CONTAINER Orscamera
{
	NAME Orscamera;
	INCLUDE Obase;

	GROUP ID_OBJECTPROPERTIES
	{
		SEPARATOR RSCAMERAOBJECT_SEPARATOR_PROJECTION { }
		LONG RSCAMERAOBJECT_PROJECTION
		{
			ANIM OFF;
			CYCLE
			{
				RSCAMERAOBJECT_PROJECTION_PERSPECTIVE;
				-1;
				RSCAMERAOBJECT_PROJECTION_FISHEYE;
				RSCAMERAOBJECT_PROJECTION_SPHERICAL;
				RSCAMERAOBJECT_PROJECTION_CYLINDRICAL;
				RSCAMERAOBJECT_PROJECTION_STEREO_SPHERICAL;
				-1;
				RSCAMERAOBJECT_PROJECTION_ORTHOGRAPHIC;
				RSCAMERAOBJECT_PROJECTION_LEFT;
				RSCAMERAOBJECT_PROJECTION_RIGHT;
				RSCAMERAOBJECT_PROJECTION_FRONT;
				RSCAMERAOBJECT_PROJECTION_BACK;
				RSCAMERAOBJECT_PROJECTION_TOP;
				RSCAMERAOBJECT_PROJECTION_BOTTOM;
				-1;
				RSCAMERAOBJECT_PROJECTION_ISOMETRIC;
				RSCAMERAOBJECT_PROJECTION_DIMETRIC;
			}
		}

		LONG RSCAMERAOBJECT_STEREO_SPHERICAL_MODE
		{
			ANIM OFF;
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_STEREO_SPHERICAL_MODE_SIDE_BY_SIDE;
				RSCAMERAOBJECT_STEREO_SPHERICAL_MODE_TOP_TO_BOTTOM;
				RSCAMERAOBJECT_STEREO_SPHERICAL_MODE_LEFT;
				RSCAMERAOBJECT_STEREO_SPHERICAL_MODE_RIGHT;
			}
		}
		BOOL RSCAMERAOBJECT_STEREO_SPHERICAL_FOCUS 					{ }
		REAL RSCAMERAOBJECT_STEREO_SPHERICAL_SEPARATION				{ MIN 0; MAXSLIDER 100; STEP 1; CUSTOMGUI REALSLIDER; }
		VECTOR RSCAMERAOBJECT_STEREO_SPHERICAL_ANGLE_OF_VIEW 		{ MIN 1; STEP 0.1; UNIT DEGREE; VECTOR_NO_Z_COMPONENT; }
		REAL RSCAMERAOBJECT_FISHEYE_ANGLE_OF_VIEW 					{ MIN 1; MAXSLIDER 180; MAX 360; CUSTOMGUI REALSLIDER; UNIT DEGREE; }
		VECTOR RSCAMERAOBJECT_FISHEYE_SCALE							{ MIN 0; STEP 0.01; VECTOR_NO_Z_COMPONENT; }
		BOOL RSCAMERAOBJECT_CYLINDRICAL_ORTHOGRAPHIC				{ }
		REAL RSCAMERAOBJECT_CYLINDRICAL_ANGLE_OF_VIEW_X 			{ MIN 0; MAX 360; CUSTOMGUI REALSLIDER; UNIT DEGREE; }
		REAL RSCAMERAOBJECT_CYLINDRICAL_ANGLE_OF_VIEW_Y 			{ MIN 0; MAX 180; CUSTOMGUI REALSLIDER; UNIT DEGREE; }
		REAL RSCAMERAOBJECT_CYLINDRICAL_HEIGHT 						{ MIN 0; MAXSLIDER 500; CUSTOMGUI REALSLIDER; }
		REAL RSCAMERAOBJECT_FOCAL_LENGTH 							{ MIN 1; MAX 10000; MINSLIDER 12; MAXSLIDER 200; STEP 0.1; CUSTOMGUI REALSLIDER; }
		// REAL RSCAMERAOBJECT_FOV_HORIZONTAL                           { MIN 0.2; MAX 174.0; UNIT DEGREE; }
		// REAL RSCAMERAOBJECT_FOV_VERTICAL                             { MIN 0.2; MAX 174.0; UNIT DEGREE; }
		VECTOR RSCAMERAOBJECT_FOV                                   { UNIT DEGREE; MIN 0.2; MAX 174.0; VECTOR_NO_Z_COMPONENT; }
		VECTOR RSCAMERAOBJECT_SENSOR_SHIFT                          { UNIT PERCENT; STEP 1; MINSLIDER -100; MAXSLIDER 100; VECTOR_NO_Z_COMPONENT; }
		REAL RSCAMERAOBJECT_ORTHOGRAPHIC_ZOOM_VIRTUAL               { CUSTOMGUI REALSLIDER; MIN 0.001; MAX 10240; MAXSLIDER 10; STEP 0.1; }

		SEPARATOR RSCAMERAOBJECT_SEPARATOR_GENERAL { }

		LONG RSCAMERAOBJECT_SENSOR_SIZE_PRESET
		{
			ANIM OFF;
			CYCLE
			{
			}
		}
		VECTOR RSCAMERAOBJECT_SENSOR_SIZE							{ MIN 1; MAX 2000; STEP 0.1; VECTOR_NO_Z_COMPONENT; }
		REAL RSCAMERAOBJECT_SENSOR_SIZE_FLOAT						{ MIN 1; MAX 2000; STEP 0.1; }
		BOOL RSCAMERAOBJECT_SENSOR_SIZE_LOCK_RATIO				    { }
		LONG RSCAMERAOBJECT_SENSOR_SIZE_FIT_MODE
		{
			ANIM OFF;
			CYCLE
			{
				RSCAMERAOBJECT_SENSOR_SIZE_FIT_MODE_CROP;
				RSCAMERAOBJECT_SENSOR_SIZE_FIT_MODE_HORIZONTAL;
				RSCAMERAOBJECT_SENSOR_SIZE_FIT_MODE_VERTICAL;
				RSCAMERAOBJECT_SENSOR_SIZE_FIT_MODE_FIT;
				RSCAMERAOBJECT_SENSOR_SIZE_FIT_MODE_SQUARE;
			}
		}

		SEPARATOR RSCAMERAOBJECT_SEPARATOR_CLIPPING { }
		BOOL RSCAMERAOBJECT_NEAR_CLIPPING_ENABLE 					{ }
		REAL RSCAMERAOBJECT_NEAR_CLIPPING 							{ UNIT METER; MIN 0.0; }
		BOOL RSCAMERAOBJECT_FAR_CLIPPING_ENABLE 					{ }
		REAL RSCAMERAOBJECT_FAR_CLIPPING 							{ UNIT METER; MIN 0.0; }
	}

	GROUP RSCAMERAOBJECT_GROUP_OPTICAL
	{
		LONG RSCAMERAOBJECT_EXPOSURE_TYPE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_EXPOSURE_TYPE_EV_ONLY;
				RSCAMERAOBJECT_EXPOSURE_TYPE_FILMIC;
			}
		}

		SEPARATOR RSCAMERAOBJECT_SEPARATOR_EXPOSURE { }
		REAL RSCAMERAOBJECT_EXPOSURE 								{ MIN -100; MAX 100; MINSLIDER -10; MAXSLIDER 10; STEP 0.1; CUSTOMGUI REALSLIDER; }
		REAL RSCAMERAOBJECT_ISO										{ MIN 0; CUSTOMGUI REALSLIDER; MINSLIDER 10.0; MAXSLIDER 3200; STEP 100.0; }
		COLOR RSCAMERAOBJECT_WHITE_POINT						    { }
		REAL RSCAMERAOBJECT_VIGNETTING 								{ MIN 0; MAX 10000; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 25; }

		SEPARATOR RSCAMERAOBJECT_SEPARATOR_DEPTH_OF_FIELD { }
		GROUP
		{
			COLUMNS 2;
			REAL RSCAMERAOBJECT_FOCUS_DISTANCE						{ UNIT METER; MINEX; MIN 0.0; }
			BITMAPBUTTON RSCAMERAOBJECT_TARGETDISTANCE_PICK			{ }
		}
		LINK RSCAMERAOBJECT_TARGETOBJECT 						{ ACCEPT { Obase; }; }
		REAL RSCAMERAOBJECT_FOCUS_OFFSET 						{ UNIT METER; }

		SEPARATOR													{ LINE; }
		REAL RSCAMERAOBJECT_FNUMBER_VALUE						    { MIN 0.01; MAX 256.0; STEP 0.1; }
		BOOL RSCAMERAOBJECT_BOKEH_ENABLED                           { PARENTCOLLAPSE; }
		LONG RSCAMERAOBJECT_APERTURE_SHAPE
		{
			DEFAULT 1;
			PARENTCOLLAPSE RSCAMERAOBJECT_BOKEH_ENABLED;
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_APERTURE_SHAPE_CIRCULAR;
				RSCAMERAOBJECT_APERTURE_SHAPE_BLADED;
				RSCAMERAOBJECT_APERTURE_SHAPE_IMAGE;
			}
		}
		REAL RSCAMERAOBJECT_APERTURE_ASPECT							{ PARENTCOLLAPSE RSCAMERAOBJECT_BOKEH_ENABLED; MIN 0.01; MAX 4.0; STEP 0.01; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 4.0; }
		REAL RSCAMERAOBJECT_APERTURE_SPHERICAL_ABBERATION			{ PARENTCOLLAPSE RSCAMERAOBJECT_BOKEH_ENABLED; MIN 0.0; STEP 0.01; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100; }
		LONG RSCAMERAOBJECT_APERTURE_BLADES 						{ PARENTCOLLAPSE RSCAMERAOBJECT_BOKEH_ENABLED; MIN 3; MAX 64; CUSTOMGUI LONGSLIDER; }
		REAL RSCAMERAOBJECT_APERTURE_ANGLE							{ PARENTCOLLAPSE RSCAMERAOBJECT_BOKEH_ENABLED; MIN 0.0; MAX 3600.0; UNIT DEGREE; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 360; }
		RSFILE RSCAMERAOBJECT_APERTURE_IMAGE	    				{ PARENTCOLLAPSE RSCAMERAOBJECT_BOKEH_ENABLED; COLORSPACE 0; }
		LONG RSCAMERAOBJECT_APERTURE_BOKEH_NORMALIZATION
		{
			DEFAULT 1;
			PARENTCOLLAPSE RSCAMERAOBJECT_BOKEH_ENABLED;
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_APERTURE_BOKEH_NORMALIZATION_OFF;
				RSCAMERAOBJECT_APERTURE_BOKEH_NORMALIZATION_WHITE_COLOR_SUM;
				RSCAMERAOBJECT_APERTURE_BOKEH_NORMALIZATION_UNIT_INTENSITY;
			}
		}

		SEPARATOR RSCAMERAOBJECT_SEPARATOR_MOTION_BLUR { }
		LONG RSCAMERAOBJECT_SHUTTER_TYPE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_SHUTTER_TYPE_STILL;
				RSCAMERAOBJECT_SHUTTER_TYPE_MOVIE;
			}
		}
		REAL RSCAMERAOBJECT_SHUTTER_TIME_RATIO              { MIN 0.02; MAX 8000.0; STEP 0.1; }
		REAL RSCAMERAOBJECT_SHUTTER_ANGLE 					{ MIN 1.0; STEP 1.0; UNIT DEGREE; }
		LONG RSCAMERAOBJECT_MOTION_BLUR_MODE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_SWITCH_MODE_OFF;
				RSCAMERAOBJECT_SWITCH_MODE_GLOBAL;
				RSCAMERAOBJECT_SWITCH_MODE_ON;
			}
		}
		BOOL RSCAMERAOBJECT_SELF_BLUR_ENABLED				{ }
		REAL RSCAMERAOBJECT_SHUTTER_OFFSET_FRAMES           { STEP 0.01;}
		REAL RSCAMERAOBJECT_SHUTTER_OFFSET 					{ STEP 1.0; UNIT DEGREE; }
		REAL RSCAMERAOBJECT_SHUTTER_EFFICIENCY 				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100; }

		SEPARATOR RSCAMERAOBJECT_SEPARATOR_DISTORTION { }
		BOOL RSCAMERAOBJECT_LENS_DISTORTION_ENABLED         { }            // RSCAMERAOBJECT_LENS_DISTORTION_MODE
		RSFILE RSCAMERAOBJECT_LENS_DISTORTION_IMAGE          { COLORSPACE 0; }
	}

	GROUP RSCAMERAOBJECT_GROUP_COLOR
	{
		GROUP RSCAMERAOBJECT_GROUP_TONE_MAPPING
		{
			DEFAULT 1;
			BOOL RSCAMERAOBJECT_TONE_MAPPING_ENABLED 					{ }
			REAL RSCAMERAOBJECT_TONE_MAPPING_HIGHLIGHTS 				{ MIN 0; MAX 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			BOOL RSCAMERAOBJECT_TONE_MAPPING_DESATURATE_HIGHLIGHTS 		{ }
			REAL RSCAMERAOBJECT_TONE_MAPPING_BLACKS 					{ MIN 0; MAX 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_TONE_MAPPING_BLACKS_THRESHOLD			{ MIN 0; MAX 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_TONE_MAPPING_SATURATION 				{ MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		}

		GROUP RSCAMERAOBJECT_GROUP_LUT
		{
			DEFAULT 1;
			LONG RSCAMERAOBJECT_LUT_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RSCAMERAOBJECT_SWITCH_MODE_OFF;
					RSCAMERAOBJECT_SWITCH_MODE_GLOBAL;
					RSCAMERAOBJECT_SWITCH_MODE_ON;
				}
			}
			FILENAME RSCAMERAOBJECT_LUT_FILENAME { ANIM OFF; }
			LONG RSCAMERAOBJECT_LUT_LIST
			{
				ANIM OFF;
				CYCLE
				{
				}
			}
			REAL RSCAMERAOBJECT_LUT_INTENSITY 				{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; PARENTCOLLAPSE; DEFAULT 1; }
			BOOL RSCAMERAOBJECT_LUT_LOG_SPACE 				{ PARENTCOLLAPSE RSCAMERAOBJECT_LUT_INTENSITY; }
			BOOL RSCAMERAOBJECT_LUT_COLOR_MANAGEMENT 		{ PARENTCOLLAPSE RSCAMERAOBJECT_LUT_INTENSITY; }
		}

		GROUP RSCAMERAOBJECT_GROUP_COLOR_CONTROLS
		{
			DEFAULT 1;
			LONG RSCAMERAOBJECT_COLOR_CONTROLS_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RSCAMERAOBJECT_SWITCH_MODE_OFF;
					RSCAMERAOBJECT_SWITCH_MODE_GLOBAL;
					RSCAMERAOBJECT_SWITCH_MODE_ON;
				}
			}

			REAL RSCAMERAOBJECT_COLOR_CONTROLS_CONTRAST 			{ MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			RSPFXCURVE RSCAMERAOBJECT_COLOR_CONTROLS_CURVE_RGB 		{ COLOR 0.9 0.9 0.9; }
			RSPFXCURVE RSCAMERAOBJECT_COLOR_CONTROLS_CURVE_RED 		{ COLOR 0.9 0.0 0.0; }
			RSPFXCURVE RSCAMERAOBJECT_COLOR_CONTROLS_CURVE_GREEN 	{ COLOR 0.0 0.9 0.0; }
			RSPFXCURVE RSCAMERAOBJECT_COLOR_CONTROLS_CURVE_BLUE 	{ COLOR 0.0 0.0 0.9; }
		}
	}

	GROUP RSCAMERAOBJECT_GROUP_LENS_EFFECTS
	{
		GROUP RSCAMERAOBJECT_GROUP_BLOOM
		{
			DEFAULT 1;
			LONG RSCAMERAOBJECT_BLOOM_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RSCAMERAOBJECT_SWITCH_MODE_OFF;
					RSCAMERAOBJECT_SWITCH_MODE_GLOBAL;
					RSCAMERAOBJECT_SWITCH_MODE_ON;
				}
			}
			REAL RSCAMERAOBJECT_BLOOM_INTENSITY 		{ MIN 0; MAX 400; CUSTOMGUI REALSLIDER; UNIT PERCENT; MAXSLIDER 100; }
			REAL RSCAMERAOBJECT_BLOOM_THRESHOLD 		{ MIN 0; MAX 50; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_BLOOM_SOFTNESS 			{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			BOOL RSCAMERAOBJECT_BLOOM_TINT 				{ PARENTCOLLAPSE; DEFAULT 1; }
			COLOR RSCAMERAOBJECT_BLOOM_TINT_1 		{ PARENTCOLLAPSE RSCAMERAOBJECT_BLOOM_TINT; }
			COLOR RSCAMERAOBJECT_BLOOM_TINT_2 		{ PARENTCOLLAPSE RSCAMERAOBJECT_BLOOM_TINT; }
			COLOR RSCAMERAOBJECT_BLOOM_TINT_3 		{ PARENTCOLLAPSE RSCAMERAOBJECT_BLOOM_TINT; }
			COLOR RSCAMERAOBJECT_BLOOM_TINT_4 		{ PARENTCOLLAPSE RSCAMERAOBJECT_BLOOM_TINT; }
			COLOR RSCAMERAOBJECT_BLOOM_TINT_5 		{ PARENTCOLLAPSE RSCAMERAOBJECT_BLOOM_TINT; }
		}

		GROUP RSCAMERAOBJECT_GROUP_FLARE
		{
			DEFAULT 1;
			LONG RSCAMERAOBJECT_FLARE_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RSCAMERAOBJECT_SWITCH_MODE_OFF;
					RSCAMERAOBJECT_SWITCH_MODE_GLOBAL;
					RSCAMERAOBJECT_SWITCH_MODE_ON;
				}
			}
			REAL RSCAMERAOBJECT_FLARE_INTENSITY 		{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			REAL RSCAMERAOBJECT_FLARE_THRESHOLD 		{ MIN 0; MAX 50; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_FLARE_SOFTNESS 			{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			REAL RSCAMERAOBJECT_FLARE_CHROMATIC 		{ MIN 0; MAX 10; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_FLARE_SIZE 				{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			REAL RSCAMERAOBJECT_FLARE_HALO				{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			BOOL RSCAMERAOBJECT_FLARE_TINT 				{ PARENTCOLLAPSE; DEFAULT 1; }
			COLOR RSCAMERAOBJECT_FLARE_TINT_1 			{ PARENTCOLLAPSE RSCAMERAOBJECT_FLARE_TINT; }
			COLOR RSCAMERAOBJECT_FLARE_TINT_2 			{ PARENTCOLLAPSE RSCAMERAOBJECT_FLARE_TINT; }
			COLOR RSCAMERAOBJECT_FLARE_TINT_3 			{ PARENTCOLLAPSE RSCAMERAOBJECT_FLARE_TINT; }
			COLOR RSCAMERAOBJECT_FLARE_TINT_4 			{ PARENTCOLLAPSE RSCAMERAOBJECT_FLARE_TINT; }
			COLOR RSCAMERAOBJECT_FLARE_TINT_5 			{ PARENTCOLLAPSE RSCAMERAOBJECT_FLARE_TINT; }
			COLOR RSCAMERAOBJECT_FLARE_TINT_6 			{ PARENTCOLLAPSE RSCAMERAOBJECT_FLARE_TINT; }
		}

		GROUP RSCAMERAOBJECT_GROUP_STREAK
		{
			DEFAULT 1;
			LONG RSCAMERAOBJECT_STREAK_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RSCAMERAOBJECT_SWITCH_MODE_OFF;
					RSCAMERAOBJECT_SWITCH_MODE_GLOBAL;
					RSCAMERAOBJECT_SWITCH_MODE_ON;
				}
			}
			REAL RSCAMERAOBJECT_STREAK_INTENSITY 		{ MIN 0; MAX 400; CUSTOMGUI REALSLIDER; UNIT PERCENT; MAXSLIDER 100; }
			REAL RSCAMERAOBJECT_STREAK_THRESHOLD 		{ MIN 0; MAX 10000; MAXSLIDER 100; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_STREAK_TAIL				{ MIN 0; MAX 1; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_STREAK_SOFTNESS 		{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			REAL RSCAMERAOBJECT_STREAK_NUMBER 			{ MIN 1; MAX 8; CUSTOMGUI REALSLIDER; }
			REAL RSCAMERAOBJECT_STREAK_ANGLE			{ MIN 0; MAX 360; STEP 0.1; CUSTOMGUI REALSLIDER; UNIT DEGREE; }
		}
	}

	GROUP RSCAMERAOBJECT_GROUP_BACKGROUND
	{
		LONG RSCAMERAOBJECT_BACKGROUND_MODE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_SWITCH_MODE_OFF;
				RSCAMERAOBJECT_SWITCH_MODE_GLOBAL;
				RSCAMERAOBJECT_SWITCH_MODE_ON;
			}
		}
		LONG RSCAMERAOBJECT_BACKGROUND_TYPE
		{
			CYCLE
			{
				RSCAMERAOBJECT_BACKGROUND_TYPE_RENDER;
				RSCAMERAOBJECT_BACKGROUND_TYPE_COMPOSITE_PRE;
				RSCAMERAOBJECT_BACKGROUND_TYPE_COMPOSITE_POST;
			}
		}
		BOOL RSCAMERAOBJECT_BACKGROUND_AFFECTED_BY_BENT_RAYS			{ }
		COLORA RSCAMERAOBJECT_BACKGROUND_COLOR							{ }
		
		RSFILE RSCAMERAOBJECT_BACKGROUND_IMAGE						 	{ }
		LONG RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE
		{
			ANIM OFF;
			CYCLE
			{
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_DEFAULT;
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_NO_SCALE;
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_64;
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_128; 
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_256; 
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_512; 
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_1024;
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_2048;
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_4096;
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_8192;
				RSCAMERAOBJECT_BACKGROUND_TEXTURE_PREVIEWSIZE_16384;
			}
		}
		BOOL RSCAMERAOBJECT_BACKGROUND_IMAGE_ALPHA						{ }
		LONG RSCAMERAOBJECT_BACKGROUND_FRAME
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				RSCAMERAOBJECT_BACKGROUND_FRAME_STRETCH;
				RSCAMERAOBJECT_BACKGROUND_FRAME_CROP;
				RSCAMERAOBJECT_BACKGROUND_FRAME_FIT;
			}
		}
		REAL RSCAMERAOBJECT_BACKGROUND_OFFSET_X 					{ MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		REAL RSCAMERAOBJECT_BACKGROUND_OFFSET_Y 					{ MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }

		SEPARATOR													{ LINE; }
		REAL RSCAMERAOBJECT_BACKGROUND_GAMMA 						{ MIN 0; MAXSLIDER 2.2; STEP 0.1; CUSTOMGUI REALSLIDER; }
		REAL RSCAMERAOBJECT_BACKGROUND_EXPOSURE 					{ MINSLIDER -10; MAXSLIDER 10; STEP 0.1; CUSTOMGUI REALSLIDER; }
		REAL RSCAMERAOBJECT_BACKGROUND_HUE 							{ MIN 0; MAXSLIDER 360; CUSTOMGUI REALSLIDER; UNIT DEGREE; }
		REAL RSCAMERAOBJECT_BACKGROUND_SATURATION 					{ MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		BOOL RSCAMERAOBJECT_BACKGROUND_EXPOSURE_COMPENSATION		{ }
	}

	// Layout Helper Group
	GROUP RSCAMERAOBJECT_GROUP_DISPLAY
	{
		GROUP RSCAMERAOBJECT_GROUP_FRUSTUM
		{
			DEFAULT 1;
			LONG RSCAMERAOBJECT_DISPLAY_MODE
			{
				CYCLE
				{
					RSCAMERAOBJECT_DISPLAY_MODE_OFF;
					RSCAMERAOBJECT_DISPLAY_MODE_ON_SELECTION;
					RSCAMERAOBJECT_DISPLAY_MODE_ON;
				}
			}
			BOOL RSCAMERAOBJECT_DISPLAY_FOCUS_PLANE									{ }
			COLOR RSCAMERAOBJECT_DISPLAY_FOCUS_PLANE_COLOR							{ }
			REAL RSCAMERAOBJECT_DISPLAY_FOCUS_PLANE_OPACITY							{ MIN 0.0; MAX 1.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			BOOL RSCAMERAOBJECT_DISPLAY_SHOW_NEAR_CLIP_PLANE						{ }
			BOOL RSCAMERAOBJECT_DISPLAY_SHOW_FAR_CLIP_PLANE							{ }
		}

		GROUP RSCAMERAOBJECT_GROUP_SAFE_AREAS
		{
			DEFAULT 1;
			BOOL RSCAMERAOBJECT_DISPLAY_RESOLUTION									{ PARENTCOLLAPSE; DEFAULT 1; }
				BOOL RSCAMERAOBJECT_DISPLAY_RESOLUTION_MASKED						{ PARENTCOLLAPSE RSCAMERAOBJECT_DISPLAY_RESOLUTION; }
				REAL RSCAMERAOBJECT_DISPLAY_RESOLUTION_OPACITY						{ MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; PARENTCOLLAPSE RSCAMERAOBJECT_DISPLAY_RESOLUTION; }
				COLOR RSCAMERAOBJECT_DISPLAY_RESOLUTION_COLOR						{ PARENTCOLLAPSE RSCAMERAOBJECT_DISPLAY_RESOLUTION; }
			BOOL RSCAMERAOBJECT_DISPLAY_SENSOR										{ }

			SEPARATOR																{ LINE; }
			BOOL RSCAMERAOBJECT_DISPLAY_SAFE_ACTION									{ }
			REAL RSCAMERAOBJECT_DISPLAY_SAFE_ACTION_SIZE							{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			BOOL RSCAMERAOBJECT_DISPLAY_SAFE_TITLE									{ }
			REAL RSCAMERAOBJECT_DISPLAY_SAFE_TITLE_SIZE								{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }

			SEPARATOR																{ LINE; }
			REAL RSCAMERAOBJECT_DISPLAY_EDITOR_OVERSCAN								{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		}

		GROUP RSCAMERAOBJECT_GROUP_COMPOSITION
		{
			DEFAULT 1;
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_OVERLAYS							{  }
			COLOR	RSCAMERAOBJECT_LAYOUTHELP_DRAW_COLOR							{  }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GRID_ENABLE							{ PARENTCOLLAPSE; }
				LONG	RSCAMERAOBJECT_LAYOUTHELP_DRAW_GRID_CELLS					{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GRID_ENABLE; MIN 2; MAX 20; CUSTOMGUI LONGSLIDER; }

			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_ENABLE						{ PARENTCOLLAPSE; }
			LONG RSCAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_MODE
			{
				PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_ENABLE;
				CYCLE
				{
					RSCAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_LEFT;
					RSCAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_RIGHT;
					RSCAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_BOTH;
				}
			}
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_ENABLE						{ PARENTCOLLAPSE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_LONG						{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_MIRROR					{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_FLIP						{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_ENABLE; }

			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_ENABLE					{ PARENTCOLLAPSE; }
			LONG RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_I					{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_ENABLE; MIN 1; MAX 5; CUSTOMGUI LONGSLIDER; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_TOP				{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_RIGHT				{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_BOTTOM				{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_LEFT				{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ENABLE						{ PARENTCOLLAPSE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_MIRROR_H				{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_MIRROR_V 				{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ENABLE; }
			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_FLIP					{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ENABLE; }
			LONG RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_V				{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ENABLE;CYCLE { RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_TOP; RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_CENTER; RSCAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_BOTTOM; } }

			BOOL RSCAMERAOBJECT_LAYOUTHELP_DRAW_CROSSHAIR_ENABLE						{ PARENTCOLLAPSE; }
			REAL RSCAMERAOBJECT_LAYOUTHELP_DRAW_CROSSHAIR_SCALE						{ PARENTCOLLAPSE RSCAMERAOBJECT_LAYOUTHELP_DRAW_CROSSHAIR_ENABLE; UNIT PERCENT; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 200.0; CUSTOMGUI REALSLIDER; }
		}
	}
}
