CONTAINER ColliderTag
{
	NAME Trbd;
	INCLUDE Tbase;

	GROUP ID_TAGPROPERTIES
	{
		GROUP
		{
			BOOL COLLIDER_USE { ANIM ON; }

			LONG CONVEX_COLLIDER
			{
				ANIM OFF;
				CYCLE
				{
					CONVEX_COLLIDER_TRIANGLE_MESH;
					CONVEX_COLLIDER_CONVEX_HULLS;
					CONVEX_COLLIDER_SPHERE;
					CONVEX_COLLIDER_BOX;
				}
			}
			REAL CONVEX_COLLIDER_CONVEXDECOMPOSITION_ACCURACY { ANIM OFF; MIN 0; MINSLIDER 0.0; MAXSLIDER 10; STEP 0.1; CUSTOMGUI REALSLIDER; }
			REAL COLLIDER_FRICTION { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL COLLIDER_BOUNCE { MIN 0.0; MAX 10.0; CUSTOMGUI REALSLIDER; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; }
			REAL COLLIDER_STICKINESS { MIN 0.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
			LONG CLOTH_PBD_COLLIDER_SIDE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					CLOTH_PBD_COLLIDER_SIDE_NORMALS;
					CLOTH_PBD_COLLIDER_SIDE_INVNORMALS;
					CLOTH_PBD_COLLIDER_SIDE_BOTH;
				}
			}
		}

		GROUP COLLIDER_LIQUID_COLLISION_GROUP
		{
			DEFAULT 1;
			LONG COLLIDER_LIQUID_COLLISION_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					COLLIDER_LIQUID_COLLISION_MODE_SURFACE;
					COLLIDER_LIQUID_COLLISION_MODE_VOLUME;
					COLLIDER_LIQUID_COLLISION_MODE_OFF;
				};
			}
			LONG COLLIDER_LIQUID_COLLISION_FROM 
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					COLLIDER_LIQUID_COLLISION_FROM_OUTSIDE;
					COLLIDER_LIQUID_COLLISION_FROM_INSIDE;
					COLLIDER_LIQUID_COLLISION_FROM_BOTH;
				}
			}
			
			LONG COLLIDER_SDF_VOXEL_SIZE_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					COLLIDER_SDF_VOXEL_SIZE_MODE_RELATIVE;
					COLLIDER_SDF_VOXEL_SIZE_MODE_ABSOLUTE;
				};
			}

			REAL COLLIDER_SDF_VOXEL_SIZE_ABSOLUTE { UNIT METER; MIN 0.0; STEP 0.1; PARENTCOLLAPSE; }
			LONG COLLIDER_SDF_VOXEL_BAND_INTERIOR_ABSOLUTE { PARENTCOLLAPSE COLLIDER_SDF_VOXEL_SIZE_ABSOLUTE; MIN 0; STEP 1; }
			LONG COLLIDER_SDF_VOXEL_BAND_EXTERIOR_ABSOLUTE { PARENTCOLLAPSE COLLIDER_SDF_VOXEL_SIZE_ABSOLUTE; MIN 0; STEP 1; }
			
			REAL COLLIDER_SDF_VOXEL_SIZE_RELATIVE { UNIT PERCENT; MIN 0.0; MINSLIDER 0.2; MAXSLIDER 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }
			LONG COLLIDER_SDF_VOXEL_BAND_INTERIOR_RELATIVE { PARENTCOLLAPSE COLLIDER_SDF_VOXEL_SIZE_RELATIVE; MIN 0; STEP 1; }
			LONG COLLIDER_SDF_VOXEL_BAND_EXTERIOR_RELATIVE { PARENTCOLLAPSE COLLIDER_SDF_VOXEL_SIZE_RELATIVE; MIN 0; STEP 1; }
		}

		GROUP COLLIDER_PREPROCESS_GROUP
		{
			DEFAULT 1;
			LONG COLLIDER_PREPROCESS_IF_OPEN
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					COLLIDER_PREPROCESS_IF_OPEN_OFF;
					COLLIDER_PREPROCESS_IF_OPEN_THICKEN;
					COLLIDER_PREPROCESS_IF_OPEN_CLOSE;
				}
			}
			REAL COLLIDER_THICKNESS { PARENTCOLLAPSE; UNIT METER; MIN 0.0; STEP 0.1; }
			REAL COLLIDER_THICKNESS_POSITION { PARENTCOLLAPSE COLLIDER_THICKNESS; UNIT PERCENT; MIN -100.0; MINSLIDER -100.0; MAXSLIDER 100.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }
			BOOL COLLIDER_PREPROCESS_RESTRICT_TO_LIQUIDS { ANIM ON; }
		}

		GROUP COLLIDER_TEXT_EXCL
		{
			GROUP 
			{
				COLUMNS 3;

				BUTTON COLLIDER_SET_EXCL {}
				BUTTON COLLIDER_CLEAR_EXCL {}
				BUTTON COLLIDER_SHOW_EXCL {}
			}
			BOOL COLLIDER_DRAW_EXCL {}
		}

		STATICTEXT COLLIDER_INFO_STRING0	{ ANIM OFF; }
		STATICTEXT COLLIDER_INFO_STRING1	{ ANIM OFF; }
	}
}
