CONTAINER ClothTag
{
	NAME Tsbd;
	INCLUDE Tbase;

	GROUP Obaselist
	{
		PRIORITY CLOTH_SIMULATION_PRIORITY { ANIM OFF; NOCAMERA; }
		BOOL CLOTH_USE { }
		BOOL CLOTH_LEGACYON { ANIM OFF; }
	}

	GROUP ID_TAGPROPERTIES
	{
		GROUP CLOTH_LEGACY_SETTINGS_GROUP
		{
			BOOL CLOTH_AUTOTIME { ANIM OFF; }
			BASETIME CLOTH_START { ANIM OFF; }
			BASETIME CLOTH_STOP  { ANIM OFF; }
			SEPARATOR { LINE; }

			LONG CLOTH_ITERATIONS {MIN 1; } STATICTEXT { JOINENDSCALE; }
			REAL CLOTH_STRUCT_F   {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; } LINK CLOTH_STRUCT_F_MAP  { ACCEPT { 5682; } }
			REAL CLOTH_FLEXION_F  {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }   LINK CLOTH_FLEXION_F_MAP { ACCEPT { 5682; } }
			REAL CLOTH_RUBBER_F   {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }   LINK CLOTH_RUBBER_F_MAP  { ACCEPT { 5682; } }
			SEPARATOR { LINE; } STATICTEXT { JOINENDSCALE; }
			REAL CLOTH_BOUNCE { UNIT PERCENT; MIN 0.0; }            LINK CLOTH_BOUNCE_MAP    { ACCEPT { 5682; } }
			REAL CLOTH_STICKI { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; } LINK CLOTH_STICKI_MAP    { ACCEPT { 5682; } }
			SEPARATOR { LINE; } STATICTEXT { JOINENDSCALE; }
			REAL CLOTH_MASS      { MIN 0.1; STEP 0.1; }    LINK CLOTH_MASS_MAP     { ACCEPT { 5682; } }
			REAL CLOTH_SHRINK_F  {UNIT PERCENT; MIN 1.0; } LINK CLOTH_SHRINK_F_MAP { ACCEPT { 5682; } }
			REAL CLOTH_TEAR_F    {UNIT PERCENT; MIN 1.0; } LINK CLOTH_TEAR_F_MAP   { ACCEPT { 5682; } }
			BOOL CLOTH_TEAR      { } STATICTEXT { JOINENDSCALE; }
			DEFAULT 1;
		}
	}
	
	// START OF PBD CLOTH INTEGRATION
	GROUP CLOTH_PBD_SETTINGS_GROUP
	{
		DEFAULT 1;
		BOOL CLOTH_PBD_CLOTH { ANIM OFF; }
		REAL CLOTH_PBD_BENDINESS { MIN 0.0; STEP 0.1; PARENTCOLLAPSE;} 
		STRING CLOTH_PBD_BENDINESS_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_BENDINESS;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}
		
		REAL CLOTH_PBD_STRETCHINESS { MIN 0.0; STEP 0.1; PARENTCOLLAPSE;} 
		STRING CLOTH_PBD_STRETCHINESS_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_STRETCHINESS;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}
		
		REAL CLOTH_PBD_BOUNCINESS { MIN 0.0; STEP 0.05; PARENTCOLLAPSE;} 
		STRING CLOTH_PBD_BOUNCINESS_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_BOUNCINESS;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_FRICTION { MIN 0.0; STEP 0.1; PARENTCOLLAPSE;} 
		STRING CLOTH_PBD_FRICTION_WEIGHTS 
		{ 
			PARENTCOLLAPSE CLOTH_PBD_FRICTION;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_STICKINESS { MIN 0.0; STEP 0.05; PARENTCOLLAPSE;} 
		STRING CLOTH_PBD_STICKINESS_WEIGHTS 
		{ 
			PARENTCOLLAPSE CLOTH_PBD_STICKINESS; 
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_THICKNESS { UNIT METER; MIN 0.001; STEP 0.01; PARENTCOLLAPSE;} 
		STRING CLOTH_PBD_THICKNESS_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_THICKNESS; 
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_TARGET_LENGTH { UNIT PERCENT; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 200.0; STEP 1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; } 
		STRING CLOTH_PBD_TARGET_LENGTH_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_TARGET_LENGTH;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}
		
		REAL CLOTH_PBD_TARGET_LENGTH_MIN { UNIT PERCENT; MIN 0.0; MAX 100; PARENTCOLLAPSE CLOTH_PBD_TARGET_LENGTH; }
		REAL CLOTH_PBD_MASS  { MIN 0.0001; STEP 0.1; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_MASS_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_MASS;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_MASS_MAP_MIN  { UNIT PERCENT; MIN 1.0; MAX 100; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE CLOTH_PBD_MASS; }

		LONG CLOTH_PBD_COLLISION_SIDE 
		{
			CUSTOMGUI QUICKTABRADIO;
			ANIM ON;
			CYCLE
			{
				CLOTH_PBD_COLLISION_SIDE_FRONT;
				CLOTH_PBD_COLLISION_SIDE_BACK;
				CLOTH_PBD_COLLISION_SIDE_BOTH;
			}
		}		
		LONG CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS 
		{
			CUSTOMGUI QUICKTABRADIO;
			ANIM OFF;
			CYCLE
			{
				CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS_NONE;
				CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS_SINGLE;
				CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS_DOUBLE;
			}
		}	
		
		GROUP CLOTH_PBD_PARTICLE_DAMPING_GROUP
		{
			DEFAULT 1;
			BOOL CLOTH_PBD_PARTICLE_DAMPING_OVERRIDE { }
			REAL CLOTH_PBD_PARTICLE_DAMPING  { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }
			STRING CLOTH_PBD_PARTICLE_DAMPING_WEIGHTS
			{
				PARENTCOLLAPSE CLOTH_PBD_PARTICLE_DAMPING;
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}
			REAL CLOTH_PBD_PARTICLE_DAMPING_WEIGHTS_MIN { MIN 0.0; STEP 1.0; UNIT PERCENT;  PARENTCOLLAPSE CLOTH_PBD_PARTICLE_DAMPING; }
		}

		GROUP CLOTH_PBD_TEARING_GROUP
		{
			BOOL CLOTH_PBD_TEARING { ANIM OFF; }
			REAL CLOTH_PBD_TEARPAST { MIN 100.0; STEP 1.0; PARENTCOLLAPSE; UNIT PERCENT; }
			STRING CLOTH_PBD_TEARPAST_WEIGHTS
			{
				PARENTCOLLAPSE CLOTH_PBD_TEARPAST;
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}
			REAL CLOTH_PBD_MAPMINTEARPAST { MIN 100.0; STEP 1.0; UNIT PERCENT;  PARENTCOLLAPSE CLOTH_PBD_TEARPAST; }
			REAL CLOTH_PBD_TEAR_GUIDE_CONE_ANGLE { UNIT DEGREE; MIN 0; MAX 90; STEP 1; DEFAULT 45; }
		}
	}
	
	GROUP CLOTH_PBD_BALLOON_GROUP
	{
		BOOL CLOTH_PBD_BALLOON { }
		REAL CLOTH_PBD_OVERPRESSURE { MIN 0.01; STEP 0.1; }
		REAL CLOTH_PBD_EXPANSIONTIME { UNIT TIME; MIN 1; STEP 1; }
		STRING CLOTH_PBD_BALLOON_WEIGHTS
		{
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}
		BOOL CLOTH_PBD_BALLOON_STRETCH_INFLUENCE { }
	}

	GROUP CLOTH_PBD_ELASTICBODY_GROUP
	{
		BOOL CLOTH_PBD_ELASTICBODY { ANIM OFF; }
		LONG CLOTH_PBD_ELASTICBODY_DRAW 
		{
			ANIM OFF;
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				CLOTH_PBD_ELASTICBODY_DRAW_SELECTED;
				CLOTH_PBD_ELASTICBODY_DRAW_ALWAYS;
				CLOTH_PBD_ELASTICBODY_DRAW_NEVER;
			}
		}
		BOOL CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_DRAW_LABEL { ANIM OFF; }

		BOOL CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_ACTIVE {}
		REAL CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_INVSTIFFNESS1 { MIN 1; STEP 0.01; MINSLIDER 1; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; } 
		
		GROUP CLOTH_PBD_ELASTICBODY_CREATION_GROUP
		{
			DEFAULT 1;
			BUTTON CLOTH_PBD_ELASTICBODY_UPDATE_BUTTON { };
			BOOL CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_AUTOCREATE { ANIM OFF; }
			BOOL CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_UNIFORM_SEGMENTS { ANIM OFF; }
			LONG CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_SEGMENTS { ANIM OFF; MIN 1; STEP 1; DEFAULT 1; }
			LONG CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_XSEGMENTS { ANIM OFF; MIN 1; STEP 1; DEFAULT 1; }
			LONG CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_YSEGMENTS { ANIM OFF; MIN 1; STEP 1; DEFAULT 1; }
			LONG CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_ZSEGMENTS { ANIM OFF; MIN 1; STEP 1; DEFAULT 1; }

			BOOL CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_RANDOMIZE { ANIM OFF; }
			REAL CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_RANDOMIZE_STRENGTH { ANIM OFF; MIN 0.01; MAX 0.05; STEP 0.01; DEFAULT 0.01; }
			LONG CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_SEED { ANIM OFF; MIN 0; STEP 1; DEFAULT 123456; }
		}
	}

	GROUP CLOTH_PBD_STRUT_SOFTBODY_GROUP
	{
		BOOL CLOTH_PBD_STRUT_SOFTBODY { ANIM OFF; }
		LONG CLOTH_PBD_STRUT_DRAW 
		{
			ANIM OFF;
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				CLOTH_PBD_STRUT_DRAW_SELECTED;
				CLOTH_PBD_STRUT_DRAW_ALWAYS;
				CLOTH_PBD_STRUT_DRAW_NEVER;
			}
		}
		REAL CLOTH_PBD_STRUT_SOFTBODY_STRETCHINESS { MIN 0.0; STEP 0.1; PARENTCOLLAPSE;} 
		STRING CLOTH_PBD_STRUT_SOFTBODY_STRETCHINESS_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_STRETCHINESS;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 200.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }
		STRING CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH_MIN { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH; }
		GROUP CLOTH_PBD_STRUT_SOFTBODY_TEARING
		{
			BOOL CLOTH_PBD_STRUT_TEARING { ANIM OFF; }
			LONG CLOTH_PBD_STRUT_TEARING_DIRECTION
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					CLOTH_PBD_STRUT_TEARING_DIRECTION_ELONGATION;
					CLOTH_PBD_STRUT_TEARING_DIRECTION_COMPRESSION;
					CLOTH_PBD_STRUT_TEARING_DIRECTION_BOTH;
				}
			}
			REAL CLOTH_PBD_STRUT_TEARPAST { MIN 0.0; STEP 1.0; PARENTCOLLAPSE; UNIT PERCENT; }
			STRING CLOTH_PBD_STRUT_TEARPAST_WEIGHTS
			{
				PARENTCOLLAPSE CLOTH_PBD_STRUT_TEARPAST;
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}
			REAL CLOTH_PBD_STRUT_MAPMINTEARPAST { MIN 0.0; STEP 1.0; UNIT PERCENT; PARENTCOLLAPSE CLOTH_PBD_STRUT_TEARPAST; }
		}

		GROUP CLOTH_PBD_STRUT_SOFTBODY_CREATION_GROUP
		{
			BUTTON CLOTH_PBD_STRUT_SOFTBODY_UPDATE_BUTTON { };
			LONG CLOTH_PBD_STRUT_SOFTBODY_MAXSTRUTS { ANIM OFF; MIN 1; MAX 100; STEP 1; PARENTCOLLAPSE; }
			STRING CLOTH_PBD_STRUT_SOFTBODY_MAXSTRUTS_WEIGHTS
			{
				PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_MAXSTRUTS; ANIM OFF;
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}

			REAL CLOTH_PBD_STRUT_SOFTBODY_MINLENGTH  { UNIT METER; STEP 1; MINSLIDER 0; MAXSLIDER 500.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE; }
			STRING CLOTH_PBD_STRUT_SOFTBODY_MINLENGTH_WEIGHTS
			{ 
				PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_MINLENGTH; ANIM OFF; 
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}
			
			REAL CLOTH_PBD_STRUT_SOFTBODY_MAXLENGTH  { UNIT METER; STEP 1; MINSLIDER 0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE; }
			STRING CLOTH_PBD_STRUT_SOFTBODY_MAXLENGTH_WEIGHTS
			{ 
				PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_MAXLENGTH; ANIM OFF;
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}
			
			REAL CLOTH_PBD_STRUT_SOFTBODY_SPREAD  { UNIT DEGREE; MIN 0; MAX 180; STEP 1; DEFAULT 45; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE; }
			STRING CLOTH_PBD_STRUT_SOFTBODY_SPREAD_WEIGHTS 
			{ 
				PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_SPREAD; ANIM OFF; 
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}
			
			REAL CLOTH_PBD_STRUT_SOFTBODY_ACCEPTANCE  { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE; }
			STRING CLOTH_PBD_STRUT_SOFTBODY_ACCEPTANCE_WEIGHTS 
			{ 
				PARENTCOLLAPSE CLOTH_PBD_STRUT_SOFTBODY_ACCEPTANCE; ANIM OFF;
				ACCEPT
				{
					tvertexmap;
				}
				CUSTOMGUI STRINGLINK;
			}

			LONG CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE
			{
				CUSTOMGUI QUICKTABRADIO;
				ANIM OFF;
				CYCLE
				{
					CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE_FRONT;
					CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE_BACK;
					CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE_BOTH;
				}
			}
			LONG CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE
			{
				CUSTOMGUI QUICKTABRADIO;
				ANIM OFF;
				CYCLE
				{
					CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE_FRONT;
					CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE_BACK;
					CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE_BOTH;
				}
			}
			LONG CLOTH_PBD_STRUT_SOFTBODY_SEED { ANIM OFF; MIN 0; STEP 1; DEFAULT 123456; }
			FIELDLIST CLOTH_PBD_STRUT_SOFTBODY_POLES_DIRECTION { ANIM OFF; NEWLINE; NOVALUE; NOCOLOR; NOROTATION; }
			DEFAULT 1;
		}
	}

	GROUP CLOTH_PBD_FOLLOW_ANIMATION_GROUP
	{ 
		BOOL CLOTH_PBD_FOLLOW_ANIMATION_PINS { }
		REAL CLOTH_PBD_FOLLOW_ANIMATION_PINS_STRETCHINESS { MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;} 
		STRING CLOTH_PBD_FOLLOW_ANIMATION_PINS_STRETCHINESS_WEIGHTS
		{ 
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}
		REAL CLOTH_PBD_FOLLOW_ANIMATION_PINS_STRETCHINESS_SCALE { MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}
		SEPARATOR { LINE; }
		BOOL CLOTH_PBD_FOLLOW_ANIMATION_FORCE {  }
		REAL CLOTH_PBD_FOLLOW_ANIMATION_FORCE_STRENGTH { MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;} 
		STRING CLOTH_PBD_FOLLOW_ANIMATION_FORCE_STRENGTH_WEIGHTS
		{ 
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}
		REAL CLOTH_PBD_FOLLOW_ANIMATION_FORCE_STRENGTH_SCALE { MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER;}
		SEPARATOR { LINE; }
		BOOL CLOTH_PBD_FOLLOW_SHAPE {}
	}

	GROUP CLOTH_PBD_PLASTIC_DEFORM_GROUP
	{
		BOOL CLOTH_PBD_BEND_PLASTIC_DEFORM {}
		REAL CLOTH_PBD_BEND_PLASTIC_DEFORM_PAST { UNIT DEGREE; MIN 0; MAX 180; STEP 1; DEFAULT 45; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_BEND_PLASTIC_DEFORM_PAST_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_BEND_PLASTIC_DEFORM_PAST;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_BEND_PLASTIC_DEFORM_RATE { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_BEND_PLASTIC_DEFORM_RATE_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_BEND_PLASTIC_DEFORM_RATE;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_BEND_PLASTIC_DEFORM_HARDENING { STEP 0.1; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_BEND_PLASTIC_DEFORM_HARDENING_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_BEND_PLASTIC_DEFORM_HARDENING;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		SEPARATOR { LINE; }
		BOOL CLOTH_PBD_ELASTIC_PLASTIC_DEFORM {}
		REAL CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_PAST { MIN 100.0; STEP 1.0; PARENTCOLLAPSE; UNIT PERCENT; }
		STRING CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_PAST_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_PAST;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_RATE { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_RATE_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_RATE;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_HARDENING { STEP 0.1; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_HARDENING_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_HARDENING;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		SEPARATOR { LINE; }
		BOOL CLOTH_PBD_STRUT_DEFORM {}
		LONG CLOTH_PBD_STRUT_DEFORM_DIRECTION
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				CLOTH_PBD_STRUT_DEFORM_DIRECTION_ELONGATION;
				CLOTH_PBD_STRUT_DEFORM_DIRECTION_COMPRESSION;
				CLOTH_PBD_STRUT_DEFORM_DIRECTION_BOTH;
			}
		}
		REAL CLOTH_PBD_STRUT_DEFORM_PAST { MIN 0.0; STEP 1.0; PARENTCOLLAPSE; UNIT PERCENT; }
		STRING CLOTH_PBD_STRUT_DEFORM_PAST_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_STRUT_DEFORM_PAST;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_STRUT_DEFORM_RATE { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_STRUT_DEFORM_RATE_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_STRUT_DEFORM_RATE;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}

		REAL CLOTH_PBD_STRUT_DEFORM_HARDENING { STEP 0.1; PARENTCOLLAPSE;}
		STRING CLOTH_PBD_STRUT_DEFORM_HARDENING_WEIGHTS
		{
			PARENTCOLLAPSE CLOTH_PBD_STRUT_DEFORM_HARDENING;
			ACCEPT
			{
				tvertexmap;
			}
			CUSTOMGUI STRINGLINK;
		}
	}

	GROUP CLOTH_GROUP_FORCES
	{
		REAL CLOTH_GRAVITY { STEP 0.1; }
		REAL CLOTH_DRAG      { UNIT PERCENT; MIN 0.0; MAX 100.0; }

		SEPARATOR { LINE; }

		VECTOR CLOTH_WIND_DIR     { UNIT METER; CUSTOMGUI SUBDESCRIPTION; STEP 0.1; }
		REAL   CLOTH_WIND_F       { MIN 0.0; STEP 0.1; }
		REAL   CLOTH_WIND_TURB_F  { MIN 0.0; }
		REAL   CLOTH_WIND_TURB_S  { MIN 0.0; }
		REAL   CLOTH_WIND_DRAG    {UNIT PERCENT; MIN 0.0; MAX 100.0; }
		REAL   CLOTH_WIND_IMPACT  {UNIT PERCENT; MIN 0.0; MAX 100.0; }
		REAL   CLOTH_WIND_LIFT    {UNIT PERCENT; MIN 0.0; MAX 100.0; }
		REAL   CLOTH_WIND_SPEED   { STEP 0.1; }

		SEPARATOR { LINE; }

		BOOL CLOTH_SREP { }

		REAL CLOTH_SREP_D { UNIT METER;MIN 0.0; }
		REAL CLOTH_SREP_F { MIN 0.0; }
		REAL CLOTH_SREP_B {  }

		DEFAULT 0;
	}

	GROUP CLOTH_GROUP_DRESSING
	{
		BOOL CLOTH_DRESSMODE { ANIM OFF; }
		SEPARATOR { LINE; }

		BUTTON CLOTH_DO_RELAXING {}
		LONG CLOTH_RELAX_STEPS { MIN 1; ANIM OFF;}

		SEPARATOR {  }
			
		BUTTON CLOTH_DO_DRESSING {}
		LONG CLOTH_DRESS_STEPS { MIN 1; ANIM OFF;}
		REAL   CLOTH_SEAMS_DIST { MIN 0.0; UNIT METER; ANIM OFF;}

		SEPARATOR { LINE; }

		GROUP
		{
			COLUMNS 5;

			STATICTEXT CLOTH_TEXT_INIT { NOTEXT; }
			BUTTON CLOTH_SETINIT {}
			BUTTON CLOTH_CLEARINIT {}
			BUTTON CLOTH_SHOWINIT{}
			STATICTEXT { DUMMY; }

			STATICTEXT CLOTH_TEXT_DRESS { NOTEXT; }
			BUTTON CLOTH_SETDINIT {}
			BUTTON CLOTH_CLEARDRESS {}
			BUTTON CLOTH_SHOWDINIT {}
			STATICTEXT { DUMMY; }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }

			STATICTEXT CLOTH_TEXT_FIX { NOTEXT; }
			BUTTON CLOTH_SETMASS {}
			BUTTON CLOTH_CLEARMASS {}
			BUTTON CLOTH_SHOWMASS {}
			BOOL CLOTH_DRAWMASS{ }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }

			STATICTEXT CLOTH_TEXT_SEAM { NOTEXT; }
			BUTTON CLOTH_SETSEAMS {}
			BUTTON CLOTH_CLEARSEAM {}
			BUTTON CLOTH_SHOWSEAMS {}
			STATICTEXT { DUMMY; }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
		}
	}

	GROUP CLOTH_GROUP_EFFECTS
	{
		BOOL CLOTH_BAKE { }

		SEPARATOR { LINE; }

		GROUP
		{
			COLUMNS 2;

			BASETIME CLOTH_CACHE_START { ANIM OFF; } STATICTEXT { JOINENDSCALE; }

			BUTTON CLOTH_DO_CALCULATE {  FIT_H; }
			BUTTON CLOTH_DO_CALCULATE_ALL { FIT_H; }

			BUTTON CLOTH_DELCACHE { FIT_H; }
			BUTTON CLOTH_DELCACHE_ALL { FIT_H; }

			BUTTON CLOTH_CACHE_FRAME {  FIT_H; }
			STATICTEXT { DUMMY; SCALE_H; }

			SEPARATOR { } STATICTEXT { JOINENDSCALE; }

			BUTTON CLOTH_CACHE_LOAD {  FIT_H; }
			STATICTEXT { DUMMY; SCALE_H; }

			BUTTON CLOTH_CACHE_SAVE {  FIT_H; }
			STATICTEXT { DUMMY; SCALE_H; }

			STATICTEXT CLOTH_CACHE_INFO1 { SCALE_H; }
			STATICTEXT CLOTH_CACHE_INFO2 { SCALE_H; }
		}
	}

	INCLUDE ocache;

	GROUP CLOTH_GROUP_EXPERT
	{
		SCALE_V;

		LONG CLOTH_SUBDIV { MIN 1; MAX 100; }
		STATICTEXT { JOINEND; }

		BOOL CLOTH_SELF { }
		STATICTEXT { JOINEND; }

		BOOL CLOTH_GIA {}
		STATICTEXT { JOINEND; }

		BOOL CLOTH_POINTS {}
		REAL CLOTH_P_EPS  { MIN 0.0; UNIT METER;}

		BOOL CLOTH_EDGES {}
		REAL CLOTH_K_EPS  { MIN 0.0; UNIT METER;}

		BOOL CLOTH_POLYS {}
		REAL CLOTH_V_EPS  { MIN 0.0; UNIT METER;}

		SEPARATOR { }

	 	IN_EXCLUDE  CLOTH_INCLUDE
	 	{
	 		SCALE_V;	ACCEPT { Obase; };
	 	}

		DEFAULT 0;
	}

	GROUP CLOTH_PBD_FORCES_GROUP
	{
		REAL CLOTH_PBD_AERO_DRAG  { ANIM ON; UNIT PERCENT; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
		REAL CLOTH_PBD_AERO_LIFT  { ANIM ON; UNIT PERCENT; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
		SCALE_V;
		LONG CLOTH_PBD_FORCES_INEXMODE
		{
			ANIM OFF;
			CYCLE
			{
				CLOTH_PBD_FORCES_INEXMODE_INCLUDE;
				CLOTH_PBD_FORCES_INEXMODE_EXCLUDE;
			}
			DEFAULT CLOTH_PBD_FORCES_INEXMODE_EXCLUDE;
		}
		IN_EXCLUDE  CLOTH_PBD_FORCES_INEXCLUDE
	 	{
	 		SCALE_V;
			NUM_FLAGS 1;
			INIT_STATE 1;
			SEND_SELCHNGMSG 1;
			SMALL_MODE_SIZE 80;
			BIG_MODE_SIZE 150;
			IMAGE_01_ON 300000131;
			IMAGE_01_OFF 300000130;
			ACCEPT 
			{
				Odeflector;
				Ogravitation;
				Orotation;
				Owind;
				Ofriction;
				Oturbulence;
				Oattractor; 
				Ofieldforce;
				1018544; // Cloner object
			}
	 	}
		BOOL CLOTH_PBD_FORCES_INEX_PYRO { DEFAULT 0; }
	}
}
