#ifndef CLOTHTAG_H__
#define CLOTHTAG_H__

enum
{
	CLOTH_BELT       = 10001, // link [just for compatibilty <V9.200]
	CLOTH_MASS       = 10002, // real
	CLOTH_DRAG       = 10005, // real
	CLOTH_GRAVITY    = 10006, // real
	CLOTH_STRUCT_F   = 10009, // real
	CLOTH_FLEXION_F  = 10010, // real
	CLOTH_TEAR_F     = 10011, // real

	CLOTH_SETMASS   = 11000, // button
	CLOTH_SETSEAMS  = 11001, // button
	CLOTH_SETINIT   = 11002, // button
	CLOTH_SETDINIT  = 11003, // button

	CLOTH_SHOWMASS  = 11004, // button
	CLOTH_SHOWSEAMS = 11005, // button
	CLOTH_SHOWINIT  = 11006, // button
	CLOTH_SHOWDINIT = 11007, // button

	CLOTH_BOUNCE    = 11010, // real
	CLOTH_STICKI    = 11011, // real
	CLOTH_SELF      = 11012, // bool

	CLOTH_SREP      = 11014, // bool
	CLOTH_SREP_D    = 11015, // real
	CLOTH_SREP_F    = 11016, // real
	CLOTH_SREP_B    = 11017, // real

	CLOTH_WIND_DIR    = 11020, // vector
	CLOTH_WIND_F      = 11021, // real
	CLOTH_WIND_TURB_F = 11022, // real
	CLOTH_WIND_TURB_S = 11023, // real
	CLOTH_WIND_DRAG   = 11024, // real
	CLOTH_WIND_IMPACT = 11025, // real
	CLOTH_WIND_LIFT   = 11026, // real
	CLOTH_WIND_SPEED  = 11027, // real

	CLOTH_SEAMS_DIST  = 11028, // real

	CLOTH_DRESSMODE      = 11031, // bool

	CLOTH_DO_DRESSING    = 11040, // button
	CLOTH_DRESS_STEPS    = 11041, // long
	CLOTH_SHRINK_F       = 11042, // real

	CLOTH_MASS_MAP       = 11043, // link
	CLOTH_STRUCT_F_MAP   = 11044, // link
	CLOTH_FLEXION_F_MAP  = 11045, // link
	CLOTH_SHRINK_F_MAP   = 11047, // link
	CLOTH_BOUNCE_MAP     = 11048, // link
	CLOTH_STICKI_MAP     = 11049, // link

	CLOTH_DO_RELAXING    = 11050, // button
	CLOTH_RELAX_STEPS    = 11051, // long

	CLOTH_SUBDIV     = 11052, // long
	CLOTH_START      = 11053, // basetime
	CLOTH_STOP       = 11054, // basetime
	CLOTH_AUTOTIME   = 11055, // bool

	CLOTH_P_EPS      = 11056, // real
	CLOTH_K_EPS      = 11057, // real
	CLOTH_V_EPS      = 11058, // real
	CLOTH_POINTS     = 11059, // bool
	CLOTH_EDGES      = 11060, // bool
	CLOTH_POLYS      = 11061, // bool
	CLOTH_GIA        = 11062, // bool

	CLOTH_BAKE       = 11065, // bool

	CLOTH_USE        = 11070, // bool
	CLOTH_INCLUDE    = 11071, // include list

	CLOTH_BELT_F_MAP = 11072, // link [just for compatibilty <V9.200]
	CLOTH_BELT_S_MAP = 11073, // link [just for compatibilty <V9.200]

	CLOTH_TEAR       = 11074, // bool
	CLOTH_DRAWMASS   = 11075, // bool
	CLOTH_RUBBER_F   = 11077, // real
	CLOTH_RUBBER_F_MAP = 11078, // link

	CLOTH_TEAR_F_MAP  = 11080, // link
	CLOTH_CACHE_OFF   = 11081, // basetime [deprecated]
	CLOTH_ITERATIONS  = 11082, // long
	CLOTH_CACHE_START = 11083, // basetime [replacing CLOTH_CACHE_OFF]

	// GUI
	CLOTH_GROUP_MAIN      = 12000,
	CLOTH_GROUP_FORCES    = 12001,
	CLOTH_GROUP_EFFECTS   = 12002,
	CLOTH_GROUP_DRESSING  = 12003,
	CLOTH_GROUP_EXPERT    = 12004,

	CLOTH_DO_CALCULATE    = 12005, // button
	CLOTH_DELCACHE        = 12006, // button
	CLOTH_CACHE_INFO1     = 12007, // button
	CLOTH_CACHE_INFO2     = 12008, // button
	CLOTH_CACHE_FRAME     = 12009, // button

	CLOTH_TEXT_INIT  = 12012,
	CLOTH_TEXT_DRESS = 12013,
	CLOTH_TEXT_FIX   = 12014,
	CLOTH_TEXT_SEAM  = 12015,

	CLOTH_CLEARDRESS = 12016,
	CLOTH_CLEARMASS  = 12017,
	CLOTH_CLEARSEAM  = 12018,
	CLOTH_CLEARINIT  = 12019,

	CLOTH_TEXT_LIMIT = 12020,

	CLOTH_CACHE_LOAD = 12021,
	CLOTH_CACHE_SAVE = 12022,

	CLOTH_SIMULATION_PRIORITY = 13002,

	// START OF PBD CLOTH INTEGRATION
	CLOTH_LEGACY_SETTINGS_GROUP = 19998,
	CLOTH_PBD_SETTINGS_GROUP = 19999,

	CLOTH_PBD_BENDINESS = 20001,
	CLOTH_PBD_STRETCHINESS = 20002,
	CLOTH_PBD_FRICTION = 20003,
	CLOTH_PBD_THICKNESS = 20004,
	CLOTH_PBD_MASS = 20005,
	CLOTH_PBD_TARGET_LENGTH = 20017,
	CLOTH_PBD_TARGET_LENGTH_WEIGHTS = 20018,
	CLOTH_PBD_TARGET_LENGTH_MIN = 20019,
	CLOTH_PBD_TEARING = 20006,
	CLOTH_PBD_TEARPAST = 20007,
	CLOTH_PBD_BALLOON = 20008,
	CLOTH_PBD_OVERPRESSURE = 20009,
	CLOTH_PBD_EXPANSIONTIME = 20026,
	CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS = 20010,
		CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS_NONE = 0,
		CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS_SINGLE = 1,
		CLOTH_PBD_CONSTRAINTS_QUADDIAGONALS_DOUBLE = 2,
	CLOTH_PBD_TEAR_GUIDE_CONE_ANGLE = 20011,
	CLOTH_PBD_BOUNCINESS = 20027,

	CLOTH_PBD_FORCES_GROUP = 20012,
	CLOTH_PBD_FORCES_INEXCLUDE = 20013,
	CLOTH_PBD_FORCES_INEXMODE = 20014,
		CLOTH_PBD_FORCES_INEXMODE_INCLUDE = 0,
		CLOTH_PBD_FORCES_INEXMODE_EXCLUDE = 1,
	CLOTH_PBD_FORCES_INEX_PYRO = 20015,
	CLOTH_PBD_BENDINESS_WEIGHTS = 20020,
	CLOTH_PBD_STRETCHINESS_WEIGHTS = 20021,
	CLOTH_PBD_FRICTION_WEIGHTS = 20022,
	CLOTH_PBD_THICKNESS_WEIGHTS = 20023,
	CLOTH_PBD_MASS_WEIGHTS = 20024,
	CLOTH_PBD_TEARPAST_WEIGHTS = 20025,
	CLOTH_PBD_BOUNCINESS_WEIGHTS = 20028,
	CLOTH_PBD_ELASTIC_PLASTIC_DEFORM = 20029,
	CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_PAST = 20030,
	CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_PAST_WEIGHTS = 20031,
	CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_RATE = 20032,
	CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_RATE_WEIGHTS = 20033,
	CLOTH_PBD_BEND_PLASTIC_DEFORM = 20034,
	CLOTH_PBD_BEND_PLASTIC_DEFORM_PAST = 20035,
	CLOTH_PBD_BEND_PLASTIC_DEFORM_PAST_WEIGHTS = 20036,
	CLOTH_PBD_BEND_PLASTIC_DEFORM_RATE = 20037,
	CLOTH_PBD_BEND_PLASTIC_DEFORM_RATE_WEIGHTS = 20038,
	CLOTH_PBD_PLASTIC_DEFORM_GROUP = 20039,
	CLOTH_PBD_TEARING_GROUP = 20040,
	CLOTH_PBD_BALLOON_GROUP = 20041,
	CLOTH_DO_CALCULATE_ALL  = 20042, // button
	CLOTH_DELCACHE_ALL  = 20043, // button
	CLOTH_PBD_BEND_PLASTIC_DEFORM_HARDENING = 20044,
	CLOTH_PBD_BEND_PLASTIC_DEFORM_HARDENING_WEIGHTS = 20045,
	CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_HARDENING = 20046,
	CLOTH_PBD_ELASTIC_PLASTIC_DEFORM_HARDENING_WEIGHTS = 20047,
	CLOTH_LEGACYON = 20048,
	CLOTH_PBD_MAPMINTEARPAST = 20049,
	CLOTH_PBD_STRUT_SOFTBODY_GROUP = 20050,
	CLOTH_PBD_STRUT_SOFTBODY = 20051,
	CLOTH_PBD_STRUT_SOFTBODY_STRETCHINESS = 20052,
	CLOTH_PBD_STRUT_SOFTBODY_STRETCHINESS_WEIGHTS = 20053,
	CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH = 20054,
	CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH_WEIGHTS = 20055,
	CLOTH_PBD_STRUT_DEFORM = 20056,
	CLOTH_PBD_STRUT_DEFORM_PAST = 20057,
	CLOTH_PBD_STRUT_DEFORM_PAST_WEIGHTS = 20058,
	CLOTH_PBD_STRUT_DEFORM_RATE = 20059,
	CLOTH_PBD_STRUT_DEFORM_RATE_WEIGHTS = 20060,
	CLOTH_PBD_STRUT_DEFORM_HARDENING = 20061,
	CLOTH_PBD_STRUT_DEFORM_HARDENING_WEIGHTS = 20062,
	CLOTH_PBD_STRUT_SOFTBODY_MAXSTRUTS = 20063,
	CLOTH_PBD_STRUT_SOFTBODY_MAXSTRUTS_WEIGHTS = 20064,
	CLOTH_PBD_STRUT_SOFTBODY_MAXLENGTH = 20065,
	CLOTH_PBD_STRUT_SOFTBODY_MAXLENGTH_WEIGHTS = 20066,
	CLOTH_PBD_STRUT_SOFTBODY_MINLENGTH = 20067,
	CLOTH_PBD_STRUT_SOFTBODY_MINLENGTH_WEIGHTS = 20068,
	CLOTH_PBD_STRUT_SOFTBODY_SPREAD = 20069,
	CLOTH_PBD_STRUT_SOFTBODY_SPREAD_WEIGHTS = 20070,
	CLOTH_PBD_STRUT_SOFTBODY_SEED = 20071,
	CLOTH_PBD_STRUT_SOFTBODY_ACCEPTANCE = 20072,
	CLOTH_PBD_STRUT_SOFTBODY_ACCEPTANCE_WEIGHTS = 20073,
	CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE = 20074,
		CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE_FRONT = 0,
		CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE_BACK = 1,
		CLOTH_PBD_STRUT_SOFTBODY_SHOOT_SIDE_BOTH = 2,
	CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE = 20075,
		CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE_FRONT = 0,
		CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE_BACK = 1,
		CLOTH_PBD_STRUT_SOFTBODY_HIT_SIDE_BOTH = 2,
	CLOTH_PBD_STRUT_TEARING = 20076,
	CLOTH_PBD_STRUT_TEARING_DIRECTION = 20077,
		CLOTH_PBD_STRUT_TEARING_DIRECTION_ELONGATION = 0,
		CLOTH_PBD_STRUT_TEARING_DIRECTION_COMPRESSION = 1,
		CLOTH_PBD_STRUT_TEARING_DIRECTION_BOTH = 2,
	CLOTH_PBD_STRUT_TEARPAST = 20078,
	CLOTH_PBD_STRUT_TEARPAST_WEIGHTS = 20079,
	CLOTH_PBD_STRUT_MAPMINTEARPAST = 20080,
	CLOTH_PBD_STRUT_DRAW = 20081,
		CLOTH_PBD_STRUT_DRAW_SELECTED = 0,
		CLOTH_PBD_STRUT_DRAW_ALWAYS = 1,
		CLOTH_PBD_STRUT_DRAW_NEVER = 2,
	CLOTH_PBD_STRUT_DEFORM_DIRECTION = 20082,
		CLOTH_PBD_STRUT_DEFORM_DIRECTION_ELONGATION = 0,
		CLOTH_PBD_STRUT_DEFORM_DIRECTION_COMPRESSION = 1,
		CLOTH_PBD_STRUT_DEFORM_DIRECTION_BOTH = 2,
	CLOTH_PBD_STRUT_SOFTBODY_CREATION_GROUP = 20083,
	CLOTH_PBD_FOLLOW_ANIMATION_GROUP = 20084,
	CLOTH_PBD_FOLLOW_ANIMATION_FORCE = 20085,
	CLOTH_PBD_FOLLOW_ANIMATION_FORCE_STRENGTH = 20086,
	CLOTH_PBD_FOLLOW_ANIMATION_FORCE_STRENGTH_WEIGHTS = 20087,
	CLOTH_PBD_FOLLOW_ANIMATION_FORCE_STRENGTH_SCALE = 20088,
	CLOTH_PBD_FOLLOW_ANIMATION_PINS = 20089,
	CLOTH_PBD_FOLLOW_ANIMATION_PINS_STRETCHINESS = 20090,
	CLOTH_PBD_FOLLOW_ANIMATION_PINS_STRETCHINESS_WEIGHTS = 20091,
	CLOTH_PBD_FOLLOW_ANIMATION_PINS_STRETCHINESS_SCALE = 20092,
	CLOTH_PBD_STICKINESS = 20093,
	CLOTH_PBD_STICKINESS_WEIGHTS = 20094,
	CLOTH_PBD_STRUT_SOFTBODY_POLES_DIRECTION = 20095,
	CLOTH_PBD_STRUT_SOFTBODY_TARGETLENGTH_MIN = 20096,
	CLOTH_PBD_STRUT_SOFTBODY_UPDATE_BUTTON = 20097,
	CLOTH_PBD_COLLISION_SIDE = 20098,
		CLOTH_PBD_COLLISION_SIDE_FRONT = 0,
		CLOTH_PBD_COLLISION_SIDE_BACK = 1,
		CLOTH_PBD_COLLISION_SIDE_BOTH = 2,
	CLOTH_PBD_FOLLOW_SHAPE = 20099,
	CLOTH_PBD_STRUT_SOFTBODY_TEARING = 20100,
	CLOTH_PBD_BALLOON_WEIGHTS = 20101,
	CLOTH_PBD_BALLOON_STRETCH_INFLUENCE = 20102,
	CLOTH_PBD_MASS_MAP_MIN = 20103,
	CLOTH_PBD_PARTICLE_DAMPING_GROUP = 20104,
	CLOTH_PBD_PARTICLE_DAMPING_OVERRIDE = 20105,
	CLOTH_PBD_PARTICLE_DAMPING = 20106,
	CLOTH_PBD_PARTICLE_DAMPING_WEIGHTS = 20107,
	CLOTH_PBD_PARTICLE_DAMPING_WEIGHTS_MIN = 20108,
	CLOTH_PBD_AERO_LIFT = 20109,
	CLOTH_PBD_AERO_DRAG = 20110,
	CLOTH_PBD_CLOTH = 20111,
	CLOTH_PBD_ELASTICBODY_GROUP = 20112,
	CLOTH_PBD_ELASTICBODY = 20113,
	CLOTH_PBD_ELASTICBODY_UPDATE_BUTTON = 20114,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_SEED = 20115,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_XSEGMENTS = 20116,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_YSEGMENTS = 20117,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_ZSEGMENTS = 20118,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_RANDOMIZE = 20119,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_RANDOMIZE_STRENGTH = 20120,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_UNIFORM_SEGMENTS = 20121,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_SEGMENTS = 20122,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_DRAW_LABEL = 20123,
	CLOTH_PBD_ELASTICBODY_DRAW = 20124,
		CLOTH_PBD_ELASTICBODY_DRAW_SELECTED = 0,
		CLOTH_PBD_ELASTICBODY_DRAW_ALWAYS = 1,
		CLOTH_PBD_ELASTICBODY_DRAW_NEVER = 2,
	CLOTH_PBD_ELASTICBODY_CREATION_GROUP = 20125,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_INVSTIFFNESS0 = 20226,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_INVSTIFFNESS1 = 20227,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_AUTOCREATE = 20228,
	CLOTH_PBD_ELASTICBODY_SHAPEMATCHING_ACTIVE = 20229,
	CLOTH_DUMMY
};

#endif // CLOTHTAG_H__
