CONTAINER Tcaanimationmodifier
{
	NAME Tcaanimationmodifier;
	INCLUDE Texpression;
	
	GROUP ID_TAGPROPERTIES
	{
		LONG ID_CA_ANIMATION_MODIFIER_TAG_MODE
		{
			ANIM OFF; 
			DEFAULT ID_CA_ANIMATION_MODIFIER_TAG_SPRING;
			
			CYCLE
			{
				ID_CA_ANIMATION_MODIFIER_TAG_SPRING;
				ID_CA_ANIMATION_MODIFIER_TAG_POSTERIZE;
				ID_CA_ANIMATION_MODIFIER_TAG_NOISE;
				ID_CA_ANIMATION_MODIFIER_TAG_SMOOTH;
			}
		}
		REAL ID_CA_ANIMATION_MODIFIER_TAG_OFFSET { UNIT TIME; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER -90.0; MAXSLIDER 90.0;}
		REAL ID_CA_ANIMATION_MODIFIER_TAG_TIME_STRETCH { UNIT PERCENT; MIN -100.0; MAXSLIDER 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; }		
		
		// Spring
		REAL ID_CA_ANIMATION_MODIFIER_TAG_SPRING_STRENGTH { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; }
		REAL ID_CA_ANIMATION_MODIFIER_TAG_SPRING_STIFFNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
		REAL ID_CA_ANIMATION_MODIFIER_TAG_SPRING_DRAG { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; CUSTOMGUI REALSLIDER; }
		// LONG ID_CA_ANIMATION_MODIFIER_TAG_SPRING_ITERATIONS { MIN 1; MAX 1000; }
		
		//Posterize
		REAL ID_CA_ANIMATION_MODIFIER_TAG_POSTERIZE_STRENGTH { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; MIN 0; MAX 100;}
		REAL ID_CA_ANIMATION_MODIFIER_TAG_POSTERIZE_TIME { UNIT TIME; MIN 1.0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 1; MAXSLIDER 30;}
		
		// Noise
		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_STRENGTH { PARENTCOLLAPSE; STEP 1.0; DEFAULT 0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100;}
		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_POSITION {PARENTCOLLAPSE ID_CA_ANIMATION_MODIFIER_TAG_NOISE_STRENGTH; UNIT PERCENT; MIN 0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }
		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_ROTATION {PARENTCOLLAPSE ID_CA_ANIMATION_MODIFIER_TAG_NOISE_STRENGTH; UNIT PERCENT; MIN 0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }
		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_SCALE {PARENTCOLLAPSE ID_CA_ANIMATION_MODIFIER_TAG_NOISE_STRENGTH; UNIT PERCENT; MIN 0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }
		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_ATTRIBUTES {PARENTCOLLAPSE ID_CA_ANIMATION_MODIFIER_TAG_NOISE_STRENGTH; UNIT PERCENT; MIN 0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }
		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_USERDATA {PARENTCOLLAPSE ID_CA_ANIMATION_MODIFIER_TAG_NOISE_STRENGTH; UNIT PERCENT; MIN 0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100; }

		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_SPEED { UNIT PERCENT; MIN 0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 100;}
		REAL ID_CA_ANIMATION_MODIFIER_TAG_NOISE_SEED { MIN 0.0; STEP 1; DEFAULT 12345; }
		
		// Smooth
		REAL ID_CA_ANIMATION_MODIFIER_TAG_SMOOTH_STRENGTH { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100; STEP 1; DEFAULT 5; CUSTOMGUI REALSLIDER; }
		LONG ID_CA_ANIMATION_MODIFIER_TAG_SMOOTH_NEIGHBOR { MIN 1; MAX 21; STEP 1;}
		SPLINE  ID_CA_ANIMATION_MODIFIER_TAG_SMOOTH_SPLINE { SHOWGRID_H; SHOWGRID_V;}

		// OUTLIER REMOVAL
		// REAL ID_CA_ANIMATION_MODIFIER_TAG_OUTLIER_REMOVAL_STRENGTH { UNIT PERCENT; MINSLIDER 0.0; MAXSLIDER 100; STEP 1; DEFAULT 50; CUSTOMGUI REALSLIDER; }
		// REAL ID_CA_ANIMATION_MODIFIER_TAG_OUTLIER_REMOVAL_SIGMA {MIN 1; MAX 1000;} 
	}
	
	GROUP ID_CA_ANIMATION_MODIFIER_TAG_EXCLUDE
	{
		DEFAULT 1;
		SCALE_V;
			
		BOOL ID_CA_ANIMATION_MODIFIER_TAG_HIERARCHY { ANIM OFF; }
		BOOL ID_CA_ANIMATION_MODIFIER_TAG_INCLUDE_TAGS { ANIM OFF;  }

		SEPARATOR { }

		LONG ID_CA_ANIMATION_MODIFIER_TAG_EXCLUSION_MODE
		{
			ANIM OFF; 
			CYCLE
			{
				ID_CA_ANIMATION_MODIFIER_TAG_EXCLUSION_MODE_INCLUDE;
				ID_CA_ANIMATION_MODIFIER_TAG_EXCLUSION_MODE_EXCLUDE;
			}
		}

		IN_EXCLUDE ID_CA_ANIMATION_MODIFIER_TAG_EXCLUSION_MODE_TRACK 
		{
			NUM_FLAGS 1; 
			INIT_STATE 1;
			SCALE_V;
			
			IMAGE_01_ON 300000131; 
			IMAGE_01_OFF 300000130; 
			
			ACCEPT 
			{ 
				Obase; 
				Tbase;
				CTbase; 
				Mbase;
				Xbase;
				GVbase;
			}; 
		}
	}
	
	GROUP ID_CA_ANIMATION_MODIFIER_TAG_CACHE
	{
		DEFAULT 0;
		
		BOOL ID_CA_ANIMATION_MODIFIER_TAG_RANGE  { ANIM OFF; }
		REAL ID_CA_ANIMATION_MODIFIER_TAG_RANGE_START  { ANIM OFF; UNIT TIME; STEP 1.0; DEFAULT 0; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 90.0;}
		REAL ID_CA_ANIMATION_MODIFIER_TAG_RANGE_END  { ANIM OFF; UNIT TIME; STEP 1.0; DEFAULT 90; CUSTOMGUI REALSLIDER; MINSLIDER 0; MAXSLIDER 90.0;}
		SEPARATOR { }
		
		GROUP
		{
			COLUMNS 2;
			SCALE_H;
			BUTTON ID_CA_ANIMATION_MODIFIER_TAG_CREATE_CACHE { }
			STATICTEXT ID_CA_ANIMATION_MODIFIER_TAG_SMOOTH_CACHE_UPDATE { };
		}
		BUTTON ID_CA_ANIMATION_MODIFIER_TAG_CLEAR_CACHE { }
	}
}
