CONTAINER Oweightmgr
{
	NAME Oweightmgr;

	INCLUDE ToolBase;
	INCLUDE ToolWeightBase;
	INCLUDE ToolMirrorBase;

	HIDE MDATA_COMMANDGROUP;

	GROUP ID_CA_WEIGHT_MGR_FUNCTION_GROUP
	{
		DEFAULT 1;

		GROUP
		{
			DEFAULT 1;
			COLUMNS 2;

			LONG ID_CA_WEIGHT_MGR_WEIGHT_MODE
			{
				CYCLE
				{
					ID_CA_WEIGHT_BASE_MODE_ADD;
					ID_CA_WEIGHT_BASE_MODE_SUBTRACT;
					ID_CA_WEIGHT_BASE_MODE_ABS;
					ID_CA_WEIGHT_BASE_MODE_SMOOTH;
					ID_CA_WEIGHT_BASE_MODE_BLEED;
					ID_CA_WEIGHT_BASE_MODE_INTENSITY;
					ID_CA_WEIGHT_BASE_MODE_REMAP;
					ID_CA_WEIGHT_BASE_MODE_PRUNE;
					ID_CA_WEIGHT_BASE_MODE_ROUND;
					ID_CA_WEIGHT_BASE_MODE_HAMMER;
				}
			}
			BOOL ID_CA_WEIGHT_MGR_NORMALIZE{}

			REAL ID_CA_WEIGHT_MGR_WEIGHT_STRENGTH { UNIT PERCENT; MIN -100.0; MINSLIDER 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			LONG ID_CA_WEIGHT_MGR_WEIGHTING_ROUND_TO
			{
				SCALE_H;
				HIDDEN;
				
				CYCLE
				{
					ID_CA_WEIGHT_MGR_SPREADSHEET_ROUND_TO_1;
					ID_CA_WEIGHT_MGR_SPREADSHEET_ROUND_TO_5;
					ID_CA_WEIGHT_MGR_SPREADSHEET_ROUND_TO_10;
				}
			}
			BOOL ID_CA_WEIGHT_MGR_FUNCTION_LINK_DROPPER_WITH_TOOL{}

			GROUP ID_CA_WEIGHT_MGR_WEIGHTING_REMAP_SPLINE_GROUP
			{
				HIDDEN;
				SPLINE ID_CA_WEIGHT_MGR_WEIGHTING_REMAP_SPLINE{  }
			}

			GROUP ID_CA_WEIGHT_MGR_OPTIONS_CLAMP_GROUP
			{
				COLUMNS 2;
				DEFAULT 0;

				BOOL ID_CA_WEIGHT_MGR_OPTIONS_CLAMP_LOWER_ENABLE { }
				REAL ID_CA_WEIGHT_MGR_OPTIONS_CLAMP_LOWER { FIT_H; SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }

				BOOL ID_CA_WEIGHT_MGR_OPTIONS_CLAMP_UPPER_ENABLE { }
				REAL ID_CA_WEIGHT_MGR_OPTIONS_CLAMP_UPPER { FIT_H; SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			}

			GROUP
			{
				COLUMNS 2;
				BUTTON ID_CA_WEIGHT_MGR_APPLY_ALL { SCALE_H; }
				BUTTON ID_CA_WEIGHT_MGR_APPLY_SELECTED { SCALE_H; }
			}
		}

		SEPARATOR { LINE; }

		GROUP
		{
			DEFAULT 1;
			COLUMNS 3; 

			BUTTON ID_CA_WEIGHT_MGR_CLEAR_WEIGHTS { SCALE_H; }
			BUTTON ID_CA_WEIGHT_MGR_COPY_WEIGHTS { SCALE_H; }
			LONG ID_CA_WEIGHT_MGR_PASTE_WEIGHTS
			{
				SCALE_H;
				CUSTOMGUI CYCLEBUTTON; 
				CYCLE
				{
					ID_CA_WEIGHT_MGR_PASTE_MERGE;
					ID_CA_WEIGHT_MGR_PASTE_REPLACE;
				}
			}

			BUTTON ID_CA_WEIGHT_MGR_NORMALIZE_ALL { SCALE_H; }
			LONG ID_CA_WEIGHT_MGR_MIRROR_WEIGHTS2
			{
				SCALE_H;
				CUSTOMGUI CYCLEBUTTON; 
				CYCLE
				{
					ID_CA_WEIGHT_MGR_MIRROR_TYPE_REFLECT;
					ID_CA_WEIGHT_MGR_MIRROR_TYPE_P2N;
					ID_CA_WEIGHT_MGR_MIRROR_TYPE_N2P;
				}
			}
			LONG ID_CA_WEIGHT_MGR_FLIP_WEIGHTS
			{
				CUSTOMGUI CYCLEBUTTON; 
				SCALE_H;
				CYCLE
				{
					ID_CA_WEIGHT_MGR_FLIP_PLANE_YZ;
					ID_CA_WEIGHT_MGR_FLIP_PLANE_XZ;
					ID_CA_WEIGHT_MGR_FLIP_PLANE_XY;
				}
			}
		}
	}

	GROUP ID_CA_WEIGHT_MGR_JOINT_GROUP
	{
		DEFAULT 0;
		NAME ID_CA_WEIGHT_MGR_JOINT_TREE_GROUP;

		GROUP
		{
			COLUMNS 3;
			// FOLLOWING ARE HIDDEN, THEIR VALUES ARE REFLECTED IN THE MENU INSTEAD.
			// BUT WE NEED THE BASECONTAINER PARAMETERS
			BOOL ID_CA_WEIGHT_MGR_SOLO_MODE { HIDDEN; }
			LONG ID_CA_WEIGHT_MGR_SORT_JOINT_LIST
			{
				HIDDEN;
				CYCLE
				{
					ID_CA_WEIGHT_MGR_SORT_LIST_FLAT;
					ID_CA_WEIGHT_MGR_SORT_LIST_HIERARCHY;
					ID_CA_WEIGHT_MGR_SORT_LIST_NAME;
					ID_CA_WEIGHT_MGR_SORT_LIST_WEIGHT_TAG;
				}
			}
			BITMAPBUTTON ID_CA_WEIGHT_MGR_JOINT_TREE_CLEAR_FILTER
			{
				BUTTON;
				ICONID1 300000187; 
			}
			STRING ID_CA_WEIGHT_MGR_FILTER_STRING { SCALE_H; }
			BOOL ID_CA_WEIGHT_MGR_LOCK_MODE { }
		}

		ITEMTREE ID_CA_WEIGHT_MGR_JOINTS
		{
			COLUMNS 3;
			COLOR;
			MULTIPLE;
			ICON;
			FOLD_FOLDERS_CMD;
			HIDE_FOLDERS_CMD;
			PADLOCK;
			DRAGDROP;
			ROWS 10;
			NORENAME;
		}
	}
	
	GROUP ID_CA_WEIGHT_MGR_SPREADSHEET_GROUP
	{
		SCALE_V;

		GROUP ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_GROUP
		{
			DEFAULT 1;
			
			GROUP
			{
				DEFAULT 1;
				FIT_H;
				COLUMNS 2;

				LONG ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER
				{
					SCALE_H;
					// DO NOT SHOW ALL FILTER TYPES HERE. THEY ARE NOT ALL MEANT FOR PERMANENT FILTERING
					CYCLE
					{
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_NONE;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_LESS;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_MORE;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_RANGE;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_UNNORMALIZED;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_VP_POINTS;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_WM_JOINTS;
					}
				}
				LONG ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER2
				{
					SCALE_H;
					CYCLE
					{
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_NONE;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_UNNORMALIZED;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_VP_POINTS;
						ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_WM_JOINTS;
					}
				}
				BOOL ID_CA_WEIGHT_MGR_SPREADSHEET_HIDE_ZERO { HIDDEN; SCALE_H; }

				REAL ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_MIN { STEP 0.01; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
				REAL ID_CA_WEIGHT_MGR_SPREADSHEET_FILTER_MAX { STEP 0.01; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			}

			SEPARATOR {LINE;}

			GROUP
			{
				DEFAULT 1;
				FIT_H;
				COLUMNS 2;
				
				BOOL ID_CA_WEIGHT_MGR_SPREADSHEET_LINK_POINT_SELECTION { SCALE_H; }
				BOOL ID_CA_WEIGHT_MGR_SPREADSHEET_LINK_JOINT_SELECTION { SCALE_H; }

				BUTTON ID_CA_WEIGHT_MGR_SPREADSHEET_SET_POINT_VISIBILITY { SCALE_H; }
				BUTTON ID_CA_WEIGHT_MGR_SPREADSHEET_SET_JOINT_VISIBILITY { SCALE_H; }
			}
		}

		GROUP ID_CA_WEIGHT_MGR_SPREADSHEET_EDIT_GROUP
		{
			DEFAULT 1;
			SCALE_V;
			SCALE_H;

			GROUP
			{
				COLUMNS 4;
				
				LONG ID_CA_WEIGHT_MGR_SPREADSHEET_SLIDER_MODE
				{
					CYCLE
					{
						ID_CA_WEIGHT_BASE_MODE_ADD;
						ID_CA_WEIGHT_BASE_MODE_SUBTRACT;
						ID_CA_WEIGHT_BASE_MODE_ABS;
						ID_CA_WEIGHT_BASE_MODE_SMOOTH;
						ID_CA_WEIGHT_BASE_MODE_BLEED;
						ID_CA_WEIGHT_BASE_MODE_INTENSITY;
						ID_CA_WEIGHT_BASE_MODE_REMAP;
						ID_CA_WEIGHT_BASE_MODE_PRUNE;
						ID_CA_WEIGHT_BASE_MODE_ROUND;
						ID_CA_WEIGHT_BASE_MODE_HAMMER;
					}
				}
				REAL ID_CA_WEIGHT_MGR_SPREADSHEET_SLIDER { SCALE_H; UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				LONG ID_CA_WEIGHT_MGR_SPREADSHEET_ROUND_TO
				{
					SCALE_H;
					HIDDEN;
					CYCLE
					{
						ID_CA_WEIGHT_MGR_SPREADSHEET_ROUND_TO_1;
						ID_CA_WEIGHT_MGR_SPREADSHEET_ROUND_TO_5;
						ID_CA_WEIGHT_MGR_SPREADSHEET_ROUND_TO_10;
					}
				}
				BUTTON ID_CA_WEIGHT_MGR_SPREADSHEET_SLIDER_ZERO { }
				
				SEPARATOR { }
				
				STATICTEXT { JOINBEGIN; }
				GROUP ID_CA_WEIGHT_MGR_SPREADSHEET_REMAP_SPLINE_GROUP
				{
					HIDDEN;
					SPLINE ID_CA_WEIGHT_MGR_SPREADSHEET_REMAP_SPLINE	{ SCALE_H; }
				}
				BUTTON ID_CA_WEIGHT_MGR_SPREADSHEET_SLIDER_APPLY_ROUND { HIDDEN; SCALE_H; }
				STATICTEXT { DUMMY; }
				STATICTEXT { JOINENDSCALE; }
			}

			SPREADSHEET ID_CA_WEIGHT_MGR_SPREADSHEET { SCALE_V; }
		}
	}
	
	GROUP ID_CA_WEIGHT_MGR_AUTOWEIGHT_GROUP
	{
		DEFAULT 0;
		COLUMNS 2;
		LONG ID_CA_WEIGHT_MGR_AUTOWEIGHT_MODE
		{
			CYCLE
			{
			}
		}
		BOOL ID_CA_WEIGHT_MGR_AUTOWEIGHT_IN_BIND_POSE { }
		SEPARATOR { }
		GROUP ID_CA_WEIGHT_MGR_AUTOWEIGHT_ALGO_GROUP
		{
		}
		BUTTON ID_CA_WEIGHT_MGR_AUTOWEIGHT_CALCULATE { FIT_H; SCALE_H; }
	}

	GROUP ID_CA_WEIGHT_MGR_FUNCTIONS2_GROUP
	{
		DEFAULT 1;

		GROUP ID_CA_WEIGHT_MGR_FUNCTION_MIRROR
		{
			DEFAULT 0;

			GROUP ID_CA_WEIGHT_MGR_FUNCTION_MIRROR_SPACE_GROUP
			{
				DEFAULT 1;
				COLUMNS 2;
				
				LONG ID_CA_WEIGHT_MGR_MIRROR_ORIGIN
				{
					CYCLE
					{
						ID_CA_TOOL_MIRROR_BASE_ORIGIN_ROOT;
						ID_CA_TOOL_MIRROR_BASE_ORIGIN_OBJECT;
						ID_CA_TOOL_MIRROR_BASE_ORIGIN_WORLD;
						ID_CA_TOOL_MIRROR_BASE_ORIGIN_MESH;
					}
				}

				LONG ID_CA_WEIGHT_MGR_MIRROR_COORDS
				{
					CYCLE
					{
						ID_CA_TOOL_MIRROR_BASE_COORDS_WORLD;
						ID_CA_TOOL_MIRROR_BASE_COORDS_LOCAL;
					}
				}

				LONG ID_CA_WEIGHT_MGR_MIRROR_DIRECTION
				{
					CYCLE
					{
						ID_CA_TOOL_MIRROR_BASE_DIRECTION_X;
						ID_CA_TOOL_MIRROR_BASE_DIRECTION_Y;
						ID_CA_TOOL_MIRROR_BASE_DIRECTION_Z;
					}
				}

				LINK ID_CA_WEIGHT_MGR_MIRROR_ORIGIN_OBJECT { ACCEPT { Obase; } }
			}

			GROUP ID_CA_WEIGHT_MGR_FUNCTION_MIRROR_POINT_GROUP
			{
				DEFAULT 1;
				COLUMNS 2;

				LONG ID_CA_WEIGHT_MGR_MIRROR_POINT_MATCH
				{
					CYCLE
					{
						ID_CA_TOOL_MIRROR_BASE_SEARCH_RADIUS;
						ID_CA_TOOL_MIRROR_BASE_SEARCH_NEAREST;
						ID_CA_TOOL_MIRROR_BASE_SEARCH_SURFACE;
						ID_CA_TOOL_MIRROR_BASE_SEARCH_NORMALS;
					}
				}
				REAL ID_CA_WEIGHT_MGR_MIRROR_POINT_TOLERANCE { UNIT METER; STEP 0.01; MIN 0.00001; }
			}
		
			GROUP ID_CA_WEIGHT_MGR_FUNCTION_MIRROR_JOINT_GROUP
			{
				DEFAULT 1;

				GROUP
				{
					COLUMNS 2;

					LONG ID_CA_WEIGHT_MGR_MIRROR_ALGO_PASS1
					{
						CYCLE
						{
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_TOPO;
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_POS;
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_SPATIAL_PART;
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_NAME;
						}
					}
					STATICTEXT{ JOINEND; }

					LONG ID_CA_WEIGHT_MGR_MIRROR_ALGO_PASS2
					{
						CYCLE
						{
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_NONE;
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_TOPO;
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_POS;
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_SPATIAL_PART;
							ID_CA_TOOL_MIRROR_BASE_JOINT_MATCH_NAME;
						}
					}
					STATICTEXT{ JOINEND; }

					BOOL ID_CA_WEIGHT_MGR_MIRROR_ALGO_PASS_FINAL { HIDDEN; }
				}

				GROUP ID_CA_WEIGHT_MGR_FUNCTION_MIRROR_SPATIAL_GROUP
				{
					DEFAULT 1;
					COLUMNS 2;
					SEPARATOR{ LINE; SCALE_H; }
					STATICTEXT{ JOINEND; }
					GROUP
					{
						DEFAULT 1;
						COLUMNS 2;
						// ADAPTATIVE IS NOT 100% FUNCTIONAL YET.
						BOOL ID_CA_WEIGHT_MGR_MIRROR_SPATIAL_ADAPTATIVE { HIDDEN; }
						REAL ID_CA_WEIGHT_MGR_MIRROR_SPATIAL_PART_FACTOR { UNIT PERCENT; STEP 1.0; MIN 1.0; MAX 200.0; }
						STATICTEXT{ JOINEND; }
					}
				}
				GROUP ID_CA_WEIGHT_MGR_FUNCTION_MIRROR_POSITION_GROUP
				{
					DEFAULT 1;
					COLUMNS 2;
					SEPARATOR{ LINE; SCALE_H; }
					STATICTEXT{ JOINEND; }
					REAL ID_CA_WEIGHT_MGR_MIRROR_JOINT_TOLERANCE { UNIT METER; STEP 0.01; MIN 0.00001; }
					STATICTEXT{ JOINEND; }
				}
				GROUP ID_CA_WEIGHT_MGR_FUNCTION_MIRROR_NAME_GROUP
				{
					DEFAULT 1;
					COLUMNS 2;
					SEPARATOR { LINE; SCALE_H; }
					STATICTEXT { JOINEND; }
					BOOL ID_CA_WEIGHT_MGR_MIRROR_NAME_MATCH_CASE {}
					STATICTEXT{ JOINEND; }
					GROUP
					{
						COLUMNS 2;
						STRING ID_CA_WEIGHT_MGR_MIRROR_NAME_NEG_PREFIX{}
						STRING ID_CA_WEIGHT_MGR_MIRROR_NAME_POS_PREFIX{}
					}
					STATICTEXT{ JOINEND; }
				}
			}
		}

		GROUP ID_CA_WEIGHT_MGR_SMOOTH_GROUP
		{
			GROUP
			{
				COLUMNS 2;

				REAL ID_CA_WEIGHT_MGR_SMOOTH_STRENGTH { UNIT PERCENT; MIN -100.0; MINSLIDER 0.0; MAX 100; CUSTOMGUI REALSLIDER; SCALE_H; }		
				REAL ID_CA_WEIGHT_MGR_SMOOTH_DISTANCE { UNIT METER; MIN 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; SCALE_H; }
			}

			SPLINE ID_CA_WEIGHT_MGR_SMOOTH_CURVE {  }

			GROUP
			{
				COLUMNS 2;

				BUTTON ID_CA_WEIGHT_MGR_SMOOTH { SCALE_H; }
				BOOL ID_CA_WEIGHT_MGR_SMOOTH_INTERACTIVE { }
			}
		}
	}

	GROUP ID_CA_WEIGHT_MGR_OPTIONS_GROUP
	{
		DEFAULT 0;
		FIT_H;
		COLUMNS 3;

		BOOL ID_CA_WEIGHT_MGR_ENABLE_DISPLAY { }
		BOOL ID_CA_WEIGHT_MGR_DISPLAY_ALL_WEIGHTS { }
		STATICTEXT { JOINEND; }
		BOOL ID_CA_WEIGHT_MGR_DISPLAY_FALLOFFS{ }
		BOOL ID_CA_WEIGHT_MGR_DISPLAY_POINTS { }
		STATICTEXT { JOINEND; }
		BOOL ID_CA_WEIGHT_MGR_DISPLAY_MOUSE_HUD { }
		BOOL ID_CA_WEIGHT_MGR_HIGHLIGHT_UNNORMALIZED { }
		STATICTEXT { JOINEND; }

		LONG ID_CA_WEIGHT_MGR_DISPLAY_HUD_MODE
		{
			CYCLE
			{
				ID_CA_WEIGHT_MGR_DISPLAY_HUD_MODE_SELECTED;
				ID_CA_WEIGHT_MGR_DISPLAY_HUD_MODE_ALL;
			}
		}
		STATICTEXT { JOINENDSCALE; }
		STATICTEXT { JOINEND; }

		REAL ID_CA_WEIGHT_MGR_DISPLAY_HUD_DIST_RATIO{ HIDDEN; UNIT PERCENT; MIN 1; MAX 200; CUSTOMGUI REALSLIDER; SCALE_H; }
		REAL ID_CA_WEIGHT_MGR_DISPLAY_HUD_ANGLE{ HIDDEN; UNIT DEGREE; MIN 0; MAX 360; CUSTOMGUI REALSLIDER; SCALE_H; }
		STATICTEXT{ HIDDEN; JOINEND; }

		GROUP
		{
			SEPARATOR{ NAME ID_CA_WEIGHT_MGR_OPTIONS_DISPLAY_COLOR_GROUP; }

			GROUP ID_CA_WEIGHT_MGR_DISPLAY_COLOR_SURFACE_GROUP
			{
				DEFAULT 1;
				FIT_H;
				COLUMNS 2;
				
				LONG ID_CA_WEIGHT_MGR_DISPLAY_COLOR_MODE
				{
					CYCLE
					{
						ID_CA_WEIGHT_MGR_DISPLAY_COLOR_MODE_OBJECT;
						ID_CA_WEIGHT_MGR_DISPLAY_COLOR_MODE_SINGLE;
						ID_CA_WEIGHT_MGR_DISPLAY_COLOR_MODE_RAINBOW;
					}
				}
				STATICTEXT { JOINEND; }

				REAL ID_CA_WEIGHT_MGR_DISPLAY_LOWER { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				REAL ID_CA_WEIGHT_MGR_DISPLAY_UPPER { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				REAL ID_CA_WEIGHT_MGR_DISPLAY_FADE { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				STATICTEXT{ JOINEND; }

				COLOR ID_CA_WEIGHT_MGR_DISPLAY_ZERO_COLOR { }
				STATICTEXT { JOINEND; }

				GRADIENT  ID_CA_WEIGHT_MGR_DISPLAY_COLOR { COLOR; }
				STATICTEXT { JOINEND; }
			}

			GROUP ID_CA_WEIGHT_MGR_DISPLAY_COLOR_JOINT_GROUP
			{
				DEFAULT 0;
				FIT_H;

				LONG ID_CA_WEIGHT_MGR_SELECTED_COLOR_MODE
				{
					CYCLE
					{
						ID_CA_WEIGHT_MGR_SELECTED_COLOR_MODE_OBJECT;
						ID_CA_WEIGHT_MGR_SELECTED_COLOR_MODE_WEIGHT;
						ID_CA_WEIGHT_MGR_SELECTED_COLOR_MODE_CUSTOM;
					}
				}

				COLOR ID_CA_WEIGHT_MGR_DISPLAY_SELECTED_COLOR { }
			}
			
			GROUP ID_CA_WEIGHT_MGR_DISPLAY_COLOR_HUD_GROUP
			{
				DEFAULT 0;
				REAL ID_CA_WEIGHT_MGR_DISPLAY_HUD_ALPHA { SCALE_H; UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
				COLOR ID_CA_WEIGHT_MGR_DISPLAY_HUD_BACKGROUND_COLOR { }
			}

			SEPARATOR{ LINE; }
		}
	}
}
