CONTAINER trigidbody
{
	NAME trigidbody;
	INCLUDE Tbase;

	GROUP Obaselist
	{
	  PRIORITY RIGIDBODY_PBD_SIMULATION_PRIORITY { ANIM OFF; NOCAMERA; }
	  BOOL RIGIDBODY_USE { }
	}
	
	GROUP RIGIDBODY_PBD_CUSTOM_START_GROUP
	{
		DEFAULT 1;
		LINK RIGIDBODY_PBD_MOGRAPH_SELECTION {ACCEPT {1021338;};}
		BOOL RIGIDBODY_PBD_SYNC_MOGRAPH_MATRIX {}
		
		LONG RIGIDBODY_PBD_TRIGGER_TYPE
		{
			CYCLE
			{
				RIGIDBODY_PBD_TRIGGER_IMMEDIATELY;
				RIGIDBODY_PBD_TRIGGER_ON_COLLISION;
				RIGIDBODY_PBD_TRIGGER_AT_VELOCITY_PEAK;
			}
			DEFAULT RIGIDBODY_PBD_TRIGGER_IMMEDIATELY;
		}

		SEPARATOR { LINE; }

		GROUP RIGIDBODY_PBD_CUSTOM_INITIAL_VELOCITY_GROUP
		{
			DEFAULT 1;

			REAL RIGIDBODY_PBD_TRIGGER_VELOCITY_THRESHOLD { UNIT METER; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; }
			BOOL RIGIDBODY_PBD_CUSTOM_INITIAL_VELOCITY { }
			BOOL RIGIDBODY_PBD_INITIAL_VELOCITY_IN_LOCALSPACE { }
			VECTOR RIGIDBODY_PBD_INITIAL_LINEAR_VELOCITY { }
			REAL RIGIDBODY_PBD_INITIAL_LINEAR_VELOCITY_STRENGTH { UNIT METER; MINSLIDER 0.0; MAXSLIDER 5000.0; STEP 100; CUSTOMGUI REALSLIDER; DEFAULT 1000.0; }
			LINK RIGIDBODY_PBD_INITIAL_VELOCITY_TARGET { SCALE_H; ACCEPT { Obase; } }

			SEPARATOR { LINE; }

			BOOL RIGIDBODY_PBD_CUSTOM_INITIAL_ANGULAR_VELOCITY { }
			BOOL RIGIDBODY_PBD_INITIAL_ANGULAR_VELOCITY_IN_LOCALSPACE { }
			VECTOR RIGIDBODY_PBD_INITIAL_ANGULAR_VELOCITY { }
			REAL RIGIDBODY_PBD_INITIAL_ANGULAR_VELOCITY_STRENGTH { UNIT DEGREE; MINSLIDER 0.0; MAXSLIDER 720.0; STEP 15; CUSTOMGUI REALSLIDER; DEFAULT 360.0; }

			SEPARATOR { LINE; }

			BOOL RIGIDBODY_PBD_DRAW_INITIAL_VELOCITY { ANIM OFF; }
		}

		GROUP RIGIDBODY_PBD_INHERIT_INITIAL_STATE_FROM_PARTICLES_GROUP
		{
			DEFAULT 1;
			BOOL RIGIDBODY_PBD_INHERIT_INITIAL_ORIENTATION_FROM_PARTICLES { }
			BOOL RIGIDBODY_PBD_INHERIT_INITIAL_LINEAR_VELOCITY_FROM_PARTICLES { }
			BOOL RIGIDBODY_PBD_INHERIT_INITIAL_ANGULAR_VELOCITY_FROM_PARTICLES { }
		}

		GROUP RIGIDBODY_PBD_DEACTIVATION_GROUP
		{
			DEFAULT 1;		
			REAL RIGIDBODY_PBD_DEACTIVATION_LINEAR { UNIT METER; DEFAULT 10.0; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; }
			REAL RIGIDBODY_PBD_DEACTIVATION_ANGULAR{ UNIT DEGREE; DEFAULT 10.0; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; }
			REAL RIGIDBODY_PBD_WAKEUPTHRESHOLD { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; }
			REAL RIGIDBODY_PBD_DEACTIVATION_TIME { UNIT TIME; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 120.0; CUSTOMGUI REALSLIDER; }
		}
		
		GROUP RIGIDBODY_PBD_DAMPING_GROUP
		{
			DEFAULT 1;
			BOOL RIGIDBODY_PBD_DAMPING_OVERRIDE { }
			REAL RIGIDBODY_PBD_LINEAR_DAMPING   { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; }
			REAL RIGIDBODY_PBD_ANGULAR_DAMPING  { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 1; CUSTOMGUI REALSLIDER; }
		}

		GROUP
		{
			COLUMNS 4;
			STATICTEXT RIGIDBODY_PBD_TEXTINIT { NOTEXT; }
			BUTTON RIGIDBODY_PBD_SETINIT {}
			BUTTON RIGIDBODY_PBD_CLEARINIT {}
			BOOL RIGIDBODY_PBD_VELOCITYINIT { ANIM OFF; }
		}
	}

	GROUP RIGIDBODY_PBD_COLLISION_GROUP
	{
		DEFAULT 1;

		REAL RIGIDBODY_PBD_FRICTION { MIN 0.0; STEP 0.1; DEFAULT 0.5; PARENTCOLLAPSE; }
		LINK RIGIDBODY_PBD_FRICTION_WEIGHTS { PARENTCOLLAPSE RIGIDBODY_PBD_FRICTION; ACCEPT { Tmgweight; } }

		REAL RIGIDBODY_PBD_BOUNCINESS { MIN 0.0; STEP 0.05; DEFAULT 0.0; PARENTCOLLAPSE; }
		LINK RIGIDBODY_PBD_BOUNCINESS_WEIGHTS { PARENTCOLLAPSE RIGIDBODY_PBD_BOUNCINESS; ACCEPT { Tmgweight; } }

		REAL RIGIDBODY_PBD_STICKINESS { MIN 0.0; STEP 0.05; DEFAULT 0.0; PARENTCOLLAPSE; }
		LINK RIGIDBODY_PBD_STICKINESS_WEIGHTS { PARENTCOLLAPSE RIGIDBODY_PBD_STICKINESS; ACCEPT { Tmgweight; } }

		REAL RIGIDBODY_PBD_THICKNESS { UNIT METER; MIN 0.001; STEP 0.01; DEFAULT 1.5; PARENTCOLLAPSE; }
		LINK RIGIDBODY_PBD_THICKNESS_WEIGHTS { PARENTCOLLAPSE RIGIDBODY_PBD_THICKNESS; ACCEPT { Tmgweight; } }

		LONG RIGIDBODY_PBD_COLLISION_SHAPES
		{
			ANIM OFF;
			CYCLE
			{
				RIGIDBODY_PBD_COLLISION_SHAPES_AUTO;
				RIGIDBODY_PBD_COLLISION_SHAPES_TRIANGLE_MESH;
				RIGIDBODY_PBD_COLLISION_SHAPES_CONVEX_HULLS;
				RIGIDBODY_PBD_COLLISION_SHAPES_SPHERE;
				RIGIDBODY_PBD_COLLISION_SHAPES_BOX;
			}
		}

		REAL RIGIDBODY_PBD_TRIANGLE_MESH_MARGIN { UNIT PERCENT; MIN 0.0; MAX 100; STEP 0.5; MINSLIDER 0; MAXSLIDER 100; DEFAULT 2.0; }

		LONG RIGIDBODY_PBD_COLLISION_SIDE 
		{
			CUSTOMGUI QUICKTABRADIO;
			ANIM OFF;
			CYCLE
			{
				RIGIDBODY_PBD_COLLISION_SIDE_FRONT;
				RIGIDBODY_PBD_COLLISION_SIDE_BACK;
				RIGIDBODY_PBD_COLLISION_SIDE_BOTH;
			}
		}
		REAL RIGIDBODY_PBD_CONVEXDECOMPOSITION_ACCURACY { ANIM OFF; MIN 0; MINSLIDER 0.0; MAXSLIDER 10; STEP 0.1; CUSTOMGUI REALSLIDER; }
		REAL RIGIDBODY_PBD_CONVEX_HULLS_COPLANAR_TRIANGLE_THRESHOLD { ANIM OFF; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 20.0; STEP 1; CUSTOMGUI REALSLIDER; }
		LONG RIGIDBODY_PBD_CONVEXDECOMPOSITION_MAX_VERTS_PER_CONVEXHULL { ANIM OFF; MIN 3; STEP 1; }
		LONG RIGIDBODY_PBD_INDIVIDUAL_ELEMENTS_MERGE_LEVEL { ANIM OFF; MIN 0; STEP 1; }
		BOOL RIGIDBODY_PBD_USEDEFORMEDOBJECT { ANIM OFF; }

		GROUP RIGIDBODY_LIQUID_COLLISION_GROUP
		{
			DEFAULT 1;
			LONG RIGIDBODY_LIQUID_COLLISION_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RIGIDBODY_LIQUID_COLLISION_MODE_SURFACE;
					RIGIDBODY_LIQUID_COLLISION_MODE_VOLUME;
					RIGIDBODY_LIQUID_COLLISION_MODE_OFF;
				};
			}
			LONG RIGIDBODY_LIQUID_COLLISION_FROM 
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RIGIDBODY_LIQUID_COLLISION_FROM_OUTSIDE;
					RIGIDBODY_LIQUID_COLLISION_FROM_INSIDE;
					RIGIDBODY_LIQUID_COLLISION_FROM_BOTH;
				}
			}
			
			LONG RIGIDBODY_SDF_VOXEL_SIZE_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					RIGIDBODY_SDF_VOXEL_SIZE_MODE_RELATIVE;
					RIGIDBODY_SDF_VOXEL_SIZE_MODE_ABSOLUTE;
				};
			}

			REAL RIGIDBODY_SDF_VOXEL_SIZE_ABSOLUTE { UNIT METER; MIN 0.0; STEP 0.1; PARENTCOLLAPSE; }
			LONG RIGIDBODY_SDF_VOXEL_BAND_INTERIOR_ABSOLUTE { PARENTCOLLAPSE RIGIDBODY_SDF_VOXEL_SIZE_ABSOLUTE; MIN 0; STEP 1; }
			LONG RIGIDBODY_SDF_VOXEL_BAND_EXTERIOR_ABSOLUTE { PARENTCOLLAPSE RIGIDBODY_SDF_VOXEL_SIZE_ABSOLUTE; MIN 0; STEP 1; }
			
			REAL RIGIDBODY_SDF_VOXEL_SIZE_RELATIVE { UNIT PERCENT; MIN 0.0; MINSLIDER 0.2; MAXSLIDER 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }
			LONG RIGIDBODY_SDF_VOXEL_BAND_INTERIOR_RELATIVE { PARENTCOLLAPSE RIGIDBODY_SDF_VOXEL_SIZE_RELATIVE; MIN 0; STEP 1; }
			LONG RIGIDBODY_SDF_VOXEL_BAND_EXTERIOR_RELATIVE { PARENTCOLLAPSE RIGIDBODY_SDF_VOXEL_SIZE_RELATIVE; MIN 0; STEP 1; }
		}
	}

	GROUP RIGIDBODY_PBD_MASS_GROUP
	{
		LONG RIGIDBODY_PBD_MASS_SELECTION 
		{
			ANIM OFF;
			CYCLE
			{
				RIGIDBODY_PBD_USE_CUSTOM_DENSITY;
				RIGIDBODY_PBD_USE_CUSTOM_MASS;
			}
			DEFAULT RIGIDBODY_PBD_USE_CUSTOM_DENSITY;
		}
		REAL RIGIDBODY_PBD_MASS { MIN 0.0001; STEP 0.1; DEFAULT 1.0; PARENTCOLLAPSE; }
		LINK RIGIDBODY_PBD_MASS_WEIGHTS { PARENTCOLLAPSE RIGIDBODY_PBD_MASS; ACCEPT { Tmgweight; } } 
		REAL RIGIDBODY_PBD_DENSITY { MIN 0.0001; STEP 0.1; DEFAULT 1.0; PARENTCOLLAPSE; }
		LINK RIGIDBODY_PBD_DENSITY_WEIGHTS { PARENTCOLLAPSE RIGIDBODY_PBD_DENSITY; ACCEPT { Tmgweight; } }
		REAL RIGIDBODY_PBD_ROTATIONAL_MASS { UNIT PERCENT; MIN 1.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 200.0; STEP 1; CUSTOMGUI REALSLIDER; DEFAULT 100.0; }
		BOOL RIGIDBODY_PBD_ISHOLLOW { ANIM OFF; }
		
		SEPARATOR { LINE; }
		BOOL RIGIDBODY_PBD_CUSTOM_CENTER_OF_MASS { ANIM OFF; }
		VECTOR RIGIDBODY_PBD_CENTER_OF_MASS { UNIT METER; ANIM OFF; }
	}

	GROUP RIGIDBODY_PBD_FORCES_GROUP
	{
		SCALE_V;
		REAL RIGIDBODY_PBD_FORCES_FOLLOW_POSITION_STRENGTH { ANIM ON; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }
		REAL RIGIDBODY_PBD_FORCES_FOLLOW_POSITION_DAMPING { ANIM ON; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE RIGIDBODY_PBD_FORCES_FOLLOW_POSITION_STRENGTH; }
		REAL RIGIDBODY_PBD_FORCES_FOLLOW_POSITION_RECOIL { ANIM ON; MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.1; CUSTOMGUI REALSLIDER;  PARENTCOLLAPSE RIGIDBODY_PBD_FORCES_FOLLOW_POSITION_STRENGTH; }
	
		REAL RIGIDBODY_PBD_FORCES_FOLLOW_ROTATION_STRENGTH { ANIM ON; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }
		REAL RIGIDBODY_PBD_FORCES_FOLLOW_ROTATION_DAMPING { ANIM ON; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE RIGIDBODY_PBD_FORCES_FOLLOW_ROTATION_STRENGTH; }
		REAL RIGIDBODY_PBD_FORCES_FOLLOW_ROTATION_RECOIL { ANIM ON; MINSLIDER -5.0; MAXSLIDER 5.0; STEP 0.1; CUSTOMGUI REALSLIDER;  PARENTCOLLAPSE RIGIDBODY_PBD_FORCES_FOLLOW_ROTATION_STRENGTH; }

		REAL RIGIDBODY_PBD_AERO_DRAG {ANIM ON; UNIT PERCENT; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
		REAL RIGIDBODY_PBD_AERO_LIFT {ANIM ON; UNIT PERCENT; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 100.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
		
		LONG RIGIDBODY_PBD_FORCES_INEXMODE
		{
			ANIM OFF;
			CYCLE
			{
				RIGIDBODY_PBD_FORCES_INEXMODE_INCLUDE;
				RIGIDBODY_PBD_FORCES_INEXMODE_EXCLUDE;
			}
			DEFAULT RIGIDBODY_PBD_FORCES_INEXMODE_EXCLUDE;
		}
		IN_EXCLUDE  RIGIDBODY_PBD_FORCES_INEXCLUDE
	 	{
	 		SCALE_V;
			NUM_FLAGS 1;
			INIT_STATE 1;
			SEND_SELCHNGMSG 1;
			SMALL_MODE_SIZE 80;
			BIG_MODE_SIZE 150;
			IMAGE_01_ON 300000131;
			IMAGE_01_OFF 300000130;
			ACCEPT 
			{
				Odeflector;
				Ogravitation;
				Orotation;
				Owind;
				Ofriction;
				Oturbulence;
				Oattractor; 
				Ofieldforce;
				1018544; // Cloner object
				180000103; // Oforce
			}
	 	}
		BOOL RIGIDBODY_PBD_FORCES_INEX_PYRO { DEFAULT 0; }
	}

	// GROUP RIGIDBODY_PBD_CACHE_GROUP
	// {
	// 	BOOL RIGIDBODY_PBD_CACHE_ENABLE { }

	// 	SEPARATOR { LINE; }

	// 	GROUP
	// 	{
	// 		COLUMNS 2;

	// 		BASETIME RIGIDBODY_PBD_CACHE_START { ANIM OFF; } STATICTEXT { JOINENDSCALE; }

	// 		BUTTON RIGIDBODY_PBD_DO_CALCULATE {  FIT_H; }
	// 		BUTTON RIGIDBODY_PBD_DO_CALCULATE_ALL { FIT_H; }

	// 		BUTTON RIGIDBODY_PBD_DELCACHE { FIT_H; }
	// 		BUTTON RIGIDBODY_PBD_DELCACHE_ALL { FIT_H; }

	// 		BUTTON RIGIDBODY_PBD_CACHE_FRAME {  FIT_H; }
	// 	}
	// }

	INCLUDE ocache;
}
