CONTAINER tpyro
{
	NAME tpyro;
	INCLUDE Tbase;

	GROUP ID_TAGPROPERTIES
	{
		BOOL PYRO_TAG_EMITTER_ENABLED {}
		REAL PYRO_TAG_OBJECT_VOXEL_SIZE { UNIT PERCENT; MIN 0.0; STEP 1.0; MAX 100.0; DEFAULT 2.5; CUSTOMGUI REALSLIDER; }
		LONG PYRO_TAG_SUBSTEP_MODE 
		{ 		
			CYCLE
			{
				PYRO_TAG_SUBSTEP_MODE_DISCRETE;
				PYRO_TAG_SUBSTEP_MODE_CONTINUOUS;
			}
			CUSTOMGUI QUICKTABRADIO;
		}
		BOOL PYRO_TAG_NO_REQUESTS {}
		LONG PYRO_TAG_SUBSTEPS { STEP 1; MIN 0; MAX 100; MINSLIDER 0; MAXSLIDER 10; CUSTOMGUI LONGSLIDER; }
		
		LONG PYRO_TAG_EMISSION_TYPE
		{ 
			ANIM OFF;
			CYCLE
			{
				PYRO_TAG_EMISSION_TYPE_SURFACE;
				PYRO_TAG_EMISSION_TYPE_VOLUME;
				PYRO_TAG_EMISSION_TYPE_PARTICLE;
				PYRO_TAG_EMISSION_TYPE_SURFACE_DYNAMIC;
				PYRO_TAG_EMISSION_TYPE_SURFACE_NANO;
				PYRO_TAG_EMISSION_TYPE_VOLUME_NANO;
			}
		}
		// BOOL PYRO_TAG_SURFACE_EMISSION_ENABLED { }
		REAL PYRO_TAG_SURFACE_THICKNESS { UNIT METER; MIN 0.0; MAX 10000.0; STEP 0.01; MINSLIDER 0.0001; MAXSLIDER 20.0; CUSTOMGUI REALSLIDER;  }
		REAL PYRO_TAG_EMISSION_VOXEL_FALLOFF { MIN 0.0; MAX 256.0; STEP 0.5; MINSLIDER 0.0; MAXSLIDER 16.0; CUSTOMGUI REALSLIDER; }
		
		GROUP
		{
			COLUMNS 2;
			STRING PYRO_TAG_SURFACE_WEIGHTS_GLOBAL
			{
				ACCEPT
				{
					tvertexmap;
					tvertexcolor;
					tpolygonselection;
				}
				CUSTOMGUI STRINGLINK;
				SCALE_H; 
			}
			POPUP PYRO_TAG_SURFACE_WEIGHTS_GLOBAL_POPUP { ANIM OFF; HIDDEN; }
		}

		GROUP PYRO_TAG_DENSITY_GROUP
		{
			DEFAULT 1;		
			BOOL PYRO_TAG_DENSITY_ENABLED { }
			GROUP
			{
				COLUMNS 2;
				STRING PYRO_TAG_SURFACE_WEIGHTS_DENSITY
				{
					ACCEPT
					{
						tvertexmap;
						tvertexcolor;
						tpolygonselection;
					}
					CUSTOMGUI STRINGLINK;
					SCALE_H; 
				}
				POPUP PYRO_TAG_SURFACE_WEIGHTS_DENSITY_POPUP { ANIM OFF; HIDDEN; }
			}
			REAL PYRO_TAG_DENSITY_MIN { STEP 0.1; MIN 0.0; MAX 50000.0; MINSLIDER 0.0; MAXSLIDER 2.0; CUSTOMGUI REALSLIDER; }
			REAL PYRO_TAG_DENSITY_ADD { STEP 1.0; MINSLIDER 0.0; MAXSLIDER 50.0; CUSTOMGUI REALSLIDER; }
		}			
		GROUP PYRO_TAG_COLOR_GROUP
		{
			DEFAULT 1;		
			BOOL PYRO_TAG_DENSITY_COLOR_ENABLED {  }
			GROUP
			{
				COLUMNS 2;
				STRING PYRO_TAG_SURFACE_WEIGHTS_COLOR
				{
					ACCEPT
					{
						tvertexmap;
						tvertexcolor;
						tpolygonselection;
					}
					CUSTOMGUI STRINGLINK;
					SCALE_H; 
				}
				POPUP PYRO_TAG_SURFACE_WEIGHTS_COLOR_POPUP { ANIM OFF; HIDDEN; }
			}
			COLOR PYRO_TAG_DENSITY_COLOR {}
			REAL PYRO_TAG_DENSITY_COLOR_ALPHA { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			BOOL PYRO_TAG_DENSITY_COLOR_SET {}
		}
		GROUP PYRO_TAG_TEMPERATURE_GROUP
		{
			DEFAULT 1;
			BOOL PYRO_TAG_TEMPERATURE_ENABLED { }
			GROUP
			{
				COLUMNS 2;
				STRING PYRO_TAG_SURFACE_WEIGHTS_TEMPERATURE
				{
					ACCEPT
					{
						tvertexmap;
						tvertexcolor;
						tpolygonselection;
					}
					CUSTOMGUI STRINGLINK;
					SCALE_H; 
				}
				POPUP PYRO_TAG_SURFACE_WEIGHTS_TEMPERATURE_POPUP { ANIM OFF; HIDDEN; }
			}
			REAL PYRO_TAG_TEMPERATURE_MIN { STEP 10.0; MIN 0.0; MAX 50000.0; MINSLIDER 0.0; MAXSLIDER 8000.0; CUSTOMGUI REALSLIDER; }
			REAL PYRO_TAG_TEMPERATURE_ADD { STEP 10.0; MINSLIDER 0.0; MAXSLIDER 4000.0; CUSTOMGUI REALSLIDER; }
		}

		GROUP PYRO_TAG_FUEL_GROUP
		{
			DEFAULT 0;
			BOOL PYRO_TAG_FUEL_ENABLED {  }
			GROUP
			{
				COLUMNS 2;
				STRING PYRO_TAG_SURFACE_WEIGHTS_FUEL
				{
					ACCEPT
					{
						tvertexmap;
						tvertexcolor;
						tpolygonselection;
					}
					CUSTOMGUI STRINGLINK;
					SCALE_H; 
				}
				POPUP PYRO_TAG_SURFACE_WEIGHTS_FUEL_POPUP { ANIM OFF; HIDDEN; }
			}
			LONG PYRO_TAG_FUEL_TYPE
			{
				CYCLE
				{
					PYRO_TAG_FUEL_TYPE_CONTINUOUS;
					PYRO_TAG_FUEL_TYPE_ONESHOT;
					PYRO_TAG_FUEL_TYPE_CONTINGENT;
				}
			}
			REAL PYRO_TAG_FUEL_MIN { STEP 0.1; MINSLIDER 0.0; MAXSLIDER 20.0; CUSTOMGUI REALSLIDER; }
			REAL PYRO_TAG_FUEL_ADD { STEP 0.1; MINSLIDER 0.0; MAXSLIDER 50.0; CUSTOMGUI REALSLIDER; }	
			BOOL PYRO_TAG_FUEL_MATCH_BURNING_RATE { }	
			BOOL PYRO_TAG_FUEL_CONSTANT_PRESSURE { }	
			REAL PYRO_TAG_FUEL_BURNING_RATE { STEP 0.1; MIN 0.0; MAX 1000.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			REAL PYRO_TAG_FUEL_INITIAL_CONTINGENT { ANIM OFF; STEP 0.01; MIN 0.0; MAX 1000.0; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
			LONG PYRO_TAG_FUEL_TARGET_FRAME { STEP 1; MIN 0; }
			LONG PYRO_TAG_FUEL_TARGET_FRAME_END { STEP 1; MIN 0; }
		}
		
		GROUP PYRO_TAG_VELOCITY_GROUP
		{
			DEFAULT 0;
			BOOL PYRO_TAG_VELOCITY_ENABLED {}
			LONG PYRO_TAG_VELOCITY_TYPE
			{
				CYCLE
				{
					PYRO_TAG_VELOCITY_TYPE_ADD;
					PYRO_TAG_VELOCITY_TYPE_ABSOLUTE;
					PYRO_TAG_VELOCITY_TYPE_DIRECTION;
					PYRO_TAG_VELOCITY_TYPE_MOVEMENT;
				}
			}
			REAL PYRO_TAG_VELOCITY_STRENGTH { STEP 0.01; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			VECTOR PYRO_TAG_VELOCITY_DIRECTION { MIN -100.0; MAX 100.0; STEP 0.01; }
			LONG PYRO_TAG_VELOCITY_SPACE 
			{ 		
				CYCLE
				{
					PYRO_TAG_VELOCITY_SPACE_LOCAL;
					PYRO_TAG_VELOCITY_SPACE_GLOBAL;
				}
				CUSTOMGUI QUICKTABRADIO;
			}
			BOOL PYRO_TAG_VELOCITY_SPACE_CUSTOM_NORMAL { }
		}
		GROUP PYRO_TAG_DIVERGENCE_CONTROL_GROUP
		{
			// BOOL PYRO_TAG_DIVERGENCE_CONTROL_ENABLED {}
			REAL PYRO_TAG_DIVERGENCE_CONTROL_STRENGTH { STEP 1.0; MINSLIDER -100.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PYRO_TAG_NOISE
		{
			DEFAULT 1;
			BOOL PYRO_TAG_NOISE_ENABLED { }
			LONG PYRO_TAG_NOISE_SCALE_SEED { STEP 1; }
			LONG PYRO_TAG_NOISE_MODE
			{
				CYCLE
				{
					PYRO_TAG_NOISE_MODE_BOX;
					PYRO_TAG_NOISE_MODE_BLISTEREDTURBULENCE;
					PYRO_TAG_NOISE_MODE_BUYA;
					PYRO_TAG_NOISE_MODE_CELL;
					PYRO_TAG_NOISE_MODE_CRANAL;
					PYRO_TAG_NOISE_MODE_DENTS;
					PYRO_TAG_NOISE_MODE_DISPLACEDTURBULENCE;
					PYRO_TAG_NOISE_MODE_ELECTRIC;
					PYRO_TAG_NOISE_MODE_GASEOUS;
					PYRO_TAG_NOISE_MODE_HAMA;
					PYRO_TAG_NOISE_MODE_LUKA;
					PYRO_TAG_NOISE_MODE_MOD;
					PYRO_TAG_NOISE_MODE_NAKI;
					PYRO_TAG_NOISE_MODE_NUTOUS;
					PYRO_TAG_NOISE_MODE_OBER;
					PYRO_TAG_NOISE_MODE_PERLIN;
					PYRO_TAG_NOISE_MODE_PEZO;
					PYRO_TAG_NOISE_MODE_POXO;
					PYRO_TAG_NOISE_MODE_SEMA;
					PYRO_TAG_NOISE_MODE_STUPL;
					PYRO_TAG_NOISE_MODE_TURBULENCE;
					PYRO_TAG_NOISE_MODE_VL;
					PYRO_TAG_NOISE_MODE_WAVYTURBULENCE;
					PYRO_TAG_NOISE_MODE_ZADA;
				};
			}
			LONG PYRO_TAG_NOISE_SPACE 
			{ 		
				CYCLE
				{
					PYRO_TAG_NOISE_SPACE_LOCAL;
					PYRO_TAG_NOISE_SPACE_GLOBAL;
				}
				CUSTOMGUI QUICKTABRADIO;
			}
			REAL PYRO_TAG_NOISE_OCTAVES { MIN 1.0; MAX 20.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 10.0; }
			VECTOR PYRO_TAG_NOISE_GLOBAL_SCALE { UNIT PERCENT; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; }
			REAL PYRO_TAG_NOISE_SCALE { UNIT PERCENT; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; }
			REAL PYRO_TAG_NOISE_FREQUENCY { STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; }
			REAL PYRO_TAG_NOISE_LOOP_PERIOD { MIN 0.0; STEP 1.0; }
			BOOL PYRO_TAG_NOISE_UNIFORM { }
			SEPARATOR { LINE; }
			VECTOR PYRO_TAG_NOISE_MOVEMENT { UNIT METER; STEP 1.0; }
			REAL PYRO_TAG_NOISE_SPEED { UNIT PERCENT; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; }
			SEPARATOR { LINE; }
			REAL PYRO_TAG_NOISE_MIN { UNIT PERCENT; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			REAL PYRO_TAG_NOISE_MAX { UNIT PERCENT; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			REAL PYRO_TAG_NOISE_BRIGHTNESS { UNIT PERCENT; STEP 1.0; MINSLIDER -100.0; MAXSLIDER 100.0; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			REAL PYRO_TAG_NOISE_CONTRAST { UNIT PERCENT; STEP 1.0; MINSLIDER -100.0; MAXSLIDER 100.0; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }			
		}
	}
}
