CONTAINER temitter
{
	NAME temitter;
	INCLUDE Tbase;

	GROUP Obaselist
	{
	  PRIORITY EMITTER_PBD_SIMULATION_PRIORITY { ANIM OFF; NOCAMERA; }
	  BOOL EMITTER_PBD_USE { }
	}

	GROUP EMITTER_PBD_TAG_GROUP
	{
		DEFAULT 1;
		
		REAL EMITTER_PBD_MASS_DENSITY { MIN 0.0; STEP 1; ANIM OFF; } 
		REAL EMITTER_PBD_MASS { DEFAULT 1.0; MIN 0.0001; STEP 0.1; ANIM OFF; } 
		REAL EMITTER_PBD_RADIUS { ANIM OFF; UNIT METER; DEFAULT 1.5; MIN 0.0001; STEP 0.1; PARENTCOLLAPSE; }
		REAL EMITTER_PBD_RADIUS_VARIANCE { ANIM OFF; DEFAULT 0.0; MIN 0.0; UNIT METER; PARENTCOLLAPSE EMITTER_PBD_RADIUS; }
		REAL EMITTER_PBD_VISCOSITY { MIN 0.0; STEP 0.01; MAX 1.0; ANIM OFF; } 
		LONG EMITTER_PBD_PHASE { MIN 0; ANIM OFF; }

		LONG EMITTER_PBD_TYPE
		{
			ANIM OFF;
			CYCLE	
			{
				EMITTER_PBD_TYPE_FREE;
				EMITTER_PBD_TYPE_LIQUID;
				EMITTER_PBD_TYPE_GRAINS;
			}
			DEFAULT EMITTER_PBD_TYPE_LIQUID;
		}

		GROUP EMITTER_PBD_LIQUID_GROUP
		{
			DEFAULT 1;
		}

		GROUP EMITTER_PBD_LIFETIME_GROUP
		{
			DEFAULT 1;
			BOOL EMITTER_PBD_LIFETIME_INFINITE_TIME { }
			BASETIME EMITTER_PBD_LIFETIME_EXPECTATION { MIN 0; PARENTCOLLAPSE; }
			BASETIME EMITTER_PBD_LIFETIME_VARIANCE { MIN 0; PARENTCOLLAPSE EMITTER_PBD_LIFETIME_EXPECTATION; }
			BOOL EMITTER_PBD_LIFETIME_INFINITE_DISTANCE { }
			REAL EMITTER_PBD_MAXTRAVELED { UNIT METER; MIN 0.0; STEP 1.0; PARENTCOLLAPSE; }
			REAL EMITTER_PBD_MAXTRAVELED_VARIANCE { MIN 0.0; STEP 1.0; UNIT METER; PARENTCOLLAPSE EMITTER_PBD_MAXTRAVELED; }
		}

		GROUP EMITTER_PBD_DAMPING_GROUP
		{
			DEFAULT 0;
			BOOL EMITTER_PBD_DAMPING_OVERRIDE { }
			REAL EMITTER_PBD_DAMPING  { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		}
	}

	GROUP EMITTER_PBD_COLLISION_GROUP
	{
		REAL EMITTER_PBD_FRICTION { MIN 0.0; STEP 0.1; } 
		REAL EMITTER_PBD_BOUNCINESS { MIN 0.0; STEP 0.05; } 
		REAL EMITTER_PBD_STICKINESS { MIN 0.0; STEP 0.05; } 
	}

	GROUP EMITTER_PBD_EMISSION_GROUP
	{
		DEFAULT 1;
		BOOL EMITTER_PBD_EMISSION_ENABLE { }

		LONG EMITTER_PBD_EMISSION_FROM 
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				EMITTER_PBD_EMISSION_FROM_POINTS;	
				EMITTER_PBD_EMISSION_FROM_SURFACE;
				EMITTER_PBD_EMISSION_FROM_VOLUME;
			}
			DEFAULT EMITTER_PBD_EMISSION_FROM_SURFACE;
		}

		LONG EMITTER_PBD_EMISSION_MODE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				EMITTER_PBD_EMISSION_MODE_SHOT;	
				EMITTER_PBD_EMISSION_MODE_CONSTANT;
				EMITTER_PBD_EMISSION_MODE_PULSE;
			}
			DEFAULT EMITTER_PBD_EMISSION_MODE_SHOT;
		}

		LONG EMITTER_PBD_EMISSION_RATE { MIN 1; ANIM ON; }
		LONG EMITTER_PBD_EMISSION_SEED { MIN 0; ANIM ON; }	

		GROUP EMITTER_PBD_INITIALVELOCITY_GROUP
		{
			DEFAULT 1;
			REAL EMITTER_PBD_INITIALVELOCITY_SPEED { DEFAULT 100.0; UNIT METER; FORBID_SCALING; PARENTCOLLAPSE; }
			REAL EMITTER_PBD_INITIALVELOCITY_SPEED_VARIATION { DEFAULT 0; UNIT METER; FORBID_SCALING; PARENTCOLLAPSE EMITTER_PBD_INITIALVELOCITY_SPEED; }
			REAL EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY { PARENTCOLLAPSE; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
			REAL EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY_LINEAR { PARENTCOLLAPSE EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
			REAL EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY_ANGULAR { PARENTCOLLAPSE EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
		}
	}

	GROUP EMITTER_PBD_FORCES_GROUP
	{
		SCALE_V;
		LONG EMITTER_PBD_FORCES_INEXMODE
		{
			ANIM OFF;
			CYCLE
			{
				EMITTER_PBD_FORCES_INEXMODE_INCLUDE;
				EMITTER_PBD_FORCES_INEXMODE_EXCLUDE;
			}
			DEFAULT EMITTER_PBD_FORCES_INEXMODE_EXCLUDE;
		}
		IN_EXCLUDE  EMITTER_PBD_FORCES_INEXCLUDE
	 	{
	 		SCALE_V;
			NUM_FLAGS 1;
			INIT_STATE 1;
			SEND_SELCHNGMSG 1;
			SMALL_MODE_SIZE 80;
			BIG_MODE_SIZE 150;
			IMAGE_01_ON 300000131;
			IMAGE_01_OFF 300000130;
			ACCEPT 
			{
				Odeflector;
				Ogravitation;
				Orotation;
				Owind;
				Ofriction;
				Oturbulence;
				Oattractor; 
				Ofieldforce;
			}
	 	}
		BOOL EMITTER_PBD_FORCES_INEX_PYRO { }
	}

	GROUP EMITTER_PBD_CACHE_GROUP
	{
		BOOL EMITTER_PBD_CACHE_ENABLE { }

		SEPARATOR { LINE; }

		GROUP
		{
			COLUMNS 2;

			BASETIME EMITTER_PBD_CACHE_START { ANIM OFF; } STATICTEXT { JOINENDSCALE; }

			BUTTON EMITTER_PBD_DO_CALCULATE {  FIT_H; }
			BUTTON EMITTER_PBD_DO_CALCULATE_ALL { FIT_H; }

			BUTTON EMITTER_PBD_DELCACHE { FIT_H; }
			BUTTON EMITTER_PBD_DELCACHE_ALL { FIT_H; }

			BUTTON EMITTER_PBD_CACHE_FRAME {  FIT_H; }
		}
	}

	GROUP EMITTER_PBD_DRAW_GROUP
	{
		BOOL EMITTER_PBD_DRAW { ANIM OFF; }
		BOOL EMITTER_PBD_DRAW_RADIUS { ANIM OFF; }
		BOOL EMITTER_PBD_DRAW_VELOCITY { ANIM OFF; }
		BOOL EMITTER_PBD_DRAW_VELOCITY_NORMALIZED { ANIM OFF; }

		GROUP EMITTER_PBD_COLORS_GROUP
		{
			DEFAULT 0;
			LONG EMITTER_PBD_COLORS_MODE
			{
				CYCLE
				{
					EMITTER_PBD_COLORS_MODE_CONSTANT;
					EMITTER_PBD_COLORS_MODE_DIRECTION;
					EMITTER_PBD_COLORS_MODE_MAP;
				}
				DEFAULT EMITTER_PBD_COLORS_MODE_CONSTANT;
			}
			COLOR EMITTER_PBD_COLORS_CONSTANT { }
			STRING EMITTER_PBD_COLORS_MAP { }
		}
	}
}
