#ifndef TEMITTER_H__
#define TEMITTER_H__

enum
{
	EMITTER_PBD_USE = 1000,
	// Main Params
	EMITTER_PBD_TAG_GROUP = 1001,
	EMITTER_PBD_MASS = 1002, 
	EMITTER_PBD_FRICTION = 1003,
	EMITTER_PBD_BOUNCINESS = 1004,
	EMITTER_PBD_STICKINESS = 1005,
	EMITTER_PBD_TYPE = 1006, 
		EMITTER_PBD_TYPE_FREE = 0,
		EMITTER_PBD_TYPE_LIQUID = 1,
		EMITTER_PBD_TYPE_GRAINS = 2,
	EMITTER_PBD_RADIUS = 1007, 
	EMITTER_PBD_RADIUS_VARIANCE = 1008, 
	EMITTER_PBD_LIFETIME_EXPECTATION = 1009, 
	EMITTER_PBD_LIFETIME_VARIANCE = 1010, 
	EMITTER_PBD_DAMPING_GROUP = 1011,
	EMITTER_PBD_DAMPING_OVERRIDE = 1012,
	EMITTER_PBD_DAMPING = 1013, 
  EMITTER_PBD_MAXTRAVELED = 1014,
  EMITTER_PBD_MAXTRAVELED_VARIANCE = 1015,
	EMITTER_PBD_LIFETIME_GROUP = 1016,
	EMITTER_PBD_LIFETIME_INFINITE_TIME = 1017,
	EMITTER_PBD_LIFETIME_INFINITE_DISTANCE = 1018,
	EMITTER_PBD_COLLISION_GROUP = 1019,
	EMITTER_PBD_LIQUID_GROUP = 1020,
	EMITTER_PBD_MASS_DENSITY = 1021,
	EMITTER_PBD_VISCOSITY = 1022,
	EMITTER_PBD_PHASE = 1023,
	// Forces
	EMITTER_PBD_FORCES_GROUP = 2001,
	EMITTER_PBD_FORCES_INEXCLUDE = 2002,
	EMITTER_PBD_FORCES_INEXMODE = 2003,
		EMITTER_PBD_FORCES_INEXMODE_INCLUDE = 0,
		EMITTER_PBD_FORCES_INEXMODE_EXCLUDE = 1,
	EMITTER_PBD_FORCES_INEX_PYRO = 2004,
	// Cache & others
	EMITTER_PBD_CACHE_GROUP = 3001,
	EMITTER_PBD_CACHE_ENABLE = 3002,
	EMITTER_PBD_CACHE_START = 3003,
	EMITTER_PBD_DO_CALCULATE = 3004,
	EMITTER_PBD_DO_CALCULATE_ALL = 3005,
	EMITTER_PBD_DELCACHE = 3006,
	EMITTER_PBD_DELCACHE_ALL = 3007,
	EMITTER_PBD_CACHE_FRAME = 3008,
	EMITTER_PBD_CACHE_INFO1 = 3009,
	EMITTER_PBD_CACHE_INFO2 = 3010,
	EMITTER_PBD_START = 3011, 
	EMITTER_PBD_STOP = 3012, 
	EMITTER_PBD_AUTOTIME = 3013, 
	EMITTER_PBD_SIMULATION_PRIORITY = 3014, // priority
	// Emission
	EMITTER_PBD_EMISSION_GROUP	= 4001,
	EMITTER_PBD_EMISSION_ENABLE = 4002,
	EMITTER_PBD_EMISSION_FROM		= 4003,
		EMITTER_PBD_EMISSION_FROM_POINTS	= 0,
		EMITTER_PBD_EMISSION_FROM_SURFACE	= 1,
		EMITTER_PBD_EMISSION_FROM_VOLUME	= 2,
	EMITTER_PBD_EMISSION_MODE = 4004,
		EMITTER_PBD_EMISSION_MODE_SHOT			= 0,
		EMITTER_PBD_EMISSION_MODE_CONSTANT	= 1,
		EMITTER_PBD_EMISSION_MODE_PULSE			= 2,
	EMITTER_PBD_EMISSION_RATE = 4005,
	EMITTER_PBD_EMISSION_SEED = 4006,
	// INITIAL VELOCITY
	EMITTER_PBD_INITIALVELOCITY_GROUP = 7000,
	EMITTER_PBD_INITIALVELOCITY_SPEED = 7001,
	EMITTER_PBD_INITIALVELOCITY_SPEED_VARIATION = 7002,
	EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY = 7003,
	EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY_LINEAR = 7004,
	EMITTER_PBD_INITIALVELOCITY_ADDSOURCEVELOCITY_ANGULAR = 7005,

	// Colors
	EMITTER_PBD_COLORS_GROUP = 8000,
	EMITTER_PBD_COLORS_MODE = 8001,
		EMITTER_PBD_COLORS_MODE_CONSTANT = 0,
		EMITTER_PBD_COLORS_MODE_DIRECTION = 1,
		EMITTER_PBD_COLORS_MODE_MAP = 2,
	EMITTER_PBD_COLORS_CONSTANT = 8002,
	EMITTER_PBD_COLORS_MAP = 8003,
	// Draw
	EMITTER_PBD_DRAW_GROUP = 5001,
	EMITTER_PBD_DRAW = 5002,
	EMITTER_PBD_DRAW_RADIUS = 5003,
	EMITTER_PBD_DRAW_VELOCITY = 5004,
		EMITTER_PBD_DRAW_VELOCITY_NORMALIZED = 5005,

	EMITTER_PBD_TAG_DUMMY
};

#endif // TEMITTER_H__
