CONTAINER opbdscene
{
	NAME opbdscene;
	INCLUDE Obase;

	GROUP PBDSCENE_GROUP_SCENEPROPERTIES
	{
		LONG PBDSCENE_DEVICE
		{
			ANIM OFF;
			CYCLE
			{
				PBDSCENE_DEVICE_CPU;
				PBDSCENE_DEVICE_GPU;
			}
			CUSTOMGUI QUICKTABRADIO;
		}
		LONG PBDSCENE_COMPUTE_DEVICE_GPU
		{
			ANIM OFF;
			CYCLE
			{
			}
		}
		REAL PBDSCENE_DEFAULTGRAVITY { UNIT METER; STEP 1.0; }
		REAL PBDSCENE_AIR_DENSITY { STEP 0.1; MIN 0.0; }
		REAL PBDSCENE_TIMESCALE { STEP 0.1; MIN 0.001; }
		REAL PBDSCENE_SCENESCALE { ANIM OFF; UNIT METER; STEP 1.0; MIN 0.01; }
		BOOL PBDSCENE_EVALUATEBEFOREGENERATORS { }
		BOOL PBDSCENE_USEDOCUMENT_RANGE { ANIM OFF; DEFAULT 1; }
		LONG PBDSCENE_SIMULATION_FROM { ANIM OFF; STEP 1; }
		LONG PBDSCENE_SIMULATION_TO { ANIM OFF; STEP 1; }
		SEPARATOR { LINE; }
		STATICTEXT IDS_PYRO_STATS_STRING_2 { ANIM OFF; SCALE_H; }
		STATICTEXT IDS_PYRO_STATS_STRING_1 { ANIM OFF; SCALE_H; }
		REAL PBDSCENE_INITIAL_ALLOCATION_MULTIPLIER { ANIM OFF; UNIT PERCENT; MIN 10.0; MAX 100000.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 200.0; DEFAULT 100; CUSTOMGUI REALSLIDER; }
		SEPARATOR { LINE; }
		SEPARATOR { LINE; }
		IN_EXCLUDE PBDSCENE_ELEMENTS
		{
			NUM_FLAGS 1;
			INIT_STATE 1;
			SEND_SELCHNGMSG 1;
			SMALL_MODE_SIZE 80;
			BIG_MODE_SIZE 150;
			IMAGE_01_ON 300000131;
			IMAGE_01_OFF 300000130;
			ACCEPT 
			{
				100004020; // CLOTH_TAG_ID
				100004021; // COLLIDER_TAG_ID
				100004022; // BELT_TAG_ID
				1017326; // HAIR_COLLIDER_TAG_ID
				1018068; // HAIR_SPLINE_DYNAMICS_TAG_ID
				1018074; // HAIR_CONSTRAINT_TAG_ID
				1058895; // ID_PBDCONSTRAINTTAG
				1059387; // ID_PYROTAG
				1060030; // ID_EMITTERTAG
				1059981; // ID_RIGIDBODYTAG
				1060887; // Ofpgroup
				1061200; // Ofpbasicemitter
				1062577; // Ofpmeshemitter
				1062564; // Ofpsplineemitter
				1066159; // Ofpliquidhoseemitter
			}
			REFUSE { }
		}

		IN_EXCLUDE PBDSCENE_FORCES
		{
			NUM_FLAGS 1;
			INIT_STATE 1;
			SEND_SELCHNGMSG 1;
			SMALL_MODE_SIZE 80;
			BIG_MODE_SIZE 150;
			IMAGE_01_ON 300000131;
			IMAGE_01_OFF 300000130;
			ACCEPT 
			{
				Odeflector;
				Ogravitation;
				Orotation;
				Owind;
				Ofriction;
				Oturbulence;
				Oattractor; 
				Ofieldforce;
				Odestructor;
				1018544; // Cloner object
				180000103; // Oforce
			}
			REFUSE { }
		}

		IN_EXCLUDE PBDSCENE_RIGIDBODY_JOINTS
		{
			NUM_FLAGS 1;
			INIT_STATE 1;
			SEND_SELCHNGMSG 1;
			SMALL_MODE_SIZE 80;
			BIG_MODE_SIZE 150;
			IMAGE_01_ON 300000131;
			IMAGE_01_OFF 300000130;
			ACCEPT 
			{
				180000011; // Oconnectorconstraint
			}
			REFUSE { }
		}
	}
	GROUP PBDSCENE_GROUP_XPBDPROPERTIES
	{
		DEFAULT 1;
		LONG PBDSCENE_SUBSTEPS { MIN 1; MAX 200; STEP 1; MINSLIDER 1; MAXSLIDER 100; DEFAULT 40;}
		LONG PBDSCENE_CONSTRAINTSOLVER
		{
			ANIM OFF;
			CYCLE
			{
				PBDSCENE_CONSTRAINTSOLVER_JACOBI;
				PBDSCENE_CONSTRAINTSOLVER_GAUSSSEIDEL;
				PBDSCENE_CONSTRAINTSOLVER_GAUSSSEIDELVIVACE;
			}
		}
		LONG PBDSCENE_ITERATIONS { MIN 0; MAX 1000; STEP 1; MINSLIDER 1; MAXSLIDER 100; DEFAULT 1; }
		LONG PBDSCENE_SMOOTHINGITERATIONS { MIN 0; MAX 1000; STEP 1; MINSLIDER 1; MAXSLIDER 100; DEFAULT 0;}
		REAL PBDSCENE_DAMPING { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 5; CUSTOMGUI REALSLIDER; }
		LONG PBDSCENE_VELOCITYCLAMP
		{
			CYCLE
			{
				PBDSCENE_VELOCITYCLAMP_OFF;
				PBDSCENE_VELOCITYCLAMP_SCENESCALE;
				PBDSCENE_VELOCITYCLAMP_ABSOLUTE;
				PBDSCENE_VELOCITYCLAMP_RADIUS;
			}
		}
		REAL PBDSCENE_VELOCITYCLAMP_SCENESCALE_VALUE { UNIT PERCENT; MIN 0.0; MAX 300.0; STEP 5.0; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 10.0; CUSTOMGUI REALSLIDER; }
		REAL PBDSCENE_VELOCITYCLAMP_ABSOLUTE_VALUE { UNIT METER; MIN 0.0; STEP 5.0; }
		REAL PBDSCENE_VELOCITYCLAMP_RADIUS_VALUE { UNIT PERCENT; MIN 0.0; MAX 300.0; STEP 5.0; MINSLIDER 0.0; MAXSLIDER 200.0; DEFAULT 10.0; CUSTOMGUI REALSLIDER; }
		LONG PBDSCENE_ACCELERATIONCLAMP
		{
			CYCLE
			{
				PBDSCENE_ACCELERATIONCLAMP_OFF;
				PBDSCENE_ACCELERATIONCLAMP_SCENESCALE;
				// PBDSCENE_ACCELERATIONCLAMP_ABSOLUTE;
			}
		}
		REAL PBDSCENE_ACCELERATIONCLAMP_SCENESCALE_VALUE { UNIT PERCENT; MIN 0.0; MAX 300.0; STEP 5.0; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 10.0; CUSTOMGUI REALSLIDER; }
		REAL PBDSCENE_ACCELERATIONCLAMP_ABSOLUTE_VALUE { UNIT METER; MIN 0.0; STEP 1000.0; MINSLIDER 0.0; MAXSLIDER 20000; CUSTOMGUI REALSLIDER; }

		GROUP PBDSCENE_COLLISIONGROUP
		{
			DEFAULT 1;
			LONG PBDSCENE_COLLISIONPASSES { ANIM OFF; MIN 0; MAX 1000; STEP 1; MINSLIDER 0; MAXSLIDER 100; DEFAULT 1; }
			LONG PBDSCENE_POLISHITERATIONS { MIN 0; MAX 100; STEP 1; MINSLIDER 0; MAXSLIDER 100; DEFAULT 0; }
			BOOL PBDSCENE_POSTCOLLISIONPASSES { ANIM OFF; }

			SEPARATOR { LINE; }

			BOOL PBDSCENE_BIAS_DYNAMICS { ANIM OFF; }
			LONG PBDSCENE_BIAS_DYNAMICS_CONTACT_TYPE 
			{
				CUSTOMGUI QUICKTABRADIO;
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_BIAS_DYNAMICS_CONTACT_TYPE_COLLIDER;
					PBDSCENE_BIAS_DYNAMICS_CONTACT_TYPE_ALL;
				}
			}
			BOOL PBDSCENE_BIAS_DYNAMICS_COLLIDERS_ONLY {}

			SEPARATOR { LINE; }

			LONG PBDSCENE_COLLISION_PRIORITY_MODE 
			{
				CUSTOMGUI QUICKTABRADIO;
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_COLLISION_PRIORITY_NONE;
					PBDSCENE_COLLISION_PRIORITY_COLLIDERS;
					PBDSCENE_COLLISION_PRIORITY_DYNAMIC_OBJECTS;
				}
			}

			LONG PBDSCENE_COLLISION_PRIORITY_SOLVE
			{
				CUSTOMGUI QUICKTABRADIO;
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_COLLISION_PRIORITY_SPLIT_AVERAGE;
					PBDSCENE_COLLISION_PRIORITY_EXTRA_PASS;
					PBDSCENE_COLLISION_PRIORITY_SEQUENTIAL;
				}
			}
			REAL PBDSCENE_COLLISION_PRIORITY_SPLIT_AVERAGE_WEIGHT { UNIT PERCENT; MIN 50.0; MAX 95.0; STEP 1.0; MINSLIDER 50.0; MAXSLIDER 95.0; DEFAULT 50.0; CUSTOMGUI REALSLIDER; }

			SEPARATOR { LINE; }

			REAL PBDSCENE_COLLISION_NOISE { UNIT PERCENT; MIN 0.0; MAX 100; STEP 0.5; MINSLIDER 0; MAXSLIDER 100; DEFAULT 0.5; }
		}

		GROUP PBDSCENE_COLLISIONEXPERIMENTALGROUP
		{
			DEFAULT 1;

			REAL PBDSCENE_COLLISION_NOISE_RESTITUTION { UNIT PERCENT; MIN 0.0; MAX 100; STEP 0.5; MINSLIDER 0; MAXSLIDER 100; DEFAULT 0.0; }

			SEPARATOR { LINE; }

			REAL PBDSCENE_BIAS_DYNAMICS_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			BOOL PBDSCENE_BIAS_DYNAMICS_VELOCITY {}
			BOOL PBDSCENE_BIAS_DYNAMICS_RIGIDBODY_ROTATION {}

			SEPARATOR { LINE; }
		}

		GROUP PBDSCENE_PRESTABILIZATION_GROUP
		{
			DEFAULT 1;
			LONG PBDSCENE_PRESTABILIZATION_PASSES { MIN 0; MAX 1000; STEP 1; MINSLIDER 0; MAXSLIDER 100; DEFAULT 0; }
			LONG PBDSCENE_PRESTABILIZATION_ITERATIONS { MIN 0; MAX 1000; STEP 1; MINSLIDER 0; MAXSLIDER 100; DEFAULT 0; }
		}		
		GROUP PBDSCENE_DRAW_GROUP
		{
			DEFAULT 1;
			BOOL PBDSCENE_DRAW { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_PARTICLES { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_COLLISIONRADIUS { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_ROPE_ORIENTATIONS { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_EDGES { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_TRIANGLEBEND { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_STRUTS { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_CONNECTORS { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_CENTERS { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_SHAPES_VERTICES { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_SHAPES { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_SHAPES_TRIANGLES { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_SHAPES_AABBS { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_SHAPES_SPHERES { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_CONTACTS { ANIM OFF; DEFAULT 0; }
			BOOL PBDSCENE_DRAW_RIGIDBODY_COPLANAR_PATCHES { ANIM OFF; DEFAULT 0; }
			LONG PBDSCENE_DRAW_HISTORY { ANIM OFF; MIN 0; MAX 100; STEP 1; MINSLIDER 0; MAXSLIDER 100; DEFAULT 0; CUSTOMGUI LONGSLIDER; }
		}
	}
	GROUP PBDSCENE_GROUP_PYROPROPERTIES
	{
		BUTTON 	PBDSCENE_PYRO_CREATEOUTPUT {}
		REAL PBDSCENE_PYRO_VOXELSIZE { UNIT METER; ANIM OFF; MIN 0.001; STEP 0.01; MINSLIDER 0.01; MAXSLIDER 20.0; DEFAULT 5.0; }	
		REAL PBDSCENE_PYRO_MASS { MIN 0.0; STEP 0.01; MINSLIDER 0.01; MAXSLIDER 1.0; DEFAULT 0.1; }	
		LONG PBDSCENE_PYRO_SUBSTEPS { MIN 0; MAX 256; STEP 1; MINSLIDER 0; MAXSLIDER 8; DEFAULT 0; }
		LONG PBDSCENE_PYRO_MAX_SUBSTEPS { MIN 0; MAX 256; STEP 1; MINSLIDER 0; MAXSLIDER 16; DEFAULT 0; }
		REAL PBDSCENE_PYRO_CFL_CONDITION { MIN 1.0; STEP 0.5; MINSLIDER 1.0; MAXSLIDER 18.0; DEFAULT 0.1; }	
		LONG PBDSCENE_PYRO_FORCE_SAMPLES { MIN 1; MAX 32; STEP 1; MINSLIDER 0; MAXSLIDER 32; DEFAULT 1; }
		LONG PBDSCENE_PYRO_FIELD_FORCE_SAMPLES { MIN 1; MAX 32; STEP 1; MINSLIDER 0; MAXSLIDER 32; DEFAULT 1; }
		LINK PBDSCENE_PYRO_INIT_VOLUME_SET
		{
			ANIM OFF;
			ACCEPT
			{
				1059580; // Opyro;
				1039867; // Ovolumeset
				1039859; // Ovolumebuilder
				1039858; // Ovolume
			}
		}
		BUTTON PBDSCENE_PYRO_CREATEINITIALSTATE {}		
		// GROUP PBDSCENE_PYRO_UPRES_GROUP
		// {
		// 	BOOL PBDSCENE_PYRO_UPRES_ENABLED { ANIM OFF; DEFAULT 0; }
		// 	LONG PBDSCENE_PYRO_UPRES_FACTOR { ANIM OFF; MIN 2; MAX 8; STEP 1; MINSLIDER 2; MAXSLIDER 4; DEFAULT 1; CUSTOMGUI LONGSLIDER; }
		// 	LONG PBDSCENE_PYRO_UPRES_ADDITIONAL_OCTAVES { ANIM OFF; MIN 0; MAX 4; STEP 1; MINSLIDER 1; MAXSLIDER 4; DEFAULT 0; }
		// 	REAL PBDSCENE_PYRO_UPRES_NOISE_STRENGTH { MIN 0.0; STEP 0.01; MINSLIDER 0.01; MAXSLIDER 2.0; DEFAULT 0.35; CUSTOMGUI REALSLIDER; }	
		// 	REAL PBDSCENE_PYRO_UPRES_NOISE_SCALE { UNIT PERCENT; MIN 0.01; STEP 1.0; MINSLIDER 0.01; MAXSLIDER 500.0; DEFAULT 10.0; }	
		// 	REAL PBDSCENE_PYRO_UPRES_TIME_ANIMATION { MIN 0.0; STEP 0.1; MINSLIDER 0.01; MAXSLIDER 10.0; DEFAULT 1.0; }	
		// }
		GROUP PBDSCENE_PYRO_TREESETTINGS
		{
			ANIM OFF;
			DEFAULT 0;
			LONG PBDSCENE_PYRO_PADDING_MODE
			{
				CYCLE
				{
					PBDSCENE_PYRO_PADDING_MODE_AUTOMATIC;
					PBDSCENE_PYRO_PADDING_MODE_CONSTANT;
				}
				CUSTOMGUI QUICKTABRADIO;
			}
			LONG PBDSCENE_PYRO_PADDINGRADIUS { MIN 0; MAX 8; STEP 1; MINSLIDER 0; MAXSLIDER 8; DEFAULT 2; }
			LONG PBDSCENE_PYRO_TREESETTINGS_VOXELCOUNT
			{
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_PYRO_TREESETTINGS_VOXELCOUNT_16;
					PBDSCENE_PYRO_TREESETTINGS_VOXELCOUNT_32;
				}
				CUSTOMGUI QUICKTABRADIO;
			}
		}
		
		GROUP PBDSCENE_PYRO_FORCES
		{
			DEFAULT 1;
			GROUP PBDSCENE_PYRO_GENERAL_FORCES_GROUP
			{
				DEFAULT 1;
				REAL PBDSCENE_PYRO_DENSITYBUOYANCY { MIN -1000000.0; MAX 1000000.0; STEP 1.0; MINSLIDER -20.0; MAXSLIDER 20.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_TEMPERATUREBUOYANCY { MIN -1000.0; MAX 1000.0; STEP 0.01; MINSLIDER -1.0; MAXSLIDER 1.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_FUELBUOYANCY { MIN -1000000.0; MAX 1000000.0; STEP 1.0; MINSLIDER -20.0; MAXSLIDER 20.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_VORTICITYSTRENGTH { STEP 0.5; MINSLIDER 0.0; MAXSLIDER 20.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }	
				LONG PBDSCENE_PYRO_VORTICITY_SOURCE 
				{ 
					PARENTCOLLAPSE PBDSCENE_PYRO_VORTICITYSTRENGTH; 
					CYCLE
					{
						PBDSCENE_PYRO_SOURCE_NONE;
						PBDSCENE_PYRO_SOURCE_DENSITY;
						PBDSCENE_PYRO_SOURCE_TEMPERATURE;
						PBDSCENE_PYRO_SOURCE_FUEL;
						PBDSCENE_PYRO_SOURCE_PRESSURE;
					}
				}	
				REAL PBDSCENE_PYRO_VORTICITY_SOURCE_STRENGTH { PARENTCOLLAPSE PBDSCENE_PYRO_VORTICITYSTRENGTH; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 50.0; CUSTOMGUI REALSLIDER; }	
			}
			GROUP PBDSCENE_PYRO_TURBULENCE_GROUP
			{
				DEFAULT 0;
				BOOL PBDSCENE_PYRO_TURBULENCE_SMOOTH { DEFAULT 0; }
				REAL PBDSCENE_PYRO_TURBULENCE_STRENGTH { MIN 0.0; STEP 10.0; MINSLIDER 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE; }
				LONG PBDSCENE_PYRO_TURBULENCE_SOURCE 
				{ 
					PARENTCOLLAPSE PBDSCENE_PYRO_TURBULENCE_STRENGTH; 
					CYCLE
					{
						PBDSCENE_PYRO_SOURCE_NONE;
						PBDSCENE_PYRO_SOURCE_DENSITY;
						PBDSCENE_PYRO_SOURCE_TEMPERATURE;
						PBDSCENE_PYRO_SOURCE_FUEL;
						PBDSCENE_PYRO_SOURCE_PRESSURE;
					}
				}	
				REAL PBDSCENE_PYRO_TURBULENCE_SOURCE_STRENGTH { PARENTCOLLAPSE PBDSCENE_PYRO_TURBULENCE_STRENGTH; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }	
				LONG PBDSCENE_PYRO_TURBULENCE_SEED { DEFAULT 0; STEP 1; MIN 0; }
				BOOL PBDSCENE_PYRO_TURBULENCE_SOURCE_SCALE_VELOCITY { DEFAULT 1; PARENTCOLLAPSE; }
				REAL PBDSCENE_PYRO_TURBULENCE_SOURCE_SCALE_VELOCITY_FACTOR {  PARENTCOLLAPSE PBDSCENE_PYRO_TURBULENCE_SOURCE_SCALE_VELOCITY; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_TURBULENCE_TIME_FREQUENCY { MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
				LONG PBDSCENE_PYRO_TURBULENCE_OCTAVES { MIN 1; STEP 1; MINSLIDER 1; MAXSLIDER 10; }
				REAL PBDSCENE_PYRO_TURBULENCE_SPACE_FREQUENCY { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_TURBULENCE_SPACE_SCALE { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 500.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_TURBULENCE_STRENGTH_SCALE { MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
			}
			GROUP PBDSCENE_PYRO_GRADIENT_FORCE_GROUP
			{
				REAL PBDSCENE_PYRO_GRADIENT_EXTEND_STRENGTH { STEP 0.1; MINSLIDER -15.0; MAXSLIDER 15.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE;  }
				REAL PBDSCENE_PYRO_GRADIENT_EXTEND_RANGE { PARENTCOLLAPSE PBDSCENE_PYRO_GRADIENT_EXTEND_STRENGTH; MIN 0.0; STEP 10.0; MINSLIDER 0.0; MAXSLIDER 8000.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_GRADIENT_REDUCE_STRENGTH { STEP 0.1; MINSLIDER -15.0; MAXSLIDER 15.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE;  }
				REAL PBDSCENE_PYRO_GRADIENT_REDUCE_RANGE { PARENTCOLLAPSE PBDSCENE_PYRO_GRADIENT_REDUCE_STRENGTH; MIN 0.0; STEP 10.0; MINSLIDER 0.0; MAXSLIDER 8000.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_GRADIENT_THRESHOLD { MIN 0.0; STEP 10.0; MINSLIDER 0.0; MAXSLIDER 8000.0; CUSTOMGUI REALSLIDER; }
				REAL PBDSCENE_PYRO_GRADIENT_CLAMP { MIN 0.0; STEP 10.0; MINSLIDER 0.0; MAXSLIDER 8000.0; CUSTOMGUI REALSLIDER; }
				LONG PBDSCENE_PYRO_GRADIENT_SOURCE 
				{ 
					CYCLE
					{
						PBDSCENE_PYRO_SOURCE_TEMPERATURE;
						PBDSCENE_PYRO_SOURCE_DENSITY;
						PBDSCENE_PYRO_SOURCE_FUEL_SCALAR;
					}
				}	
			}
		}
		GROUP PBDSCENE_PYRO_BURNPROCESS
		{
			DEFAULT 1;
			REAL PBDSCENE_PYRO_FUELBURNINGRATE { MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TEMPERATUREIGNITION { MIN -1.0; STEP 0.01; MINSLIDER -1.0; MAXSLIDER 8000.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_DENSITYADDPERFUEL { MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TEMPERTUREADDPERFUEL { MIN 0.0; STEP 10.0; MINSLIDER 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_PRESSUREADDPERFUEL { STEP 0.1; MINSLIDER -10.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PBDSCENE_PYRO_RESTGRID_GROUP
		{
			DEFAULT 0;
			BOOL PBDSCENE_PYRO_RESTGRID_ENABLED { ANIM OFF; DEFAULT 1; }
			LONG PBDSCENE_PYRO_RESTGRID_RESET_FPS_CYCLE { ANIM OFF; MIN 4; STEP 2; MINSLIDER 4; MAXSLIDER 120; DEFAULT 30; CUSTOMGUI LONGSLIDER; }
			REAL PBDSCENE_PYRO_RESTGRID_TIMESCALE { UNIT PERCENT; MIN 0.0; MAX 10000.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 400.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PBDSCENE_PYRO_DENSITY_GROUP
		{
			REAL PBDSCENE_PYRO_DENSITYDISSIPATION { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }				
			REAL PBDSCENE_PYRO_LINEARDENSITYDISSIPATION { MIN 0.0; MAX 1000.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_BLUR_FACTOR_DENSITY { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TREE_DENSITY_THRESHOLD { MIN 0.0000001; STEP 0.01; MINSLIDER 0.0001; MAXSLIDER 1.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_DENSITY_THRESHOLD_CUTOFF { MIN 0.0000001; STEP 0.01; MINSLIDER 0.0001; MAXSLIDER 1.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_DENSITY_TIMESCALE { UNIT PERCENT; MIN 0.0; MAX 10000.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 400.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PBDSCENE_PYRO_COLOR_GROUP
		{			
			LONG PBDSCENE_PYRO_COLOR_MODE
			{			
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_PYRO_COLOR_MODE_LEGACY;
					PBDSCENE_PYRO_COLOR_MODE_STANDARD;
					PBDSCENE_PYRO_COLOR_MODE_LIGHTNESS;
				}
			}
			// REAL PBDSCENE_PYRO_COLOR_MIXING_FACTOR { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }				
			REAL PBDSCENE_PYRO_COLOR_DISSIPATION { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }				
			REAL PBDSCENE_PYRO_COLOR_LINEARDISSIPATION { MIN 0.0; MAX 1000.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_BLUR_FACTOR_COLOR { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_COLOR_TIMESCALE { UNIT PERCENT; MIN 0.0; MAX 10000.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 400.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PBDSCENE_PYRO_TEMPERATURE_GROUP
		{
			REAL PBDSCENE_PYRO_TEMPERATUREDISSIPATION { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_LINEARTEMPERATUREDISSIPATION { MIN 0.0; MAX 10000.0; STEP 10.0; MINSLIDER 0.0; MAXSLIDER 1000.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_BLUR_FACTOR_TEMPERATURE { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TREE_TEMPERATURE_THRESHOLD { MIN 0.01;  STEP 1.0; MINSLIDER 0.01; MAXSLIDER 1000.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TEMPERATURE_THRESHOLD_CUTOFF { MIN 0.01;  STEP 1.0; MINSLIDER 0.01; MAXSLIDER 1000.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TEMPERATUREAMBIENT { MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 4000.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TEMPERATURE_TIMESCALE { UNIT PERCENT; MIN 0.0; MAX 10000.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 400.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PBDSCENE_PYRO_FUEL_GROUP
		{
			REAL PBDSCENE_PYRO_FUELDISSIPATION { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_LINEARFUELDISSIPATION { MIN 0.0; MAX 1000.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_BLUR_FACTOR_FUEL { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TREE_FUEL_THRESHOLD { MIN 0.0001; STEP 0.1; MINSLIDER 0.0001; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_FUEL_THRESHOLD_CUTOFF { MIN 0.0001; STEP 0.1; MINSLIDER 0.0001; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_FUEL_TIMESCALE { UNIT PERCENT; MIN 0.0; MAX 10000.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 400.0; DEFAULT 100.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PBDSCENE_PYRO_VELOCITY_GROUP
		{
			VECTOR PBDSCENE_PYRO_VELOCITY_DAMPING { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			REAL PBDSCENE_PYRO_VELOCITY_DAMPING_UNIFORM { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
			BOOL PBDSCENE_PYRO_VELOCITY_DAMPING_UNIFORM_ENABLED { DEFAULT 1; }
			REAL PBDSCENE_PYRO_BLUR_FACTOR_VELOCITY { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_TREE_VELOCITY_THRESHOLD { UNIT PERCENT; MIN 0.01; STEP 0.1; MINSLIDER 0.01; MAXSLIDER 200.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
		}
		GROUP PBDSCENE_PYRO_ADVANCED_GROUP
		{
			DEFAULT 0;
			LONG PBDSCENE_PYRO_FLOATPRECISION
			{		
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_PYRO_FLOATPRECISION_16;
					PBDSCENE_PYRO_FLOATPRECISION_32;
				}
				CUSTOMGUI QUICKTABRADIO;
			}
			BOOL PBDSCENE_PYRO_OUTOFCORE { DEFAULT 0; ANIM OFF; }
			REAL PBDSCENE_PYRO_BLUR_AROUND_COLLIDERS_ON_DOWNLOAD { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_BLUR_INTO_COLLIDERS_ON_DOWNLOAD { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; CUSTOMGUI REALSLIDER; }
			BOOL PBDSCENE_PYRO_MACVELOCITIY_ENABLED { ANIM OFF; DEFAULT 0; }
			LONG PBDSCENE_PYRO_ADVECTION_REFLECTION
			{		
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_PYRO_ADVECTION_REFLECTION_OFF;
					PBDSCENE_PYRO_ADVECTION_REFLECTION_FIRST;
					PBDSCENE_PYRO_ADVECTION_REFLECTION_SECOND;
				}
				CUSTOMGUI QUICKTABRADIO;
			}
			GROUP PBDSCENE_PYRO_ADVECTION_GROUP
			{
				DEFAULT 1;
				LONG PBDSCENE_PYRO_TRACE_ORDER
				{		
					CYCLE
					{
						PBDSCENE_PYRO_TRACE_ORDER_FIRST;
						PBDSCENE_PYRO_TRACE_ORDER_SECOND;
						PBDSCENE_PYRO_TRACE_ORDER_FOURTH;
					}
					CUSTOMGUI QUICKTABRADIO;
				}					
				LONG PBDSCENE_PYRO_INTERPOLATION_ACCURACY
				{		
					CYCLE
					{
						PBDSCENE_PYRO_INTERPOLATION_ACCURACY_LINEAR;
						PBDSCENE_PYRO_INTERPOLATION_ACCURACY_CUBIC;
					}
					CUSTOMGUI QUICKTABRADIO;
				}
				BOOL PBDSCENE_PYRO_PRE_ADVECT_QUANTITIES { DEFAULT 0; }
				BOOL PBDSCENE_PYRO_ADVECT_FUEL { DEFAULT 1; }
				LONG PBDSCENE_PYRO_ADVECTIONMODE 
				{ 
					CYCLE
					{
						PBDSCENE_PYRO_ADVECTIONMODE_SEMILAGRANGIAN;
						PBDSCENE_PYRO_ADVECTIONMODE_MACCORMACK;
						PBDSCENE_PYRO_ADVECTIONMODE_BFECC;
					}
				}
				BOOL PBDSCENE_PYRO_ADVECTIONMODE_VELOCITIES { DEFAULT 1; }
				BOOL PBDSCENE_PYRO_ADVECTION_CLAMPING { DEFAULT 1; }
				REAL PBDSCENE_PYRO_MACCORMACKCORRECT { MIN 0.0; MAX 3.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 3.0; DEFAULT 1.0; CUSTOMGUI REALSLIDER; }
			}
			GROUP PBDSCENE_PYRO_PRESSURESOLVER
			{	
				DEFAULT 1;
				LONG PBDSCENE_PYRO_PRESSURESOLVER_TYPE
				{
					CYCLE
					{
						PBDSCENE_PYRO_PRESSURESOLVER_GAUSSSEIDEL;
						PBDSCENE_PYRO_PRESSURESOLVER_MULTIGRIDV;
						PBDSCENE_PYRO_PRESSURESOLVER_MULTIGRIDFULL;
						PBDSCENE_PYRO_PRESSURESOLVER_PCG;
					}
				}
				LONG PBDSCENE_PYRO_PRESSURESOLVER_GLOBAL_ITERATIONS { MIN 1; MAX 32; STEP 1; MINSLIDER 1; MAXSLIDER 32; DEFAULT 1; }
				LONG PBDSCENE_PYRO_PRESSURESOLVER_ITERATIONS { MIN 0; MAX 256; STEP 1; MINSLIDER 1; MAXSLIDER 256; DEFAULT 1; }
				LONG PBDSCENE_PYRO_PRESSURESOLVER_SMOOTHINGITERATIONS { MIN 0; MAX 256; STEP 1; MINSLIDER 0; MAXSLIDER 256; DEFAULT 8; }
				LONG PBDSCENE_PYRO_PRESSURESOLVER_SMOOTHINGITERATIONSFINAL { MIN 0; MAX 256; STEP 1; MINSLIDER 1; MAXSLIDER 256; DEFAULT 50; }
				LONG PBDSCENE_PYRO_PRESSURESOLVER_MAXIMUMMULTIGRIDDEPTH { MIN 0; MAX 6; STEP 1; MINSLIDER 1; MAXSLIDER 6; DEFAULT 2; }
			}
			GROUP PBDSCENE_PYRO_INIT_GROUP
			{
				LINK PBDSCENE_PYRO_INIT_DENSITY_VOLUME
				{
					ANIM OFF;
					ACCEPT
					{
						1059580; // Opyro;
						1039867; // Ovolumeset
						1039859; // Ovolumebuilder
						1039858; // Ovolume
					}
				}
				LINK PBDSCENE_PYRO_INIT_COLOR_VOLUME
				{
					ANIM OFF;
					ACCEPT
					{
						1059580; // Opyro;
						1039867; // Ovolumeset
						1039859; // Ovolumebuilder
						1039858; // Ovolume
					}
				}
				LINK PBDSCENE_PYRO_INIT_TEMPERATURE_VOLUME
				{
					ANIM OFF;
					ACCEPT
					{
						1059580; // Opyro;
						1039867; // Ovolumeset
						1039859; // Ovolumebuilder
						1039858; // Ovolume
					}
				}
				LINK PBDSCENE_PYRO_INIT_FUEL_VOLUME
				{
					ANIM OFF;
					ACCEPT
					{
						1059580; // Opyro;
						1039867; // Ovolumeset
						1039859; // Ovolumebuilder
						1039858; // Ovolume
					}
				}
				LINK PBDSCENE_PYRO_INIT_VELOCITY_VOLUME
				{
					ANIM OFF;
					ACCEPT
					{
						1059580; // Opyro;
						1039867; // Ovolumeset
						1039859; // Ovolumebuilder
						1039858; // Ovolume
					}
				}
			}
		}
		GROUP PBDSCENE_PYRO_DRAW_GROUP
		{
			DEFAULT 1;
			BOOL PBDSCENE_PYRO_DRAW_PYRO { DEFAULT 1; }
			BOOL PBDSCENE_PYRO_DRAW_GRID { DEFAULT 1; }
			BOOL PBDSCENE_PYRO_DRAW_TREE { DEFAULT 0; }
			REAL PBDSCENE_PYRO_DRAW_DENSITY_SCALE { MIN 0.0001; MAX 100.0; STEP 0.01; MINSLIDER 0.001; MAXSLIDER 10.0; DEFAULT 1.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_RAYMARCH_STEPSIZE { UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 50.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_DRAW_EMISSION_SCALE { MIN 0.0001; MAX 100.0; STEP 0.01; MINSLIDER 0.001; MAXSLIDER 10.0; DEFAULT 1.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_DRAW_TEMPERATURE { MIN 0.0001; MAX 100.0; STEP 0.01; MINSLIDER 0.001; MAXSLIDER 10.0; DEFAULT 1.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_PYRO_DRAW_ABSORPTION { MIN 0.0001; MAX 100.0; STEP 0.01; MINSLIDER 0.01; MAXSLIDER 10.0; DEFAULT 1.0; CUSTOMGUI REALSLIDER; }	
			LONG PBDSCENE_PYRO_DRAW_TEXTURE
			{
				CYCLE
				{
					PBDSCENE_PYRO_DRAW_TEXTURE_SHADED;
					PBDSCENE_PYRO_DRAW_TEXTURE_DENSITY;
					PBDSCENE_PYRO_DRAW_TEXTURE_DIVERGENCE;
					PBDSCENE_PYRO_DRAW_TEXTURE_TEMPERATURE;
					PBDSCENE_PYRO_DRAW_TEXTURE_FUEL;
					PBDSCENE_PYRO_DRAW_TEXTURE_VELOCITY;
					PBDSCENE_PYRO_DRAW_TEXTURE_PRESSURE;
				}
			}
		}
		GROUP PBDSCENE_PYRO_FORCES_GROUP
		{
			DEFAULT 1; 
			LONG PBDSCENE_PYRO_FORCES_INEXMODE
			{
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_PYRO_FORCES_INEXMODE_INCLUDE;
					PBDSCENE_PYRO_FORCES_INEXMODE_EXCLUDE;
				}
				DEFAULT PBDSCENE_PYRO_FORCES_INEXMODE_EXCLUDE;
			}
			IN_EXCLUDE PBDSCENE_PYRO_FORCES_INEXCLUDE
	 		{
	 			SCALE_V;
				NUM_FLAGS 1;
				INIT_STATE 1;
				SEND_SELCHNGMSG 1;
				SMALL_MODE_SIZE 80;
				BIG_MODE_SIZE 150;
				IMAGE_01_ON 300000131;
				IMAGE_01_OFF 300000130;
				ACCEPT 
				{
					Odeflector;
					Ogravitation;
					Orotation;
					Owind;
					Ofriction;
					Oturbulence;
					Oattractor; 
					Ofieldforce;
					Odestructor;
					1018544; // Cloner object
				}
			}
	 	}
	}

	GROUP PBDSCENE_FP_GROUP
	{
		GROUP PBDSCENE_FP_SETTINGS_GROUP
		{
			DEFAULT 1;
			LONG PBDSCENE_FP_SUBSTEPS { MIN 1; STEP 1; DEFAULT 1;}
			REAL PBDSCENE_FP_SUBSTEP_FIELD_VARIANCE { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0; CUSTOMGUI REALSLIDER; }
			LONG PBDSCENE_FP_PRECISION
			{
				CUSTOMGUI QUICKTABRADIO;
				ANIM OFF;
				CYCLE
				{
					PBDSCENE_FP_PRECISION_16BIT;
					PBDSCENE_FP_PRECISION_32BIT;
				}
			}
			LONG PBDSCENE_FP_CAPACITY { DEFAULT 2048; MIN 256; ANIM OFF; }
			REAL PBDSCENE_FP_COMPACTIFYTHRESHOLD { MIN 0.0; MAX 100.0; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
			LONG PBDSCENE_FP_SYNC 
			{ 
				CUSTOMGUI QUICKTABRADIO;
				ANIM OFF; 
				CYCLE
				{
					PBDSCENE_FP_SYNC_AUTO;
					PBDSCENE_FP_SYNC_ON;
					PBDSCENE_FP_SYNC_OFF;
				}
			}
			
			BOOL PBDSCENE_FP_DRAW_MASK_WHEN_SELECTED { DEFAULT 1; }
		}

		GROUP PBDSCENE_FP_ATTRIBUTES
		{
			DEFAULT 0;
			BOOL PBDSCENE_FP_ATTRIBUTES_AGE { ANIM OFF; }
			BOOL PBDSCENE_FP_ATTRIBUTES_COLOR { ANIM OFF; }
			BOOL PBDSCENE_FP_ATTRIBUTES_VELOCITY { ANIM OFF; }
			BOOL PBDSCENE_FP_ATTRIBUTES_RADIUS { ANIM OFF; }
			BOOL PBDSCENE_FP_ATTRIBUTES_DISTANCE { ANIM OFF; }
			BOOL PBDSCENE_FP_ATTRIBUTES_LIFETIME { ANIM OFF; }
			BOOL PBDSCENE_FP_ATTRIBUTES_ALIGNMENT { ANIM OFF; }
			BOOL PBDSCENE_FP_ATTRIBUTES_ANGULARVELOCITY { ANIM OFF; }
		}

		GROUP PBDSCENE_FP_CUSTOMATTRIBUTES_AUTOGENERATED
		{
			DEFAULT 1;
			COLUMNS 4;

			STRING PBDSCENE_FP_CUSTOMATTRIBUTES_AUTOGENERATED_HEADER_USE { ANIM OFF; READONLY; NO_BORDER; NO_DARK_BACKGROUND; CUSTOMGUI MULTISTRING; LINECOUNT 1; NO_SCROLLBARS; }
			STRING PBDSCENE_FP_CUSTOMATTRIBUTES_AUTOGENERATED_HEADER_INFO { ANIM OFF; READONLY; NO_BORDER; NO_DARK_BACKGROUND; CUSTOMGUI MULTISTRING; LINECOUNT 1; NO_SCROLLBARS; }
			STRING PBDSCENE_FP_CUSTOMATTRIBUTES_AUTOGENERATED_HEADER_REFERENCES { ANIM OFF; READONLY; NO_BORDER; NO_DARK_BACKGROUND; CUSTOMGUI MULTISTRING; LINECOUNT 1; NO_SCROLLBARS; }
			STRING PBDSCENE_FP_CUSTOMATTRIBUTES_AUTOGENERATED_HEADER_REMOVEREFERENCES { ANIM OFF; READONLY; NO_BORDER; NO_DARK_BACKGROUND; CUSTOMGUI MULTISTRING; LINECOUNT 1; NO_SCROLLBARS; }
		}

		GROUP PBDSCENE_FP_CUSTOMATTRIBUTES
		{
			DEFAULT 1;
			COLUMNS 4;
			
			GROUP
			{
				BUTTON PBDSCENE_FP_ADDCUSTOMATTRIBUTES_ADD { SCALE_H; }
			}

			STRING PBDSCENE_FP_CUSTOMATTRIBUTES_HEADER_USE { ANIM OFF; READONLY; NO_BORDER; NO_DARK_BACKGROUND; CUSTOMGUI MULTISTRING; LINECOUNT 1; NO_SCROLLBARS; }
			STRING PBDSCENE_FP_CUSTOMATTRIBUTES_HEADER_NAME { ANIM OFF; READONLY; NO_BORDER; NO_DARK_BACKGROUND; CUSTOMGUI MULTISTRING; LINECOUNT 1; NO_SCROLLBARS; SCALE_H; }
			STRING PBDSCENE_FP_CUSTOMATTRIBUTES_HEADER_TYPE { ANIM OFF; READONLY; NO_BORDER; NO_DARK_BACKGROUND; CUSTOMGUI MULTISTRING; LINECOUNT 1; NO_SCROLLBARS; }
			STATICTEXT PBDSCENE_FP_CUSTOMATTRIBUTES_HEADER_REMOVE { ANIM OFF; }
		}

		GROUP PBDSCENE_FP_DRAW_PARTICLES_GROUP	
		{
			DEFAULT 0;
			BOOL PBDSCENE_FP_DRAW_PARTICLES { DEFAULT 1; }
			LONG PBDSCENE_FP_DRAW_PARTICLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					PBDSCENE_FP_DRAW_PARTICLES_MODE_DOTS;
					PBDSCENE_FP_DRAW_PARTICLES_MODE_ARROWS;
					PBDSCENE_FP_DRAW_PARTICLES_MODE_TICKS;
					PBDSCENE_FP_DRAW_PARTICLES_MODE_LINES;
					PBDSCENE_FP_DRAW_PARTICLES_MODE_HANDLES;
				}
			}
			BOOL PBDSCENE_FP_DRAW_PARTICLES_RADIUS { DEFAULT 1; }
			REAL PBDSCENE_FP_DRAW_PARTICLES_SIZE { STEP 0.25; MIN 0.001; }
			LONG PBDSCENE_FP_COLOR_OVERRIDE_MODE
			{
				CYCLE
				{
					PBDSCENE_FP_COLOR_OVERRIDE_MODE_NONE;
					PBDSCENE_FP_COLOR_OVERRIDE_MODE_CONSTANT;
					PBDSCENE_FP_COLOR_OVERRIDE_MODE_DIRECTION;
				}
				DEFAULT PBDSCENE_FP_COLOR_OVERRIDE_MODE_NONE;
			}
			COLOR PBDSCENE_FP_COLOR_OVERRIDE_CONSTANT { }
		}
	}

	GROUP PBDSCENE_LIQUIDS_GROUP
	{
		REAL PBDSCENE_LIQUIDS_RADIUS { DEFAULT 3.0; ANIM OFF; MIN 0.0; STEP 0.1; UNIT METER; } 
		LONG PBDSCENE_LIQUIDS_NEIGHBORS_PASSES { MIN 0; MAX 1000; STEP 1; MINSLIDER 1; MAXSLIDER 100; }
		LONG PBDSCENE_LIQUIDS_EXTRA_ITERATIONS { MIN 0; MAX 1000; STEP 1; MINSLIDER 1; MAXSLIDER 100; }
		LONG PBDSCENE_LIQUIDS_VISCOSITY_ITERATIONS { MIN 0; MAX 1000; STEP 1; MINSLIDER 1; MAXSLIDER 100; }
		LONG PBDSCENE_LIQUIDS_SURFACETENSION_ITERATIONS { MIN 0; MAX 1000; STEP 1; MINSLIDER 1; MAXSLIDER 100; }
		BOOL PBDSCENE_LIQUIDS_ACCELERATIONCLAMP_OVERRIDE { }
		REAL PBDSCENE_LIQUIDS_ACCELERATIONCLAMP_ABSOLUTE_SIZE { UNIT METER; MIN 0.0; STEP 1000.0; MINSLIDER 0.0; MAXSLIDER 20000; CUSTOMGUI REALSLIDER; }

		GROUP PBDSCENE_LIQUID_DRAW_GROUP
		{
			DEFAULT 1;

			LONG PBDSCENE_LIQUID_DRAW_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					PBDSCENE_LIQUID_DRAW_MODE_OFF;
					PBDSCENE_LIQUID_DRAW_MODE_DOTS;
					PBDSCENE_LIQUID_DRAW_MODE_ARROWS;
				}
			}
			BOOL PBDSCENE_LIQUID_DRAW_RADIUS { }
			REAL PBDSCENE_LIQUID_DRAW_SIZE { STEP 0.25; MIN 0.001; }

			LONG PBDSCENE_LIQUID_COLOR_OVERRIDE_MODE
			{
				CYCLE
				{
					PBDSCENE_LIQUID_COLOR_OVERRIDE_MODE_NONE;
					PBDSCENE_LIQUID_COLOR_OVERRIDE_MODE_CONSTANT;
					PBDSCENE_LIQUID_COLOR_OVERRIDE_MODE_SPEED;
				}
			}
			COLOR PBDSCENE_LIQUID_COLOR_OVERRIDE_CONSTANT { }
			REAL PBDSCENE_LIQUID_COLOR_OVERRIDE_SPEED_MAX { UNIT METER; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 150.0; CUSTOMGUI REALSLIDER; }

			REAL PBDSCENE_LIQUID_DRAW_ALPHA { STEP 0.25; MIN 0.0; MAX 1.0; }
			LONG PBDSCENE_LIQUID_DRAW_ONLY_GROUP { MIN -1; STEP 1; }
			LONG PBDSCENE_DRAW_LIQUIDS_NEIGHBORS { MIN -1; STEP 1; }
		}
	}

	GROUP PBDSCENE_GROUP_DEBUGPROPERTIES
	{
		GROUP PBDSCENE_DEBUG_PBDPARTICLES_GROUP
		{
			BOOL PBDSCENE_DEBUG_PBDPARTICLES_PRIORITIZECONTACTS { DEFAULT 1; }
			REAL PBDSCENE_DEBUG_PBDPARTICLES_PUREOVERMIXEDCONTACTSRATIO { MIN 0.0; MAX 1.0; STEP 0.1; DEFAULT 0.5; }
		}

		GROUP PBDSCENE_DEBUG_LIQUIDS_GROUP
		{
			DEFAULT 1;
			BOOL PBDSCENE_DEBUG_LIQUIDS_RIGIDBODY_SDF_BROADPHASE_SAFETY_FACTOR_OVERRIDE  { }
			REAL PBDSCENE_DEBUG_LIQUIDS_RIGIDBODY_SDF_BROADPHASE_SAFETY_FACTOR  { MIN 1.0; MAX 1000000.0; STEP 0.5; }
			REAL PBDSCENE_DEBUG_LIQUIDS_COLLIDER_SDF_BROADPHASE_SAFETY_FACTOR  { MIN 1.0; MAX 1000000.0; STEP 0.5; }
			SEPARATOR { LINE; }
			REAL PBDSCENE_DEBUG_LIQUIDS_STABILITY_THRESHOLD { MIN 0.0; MAX 1.0; STEP 0.01; }
			LONG PBDSCENE_DEBUG_LIQUIDS_STABILITY_HANDLING_TYPE { MIN 0; MAX 3; }
			REAL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_REPULSION_FACTOR { MIN 0.0; STEP 0.1; }
			REAL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_ATTRACTION_FACTOR { MIN 0.0; STEP 0.1; }
			REAL PBDSCENE_DEBUG_LIQUIDS_TENSILE_K { MIN 0.0; MAX 1.0; STEP 0.1; }
			REAL PBDSCENE_DEBUG_LIQUIDS_TENSILE_Q { MIN 0.0; MAX 1.0; STEP 0.1; }
			REAL PBDSCENE_DEBUG_LIQUIDS_OVERRELAXATION { MIN 0.0; MAX 10.0; STEP 0.1; }
			REAL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_REST_DENSITY_MULTIPLIER { MIN 0.0001; STEP 0.0001; }
			SEPARATOR { LINE; }
			LONG PBDSCENE_DEBUG_LIQUIDS_VELOCITY_MIXTURE_MODE { MIN 0; MAX 1; }
			REAL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_VISCOSITY { MIN 0.0; MAX 10.0; STEP 0.001; }
			REAL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_INVSTIFF { MIN 0.0; STEP 0.0001; }
			REAL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_DAMPING { MIN 0.0; STEP 0.0001; }
			REAL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_COLLISION_INVSTIFF { MIN -2.0; STEP 0.0001; }
			BOOL PBDSCENE_DEBUG_LIQUIDS_DEFAULT_READ_SECOND_PARTICLE { }
			BOOL PBDSCENE_DEBUG_LIQUIDS_SUPPRESS_ALONG_CONTACTS_NORMAL_ENABLE { }
			REAL PBDSCENE_DEBUG_LIQUIDS_SUPPRESS_ALONG_CONTACTS_NORMAL { MIN 0.0; MAX 1.0; STEP 0.1; }
			SEPARATOR { LINE; }
			LONG PBDSCENE_DEBUG_LIQUIDS_MAX_NEIGHBORS_COUNT { MIN 0; MAX 256; ANIM OFF; }
			BOOL PBDSCENE_DEBUG_LIQUIDS_SORT_NEIGHBORS { }
			LONG PBDSCENE_DEBUG_LIQUIDS_FIRST_NEIGHBORS_COUNT { MIN 0; MAX 256; }
			REAL PBDSCENE_DEBUG_LIQUIDS_MAX_NEIGHBORS_DIST_MULT { MIN 0.0; MAX 100.0; STEP 1.0; ANIM OFF; }
			REAL PBDSCENE_DEBUG_LIQUIDS_KERNEL_RAD_MULTIPLIER { MIN 0.0; MAX 100.0; STEP 1.0; ANIM OFF; }
		}

		GROUP PBDSCENE_DEBUG_RIGIDBODY
		{
			REAL PBDSCENE_RIGIDBODY_TRIANGLE_MESH_THICKNESS_REDUCE_FACTOR { MIN 0.0001; STEP 0.01; DEFAULT 0.01; }
			REAL PBDSCENE_RIGIDBODY_TRIANGLE_MESH_MIN_THICKNESS { UNIT METER; MIN 0.00001; STEP 0.0001; DEFAULT 0.005; }
			REAL PBDSCENE_RIGIDBODY_MAX_DEPENETRATION_VELOCITY { MIN 0.0; STEP 1; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 10.0; CUSTOMGUI REALSLIDER; }
			REAL PBDSCENE_RIGIDBODY_FRICTION_RANGE_MULTIPLIER { MIN 0.0; STEP 0.01; DEFAULT 0.01; }
			REAL PBDSCENE_RIGIDBODY_FRICTION_MIN_CONTACT_DEPTH_MULTIPLIER { MIN 0.0; STEP 0.01; DEFAULT 0.05; }
			LONG PBDSCENE_RIGIDBODY_ADD_CENTER_CONTACT { DEFAULT 1; MIN 0; MAX 1; }
			BOOL PBDSCENE_EXCLUDE_RIGIDBODY_VERSUS_FLAT_COLLIDER_EDGES { DEFAULT 1; }
			LONG PBDSCENE_RIGIDBODY_BEST_SAT_MAX { DEFAULT 2; MIN 1; MAX 2; }
			REAL PBDSCENE_RIGIDBODY_BEST_SAT_TOLERANCE { DEFAULT 0.1; STEP 0.01; MIN 0.0; MAX 1.0; }
			BOOL PBDSCENE_RIGIDBODY_REUSE_OVERLAP_AXIS { DEFAULT 1; }
			REAL PBDSCENE_RIGIDBODY_REUSE_OVERLAP_AXIS_THRESHOLD0 { MIN 0.0; STEP 0.1; DEFAULT 1.0; }
			REAL PBDSCENE_RIGIDBODY_REUSE_OVERLAP_AXIS_THRESHOLD1 { MIN 0.0; STEP 0.1; DEFAULT 1.0; }
			LONG PBDSCENE_RIGIDBODY_REUSE_OVERLAP_AXIS_LIFETIME { MIN 0; STEP 1; DEFAULT 1; }
			REAL PBDSCENE_RIGIDBODY_REDUCE_CONTACT_SET_THRESHOLD { MIN 0.0; STEP 1.0; DEFAULT 3.0; }
			SEPARATOR { LINE; }
			REAL PBDSCENE_RIGIDBODY_JOINT_CONSTRAINT_INVSTIFFNESS { MIN 0.0; STEP 0.0005; DEFAULT 0.0001; }
			REAL PBDSCENE_RIGIDBODY_JOINT_CONSTRAINT_DAMPING { MIN 0.0; STEP 0.005; DEFAULT 0.001; }
		}

		GROUP PBDSCENE_DEBUG_PARALLELFOR
		{
			LONG  PBDSCENE_PARALLELFOR_THREADCOUNT { DEFAULT 0; MIN 0; }
			LONG  PBDSCENE_PARALLELFOR_GRANULARITY { DEFAULT 16; MIN 1; }
		}

		GROUP PBDSCENE_DEBUG_COLORING
		{
			BOOL PBDSCENE_RANDOMIZECOLORSOLVE { DEFAULT 1; }
			BOOL PBDSCENE_RECREATECOLORS { DEFAULT 0; }
		}

		GROUP PBDSCENE_DEBUG_FIXEDCONSTRAINTS
		{
			BOOL PBDSCENE_SOLVEELASTICON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVETRIANGLEBENDON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEVOLUMEON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVESPLINEBENDON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVESTRETCHSHEARON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEBENDTWISTON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEELASTICADDEDON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEWEAKPINSON { DEFAULT 1; }
		}

		GROUP PBDSCENE_DEBUG_COLLISIONDETECTION
		{
			BOOL PBDSCENE_EXCLUSIONLISTON { DEFAULT 1; }
			BOOL PBDSCENE_PARTICLEPARTICLEON { DEFAULT 1; }
			BOOL PBDSCENE_PARTICLETRIANGLEON { DEFAULT 1; }
			BOOL PBDSCENE_EDGEEDGEON { DEFAULT 1; }
			BOOL PBDSCENE_COLLIDERPARTICLETRIANGLEON { DEFAULT 1; }
			BOOL PBDSCENE_PARTICLECOLLIDERTRIANGLEON { DEFAULT 1; }
			BOOL PBDSCENE_EDGECOLLIDEREDGEON { DEFAULT 1; }
			BOOL PBDSCENE_RIGIDBODYON { DEFAULT 1; }
			BOOL PBDSCENE_REPTRION { DEFAULT 0; }
		}

		GROUP PBDSCENE_DEBUG_SOLVECONTACTS
		{
			BOOL PBDSCENE_SORTCONTACTSON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEPARTICLEPARTICLEON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEPARTICLETRIANGLEON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEEDGEEDGEON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVECOLLIDERPARTICLETRIANGLEON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEPARTICLECOLLIDERTRIANGLEON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEEDGECOLLIDEREDGEON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVERIGIDBODYON { DEFAULT 1; }
		}

		GROUP PBDSCENE_DEBUG_DYNAMICFRICTION
		{
			BOOL PBDSCENE_SOLVEPARTICLEPARTICLEVELOCITYON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEPARTICLETRIANGLEVELOCITYON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVECOLLIDERPARTICLETRIANGLEVELOCITYON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVEPARTICLECOLLIDERTRIANGLEVELOCITYON { DEFAULT 1; }
			BOOL PBDSCENE_SOLVERIGIDBODYVELOCITYON { DEFAULT 1; }
		}
	}

}
