CONTAINER oliquidmesh 
{
    NAME oliquidmesh;
	INCLUDE Obase;

    GROUP LIQUID_MESH_PROPERTY
	{
		DEFAULT 1;
        REAL LIQUID_MESH_INFLUENCE_SCALE {  MINSLIDER 0; STEP 0.1; MAXSLIDER 5; CUSTOMGUI REALSLIDER ; MIN 0.0; }	
        REAL LIQUID_MESH_DENSITY_THRESHOLD { MINSLIDER 0; STEP 0.01; MAXSLIDER 1; CUSTOMGUI REALSLIDER ; MAX 1.0; }	

        LONG LIQUID_MESH_CELL_MODE 
        {
            CUSTOMGUI QUICKTABRADIO;	
            CYCLE
            {
                LIQUID_MESH_CELL_RELATIVE;
                LIQUID_MESH_CELL_ABSOLUTE;
            }	
        }
        LONG LIQUID_MESH_CELL_STEP {MIN 1; MINSLIDER 1; STEP 1; MAXSLIDER 8; CUSTOMGUI LONGSLIDER;}
        REAL LIQUID_MESH_CELL_SIZE { MINSLIDER 1; STEP 0.1; UNIT METER; FORBID_SCALING; CUSTOMGUI REALSLIDER ; MIN 0.001; MAX 20; }
        LONG LIQUID_MESH_AABB 
		{
			CUSTOMGUI QUICKTABRADIO;	
			CYCLE
			{
				LIQUID_MESH_AABB_STATIC;
				LIQUID_MESH_AABB_DYNAMIC;
			}	
		}
        VECTOR LIQUID_MESH_SCENE_POSITION { UNIT METER; STEP 0.1; FORBID_SCALING; }
        VECTOR LIQUID_MESH_SCENE_SIZE { UNIT METER; STEP 0.1; MIN 0.0; FORBID_SCALING; }
        BOOL LIQUID_MESH_CLOSE_HOLE {}

        LONG LIQUID_MESH_EMITTER_INEXMODE
		{
			ANIM OFF;
			CYCLE
			{
				LIQUID_MESH_EMITTER_INEXMODE_INCLUDE;
				LIQUID_MESH_EMITTER_INEXMODE_EXCLUDE;
			}
			DEFAULT LIQUID_MESH_EMITTER_INEXMODE_EXCLUDE;
		}
        IN_EXCLUDE  LIQUID_MESH_EMITTER_INEXCLUDE
	 	{
            ACCEPT
            {
                Ofpgroup;
            }
        }
		GROUP LIQUID_MESH_SMOOTH
		{
			BOOL LIQUID_MESH_GEOMETRY_SMOOTH {}
			LONG LIQUID_MESH_GEOMETRY_SMOOTH_ITER { MIN 0;  MINSLIDER 0;  MAXSLIDER 100;}
			REAL LIQUID_MESH_GEOMETRY_SMOOTH_STRENGTH {  MINSLIDER 0; STEP 1.0; MAXSLIDER 100; CUSTOMGUI REALSLIDER ; UNIT PERCENT; MIN 0.0; MAX 100.0; }
			SEPARATOR { LINE; }
			BOOL LIQUID_MESH_NORMAL_SMOOTH {}
			LONG LIQUID_MESH_NORMAL_SMOOTH_ITER {MIN 0; }
		}
		GROUP LIQUID_MESH_PROCESSING
		{
			BOOL LIQUID_MESH_REMOVE_ARTIFACT { }
			REAL LIQUID_MESH_ARTIFACT_THRESHOLD { MIN 0.0; STEP 1.0; }
		}
		GROUP LIQUID_MESH_DROPLET
		{
			REAL LIQUID_MESH_DROPLET_SCALE {  MINSLIDER 0; STEP 1.0; MAXSLIDER 100; CUSTOMGUI REALSLIDER ; UNIT PERCENT; MIN 0.0; MAX 100.0; }	
			LONG LIQUID_MESH_DROPLET_COUNT { MIN 0; MINSLIDER 0; STEP 1; MAXSLIDER 30; CUSTOMGUI LONGSLIDER; }
		}
    };

	GROUP LIQUID_MESH_EXPORT_PANEL
	{
		LONG LIQUID_MESH_GEOMETRY
		{
			CYCLE
			{
				LIQUID_MESH_CHANNEL_ON;
				LIQUID_MESH_CHANNEL_OFF;
			}
			CUSTOMGUI QUICKTABRADIO;
		}
		LONG LIQUID_MESH_NORMAL
		{
			CYCLE
			{
				LIQUID_MESH_CHANNEL_ON;
				LIQUID_MESH_CHANNEL_OFF;
			}
			CUSTOMGUI QUICKTABRADIO;
		}
		LONG LIQUID_MESH_DENSITY
		{
			CYCLE
			{
				LIQUID_MESH_CHANNEL_ON;
				LIQUID_MESH_CHANNEL_OFF;
			}
			CUSTOMGUI QUICKTABRADIO;
		}
		LONG LIQUID_MESH_COLOR
		{
			CYCLE
			{
				LIQUID_MESH_CHANNEL_ON;
				LIQUID_MESH_CHANNEL_OFF;
			}
			CUSTOMGUI QUICKTABRADIO;
		}
		LONG LIQUID_MESH_VELOCITY
		{
			CYCLE
			{
				LIQUID_MESH_CHANNEL_ON;
				LIQUID_MESH_CHANNEL_OFF;
			}
			CUSTOMGUI QUICKTABRADIO;
		}
	}

}