CONTAINER ofpreproduce
{
	NAME ofpreproduce;
	INCLUDE Obase;

	GROUP FP_REPRODUCE_REPRODUCTION
	{
		DEFAULT 1;
		BOOL FP_REPRODUCE_REPRODUCTION_ENABLED { DEFAULT 1; }
		LONG FP_REPRODUCE_REPRODUCTION_COUNT { DEFAULT 10; MIN 0; }
		LONG FP_REPRODUCE_REPRODUCTION_MODE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				FP_REPRODUCE_REPRODUCTION_MODE_PERPARTICLE;
				FP_REPRODUCE_REPRODUCTION_MODE_DISTRIBUTE;
			}
			DEFAULT FP_REPRODUCE_REPRODUCTION_MODE_PERPARTICLE;
		}
		LONG FP_REPRODUCE_REPRODUCTION_COUNT_VARIANCE { DEFAULT 0; MIN 0;}
		BOOL FP_REPRODUCE_REPRODUCTION_KILLSOURCE {}
		LONG FP_REPRODUCE_REPRODUCTION_ONCE 
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				FP_REPRODUCE_REPRODUCTION_ONCE_ON;
				FP_REPRODUCE_REPRODUCTION_ONCE_OFF;
			}
			DEFAULT 1; 
		}
		BOOL FP_REPRODUCE_REPRODUCTION_CONTINUOUS { DEFAULT 1; }

		REAL FP_REPRODUCE_REPRODUCTION_OFFSET { DEFAULT 0.0; MIN 0.0; STEP 0.1; UNIT METER; }
		REAL FP_REPRODUCE_REPRODUCTION_OFFSET_VARIANCE { DEFAULT 0.0; MIN 0.0; STEP 0.1; UNIT METER; } 

		LONG FP_REPRODUCE_REPRODUCTION_SEED { DEFAULT 12345; MIN 0; }
		
		GROUP FP_REPRODUCE_GROUP
		{
			DEFAULT 1;
			BOOL FP_REPRODUCE_GROUP_INHERITANCE { DEFAULT 1; }
			LINK FP_REPRODUCE_GROUP_GROUP
			{ 
				ACCEPT { Ofpgroup; }
			}
			BUTTON FP_REPRODUCE_GROUP_CREATE {}
		}
	}
	GROUP FP_REPRODUCE_OUTPUT
	{
		DEFAULT 0;
		COLUMNS 2;

		BOOL FP_REPRODUCE_OUTPUT_BORN { SCALE_V; ANIM OFF; }
		STATICTEXT { JOINEND; }
		STRING FP_REPRODUCE_OUTPUT_BORN_ATTRIBUTE_NAME { SCALE_H; }
		POPUP FP_REPRODUCE_OUTPUT_BORN_ATTRIBUTE_POPUP { }
		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }

		BOOL FP_REPRODUCE_OUTPUT_SOURCEID { SCALE_V; ANIM OFF; }
		STATICTEXT { JOINEND; }
		STRING FP_REPRODUCE_OUTPUT_SOURCEID_ATTRIBUTE_NAME { SCALE_H; }
		POPUP FP_REPRODUCE_OUTPUT_SOURCEID_ATTRIBUTE_POPUP { }
		STATICTEXT { JOINEND; }
	}
	GROUP FP_REPRODUCE_ATTRIBUTES
	{
		DEFAULT 1;
		
		GROUP FP_REPRODUCE_LIFETIME
		{
			DEFAULT 1;
			BOOL FP_REPRODUCE_LIFETIME_LIMITED { DEFAULT 1; }
			BASETIME FP_REPRODUCE_LIFETIME_EXPECTATION { DEFAULT 0; MIN 0; PARENTCOLLAPSE; }
			BASETIME FP_REPRODUCE_LIFETIME_VARIANCE { DEFAULT 0; MIN 0; PARENTCOLLAPSE FP_REPRODUCE_LIFETIME_EXPECTATION; }
			REAL FP_REPRODUCE_LIFETIME_INHERITANCE { STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
		}

		GROUP FP_REPRODUCE_VELOCITY
		{
			DEFAULT 1;
			REAL FP_REPRODUCE_VELOCITY_SPEED { DEFAULT 100.0; UNIT METER; PARENTCOLLAPSE; }
			REAL FP_REPRODUCE_VELOCITY_SPEED_VARIANCE { DEFAULT 0; UNIT METER; PARENTCOLLAPSE FP_REPRODUCE_VELOCITY_SPEED; }
			LONG FP_REPRODUCE_VELOCITY_DIRECTION_MODE 
			{ 
				CYCLE
				{
					FP_REPRODUCE_VELOCITY_DIRECTION_MODE_AXIS;
					FP_REPRODUCE_VELOCITY_DIRECTION_MODE_RADIAL;
					FP_REPRODUCE_VELOCITY_DIRECTION_MODE_RANDOM;
					FP_REPRODUCE_VELOCITY_DIRECTION_MODE_TARGET;
					FP_REPRODUCE_VELOCITY_DIRECTION_MODE_VECTOR;
				}
				DEFAULT FP_REPRODUCE_VELOCITY_DIRECTION_MODE_VECTOR;
				PARENTCOLLAPSE;
			}
			LONG FP_REPRODUCE_VELOCITY_DIRECTION_AXIS
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					FP_REPRODUCE_DIRECTION_POSX;
					FP_REPRODUCE_DIRECTION_NEGX;
					FP_REPRODUCE_DIRECTION_POSY;
					FP_REPRODUCE_DIRECTION_NEGY;
					FP_REPRODUCE_DIRECTION_POSZ;
					FP_REPRODUCE_DIRECTION_NEGZ;
				}
				DEFAULT FP_REPRODUCE_DIRECTION_POSZ;
				PARENTCOLLAPSE FP_REPRODUCE_VELOCITY_DIRECTION_MODE;
			}
			VECTOR FP_REPRODUCE_VELOCITY_DIRECTION_VECTOR { UNIT METER; PARENTCOLLAPSE FP_REPRODUCE_VELOCITY_DIRECTION_MODE; }
			LINK FP_REPRODUCE_VELOCITY_DIRECTION_TARGET_LINK { ACCEPT { Obase; } PARENTCOLLAPSE FP_REPRODUCE_VELOCITY_DIRECTION_MODE; }
			LONG FP_REPRODUCE_VELOCITY_DIRECTION_SPACE 
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					FP_REPRODUCE_VELOCITY_DIRECTION_SPACE_LOCAL;
					FP_REPRODUCE_VELOCITY_DIRECTION_SPACE_GLOBAL;
				}
				DEFAULT FP_REPRODUCE_VELOCITY_DIRECTION_SPACE_LOCAL;
				PARENTCOLLAPSE FP_REPRODUCE_VELOCITY_DIRECTION_MODE;
			}
			REAL FP_REPRODUCE_VELOCITY_DIRECTION_FOV { DEFAULT 0; MIN 0; MAX 360; UNIT DEGREE; PARENTCOLLAPSE FP_REPRODUCE_VELOCITY_DIRECTION_MODE; }
			REAL FP_REPRODUCE_VELOCITY_DIRECTION_FOVFALLOFF { STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; MIN 0.0; MAX 100.0; DEFAULT 0.0; UNIT PERCENT; PARENTCOLLAPSE FP_REPRODUCE_VELOCITY_DIRECTION_MODE; }
			REAL FP_REPRODUCE_VELOCITY_SPEED_INHERITANCE { STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
			REAL FP_REPRODUCE_VELOCITY_DIRECTION_INHERITANCE { MIN 0.0; MAX 100.0; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }	
		}
		GROUP FP_REPRODUCE_ALIGNMENT
		{
			LONG FP_REPRODUCE_ALIGNMENT_FORWARD_MODE 
			{
				CYCLE
				{
					FP_REPRODUCE_ALIGNMENT_FORWARD_MODE_AXIS;
					FP_REPRODUCE_ALIGNMENT_FORWARD_MODE_VELOCITYDIRECTION;
					FP_REPRODUCE_ALIGNMENT_FORWARD_MODE_RADIAL;
					FP_REPRODUCE_ALIGNMENT_FORWARD_MODE_RANDOM;
					FP_REPRODUCE_ALIGNMENT_FORWARD_MODE_OBJECT;
					FP_REPRODUCE_ALIGNMENT_FORWARD_MODE_VECTOR;
				}
				DEFAULT FP_REPRODUCE_ALIGNMENT_FORWARD_MODE_VELOCITYDIRECTION;
				PARENTCOLLAPSE;
			}
			LONG FP_REPRODUCE_ALIGNMENT_FORWARD_AXIS
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					FP_REPRODUCE_DIRECTION_POSX;
					FP_REPRODUCE_DIRECTION_NEGX;
					FP_REPRODUCE_DIRECTION_POSY;
					FP_REPRODUCE_DIRECTION_NEGY;
					FP_REPRODUCE_DIRECTION_POSZ;
					FP_REPRODUCE_DIRECTION_NEGZ;
				}
				DEFAULT FP_REPRODUCE_AXISDIRECTION_POSZ;
				PARENTCOLLAPSE FP_REPRODUCE_ALIGNMENT_FORWARD_MODE;
			}
			VECTOR FP_REPRODUCE_ALIGNMENT_FORWARD_VECTOR { PARENTCOLLAPSE FP_REPRODUCE_ALIGNMENT_FORWARD_MODE; }
			LINK FP_REPRODUCE_ALIGNMENT_FORWARD_OBJECT_LINK 
			{
				ACCEPT
				{
					obase;
				}  
				ANIM OFF; 
				PARENTCOLLAPSE FP_REPRODUCE_ALIGNMENT_FORWARD_MODE;
			}
			LONG FP_REPRODUCE_ALIGNMENT_FORWARD_AXIS_SPACE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					FP_REPRODUCE_ALIGNMENT_FORWARD_AXIS_SPACE_LOCAL;
					FP_REPRODUCE_ALIGNMENT_FORWARD_AXIS_SPACE_GLOBAL;
				}
				DEFAULT FP_REPRODUCE_ALIGNMENT_FORWARD_AXIS_SPACE_LOCAL;
				PARENTCOLLAPSE FP_REPRODUCE_ALIGNMENT_FORWARD_MODE;
			}
			REAL FP_REPRODUCE_ALIGNMENT_FORWARD_FOV { DEFAULT 0; MIN 0; MAX 360; UNIT DEGREE; PARENTCOLLAPSE FP_REPRODUCE_ALIGNMENT_FORWARD_MODE; }
			REAL FP_REPRODUCE_ALIGNMENT_FORWARD_FOVFALLOFF { DEFAULT 0; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; MIN 0.0; MAX 100.0; DEFAULT 0.0; UNIT PERCENT; PARENTCOLLAPSE FP_REPRODUCE_ALIGNMENT_FORWARD_MODE; }
			VECTOR FP_REPRODUCE_ALIGNMENT_UP {}
			REAL FP_REPRODUCE_ALIGNMENT_INHERITANCE { STEP 1; CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
		}
		// Angular Velocity
		GROUP FP_REPRODUCE_ANGULARVELOCITY
		{
			REAL FP_REPRODUCE_ANGULARVELOCITY_SPINSPEED { DEFAULT 0; UNIT DEGREE; PARENTCOLLAPSE; }
			REAL FP_REPRODUCE_ANGULARVELOCITY_SPINSPEED_VARIANCE { DEFAULT 0; UNIT DEGREE; PARENTCOLLAPSE FP_REPRODUCE_ANGULARVELOCITY_SPINSPEED; }
			LONG FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE
			{
				CYCLE
				{
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE_AXIS;
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE_VELOCITYDIRECTION;
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE_RADIAL;
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE_RANDOM;
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE_OBJECT;
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE_VECTOR;
				}
				DEFAULT FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE_VELOCITYDIRECTION;
				PARENTCOLLAPSE;
			}
			LONG FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_AXIS
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					FP_REPRODUCE_DIRECTION_POSX;
					FP_REPRODUCE_DIRECTION_NEGX;
					FP_REPRODUCE_DIRECTION_POSY;
					FP_REPRODUCE_DIRECTION_NEGY;
					FP_REPRODUCE_DIRECTION_POSZ;
					FP_REPRODUCE_DIRECTION_NEGZ;
				}
				DEFAULT FP_REPRODUCE_AXISDIRECTION_POSZ;
				PARENTCOLLAPSE FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE;
			}
			VECTOR FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_VECTOR { PARENTCOLLAPSE FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE; }
			LINK FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_OBJECT_LINK 
			{
				ACCEPT
				{
					obase;
				}  
				ANIM OFF; 
				PARENTCOLLAPSE FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE;
			}
			LONG FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_SPACE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_SPACE_ALIGNMENT;
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_SPACE_LOCAL;
					FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_SPACE_GLOBAL;
				}
				DEFAULT FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_SPACE_ALIGNMENT;
				PARENTCOLLAPSE FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE;
			}
			REAL FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_FOV { DEFAULT 0; MIN 0; MAX 360; UNIT DEGREE; PARENTCOLLAPSE FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE; }
			REAL FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_FOVFALLOFF { DEFAULT 0; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; MIN 0.0; MAX 100.0; DEFAULT 0.0; UNIT PERCENT; PARENTCOLLAPSE FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_MODE; }
			REAL FP_REPRODUCE_ANGULARVELOCITY_SPINSPEED_INHERITANCE { STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
			REAL FP_REPRODUCE_ANGULARVELOCITY_SPINVECTOR_INHERITANCE { STEP 1; CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
		}
		GROUP FP_REPRODUCE_COLOR
		{
			DEFAULT 0;

			LONG FP_REPRODUCE_COLOR_MODE 
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					FP_REPRODUCE_COLOR_MODE_CONSTANT;
					FP_REPRODUCE_COLOR_MODE_RANDOM;
					FP_REPRODUCE_COLOR_MODE_NOISE;
				}
				DEFAULT FP_REPRODUCE_COLOR_MODE_NOISE;
			}
						
			COLOR FP_REPRODUCE_COLOR_COLOR { }
			REAL FP_REPRODUCE_COLOR_COLOR_ALPHA { DEFAULT 100.0; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }
						
			GRADIENT FP_REPRODUCE_COLOR_GRADIENT { OPEN; COLOR; ALPHA; FIELD COLOR; ICC_BASEDOCUMENT; }
			
			INCLUDE_IN_GROUP onoise;

			REAL FP_REPRODUCE_COLOR_INHERITANCE { MIN 0.0; MAX 100.0; STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
		}
		
		GROUP FP_REPRODUCE_RADIUS
		{
			DEFAULT 0;
			REAL FP_REPRODUCE_RADIUS_RADIUS { DEFAULT 1.0; MIN 0; UNIT METER; PARENTCOLLAPSE; }
			REAL FP_REPRODUCE_RADIUS_VARIANCE { DEFAULT 0.0; MIN 0.0; UNIT METER; PARENTCOLLAPSE FP_REPRODUCE_RADIUS_RADIUS; }
			REAL FP_REPRODUCE_RADIUS_INHERITANCE { STEP 1; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100.0; DEFAULT 0.0; UNIT PERCENT; }
		}
	}
	GROUP FP_REPRODUCE_CUSTOM
	{
		
	}
}
