#ifndef OFPEMITTERATTRIBUTES_H__
#define OFPEMITTERATTRIBUTES_H__

enum
{
	FP_EMITTER_ATTRIBUTES = 1100,
	// LIFETIME
	FP_EMITTER_ATTRIBUTES_LIFETIME = 10300,
	FP_EMITTER_ATTRIBUTES_LIFETIME_EXPECTATION = 10301,
	FP_EMITTER_ATTRIBUTES_LIFETIME_VARIANCE = 10302,
	FP_EMITTER_ATTRIBUTES_LIFETIME_INFINITE = 10303,
	FP_EMITTER_ATTRIBUTES_LIFETIME_LIMITED = 10304,
	// Velocity
	FP_EMITTER_ATTRIBUTES_VELOCITY = 10400,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE = 10401,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_AXIS = 0,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_NORMAL = 2,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_RADIAL = 3,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_RANDOM = 4,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_VECTOR = 5,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_TARGET = 6,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_TANGENTIAL = 7,
		FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_MODE_RAIL = 8,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_AXIS = 10402,
		FP_EMITTER_ATTRIBUTES_DIRECTION_POSX = 0,
		FP_EMITTER_ATTRIBUTES_DIRECTION_NEGX = 1,
		FP_EMITTER_ATTRIBUTES_DIRECTION_POSY = 2,
		FP_EMITTER_ATTRIBUTES_DIRECTION_NEGY = 3,
		FP_EMITTER_ATTRIBUTES_DIRECTION_POSZ = 4,
		FP_EMITTER_ATTRIBUTES_DIRECTION_NEGZ = 5,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_VECTOR = 10403,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_TARGET_LINK = 10404,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_RAIL_LINK = 10405,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_SPACE = 10406,
		FP_EMITTER_ATTRIBUTES_SPACE_GLOBAL = 0,
		FP_EMITTER_ATTRIBUTES_SPACE_LOCAL = 1,
		FP_EMITTER_ATTRIBUTES_SPACE_ALIGNMENT = 2,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_FOV = 10407,
	FP_EMITTER_ATTRIBUTES_VELOCITY_DIRECTION_FOVFALLOFF = 10408,
	FP_EMITTER_ATTRIBUTES_VELOCITY_SPEED = 10409,
	FP_EMITTER_ATTRIBUTES_VELOCITY_SPEED_VARIATION = 10410,
	FP_EMITTER_ATTRIBUTES_VELOCITY_ADDSOURCEVELOCITY = 10411,
	FP_EMITTER_ATTRIBUTES_VELOCITY_ADDSOURCEVELOCITY_LINEAR = 10412,
	FP_EMITTER_ATTRIBUTES_VELOCITY_ADDSOURCEVELOCITY_ANGULAR = 10413,
	FP_EMITTER_ATTRIBUTES_VELOCITY_HANDLES = 10414,
	FP_EMITTER_ATTRIBUTES_VELOCITY_SPEED_ENABLEVARIANCE = 10415,
	// Alignment
	FP_EMITTER_ATTRIBUTES_ALIGNMENT = 10500,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE = 10501,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_AXIS = 0,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_VELOCITYDIRECTION = 1,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_RANDOM = 2,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_VECTOR = 4,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_TARGET = 5,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_NORMAL = 6,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_RADIAL = 7,
		FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_MODE_TANGENTIAL = 8,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_AXIS = 10502,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_AXIS_SPACE = 10503,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_VECTOR = 10504,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_TARGET_LINK = 10505,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_FOV = 10506,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_FORWARD_FOVFALLOFF = 10507,
	FP_EMITTER_ATTRIBUTES_ALIGNMENT_UP = 10508,
	// Angular Velocity
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY = 10600,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE = 10601,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_AXIS = 0,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_VELOCITYDIRECTION = 1,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_RANDOM = 2,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_VECTOR = 4,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_TARGET = 5,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_NORMAL = 6,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_RADIAL = 7,
		FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_MODE_TANGENTIAL = 8,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_AXIS = 10602,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_VECTOR = 10603,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_TARGET_LINK = 10604,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_SPACE = 10605,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_FOV = 10606,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINVECTOR_FOVFALLOFF = 10607,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINSPEED = 10608,
	FP_EMITTER_ATTRIBUTES_ANGULARVELOCITY_SPINSPEED_VARIANCE = 10609,
	// Colors
	FP_EMITTER_ATTRIBUTES_COLOR = 10700,
	FP_EMITTER_ATTRIBUTES_COLOR_COLOR = 10701,
	FP_EMITTER_ATTRIBUTES_COLOR_GRADIENT = 10702,
	FP_EMITTER_ATTRIBUTES_COLOR_MODE = 10703,
		FP_EMITTER_ATTRIBUTES_COLOR_MODE_NOISE = 0,
		FP_EMITTER_ATTRIBUTES_COLOR_MODE_ALONGSPLINE = 1,
		FP_EMITTER_ATTRIBUTES_COLOR_MODE_RANDOM = 2,
		FP_EMITTER_ATTRIBUTES_COLOR_MODE_CONSTANT = 3,
	FP_EMITTER_ATTRIBUTES_COLOR_SPLINE_REPEAT = 10704,
	FP_EMITTER_ATTRIBUTES_COLOR_COLOR_ALPHA = 10705,
	// Radius
	FP_EMITTER_ATTRIBUTES_RADIUS = 90800, // oops accidental id choice, forces us to leave the 10k-91k range for system attribute ids
	FP_EMITTER_ATTRIBUTES_RADIUS_RADIUS = 90801,
	FP_EMITTER_ATTRIBUTES_RADIUS_VARIANCE = 90802,
	
	// Liquid
	FP_EMITTER_ATTRIBUTES_LIQUID = 10800,
	FP_EMITTER_ATTRIBUTES_LIQUID_LIQUIDCONTRIBUTION = 10801,
	// Liquid Radius
	FP_EMITTER_ATTRIBUTES_LIQUID_RADIUS = 10900,
	FP_EMITTER_ATTRIBUTES_LIQUID_RADIUS_SOURCE = 10901,
		FP_EMITTER_ATTRIBUTES_LIQUID_RADIUS_SOURCE_SIMULATIONSCENE = 0,
		FP_EMITTER_ATTRIBUTES_LIQUID_RADIUS_SOURCE_OVERRIDE = 1,
	FP_EMITTER_ATTRIBUTES_LIQUID_RADIUS_RADIUS = 10902,
	// Liquid Constraints 
	FP_EMITTER_ATTRIBUTES_LIQUID_CONSTRAINTS = 11000,
	FP_EMITTER_ATTRIBUTES_LIQUID_CONSTRAINTS_MASSDENSITY = 11001,
	FP_EMITTER_ATTRIBUTES_LIQUID_CONSTRAINTS_VISCOSITY = 11002,
	FP_EMITTER_ATTRIBUTES_LIQUID_CONSTRAINTS_SURFACETENSION = 11003,
	FP_EMITTER_ATTRIBUTES_LIQUID_CONSTRAINTS_MIXTURE = 11004,
	FP_EMITTER_ATTRIBUTES_LIQUID_CONSTRAINTS_EASEIN = 11005,
	// Liquid Collisions 
	FP_EMITTER_ATTRIBUTES_LIQUID_COLLISIONS = 11100,
	FP_EMITTER_ATTRIBUTES_LIQUID_COLLISIONS_FRICTION = 11101,
	FP_EMITTER_ATTRIBUTES_LIQUID_COLLISIONS_STICKINESS = 11102,
	FP_EMITTER_ATTRIBUTES_LIQUID_COLLISIONS_INTERACTION_MASS = 11103,
	// Liquid Damping 
	FP_EMITTER_ATTRIBUTES_LIQUID_DAMPING = 11200,
	FP_EMITTER_ATTRIBUTES_LIQUID_DAMPING_SOURCE = 11201,
		FP_EMITTER_ATTRIBUTES_LIQUID_DAMPING_SOURCE_SIMULATIONSCENE = 0,
		FP_EMITTER_ATTRIBUTES_LIQUID_DAMPING_SOURCE_OVERRIDE = 1,
	FP_EMITTER_ATTRIBUTES_LIQUID_DAMPING_DAMPING = 11202,

	// Maps
	// Velocity
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_VELOCITY_DIRECTION_MAP = 20201,
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_VELOCITY_DIRECTION_MIX = 20202,
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_VELOCITY_SPEED_MAP = 20203,
	// Alignment
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_ALIGNMENT_FORWARD_MAP = 20301,
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_ALIGNMENT_FORWARD_MIX = 20302,
	// Angular Velocity
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_ANGULARVELOCITY_SPINVECTOR_MAP = 20401,
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_ANGULARVELOCITY_SPINVECTOR_MIX = 20402,
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_ANGULARVELOCITY_SPINSPEED_MAP = 20403,
	// Colors
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_COLOR_MAP = 20501,
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_COLOR_MIX = 20502,
	// Radius
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_RADIUS_MAP = 20601,
	// Lifetime
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_LIFETIME_EXPECTATION_MAP = 20701,
	FP_GEOMETRYMAPS_ATTRIBUTEMAPS_LIFETIME_VARIANCE_MAP = 20702,

	// Custom
	FP_EMITTER_ATTRIBUTES_CUSTOM_LEGACY = 30000, // this id choice is problematic because it falls inside the 10k-91k range of system attribute ids above
	FP_EMITTER_ATTRIBUTES_CUSTOM = 100000,

	FP_EMITTER_ATTRIBUTES_DUMMY
};

#endif // OFPEMITTERATTRIBUTES_H__
