#ifndef C4D_SYMBOLS_H__
#define C4D_SYMBOLS_H__

enum
{
	// string table definitions
	IDS_START = 10000,

	IDS_ODISC,
	IDS_OSINGLEPOLY,
	IDS_OTORUS,
	IDS_OCUBE,
	IDS_OSPHERE,
	IDS_OPLATONIC,
	IDS_OFIGURE,
	IDS_OPYRAMID,
	IDS_OPLANE,
	IDS_OTUBE,
	IDS_OFRACTAL,
	IDS_OCONE,
	IDS_OCYLINDER,
	IDS_OCAPSULE,
	IDS_OOILTANK,
	IDS_ORELIEF,

	IDS_OSPLINECIRCLE,
	IDS_OSPLINEARC,
	IDS_OSPLINECISSOID,
	IDS_OSPLINECYCLOID,
	IDS_OSPLINEPROFILE,
	IDS_OSPLINECONTOUR,
	IDS_OSPLINEHELIX,
	IDS_OSPLINERECTANGLE,
	IDS_OSPLINESTAR,
	IDS_OSPLINECOGWHEEL,
	IDS_OSPLINEFLOWER,
	IDS_OSPLINEFORMULA,
	IDS_OSPLINETEXT,
	IDS_OSPLINE4SIDE,
	IDS_OSPLINENSIDE,

	IDS_OPARTICLEBASE,
	IDS_OGRAVITATION,
	IDS_OATTRACTOR,
	IDS_ODESTRUCTOR,
	IDS_ODEFLECTOR,
	IDS_OFRICTION,
	IDS_OROTATION,
	IDS_OTURBULENCE,
	IDS_OWIND,

	IDS_OHEADPHONE_DEPRECATED,
	IDS_OBACKGROUND,
	IDS_OFOREGROUND,
	IDS_OCONPLANE,
	IDS_OENVIRONMENT,
	IDS_OFLOOR,
	IDS_OSTAGE,
	IDS_OLOUDSPEAKER_DEPRECATED,
	IDS_OMICROPHONE,

	IDS_OBEND,
	IDS_OBULGE,
	IDS_OTWIST,
	IDS_OTAPER,
	IDS_OSHEAR,

	IDS_OEXPLOSION,
	IDS_OFORMULA,
	IDS_OMELT,
	IDS_OSHATTER,
	IDS_OWINDDEFORM,
	IDS_OWRAP,

	IDS_OPOLYREDUCTION,
	IDS_POLYREDUCTION,
	IDS_BOOLEOBJECT,

	IDS_VERTEX,
	IDS_HANDEFFECTOR,
	IDS_FOOTEFFECTOR,
	IDS_FIGURELEFT,
	IDS_FIGURERIGHT,
	IDS_HEADEFFECTOR,
	IDS_UPPERBODY,
	IDS_NECK,
	IDS_UPPERARM,
	IDS_LOWERARM,
	IDS_UPPERKNEE,
	IDS_LOWERKNEE,
	IDS_HAND,
	IDS_FOOT,
	IDS_HEAD,
	IDS_JOINT,
	IDS_TEXTCONTENT,

	// Pipe Object result names
	IDS_PIPEOBJECT_PROFILE_OUTER,
	IDS_PIPEOBJECT_CONNECTOBJ,
	IDS_PIPEOBJECT_PROFILE_INNER,
	// Pipe Object result names

	// Global string definitions start here
	IDS_SDSOBJECT,
	IDS_SDS_TOOL,
	IDS_WEIGHT_TAG_NAME,
	IDS_SELECT_SDS_OBJECT,
	IDS_NUMBER,
	IDS_EDGES,
	IDS_POINTS,
	IDS_MIN,
	IDS_MAX,
	IDS_AVERAGE,
	// Global string definitions end here

	// Dialog definitions of IDC_SDS_TOOL_DLG start here
	IDC_SDS_TOOL_DLG,
	IDC_SET_POINT_WT_CHK,
	IDC_SET_EDGE_WT_CHK,
	IDC_SELECT_ONLY_VISIBLE_CHK,
	IDC_SELECT_NEIGHBORS_CHK,
	IDC_WEIGHT_EDIT,
	IDC_MIN_WEIGHT_EDIT,
	IDC_MAX_WEIGHT_EDIT,
	IDC_ALL_WEIGHTS_BTN,
	IDC_SELECT_ALL_BTN,
	IDC_SET_SELECTED_WEIGHT_BTN,
	// Dialog definitions of IDC_SDS_TOOL_DLG end here

	IDS_INEXCLUDETAG,

	IDS_EDGE_LOOP,
	IDS_EDGE_RING,
	IDS_EDGE_TO_SPLINE,
	IDS_EDGE_CUT,
	IDS_EDGE_EXTRUDE,
	IDS_EDGE_BEVEL,
	IDS_EDGE_MELT,

	IDS_SPLINE,

	// Dialog definitions of IDC_EDGE_CUT_DIALOG start here
	IDC_EDGE_CUT_DIALOG,
	IDC_EDGE_CUT_SUBDIV_EDIT,
	IDC_EDGE_CUT_KEEP_SEL_CHK,
	// Dialog definitions of IDC_EDGE_CUT_DIALOG end here

	IDS_EXPLOSIONFX,
	IDS_SELECTIONOBJECT,
	IDS_ATOMARRAY,
	IDS_ATOMPOINT,
	IDS_ATOMEDGE,
	IDS_LOOKATCAMERA,
	IDS_VIBRATE,
	IDS_ALIGNTOSPLINE,
	IDS_ALIGNTOPATH,
	IDS_SUNEXPRESSION,
	IDS_SPLINEDEFORMER,
	IDS_SPLINERAIL,
	IDS_SPHERIFY,
	IDS_POINTPROJECTOR,
	IDS_POLY_SELECTION_GROW,
	IDS_OUTLINE_POLYSELECTION,

	IDS_HLP_WEIGHT,

	IDS_FLT_LISTSELECTION,
	IDS_FLT_QKAMERA,
	IDS_FLT_LIGHT,
	IDS_FLT_BMATERIAL,
	IDS_FLT_OBJNAME,
	IDS_FLT_VRML2_ERROR,
	IDS_FLT_VRML_INLINETEXTURE1,
	IDS_FLT_VRML_INLINETEXTURE2,
	IDS_FLT_AXISOBJECT,

	IDS_FLT_QSPHERE,
	IDS_FLT_QQUADER,
	IDS_FLT_QCONE,
	IDS_FLT_QCYLINDER,
	IDS_FLT_QCUBE,
	IDS_FLT_QFRAKTAL,
	IDS_FLT_ROTATIONOBJECT,

	IDS_FLT_LNAME,
	IDS_FLT_LID1,
	IDS_FLT_LID2,
	IDS_FLT_ADOBEPFAD,
	IDS_FLT_ADOBELAYER,
	IDS_FLT_ADOBEGRUPPE,

	IDS_FLT_ILLUSTRATOR,
	IDS_FLT_SVG,
	IDS_FLT_VECTORART_OBJECT,
	IDS_FLT_VECTORART_TAG,

	IDS_FLT_VECTORART_FILE_EMPTY_MSG,
	IDS_FLT_VECTORART_FILE_UNKNOWN_FORMAT_MSG,

	IDS_FLT_ILLUSTRATOR_8_STRING,
	IDS_FLT_ILLUSTRATOR_CC_STRING,

	IDS_C4DFALLOFF_INFINITE,
	IDS_C4DFALLOFF_BOX,
	IDS_C4DFALLOFF_SPHERE,
	IDS_C4DFALLOFF_LINEAR,
	IDS_C4DFALLOFF_CYLINDER,
	IDS_C4DFALLOFF_OBJECT,
	IDS_C4DFALLOFF_CONE,
	IDS_C4DFALLOFF_TORUS,

	// Dialog definitions of dlg_previewmaker start here
	DLG_PREVIEWMAKER,
	IDC_PM_ASEDITOR,
	IDC_PREVIEW_MODE_COMBO,
	IDC_HQ_VIEWPORT_TRANSPARENCY_CHK,
	IDC_HQ_VIEWPORT_SHADOWS_CHK,
	IDC_HQ_VIEWPORT_POSTEFFECTS_CHK,
	IDC_HQ_VIEWPORT_NOISES_CHK,
	IDC_PM_TIMERANGE,
	IDC_PM_TIME2,
	IDC_PM_TIME3,
	IDC_PM_TIME1,
	IDC_PM_FROM,
	IDC_PM_TO,
	IDC_PM_RES,
	IDC_PM_RESDISPLAY,
	IDC_PM_FRAMERATE,
	IDC_PM_COMPRESSOR,
	IDC_PM_QT,
	IDC_PM_AVI,
	IDC_PM_COMPRESSOROPTIONS,
	// Dialog definitions of dlg_previewmaker end here

	IDS_PREVIEWMAKER,
	IDS_PREVIEWHELP,
	IDS_PM_CALC,
	IDS_PM_RUNNING,
	IDS_PM_RAY_NOMEM,
	IDS_PM_RAY_TEXMISSING,
	IDS_PM_RAY_MP,
	IDS_PM_RAY_IMAGE,
	IDS_PM_RAY_USERBREAK,
	IDS_PM_RAY_GICACHE,
	IDS_SNIPER_SAVE_REGION_COMMAND,				// save region command
	IDS_SNIPER_SAVE_DIALOG_COMMAND,				// Show sniper dialog
	IDS_SNIPER_VIEWPORT_COMMAND,
	IDS_SNIPER_OBJECT,
	IDS_VS_EDIT,
	IDS_VS_SET_DEFAULT,
	IDS_NODOCLOADED,
	IDS_SCENEOPENED,
	IDS_SCENEOUTOFDATE,
	IDS_SCENEUPTODATE,
	IDS_FPS,
	IDS_DELETED_1,
	IDS_DELETED_2,
	IDS_DELETED_3,
	IDS_DELETED_4,
	IDS_DELETED_5,
	IDS_XREFS_NAME,
	IDS_DELETED_6,
	IDS_DELETED_7,
	IDS_XREFS_SETCENTER,
	IDS_XREFS_RESETCENTER,
	IDS_XREFS_WARNING,
	IDS_XREFS_BROKENLINK,
	IDS_XREFS_COL_OBJECT,
	IDS_XREFS_COL_EDITOR,
	IDS_XREFS_COL_RENDER,
	IDS_XREFS_COL_GENERATOR,
	IDS_SENDTOALLPLAN,
	IDS_ALLPLAN_CREATEDIR,
	IDS_ALLPLANERROR1,
	IDS_ALLPLANERROR2,


	//PNG Dialog definitions
	DLG_PNG,
	GADGET_PNG_INTERLACED,

	//DPX Dialog definitions
	DLG_DPX,
	GADGET_DPX_PLANAR,

	IDS_PLUGIN_NAME,
	IDS_PLUGIN_DESCR,
	IDS_ALL,
	IDS_REPLACE1,
	IDS_REPLACE2,
	IDS_HEADLINE,

	IDS_FRAMESPERSECOND,
	IDS_FRAMESPERSECOND_HELP,

	DLG_FRAMESPERSECOND,
	GADGET_MODE_1,
	GADGET_MODE_2,
	GADGET_MODE_3,
	GADGET_MOVE,
	GADGET_ROTATE,
	GADGET_ACTIVEVIEW,
	GADGET_TIMER,
	GADGET_FPS,
	GADGET_START,
	GADGET_STOP,
	GADGET_TESTANIM,
	GADGET_REVERSE,
	// see GADGET_TEXTUREVIEW below

	IDS_ANNOTATIONTAG,
	IDS_ANNOTATIONTAGSCENEHOOK,
	IDS_ANNOTATIONTOOL,
	IDS_ANNOTATIONTOOL_INACTIVE_HELP,
	IDS_ANNOTATIONTOOL_ACTIVE_HELP,

	IDS_PRIORITYOFFSETTAG,
	IDS_PELVIS,
	IDS_INSTANCEOBJECT,

	IDS_LODOBJECT,
	IDS_LODOBJECT_LEVEL,
	IDS_LODOBJECT_HIDE,
	IDS_LODOBJECT_OBJECTS,
	IDS_LODOBJECT_FULLOBJECT,
	IDS_LODOBJECT_DECIMATED,
	IDS_LODOBJECT_CH,
	IDS_LODOBJECT_BB,
	IDS_LODOBJECT_NULL,
	IDS_LODOBJECT_SIMPLIFYMODE,
	IDS_LODOBJECT_STRENGTH,
	IDS_LODOBJECT_PEROBJ,
	IDS_LODOBJECT_NULLPARAM,
	IDS_LODOBJECT_HUD_MAIN,
	IDS_LODOBJECT_HUD_CAM,
	IDS_LODOBJECT_DISPLAY,
	IDS_LODOBJECT_ORIGINALSHADING,
	IDS_LODOBJECT_ORIGINALWIRE,
	IDS_LODOBJECT_LODVALUESTRING,

	IDS_C4DFALLOFF_NOISE,
	IDS_FSPHERICAL,
	IDS_FLINEAR,
	IDS_FBOX,
	IDS_FCONE,
	IDS_FCYLINDER,
	IDS_FTORUS,
	IDS_FCAPSULE,

	IDS_PRIM_PLATONIC_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_PYRAMID_CONFIRM_SWITCH_MESSAGE,

	IDS_FALLOFFCONVERTFIELD,

	// used in DLG_FRAMESPERSECOND, see above
	GADGET_TEXTUREVIEW,
	GADGET_WITHOUTVIEW,
	GADGET_NOUIUPDATE,
	IDS_FIELDFORCE,
	IDS_PRIM_SPHERE_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_CONE_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_CYLINDER_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_CAPSULE_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_OILTANK_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_TORUS_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_TUBE_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_FIGURE_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_FRACTAL_CONFIRM_SWITCH_MESSAGE,
	IDS_PRIM_RELIEF_CONFIRM_SWITCH_MESSAGE,

	IDS_FRAMESPERSECOND_ANIM_TEST_RESULT,
	IDS_USERDATA_TAG,
	IDS_ANNOTATION_COLOR,
	IDS_OREMESH,
	IDS_REMESH_STATUS,

  IDS_TAG_DELTAMUSH,
  IDS_DELTAMUSH_DEFORMER,
  ID_DELTAMUSH_OBJECT_MEM_SIZE,
  ID_DELTAMUSH_ADDBOTH,
  ID_DELTAMUSH_ADDBOTH_STRING,

	IDS_EDGE_CUT_NAME = 1000,
	IDS_EDGE_CUT_HELP,
	IDS_LOOP_NAME,
	IDS_LOOP_HELP,
	IDS_RING_NAME,
	IDS_RING_HELP,
	IDS_POINT_RING_NAME,
	IDS_POINT_RING_HELP,
	IDS_FILL_SELECTION_NAME,
	IDS_FILL_SELECTION_HELP,
	IDS_OUTLINE_SELECTION_NAME,
	IDS_OUTLINE_SELECTION_HELP,
	IDS_MEASURE_TOOL_NAME,
	IDS_MEASURE_TOOL_HELP,
	IDS_MEASURE_OBJECT_NAME,
	IDS_SEARCH_COMMAND,
	IDS_SEARCH_COMMAND_HELP,
	IDS_SEARCT_MATCH,
	IDS_SEARCT_START,
	IDS_SEARCT_END,
	IDS_SEARCT_CONTAIN,
	IDS_SEARCH_CASE_SENSITIVE,
	IDS_OBJECTS,
	IDS_TAGS,
	IDS_ME_MOVE,
	IDS_ME_SCALE,
	IDS_ME_ROTATE,
	IDS_AXIS_X,
	IDS_AXIS_Y,
	IDS_AXIS_Z,
	IDS_CONVERT_SELECTION_NAME,
	IDS_CONVERT_SELECTION_TYPE,
	IDS_MELT_NAME,
	IDS_MELT_HELP,
	IDS_EDGE_TO_SPLINE_NAME,
	IDS_EDGE_TO_SPLINE_HELP,
	IDS_MATRIX_EXTRUDE_NAME,
	IDS_MATRIX_EXTRUDE_HELP,
	IDS_COLLAPSETOOL_NAME,
	IDS_COLLAPSETOOL_HELP,
	IDS_POLYGON_CREATE_NAME,
	IDS_POLYGON_CREATE_HELP,
	IDS_POINT_ADD_NAME,
	IDS_POINT_ADD_HELP,
	IDS_BRIDGE_NAME,
	IDS_BRIDGE_HELP,
	IDS_BRIDGE_INFO1,
	IDS_BRIDGE_INFO2,
	IDS_WELD_NAME,
	IDS_WELD_HELP,
	IDS_WELD_INFO,
	IDS_CLOSEHOLE_NAME,
	IDS_CLOSEHOLE_HELP,
	IDS_STITCHANDSEW_NAME,
	IDS_STITCHANDSEW_HELP,
	IDS_STITCHANDSEW_INFO,
	IDS_STITCHANDSEW_INFO2,
	IDS_SLIDE_NAME,
	IDS_SLIDE_HELP,
	IDS_IRON_NAME,
	IDS_IRON_HELP,
	IDS_IRON_INFO,
	IDS_MODELING_NORMALMOVE,
	IDS_MODELING_NORMALMOVE_H,
	IDS_MODELING_NORMALSCALE,
	IDS_MODELING_NORMALSCALE_H,
	IDS_MODELING_NORMALROTATE,
	IDS_MODELING_NORMALROTATE_H,
	IDS_MODELING_EXTRUDEINNER,
	IDS_MODELING_EXTRUDEINNER_H,
	IDS_MODELING_BEVEL,
	IDS_MODELING_BEVEL_H,
	IDS_MODELING_EXTRUDE,
	IDS_MODELING_EXTRUDE_H,
	ID_MODELING_SETVALUE,
	ID_MODELING_SETVALUE_H,
	ID_TOOL_DUPLICATE,
	ID_TOOL_DUPLICATE_H,
	ID_TOOL_ARRANGE,
	ID_TOOL_ARRANGE_H,
	ID_TOOL_TRANSFER,
	ID_TOOL_TRANSFER_H,
	ID_TOOL_RANDOMIZE,
	ID_TOOL_RANDOMIZE_H,
	ID_TOOL_CENTER,
	ID_TOOL_CENTER_H,
	IDS_KNIFE_NAME,
	IDS_KNIFE_HELP,
	IDS_TOOL_MODIFY,
	IDS_TOOL_MODIFY_H,
	IDS_INSTANT_RENDER_NAME,
	IDS_INSTANT_RENDER_HELP,
	IDS_MAGNETTOOL_NAME,
	IDS_MAGNETTOOL_HELP,
	IDS_BRUSHTOOL_NAME,
	IDS_BRUSHTOOL_HELP,
	IDS_CLONE_NAME,
	IDS_CLONE_HELP,
	IDS_SPLINE_CHAMFER_NAME,
	IDS_SPLINE_CHAMFER_HELP,
	IDS_ARRAY_NAME,
	IDS_ARRAY_HELP,
	IDS_SPLINE_PROJECT_NAME,
	IDS_SPLINE_PROJECT_HELP,
	IDS_MODELING_FITCIRCLE,
	IDS_MODELING_FITCIRCLE_H,
	IDS_MODELING_EDGESMOOTH,
	IDS_MODELING_EDGESMOOTH_H,
	IDS_MODELING_SETEDGEFLOW,
	IDS_MODELING_SETEDGEFLOW_H,
	IDS_MODELING_SETEDGESLINEAR,
	IDS_MODELING_SETEDGESLINEAR_H,
	IDS_MODELING_EVENSPACING,
	IDS_MODELING_EVENSPACING_H,
	IDS_MODELING_FLATTEN,
	IDS_MODELING_FLATTEN_H,
	IDS_MODELING_SOLIDIFY_TOOL,
	IDS_MODELING_SOLIDIFY_TOOL_H,
	IDS_MODELING_ATTRIBUTETRANSFER_COMMAND,
	IDS_MODELING_ATTRIBUTETRANSFER_COMMAND_H,

	IDS_HUDPOP_SHOW_MENU,
	IDS_HUDPOP_DISPLAY_MENU,
	IDS_HUDPOP_SLIDER_MENU,
	IDS_HUDPOP_LAYOUT_MENU,
	IDS_HUDPOP_RELATIVE,
	IDS_HUDPOP_PIXELS,
	IDS_HUDPOP_VERTICAL,
	IDS_HUDPOP_REMOVE,
	IDS_HUDPOP_MAKEGROUP,
	IDS_HUDPOP_GROUPREMOVE,
	IDS_HUDPOP_PROPERTIES,
	IDS_HUDPOP_SHOW_MENU_OBJECTACTIVE,
	IDS_HUDPOP_SHOW_MENU_ALWAYS,
	IDS_HUDPOP_SHOW_MENU_PARENTACTIVE,
	IDS_HUDPOP_SHOW_MENU_ROOTHIERARCHYACTIVE,
	IDS_HUDPOP_SHOW_MENU_SAMEACTIVE,
	IDS_HUDPOP_SHOW_MENU_RENDER,
	IDS_HUDPOP_SHOW_MENU_LOCKVIEW,
	IDS_HUDPOP_DISPLAY_MENU_OBJECTNAME,
	IDS_HUDPOP_DISPLAY_MENU_NAME,
	IDS_HUDPOP_DISPLAY_MENU_WIDGET,
	IDS_HUDPOP_DISPLAY_MENU_FRAME,
	IDS_HUDPOP_DISPLAY_MENU_KEY,
	IDS_HUDPOP_DISPLAY_MENU_ICON,
	IDS_HUDPOP_SLIDER_MENU_BOX,
	IDS_HUDPOP_SLIDER_MENU_CIRCLE,
	IDS_HUDPOP_SLIDER_MENU_TRI,
	IDS_HUDPOP_SLIDER_MENU_PENT,
	IDS_HUDPOP_SLIDER_MENU_DIAMOND,
	IDS_HUDPOP_SLIDER_MENU_LEFT,
	IDS_HUDPOP_SLIDER_MENU_RIGHT,
	IDS_HUDPOP_SLIDER_MENU_UP,
	IDS_HUDPOP_SLIDER_MENU_DOWN,
	IDS_HUDPOP_LAYOUT_MENU_ALIGNLEFT,
	IDS_HUDPOP_LAYOUT_MENU_ALIGNRIGHT,
	IDS_HUDPOP_LAYOUT_MENU_ALIGNTOP,
	IDS_HUDPOP_LAYOUT_MENU_ALIGNBOTTOM,
	IDS_HUDPOP_LAYOUT_MENU_CENTERHORZ,
	IDS_HUDPOP_LAYOUT_MENU_CENTERVERT,
	IDS_HUDPOP_LAYOUT_MENU_TILEHORZ,
	IDS_HUDPOP_LAYOUT_MENU_TILEVERT,
	IDS_HUDPOP_LAYOUT_MENU_SPACEHORZ,
	IDS_HUDPOP_LAYOUT_MENU_SPACEVERT,
	IDS_HUDPOP_REFRESH,
	IDS_HUDPOP_COLOR_TEXT,
	IDS_HUDPOP_COLOR_BACK,
	IDS_HUDPOP_COLOR_HIGHLIGHT,
	IDS_HUDPOP_COLOR_RESET,
	IDS_HUDPOP_ICON_SIZE,
	IDS_HUDPOP_ICON_SIZE_SMALL,
	IDS_HUDPOP_ICON_SIZE_MEDIUM,
	IDS_HUDPOP_ICON_SIZE_LARGE,
	IDS_HUDPOP_ICON_SIZE_FIT,
	IDS_HUDPOP_ICON_SIZE_ORIGINAL,
	IDS_HUDPOP_ICON_LOAD,
	IDS_HUDPOP_RESET,
	IDS_HUDPOP_SHOWDESCID,
	IDS_HUDPOP_ACTION_ENABLE,
	IDS_HUDPOP_ACTION_MOVE,
	IDS_HUDPOP_ACTION_SCALE,
	IDS_HUDPOP_ACTION_ROTATE,
	IDS_HUDPOP_ACTION_COMMAND,
	IDS_HUDPOP_COLOR_MENU,
	IDS_HUDPOP_ACTION_MENU,
	IDS_HUDPOP_DISPLAY_MENU_AUTOFOLDER,

	IDS_HUD_GROUP_NAME,
	IDS_MODE_TWEAK,
	IDS_MODE_NORMAL,
	IDS_MODE_AUTOSWITCH,
	IDS_FORMAT_DATE,
	IDS_FORMAT_TIME,

	// Dialog definitions of IDD_SEARCH_DIALOG start here
	IDD_SEARCH_DIALOG,
	IDC_SEARCH_NAME_EDIT,
	IDC_SEARCH_TYPE_ARROW,
	ID_SEARCH_TYPE_OBJECT,
	ID_SEARCH_TYPE_TAG,
	// Dialog definitions of IDD_SEARCH_DIALOG end here

	// Dialog definitions of IDD_CONVERT_SELECTION_DIALOG start here
	IDD_CONVERT_SELECTION_DLG,
	IDC_CONVERTSELECTION_LEFT,
	IDC_CONVERTSELECTION_LEFT_1,
	IDC_CONVERTSELECTION_LEFT_2,
	IDC_CONVERTSELECTION_LEFT_3,
	IDC_CONVERTSELECTION_LEFT_4,
	IDC_CONVERTSELECTION_RIGHT,
	IDC_CONVERTSELECTION_RIGHT_1,
	IDC_CONVERTSELECTION_RIGHT_2,
	IDC_CONVERTSELECTION_RIGHT_3,
	IDC_CONVERTSELECTION_RIGHT_4,
	IDC_CONVERTSELECTION_TOLERANT,
	IDC_CONVERT_SEL_BTN,
	// see below related IDC_CONVERTSELECTION_LEFT_5,
	// see below related IDC_CONVERTSELECTION_LEFT_6,
	// see below related IDC_CONVERTSELECTION_LEFT_7,
	// see below related IDC_CONVERTSELECTION_RIGHT_5,
	// see below related IDC_CONVERTSELECTION_RIGHT_6,
	// see below related IDC_CONVERTSELECTION_RIGHT_7,

	// Dialog definitions of IDD_CONVERT_SELECTION_DIALOG end here

	// Kernel error strings
	IDS_MODELING_KERNEL_ERROR,
	IDS_MODELING_KERNEL_ERROR_UNKNOWN,
	IDS_MODELING_KERNEL_ERROR_NONE,
	IDS_MODELING_KERNEL_ERROR_FAILED,
	IDS_MODELING_KERNEL_ERROR_NOMEMORY,
	IDS_MODELING_KERNEL_ERROR_NOTFOUND,
	IDS_MODELING_KERNEL_ERROR_INVALIDOP,
	IDS_MODELING_KERNEL_ERROR_FATAL,
	IDS_MODELING_KERNEL_ERROR_INVALIDOBJECT,
	IDS_MODELING_KERNEL_ERROR_ILLEGAL,
	IDS_MODELING_KERNEL_ERROR_TRIANGULATION,
	IDS_MODELING_KERNEL_ERROR_INVALIDKERNEL,
	IDS_MODELING_KERNEL_ERROR_INTERNAL,
	IDS_MODELING_KERNEL_ERROR_BADARGS,
	IDS_MODELING_KERNEL_ERROR_CORRUPTOBJECT,
	IDS_MODELING_KERNEL_ERROR_MSGFAIL,
	//

	// HUD information
	IDS_HUD_FPS,
	IDS_HUD_CAMERADISTANCE,
	IDS_HUD_FRAME,
	IDS_HUD_CAMERA_NAME,
	IDS_HUD_PROJECTION_NAME,
	IDS_HUD_ACTIVE_OBJECT,
	IDS_HUD_ROOT_OBJECT,
	IDS_HUD_PARENT_OBJECT,
	IDS_HUD_TOTAL_OBJECTS,
	IDS_HUD_TOTAL_POINTS,
	IDS_HUD_TOTAL_POLYGONS,
	IDS_HUD_TOTAL_NGONS,
	IDS_HUD_TOTAL_EDGES,
	IDS_HUD_FRAMETIME,
	IDS_HUD_SELECTED_OBJECTS,
	IDS_HUD_SELECTED_NGONS,
	IDS_HUD_SELECTED_POINTS,
	IDS_HUD_SELECTED_EDGES,
	IDS_HUD_SELECTED_POLYGONS,
	IDS_HUD_SELECTED,
	IDS_HUD_TOTAL,
	IDS_HUD_TWEAKACTIVE,
	IDS_HUD_AUTOSWITCHACTIVE,
	IDS_HUD_STATISTIC_TRIANGLES,
	DELME_IDS_HUD_STATISTIC_QUADS,
	IDS_HUD_STATISTIC_LINES,
	IDS_HUD_STATISTIC_POINTS,
	DELME_IDS_HUD_STATISTIC_TRIANGLE_STRIPS,
	DELME_IDS_HUD_STATISTIC_LINE_STRIPS,
	IDS_HUD_SCULPT_STATISTIC_CURRENTLAYER,
	IDS_HUD_SCULPT_STATISTIC_CURRENTLEVEL,
	IDS_HUD_SCULPT_STATISTIC_POLYCOUNT,
	IDS_HUD_SCULPT_STATISTIC_MEMORY_USAGE,
	IDS_HUD_WORKPLANE_STATISTIC,
	IDS_HUD_MARKER,

	// menus
	//
	IDS_NGON_RETRIANGULATE,
	IDS_NGON_FORCE_RETRIANGULATE,
	IDS_NGON_REMOVE,
	IDS_OBJECTHANDLES_ONOFF_IS_DEPRECATED,
	IDS_SDS_INC,
	IDS_SDS_DEC,
	IDS_SDS_ONOFF,
	IDS_OM_SELECT_INVERT,
	IDS_OM_SELECT_HIDE,
	IDS_OM_SELECT_SHOW,

	IDS_LIVESELECTION_NAME,
	IDS_FREESELECTION_NAME,
	IDS_RECTSELECTION_NAME,
	IDS_POLYSELECTION_NAME,
	IDS_LIVESELECTION_HELP,
	IDS_FREESELECTION_HELP,
	IDS_RECTSELECTION_HELP,
	IDS_POLYSELECTION_HELP,

	IDS_MODELING_MOVE_NAME,
	IDS_MODELING_MOVE_HELP,
	IDS_MODELING_SCALE_NAME,
	IDS_MODELING_SCALE_HELP,
	IDS_MODELING_ROTATE_NAME,
	IDS_MODELING_ROTATE_HELP,

	IDS_CAMERA_MOVE,
	IDS_CAMERA_MOVE_HELP,

	IDS_CAMERA_MAGNIFY,
	IDS_CAMERA_MAGNIFY_HELP,

	IDS_CAMERA_ZOOM,
	IDS_CAMERA_ZOOM_HELP,

	IDS_CAMERA_ZOOM_IN,
	IDS_CAMERA_ZOOM_IN_HELP,

	IDS_CAMERA_ZOOM_OUT,
	IDS_CAMERA_ZOOM_OUT_HELP,

	IDS_SMOOTHSHIFT_NAME,
	IDS_SMOOTHSHIFT_HELP,
	IDS_SPLINE_ROUND_NAME,
	IDS_SPLINE_ROUND_HELP,

	IDS_HLP_EDGECUT,
	IDS_HLP_FILLSELECTION,
	IDS_HLP_LOOP,
	IDS_HLP_MEASURE,
	IDS_HLP_OUTLINE,
	IDS_HLP_RING,
	IDS_HLP_LIVESELECTION,
	IDS_HLP_RECTSELECTION,
	IDS_HLP_POLYSELECTION,
	IDS_HLP_FREESELECTION,
	IDS_HLP_MOVE,
	IDS_HLP_SCALE,
	IDS_HLP_ROTATE,
	IDS_HLP_ADDPOINT,
	IDS_HLP_ARRANGE,
	IDS_HLP_BRIDGE,
	IDS_HLP_BRUSH,
	IDS_HLP_FILMMOVE,
	IDS_HLP_FILMMAGNIFY,
	IDS_HLP_FILMZOOM,
	IDS_HLP_CENTER,
	IDS_HLP_CLOSEHOLE,
	IDS_HLP_COLLAPSE,
	IDS_HLP_CREATEPOLYGON,
	IDS_HLP_DUPLICATE,
	IDS_HLP_EXTRUDE,
	IDS_HLP_IRON,
	IDS_HLP_KNIFE,
	IDS_HLP_MAGNET,
	IDS_HLP_MATRIXEXTRUDE,
	IDS_HLP_MODIFY,
	IDS_HLP_POINTWELD,
	IDS_HLP_BEVEL,
	IDS_HLP_EXTRUDEINNER,
	IDS_HLP_RANDOMIZE,
	IDS_HLP_SETVALUE,
	IDS_HLP_SLIDE,
	IDS_HLP_SMOOTHSHIFT,
	IDS_HLP_STITCHANDSEW,
	IDS_HLP_TRANSFER1,
	IDS_HLP_TRANSFER2,
	IDS_HLP_SPLINE_ROUND,
	IDS_HLP_CLONE,
	IDS_HLP_SPLINECHAMFER,
	IDS_HLP_ARRAY,
	IDS_HLP_SPLINEPROJECT,
	IDS_HLP_FITCIRCLE,
	IDS_HLP_EDGESMOOTH,
	IDS_HLP_SETEDGEFLOW,
	IDS_HLP_SETEDGESLINEAR,
	IDS_HLP_EVENSPACING,
	IDS_HLP_FLATTEN,
	IDS_HLP_PATTERNSELECTION,
	IDS_HLP_SOLIDIFY_TOOL,

	IDS_SHORTCUT_SELECTVISIBLE,

	IDS_HUDPOP_VECTOR2D_MENU,
	IDS_HUDPOP_VECTOR2D_MENU_CROSS,
	IDS_HUDPOP_VECTOR2D_MENU_DIAMOND,
	IDS_HUDPOP_VECTOR2D_MENU_CIRCLE,
	IDS_HUDPOP_VECTOR2D_MENU_SQUARE,
	IDS_HUDPOP_VECTOR2D_MENU_CROSSHAIR,

	IDS_CONNECTOR,

	IDS_AXCDLG_TITLE,
	IDS_AXCDLG_MOVE,
	IDS_AXCDLG_OBJECT,
	IDS_AXCDLG_AXIS,
	IDS_AXCDLG_CENTER,
	IDS_AXCDLG_BOUNDS,
	IDS_AXCDLG_POINTS,
	IDS_AXCDLG_CHILDREN,
	IDS_AXCDLG_EXECUTE,
	IDS_AXCDLG_MENU,
	IDS_AXCDLG_MENU_HELP,
	IDS_AXCDLG_POSITION,
	IDS_AXCDLG_SELPOINTS,
	IDS_AXCDLG_SELPOLYS,
	IDS_AXCDLG_SELEDGES,
	IDS_AXCDLG_X,
	IDS_AXCDLG_Y,
	IDS_AXCDLG_Z,
	IDS_AXCDLG_ROTATION,
	IDS_AXCDLG_AXISALIGN,
	IDS_AXCDLG_ALIGN,
	IDS_AXCDLG_NORMAL,
	IDS_AXCDLG_EDGE,
	IDS_AXCDLG_USEALL,
	IDS_AXCDLG_AUTO,
	IDS_AXCDLG_VIEWCENTER,
	IDS_AXCDLG_PARENTTO,
	IDS_AXCDLG_TOPARENT,
	IDS_AXCDLG_WORLD,
	IDS_AXCDLG_PARENT,
	IDS_AXCDLG_CHILD,
	IDS_AXCDLG_POINTCENTER,
	IDS_AXCDLG_RESET,
	IDS_AXCDLG_ALL,
	IDS_AXCDLG_TRANSPOS,
	IDS_AXCDLG_TRANSROT,
	IDS_AXCDLG_TRANSSCALE,
	IDS_AXCDLG_AUTOEDITOR,
	IDS_AXCDLG_MENU_VIEWCENTER,
	IDS_AXCDLG_MENU_VIEWCENTER_HELP,
	IDS_AXCDLG_MENU_AXISTO,
	IDS_AXCDLG_MENU_AXISTO_HELP,
	IDS_AXCDLG_MENU_PARENTTO,
	IDS_AXCDLG_MENU_PARENTTO_HELP,
	IDS_AXCDLG_MENU_TOPARENT,
	IDS_AXCDLG_MENU_TOPARENT_HELP,
	IDS_AXCDLG_MENU_OBJECTTO,
	IDS_AXCDLG_MENU_OBJECTTO_HELP,
	IDS_AXCDLG_MENU_INSERTTO,
	IDS_AXCDLG_MENU_INSERTTO_HELP,

	IDS_AXC_DEFAULTS,
	IDS_AXC_INSERTOBJECT,
	IDS_AXC_ACTIVATEOBJECT,
	IDS_AXC_INSERT_STANDARD,
	IDS_AXC_INSERT_PARENT,
	IDS_AXC_INSERT_TOPMOST,
	IDS_AXC_INSERT_NEXT,
	IDS_AXC_INSERT_CHILD,

	IDS_CONNECT_COMMAND,
	IDS_DISOLVE_COMMAND,
	IDS_SPINEDGE_COMMAND,
	IDS_LIGHTPLACER_TOOL,

	DELME_IDS_MENU_LASTTOOLS,
	IDS_CAMERA_PIVOT_COMMAND,
	IDS_CAMERA_PIVOT_COMMAND_HELP,

	IDS_DOODLE_OBJECT,
	IDS_DOODLE_HOOK,
	IDS_DOODLE_TRACK,
	IDS_DOODLE_BITMAP,
	IDS_DOODLE_SETBD,
	IDS_DOODLE_ADDFRAME,
	IDS_DOODLE_DELFRAME,
	IDS_DOODLE_CLEARFRAME,
	IDS_DOODLE_PAINT,
	IDS_DOODLE_ERASER,
	IDS_DOODLE_DUPLICATEFRAME,

	IDS_STEREO,

	// Dialog definitions of idd_scaledocument start here
	IDD_SCALEDOCUMENT,
	IDC_SCALEDOCUMENT_CURRENT,
	IDC_SCALEDOCUMENT_TARGET,
	IDC_SCALEDOCUMENT_EFFECTIVE,
	// Dialog definitions of idd_scaledocument end here
	IDS_SCALEDOCUMENT,
	IDS_SCALEDOCUMENT_HELP,

	IDS_DOODLE_LOADIMAGE,
	IDS_DOODLE_EXPORTDATA,
	IDS_DOODLE_IMPORTDATA,

	IDS_HUDPOP_RENAME,

	IDS_PARENTMOVE,
	IDS_PARENTMOVEHELP,

	IDS_CAMERA_SET_FOCUS,
	IDS_CAMERA_SET_FOCUS_HELP,

	///
	IDS_CAMERACOMMAND_POI_CENTER,
	IDS_CAMERACOMMAND_POI_CENTER_HELP,
	IDS_CAMERACOMMAND_POI_OBJECT,
	IDS_CAMERACOMMAND_POI_OBJECT_HELP,
	IDS_CAMERACOMMAND_POI_CAMERA,
	IDS_CAMERACOMMAND_POI_CAMERA_HELP,

	IDS_CAMERACOMMAND_CURSOR_OFF,
	IDS_CAMERACOMMAND_CURSOR_OFF_HELP,
	IDS_CAMERACOMMAND_CURSOR_SELECTED,
	IDS_CAMERACOMMAND_CURSOR_SELECTED_HELP,
	IDS_CAMERACOMMAND_CURSOR_CHILDREN,
	IDS_CAMERACOMMAND_CURSOR_CHILDREN_HELP,
	IDS_CAMERACOMMAND_CURSOR_ALL,
	IDS_CAMERACOMMAND_CURSOR_ALL_HELP,

	IDS_CAMERACOMMAND_DEEP_CURSOR,
	IDS_CAMERACOMMAND_DEEP_CURSOR_HELP,
	IDS_CAMERACOMMAND_LOCK_DOLLY,
	IDS_CAMERACOMMAND_LOCK_DOLLY_HELP,

	IDS_NORMAL_DISPLAY_TOGGLE,
	IDS_NORMAL_DISPLAY_TOGGLE_HELP,

	IDS_GIMBAL_ROTATION_TOGGLE,
	IDS_GIMBAL_ROTATION_TOGGLE_HELP,

	IDS_CAMERACOMMAND_CENTERMODE,
	IDS_CAMERACOMMAND_CENTERMODE_HELP,
	IDS_CAMERACOMMAND_OBJECTMODE,
	IDS_CAMERACOMMAND_OBJECTMODE_HELP,
	IDS_CAMERACOMMAND_CAMERAMODE,
	IDS_CAMERACOMMAND_CAMERAMODE_HELP,
	IDS_CAMERACOMMAND_CAMERA2DMODE,
	IDS_CAMERACOMMAND_CAMERA2DMODE_HELP,
	IDS_CAMERACOMMAND_CURSORMODE,
	IDS_CAMERACOMMAND_CURSORMODE_HELP,

	IDS_CAMERA_PIVOTLOCK_COMMAND,
	IDS_CAMERA_PIVOTLOCK_COMMAND_HELP,

	IDS_RAYCAST_SELECTION,
	IDS_RAYCAST_SELECTION_HELP,

	IDS_NUDGE_UP,
	IDS_NUDGE_UP_HELP,
	IDS_NUDGE_DOWN,
	IDS_NUDGE_DOWN_HELP,
	IDS_NUDGE_LEFT,
	IDS_NUDGE_LEFT_HELP,
	IDS_NUDGE_RIGHT,
	IDS_NUDGE_RIGHT_HELP,

	IDS_OWORKPLANE,
	IDS_WORKPLANESCENEHOOK,
	IDS_WORKPLANELOCKEDCOMMAND,
	IDS_WORKPLANELOCKEDCOMMAND_CURRENT,
	IDS_WORKPLANELOCKEDCOMMAND_X,
	IDS_WORKPLANELOCKEDCOMMAND_Y,
	IDS_WORKPLANELOCKEDCOMMAND_Z,
	IDS_WORKPLANEPLANARCOMMAND,
	IDS_WORKPLANECAMERACOMMAND,
	IDS_WORKPLANEAXISCOMMAND,
	IDS_WORKPLANEINTERACTIVECOMMAND,
	IDS_WORKPLANEALIGNTOSELECTION,
	IDS_SELECTIONALIGNWP,

	IDS_USEGUIDESCOMMAND,
	IDS_KILLGUIDESCOMAND,
	IDS_CREATEGUIDEONCOMMAND,

	IDS_OGUIDE,
	IDS_TGUIDE,
	IDS_TGUIDE_HELP,
	IDS_SNAP_SCENEHOOK,

	IDS_SNAP_ENABLE,
	IDS_SNAP_ENABLE_HELP,

	IDS_SNAPMODE_GUIDE,
	IDS_SNAPMODE_GUIDE_HELP,
	IDS_SNAPMODE_INTERSECTION,
	IDS_SNAPMODE_INTERSECTION_HELP,
	IDS_SNAPMODE_DYNAMICGUIDE,
	IDS_SNAPMODE_DYNAMICGUIDE_HELP,
	IDS_SNAPMODE_POINT,
	IDS_SNAPMODE_POINT_HELP,
	IDS_SNAPMODE_SPLINE,
	IDS_SNAPMODE_SPLINE_HELP,
	IDS_SNAPMODE_SPLINEMID,
	IDS_SNAPMODE_SPLINEMID_HELP,
	IDS_SNAPMODE_EDGE,
	IDS_SNAPMODE_EDGE_HELP,
	IDS_SNAPMODE_EDGEMID,
	IDS_SNAPMODE_EDGEMID_HELP,
	IDS_SNAPMODE_POLY,
	IDS_SNAPMODE_POLY_HELP,
	IDS_SNAPMODE_POLYCENTER,
	IDS_SNAPMODE_POLYCENTER_HELP,
	IDS_SNAPMODE_AXIS,
	IDS_SNAPMODE_AXIS_HELP,
	IDS_SNAPMODE_WORKPLANE,
	IDS_SNAPMODE_WORKPLANE_HELP,
	IDS_SNAPMODE_ORTHO,
	IDS_SNAPMODE_ORTHO_HELP,
	IDS_SNAPMODE_GRIDPOINT,
	IDS_SNAPMODE_GRIDPOINT_HELP,
	IDS_SNAPMODE_GRIDLINE,
	IDS_SNAPMODE_GRIDLINE_HELP,
	IDS_SNAPMODE_MIDPOINT,
	IDS_SNAPMODE_MIDPOINT_HELP,
	IDS_SNAPMODE_GUIDEMID,
	IDS_SNAPMODE_GUIDEMID_HELP,

	IDS_SNAPRADIUS,
	IDS_SNAPRADIUS_HELP,

	IDS_SNAPRADIUS_SLIDERTITLE,

	IDS_GUIDEANGLE,
	IDS_GUIDEANGLE_HELP,

	IDS_GUIDEANGLE_SLIDERTITLE,

	IDS_SNAP_QUANTIZE,
	IDS_SNAP_QUANTIZE_HELP,

	IDS_QUANTIZE_MOVE,
	IDS_QUANTIZE_MOVE_HELP,
	IDS_QUANTIZE_MOVE_SLIDERTITLE,
	IDS_QUANTIZE_SCALE,
	IDS_QUANTIZE_SCALE_HELP,
	IDS_QUANTIZE_SCALE_SLIDERTITLE,
	IDS_QUANTIZE_ROTATE,
	IDS_QUANTIZE_ROTATE_HELP,
	IDS_QUANTIZE_ROTATE_SLIDERTITLE,
	IDS_QUANTIZE_TEXTURE,
	IDS_QUANTIZE_TEXTURE_HELP,
	IDS_QUANTIZE_TEXTURE_SLIDERTITLE,
	IDS_SNAP_SETTINGS_AUTO,
	IDS_SNAP_SETTINGS_AUTO_HELP,
	IDS_SNAP_SETTINGS_2D,
	IDS_SNAP_SETTINGS_2D_HELP,
	IDS_SNAP_SETTINGS_3D,
	IDS_SNAP_SETTINGS_3D_HELP,

	IDS_SNAP_POPUP,
	IDS_SNAP_POPUP_HELP,

	IDS_SNAP_TOOLLOCAL,
	IDS_SNAP_TOOLLOCAL_HELP,

	IDS_SNAP_INTERSECTION,

	IDS_HOTKEY_RESIZE_BRUSH,
	IDS_HOTKEY_RESIZE_BRUSH_HELP,

	IDS_HUDPOP_SHOW_MENU_PARAMETER,
	IDS_HUDPOP_SHOW_MENU_PARAMETER_ID,

	IDS_SNAPMODE_COMBO,

	IDS_MODELLING_SETTINGS,
	IDS_ACTIVEOBJECTMODE_MODELING,

	IDS_BEVELTOOL,
	IDS_BEVELTOOL_HELP,
	IDS_SLIDETOOL,
	IDS_SLIDETOOL_HELP,
	IDS_HLP_SLIDETOOL,

	IDS_BEVELGEN,
	IDS_POLYPEN,
	IDS_POLYPEN_HELP,
	IDS_PENTOOL,
	IDS_PENTOOL_HELP,

	IDS_PENTOOLMENU_EDGE_HARD,
	IDS_PENTOOLMENU_EDGE_SOFT,
	IDS_PENTOOLMENU_EDGE_DELETE,
	IDS_PENTOOLMENU_EDGE_ADDPOINT,
	IDS_PENTOOLMENU_EDGE_SPLITPOINT,

	IDS_PENTOOLMENU_POINT_DELETE,
	IDS_PENTOOLMENU_POINT_DISCONNECT,
	IDS_PENTOOLMENU_POINT_HARD,
	IDS_PENTOOLMENU_POINT_SOFT,

	IDS_SKETCHTOOL,
	IDS_SKETCHTOOL_HELP,

	IDS_TWEAKENABLE,
	IDS_TWEAKENABLE_HELP,

	IDS_INTERACTIONTAG,

	IDS_SPLINESMOOTHTOOL,
	IDS_SPLINESMOOTHTOOL_HELP,

	IDS_SPLINEBOOLEUNION,
	IDS_SPLINEBOOLEUNION_HELP,

	IDS_SPLINEBOOLESUB,
	IDS_SPLINEBOOLESUB_HELP,

	IDS_SPLINEBOOLEOR,
	IDS_SPLINEBOOLEOR_HELP,

	IDS_SPLINEBOOLE,
	IDS_SPLINEBOOLE_HELP,

	IDS_SPLINENORMALTAG,

	IDS_SPLINEARCTOOL,
	IDS_SPLINEARCTOOL_HELP,

	IDS_RELATEDTOOLSMANAGER,
	IDS_RELATEDTOOLSMANAGER_HELP,

	IDS_INTERACTIONTAG_COMMENT_INIT,
	IDS_INTERACTIONTAG_COMMENT_MAIN,
	IDS_INTERACTIONTAG_COMMENT_FREE,
	IDS_INTERACTIONTAG_COMMENT_SELECT,
	IDS_INTERACTIONTAG_COMMENT_DESELECT,
	IDS_MODELLING_SETTINGS_COMMAND,
	IDS_MODELLING_SETTINGS_HELP,
	IDS_INTERACTIONTAG_COMMENT_HIGHLIGHT,
	IDS_INTERACTIONTAG_COMMENT_UNHIGHLIGHT,
	IDS_INTERACTIONTAG_COMMENT_MESSAGE,
	IDS_INTERACTIONTAG_COMMENT_DRAW,
	IDS_INTERACTIONTAG_COMMENT_DOUBLECLICK,

	IDS_MODELING_OPTION_SOLO_OFF,
	IDS_MODELING_OPTION_SOLO_SINGLE,
	IDS_MODELING_OPTION_SOLO_CHILDREN,
	IDS_MODELING_OPTION_SOLO_SELECTION,

	IDS_MODELING_OPTION_SOLO_OFF_HELP,
	IDS_MODELING_OPTION_SOLO_SINGLE_HELP,
	IDS_MODELING_OPTION_SOLO_CHILDREN_HELP,
	IDS_MODELING_OPTION_SOLO_SELECTION_HELP,

	IDS_SPLINEBOOLEAND,
	IDS_SPLINEBOOLEAND_HELP,

	IDS_SPLINEBOOLEINTERSECT,
	IDS_SPLINEBOOLEINTERSECT_HELP,

	IDS_CALCLINEINSERTION,

	IDS_DEFAULTCAMERA,

	IDS_VERTEX_NORMALS_DISPLAY_TOGGLE,
	IDS_VERTEX_NORMALS_DISPLAY_TOGGLE_HELP,

	IDS_HUD_STATISTIC_PATCHES,

	IDS_LINEKNIFE,
	IDS_LINEKNIFE_HELP,

	IDS_PLANEKNIFE,
	IDS_PLANEKNIFE_HELP,

	IDS_PATHKNIFE,
	IDS_PATHKNIFE_HELP,

	// Dialog definitions of IDD_CONVERT_SELECTION_DIALOG continue here
	IDC_CONVERTSELECTION_LEFT_5,
	IDC_CONVERTSELECTION_LEFT_6,
	IDC_CONVERTSELECTION_RIGHT_5,
	IDC_CONVERTSELECTION_RIGHT_6,
	// see below related IDC_CONVERTSELECTION_LEFT_7,
	// see below related IDC_CONVERTSELECTION_RIGHT_7,

	IDS_HUD_PREVIEWRENDERER_START,
	IDS_HUD_PREVIEWRENDERER_QUALITY,
	IDS_HUD_PREVIEWRENDERER_QUALITY_PREVIEW,
	IDS_HUD_PREVIEWRENDERER_QUALITY_OFFLINE,

	IDS_HUD_PREVIEWRENDERER_STATISTICS_MEM,
	IDS_HUD_PREVIEWRENDERER_STATISTICS_TEX,
	IDS_HUD_PREVIEWRENDERER_STATISTICS_BAKED,
	IDS_HUD_PREVIEWRENDERER_STATISTICS_MATNODES,
	IDS_HUD_PREVIEWRENDERER_STATISTICS_MESHES,
	IDS_HUD_PREVIEWRENDERER_STATISTICS_INSTANCES,

	IDS_CREATE_NORMAL_TAG,
	IDS_CONFIRM_OVERWRITE_NORMAL_TAG,

	IDS_WELD_STATUS_TEXT,

	IDS_HUDPOP_ANIM,
	IDS_HUDPOP_ANIM_ADDKEYFRAME,
	IDS_HUDPOP_ANIM_REMOVEKEYFRAME,
	IDS_HUDPOP_ANIM_OPENCURVE,
	IDS_HUDPOP_ANIM_OPENTRACK,
	IDS_HUDPOP_ANIM_ADDTRACK,
	IDS_HUDPOP_ANIM_COPYTRACK,
	IDS_HUDPOP_ANIM_PASTETRACK,
	IDS_HUDPOP_ANIM_REMOVETRACK,
	IDS_HUDPOP_ANIM_NEXTKEYFRAME,
	IDS_HUDPOP_ANIM_PREVIOUSKEYFRAME,
	IDS_HUDPOP_ANIM_ADDKEYSEL,
	IDS_HUDPOP_ANIM_REMOVEKEYSEL,
	IDS_HUDPOP_ANIM_CLEARKEYSEL,

	IDS_AXIS_SOFTSELECTION,

	// Dialog definitions of IDD_CONVERT_SELECTION_DIALOG continue here
	IDC_CONVERTSELECTION_LEFT_7,
	IDC_CONVERTSELECTION_RIGHT_7,

	IDS_SNAPMODE_PIXEL,
	IDS_SNAPMODE_PIXEL_HELP,

	IDS_QUANTIZE_PARAMETERS,
	IDS_QUANTIZE_PARAMETERS_HELP,

	IDS_MODELING_ENABLE_SOFTSELECTION_CMD,
	IDS_MODELING_ENABLE_SOFTSELECTION_CMD_HELP,
	// End of symbol definition

	IDS_VIEW_TRANSFORM,
	IDS_VIEW_TRANSFORM_DEFAULT,

	IDS_MODELING_AXIS,
	IDS_MODELING_ORIENTATION,

	// Dialog definitions of IDD_OPTIMAL_MAPPING start here
	IDD_OPTIMAL_MAPPING,
	IDC_OPT_MAP_OPTIMALCUBIC_RADIO,
	IDC_OPT_MAP_OPTIMAL_RADIO,
	IDC_OPT_MAP_OK_BTN,
	IDC_OPT_MAP_TAB_GROUP,
	IDC_OPT_MAP_OPTIMALCUBIC_GROUP,
	IDC_OPT_MAP_OPTIMALCUBIC_PRESERVE_ORIENTATION_CHK,
	IDC_OPT_MAP_OPTIMALCUBIC_STRETCH_FIT_CHK,
	IDC_OPT_MAP_OPTIMALCUBIC_2D_CHK,
	IDC_OPT_MAP_OPTIMALCUBIC_AREA_EDIT,
	IDC_OPT_MAP_OPTIMALCUBIC_RELAX_EDIT,
	IDC_OPT_MAP_OPTIMALCUBIC_SPACING_EDIT,
	IDC_OPT_MAP_OPTIMAL_GROUP,
	IDC_OPT_MAP_OPTIMAL_PRESERVE_ORIENTATION_CHK,
	IDC_OPT_MAP_OPTIMAL_STRETCH_FIT_CHK,
	IDC_OPT_MAP_OPTIMAL_MAX_DIST_EDIT,
	IDC_OPT_MAP_OPTIMAL_RELAX_EDIT,
	IDC_OPT_MAP_OPTIMAL_SPACING_EDIT,
	// Dialog definitions of IDD_OPTIMAL_MAPPING end here

	// Dialog definitions of IDD_relaxuv start here
	IDD_RELAXUV,
	IDC_RELAX_UV_AUTO_REALIGN,
	IDC_RELAX_UV_PIN_NEIGHBORS,
	IDC_RELAX_UV_PIN_BORDER,
	IDC_RELAX_UV_PIN_SEL,
	IDC_RELAX_UV_PIN_SEL_USE_LINK,
	IDC_RELAX_UV_PIN_SEL_LINK,
	IDC_RELAX_UV_CUT_EDGES,
	IDC_RELAX_UV_CUT_EDGES_USE_LINK,
	IDC_RELAX_UV_CUT_EDGES_LINK,
	IDC_RELAX_UV_STOP_BTN,
	IDC_RELAX_UV_START_BTN,
	IDC_RELAX_UV_MODE,
	// Dialog definitions of IDD_relaxuv end here
	// Dialog definitions of IDD_RELAXUV_WORKING begins here
	IDD_RELAXUV_WORKING,
	// Dialog definitions of IDD_RELAXUV_WORKING ends here
	// Dialog definitions of IDD_PROJECTION_DIALOG start here
	IDD_PROJECTION_DIALOG,
	IDC_PROJECTION_SPHERE_BTN,
	IDC_PROJECTION_CYLINDER_BTN,
	IDC_PROJECTION_FRONTAL_BTN,
	IDC_PROJECTION_FLAT_BTN,
	IDC_PROJECTION_CUBIC_BTN,
	IDC_PROJECTION_CUBIC_2_BTN,
	IDC_PROJECTION_SHRINK_BTN,
	IDC_PROJECTION_BOX_BTN,
	IDC_PROJECTION_FITTOSELECTION_CHK,
	IDC_PROJECTION_WEIGHT_NORMAL_CHK_EX,
	IDC_PROJECTION_SYSTEM_COMBO,
	IDC_PROJECTION_SYSTEM_OBJECT,
	IDC_PROJECTION_SYSTEM_WORLD,
	IDC_PROJECTION_SYSTEM_AV_NORMAL,
	// Dialog definitions of IDD_PROJECTION_DIALOG end here
	// Dialog definitions of IDD_UV_MAP start here
	IDD_UV_MAP,
	IDC_UV_MAP_MODE_TAB,
	IDC_UV_MAP_SCROLL,
	IDC_UV_MAP_DIALOG_CONTAINER,
	// Dialog definitions of IDD_UV_MAP end here
	// Dialog definitions of IDD_UVEDIT_NUMERIC start here
	IDD_UVEDIT_NUMERIC,
	IDC_UVEDIT_POS_X_EDIT,
	IDC_UVEDIT_SCALE_X_EDIT,
	IDC_UVEDIT_ANGLE_EDIT,
	IDC_UVEDIT_POS_Y_EDIT,
	IDC_UVEDIT_SCALE_Y_EDIT,
	IDC_UVEDIT_APPLY_BTN,
	// Dialog definitions of IDD_UVEDIT_NUMERIC end here
	IDS_RELAXUV,
	IDS_UV_MAP_DIALOG,
	IDS_COPY_UV,
	IDS_PASTE_UV,
	IDS_FLIP_SEQUENCE,
	IDS_MAX_UV,
	IDS_CYCLE_CW_UV,
	IDS_CYCLE_CCW_UV,
	IDS_TERRACE,
	IDS_OPTIMAL_MAPPING,
	IDS_RELAX_UV,
	IDS_PROJECTION,
	IDS_TRANSFORM,
	IDS_SCALE_UV,
	IDS_TOOL_EXECUTE,
	IDS_OPTIMAL_MAPPING_CMD,
	IDS_OPTIMAL_TRANSFORM_CMD,
	IDS_REALIGN_CMD,
	IDS_PAINT_CALCREMAP,
	IDS_LINEUP,
	IDS_UNSTITCH_UV,
	IDS_BOUNDARY2CIRCLE,
	IDS_BOUNDARY2QUAD,
	// String definitions for RelaxUV
	IDS_UVR_ERROR_TITLE,
	IDS_UVR_ERROR_NOBOUNDARY,
	IDS_UVR_ERROR_BADEDGE,
	IDS_UVR_ERROR_DEGENERATE,
	IDS_UVR_ERROR_INVALIDPOLY,
	IDS_UVR_ERROR_OUTOFMEM,
	IDS_UVR_ERROR_UNKNOWN,
	IDS_UVR_PROGRESS,
	IDS_UVR_PROGRESS_ITERATING,

	// Edge selection stuff
	MWS_EDGE_IDS,
	MWS_PHONG_IDS,

	// Tools
	IDS_UVPEELERTOOL,
	IDS_UVPEELERTOOL_HELP,

	// re-factored Weighted Normal option in UV Mapper > Projection dialog as a pulldown option
	IDC_PROJECTION_SYSTEM_WEIGHTED_NORMAL,

	// Set UV Command
	IDS_UV_SET_FROM_PROJECTION,

	IDS_UV_SET_FROM_PROJECTION_GROUP_CREATE,
	IDS_UV_SET_FROM_PROJECTION_NAME_STATIC,
	IDS_UV_SET_FROM_PROJECTION_NAME_EDIT,
	IDS_UV_SET_FROM_PROJECTION_LOCK,

	IDS_UV_SET_FROM_PROJECTION_GROUP_MODIFY,
	IDS_UV_SET_FROM_PROJECTION_USE_POLYGON_SELECTION,

	IDS_UV_SET_FROM_PROJECTION_TYPE,
	IDS_UV_SET_FROM_PROJECTION_TYPE_SPHERICAL,
	IDS_UV_SET_FROM_PROJECTION_TYPE_CYLINDRICAL,
	IDS_UV_SET_FROM_PROJECTION_TYPE_FRONTAL,
	IDS_UV_SET_FROM_PROJECTION_TYPE_FLAT,
	IDS_UV_SET_FROM_PROJECTION_TYPE_CUBIC,
	IDS_UV_SET_FROM_PROJECTION_TYPE_CUBIC2,
	IDS_UV_SET_FROM_PROJECTION_TYPE_BOX,
	IDS_UV_SET_FROM_PROJECTION_TYPE_SHRINK_WRAP,

	IDS_UV_SET_FROM_PROJECTION_GROUP_PROJECTION_VOLUME,
	IDS_UV_SET_FROM_PROJECTION_INCLUDE_CHILDREN,
	IDS_UV_SET_FROM_PROJECTION_SUPPORT_OBJECT,
	IDS_UV_SET_FROM_PROJECTION_SUPPORT_HIERARCHY,
	IDS_UV_SET_FROM_PROJECTION_SUPPORT_ALL,
	IDS_UV_SET_FROM_PROJECTION_FIT_TO_SELECTION,

	IDS_UV_SET_FROM_PROJECTION_GROUP_PROJECTION_ORIENTATION,
	IDS_UV_SET_FROM_PROJECTION_REFERENCE_OBJECT,
	IDS_UV_SET_FROM_PROJECTION_REFERENCE_WORLD,
	IDS_UV_SET_FROM_PROJECTION_REFERENCE_AVERAGE,
	IDS_UV_SET_FROM_PROJECTION_REFERENCE_WEIGHTED,

	IDC_RELAX_ITERATION_NUMBER_TEXT,
	IDC_RELAX_ITERATION_NUMBER,
	IDC_RELAX_INTERACTIVE_ABF_TEXT,
	IDC_RELAX_INTERACTIVE_ABF,
	IDC_RELAX_LIVE_ABF_UPDATE_TEXT,
	IDC_RELAX_LIVE_ABF_UPDATE,

	IDS_PACKUV,
	IDS_PACKING_UVS,
	IDS_AUTOCREATING_UVS,

	IDS_UV_SET_FROM_PROJECTION_TYPE_PACKED_AUTOMATICUV,
	IDC_OPT_MAP_AUTOMATICUV_RADIO,
	IDC_OPT_MAP_AUTOMATICUV_GROUP,
	IDC_OPT_MAP_AUTOMATICUV_OVERLAP_IDENTICAL_CHK,
	IDC_OPT_MAP_AUTOMATICUV_OVERLAP_MIRRORED_CHK,
	IDC_OPT_MAP_AUTOMATICUV_NORMALS_CHK,
	IDC_OPT_MAP_AUTOMATICUV_SPACING_EDIT,
	IDC_OPT_MAP_AUTOMATICUV_FORCESEAM_EDIT,

	IDS_UV_PACKING,
	IDD_UV_PACKING,
	IDC_UV_PACKING_RASTERIZED_RADIO,
	IDC_UV_PACKING_GEOMETRIC_RADIO,
	IDC_UV_PACKING_BOUNDINGBOX_RADIO,
	IDC_UV_PACKING_APPLY_BTN,
	IDC_UV_PACKING_TAB_GROUP,
	IDC_UV_PACKING_RASTERIZED_GROUP,
	IDC_UV_PACKING_RASTERIZED_TARGET_RESOLUTION_X,
	IDC_UV_PACKING_RASTERIZED_TARGET_RESOLUTION_Y,
	IDC_UV_PACKING_RASTERIZED_OVERLAP_IDENTICAL_CHK,
	IDC_UV_PACKING_RASTERIZED_OVERLAP_MIRRORED_CHK,
	IDC_UV_PACKING_GEOMETRIC_GROUP,
	IDC_UV_PACKING_GEOMETRIC_SPACE,
	IDC_UV_PACKING_GEOMETRIC_TARGET_RESOLUTION_X_TEXT,
	IDC_UV_PACKING_GEOMETRIC_TARGET_RESOLUTION_X,
	IDC_UV_PACKING_GEOMETRIC_TARGET_RESOLUTION_Y_TEXT,
	IDC_UV_PACKING_GEOMETRIC_TARGET_RESOLUTION_Y,
	IDC_UV_PACKING_GEOMETRIC_GAP_SIZE_TEXT,
	IDC_UV_PACKING_GEOMETRIC_GAP_SIZE,
	IDC_UV_PACKING_GEOMETRIC_SPACING_TEXT,
	IDC_UV_PACKING_GEOMETRIC_SPACING,
	IDC_UV_PACKING_GEOMETRIC_PRESERVE_ORIENTATION_CHK,
	IDC_UV_PACKING_GEOMETRIC_STRETCH_TO_FIT_CHK,
	IDC_UV_PACKING_GEOMETRIC_EQUALIZE_ISLAND_SIZE_CHK,
	IDC_UV_PACKING_GEOMETRIC_OVERLAP_IDENTICAL_CHK,
	IDC_UV_PACKING_GEOMETRIC_OVERLAP_MIRRORED_CHK,
	IDC_UV_PACKING_BOUNDINGBOX_GROUP,
	IDC_UV_PACKING_BOUNDINGBOX_SPACING,
	IDC_UV_PACKING_BOUNDINGBOX_PRESERVE_ORIENTATION_CHK,
	IDC_UV_PACKING_BOUNDINGBOX_STRETCHTOFIT_CHK,
	IDC_UV_PACKING_BOUNDINGBOX_EQUALIZEAREA_CHK,

	// UV Straighten Command
	IDS_UV_STRAIGHTEN,
	// UV Straighten Command Options
	IDD_UV_STRAIGHTEN,
	IDC_UV_STRAIGHTEN_ALIGN,
	IDC_UV_STRAIGHTEN_KEEP_LENGTH,
	IDC_UV_STRAIGHTEN_EQUIDISTANT,
	// UV Straighten Invalid Selection Error
	IDS_UV_STRAIGHTEN_IVALID_SELECTION,
	// UV Straighten Path Too Long Error
	IDS_UV_STRAIGHTEN_PATH_TOO_LONG,
	// Progress bar messages
	IDS_UV_STRAIGHTEN_PREPARATION_PROGRESS,
	IDS_UV_STRAIGHTEN_EXECUTION_PROGRESS,

	// UV Rectangularize Command
	IDS_UV_RECTANGULARIZE,
	// UV Rectangularize Command Options
	IDD_UV_RECTANGULARIZE,
	IDC_UV_RECTANGULARIZE_ALIGN,
	IDC_UV_RECTANGULARIZE_EQUIDISTANT,
	// UV Rectangularize Invalid Selection Error
	IDS_UV_RECTANGULARIZE_IVALID_SELECTION,
	// Progress bar messages
	IDS_UV_RECTANGULARIZE_PREPARATION_PROGRESS,
	IDS_UV_RECTANGULARIZE_EXECUTION_PROGRESS,

	IDS_UV_SELECT_SEAMS,
	IDH_UV_SELECT_SEAMS,
	IDC_OPT_MAP_AUTOMATICUV_STRETCH_EDIT,

	// Operators
	IDS_OPOLYREDUX_DEPRECATED,
	IDS_POLYREDUX_PREPROCESSING_REDUCTION,
	IDS_POLYREDUX_PREPROCESSING_TRIANGULATING,
	IDS_POLYREDUX_PREPROCESSING_OPTIMIZING,
	IDS_POLYREDUX_PREPROCESSING_INIT_COSTS,
	IDS_POLYREDUX_PREPROCESSING_INIT_STACK,
	IDS_POLYREDUX_PREPROCESSING_FINALIZE_STACK,
	IDS_OPOLYREDUX_GENERATOR,
	IDS_POLYREDUX_PREPROCESSING_COUNTING_EDGES,

	IDS_BOOLEANGENERATOR,
	IDS_BOOLEANTAG,

	// symmetry generator (new, since 2023.2)
	IDS_SYMMETRYGENERATOR,
	// symmetry generator (new, since 2023.2)
	IDS_SOLIDIFYGENERATOR,

	// spline to mesh strings.
	IDS_SPLINETOMESH_MESSAGE_BODY,
	IDS_SPLINETOMESH_MESSAGE_CAPS,

	// error message for melt
	IDS_MELT_ERROR,

	// Commands
	IDS_ALTERNATE_DELETE_COMPONENTS_COMMAND,
	IDS_REMOVE_NON_MANIFOLD,
	IDS_SELECT_ISLAND_FROM_EDGE,
	IDS_CUT_ISLAND_FROM_EDGE,
	IDS_UNWRAP_ISLAND_FROM_EDGE,
	IDS_MODELING_UVUNWRAP,
	IDS_UV_WELD,
	IDS_UV_WELD_RELAX,

	// Mirror Selection command and options
	IDS_MODELING_MIRROR_SELECTION,
	IDD_MODELING_MIRRORSELECTION,
	IDC_MIRRORSELECTION_MODE,
	IDC_MIRRORSELECTION_TOLERANCE,
	IDC_MIRRORSELECTION_SPACE,
	IDC_MIRRORSELECTION_PLANE,

	IDS_TOGGLEMODE,
	IDS_TOGGLEMODE_HELP,

	IDS_UNTRIANGULATE,
	IDS_UNTRIANGULATE_HELP,

	// UV Unwrap options
	IDD_MODELING_UVUNWRAP,
	IDC_UVUNWRAP_POLYGON,
	IDC_UVUNWRAP_PIN,
	IDC_UVUNWRAP_REALIGN,

	// Pin selection command strings
	IDS_ADDPINSELECTION_COMMAND,
	IDS_REMOVEPINSELECTION_COMMAND,
	IDS_CLEARPINSELECTION_COMMAND,

	// UV Weld and Relax options
	IDD_MODELING_UVWELDRELAX,
	IDC_UVWELDRELAX_PIN,
	IDC_UVWELDRELAX_REALIGN,
	IDC_UVWELDRELAX_POLYGON,

	// query messages
	IDS_PAINT_ENABLEMATERIAL,

	IDS_AUTOUV_STATUS,
	IDS_PACKUV_STATUS,
	IDS_UNWRAPPACKUV_STATUS,
	IDS_PACKUVGEOMETRIC_STATUS,
	IDS_PACKUVGEOMETRIC_FAIL_GENERAL,
	IDS_PACKUVGEOMETRIC_FAIL_EXCESSIVE_MIN_SPACING,
	IDS_PACKUVGEOMETRIC_FAIL_BAD_GEOMETRY,

	IDS_REMESHERCOMMAND,
	IDC_REMESH_DIALOG,
	IDC_REMESH_POLYGONTARGET,
	IDC_REMESH_KEEPOUTLINE,

	IDS_MODELING_PATTERNSELECTION,
	IDS_MODELING_PATTERNSELECTION_H,

	IDS_MODELING_PRIMITIVESKETCHING,
	IDS_MODELING_PRIMITIVESKETCHING_H,

	IDS_MODELING_POKEPOLYGONS,
	IDS_HLP_POKEPOLYGONS,
	IDS_MODELING_SYMMETRIZE,
	IDS_HLP_SYMMETRIZE,
	IDS_MODELING_SYMMETRIZESELECTION,
	IDS_HLP_SYMMETRIZESELECTION,

	IDS_MODELING_NORMALS_SETVALUE,
	IDS_MODELING_NORMALS_AVERAGE,
	IDS_MODELING_NORMALS_ALIGNTOPOLYGON,
	IDS_MODELING_NORMALS_ALIGNTOVERTEX,
	IDS_MODELING_NORMALS_COPYFROMSELECTED,
	IDS_MODELING_NORMALS_COPYTOSELECTED,
	IDS_MODELING_NORMALS_FLIP,
	IDS_HLP_MODELING_NORMALS_SETVALUE,
	IDS_HLP_MODELING_NORMALS_AVERAGE,
	IDS_HLP_MODELING_NORMALS_ALIGNTOPOLYGON,
	IDS_HLP_MODELING_NORMALS_ALIGNTOVERTEX,
	IDS_HLP_MODELING_NORMALS_COPYFROMSELECTED,
	IDS_HLP_MODELING_NORMALS_COPYTOSELECTED,
	IDS_HLP_MODELING_NORMALS_FLIP,

	IDS_BOOLEANCOMMANDC4D_UNION,
	IDS_BOOLEANCOMMANDC4D_UNION_HELP,
	IDS_BOOLEANCOMMANDC4D_SUBTRACT,
	IDS_BOOLEANCOMMANDC4D_SUBTRACT_HELP,
	IDS_BOOLEANCOMMANDC4D_INTERSECT,
	IDS_BOOLEANCOMMANDC4D_INTERSECT_HELP,
	IDS_BOOLEANCOMMANDC4D_WITHOUT,
	IDS_BOOLEANCOMMANDC4D_WITHOUT_HELP,

	GADGET_PROFILE_ANIMATION,
	GADGET_PROFILE_SPINLOCKS,
	GADGET_PROFILE_SUMMARY,
	IDS_INDICES_DISPLAY_TOGGLE,
	IDS_INDICES_DISPLAY_TOGGLE_HELP,

	IDS_VERTEX_INDICES_DISPLAY_TOGGLE,
	IDS_VERTEX_INDICES_DISPLAY_TOGGLE_HELP,

	GADGET_JSON,

	IDS_BOOLEAN_EDGE_INTERSECTION_NAME,
	IDC_PM_TIME4,
	IDC_PM_CUSTOMRANGE,

	IDS_MODELING_UDIM_ROTATE,
	IDS_MODELING_UDIM_ROTATE_HELP,
	IDS_MODELING_UDIM_MOVE,
	IDS_MODELING_UDIM_MOVE_HELP,
	IDS_MODELING_UDIM_MOVETOTILE,
	IDS_MODELING_UDIM_MOVETOTILE_HELP,

	// More definitions of IDD_UVEDIT_NUMERIC, to show the udim commands.
	IDC_UVEDIT_UDIM_MOVE_UP,
	IDC_UVEDIT_UDIM_MOVE_DOWN,
	IDC_UVEDIT_UDIM_MOVE_LEFT,
	IDC_UVEDIT_UDIM_MOVE_RIGHT,
	IDC_UVEDIT_UDIM_ROTATE_CW,
	IDC_UVEDIT_UDIM_ROTATE_CCW,
	IDS_UVEDIT_UDIM_MOVE_TO_TILE_TEXT,
	IDC_UVEDIT_UDIM_MOVE_TO_TILE_TILE_X,
	IDC_UVEDIT_UDIM_MOVE_TO_TILE_TILE_Y,
	IDC_UVEDIT_UDIM_MOVE_TO_TILE_APPLY,
	IDC_UVEDIT_GROUP,
	IDC_UVEDIT_NUMERIC_TRANSFORM_GROUP,
	// Definitions of IDD_UVEDIT_NUMERIC end here

	// Definitions of IDD_UV_TEXELDENSITY start here
	IDD_UV_TEXELDENSITY,
	IDS_TEXELDENSITY_NAME,
	IDC_TEXELDENSITY_MAPSIZE_TEXT,
	IDS_TEXELDENSITY_MAPSIZE_TEXT,
	IDC_TEXELDENSITY_MAPSIZE_VALUE,
	IDC_TEXELDENSITY_MAPSIZE_DROPDOWN,
	IDC_TEXELDENSITY_GETSELECTED_BTN,
	IDS_TEXELDENSITY_GETSELECTED,
	IDC_TEXELDENSITY_TEXELDENSITY_TEXT,
	IDS_TEXELDENSITY_TEXELDENSITY_TEXT,
	IDC_TEXELDENSITY_TEXELDENSITY_VALUE,
	IDC_TEXELDENSITY_TEXELDENSITY_DROPDOWN,
	IDS_TEXELDENSITY_TEXELDENSITY_TEXT_UNIT,
	IDC_TEXELDENSITY_SETSELECTED_BTN,
	IDS_TEXELDENSITY_SETSELECTED,
	IDC_TEXELDENSITY_SETCURRENTTILE_BTN,
	IDS_TEXELDENSITY_SETCURRENTTILE,
	IDC_TEXELDENSITY_SETALL_BTN,
	IDS_TEXELDENSITY_SETALL,
	// Definitions of IDD_UV_TEXELDENSITY end here

	// Additional definitions for IDD_UV_PACKING
	IDC_UV_PACKING_COMMON_GROUP,

	IDC_UV_PACKING_COMMON_RESOLUTION_TEXT,
	IDS_UV_PACKING_COMMON_RESOLUTION_TEXT,
	IDC_UV_PACKING_COMMON_RESOLUTION_GROUP,
	IDC_UV_PACKING_COMMON_RESOLUTION_X,
	IDC_UV_PACKING_COMMON_RESOLUTION_Y,

	IDC_UV_PACKING_COMMON_GAPSIZE_TEXT,
	IDS_UV_PACKING_COMMON_GAPSIZE_TEXT,
	IDC_UV_PACKING_COMMON_GAPSIZE,

	IDC_UV_PACKING_COMMON_STARTTILE_TEXT,
	IDS_UV_PACKING_COMMON_STARTTILE_TEXT,
	IDC_UV_PACKING_COMMON_STARTTILE_GROUP,
	IDC_UV_PACKING_COMMON_STARTTILE_U,
	IDC_UV_PACKING_COMMON_STARTTILE_V,

	IDS_UV_PACKING_COMMON_SKIPPOPULATEDTILES_TEXT,
	IDC_UV_PACKING_COMMON_SKIPPOPULATEDTILES,

	IDC_UV_PACKING_COMMON_ORIENTATION_TEXT,
	IDS_UV_PACKING_COMMON_ORIENTATION_TEXT,
	IDC_UV_PACKING_COMMON_ORIENTATION,
		IDC_UV_PACKING_COMMON_ORIENTATION_FREE,
		IDC_UV_PACKING_COMMON_ORIENTATION_45,
		IDC_UV_PACKING_COMMON_ORIENTATION_90,
		IDC_UV_PACKING_COMMON_ORIENTATION_180,
		IDC_UV_PACKING_COMMON_ORIENTATION_PRESERVE,

		IDS_UV_PACKING_COMMON_ORIENTATION_FREE,
		IDS_UV_PACKING_COMMON_ORIENTATION_45,
		IDS_UV_PACKING_COMMON_ORIENTATION_90,
		IDS_UV_PACKING_COMMON_ORIENTATION_180,
		IDS_UV_PACKING_COMMON_ORIENTATION_PRESERVE,

	IDC_UV_PACKING_COMMON_SCALING_TEXT,
	IDS_UV_PACKING_COMMON_SCALING_TEXT,
	IDC_UV_PACKING_COMMON_SCALING,
		IDC_UV_PACKING_COMMON_SCALING_AUTOFIT,
		IDC_UV_PACKING_COMMON_SCALING_PRESERVE,
		IDC_UV_PACKING_COMMON_SCALING_TEXELDENSITY,

		IDS_UV_PACKING_COMMON_SCALING_AUTOFIT,
		IDS_UV_PACKING_COMMON_SCALING_PRESERVE,
		IDS_UV_PACKING_COMMON_SCALING_TEXELDENSITY,

	IDC_UV_PACKING_COMMON_TEXELDENSITY_TEXT,
	IDS_UV_PACKING_COMMON_TEXELDENSITY_TEXT,
	IDC_UV_PACKING_COMMON_TEXELDENSITY,
	IDC_UV_PACKING_COMMON_TEXELDENSITY_DROPDOWN,
	// Additional definitions for IDD_UV_PACKING end here
	
	IDS_KEEPS_PANEL_OPEN,

	IDS_CAMERA_SET_NAVSPEED_1,
	IDS_CAMERA_SET_NAVSPEED_2,
	IDS_CAMERA_SET_NAVSPEED_3,
	IDS_CAMERA_SET_NAVSPEED_4,
	IDS_CAMERA_SET_NAVSPEED_5,

	IDS_CAMERA_SET_NAVSPEED_1_HELP,
	IDS_CAMERA_SET_NAVSPEED_2_HELP,
	IDS_CAMERA_SET_NAVSPEED_3_HELP,
	IDS_CAMERA_SET_NAVSPEED_4_HELP,
	IDS_CAMERA_SET_NAVSPEED_5_HELP,

	IDS_CAMERA_OPEN_NAV_SETTINGS,
	IDS_CAMERA_OPEN_NAV_SETTINGS_HELP,

	IDS_CAMERA_TOGGLE_WALK_MODE,

	IDS_CAMERA_NAV_SPEED,
	IDS_CAMERA_NAV_SENSITIVITY,
	IDS_CAMERA_NAV_MODE_WALK,
	IDS_CAMERA_NAV_MODE_FLY,
	IDS_CAMERA_WALK_HEIGHT,

	// Additional definitions for IDD_UV_PACKING
	IDC_UV_PACKING_GEOMETRIC_SKIPPOPULATEDTILES,
	IDC_UV_PACKING_RASTERIZED_SKIPPOPULATEDTILES,
	IDC_UV_PACKING_BOUNDINGBOX_SKIPPOPULATEDTILES,
	// Additional definitions for IDD_UV_PACKING end here

	// Additional definitions for IDD_OPTIMAL_MAPPING
	IDC_OPT_MAP_COMMON_RESOLUTION_X,
	IDC_OPT_MAP_COMMON_RESOLUTION_Y,
	IDC_OPT_MAP_COMMON_SPACING,
	IDC_OPT_MAP_AUTOMATICUV_STRETCH_TEXT,
	IDC_OPT_MAP_AUTOMATICUV_STRETCH_TEXT_DUMMY,
	IDC_OPT_MAP_OPTIMALCUBIC_AREA_TEXT,
	IDC_OPT_MAP_OPTIMALCUBIC_AREA_TEXT_DUMMY,
	IDC_OPT_MAP_OPTIMALCUBIC_RELAX_TEXT,
	IDC_OPT_MAP_OPTIMALCUBIC_RELAX_TEXT_DUMMY,
	IDC_OPT_MAP_OPTIMAL_MAX_DIST_TEXT,
	IDC_OPT_MAP_OPTIMAL_MAX_DIST_TEXT_DUMMY,
	IDC_OPT_MAP_OPTIMAL_RELAX_TEXT,
	IDC_OPT_MAP_OPTIMAL_RELAX_TEXT_DUMMY,
	IDC_UV_OPTIONAL_MAPPING_COMMON_GROUP,
	// Additional definitions for IDD_OPTIMAL_MAPPING end here

	// Additional definitions for IDD_UV_PACKING
	IDC_UV_PACKING_COMMON_UVSPACE_TEXT,
	IDS_UV_PACKING_COMMON_UVSPACE_TEXT,
	IDC_UV_PACKING_COMMON_UVSPACE,
	IDC_UV_PACKING_COMMON_UVSPACE_MERGED,
	IDC_UV_PACKING_COMMON_UVSPACE_GROUPED,
	IDC_UV_PACKING_COMMON_UVSPACE_PEROBJECT,
	IDS_UV_PACKING_COMMON_UVSPACE_MERGED,
	IDS_UV_PACKING_COMMON_UVSPACE_GROUPED,
	IDS_UV_PACKING_COMMON_UVSPACE_PEROBJECT,
	// Additional definitions for IDD_UV_PACKING end here

	IDS_MODELING_MOVE_HELP_EXTENDED,
	IDS_MODELING_ROTATE_HELP_EXTENDED,
	IDS_MODELING_SCALE_HELP_EXTENDED,

	IDS_MARK_SEAM,
	IDS_UNMARK_SEAM,
	IDS_MARK_SEAM_HELP,
	IDS_UNMARK_SEAM_HELP,
	IDS_SEAM_TAG_NAME,
	IDS_SEAM_TOOL_NAME,

	// Modeling Modifiers
	IDS_MODIFIERS_PRESERVEUV_ENABLE,
	IDS_MODIFIERS_PRESERVEUV_ENABLE_HELP,

	IDS_MODELING_MOVE_NAME_EXTENDED,
	IDS_MODELING_ROTATE_NAME_EXTENDED,
	IDS_MODELING_SCALE_NAME_EXTENDED,

	IDS_MODELING_OPTION_SOLO_ENABLE,
	IDS_MODELING_OPTION_SOLO_ENABLE_HELP,
	// End of symbol definition
	_DUMMY_ELEMENT_
};

#endif // C4D_SYMBOLS_H__
