CONTAINER Ocamera
{
	NAME Ocamera;
	INCLUDE Obase;

	GROUP ID_OBJECTPROPERTIES
	{
		GROUP
		{
			BUTTON CAMERAOBJECT_CONVERT_TO_REDSHIFT { }
		}

		COLUMNS 3;

		LONG CAMERA_PROJECTION 				{ CYCLE { Pperspective;Pparallel;Pleft;Pright;Pfront;Pback;Ptop;Pbottom;Pmilitary;Pfrog;Pbird;Pgentleman;Pisometric;Pdimetric; } }
		STATICTEXT { JOINEND; }
		STATICTEXT { }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP ID_GROUP_REGULAR_SETTINGS
		{
			COLUMNS 2;

			REAL CAMERA_FOCUS 				{ MIN 1; MAX 10000; STEP 0.1; }
			LONG CAMERAOBJECT_FOCUS_PRESET			{ANIM OFF;  CYCLE { CAMERAOBJECT_FOCUS_PRESET_CUSTOM;CAMERAOBJECT_FOCUS_PRESET_WIDESUPER;CAMERAOBJECT_FOCUS_PRESET_WIDE;CAMERAOBJECT_FOCUS_PRESET_C4D;CAMERAOBJECT_FOCUS_PRESET_NORMAL;CAMERAOBJECT_FOCUS_PRESET_PORTRAIT;CAMERAOBJECT_FOCUS_PRESET_TELE;CAMERAOBJECT_FOCUS_PRESET_TELESUPER; } }

			REAL CAMERAOBJECT_APERTURE 			{ MIN 1.0; MAX 2000.0; STEP 0.1; }
			LONG CAMERAOBJECT_APERTURE_PRESET		{ANIM OFF; CYCLE { CAMERAOBJECT_APERTURE_PRESET_CUSTOM;CAMERAOBJECT_APERTURE_PRESET_8;CAMERAOBJECT_APERTURE_PRESET_16;CAMERAOBJECT_APERTURE_PRESET_35MOVIE;CAMERAOBJECT_APERTURE_PRESET_35STILL;CAMERAOBJECT_APERTURE_PRESET_70; } }

			STATICTEXT CAMERAOBJECT_APERTURE_35 		{ }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERAOBJECT_FOV				{ MIN 0.2; MAX 174.0; UNIT DEGREE; }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERAOBJECT_FOV_VERTICAL { MIN 0.2; MAX 174.0; UNIT DEGREE; }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERA_ZOOM  				{ MIN 0.0001; MAX 1000000.0; STEP 0.1; }
			STATICTEXT { JOINENDSCALE; }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERAOBJECT_FILM_OFFSET_X 		{ UNIT PERCENT; }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERAOBJECT_FILM_OFFSET_Y 		{ UNIT PERCENT; }
			STATICTEXT { JOINENDSCALE; }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERAOBJECT_TARGETDISTANCE 		{ UNIT METER; MINEX; MIN 0.0; }
			BITMAPBUTTON	CAMERAOBJECT_TARGETDISTANCE_PICK	{  }

			BOOL CAMERAOBJECT_USETARGETOBJECT	{ }
			STATICTEXT { JOINENDSCALE; }

			LINK CAMERAOBJECT_TARGETOBJECT 			{ FIT_H; ACCEPT { Obase; } }
			STATICTEXT { JOINENDSCALE; }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERAOBJECT_WHITE_BALANCE_TEMPERATURE	{ MIN 1000.0; MAX 10000.0; STEP 10.0; }
			LONG CAMERAOBJECT_WHITE_BALANCE			{ANIM OFF;  CYCLE {CAMERAOBJECT_WHITE_BALANCE_CUSTOM;CAMERAOBJECT_WHITE_BALANCE_CANDLE;CAMERAOBJECT_WHITE_BALANCE_TUNGSTEN;CAMERAOBJECT_WHITE_BALANCE_FLUORESCENT;CAMERAOBJECT_WHITE_BALANCE_FLASH;CAMERAOBJECT_WHITE_BALANCE_DAYLIGHT;CAMERAOBJECT_WHITE_BALANCE_OVERCAST;CAMERAOBJECT_WHITE_BALANCE_SHADE; } }

			BOOL CAMERAOBJECT_WHITE_BALANCE_LIGHTS_ONLY	{ }
			STATICTEXT { JOINENDSCALE; }

			SEPARATOR { LINE; }
			STATICTEXT { JOINENDSCALE; }

			BOOL CAMERAOBJECT_AFX	{ }
			STATICTEXT { JOINENDSCALE; }
		}
	}

	// --- Lens Group
	GROUP ID_GROUP_LENS
	{
		COLUMNS 3;

		BOOL CAMERAOBJECT_MOVIECAMERA	{}
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_FNUMBER_VALUE			{ MIN 0.01; MAX 256.0; STEP 0.1; }
		LONG CAMERAOBJECT_FNUMBER			{ANIM OFF;  CYCLE { CAMERAOBJECT_FNUMBER_CUSTOM;CAMERAOBJECT_FNUMBER_10;CAMERAOBJECT_FNUMBER_11;CAMERAOBJECT_FNUMBER_12;CAMERAOBJECT_FNUMBER_14;CAMERAOBJECT_FNUMBER_16;CAMERAOBJECT_FNUMBER_18;CAMERAOBJECT_FNUMBER_20;CAMERAOBJECT_FNUMBER_22;CAMERAOBJECT_FNUMBER_25;CAMERAOBJECT_FNUMBER_28;CAMERAOBJECT_FNUMBER_32;CAMERAOBJECT_FNUMBER_35;CAMERAOBJECT_FNUMBER_40;CAMERAOBJECT_FNUMBER_45;CAMERAOBJECT_FNUMBER_50;CAMERAOBJECT_FNUMBER_56;CAMERAOBJECT_FNUMBER_63;CAMERAOBJECT_FNUMBER_71;CAMERAOBJECT_FNUMBER_80;CAMERAOBJECT_FNUMBER_90;CAMERAOBJECT_FNUMBER_100;CAMERAOBJECT_FNUMBER_110;CAMERAOBJECT_FNUMBER_130;CAMERAOBJECT_FNUMBER_140;CAMERAOBJECT_FNUMBER_160;CAMERAOBJECT_FNUMBER_180;CAMERAOBJECT_FNUMBER_200;CAMERAOBJECT_FNUMBER_220; } }
		STATICTEXT { }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		BOOL CAMERAOBJECT_EXPOSURE			{ }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_ISO_VALUE			{ MIN 10.0; MAX 10000.0; STEP 10.0; }
		LONG CAMERAOBJECT_ISO_PRESET {ANIM OFF;  CYCLE { CAMERAOBJECT_ISO_PRESET_CUSTOM;CAMERAOBJECT_ISO_PRESET_50;CAMERAOBJECT_ISO_PRESET_100;CAMERAOBJECT_ISO_PRESET_200;CAMERAOBJECT_ISO_PRESET_400;CAMERAOBJECT_ISO_PRESET_800;CAMERAOBJECT_ISO_PRESET_1600;CAMERAOBJECT_ISO_PRESET_3200;CAMERAOBJECT_ISO_PRESET_6400; } }
		STATICTEXT { }

		REAL CAMERAOBJECT_GAIN_VALUE			{ MIN -100.0; MAX 100.0; STEP 1.0; }		
		STATICTEXT { }
		STATICTEXT { }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		REAL CAMERAOBJECT_SHUTTER_SPEED_VALUE		{ MIN 0.0001; MAX 100.0; STEP 0.001; }
		LONG CAMERAOBJECT_SHUTTER_SPEED_PRESET {ANIM OFF;  CYCLE { CAMERAOBJECT_SHUTTER_SPEED_PRESET_CUSTOM;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_1000;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_500;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_250;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_125;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_60;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_30;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_15;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_8;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_4;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_2;CAMERAOBJECT_SHUTTER_SPEED_PRESET_1_1;CAMERAOBJECT_SHUTTER_SPEED_PRESET_2_1;CAMERAOBJECT_SHUTTER_SPEED_PRESET_4_1;CAMERAOBJECT_SHUTTER_SPEED_PRESET_8_1;CAMERAOBJECT_SHUTTER_SPEED_PRESET_15_1;CAMERAOBJECT_SHUTTER_SPEED_PRESET_30_1; } }
		STATICTEXT { }

		REAL CAMERAOBJECT_SHUTTER_ANGLE			{ MIN 10.0; MAX 1080.0; STEP 1.0; UNIT DEGREE; }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_SHUTTER_OFFSET		{ MIN 0.0; MAX 360.0; STEP 1.0; UNIT DEGREE; }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_SHUTTER_EFFICIENCY		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		STATICTEXT { }
		STATICTEXT { }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		REAL CAMERAOBJECT_LENS_DISTORTION_QUAD		{ MIN -100.0; MAX 100.0; STEP 0.1; UNIT PERCENT; }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_LENS_DISTORTION_CUBIC		{ MIN -100.0; MAX 100.0; STEP 0.1; UNIT PERCENT; }
		STATICTEXT { }
		STATICTEXT { }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		REAL CAMERAOBJECT_VIGNETTING_INTENSITY		{ MIN 0.0; MAX 500.0; STEP 0.1; UNIT PERCENT; }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_VIGNETTING_OFFSET		{ MIN 0.0; MAX 100.0; STEP 0.1; UNIT PERCENT; }
		STATICTEXT { }
		STATICTEXT { }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		REAL CAMERAOBJECT_CHROMATIC_ABERRATION_STRENGTH	{ MIN -1000.0; MAX 1000.0; STEP 0.1; UNIT PERCENT; }
		STATICTEXT { }
		STATICTEXT { }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		BOOL CAMERAOBJECT_APERTURE_SHAPE		{ PARENTCOLLAPSE; }
		STATICTEXT { }
		STATICTEXT { }

		LONG CAMERAOBJECT_APERTURE_BLADES 		{ PARENTCOLLAPSE CAMERAOBJECT_APERTURE_SHAPE; MIN 3; MAX 32; }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_APERTURE_ANGLE		{ PARENTCOLLAPSE CAMERAOBJECT_APERTURE_SHAPE; MIN 0.0; MAX 3600.0; UNIT DEGREE; }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_APERTURE_BIAS			{ PARENTCOLLAPSE CAMERAOBJECT_APERTURE_SHAPE; MIN -1.0; MAX 1.0; STEP 0.1; }
		STATICTEXT { }
		STATICTEXT { }

		REAL CAMERAOBJECT_APERTURE_ANISOTROPY		{ PARENTCOLLAPSE CAMERAOBJECT_APERTURE_SHAPE; MIN -100.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		STATICTEXT { }
		STATICTEXT { }

		SHADERLINK CAMERAOBJECT_APERTURE_SHADER		{ PARENTCOLLAPSE CAMERAOBJECT_APERTURE_SHAPE; FIT_H;}
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }
	}

	// --- Settings Group
	GROUP ID_GROUP_SETTINGS
	{
		COLUMNS 2;
		BOOL CAMERAOBJECT_NEAR_CLIPPING_ENABLE 	{ }
		STATICTEXT 				{ NEWLINE; }
		REAL CAMERAOBJECT_NEAR_CLIPPING 	{ UNIT METER; MIN 0.0; }
		STATICTEXT 				{ NEWLINE; }

		BOOL CAMERAOBJECT_FAR_CLIPPING_ENABLE 	{ }
		STATICTEXT 				{ NEWLINE; }
		REAL CAMERAOBJECT_FAR_CLIPPING 		{ UNIT METER; MIN 0.0; }
		STATICTEXT 				{ NEWLINE; }

		FILENAME CAMERAOBJECT_PROJECTIONRENDER 	{ HIDDEN; }
		STATICTEXT 				{ NEWLINE; }

		SEPARATOR { LINE; }
		STATICTEXT { JOINENDSCALE; }

		BOOL CAMERAOBJECT_SHOW 			{ }
		STATICTEXT 				{ NEWLINE; }

		SEPARATOR { LINE; }
		STATICTEXT { JOINENDSCALE; }

		GROUP
		{
			BOOL CAMERAOBJECT_FRONTBLUR 	{ }
			REAL CAMERAOBJECT_FRONTSTART 	{ PARENTID CAMERAOBJECT_FRONTBLUR; UNIT METER; MIN 0.0; }
			REAL CAMERAOBJECT_FRONTEND 	{ PARENTID CAMERAOBJECT_FRONTBLUR; UNIT METER; MIN 0.0; }

			BOOL CAMERAOBJECT_REARBLUR 	{ }

			REAL CAMERAOBJECT_REARSTART 	{ PARENTID CAMERAOBJECT_REARBLUR; UNIT METER; MIN 0.0; }
			REAL CAMERAOBJECT_REAREND 	{ PARENTID CAMERAOBJECT_REARBLUR; UNIT METER; MIN 0.0; }
		}
	}

	// --- Stereo Group
 	GROUP ID_GROUP_STEREO
 	{
		GROUP ID_GROUP_STEREO_REGULAR
		{
 			LONG CAMERAOBJECT_STEREO_MODE
 			{
 				CYCLE
 				{
 					CAMERAOBJECT_STEREO_MODE_MONO;
 					CAMERAOBJECT_STEREO_MODE_SYMMETRICAL;
 					CAMERAOBJECT_STEREO_MODE_LEFT;
 					CAMERAOBJECT_STEREO_MODE_RIGHT;
 				}
 			}
 			REAL CAMERAOBJECT_STEREO_EYESEPARATION { UNIT METER; MIN 0; STEP 0.01; }
 			LONG CAMERAOBJECT_STEREO_PLACEMENT
 			{
 				CYCLE
 				{
 					CAMERAOBJECT_STEREO_PLACEMENT_PARALLEL;
 					CAMERAOBJECT_STEREO_PLACEMENT_OFF_AXIS;
 					CAMERAOBJECT_STEREO_PLACEMENT_ON_AXIS;
 					CAMERAOBJECT_STEREO_PLACEMENT_RADIAL;
 				}
 			}
 			BOOL CAMERAOBJECT_STEREO_SHOW_ALL { }
 			REAL CAMERAOBJECT_STEREO_ZERO_PARALLAX { UNIT METER; MIN 0; }
 			LONG CAMERAOBJECT_STEREO_AUTO_PLANES
 			{
 				CYCLE
 				{
 					CAMERAOBJECT_STEREO_AUTO_PLANES_MANUAL;
 					CAMERAOBJECT_STEREO_AUTO_PLANES_70;
 					CAMERAOBJECT_STEREO_AUTO_PLANES_90;
 				}
 			}
 			REAL CAMERAOBJECT_STEREO_NEAR_PLANE { UNIT METER; MIN 0; }
 			REAL CAMERAOBJECT_STEREO_FAR_PLANE { UNIT METER; MIN 0; }
 			BOOL CAMERAOBJECT_STEREO_SHOW_FLOATING_FRAME { }
		}

		GROUP ID_GROUP_STEREO_SPC
		{
 			LONG CAMERAOBJECT_SPC_STEREO_MODE
 			{
 				CYCLE
 				{
 					CAMERAOBJECT_SPC_STEREO_MONO;
 					CAMERAOBJECT_SPC_STEREO_PARALLEL;
 					CAMERAOBJECT_SPC_STEREO_TOEIN;
 				}
 			}

		  LONG CAMERAOBJECT_SPC_STEREO_LAYOUT 			{ CYCLE { SPC_LAYOUT_ABOVE_UNDER; SPC_LAYOUT_SIDE_BY_SIDE; SPC_LAYOUT_LEFT_ONLY; SPC_LAYOUT_RIGHT_ONLY; } }

 			REAL CAMERAOBJECT_SPC_STEREO_EYESEPARATION { UNIT METER; MIN 0; STEP 0.01; }
 			REAL CAMERAOBJECT_SPC_STEREO_NECK_DIST { UNIT METER; MIN 0; STEP 0.01; }
			SEPARATOR { LINE; }
			STATICTEXT { JOINEND; }
			STATICTEXT { JOINENDSCALE; }

 			REAL CAMERAOBJECT_SPC_STEREO_FOCAL { UNIT METER; MIN 0.01; STEP 0.01; }

			SEPARATOR { LINE; }
			STATICTEXT { JOINEND; }
			STATICTEXT { JOINENDSCALE; }

 			LONG CAMERAOBJECT_SPC_STEREO_N_POLE_MODE 
 			{
 				CYCLE
 				{
 					CAMERAOBJECT_SPC_STEREO_SMOOTH_NONE;
 					CAMERAOBJECT_SPC_STEREO_SMOOTH_LINEAR;
					CAMERAOBJECT_SPC_STEREO_SMOOTH_EXP;
 				}
 			}

			REAL CAMERAOBJECT_SPC_STEREO_N_POLE_ANGLE			
			{ 
				UNIT DEGREE;
				MIN  -90.0; 
				MAX   0.0; 
				CUSTOMGUI REALSLIDER;
			}
			STATICTEXT { JOINEND; }
			STATICTEXT { JOINENDSCALE; }
		
			REAL CAMERAOBJECT_SPC_STEREO_N_POLE_EXP 	{ MIN 0.; MAX 10.0; STEP 0.1; }

 			LONG CAMERAOBJECT_SPC_STEREO_S_POLE_MODE 
 			{
 				CYCLE
 				{
 					CAMERAOBJECT_SPC_STEREO_SMOOTH_NONE;
 					CAMERAOBJECT_SPC_STEREO_SMOOTH_LINEAR;
					CAMERAOBJECT_SPC_STEREO_SMOOTH_EXP;
 				}
 			}

			REAL CAMERAOBJECT_SPC_STEREO_S_POLE_ANGLE				
			{ 
				UNIT DEGREE;
				MIN   0.0; 
				MAX   90.0; 
				CUSTOMGUI REALSLIDER;
			}
			STATICTEXT { JOINEND; }
			STATICTEXT { JOINENDSCALE; }

			REAL CAMERAOBJECT_SPC_STEREO_S_POLE_EXP 	{ MIN 0.; MAX 10.0; STEP 0.1; }
		}
  }

	// --- Layout Helper Group
	GROUP ID_GROUP_LAYOUTHELP
	{
		COLUMNS 3;

		GROUP CAMERAOBJECT_GROUP_SAFE_AREAS
		{
			DEFAULT 1;
			BOOL CAMERAOBJECT_DISPLAY_RESOLUTION								{ PARENTCOLLAPSE; DEFAULT 1; }
				BOOL CAMERAOBJECT_DISPLAY_RESOLUTION_MASKED						{ PARENTCOLLAPSE CAMERAOBJECT_DISPLAY_RESOLUTION; }
				REAL CAMERAOBJECT_DISPLAY_RESOLUTION_OPACITY					{ MINSLIDER 0; MAXSLIDER 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; PARENTCOLLAPSE CAMERAOBJECT_DISPLAY_RESOLUTION; }
				COLOR CAMERAOBJECT_DISPLAY_RESOLUTION_COLOR						{ PARENTCOLLAPSE CAMERAOBJECT_DISPLAY_RESOLUTION; }
			BOOL CAMERAOBJECT_DISPLAY_SENSOR									{ }

			SEPARATOR															{ LINE; }
			BOOL CAMERAOBJECT_DISPLAY_SAFE_ACTION								{ }
			REAL CAMERAOBJECT_DISPLAY_SAFE_ACTION_SIZE							{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
			BOOL CAMERAOBJECT_DISPLAY_SAFE_TITLE								{ }
			REAL CAMERAOBJECT_DISPLAY_SAFE_TITLE_SIZE							{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }

			SEPARATOR															{ LINE; }
			REAL CAMERAOBJECT_DISPLAY_EDITOR_OVERSCAN							{ MIN 0; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		}

		BOOL	CAMERAOBJECT_LAYOUTHELP_ENABLE								{  }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		SEPARATOR																						{ LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_GRID_ENABLE						{  }
		BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_ENABLE				{  }
		STATICTEXT {  }

		BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_ENABLE			{  }
		BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_ENABLE	{  }
		STATICTEXT {  }

		BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ENABLE		{  }
		BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_CROSSHAIR_ENABLE			{  }
		STATICTEXT {  }

		SEPARATOR																						{ LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP	CAMERAOBJECT_LAYOUTHELP_DRAW_GRID
		{
			LONG	CAMERAOBJECT_LAYOUTHELP_DRAW_GRID_CELLS				{ MIN 2; MAX 20; CUSTOMGUI LONGSLIDER; }
			COLOR	CAMERAOBJECT_LAYOUTHELP_DRAW_GRID_COLOR				{  }
		}
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP CAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL
		{
			BOOL	CAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_MIRROR		{  }
			COLOR	CAMERAOBJECT_LAYOUTHELP_DRAW_DIAGONAL_COLOR		{  }
		}
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES
		{
			GROUP
			{
				COLUMNS 2;

				LONG	CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_MODE		{ CYCLE { CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_MODE_1; CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_MODE_2; } }
				STATICTEXT	{  }
			}
			BOOL	CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_MIRROR	{  }
			BOOL	CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_FLIP		{  }
			COLOR	CAMERAOBJECT_LAYOUTHELP_DRAW_TRIANGLES_COLOR	{  }
		}
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION
		{
			LONG	CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_I			{ MIN 1; MAX 5; CUSTOMGUI LONGSLIDER; }
			BOOL	CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_TOP		{  }
			BOOL	CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_RIGHT	{  }
			BOOL	CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_BOTTOM	{  }
			BOOL	CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_LEFT		{  }
			COLOR	CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSECTION_COLOR	{  }
		}
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL
		{
			BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_MIRROR_H	{  }
			BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_MIRROR_V {  }
			BOOL CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_FLIP			{  }
			GROUP
			{
				COLUMNS 2;

				LONG CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_V	{ CYCLE { CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_TOP; CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_CENTER; CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_BOTTOM; } }
				LONG CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_H	{ CYCLE { CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_LEFT; CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_CENTER; CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_ALIGN_RIGHT; } }
				STATICTEXT	{  }
			}
			COLOR	CAMERAOBJECT_LAYOUTHELP_DRAW_GOLDENSPIRAL_COLOR		{  }
		}
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP CAMERAOBJECT_LAYOUTHELP_DRAW_CROSSHAIR
		{
			REAL CAMERAOBJECT_LAYOUTHELP_DRAW_CROSSHAIR_SCALE				{ UNIT PERCENT; MIN 0.0; MINSLIDER 0.0; MAXSLIDER 200.0; CUSTOMGUI REALSLIDER; }
			COLOR	CAMERAOBJECT_LAYOUTHELP_DRAW_CROSSHAIR_COLOR			{  }
		}
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }
	}

	// --- Spherical Camera.
	GROUP ID_GROUP_SPC_TAB
	{
		COLUMNS 3;

		BOOL CAMERAOBJECT_SPC_ENABLE 	{ }
		STATICTEXT 				{ JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		SEPARATOR { LINE; }
		STATICTEXT { JOINEND; }
		STATICTEXT { JOINENDSCALE; }

		GROUP ID_GROUP_SPC_SETTINGS
		{
		  LONG CAMERAOBJECT_SPC_GIZMO 			{ CYCLE { SPC_GIZMO_LATLONG;SPC_GIZMO_DOME; } }
		  LONG CAMERAOBJECT_SPC_PROJECTION_MAPPING 			{ CYCLE { SPC_MAPPING_LATLONG;SPC_MAPPING_CUBIC;SPC_MAPPING_CUBIC32;SPC_MAPPING_CUBIC_STRING;} }
			SEPARATOR { LINE; }
			BOOL CAMERAOBJECT_SPC_FIT_FRAME 	{ }

			GROUP ID_GROUP_SPC_LATLONG
			{
				COLUMNS 3;

				BOOL CAMERAOBJECT_SPC_FULL_RANGE_ENABLE 	{ }
				STATICTEXT 				{ JOINEND; }
				STATICTEXT { JOINENDSCALE; }

				REAL CAMERAOBJECT_SPC_LONG_MIN				
				{ 
					UNIT DEGREE;
					MIN -180.0; 
					MAX 180.0; 
					CUSTOMGUI REALSLIDER;
				}

				STATICTEXT { JOINEND; }
				STATICTEXT { JOINENDSCALE; }

				REAL CAMERAOBJECT_SPC_LONG_MAX				
				{ 
					UNIT DEGREE;
					MIN -180.0; 
					MAX 180.0; 
					CUSTOMGUI REALSLIDER;
				}

				STATICTEXT { JOINEND; }
				STATICTEXT { JOINENDSCALE; }

				REAL CAMERAOBJECT_SPC_LAT_MIN				
				{ 
					UNIT DEGREE;
					MIN -90.0; 
					MAX  90.0; 
					CUSTOMGUI REALSLIDER;
				}
				STATICTEXT { JOINEND; }
				STATICTEXT { JOINENDSCALE; }

				REAL CAMERAOBJECT_SPC_LAT_MAX				
				{ 
					UNIT DEGREE;
					MIN -90.0; 
					MAX  90.0; 
					CUSTOMGUI REALSLIDER;
				}
				STATICTEXT { JOINEND; }
				STATICTEXT { JOINENDSCALE; }
			}

			GROUP ID_GROUP_SPC_DOME
			{
				COLUMNS 3;
				REAL CAMERAOBJECT_SPC_DOME_LAT				
				{ 
					UNIT DEGREE;
					MINSLIDER -90.0; 
					MAXSLIDER  90.0; 
					CUSTOMGUI REALSLIDER;
				}
				STATICTEXT { JOINEND; }
				STATICTEXT { JOINENDSCALE; }
			}
		}
	}
}
