#ifndef C4D_SYMBOLS_H__
#define C4D_SYMBOLS_H__

// fixed ids
enum
{
	IDS_TRISTATE_TEXT = 200000145,
	IDM_A_HQ_VIEWPORT_DEPTHOFFIELD = 1038947,
	IDM_BAKEASALEMBIC = 1040814,
	IDM_BAKEASALEMBICDELETE = 1040815,
	// to support UV OpenGL Viewport
	R_UV_VIEW_PANEL = 1041355,
	IDM_UVEDIT_UVGIZMO = 1038963,

	IDM_SHORTCUTPRESET_LIST				= 1057409,
	IDM_SHORTCUTPRESET_RENAME			= 1057411,
	IDM_SHORTCUTPRESET_DELETE			= 1057412,
	IDM_SHORTCUTPRESET_LOAD				= 1057413,
	IDM_SHORTCUTPRESET_DUPLICATE	= 1057429,

	IDM_CAPSULE_ASSET_TO_GROUP		= 180429000,
	IDM_HEATMAP_DUMP							= 190000000,
	IDM_HEATMAP_ENABLE						= 190000001,
	IDM_HEATMAP_ISENABLED					= 190000002,
	IDM_HEATMAP_ISSUPPORTED				= 190000003,
	IDM_CAPSULE_DUMP							= 190000005,
	IDM_CAPSULE_FORCEDIRTY				= 190000006,

	IDM_UNDOREDO_HISTORY = 1063388,

	X_IDS_FIXED_END_X
};

// TODO: (Seb) Cleanup undef

// must be undefined because of c4d_gui.h in unity builds
#undef IDC_OK
#undef IDC_CANCEL

// must be undefined because of sb_main.h in unity builds
#undef IDM_CM_CLOSEWINDOW

// must be undefined because of ge_prepass.h in unity builds
#undef IDM_UNDO
#undef IDM_CUT
#undef IDM_COPY
#undef IDM_PASTE
#undef IDM_DELETE
#undef IDM_SELECTALL
#undef IDM_SELECTNONE
#undef IDM_REDO
#undef IDM_INVERSION
#undef IDM_KEY_LAST
#undef IDM_KEY_NEXT

#undef HOTKEY_CAMERA_MOVE
#undef HOTKEY_CAMERA_SCALE
#undef HOTKEY_CAMERA_ROTATE

#undef HOTKEY_OBJECT_MOVE
#undef HOTKEY_OBJECT_SCALE
#undef HOTKEY_OBJECT_ROTATE

#undef HOTKEY_MODEL_SCALE
#undef HOTKEY_ZOOM
#undef HOTKEY_SELECT_FREE
#undef HOTKEY_SELECT_LIVE
#undef HOTKEY_SELECT_RECT


// Please do NOT remove any deprecated symbol but mark as unused instead.
enum
{
	R_PANELVIEW							= 59000,	// needs 499 free IDs afterwards
	R_PANELVIEW_MULTIRANGE	= 499,
	R_UV_PANELVIEW						= 59500,	// needs 499 free IDs afterwards
	R_UV_PANELVIEW_MULTIRANGE	= 499,

	IDS_SERIAL_EXPIRED = 70001,
	IDS_SERIAL_EXPIRE1 = 70002,
	IDS_SERIAL_EXPIRE2 = 70003,
	IDS_SERIAL_ENTERDATA = 70004,
	IDS_SERIAL_WRONG = 70005,
	IDS_REG_AMBERSN = 70006,
	IDS_SERIAL_NETWORK = 70007,
	IDS_REG_TAKEEFFECT = 70008,
	IDS_SERIAL_EXPIRE3 = 70009,
	IDS_SERIAL_MISSING = 70010,
	IDS_SERIAL_CHANGE  = 70011,
	IDS_SERIAL_NETWORK_URL,

	IDC_COFFEE = 100000,

	R_DIALOG_GUICONFIG,

	DELME_IDC_BUBBLEHELP1,
	IDC_BUBBLEHELP2,
	IDC_THREADPRIORITY,

	IDC_MENUICON,
	IDC_MENUSHORTCUT,

	IDC_COLORTYPE,
	IDC_EDITCOLOR,

	IDC_BORDER,
	IDC_BORDER_STYLE,

	DELME_IDC_DELAY,
	DELME_IDC_DELAY_VALUE,

	IDC_GUIFONT,
	IDC_GUIFONTTYPE,

	DELME_IDC_DIALOGSTYLE,
	DELME_IDC_DIALOGALIGN,

	R_BATCHRENDER,
	IDC_BATCHSELECT1,
	IDC_BATCHSELECT2,
	IDC_BATCHSELECT3,
	IDC_BATCHSELECT4,
	IDC_BATCHSELECT5,
	IDC_BATCHSELECT6,
	IDC_BATCHSELECT7,
	IDC_BATCHSELECT8,
	IDC_BATCHSELECT9,
	IDC_BATCHSELECT10,
	IDC_BATCHNAME1,
	IDC_BATCHNAME2,
	IDC_BATCHNAME3,
	IDC_BATCHNAME4,
	IDC_BATCHNAME5,
	IDC_BATCHNAME6,
	IDC_BATCHNAME7,
	IDC_BATCHNAME8,
	IDC_BATCHNAME9,
	IDC_BATCHNAME10,

	IDM_RENDERBATCH_EX,

	IDC_OPENGL_AA_LINES,
	IDC_OPENGL_PERSPECT,
	IDC_OPENGL_MIPMAP,
	IDC_OPENGL_FASTREDRAW,
	IDC_OPENGL_FASTLIVESELECTION,

	IDC_PATTERNNAME,
	IDC_RESET,

	IDC_PATTERNPOPUP,

	IDS_FONT_SYSTEM,

	IDC_USEPATTERNS,
	IDC_NAVSERVICE,

	ISD_NO_PATTERN,
	IDS_LINE_POS,

	IDS_TEXT_GOTOLINE,

	IDS_TEXT_FIND,
	IDS_TEXT_NEXT,
	IDS_TEXT_PREVIOUS,
	IDS_TEXT_IGNORECASE,
	IDS_TEXT_WRAPAROUND,
	IDS_TEXT_NOTHINGFOUND,

	IDC_TOOLCURSOR
};

// Please do NOT remove any deprecated symbol but mark as unused instead.
enum
{
	P_DIALOG_SECTION_START = 180000,

	P_SETUPWIZARD,
	IDC_SW_TABGROUP,
	IDC_TAB_SELECT_OBJECTS,
	IDC_SW_OBJECTS,
	IDC_SW_MATERIALS,
	IDC_SW_SELECTALL,
	IDC_SW_DESELECTALL,
	IDC_SW_OBJECTLIST,
	IDC_SW_SELECTED,
	IDC_SW_NEXT,
	IDC_TAB_UVSETUP,
	IDC_SW_UV_RECALC,
	IDC_SW_UV_OPTIMALCUBICMAPPING,
	IDC_SW_UV_OPTIMALMAPPING,
	IDC_SW_UV_REALIGN,
	IDC_SW_UV_RELAXATION,
	IDC_SW_UV_ONE_MATERIAL,
	IDC_SW_UV_PREVIOUS,
	IDC_SW_UV_NEXT,
	IDC_TAB_MATERIALSETUP,
	IDC_SW_MAT_CREATE_MISSING_MATERIALS,
	IDC_SW_MAT_CREATE_MISSING_CHANNELS,
	IDC_SW_MAT_COLOR,
	IDC_SW_MAT_COLOR_C,
	IDC_SW_MAT_DIFFUSION,
	IDC_SW_MAT_DIFFUSION_C,
	IDC_SW_MAT_LUMINANCE,
	IDC_SW_MAT_LUMINANCE_C,
	IDC_SW_MAT_TRANSPARENCY,
	IDC_SW_MAT_TRANSPARENCY_C,
	IDC_SW_MAT_REFLECTION,
	IDC_SW_MAT_REFLECTION_C,
	IDC_SW_MAT_ENVIRONMENT,
	IDC_SW_MAT_ENVIRONMENT_C,
	IDC_SW_MAT_BUMP,
	IDC_SW_MAT_BUMP_C,
	IDC_SW_MAT_ALPHA,
	IDC_SW_MAT_ALPHA_C,
	IDC_SW_MAT_SPECULAR,
	IDC_SW_MAT_SPECULAR_C,
	IDC_SW_MAT_DISPLACEMENT,
	IDC_SW_MAT_DISPLACEMENT_C,
	IDC_SW_MAT_RESCALE_EXISTING,
	IDC_SW_MAT_AUTOMATIC_MAPSIZE,
	IDC_TEXTURETAB,
	IDC_SW_MAT_AMSI,
	IDC_SW_MAT_AMSI_MIN,
	IDC_SW_MAT_AMSI_MAX,
	IDC_SW_MAT_QUANTIZE,
	IDC_SW_MAT_TEX,
	IDC_SW_MAT_TEX_WIDTH,
	IDC_SW_MAT_TEX_HEIGHT,
	IDC_SW_MAT_PREVIOUS,
	IDC_SW_MAT_NEXT,
	IDC_TAB_FINISH,
	IDC_SW_FINISH_LOG,
	IDC_SW_FINISH_PREV,
	IDC_SW_FINISH_CLOSE,
	IDC_SW_UV_AUTOMATICPACKEDUV,
	IDC_SW_UV_AUTOMATICPACKEDUV_OVERLAPIDENTICAL,
	IDC_SW_UV_AUTOMATICPACKEDUV_OVERLAPMIRRORED,
	P_DIALOG_SECTION_END
};

// Please do NOT remove any deprecated symbol but mark as unused instead.
enum
{
	IDM_PAINTER_START = 150000,
	P_PAINT_MANAGERDEFS = 150001,
	P_PAINT_TEXTURE2D,
	P_PAINT_BRUSHLISTWINDOW,
	P_PAINT_MATWINDOW,
	P_PAINT_POLYWINDOW,
	P_PAINT_CHANNELMANAGER,
	P_PAINT_COLORSOURCE,
	OBSOLETE_P_PAINT_COLORPRESETS_STATIC,
	P_PAINT_BRUSHEDITOR,
	OBSOLETE_P_PAINT_BRUSHPRESETS_STATIC,
	OBSOLETE_P_PAINT_BITMAPINFO,
	P_PAINT_TEXTUREMANAGER,
	// Depreciated, do not reuse these IDs
	// IDP_3DPAINT,
	P_PAINTTOOL_FILLBITMAP = 150014,
	P_PAINTTOOL_MAGICWAND,
	P_PAINTTOOL_PICKUP,
	P_PAINTTOOL_SELECTION,
	P_UVEDIT_PREFS,
	P_NEWBITMAP,
	P_UVEDIT_NUMERIC,
	P_PAINTTOOL_LINE,
	P_PAINTTOOL_POLYGONSHAPE,
	P_PAINTTOOL_SELECTCOLOR,
	P_UVEDIT_REMAP,
	P_UVEDIT_UNTRUEUV,
	P_PAINTTOOL_TEXT,
	P_ROTATE,
	P_SCALE,
	P_CANVAS,
	P_FLIP,
	P_ZOOM,
	P_PAINT_BRUSHPROFILE,
	P_FEATHER,
	P_PAINTTOOL_TRANSFORM,
	P_GROWSELECTION,
	P_SHRINKSELECTION,
	P_SAVEFORMAT,
	P_PAINTTOOL_CLONE,
	P_GENERALPREFS,
	P_CROP,
	P_PAINT_TEXMATMANAGER,
	P_PAINT_COLORPRESETS_POPUP,
	P_PAINT_BRUSHPRESETS_POPUP,
	P_PAINTTOOL_GRADIENT,
	P_PAINT_GRADIENTPRESET_STATIC,
	P_PAINT_GRADIENTPRESET_POPUP,
	P_PAINTTOOL_BRUSH,
	P_PAINTTOOL_ERASER,
	P_PAINTTOOL_MOVELAYER,
	P_PAINTTOOL_DODGE,
	P_PAINTTOOL_BURN,
	P_PAINTTOOL_SPONGE,
	P_PAINTTOOL_SMEAR,
	P_UVGIZMO_PREFS,
	DELME_P_UVEDIT_PREFS_NEW,

	M_TEXTUREVIEW      = 151000,
	M_TEXTUREMANAGER,
	M_TEXTUREMANAGER_POPUP1,
	M_TEXTUREMANAGER_POPUP2,
	OBSOLETE_M_BRUSHPRESETS,
	M_BRUSHSETTINGS,
	OBSOLETE_M_COLORPRESETS,
	M_COLORSETTINGS,
	DELME_M_TOOLPRESETS,
	M_TEXTUREMANAGER_SPLINE,
	M_UVTOOL_POPUP,

	IDP_TEXTURELIST		= 160000,
	IDP_BITMAPFILTER  = 164000,
	IDP_UVTAGS				= 165000,

	IDP_TEXTURE_NEW		= 170000,
	IDP_TEXTURE_OPEN,
	IDP_TEXTURE_REVERT,
	IDP_TEXTURE_CLOSE,
	IDP_TEXTURE_SAVE,
	IDP_TEXTURE_SAVEAS,
	IDP_TEXTURE_SAVECOPYAS,
	IDP_COPY_MERGED,
	DELME_IDP_FILLBITMAP,
	IDP_UVEDIT_SHOWMESH,
	DELME_IDP_UVEDIT_EDITPOINTS,
	DELME_IDP_UVEDIT_EDITFACES,
	DELME_IDP_UVEDIT_SELECTLIVE,
	DELME_IDP_UVEDIT_SELECTRECT,
	DELME_IDP_UVEDIT_SELECTPOLY,
	DELME_IDP_UVEDIT_SELECTFREE,
	DELME_IDP_UVEDIT_MOVE,
	DELME_IDP_UVEDIT_SCALEUNIFORM,
	DELME_IDM_UVEDIT_SCALE,
	DELME_IDP_UVEDIT_ROTATE,
	DELME_IDM_UVEDIT_SHEAR,
	DELME_IDM_UVEDIT_TAPER,
	IDP_UVEDIT_MIRRORX,
	IDP_UVEDIT_MIRRORY,
	DELME_IDP_UVEDIT_NUMERIC,
	IDP_FITTOSCREEN,
	IDP_ACTUALPIXELS,
	IDP_ZOOMIN,
	IDP_ZOOMOUT,
	IDP_SETZOOM,
	IDP_ACTIVEMATERIALCHANNELS,
	X_IDP_ALLTEXTURES,
	X_IDP_PAINT_LEFTLIST_NO,
	X_IDP_PAINT_LEFTLIST_SMALL,
	X_IDP_PAINT_LEFTLIST_MEDIUM,
	X_IDP_PAINT_LEFTLIST_LARGE,
	IDP_PAINT_RIGHTLIST_NO,
	IDP_PAINT_RIGHTLIST_SMALL,
	IDP_PAINT_RIGHTLIST_MEDIUM,
	IDP_PAINT_RIGHTLIST_LARGE,
	X_IDP_CHANNEL_COLOR,
	X_IDP_CHANNEL_DIFFUSION,
	X_IDP_CHANNEL_LUMINANCE,
	X_IDP_CHANNEL_TRANSPARENCY,
	X_IDP_CHANNEL_REFLECTION,
	X_IDP_CHANNEL_ENVIRONMENT,
	X_IDP_CHANNEL_BUMP,
	X_IDP_CHANNEL_ALPHA,
	X_IDP_CHANNEL_SPECULARCOLOR,
	X_IDP_CHANNEL_DISPLACEMENT,
	IDP_NEWLAYER,
	IDP_CHANNEL_ADDLAYERMASK,
	IDP_DUPLICATELAYER,
	IDP_CHANNEL_DELETE,
	IDP_CHANNEL_FLATTEN,
	IDP_CHANNEL_FLATTEN_VISIBLE,
	IDP_MERGEDOWN,
	IDP_MERGELINKED,
	IDP_SELECTIONFROMLAYER,
	IDP_NEWALPHACHANNEL,
	IDP_CONVERTTOGRAY,
	IDP_CONVERTTORGB,
	IDP_REPLACETEXTURE,
	IDP_REVERTTOSAVED,
	IDP_BITMAPINFO,
	IDP_DISABLECHANNEL,
	IDP_BRUSH_NEWFOLDER,
	IDP_BRUSH_NEW,
	IDP_BRUSH_REVERT_EX,
	IDP_BRUSH_SAVEASDEFAULT_EX,
	IDP_BRUSH_IMPORT,
	IDP_BRUSH_EXPORTSELECTION,
	IDP_BRUSH_EXPORTVISIBLE_EX,
	IDP_BRUSH_EDIT_EX,
	IDP_BRUSH_RENAME,
	IDP_BRUSH_DUPLICATE_EX,
	IDP_BRUSH_DELETE,
	IDP_BRUSH_ASLIST,
	IDP_BRUSH_ASICON,
	IDP_BRUSH_SMALLICONS,
	IDP_BRUSH_MEDIUMICONS,
	IDP_BRUSH_LARGEICONS,
	IDP_COLOR_NEWFOLDER,
	IDP_COLOR_NEW,
	IDP_COLOR_REVERT_EX,
	IDP_COLOR_SAVEASDEFAULT_EX,
	IDP_COLOR_IMPORT,
	IDP_COLOR_EXPORTSELECTION,
	IDP_COLOR_EXPORTVISIBLE_EX,
	IDP_COLOR_EDIT_EX,
	IDP_COLOR_RENAME,
	IDP_COLOR_DUPLICATE_EX,
	IDP_COLOR_DELETE,
	IDP_COLOR_ASLIST,
	IDP_COLOR_ASICON,
	IDP_COLOR_SMALLICONS,
	IDP_COLOR_MEDIUMICONS,
	IDP_COLOR_LARGEICONS,
	IDP_COLOR_ADDPRESET,
	OBSOLETE_IDP_COLOR_OVERWRITE,
	IDP_COLOR_COPY,
	IDP_COLOR_PASTE,
	IDP_BRUSH_ADDPRESET,
	IDP_NEWTEXTUREVIEW,
	DELME_IDP_BRUSHSETTINGS,
	IDP_COLORSETTINGS,
	OBSOLETE_IDP_BRUSHPRESETS,
	IDP_COLORPRESETS,
	IDP_TEXTUREMANAGER,
	IDP_PREVIEW_COLOR,
	IDP_PREVIEW_DIFFUSION,
	IDP_PREVIEW_LUMINANCE,
	IDP_PREVIEW_TRANSPARENCY,
	IDP_PREVIEW_REFLECTION,
	IDP_PREVIEW_ENVIRONMENT,
	IDP_PREVIEW_BUMP,
	IDP_PREVIEW_ALPHA,
	IDP_PREVIEW_SPECULARCOLOR,
	IDP_PREVIEW_DISPLACEMENT,
	IDP_PREVIEW_MULTI,
	IDP_CLOSEALLTEXTURES,
	IDP_SAVEALLTEXTURES,
	IDP_TOOL_SELECTCIRCLE,
	IDP_TOOL_SELECTRECT,
	IDP_TOOL_SELECTPOLYLINES,
	IDP_TOOL_SELECTFREEHAND,
	IDP_TOOL_MAGICWAND,
	IDP_TOOL_SELECTCOLORRANGE,
	IDP_PAINT_SELECTALL,
	IDP_PAINT_DESELECTALL,
	IDP_PAINT_INVERSESELECTION,
	IDP_TOOL_MOVELAYER,
	IDP_TOOL_MAGNIFY,
	IDP_TOOL_PICKUP,
	IDP_TOOL_BRUSH,
	IDP_TOOL_CLONE,
	IDP_TOOL_ERASER,
	IDP_TOOL_FILLBITMAP,
	IDP_TOOL_TRANSFORMBITMAP,
	IDP_TOOL_DRAWLINE,
	IDP_TOOL_DRAWTEXT,
	IDP_TOOL_POLYGONSHAPE,
	DELME_IDP_TOOL_SMUDGE,
	DELME_IDP_TOOL_SHARPEN,
	DELME_IDP_TOOL_SOFTEN,
	IDP_PAINT_SCALE,
	IDP_PAINT_CANVAS,
	IDP_PAINT_ROTATE,
	IDP_PAINT_FLIPX,
	IDP_PAINT_FLIPY,
	IDP_PAINT_FILLBITMAP,
	IDP_UVEDIT_FILLFACES,
	IDP_UVEDIT_OUTLINEFACES,
	IDP_PAINT_CREATEMASKFROMSELECTION,
	IDP_DISPLAYSINGLECHANNEL,
	IDP_PAINT_TILEU,
	IDP_PAINT_TILEV,
	IDP_CLEARBITMAP,
	X_OBSOLETE_IDP_HIGHQUALITY,
	DELME_IDP_RAYBRUSHALL,
	DELME_IDP_RAYBRUSHACTIVE,
	DELME_IDP_RAYBRUSHPART,

	PGD_SELECTION_SHAPE,
	PGD_SELECTION_HANDLE,
	HANDLE_BOX,
	HANDLE_DIA,
	HANDLE_MID,

	IDS_PAINT_FILE,
	IDS_PAINT_EDIT,
	IDS_PAINT_TOOLS,
	IDS_PAINT_FUNCTIONS,
	IDS_PAINT_VIEW,
	IDS_TEXTURES,
	IDS_PAINT_TEXTUREMANAGER_VIEW,
	IDS_PAINT_LEFTLIST,
	IDS_PAINT_RIGHTLIST,
	IDS_PAINT_TEXTUREMANAGER_FUNCTIONS,
	IDS_PAINT_BRUSH_GROUP,
	IDS_PAINT_BRUSH_VIEW,
	IDS_PAINT_COLOR_GROUP,
	IDS_PAINT_COLOR_VIEW,
	IDS_PAINT_PAINTER,
	IDS_PAINT_PAINTERMAIN,
	IDS_PAINT_SELECTIONMAIN,
	IDS_PAINT_TOOLSMAIN,
	IDS_PAINT_FUNCTIONSMAIN,
	DELME_IDS_NAME_BACKGROUND,
	DELME_IDS_NAME_LAYER,
	DELME_IDS_NAME_SELECTION,
	DELME_IDS_NAME_ALPHA,
	IDS_CHANNEL_COLOR,
	IDS_CHANNEL_DIFFUSION,
	IDS_CHANNEL_LUMINANCE,
	IDS_CHANNEL_TRANSPARENCY,
	IDS_CHANNEL_REFLECTION,
	IDS_CHANNEL_ENVIRONMENT,
	IDS_CHANNEL_BUMP,
	IDS_CHANNEL_ALPHA,
	IDS_CHANNEL_SPECULARCOLOR,
	IDS_CHANNEL_DISPLACEMENT,
	IDS_ERROR_READINGTEXTURE,
	IDS_NOSELECTION,
	IDS_FLOATINGLAYER,
	IDS_TEXTURE_WRONGNAME,
	IDS_TEXTURE_TEXNOTFOUND,
	IDS_SELECT_TEXTURE,
	IDS_TITLE_2DVIEW,
	IDS_TEXTUREINMEMORY,
	IDS_SAVECHANNEL,
	IDS_TEXTURELOADINMEMORY,
	IDS_TEXTURESAVECHANGES,
	IDS_TEXTUREINMATERIAL,
	IDS_TEXTURE_INFO,
	X_IDS_PAINT_CHANNELS,
	IDS_CM_PAINTER,
	IDS_CM_TEXTUREVIEW,
	IDS_CM_TEXTUREMANAGER,
	OBSOLETE_IDS_CM_BRUSHPRESETS,
	OBSOLETE_IDS_CM_COLORPRESETS,
	IDS_CM_PAINTERMAIN,

	IDP_EDITMASK,

	IDP_UVEDIT_REMAP,
	IDP_UVEDIT_BAKE,
	IDP_UVEDIT_BAKE_RESTORE,
	IDP_UVEDIT_INTERACTIVE_START,
	IDP_UVEDIT_INTERACTIVE_STOP,
	IDP_UVEDIT_INTERACTIVE,
	DELME_IDP_UVEDIT_UNTRUEUV,
	IDP_UVEDIT_RESETUV,
	IDP_UVEDIT_FITCANVASTOUV,
	IDP_COLOR_ADDPRESET_MULTI,

	IDP_LAYERMASKADDSELECTION,
	IDP_LAYERMASKSUBSELECTION,


	DELME_IDM_UVEDIT_MAGNET,
	IDP_UVEDIT_MAGNET_TYPE,
	IDP_UVEDIT_MAGNET_NEAREST,
	IDP_UVEDIT_MAGNET_RADIUS,
	IDP_UVEDIT_MAGNET_WIDTH,

	IDP_SELECTIONFROMLAYERADD,
	IDP_SELECTIONFROMLAYERSUB,


	IDP_ROTATE_MATERIALNAME,
	IDP_ROTATE_C0,
	IDP_ROTATE_S0,
	IDP_ROTATE_C1,
	IDP_ROTATE_S1,
	IDP_ROTATE_C2,
	IDP_ROTATE_S2,
	IDP_ROTATE_C3,
	IDP_ROTATE_S3,
	IDP_ROTATE_C4,
	IDP_ROTATE_S4,
	IDP_ROTATE_C5,
	IDP_ROTATE_S5,
	IDP_ROTATE_C6,
	IDP_ROTATE_S6,
	IDP_ROTATE_C7,
	IDP_ROTATE_S7,
	IDP_ROTATE_C8,
	IDP_ROTATE_S8,
	IDP_ROTATE_C9,
	IDP_ROTATE_S9,
	IDP_ROTATE_ANGLE,
	IDP_ROTATE_SAMPLE,
	IDP_ROTATE_OPTION,
	IDP_ROTATE_UVW,

	IDP_SCALE_MATERIALNAME,
	IDP_SCALE_C0,
	IDP_SCALE_S0,
	IDP_SCALE_C1,
	IDP_SCALE_S1,
	IDP_SCALE_C2,
	IDP_SCALE_S2,
	IDP_SCALE_C3,
	IDP_SCALE_S3,
	IDP_SCALE_C4,
	IDP_SCALE_S4,
	IDP_SCALE_C5,
	IDP_SCALE_S5,
	IDP_SCALE_C6,
	IDP_SCALE_S6,
	IDP_SCALE_C7,
	IDP_SCALE_S7,
	IDP_SCALE_C8,
	IDP_SCALE_S8,
	IDP_SCALE_C9,
	IDP_SCALE_S9,
	IDP_SCALE_WIDTH,
	IDP_SCALE_HEIGHT,
	IDP_SCALE_LOCK,
	IDP_SCALE_TYPE,
	IDP_SCALE_SAMPLE,

	IDP_CANVAS_MATERIALNAME,
	IDP_CANVAS_C0,
	IDP_CANVAS_S0,
	IDP_CANVAS_C1,
	IDP_CANVAS_S1,
	IDP_CANVAS_C2,
	IDP_CANVAS_S2,
	IDP_CANVAS_C3,
	IDP_CANVAS_S3,
	IDP_CANVAS_C4,
	IDP_CANVAS_S4,
	IDP_CANVAS_C5,
	IDP_CANVAS_S5,
	IDP_CANVAS_C6,
	IDP_CANVAS_S6,
	IDP_CANVAS_C7,
	IDP_CANVAS_S7,
	IDP_CANVAS_C8,
	IDP_CANVAS_S8,
	IDP_CANVAS_C9,
	IDP_CANVAS_S9,
	IDP_CANVAS_LEFT,
	IDP_CANVAS_TOP,
	IDP_CANVAS_RIGHT,
	IDP_CANVAS_BOTTOM,
	IDP_CANVAS_SYMMETRIC,
	IDP_CANVAS_UVW,

	IDP_FLIP_MATERIALNAME,
	IDP_FLIP_C0,
	IDP_FLIP_S0,
	IDP_FLIP_C1,
	IDP_FLIP_S1,
	IDP_FLIP_C2,
	IDP_FLIP_S2,
	IDP_FLIP_C3,
	IDP_FLIP_S3,
	IDP_FLIP_C4,
	IDP_FLIP_S4,
	IDP_FLIP_C5,
	IDP_FLIP_S5,
	IDP_FLIP_C6,
	IDP_FLIP_S6,
	IDP_FLIP_C7,
	IDP_FLIP_S7,
	IDP_FLIP_C8,
	IDP_FLIP_S8,
	IDP_FLIP_C9,
	IDP_FLIP_S9,
	IDP_FLIP_UVW,
	IDP_PASTEINTO_SELECTION,

	IDP_ZOOM_VALUE,
	IDP_ZOOM_POPUP,

	IDC_BITMAPINFO_PREVIEW,
	IDC_BITMAPINFO_NAME,
	IDC_BITMAPINFO_TYPE,
	IDC_BITMAPINFO_SIZE,
	IDC_BITMAPINFO_LAYER_VISIBLE,
	IDC_BITMAPINFO_LAYER_BLENDING,
	IDC_BITMAPINFO_LAYER_STRENGTH,
	IDC_BITMAPINFO_LAYER_OFFSETX,
	IDC_BITMAPINFO_LAYER_OFFSETY,
	IDC_BITMAPINFO_LAYER_COLORMODE,
	IDC_BITMAPINFO_LAYER_MEMORY,
	IDC_BITMAPINFO_TAB,

	IDC_OBJECT_PAINTTEXTURE,
	IDC_OBJECT_PAINTLAYER,

	IDC_BRUSH_TYPE_SIMPLE,
	IDC_BRUSH_TYPE_BITMAP,
	IDC_BRUSHEDIT_TAB,
	IDC_BRUSHEDIT_PREVIEW,
	IDC_BRUSHEDIT_STORECOLOR,
	IDC_BRUSHEDIT_SIZE,
	IDC_BRUSHEDIT_SIZE_MOD,
	IDC_BRUSHEDIT_DISTANCE_ON,
	IDC_BRUSHEDIT_DISTANCE,
	IDC_BRUSHEDIT_DISTANCE_MOD,
	IDC_BRUSHEDIT_DISPLACEMENT_ON,
	IDC_BRUSHEDIT_DISPLACEMENT,
	IDC_BRUSHEDIT_DISPLACEMENT_MOD,
	IDC_BRUSHEDIT_PRESSURE,
	IDC_BRUSHEDIT_PRESSURE_MOD,
	IDC_BRUSHEDIT_HARDNESS,
	IDC_BRUSHEDIT_HARDNESS_MOD,
	IDC_BRUSHEDIT_SQUEEZE,
	IDC_BRUSHEDIT_SQUEEZE_MOD,
	IDC_BRUSHEDIT_ROTATION,
	IDC_BRUSHEDIT_ROTATION_MOD,
	IDC_BRUSHEDIT_SHAPE,
	IDC_BRUSHEDIT_PROFILE,
	IDC_BRUSHEDIT_PROFILE_EDIT,
	IDC_BRUSHEDIT_BRUSHTYPE,
	IDC_BRUSHEDIT_BMP_NAME,
	IDC_BRUSHEDIT_BMP_POPUP,
	IDC_BRUSHEDIT_BMP_SIZE,
	IDC_BRUSHEDIT_BMP_SIZE_MOD,
	IDC_BRUSHEDIT_BMP_PRESSURE,
	IDC_BRUSHEDIT_BMP_PRESSURE_MOD,
	IDC_BRUSHEDIT_BMP_DISTANCE_ON,
	IDC_BRUSHEDIT_BMP_DISTANCE,
	IDC_BRUSHEDIT_BMP_DISPLACEMENT_ON,
	IDC_BRUSHEDIT_BMP_DISPLACEMENT,
	IDC_BRUSHEDIT_BMP_DISPLACEMENT_MOD,
	IDC_BRUSHEDIT_BMP_ROTATION,
	IDC_BRUSHEDIT_BMP_ROTATION_MOD,
	IDC_BRUSHEDIT_FILTER,
	IDC_BRUSHEDIT_FILTER_SMUDGECOLOR,
	IDC_BRUSHEDIT_FILTER_SMUDGECOLOR_MOD,
	IDC_BRUSHEDIT_FILTER_SMUDGEFLATTEN,

	IDC_COLORSOURCE_SOLIDCOLOR,
	IDC_COLORSOURCE_TEXTURE,
	IDC_COLORSOURCE_TABSOLIDCOLOR,
	IDC_COLORSOURCE_TABTEXTURE,
	IDC_COLORSOURCE_TAB,
	IDC_COLORSOURCE_STRENGTH,
	IDC_COLORSOURCE_BLENDING,
	IDC_COLORSOURCE_RGB,
	IDC_COLORSOURCE_TEXTUREDEST,
	IDC_COLORSOURCE_PREVIEW,
	IDC_COLORSOURCE_TEXTUREGROUP,
	IDC_COLORSOURCE_TEXTUREPOPUP,
	IDC_COLORSOURCE_TEXTURENAME,
	IDC_COLORSOURCE_TEXTURE_SX,
	IDC_COLORSOURCE_TEXTURE_SY,
	IDC_COLORSOURCE_TEXTURE_DX,
	IDC_COLORSOURCE_TEXTURE_DY,
	IDC_COLORSOURCE_TEXTURE_SCALE,
	IDC_COLORSOURCE_TEXTURE_SCALE_ON,
	IDC_COLORSOURCE_TEXTURE_SCALE_MOD,
	IDC_COLORSOURCE_TEXTURE_ROTATION,
	IDC_COLORSOURCE_TEXTURE_ROTATION_ON,
	IDC_COLORSOURCE_TEXTURE_ROTATION_MOD,
	IDC_COLORSOURCE_TEXTURE_PREVIEW,
	IDC_COLORSOURCE_TEXTURE_TILING,
	IDC_COLORSOURCE_WALLPAPERGROUP,
	IDC_COLORSOURCE_WALLPAPERPOPUP,
	IDC_COLORSOURCE_WALLPAPERNAME,
	IDC_COLORSOURCE_WALLPAPERSTRENGTH,
	IDC_COLORSOURCE_WALLPAPERBLENDING,
	IDC_COLORSOURCE_WALLPAPERPREVIEW,
	IDC_COLORSOURCE_IGNOREFILTER,

	IDC_BRUSHPROFILE_POPUP,
	IDC_BRUSHPROFILE_STRENGTH,
	IDC_BRUSHPROFILE_RADIUS,
	IDC_BRUSHPROFILE_PREVIEW,
	IDC_BRUSHPROFILE_PREVIEW1,
	IDC_BRUSHPROFILE_PREVIEW2,

	IDP_FEATHER,
	IDP_GROWSELECTION,
	IDP_SHRINKSELECTION,

	IDP_TRANSFORM_MODE,
	IDP_TRANSFORM_APPLY,

	IDP_UNDOPAINTER,
	IDP_EXECUTE_LASTFILTER,

	IDS_TEXTUREVIEW_ZOOM,
	IDS_TEXTUREVIEW_SIZE,
	IDS_PAINTTOOL_DOESNTWORK,
	IDS_PAINTOBJECT_TEXTURE,
	IDS_PAINTOBJECT_LAYER,
	IDS_PAINT_UNKNOWN,
	IDS_PAINT_RGB24,
	IDS_PAINT_RGBA,
	IDS_PAINT_GRAY8,
	IDS_PAINT_GRAYA,
	IDS_PAINT_BYTE,
	IDS_PAINT_KBYTE,
	IDS_PAINT_MBYTE,
	IDS_PAINT_GBYTE,
	IDS_PAINT_BRUSHPRESETS,
	IDS_PAINT_BRUSHDEF,
	IDS_PAINT_COLORPRESETS,
	IDS_PAINT_COLORDEF,
	IDS_PAINT_COLORDEFMULTI,
	IDS_FROMDISC,
	DELME_IDS_REREADDIR,
	IDS_PAINT_SELECT_PATTERN,
	IDS_PAINT_COPYPATTERN,
	IDS_PAINT_ALREADYEXISTS,
	IDS_PAINT_NONE,
	IDS_PAINT_DRAWDIRECTION,
	IDS_PAINT_DRAWRANDOM,
	IDS_PAINT_DRAWWHEEL,
	IDS_PAINT_DRAWDISTANCE,
	IDS_PAINT_PENPRESSURE,
	IDS_PAINT_PENTILT,
	IDS_PAINT_PENFINGERWHEEL,
	IDS_PAINT_PENDIRECTION,
	IDS_PAINT_PIXEL,
	IDS_PAINT_VALUE,
	IDS_PAINT_COPYCURVE,
	IDS_PAINT_PASTECURVE,
	IDS_PAINT_RESETTODEFAULT,
	IDS_PAINT_FLIPX,
	IDS_PAINT_FLIPY,
	IDS_PAINT_MIN,
	IDS_PAINT_MAX,
	IDS_PAINT_PIXELLENGTH,
	IDS_PAINT_LOOPS,
	IDS_PAINT_EFFECTORSETTINGS,
	IDS_PAINT_B3DFORMAT,
	IDS_PAINT_B3DXMLFORMAT,
	IDS_PAINT_COPY,
	IDS_PAINT_SPLINE,
	IDS_PAINT_ALLPRESETS,
	IDS_PAINT_NEWFOLDER,
	IDS_PAINT_REVERTTEXTURE,
	IDS_PAINT_RENAMETEXTURE,
	IDS_PAINT_SAVEASSIOCTEXTURES_EX,
	IDS_PAINT_DELETEENTRY,
	IDS_PAINT_OVERWRITEENTRY,
	IDS_PAINT_REVERTCHANGES,
	IDS_PAINT_SAVEDEFAULTSETTINGS,
	IDS_PAINT_SAVEALLSETTINGS,
	IDS_PAINT_LAYERMANAGER,
	IDS_PAINT_LAYERS,
	IDS_PAINT_ALPHAS,
	DELME_IDS_PAINT_BLENDNORMAL,
	DELME_IDS_PAINT_BLENDDISSOLVE,
	DELME_IDS_PAINT_BLENDDIFFERENCE,
	DELME_IDS_PAINT_BLENDLIGHTEN,
	DELME_IDS_PAINT_BLENDDARKEN,
	DELME_IDS_PAINT_BLENDMULTIPLY,
	DELME_IDS_PAINT_BLENDSCREEN,
	DELME_IDS_PAINT_BLENDADD,
	DELME_IDS_PAINT_BLENDEXCLUSION,
	IDS_PAINT_ALPHASTRAIGHT,
	IDS_PAINT_ALPHAPREMULTI,
	IDS_PAINT_PROCIMAGE,
	IDS_PAINT_TMATERIAL,
	IDS_PAINT_TTEXTURE,
	IDS_PAINT_DIFFSIZE,
	IDS_PAINT_BRUSHERROR,
	IDS_BRUSH_TINY,
	IDS_BRUSH_SMALL,
	IDS_BRUSH_AVERAGE,
	IDS_BRUSH_BIG,
	IDS_BRUSH_HUGE,
	IDS_PAINT_TEXT,
	IDS_PAINT_HELPDRAG,
	IDS_PAINT_HELPBRUSH,
	IDS_PAINT_HELPPOLY,
	IDS_PAINT_HELPTEXT,
	IDS_PAINT_HELPCLONE1,
	IDS_PAINT_HELPCLONE2,
	IDS_PAINT_HELP_LINE,
	IDS_PAINT_HELPFILLLAYER,
	IDS_PAINT_HELPFILLWAND ,
	IDS_PAINT_HELPCOLORRANGE,
	IDS_PAINT_HELPPICKUP,
	IDS_PAINT_HELPSELECT1,
	IDS_PAINT_HELPSELECT2,
	IDS_PAINT_TRANSFORMLAYER,
	IDS_PAINT_TRANSORMONLYONE,
	IDS_PAINT_CALCWEIGHTS,
	IDS_PAINT_HELPSELECTLIVE,
	IDS_PAINT_HELPSELECTFREE,
	IDS_PAINT_HELPSELECTPOLY,
	IDS_PAINT_HELPSELECTRECT,
	IDS_PAINT_HELPZOOM,
	IDS_PAINT_CALCREMAP,
	IDS_PAINT_UNTITLED,
	IDS_PAINT_CREATETEXTURE,
	IDS_PAINT_CONVERTTOGRAY,
	IDS_PAINT_CONVERTTORGB,
	IDS_PAINT_ERROREXECUTEPLUGIN,
	IDS_PAINT_MATENABLED,
	// Depreciated, do not reuse these IDs
	// IDS_PAINT_ENABLEMATERIAL,
	
	IDS_PAINT_SERIAL_EXPIRED = 170557,
	IDS_PAINT_SERIAL_EXPIRE1,
	IDS_PAINT_SERIAL_EXPIRE2,
	IDS_PAINT_SERIAL_WRONG,
	DELME_IDP_PAINT_MANUAL,
	IDS_PAINT_BITMAPFILTER,

	IDS_PAINT_SAVENOLAYERS,
	IDS_PAINT_SAVEALLFEATURES,
	IDS_PAINT_CLOSEASSIOCTEXTURES,
	IDS_PAINT_INACTIVELAYERS,

	IDP_PAINT_CROP,
	IDS_PAINT_ERRORWRITINGFILE,
	IDS_PAINT_REMAPPING,

	IDS_PAINT_ENABLEMATERIAL2,

	IDS_ACTIVE_LAYER,
	IDS_SELECTED_LAYER,

	IDP_TEXTURE_EMPTYUV,
	
	IDS_BPUVTAGS,
	X_IDP_PAINT_SHOWLIST,
	IDP_PROJECTIONPAINT,

	IDS_PAINT_SAVEUNASSIOCTEXTURES,
	IDS_PAINT_SAVETEXT1,
	IDS_PAINT_SAVETEXT2,
	IDS_PAINT_SAVETEXT3,
	IDS_PAINT_SAVETEXT4,
	IDS_PAINT_SAVETEXT5,
	IDS_PAINT_REVERTALL,

	IDC_QUICKTAB1,
	IDC_COLORSOURCE_GROUP_PREVIEW,
	IDC_COLORSOURCE_GROUP_COLOR,
	IDC_COLORSOURCE_GROUP_MIXING,
	IDC_BRUSHEDIT_GROUP_PREVIEW,
	IDC_BRUSHEDIT_GROUP_SETTINGS,
	IDC_BRUSHEDIT_GROUP_FILTER,
	IDC_BRUSHEDIT_STROKEPREVIEW,

	IDP_TOOL_GRADIENT,

	IDP_TOOL_NEWFOLDER,
	IDP_TOOL_REVERT,
	IDP_TOOL_SAVEASDEFAULT,
	IDP_TOOL_IMPORT,
	IDP_TOOL_EXPORTSELECTION,
	IDP_TOOL_EXPORTVISIBLE,
	IDP_TOOL_EDIT,
	IDP_TOOL_RENAME,
	IDP_TOOL_DUPLICATE,
	IDP_TOOL_DELETE,
	IDP_TOOL_ASLIST,
	IDP_TOOL_ASICON,
	IDP_TOOL_SMALLICONS,
	IDP_TOOL_MEDIUMICONS,
	IDP_TOOL_LARGEICONS,
	IDP_TOOL_ADDPRESET,
	IDP_TOOL_OVERWRITE,
	IDP_TOOL_COPY,
	IDP_TOOL_PASTE,

	IDP_TOOL_SPLINESELECTION,

	IDP_PROJECTIONPAINT_APPLY,
	IDP_PROJECTIONPAINT_DISCARD,
	IDP_TOGGLE_FGBG,

	IDS_PP_DISCARD,

	IDC_COLORSOURCE_GROUP_CHANNELS,
	IDC_COLORSOURCE_CHANNELS,

	IDP_TOOLLAYER_MODE,
	IDP_PAINT_HIDEANTS,
	IDP_MOVELAYER_AUTOSELECT,

	IDP_TRANSFORM_MIRRORX,
	IDP_TRANSFORM_MIRRORY,

	IDP_PREVIEW_ACTIVECHANNEL,
	IDP_PAINT_SETUPWIZARD,

	IDS_BPMENU_C4D,
	IDS_BPMENU_IMAGE,
	IDS_BPMENU_LAYER,
	IDS_BPMENU_SELECT,
	IDS_BPMENU_FITLER,
	IDS_BPMENU_SELECTPOLYS,
	IDS_BPMENU_UVEDIT,
	IDS_BPMENU_PAINTTOOLS,
	IDS_BPMENU_UVTOOLS,
	IDS_BPMENU_C4DTOOLS,
	IDS_BPMENU_UVMESH,
	IDS_PAINTER_SENDBACK,
	IDS_PAINTER_SENDBACKHELP,

	IDP_PAINT_BRUSH_SIZE_INC,
	IDP_PAINT_BRUSH_SIZE_DEC,
	IDP_PAINT_BRUSH_HARDNESS_INC,
	IDP_PAINT_BRUSH_HARDNESS_DEC,
	IDP_PAINT_BRUSH_PRESSURE_INC,
	IDP_PAINT_BRUSH_PRESSURE_DEC,
	IDP_PAINT_BRUSH_ROTATION_CLOCKWISE,
	IDP_PAINT_BRUSH_ROTATION_COUNTERCLOCKWISE,

	IDP_TOOL_DODGE,
	IDP_TOOL_BURN,
	IDP_TOOL_SMEAR,
	IDP_TOOL_SPONGE,

	IDS_BRUSH_PREVIEW,
	IDS_BRUSH_SETTINGS,
	IDS_BRUSH_FILTERS,

	IDS_PAINT_NOTHINGSELECTED,
	IDS_PAINT_HELP_GRADIENT,

	IDS_TEXTUREVIEW_BPP,

	IDP_CONVERTTO_UCHAR,
	IDP_CONVERTTO_UWORD,
	IDP_CONVERTTO_FLOAT,

	IDS_PAINT_CONVERTTO_UCHAR,
	IDS_PAINT_CONVERTTO_UWORD,
	IDS_PAINT_CONVERTTO_FLOAT,
	IDS_PAINT_CONVERTTO_BITDEPTHWARNING,

	IDP_NEWLAYERSET,
	IDS_PAINT_SAVENOLAYERSWITHTHISDEPTH,
	IDS_PAINT_SAVEIMAGEWITHTHISDEPTH,

	IDP_PROJECTIONPAINT_RELEASE_PLANE,

	IDS_PP_LAYER,
	IDS_PP_LAYERSET,
	IDS_PP_OBJECTMASK,
	IDS_PP_ALLLAYERS,
	DEPRECATED_IDS_PP_ACTIVELAYER,
	DEPRECATED_IDS_PP_PREPARE,

	IDP_PREVIEW_NORMAL,
	IDS_CHANNEL_NORMAL,
	IDP_FLIP_C10,
	IDP_FLIP_S10,
	IDP_CANVAS_C10,
	IDP_CANVAS_S10,
	IDP_ROTATE_C10,
	IDP_ROTATE_S10,
	IDP_SCALE_C10,
	IDP_SCALE_S10,

	IDC_SW_MAT_NORMAL,
	IDC_SW_MAT_NORMAL_C,

	IDP_FREEZE_VIEW,
	IDP_TEXTURE_MERGE,

	IDS_PP_MERGE,
	IDS_PP_DIFFERENT,
	IDS_PP_ERRORSCALE,

	IDS_FREEZE_VIEWWINDOW,
	IDS_FREEZE_XRES,
	IDS_FREEZE_YRES,
	IDP_BRUSH_NEWLIB,
	IDP_BRUSH_SAVE,
	IDP_BRUSH_SAVEAS,
	IDP_BRUSH_SHOWINCB,
	IDP_COLOR_SHOWINCB,
	IDP_COLOR_NEWLIB,
	IDP_COLOR_SAVE_EX,
	IDP_COLOR_SAVEAS_EX,
	IDS_CHANNEL_ANY,
	IDP_PROJECTIONPAINT_PROJECTBACK,
	IDP_PAINT_DEFINEBRUSH,
	IDP_PAINT_DEFINECOLORSET,
	IDP_PAINT_DEFINEWALLPAPER,
	IDS_FROMSELECTION,
	IDS_EDITINBP,
	IDC_BRUSHEDIT_DISPLACEMENT_BOTHAXIS,
	IDC_BRUSHEDIT_DISPLACEMENT_COUNT,
	IDC_BRUSHEDIT_DISPLACEMENT_COUNT_MOD,
	IDC_BRUSHEDIT_BMP_DISPLACEMENT_COUNT_MOD,
	IDC_BRUSHEDIT_BMP_DISPLACEMENT_COUNT,
	IDC_BRUSHEDIT_BMP_DISPLACEMENT_BOTHAXIS,
	IDC_BRUSHEDIT_AIRSPEED_ON,
	IDC_BRUSHEDIT_AIRSPEED,
	IDC_BRUSHEDIT_AIRSPEED_MOD,
	IDC_BRUSHEDIT_BMP_AIRSPEED_ON,
	IDC_BRUSHEDIT_BMP_AIRSPEED,
	IDC_BRUSHEDIT_BMP_AIRSPEED_MOD,
	IDC_BRUSHEDIT_BMP_SETSAMPLESIZE,
	IDS_PAINT_PENROTATION,
	IDP_UVEDIT_CREATEUVLAYER,
	IDP_TOOL_BLUR,
	IDP_TOOL_SHARPEN,
	IDP_TOOL_HSV,
	P_PAINTTOOL_BLUR,
	P_PAINTTOOL_SHARPEN,
	P_PAINTTOOL_COLORIZE,
	IDP_SHOWTILEDTEXTURE,
	IDP_TRANSFORM_ROTATECW,
	IDP_TRANSFORM_ROTATECCW,

	IDS_PAINT_WRONGLAYERTYPE,
	IDP_PAINT_CONVERTTOPROFILE,
	IDP_PAINT_ASSIGNPROFILE,

	IDS_DISPLACEMENT_TESSELLATION_UNSUPPORTED,

	IDS_PP_PREPARE_SINGLE,
	IDS_PP_PREPARE_MULTI,
	IDS_PP_PREPARE_SUFFIX,

	IDS_FREEZE_FACTOR,

	// labels for coordinates at each corner of reference quad in UV viewport
	IDS_UVCOORD_00,
	IDS_UVCOORD_01,
	IDS_UVCOORD_11,
	IDS_UVCOORD_10,

	// UV viewport axis
	IDS_AXIS_U,
	IDS_AXIS_V,

	// Help bubble text for UV Editor tools
	IDS_HLP_UVEDIT_UVGIZMO,
	IDS_HLP_UVEDIT_MOVE,
	IDS_HLP_UVEDIT_UNIFORM_SCALE,
	IDS_HLP_UVEDIT_SCALE,
	IDS_HLP_UVEDIT_ROTATE,
	IDS_HLP_UVEDIT_MAGNET,
	IDS_HLP_UVEDIT_SHEARU,
	IDS_HLP_UVEDIT_SHEARV,

	// options to display HUD gadgets in Texture View
	IDP_UV_HUD_VIEWPORT_NAME,
	IDP_UV_HUD_RULERS,
	IDP_UV_HUD_AXIS,
	IDP_UV_HUD_UNITS,

	IDP_UV_COMPONENT_HIGHLIGHTING,

	// option to display UV overlapping polygons in Texture View
	IDP_UV_OVERLAPPING_POLYGONS,

	// option to display UV bitmap checkerboard in Texture View
	IDP_TEXTURE_UV_MAP,

	// option to display UV stretch map in Texture View
	IDP_UV_STRETCH_MAP,

	// option to display UV colored islands in Texture View
	IDP_UV_COLORED_ISLANDS,

	// UV settings mode
	IDP_UV_SETTINGS,
	IDP_UV_SETTINGS_ALL,

	// option to display UV seams in Texture View
	IDP_UV_SEAMS,

	// option to display UV connectivity in Texture View
	IDP_UV_CONNECTIVITY,

	// option to display UV mesh as filled polygons in Texture View
	IDP_UV_FILLED_POLYGONS,

	// option to display UV pins in Texture View
	IDP_UV_PINS,

	// New BP submenu strings.
	IDS_BPMENU_UVTAGS,
	IDS_BPMENU_PAINT,
	
	// New View submenu string
	IDS_BPMENU_FILTER,

	IDP_UVEDIT_SHOWUVDISPLAY,

	IDP_UV_LINES,
	IDP_UV_NO_BOUNDARIES,	

	// option to display UV Grid in Texture View
	IDP_UV_GRID,

	IDM_UVEDIT_ALIGN_ISLANDS,
	
	// UV Tools submenu strings
	IDS_BPMENU_RESIZECOMMANDS,
	IDS_BPMENU_TRANSFORMTOOLS,
	IDS_BPMENU_TRANSFORMCOMMANDS,
	
	IDP_FITTOSCREEN_SELECTED,
	IDP_FITTOSCREEN_UVISLANDS,

	IDP_UV_UDIM_INDEX,
	IDS_UV_UDIM_POPUP_TITLE,
	IDS_UV_UDIM_POPUP_TEXT,

	// Option to display polygons that cross uv tiles in Texture View
	IDP_UV_POLYGONS_CROSSING_TILES,

	// Option to display texel density in Texture View
	IDP_UV_TEXEL_DENSITY,

	IDM_PAINTER_END 	// has to be last element
};

// Please do NOT remove any deprecated symbol but mark as unused instead.
enum
{
	// Dialogs must come here
	// Dialog definitions of r_register start here
	R_REGISTER = 99000,
	IDC_REGISTER_PERSONALIZE_GROUP,
	IDC_REGISTER_NAME_EDIT_EX,
	IDC_REGISTER_COMPANY_EDIT_EX,
	IDC_REGISTER_STREET_EDIT_EX,
	IDC_REGISTER_CITY_EDIT_EX,
	IDC_REGISTER_COUNTRY_EDIT_EX,
	IDC_REGISTER_EDIT_GROUP_EX,
	IDC_REGISTER_PASTE_BTN_EX,
	IDC_REGISTER_SERIALS_EDIT_EX,
	IDC_REGISTER_RIGHT_GROUP_EX,
	IDC_REGISTER_LICENSESERVER_GROUP,
	IDC_REGISTER_REGISTRATION_GROUP_EX,
	IDC_REGISTER_SERIALS_GROUP_EX,
	IDC_REGISTER_LICENSERVERLIST_EX,
	IDC_REGISTER_RLM_GROUP,
	IDC_REGISTER_RLM_ERROR_GROUP_EX,
	DELME_IDC_REGISTER_RLM_ETHERNET_ID_EX,
	DELME_IDC_REGISTER_RLM_MACHINE_NAME_EX,
	DELME_IDC_REGISTER_RLM_USER_NAME_EX,
	DELME_IDC_REGISTER_RLM_ERRORMESSAGE_EX,
	// Dialog definitions of IDD_LICENSESERVER_SETUP start here
	IDD_LICENSESERVER_SETUP,
	IDC_SETUP_LICSERVER_SERVER_MODE,
	IDC_SETUP_LICSERVER_SERVER_EDIT,
	IDC_SETUP_LICSERVER_PORT_EDIT,
	IDC_SETUP_LICSERVER_FILE_BTN,
	IDC_SETUP_LICSERVER_USERNAME,
	IDC_SETUP_LICSERVER_PASSWD,
	// Dialog definitions of IDD_LICENSESERVER_SETUP end here
	// Dialog definitions of IDD_LICENSERLM_SETUP start here
	IDD_LICENSERLM_SETUP,
	IDC_SETUP_RLM_SERVER_MODE,
	IDC_SETUP_RLM_SERVER_EDIT,
	IDC_SETUP_RLM_PORT_EDIT,
	IDC_SETUP_RLM_FILE_BTN,
	IDC_SETUP_RLM_PASSWD,
	IDC_SETUP_RLM_HARDWAREID,
	// Dialog definitions of IDD_LICENSERLM_SETUP end here	
	IDC_INSTALL_SERIALS_LICENSE_SERVER_CHK,
	IDC_REGISTER_FORWARD,
	IDC_REGISTER_BACKWARD,
	IDC_REGISTER_HOME,
	// Dialogs must come here
	// Dialog definitions of r_register start here
};

enum
{
	CMDGROUP_EDITOR      = 1000,
		CMDGROUP_EDITOR_FILE     = 1100,
		CMDGROUP_EDITOR_EDIT     = 1200,
		CMDGROUP_EDITOR_OBJECTS  = 1300,
		CMDGROUP_EDITOR_MODELING = 1400,
		CMDGROUP_EDITOR_SELECTION = 1500,
		CMDGROUP_EDITOR_PLUGINS  = 1600,
		CMDGROUP_EDITOR_RENDERING = 1700,
		CMDGROUP_EDITOR_WINDOWS  = 1800,
		CMDGROUP_EDITOR_OPTIONS  = 1900,

	CMDGROUP_TIMELINE_NAVIGATION = 2200,


	CMDGROUP_OBJMAN      = 3000,

	CMDGROUP_MATMAN      = 4000,
	CMDGROUP_SPREADSHEET = 6000,
	CMDGROUP_VIEWWINDOW  = 7000,
	CMDGROUP_OUTWINDOW   = 8000,
	CMDGROUP_HOTKEYS     = 9000,
	CMDGROUP_OTHERS      = 10000,
	CMDGROUP_PLUGINS     = 11000,

	CMDGROUP_PAINTER		 = 12000,
		CMDGROUP_TEXTUREVIEW = 12100,
		CMDGROUP_TEXTUREMANAGER  = 12200,
		CMDGROUP_BRUSHPRESETS  = 12300,
		CMDGROUP_COLORPRESETS  = 12400,
		CMDGROUP_PAINTERMAIN	= 12500,


	X_DUMMY02_X
};


enum
{
	IDC_OK = 1,
	IDC_CANCEL = 2,
	ICON_WINDOW	= 9000,


	IDS_NOMEM	= 10002,
	IDC_SELECT	= 10003,
	IDS_FILEOPEN	= 10004,
	IDC_DESELECT	= 10005,
	IDS_FILECLOSE	= 10006,
	IDC_SELECT2	= 10007,
	IDS_FILEREAD	= 10008,
	IDC_DESELECT2	= 10009,
	IDS_FILEWRITE	= 10010,
	IDC_SELECT3	= 10011,
	IDC_ERSATZ1	= 10012,
	IDS_FILESEEK	= 10013,
	IDC_RAYOPT_ILLUMINATION	= 10014,
	IDC_DESELECT3	= 10015,
	IDC_GET1	= 10016,
	IDC_MOTIONBLUR	= 10017,
	IDC_RAYOPT_TEXTURES	= 10018,
	IDC_SELECT4	= 10019,
	IDC_GET2	= 10020,
	IDS_NOMEMRETRY	= 10021,
	IDC_RAYOPT_OUTLINE	= 10022,
	IDC_DESELECT4	= 10023,
	IDC_ERSATZ5	= 10024,
	IDC_RAYSAVE_PATHCHOOSER	= 10025,
	IDC_RAYOPT_EDGES	= 10026,
	IDC_SELECT5	= 10027,
	IDC_GET3	= 10028,
	IDC_DESELECT5	= 10029,
	IDC_ERSATZ6	= 10030,
	IDC_RAYSAVE_EXTERNALCHOOSER	= 10031,
	IDC_SELECT6	= 10032,
	IDC_GET4	= 10033,
	IDC_FIELD	= 10034,
	IDC_RAYOPT_SHADOWDEPTH	= 10035,
	IDC_DESELECT6	= 10036,
	IDC_ERSATZ7	= 10037,
	IDC_GET5	= 10038,
	IDC_ERSATZ8	= 10039,
	IDC_GET6	= 10040,
	IDC_RAYOPT_THRESHOLD	= 10041,
	IDC_RAYOPT_AA	= 10042,
	IDC_ERSATZ9	= 10043,
	IDC_GET7	= 10044,
	IDC_ERSATZ10	= 10045,
	IDC_GET8	= 10046,
	IDC_GET9	= 10047,
	IDC_GET10	= 10048,
	IDC_VERX	= 10049,
	IDC_ERSATZ2	= 10050,
	IDC_VERY	= 10051,
	IDC_ERSATZ3	= 10052,
	IDC_SNAPSTRENGTH	= 10053,
	IDC_ERSATZ4	= 10054,
	IDC_SNAPFOCUSANGLE	= 10055,
	IDS_UNBEKFORMAT	= 10056,
	IDC_RAYSAVE_PATH	= 10057,
	IDM_STOP	= 10058,
	M_EDITOR	= 10059,
	IDC_RAYSAVE_FORMAT	= 10060,
	//M_PICTURE_VIEWER	= 10061,
	IDC_RAYSAVE_EXTERNAL	= 10062,
	IDC_RAYSAVE_DPI	= 10063,
	R_RAYTRACER	= 10064,
	R_VORPFADE	= 10065,
	M_MATERIAL_MANAGER	= 10066,
	IDC_Y	= 10067,
	M_TIMELINE	= 10068,
	M_TIMELINE_NEW	= 465001600,
	M_SCULPT_LAYERS = 1027062,
	M_PV = 465001704,
	M_RM = 465003501,
	// Depreciated, do not reuse these IDs
	// M_NODEEDITOR = 465002210,
	OM_ID_MENU   = 465002420,
	R_BOOLE	= 10069,
	IDC_Y2	= 10070,
	IDC_Y3	= 10071,
	IDC_DEPTH	= 10072,
	M_STRUCTURE_MANAGER = 10073,
	IDC_LENY	= 10074,
	IDC_Y4	= 10075,
	IDC_VON	= 10076,
	R_SPIEGELN	= 10077,
	IDC_OFFY	= 10078,
	IDC_FILTERSTAERKE	= 10079,
	M_OBJECT_MANAGER	= 10080,
	IDC_Y5	= 10081,
	IDC_BIS	= 10082,
	IDC_SCHATTEN	= 10084,
	DELME_R_UNTERTEILEN	= 10085,
	IDC_LOOPS	= 10086,
	M_PROFILE_MANAGER	= 10087,
	IDC_OBJECTSTAERKE	= 10088,
	IDC_MAPSIZE	= 10089,
	IDC_SCENESTAERKE	= 10090,
	IDC_LIGHTTYPE	= 10091,
	IDC_TRANSPARENZ	= 10092,
	IDC_LI_FALLOFF	= 10093,
	R_DEFORM_WRAPOBJECT	= 10094,
	IDC_RAYOPT_AUTOLIGHT	= 10095,
	IDC_RELIEF	= 10096,
	IDC_SPIEGELUNG	= 10098,
	R_ZUFALL	= 10099,
	IDC_ROST	= 10100,
	IDC_NEBEL	= 10101,
	R_OPTIMIEREN	= 10102,
	IDC_FADEBUMP	= 10103,
	IDC_FRESNEL	= 10104,
	IDC_TRANSADDITIVE	= 10105,
	R_SPLINE_PRIMITIVE	= 10106,
	R_SPLINE_FLOWER	= 10107,
	R_LINIE	= 10108,
	R_SPLINE_NSIDE	= 10109,
	R_SPLINE_STAR	= 10110,
	R_PFADOBJEKT	= 10111,
	R_UMGEBUNGFARBE	= 10112,
	R_SPIRALE	= 10113,
	IDC_FRAMETEXT	= 10114,
	R_MAGNET	= 10116,
	R_RUND	= 10117,
	R_EDITOR	= 10119,
	R_LINSENEFFEKTE	= 10133,
	R_KEYEDIT	= 10134,
	R_TEXTUR	= 10137,
	R_FOLLOW	= 10138,
	R_ANIM_ALIGNTOPATH	= 10139,
	R_DEFORM_MELTOBJECT	= 10140,
	R_DEFORM_WINDOBJECT	= 10141,
	R_ANIM_PULSATE	= 10142,
	R_ANIM_VIBRATE	= 10143,
	R_INAKTIV	= 10144,
	R_SPREADSHEET	= 10146,
	R_PEDIT	= 10147,
	R_ICONMANAGER	= 10148,
	R_PALETTE	= 10149,
	R_TOOLBARS	= 10150,
	R_NAME	= 10151,
	R_BUBBLEHELP	= 10153,
	R_ELLIPSE	= 10154,
	R_SPLINE_RECTANGLE	= 10155,
	R_GDREIECK	= 10156,
	R_SPLINE_PROFILE	= 10157,
	R_SPLINE_COGWHEEL	= 10158,
	R_SPLINE_4SIDE	= 10159,
	R_ANIM_ALIGNTOSPLINE	= 10162,
	R_KINEMATIK	= 10163,
	R_PHONG	= 10164,
	R_DEFORM_SHATTEROBJECT	= 10165,
	R_VOREDITORANSICHT1	= 10167,
	R_SPLINE_CYCLOID	= 10168,
	R_SPLINE_HELIX	= 10169,
	R_SPLINE_CISSOID	= 10170,
	R_SPLINE_FORMULA	= 10171,
	R_RAYQUICKTIMEVR1	= 10172,
	R_LOFT	= 10173,
	R_DEFORM_FFDOBJECT	= 10174,
	M_VIEW_WINDOW	= 10175,
	R_EMITTER	= 10176,
	M_BASIC_CONTEXT	= 10177,
	R_PART_WIND	= 10178,
	R_PART_DEFLEKTOR	= 10179,
	R_PART_GRAVITATION	= 10180,
	R_PART_ROTATION	= 10181,
	R_PART_REIBUNG	= 10182,
	R_PART_TURBULENZ	= 10183,
	R_EXTRUDE	= 10184,
	R_ROTATE	= 10185,
	R_SWEEP	= 10186,
	R_PARTIKEL	= 10187,
	R_DEFORM_FORMULAOBJECT	= 10188,
	R_PART_ATTRAKTOR	= 10189,
	R_BROWSER	= 10194,
	R_BEZIER	= 10197,
	R_PRASTER	= 10198,
	R_EINGABE	= 10199,
	R_LINSENEDITOR	= 10200,
	R_STREAKEDITOR	= 10201,
	R_LINSENGLUEHEN	= 10202,
	R_RAYAUSGABE1	= 10204,
	R_DISPLAY	= 10205,
	R_TANEDIT1	= 10206,
	R_KAMERA2	= 10207,
	R_INFO_MANAGER	= 10209,
	R_BONE1	= 10210,
	R_SPLINE_TEXT	= 10212,
	R_RAYSAVE1	= 10213,
	R_CONSOLE	= 10214,
	R_COF_DEBUG	= 10215,
	R_MATERIALGLOW2	= 10216,
	R_PART_ERASE	= 10217,
	R_BONE2_2	= 10230,
	R_RESETAXIS	= 10231,
	R_TEXMISSING	= 10234,
	IDC_LIGHTSHOWVL	= 10254,
	R_RAYEFFECTS3	= 10258,
	R_RAYOPTIONS3	= 10259,
	R_INSTALL	= 10262,
	R_DECKFLAECHEN2	= 10263,
	R_UEBER1	= 10264,
	R_BLUR	= 10267,
	R_HYPERNURBS	= 10272,
	R_EXPLODE2	= 10273,
	R_DEFORM	= 10274,
	R_MAGOBJECT	= 10275,
	R_WAVE	= 10276,
	R_EXPLODE3	= 10277,
	R_MATERIAL_MANAGER	= 10278,
	R_OBJECT_MANAGER	= 10279,
	DELME_R_OUTWINDOW	= 10280,
	R_TIMELINE	= 10281,
	IDC_UNUSED	= 10282,
	IDC_RADIUS	= 10283,
	IDC_UNUSED3	= 10284,
	IDC_SKALZ	= 10285,
	IDC_RAD2	= 10286,
	IDC_STRENGTH	= 10287,
	IDC_STRENGTH1	= 10288,
	IDC_RADIUS3	= 10289,
	IDC_SKALX	= 10290,
	IDC_MAX	= 10291,
	IDC_MELT_VERTRANDOM	= 10292,
	IDC_UNUSED4	= 10293,
	IDC_NAME	= 10294,
	IDC_FLAECHEN	= 10295,
	IDC_LEN	= 10296,
	IDC_MELT_RADIUS	= 10297,
	IDC_UNUSED5	= 10298,
	IDC_ANZAHL	= 10299,
	IDC_NAMEB	= 10300,
	IDC_UNUSED6	= 10301,
	IDC_PUNKTE	= 10302,
	IDC_FORMULA_Y	= 10303,
	IDC_UNUSED7	= 10304,
	IDC_UNBENUTZTEPUNKTE	= 10305,
	IDC_FORMULA_Z	= 10306,
	IDC_CHAMFER_RADIUS	= 10307,
	IDC_VERSCHIEBUNG	= 10308,
	IDC_RAYOPT_ANTIALIASING	= 10309,
	IDC_ROTZ	= 10310,
	IDC_UNUSED9	= 10311,
	IDC_BRENNWEITE	= 10312,
	IDC_ROTX	= 10313,
	IDC_DISTANZ	= 10314,
	IDC_ZOOM	= 10315,
	IDC_OBJEKTIV	= 10316,
	IDC_ROTY	= 10317,
	IDC_PROJEKTION	= 10318,
	IDC_CONEANGLE	= 10319,
	IDC_LI_OUTERANGLE	= 10320,
	IDC_DREHUNG	= 10321,
	IDC_HELLIGKEIT	= 10322,
	IDC_LI_INNERANGLE	= 10323,
	IDC_SKALY	= 10324,
	IDC_LI_NEARFROM	= 10325,
	IDC_RAYSAVE_NAMEFORMAT	= 10326,
	IDC_THELLIGKEIT	= 10327,
	IDC_EDITMIPOFFSET	= 10328,
	IDC_LI_NEARTO	= 10329,
	IDC_SLIDERR	= 10330,
	IDC_PHONGLUMEDIT	= 10331,
	IDC_LI_OUTER	= 10332,
	IDC_VERZ	= 10333,
	IDC_SLIDERG	= 10334,
	IDC_VN_WINDX	= 10335,
	IDC_SLIDERB	= 10336,
	IDC_KOPIEN	= 10337,
	IDC_INFO	= 10338,
	IDC_PHONGBUMEDIT	= 10339,
	IDC_MODUS	= 10340,
	IDC_SLIDERRANGEX	= 10341,
	IDC_LENSELEMENT	= 10342,
	IDC_PHONGTRNEDIT	= 10343,
	IDC_LI_FARFROM	= 10344,
	IDC_SLIDERRANGEY	= 10345,
	IDC_LI_FARTO	= 10346,
	IDC_ACHSENSYSTEM	= 10347,
	IDC_POLYGONART	= 10348,
	IDC_PARALLEL	= 10349,
	IDC_SLIDERRANGEZ	= 10350,
	IDC_LENSTYP	= 10351,
	IDC_PHONGEINEDIT	= 10352,
	IDC_LI_CONTRAST	= 10353,
	IDC_EBENE	= 10354,
	IDC_WEICH	= 10355,
	IDC_STAERKE	= 10356,
	IDC_INTERART	= 10357,
	IDC_SAMPLES	= 10358,
	IDC_PHONGSPEEDIT	= 10359,
	IDC_EDITMIPSTRENGTH	= 10360,
	IDC_LI_ASPECTRATIO	= 10361,
	IDC_TURBULENZ	= 10362,
	IDC_PHONGIND	= 10363,
	IDC_NOISETIME	= 10364,
	IDC_VN_WINDZ	= 10365,
	IDC_KEYS	= 10366,
	IDC_GLOWSV	= 10367,
	IDC_STERNE	= 10368,
	IDC_PHONGX	= 10369,
	IDC_NOISEOCTAVES	= 10370,
	IDC_VN_WINDVELOCITY	= 10371,
	IDC_COLOR	= 10372,
	IDC_RESOLUTION	= 10373,
	IDC_REFLSV	= 10374,
	IDC_PHONGFALEDIT	= 10375,
	IDC_NOISESTART	= 10376,
	IDC_BREITE	= 10377,
	IDC_X	= 10378,
	IDC_SLIDERH	= 10379,
	IDC_ANTISTUFE	= 10380,
	IDC_FILMFORMAT	= 10381,
	IDC_COLOR2	= 10382,
	IDC_GLOWPRESET	= 10383,
	IDC_PHONGTRAEDIT	= 10384,
	IDC_SLIDERTH	= 10385,
	IDC_X2	= 10386,
	IDC_BILDFILTER	= 10387,
	IDC_STREAKANZ	= 10388,
	IDC_REFLPRESET	= 10389,
	IDC_HALOTYP	= 10390,
	IDC_COLOR3	= 10391,
	IDC_PHONGORI	= 10392,
	IDC_NOISESCALE	= 10393,
	IDC_HELIX_RADIUS2	= 10394,
	IDC_ANTIFAK	= 10395,
	IDC_BILDFOLGE	= 10396,
	IDC_HALOFELD	= 10397,
	IDC_COLOR4	= 10398,
	IDC_PHONGREFEDIT	= 10399,
	IDC_ABSOLUTEBIAS	= 10400,
	IDC_X4	= 10401,
	IDC_HELIX_SUB	= 10402,
	IDC_TEXTUR	= 10403,
	IDC_X3	= 10404,
	IDC_STREAKNUM	= 10405,
	IDC_COLOR5	= 10406,
	IDC_PHONGY	= 10407,
	IDC_OUTLINESHADOW	= 10408,
	IDC_HELIX_RADIUS1	= 10409,
	IDC_LENX	= 10410,
	IDC_STREAKSET	= 10411,
	IDC_SHADOWTRANS	= 10412,
	IDC_X5	= 10413,
	IDC_HELIX_END	= 10414,
	IDC_OFFX	= 10415,
	IDC_STREAKFELD	= 10416,
	IDC_SHADOWCONE	= 10417,
	IDC_HELIX_START	= 10418,
	IDC_STREAKEDIT	= 10419,
	IDC_SOFTCONE	= 10420,
	IDC_LI_NEAR	= 10421,
	IDC_DISC_SEG	= 10422,
	IDC_RESTRICT	= 10423,
	IDC_LI_FAR	= 10424,
	IDC_UNTERTEILUNGEN	= 10425,
	IDC_GLOWHELL	= 10426,
	IDC_LI_INNERCONE	= 10427,
	IDC_REFLHELL	= 10428,
	IDC_LF_SCALE	= 10429,
	IDC_SKAL	= 10430,
	IDC_LF_ROTATION	= 10431,
	IDC_CUBE_SEP	= 10432,
	IDC_LF_REFERENCE	= 10433,
	IDC_CUBE_FENABLE	= 10434,
	IDC_WRAP_TYPE	= 10435,
	IDC_ROT	= 10436,
	IDC_WRAP_XSANGLE	= 10437,
	IDC_FLOWER_PETALS	= 10438,
	IDC_WRAP_XEANGLE	= 10439,
	IDC_FLOWER_ORADIUS	= 10440,
	IDC_WRAP_YSANGLE	= 10441,
	IDC_FLOWER_IRADIUS	= 10442,
	IDC_LAENGE	= 10443,
	IDC_XANZ	= 10444,
	IDC_WRAP_YEANGLE	= 10445,
	IDC_XACHSE	= 10446,
	IDC_YANZ	= 10447,
	IDC_CUBE_SUBY	= 10448,
	IDC_WRAP_WIDTH	= 10449,
	IDC_NSIDE_SIDES	= 10450,
	IDC_ZACHSE	= 10451,
	IDC_ZACKEN	= 10452,
	IDC_CUBE_SUBZ	= 10453,
	IDC_WRAP_HEIGHT	= 10454,
	IDC_FFD_ZSUB	= 10455,
	IDC_ANZ1	= 10456,
	IDC_XLEN	= 10457,
	IDC_YACHSE	= 10458,
	IDC_CLOSE1	= 10459,
	IDC_YLEN	= 10460,
	IDC_PARALLELVERSCHIEBUNG	= 10461,
	IDC_CLOSE2	= 10462,
	IDC_ZLEN	= 10463,
	IDC_ANZ2	= 10464,
	IDC_CUBE_FILLET	= 10465,
	IDC_RUND1	= 10466,
	IDC_CUBE_SUBF	= 10467,
	IDC_RUND2	= 10468,
	IDC_PREVIEW	= 10469,
	IDC_HUELL1	= 10470,
	IDC_FARBE	= 10471,
	IDC_LOCH1	= 10472,
	IDC_TEXTURPREV	= 10473,
	IDC_GROESSE	= 10474,
	IDC_SOFTONOFF	= 10475,
	IDC_GLANZLICHT	= 10476,
	IDC_LEUCHTEND	= 10477,
	IDC_ALPHASOURCE	= 10478,
	IDC_FAKTOR	= 10479,
	IDC_BRECHUNG	= 10480,
	IDC_INVERT	= 10481,
	IDC_SCHATTENWURF	= 10482,
	IDC_OFFSET	= 10483,
	IDC_TAG	= 10484,
	IDC_PFAD	= 10485,
	IDC_MONAT	= 10486,
	IDC_VERLAUF	= 10487,
	IDC_PROJEKT	= 10488,
	IDC_TRANS	= 10489,
	IDC_ACHSE	= 10490,
	IDC_REKURS	= 10491,
	IDC_STUNDEN	= 10492,
	IDC_GRUEN	= 10493,
	IDC_DECAL	= 10494,
	IDC_MINUTEN	= 10495,
	IDC_BLAU	= 10496,
	IDC_WINKEL	= 10497,
	IDC_ACTION_FAC	= 10498,
	IDC_TITLE_FAC	= 10499,
	IDC_LOOKAHEAD	= 10500,
	IDC_TEXT_FONT	= 10501,
	IDC_AKTIV	= 10502,
	IDC_FADEOFFSCREEN	= 10503,
	IDC_RECHTS	= 10504,
	IDC_ZUFALL	= 10505,
	IDC_MEHRFACH	= 10506,
	IDC_INAKTIV	= 10507,
	IDC_POS	= 10508,
	IDC_DARK	= 10509,
	IDC_TEXT_FILE	= 10510,
	IDC_TGRUEN	= 10511,
	IDC_LINKS	= 10512,
	IDC_TILE	= 10513,
	IDC_LI_NOSPECULAR	= 10514,
	IDC_MELT_NOISESCALE	= 10515,
	IDC_VIBRATE_FREQUENCY	= 10516,
	IDC_HIGHLIGHT	= 10517,
	IDC_HPBSYSTEM	= 10518,
	IDC_TROT	= 10519,
	IDC_SNAPGRIDLINES	= 10520,
	IDC_UMGEBUNG	= 10521,
	IDC_SNAPPOINTS	= 10522,
	IDC_VIEW_SHOWPATH	= 10523,
	IDC_TBLAU	= 10524,
	IDC_SNAPEDGES	= 10525,
	IDC_VIEW_SHOWSAFEFRAMES	= 10526,
	IDC_SNAPFACES	= 10527,
	IDC_GENLOCK	= 10528,
	IDC_SNAPSPLINE	= 10529,
	IDC_SNAPSPLINEGRID	= 10530,
	IDC_GLANZFARBE	= 10531,
	IDC_SNAPAXIS	= 10532,
	IDC_FPS	= 10533,
	IDC_GLOW	= 10534,
	IDC_SNAPPLANE	= 10535,
	IDC_MASSEINHEIT	= 10536,
	IDC_DISPLACE	= 10537,
	IDC_SNAPAUTOFOCUS	= 10538,
	IDC_TYP	= 10539,
	IDC_ZEITEINHEIT	= 10540,
	IDC_SNAPFOCUS	= 10541,
	IDC_FARBEINHEIT	= 10542,
	IDC_SNAP3D	= 10543,
	IDC_DXFFAK	= 10544,
	IDC_SNAPENABLE	= 10545,
	IDC_DISPLAY_DISPLAY	= 10546,
	IDC_SNAPTANGENT	= 10547,
	IDC_SRASTERE	= 10548,
	IDC_AUTOREDUZ	= 10549,
	IDC_LWOFAK	= 10550,
	IDC_SNAPPERPENDICULAR	= 10551,
	IDC_RRASTERE	= 10552,
	IDC_TDDFAK	= 10553,
	IDC_MAXLAST	= 10554,
	IDC_SNAPFACECENTER	= 10555,
	IDC_VRASTER	= 10556,
	IDC_DXFLAYER	= 10557,
	IDC_MAXUNDO	= 10558,
	IDC_SNAPMIDPOINT	= 10559,
	IDC_VIEW_DISPLAYINACTIVE	= 10560,
	IDC_SRASTER	= 10561,
	IDC_SKALIERUNG	= 10562,
	IDC_RRASTER	= 10563,
	IDC_DXFEXPORT	= 10564,
	IDC_FUNKTION	= 10565,
	IDC_LRASTERE	= 10566,
	IDC_Q3DFAK	= 10567,
	IDC_LRASTER	= 10568,
	IDC_KREISSEGMENTE	= 10569,
	IDC_GESCHLOSSEN	= 10570,
	IDC_VRASTERE	= 10571,
	IDC_RASTERSEG	= 10572,
	IDC_RAD1	= 10573,
	IDC_TRASTERE	= 10574,
	IDC_TRASTER	= 10575,
	IDC_BEDIT	= 10576,
	IDC_HEDIT	= 10577,
	IDC_SLIDERST	= 10578,
	IDC_RANDOMSTREAKS	= 10579,
	IDC_FADEBEHINDOBJECTS	= 10580,
	IDC_RANDOMLEN	= 10581,
	IDC_FADENEAROBJECTS	= 10582,
	IDC_STERN	= 10583,
	IDC_USELIGHTPARAM	= 10584,
	IDC_SCALEGLOW	= 10585,
	IDC_SCALEREFLEXES	= 10586,
	IDC_STRAHLEN	= 10587,
	IDC_TEXT	= 10588,
	IDC_TEXT3	= 10589,
	IDC_LENSEFFECTS	= 10590,
	IDC_GLOWEFFECTS	= 10591,
	IDC_MAPMEMORY	= 10592,
	IDC_TEXT12	= 10593,
	IDC_Z	= 10594,
	IDC_TEXT14	= 10595,
	IDC_TIME	= 10596,
	IDC_Z2	= 10597,
	IDC_TEXT15	= 10598,
	IDC_Z3	= 10599,
	IDC_RANGEX	= 10600,
	IDC_TEXT16	= 10601,
	IDC_RANGEY	= 10602,
	IDC_TEXT17	= 10603,
	IDC_TEXT13	= 10604,
	IDC_Z4	= 10605,
	IDC_RANGEZ	= 10606,
	IDC_LI_OUTERCONE	= 10607,
	IDC_TEXT20	= 10608,
	IDC_Z5	= 10609,
	IDC_4SIDE_ANGLE	= 10610,
	IDC_TEXT18	= 10611,
	IDC_COGWHEEL_BEVEL	= 10612,
	IDC_TEXT19	= 10613,
	IDC_AMP	= 10614,
	IDC_F1	= 10615,
	IDC_FREQUENZ	= 10616,
	IDC_F2	= 10617,
	IDC_WIND_FX	= 10618,
	IDC_F3	= 10619,
	IDC_WIND_FY	= 10620,
	IDC_SUCHEN	= 10621,
	IDC_SUCHENB	= 10622,
	IDC_SKALSUCHEN	= 10623,
	IDC_PLAY	= 10624,
	IDC_X1	= 10625,
	IDC_Y1	= 10626,
	IDC_Z1	= 10627,
	IDC_VERSION	= 10628,
	IDC_A	= 10629,
	IDC_B	= 10630,
	IDC_COGWHEEL_MRADIUS	= 10631,
	IDC_CIRCLE_INNERRADIUS	= 10632,
	IDC_CYCLOID_A	= 10633,
	IDC_COGWHEEL_IRADIUS	= 10634,
	IDC_ARC_ENDANGLE	= 10635,
	IDC_ANZEIGE	= 10636,
	IDC_SKALANZEIGE	= 10637,
	IDC_PRESET	= 10638,
	IDC_NUMMER	= 10639,
	IDC_NAMEA	= 10640,
	IDC_SUCHENA	= 10641,
	IDC_LINSI	= 10642,
	IDC_ARTEFAKT	= 10643,
	IDC_TEXT1	= 10644,
	IDC_TEXT2	= 10645,
	IDC_TEXT4	= 10646,
	IDC_TEXT5	= 10647,
	IDC_TEXT6	= 10648,
	IDC_DXF2DELEMENTS	= 10649,
	IDC_RENDERMODE_COMBO	= 10650,
	IDC_TEXT7	= 10651,
	IDC_DXFFROZEN	= 10652,
	IDC_XAUF	= 10653,
	IDC_TEXT8	= 10654,
	IDC_DXFAUSRICHTEN	= 10655,
	IDC_YAUF	= 10656,
	IDC_TEXT9	= 10657,
	IDC_SPIEGEL	= 10658,
	IDC_DXFHOCHZUG	= 10659,
	IDC_XAUF2	= 10660,
	IDC_TEXT10	= 10661,
	DELME_IDC_LWAVETEXTUREN	= 10662,
	IDC_YAUF2	= 10663,
	IDC_PICTSIZE	= 10664,
	IDC_TIEFENUNSCHAERFE	= 10665,
	DELME_IDC_LWAVELICHT	= 10666,
	IDC_FILESIZE	= 10667,
	IDC_KNICKKNACK	= 10668,
	DELME_IDC_LWAVENORMALEN	= 10669,
	IDC_FILETYPE	= 10670,
	IDC_RAYOPT_ONLYACTIVE	= 10671,
	IDC_BAR1	= 10672,
	IDC_BAR2	= 10673,
	IDC_BAR3	= 10674,
	IDC_BAR4	= 10675,
	IDC_NUMBER	= 10676,
	IDC_BAR5	= 10677,
	IDC_HELIX_HEIGHT	= 10678,
	IDC_BAR6	= 10679,
	IDC_NUMBER3	= 10680,
	IDC_HELIX_HEIGHTBIAS	= 10681,
	IDC_BAR7	= 10682,
	IDC_NUMBER4	= 10683,
	IDC_VORNE	= 10684,
	IDC_HELIX_RADIALBIAS	= 10685,
	IDC_BAR8	= 10686,
	IDC_NUMBER5	= 10687,
	IDC_MITTE	= 10688,
	IDC_NUMBER6	= 10689,
	IDC_HINTEN	= 10690,
	IDC_R2	= 10691,
	IDC_COGWHEEL_ORADIUS	= 10692,
	IDC_NUMBER7	= 10693,
	IDC_R1	= 10694,
	IDC_WAHL	= 10695,
	IDC_LENSDEL	= 10696,
	IDC_ALIGN	= 10697,
	IDC_LENSADD	= 10698,
	IDC_HEADLINE1	= 10699,
	IDC_HEADLINE2	= 10700,
	IDC_HEADLINE3	= 10701,
	IDC_RAYVR_HSTART	= 10702,
	IDC_RAYVR_HEND	= 10703,
	IDC_RAYVR_VSTART	= 10704,
	IDC_RAYVR_VEND	= 10705,
	IDC_MINH	= 10706,
	IDC_RAYSAVE_VRMODE	= 10707,
	IDC_MAXH	= 10708,
	IDC_DAMP	= 10709,
	IDC_HORIZ	= 10710,
	IDC_LIMITPHONG	= 10711,
	IDC_FORMULA_XMIN	= 10712,
	IDC_MINP	= 10713,
	IDC_VERT	= 10714,
	IDC_PHONG	= 10715,
	IDC_WIDTH	= 10716,
	IDC_FORMULA_XMAX	= 10717,
	IDC_MAXP	= 10718,
	IDC_BIAS	= 10719,
	IDC_HEIGHT	= 10720,
	IDC_FORMULA_SUB	= 10721,
	IDC_USERMAPSIZE	= 10722,
	IDC_CYCLOID_START	= 10723,
	IDC_MINB	= 10724,
	IDC_WIDTHWERT	= 10725,
	IDC_SAMPLING	= 10726,
	IDC_CYCLOID_END	= 10727,
	IDC_MAXB	= 10728,
	IDC_ENDE	= 10729,
	IDC_BUBBLEHELP	= 10730,
	IDC_HEIGHTWERT	= 10731,
	IDC_SHADOWDENSITY	= 10732,
	IDC_DEPTHWERT	= 10733,
	IDC_SHADOWPARSIZE	= 10734,
	IDC_USERMAPSIZEY	= 10735,
	IDC_SHADOWAREASIZE	= 10736,
	IDC_DISPLAY_HIDERAY	= 10737,
	IDC_DISPLAY_HIDEEDITOR	= 10738,
	IDC_DISPLAY_TEXTURES	= 10739,
	IDC_NAMEWERT	= 10740,
	IDC_VIEW_USETAGACTIVE	= 10741,
	IDC_DISPLAY_BACKCULL	= 10742,
	IDC_KOMMWERT	= 10743,
	IDC_SUBEDITOR	= 10744,
	IDC_SUBSHADE	= 10745,
	IDC_VIEW_USETAGINACTIVE	= 10746,
	IDC_SUBRAY	= 10747,
	IDC_VIEW_DISABLETEXTURES	= 10748,
	IDC_SUBWIRE	= 10749,
	IDC_VIEW_DISABLEBACKCULL	= 10750,
	IDC_FILENAME	= 10751,
	IDC_NSEG	= 10752,
	IDC_TVAR	= 10753,
	IDC_MSEG	= 10754,
	IDC_EXP_FXR	= 10755,
	IDC_VSTART	= 10756,
	IDC_VVAR	= 10757,
	IDC_LIFETIME	= 10758,
	IDC_EXP_VXR	= 10759,
	IDC_SVAR	= 10760,
	IDC_EXP_TX	= 10761,
	IDC_ANZAHL_R	= 10762,
	IDC_EXP_VYR	= 10763,
	IDC_ROTATION	= 10764,
	IDC_STRAHLTEILER	= 10765,
	IDC_ROTVAR	= 10766,
	IDC_EXP_VZR	= 10767,
	IDC_EXP_FYR	= 10768,
	IDC_EXP_FZR	= 10769,
	IDC_EXP_RX	= 10770,
	IDC_ABSTRAHLUNG	= 10771,
	IDC_EXP_RY	= 10772,
	IDC_TANGENTIAL	= 10773,
	IDC_EXP_TY	= 10774,
	IDC_EXP_EXPVECT	= 10775,
	IDC_T	= 10776,
	IDC_EXP_RZ	= 10777,
	IDC_EXP_TZ	= 10778,
	IDC_FORMELX	= 10779,
	IDC_SHADER	= 10780,
	IDC_FORMULA_DLT	= 10781,
	IDC_BLUR	= 10782,
	IDC_MIN	= 10783,
	IDC_EXP_MAXR	= 10784,
	IDC_COMPOSITING_CAST	= 10785,
	IDC_ENVIX	= 10786,
	IDC_EXP_MAXRR	= 10787,
	IDC_COMPOSITING_RECEIVE	= 10788,
	IDC_ENVIY	= 10789,
	IDC_DISPLACEHOEHE	= 10790,
	IDC_EXP_DIS	= 10791,
	IDC_COMPOSITING_CAMERA	= 10792,
	IDC_EXP_DISR	= 10793,
	IDC_COMPOSITING_RAYS	= 10794,
	IDC_EXP_DISP	= 10795,
	IDC_COMPOSITING_BACKGROUND	= 10796,
	IDC_EXP_DISPR	= 10797,
	IDC_TEXINFO	= 10798,
	IDC_CLOSEDM	= 10799,
	IDC_CLOSEDN	= 10800,
	IDC_BILDER	= 10801,
	IDC_MOVIES	= 10802,
	IDC_SZENEN	= 10803,
	IDC_MODE	= 10804,
	IDC_WIND_FLAG	= 10805,
	IDC_IGNORE	= 10806,
	IDC_COLOR1	= 10807,
	IDC_RENDERMATS	= 10808,
	IDC_COLOR6	= 10809,
	IDC_OBJECTBLUR	= 10810,
	IDC_NORMALEN	= 10811,
	IDC_LENSTEXT1	= 10812,
	IDC_LIMITRANGE	= 10813,
	IDC_LENSTEXT2	= 10814,
	IDC_SCALESTRENGTH	= 10815,
	IDC_ANZAHL_E	= 10816,
	IDC_LENSTEXT4	= 10817,
	IDC_LENSTEXT5	= 10818,
	IDC_LENSTEXT6	= 10819,
	IDC_EDIT1	= 10820,
	IDC_STREAKTEXT3	= 10821,
	IDC_EDIT2	= 10822,
	IDC_STREAKDICKE	= 10823,
	IDC_EDIT3	= 10824,
	IDC_STREAKTEXT5	= 10825,
	IDC_EDIT4	= 10826,
	IDC_EDIT5	= 10827,
	IDC_STREAKTEXT4	= 10828,
	IDC_LENSTEXT8	= 10829,
	IDC_EDIT6	= 10830,
	IDC_EDIT7	= 10831,
	IDC_STREAKTEXT2	= 10832,
	IDC_LENSTEXT9	= 10833,
	IDC_EDIT8	= 10834,
	IDC_EDIT9	= 10835,
	IDC_LENSTEXT10	= 10836,
	IDC_EDIT10	= 10837,
	IDC_LENSTEXT11	= 10838,
	IDC_GLOWFELD	= 10839,
	IDC_STREAKSIZE	= 10840,
	IDC_STREAKSV	= 10841,
	IDC_HALOSIZE	= 10842,
	IDC_HALOSV	= 10843,
	IDC_GLOWSIZE	= 10844,
	IDC_GLOWTYP	= 10845,
	IDC_GLOWNUM	= 10846,
	IDC_ADDITIV	= 10847,
	IDC_URL	= 10848,
	IDC_T1	= 10849,
	IDC_T2	= 10850,
	IDC_T3	= 10851,
	IDC_T4	= 10852,
	IDC_T5	= 10853,
	IDC_T6	= 10854,
	IDC_T7	= 10855,
	IDC_T8	= 10856,
	IDC_T9	= 10857,
	IDC_SKALART	= 10858,
	IDC_T10	= 10859,
	IDC_SYSART	= 10860,
	IDC_INNEN	= 10861,
	IDC_T11	= 10862,
	IDC_AUSSEN	= 10863,
	IDC_T12	= 10864,
	IDC_BERECHNEN	= 10865,
	IDC_T13	= 10866,
	IDC_LOOP	= 10867,
	IDC_T14	= 10868,
	IDC_TIMING	= 10869,
	IDC_T15	= 10870,
	IDC_TIMINGRANGEBIS	= 10871,
	IDC_RAYSAVE_OPTIONS	= 10872,
	IDC_T16	= 10873,
	IDC_TIMINGRANGEVON	= 10874,
	IDC_INLINETEXTUREN	= 10875,
	IDC_TIMINGFPS	= 10876,
	IDC_ZOOMFAKTOR	= 10877,
	IDC_SEG_KUGEL	= 10878,
	IDC_SEG_KEGEL	= 10879,
	IDC_MAXPIXELSIZE	= 10880,
	IDC_FAKTOR_3DS	= 10881,
	IDC_FAKTOR_WAVE	= 10882,
	IDC_GRUPPEN	= 10883,
	IDC_ANIMATION	= 10884,
	IDC_BACKFACE	= 10885,
	IDC_EINRUECK	= 10886,
	IDC_USEFARBE	= 10887,
	IDC_RELATIV	= 10888,
	IDC_FORMATTEXT	= 10889,
	IDC_TEMPLATES	= 10890,
	IDC_TEXTURES	= 10891,
	IDC_ANPASSEN	= 10892,
	IDC_ENDUNG	= 10893,
	IDC_MESH	= 10894,
	IDC_SEPARAT	= 10895,
	IDC_SEG_NURBS	= 10896,
	IDC_FORMATIEREN	= 10897,
	IDC_VOLUMETRIC	= 10898,
	IDC_NORM	= 10899,
	IDC_ORTHO	= 10900,
	IDC_KONTUR	= 10901,
	IDC_COMPENSATE	= 10902,
	IDC_TABLETT	= 10903,
	IDC_FORM	= 10904,
	IDC_REKURSIV	= 10905,
	IDC_KOMMENTAR	= 10906,
	IDC_TEX0	= 10907,
	IDC_TEX1	= 10908,
	IDC_TEX2	= 10909,
	IDC_COL1	= 10910,
	IDC_TEX3	= 10911,
	IDC_COL2	= 10912,
	IDC_TEX4	= 10913,
	IDC_COL3	= 10914,
	IDC_TEX5	= 10915,
	IDC_FREQ	= 10916,
	IDC_TEX6	= 10917,
	IDC_LAND	= 10918,
	IDC_TEX7	= 10919,
	IDC_GLANZ	= 10920,
	IDC_TEX8	= 10921,
	IDC_FREQT	= 10922,
	IDC_COL4	= 10923,
	IDC_TEX9	= 10924,
	IDC_COL5	= 10925,
	IDC_TEX10	= 10926,
	IDC_FREQX	= 10927,
	IDC_TEX11	= 10928,
	IDC_FREQY	= 10929,
	IDC_REFLEKTION	= 10930,
	IDC_TEX12	= 10931,
	IDC_FREQZ	= 10932,
	IDC_FREQY2	= 10933,
	IDC_TEX13	= 10934,
	IDC_FREQZ2	= 10935,
	IDC_TEX14	= 10936,
	IDC_FREQX2	= 10937,
	IDC_FREQR	= 10938,
	IDC_TURB	= 10939,
	IDC_OKTAVEN	= 10940,
	IDC_WOLKEN	= 10941,
	IDC_WIND	= 10942,
	IDC_FUGE	= 10943,
	IDC_FLANKE	= 10944,
	IDC_RAYOPT_LOGFILE	= 10945,
	IDC_SCENEB	= 10946,
	IDC_RAYOPT_TEXTUREERROR	= 10947,
	IDC_REFL	= 10948,
	IDC_REGISTRY	= 10949,
	IDC_F	= 10953,
	IDC_RAYSAVE_STRAIGHT	= 10955,
	IDC_MIPSATTEXT5	= 10956,
	IDC_B3	= 10957,
	IDC_RAYSAVE_ALPHA	= 10958,
	IDC_NOISE3D	= 10960,
	IDC_EXP_BLASTV	= 10961,
	IDC_LIGHTSHADOW	= 10962,
	IDC_VIEW_GETPATH	= 10963,
	IDC_RAYSAVE_DEPTH	= 10964,
	IDC_INTENSITY1	= 10965,
	IDC_MIPSATTEXT7	= 10966,
	IDC_EXP_BLASTVR	= 10967,
	IDC_VL_USECOL	= 10968,
	IDC_LIGHTVL	= 10969,
	IDC_VIEW_PATH	= 10970,
	IDC_RAYSAVE_SEPARATE	= 10971,
	IDC_INTENSITY2	= 10973,
	IDC_VL_COL1	= 10974,
	IDC_LIGHTVN	= 10975,
	IDC_VIEW_FULLSIZE	= 10976,
	IDC_MIPSATTEXT9	= 10977,
	IDC_INTENSITY3	= 10978,
	IDC_VL_COL2	= 10979,
	IDC_INTENSITY4	= 10981,
	IDC_VIEW_SHOWPICTURE	= 10982,
	IDC_MIPMAPPING	= 10984,
	IDC_EXP_OBJECT	= 10985,
	IDC_MIPOFFSET	= 10986,
	IDC_BAKE_STEPS	= 10987,
	IDC_VL_COLFALLOFF	= 10988,
	IDC_MIPSTRENGTH	= 10990,
	IDC_STORE_STEPS	= 10991,
	IDC_MEMORY	= 10992,
	IDC_LIGHTSHOWLI	= 10993,
	IDC_PHONGLUM	= 10994,
	IDC_POINTS	= 10995,
	IDC_EXP_VX	= 10996,
	IDC_EXP_F	= 10997,
	IDC_POLYGONS	= 10998,
	IDC_LIGHTSHOWCLIP	= 10999,
	IDC_GRADIENT	= 11000,
	IDC_EXP_VY	= 11001,
	IDC_EXP_FR	= 11002,
	IDC_OBJECTS	= 11003,
	IDC_GRADINTERPOL	= 11004,
	IDC_EXP_VZ	= 11005,
	IDC_EXP_T	= 11006,
	IDC_GRADRAMP	= 11007,
	IDC_EXP_FX	= 11008,
	IDC_EXP_TR	= 11009,
	IDC_MSIZE	= 11010,
	IDC_LI_NODIFFUSE	= 11011,
	IDC_PHONGENV	= 11012,
	IDC_GRADPOSITION	= 11013,
	IDC_EXP_FY	= 11014,
	IDC_EXP_R	= 11015,
	IDC_B16	= 11016,
	IDC_LI_INNER	= 11017,
	IDC_PHONGSPE	= 11018,
	IDC_GRADSTRENGTH	= 11019,
	IDC_EXP_FZ	= 11020,
	IDC_EXP_RR	= 11021,
	IDC_LENGTH	= 11022,
	IDC_LI_INNERCOLOR	= 11023,
	IDC_VL_STRENGTH	= 11024,
	IDC_PHONGSHI	= 11025,
	IDC_GRADSCALE	= 11026,
	IDC_EXP_VANG	= 11027,
	IDC_STEREO	= 11028,
	IDC_VOLUME	= 11029,
	IDC_LI_COLOR	= 11030,
	IDC_VL_EDGESTRENGTH	= 11031,
	IDC_EXP_GRAV	= 11032,
	IDC_PHONGTRN	= 11033,
	IDC_GRADABSOLUTE	= 11034,
	IDC_EXP_VANGR	= 11035,
	IDC_EXP_OBJNAME	= 11036,
	IDC_BALANCE	= 11037,
	IDC_LI_AMBIENT	= 11038,
	IDC_PHONGTRA	= 11039,
	IDC_GRADOCTAVES	= 11040,
	IDC_EXP_HEIGHT	= 11041,
	IDC_GETPATH	= 11042,
	IDC_VL_SAMPLES	= 11043,
	IDC_PHONGDIFCOL	= 11044,
	IDC_MAPMINX	= 11045,
	IDC_EXP_ELAS	= 11046,
	IDC_PATHNAME	= 11047,
	IDC_VL_BRIGHTNESS	= 11048,
	IDC_PHONGREF	= 11049,
	IDC_MAPMINY	= 11050,
	IDC_EXP_ELASR	= 11051,
	IDC_B1	= 11052,
	IDC_THRESHOLD	= 11053,
	IDC_PHONGBUM	= 11054,
	IDC_MAPMAXX	= 11055,
	IDC_EXP_TYPE	= 11056,
	IDC_VL_JITTER	= 11057,
	IDC_B2	= 11058,
	IDC_PHONGSPECOL	= 11059,
	IDC_MAPMAXY	= 11060,
	IDC_BS	= 11061,
	IDC_EXP_MAX_ITER2	= 11062,
	IDC_PHONGREFTYPE	= 11063,
	IDC_SOFT	= 11064,
	IDC_EXP_CMIN	= 11065,
	IDC_VL_FARFROM	= 11066,
	IDC_EXP_CMAX	= 11067,
	IDC_CURVE	= 11068,
	IDC_VL_FARTO	= 11069,
	IDC_EXP_TEXT_CMIN	= 11070,
	IDC_SMODE	= 11071,
	IDC_PHONGTRACOL	= 11072,
	IDC_TYPE	= 11073,
	IDC_VL_FAR	= 11074,
	IDC_EXP_TEXT_CMAX	= 11075,
	IDC_SNAPGRID	= 11076,
	IDC_VIEW_DISPLAYACTIVE	= 11077,
	IDC_PHONGADD	= 11078,
	IDC_FILLET	= 11079,
	IDC_WAVENUM	= 11080,
	IDC_VL_NEARTO	= 11081,
	IDC_SNAPSPLINESUBDIV	= 11082,
	IDC_PHONGFIL	= 11083,
	IDC_DEFORM_TEXT	= 11084,
	IDC_VL_NEARFROM	= 11085,
	IDC_VIEW_PROJECTION	= 11086,
	IDC_MIDDLE	= 11087,
	IDC_VL_NEAR	= 11088,
	IDC_EXP_CTYPE	= 11089,
	IDC_DISC_ORAD	= 11090,
	IDC_VL_OUTERDISTZ	= 11092,
	IDC_EXP_V	= 11093,
	IDC_OPENGL	= 11094,
	IDC_DISC_CSUB	= 11095,
	IDC_PHONGEIN	= 11096,
	IDC_VL_OUTERZ	= 11097,
	IDC_EXP_VR	= 11098,
	IDC_RENDER_SAFE	= 11099,
	IDC_LOAD	= 11100,
	IDC_DISC_IRAD	= 11101,
	IDC_PHONGFRE	= 11102,
	IDC_EXP_VOLUME	= 11103,
	IDC_VL_OUTERDISTY	= 11104,
	IDC_ACTION_SAFE	= 11105,
	IDC_SAVE	= 11106,
	IDC_TORUS_OUTERRAD	= 11107,
	IDC_EXP_VLEN	= 11109,
	IDC_VL_OUTERY	= 11110,
	IDC_TITLE_SAFE	= 11111,
	IDC_COMPILE	= 11112,
	IDC_TORUS_INNERRAD	= 11113,
	IDC_PHONGMIP	= 11114,
	IDC_EXP_VLENR	= 11115,
	IDC_VL_OUTER	= 11116,
	IDC_MESSAGE	= 11117,
	IDC_TORUS_SEG	= 11118,
	IDC_PHONGREFCOL	= 11119,
	IDC_EXP_CUTTING	= 11120,
	IDC_VL_INNER	= 11121,
	IDC_LINE	= 11122,
	IDC_EXP	= 11123,
	IDC_TORUS_CSUB	= 11124,
	IDC_EXP_PRECUT	= 11126,
	IDC_VL_FALLOFF	= 11127,
	IDC_TUBE_SEG	= 11128,
	IDC_MELT_RADRANDOM	= 11129,
	IDC_IDIST	= 11130,
	IDC_VIEW_SIZEX	= 11131,
	IDC_PHONGSEP1	= 11132,
	IDC_EXP_COLLISION	= 11133,
	IDC_VL_DUST	= 11134,
	IDC_CUBE_LENX	= 11135,
	IDC_MELT_SIZE	= 11136,
	IDC_ODIST	= 11137,
	IDC_VIEW_RATIO	= 11138,
	IDC_PHONGSEP2	= 11139,
	IDC_EXP_CUTV	= 11140,
	IDC_LI_BRIGHTNESS	= 11141,
	IDC_VL_EDGEFALLOFF	= 11142,
	IDC_CUBE_LENY	= 11143,
	IDC_FORMULA_EFFECT	= 11144,
	IDC_IANGLE	= 11145,
	IDC_PHONGFAL	= 11146,
	IDC_EXP_CUTVR	= 11147,
	IDC_VN_WINDY	= 11148,
	IDC_CUBE_LENZ	= 11149,
	IDC_FORMULA_FX	= 11150,
	IDC_OANGLE	= 11151,
	IDC_EXP_CUT_RAND	= 11152,
	IDC_VN_TYPE	= 11153,
	IDC_CUBE_SUBX	= 11154,
	IDC_FORMULA_FY	= 11155,
	IDC_ICONE	= 11156,
	IDC_PHONGSEA	= 11157,
	IDC_EXP_CUT_LEVEL	= 11158,
	IDC_VN_PREVIEW	= 11159,
	IDC_FORMULA_FZ	= 11160,
	IDC_DFAC	= 11161,
	IDC_EXP_CUTMIN	= 11162,
	IDC_VN_OCTAVES	= 11163,
	IDC_SPHERE_RAD	= 11164,
	IDC_FORMULA_LENX	= 11165,
	IDC_OCONE	= 11166,
	IDC_PHONGDIF	= 11167,
	IDC_EXP_CUTMINR	= 11168,
	IDC_VN_VELOCITY	= 11169,
	IDC_SPHERE_SUB	= 11170,
	IDC_FORMULA_LENY	= 11171,
	IDC_SHOW	= 11172,
	IDC_PHONGDIFEDIT	= 11173,
	IDC_EXP_INSTANT	= 11174,
	IDC_VN_SCALE	= 11175,
	IDC_EXP_CLUSTER	= 11176,
	IDC_SPHERE_TYPE	= 11177,
	IDC_FORMULA_LENZ	= 11178,
	IDC_DOPPLER	= 11179,
	IDC_PHONGTYP	= 11180,
	IDC_VN_AMPLITUDE	= 11181,
	IDC_WRAP_RADIUS	= 11182,
	IDC_BASIS	= 11183,
	IDC_PHONGPRE	= 11184,
	IDC_VN_LOCAL	= 11185,
	IDC_PLATONIC_RAD	= 11186,
	IDC_WRAP_MOVE	= 11187,
	IDC_MAPNAME	= 11188,
	IDC_VN_OFFSET	= 11189,
	IDC_LTTYPE	= 11190,
	IDC_PLATONIC_SUB	= 11191,
	IDC_WRAP_ZSCALE	= 11192,
	IDC_SHATTER_ANGLESPEED	= 11193,
	IDC_MAPEDIT	= 11194,
	IDC_LI_ARTEXT	= 11195,
	IDC_PLATONIC_TYPE	= 11196,
	IDC_WRAP_TENSION	= 11197,
	IDC_SHATTER_SCALE	= 11198,
	IDC_MAPTIMING	= 11199,
	IDC_LI_COLFALLOFF	= 11200,
	IDC_SHATTER_RANDOM	= 11201,
	IDC_MAPCROP	= 11202,
	IDC_LT_MEMORY	= 11203,
	IDC_FIGURE_HEIGHT	= 11204,
	IDC_FFD_XSUB	= 11205,
	IDC_MAPINTER	= 11206,
	IDC_LT_RENDERTIME	= 11207,
	IDC_FIGURE_SUB	= 11208,
	IDC_FFD_YSUB	= 11209,
	IDC_MAPNAMEDIT	= 11210,
	IDC_WIND_AMPLITUDE	= 11211,
	IDC_MAPOUTPUT	= 11212,
	IDC_PYRAMID_LENX	= 11213,
	IDC_WIND_FREQUENCY	= 11214,
	IDC_MAPINFO	= 11215,
	IDC_PYRAMID_LENY	= 11216,
	IDC_WIND_TURBULENCE	= 11217,
	IDC_MAPPREVIEW	= 11218,
	IDC_PYRAMID_LENZ	= 11219,
	IDC_WIND_SIZE	= 11220,
	IDC_VIBRATE_SEED	= 11221,
	IDC_BRICKPREVIEW	= 11222,
	IDC_PYRAMID_SUB	= 11223,
	IDC_ANGLE	= 11224,
	IDC_BRICKCOL1	= 11225,
	IDC_PLANE_SUBH	= 11226,
	IDC_TORUS_AXIS	= 11227,
	IDC_VIEW_SHOWNORMALS	= 11228,
	IDC_BRICKCOL2	= 11229,
	IDC_PYRAMID_AXIS	= 11230,
	IDC_VIEW_OFFX	= 11231,
	IDC_BRICKJOINT	= 11232,
	IDC_DISC_AXIS	= 11233,
	IDC_VIEW_OFFY	= 11234,
	IDC_BRICKBEVEL	= 11235,
	IDC_GRADPREVIEW	= 11236,
	IDC_PLANE_WIDTH	= 11237,
	IDC_RAYVR_HSTEPS	= 11238,
	IDC_NOISECOL1	= 11239,
	IDC_PLANE_HEIGHT	= 11240,
	IDC_RAYVR_VSTEPS	= 11241,
	IDC_NOISECOL2	= 11242,
	IDC_PLANE_SUBW	= 11243,
	IDC_RAYOPT_RAYDEPTH	= 11244,
	IDC_NOISEPREVIEW	= 11245,
	IDC_PLANE_AXIS	= 11246,
	IDC_RAYOPT_EDGECOLOR	= 11247,
	IDC_FRACTAL_BLEVEL	= 11248,
	Format	= 11249,
	IDC_RAYOPT_BACKCOLOR	= 11250,
	IDC_FRACTAL_SCALE	= 11251,
	IDC_TUBE_IRAD	= 11252,
	IDC_NOISETYPE	= 11253,
	IDC_FRACTAL_ROUGH	= 11254,
	IDC_TUBE_ORAD	= 11255,
	IDC_CURVEPREVIEW	= 11256,
	IDC_FRACTAL_FINE	= 11257,
	IDC_TUBE_HEIGHT	= 11258,
	IDC_CURVELOWER	= 11259,
	IDC_CONE_TFILLETY	= 11260,
	IDC_FRACTAL_TLEVEL	= 11261,
	IDC_TUBE_HSUB	= 11262,
	IDC_CIRCLE_RADIUS	= 11263,
	IDC_CURVEUPPER	= 11264,
	IDC_TUBE_CSUB	= 11265,
	IDC_CIRCLE_YRADIUS	= 11266,
	IDC_CURVEBRIGHT	= 11267,
	IDC_CONE_BFILLET	= 11268,
	IDC_TUBE_AXIS	= 11269,
	IDC_ARC_STARTANGLE	= 11270,
	IDC_CURVECONTRAST	= 11271,
	IDC_FRACTAL_MULTIFRACTAL	= 11272,
	IDC_CIRCLE_ELLIPSE	= 11273,
	IDC_CURVEGAMMA	= 11274,
	IDC_FRACTAL_BORDERS	= 11275,
	IDC_CIRCLE_RING	= 11276,
	IDC_FRACTAL_LENX	= 11277,
	IDC_ARC_TYPE	= 11278,
	IDC_FRACTAL_LENY	= 11279,
	IDC_ARC_RADIUS	= 11280,
	IDC_FRACTAL_LENZ	= 11281,
	IDC_ARC_INNERRADIUS	= 11282,
	IDC_CONE_BFILLETY	= 11283,
	IDC_FRACTAL_SUBW	= 11284,
	IDC_FRACTAL_SUBH	= 11285,
	IDC_FRACTAL_AXIS	= 11286,
	IDC_CONE_CSUB	= 11287,
	IDC_FRACTAL_SPHERICAL	= 11288,
	IDC_CONE_SEG	= 11289,
	IDC_CISSOID_WIDTH	= 11290,
	IDC_CONE_BBEVEL	= 11291,
	IDC_CISSOID_TENSION	= 11292,
	IDC_CISSOID_TYPE	= 11293,
	IDC_CONE_TRAD	= 11294,
	IDC_CONE_BRAD	= 11295,
	IDC_CYCLOID_TYPE	= 11296,
	IDC_CONE_HEIGHT	= 11297,
	IDC_CYCLOID_RADIUS	= 11298,
	IDC_CONE_HSUB	= 11299,
	IDC_CYCLOID_R	= 11300,
	IDC_CONE_FSUB	= 11301,
	IDC_CONE_CAPS	= 11302,
	IDC_SPLINE_PLANE	= 11303,
	IDC_CONE_TBEVEL	= 11304,
	IDC_CONE_TFILLET	= 11305,
	IDC_PROFILE_TYPE	= 11306,
	IDC_RECTANGLE_ROUNDING	= 11307,
	IDC_CONE_AXIS	= 11308,
	IDC_PROFILE_A	= 11309,
	IDC_RECTANGLE_RADIUS	= 11310,
	IDC_PROFILE_B	= 11311,
	IDC_CYLINDER_RAD	= 11312,
	IDC_PROFILE_S	= 11313,
	IDC_CYLINDER_HEIGHT	= 11314,
	IDC_PROFILE_T	= 11315,
	IDC_CYLINDER_HSUB	= 11316,
	IDC_CYLINDER_SEG	= 11317,
	IDC_CYLINDER_AXIS	= 11318,
	IDC_NSIDE_RADIUS	= 11319,
	IDC_CYLINDER_CAPS	= 11320,
	IDC_NSIDE_ROUNDING	= 11321,
	IDC_CYLINDER_CSUB	= 11322,
	IDC_NSIDE_ROUNDRADIUS	= 11323,
	IDC_CYLINDER_BEVEL	= 11324,
	IDC_CYLINDER_FSUB	= 11325,
	IDC_4SIDE_TYPE	= 11326,
	IDC_CYLINDER_FILLET	= 11327,
	IDC_4SIDE_A	= 11328,
	IDC_4SIDE_B	= 11329,
	IDC_OILTANK_RAD	= 11330,
	IDC_FORMULA_X	= 11331,
	IDC_OILTANK_HEIGHT	= 11332,
	IDC_RECTANGLE_WIDTH	= 11333,
	IDC_OILTANK_HSUB	= 11334,
	IDC_RECTANGLE_HEIGHT	= 11335,
	IDC_OILTANK_SEG	= 11336,
	IDC_OILTANK_AXIS	= 11337,
	IDC_COGWHEEL_TEETH	= 11338,
	IDC_OILTANK_FSUB	= 11339,
	IDC_STAR_IRADIUS	= 11340,
	IDC_OILTANK_FILLETY	= 11341,
	IDC_STAR_ORADIUS	= 11342,
	IDC_CAPSULE_AXIS	= 11343,
	IDC_STAR_TWIST	= 11344,
	IDC_CAPSULE_SEG	= 11345,
	IDC_STAR_POINTS	= 11346,
	IDC_CAPSULE_FSUB	= 11347,
	IDC_CAPSULE_HSUB	= 11348,
	IDC_TEXT_ALIGN	= 11349,
	IDC_CAPSULE_HEIGHT	= 11350,
	IDC_TEXT_HSPACING	= 11351,
	IDC_CAPSULE_RAD	= 11352,
	IDC_TEXT_EDIT	= 11353,
	IDC_TEXT_VSPACING	= 11354,
	IDC_SLICE_ENABLE	= 11355,
	IDC_FORMULA_CUBIC	= 11356,
	IDC_SLICE_FROM	= 11357,
	IDC_SLICE_TO	= 11358,
	IDC_TEXT_HEIGHT	= 11359,
	IDC_POLYSELECT_ACTION	= 11360,
	IDC_SPLINE_REVERSE	= 11361,
	IDC_RELIEF_AXIS	= 11362,
	IDC_SPLINE_INTERPOLATION	= 11363,
	IDC_RELIEF_SPHERICAL	= 11364,
	IDC_SPLINE_NUMBER	= 11365,
	IDC_RELIEF_TLEVEL	= 11366,
	IDC_SPLINE_ANGLE	= 11367,
	IDC_RELIEF_BLEVEL	= 11368,
	IDC_MAC_FONTSELECT	= 11369,
	IDC_RELIEF_LENZ	= 11370,
	IDC_SELPNT_1	= 11371,
	IDC_RELIEF_SUBH	= 11372,
	IDC_SELPNT_2	= 11373,
	IDC_RELIEF_LENY	= 11374,
	IDC_SELPNT_3	= 11375,
	IDC_RELIEF_LENX	= 11376,
	IDC_SELPNT_4	= 11377,
	IDC_RELIEF_SUBW	= 11378,
	IDC_SELPOLY_1	= 11379,
	IDC_SELPOLY_2	= 11380,
	IDC_RELIEF_PREV	= 11381,
	IDC_SELPOLY_3	= 11382,
	IDC_RELIEF_FILER	= 11383,
	IDC_SELPOLY_4	= 11384,
	IDC_POLY_SUB	= 11385,
	IDC_SELPOLY_5	= 11386,
	IDC_POLY_HEIGHT	= 11387,
	IDC_SELPNT_5	= 11388,
	IDC_SELPOLY_6	= 11389,
	IDC_POLY_WIDTH	= 11390,
	IDC_SELPNT_6	= 11391,
	IDC_SELPOLY_7	= 11392,
	IDC_POINTSELECT_ACTION	= 11393,
	IDC_SELPNT_7	= 11394,
	IDC_CHAMFER_FLAT	= 11395,
	IDC_SELSPLINE_4	= 11396,
	IDC_POLY_AXIS	= 11397,
	IDC_SELPNT_8	= 11398,
	IDC_CONTOUR_TOLERANCE	= 11399,
	IDC_SELSPLINE_5	= 11400,
	IDC_POLY_TRIANG	= 11401,
	IDC_SELPNT_9	= 11402,
	IDC_CONTOUR_PREV	= 11403,
	IDC_CONTOUR_FILER	= 11404,
	IDC_CONTOUR_WIDTH	= 11405,
	IDC_TOLERANCE	= 11406,
	IDC_SELSPLINE_1	= 11407,
	IDC_SELSPLINE_2	= 11408,
	IDC_SELSPLINE_3	= 11409,
	IDC_SELSPLINE_6	= 11410,
	IDC_SELSPLINE_7	= 11411,
	IDC_SELSPLINE_8	= 11412,
	IDS_FS_BILDER	= 11413,
	IDS_FS_LOAD3D	= 11414,
	IDS_FS_MOVIES = 11415,
	IDC_AUSWAHL	= 11417,
	IDS_FS_ALLES	= 11418,
	IDC_DICHTE	= 11422,
	IDC_FALLOFF	= 11423,
	IDC_UNRUHE	= 11424,
	IDS_CHOOSEOBJECTS	= 11425,
	IDS_LIGHT	= 11426,
	IDS_TEXT	= 11427,
	IDS_CHOOSEOBJECT	= 11428,
	IDS_TAKETHREE	= 11429,
	IDS_TAKETWO	= 11430,
	IDS_NOARC	= 11431,
	IDS_UPPERBODY	= 11432,
	IDS_NECK	= 11433,
	IDS_UPPERARM	= 11434,
	IDS_LOWERARM	= 11435,
	IDS_UPPERKNEE	= 11436,
	IDS_LOWERKNEE	= 11437,
	IDS_HAND	= 11438,
	IDS_FOOT	= 11439,
	IDS_HEAD	= 11440,
	IDS_JOINT	= 11441,
	IDS_QAXIS	= 11442,
	IDS_QPLAIN	= 11443,
	IDS_QCONE	= 11444,
	IDS_QRING	= 11445,
	IDS_QDISK	= 11446,
	IDS_QCUBE	= 11447,
	IDS_QCYLINDER	= 11448,
	IDS_QSPHERE	= 11449,
	IDS_QFRAKTAL	= 11450,
	IDS_QRELIEF	= 11451,
	IDS_QPYRAMIDE	= 11452,
	IDS_QTETRAEDER	= 11453,
	IDS_VERTEXOBJECT	= 11460,
	IDS_SPHEREOBJECT	= 11461,
	IDS_GROUNDOBJECT	= 11462,
	IDS_SKYOBJECT	= 11463,
	IDS_POLYOBJECT	= 11464,
	IDS_CHOOSEPOLY	= 11465,
	IDS_VERTEX1	= 11466,
	IDS_VERTEX2	= 11467,
	IDS_VERTEX3	= 11468,
	IDS_VERTEX4	= 11469,
	IDS_VERTEX5	= 11470,
	IDS_VERTEX6	= 11471,
	IDS_UUKEGEL	= 11472,
	IDS_ROUND	= 11473,
	IDS_ROUND1	= 11474,
	IDS_ROUND2	= 11475,
	IDS_LID	= 11476,
	IDS_LID1	= 11477,
	IDS_LID2	= 11478,
	R_POLYGON	= 11479,
	IDC_CENTER	= 11480,
	IDC_BACKUP	= 11481,
	IDS_NOTHING	= 11482,
	IDS_BYTES	= 11483,
	IDS_YES	= 11484,
	IDS_NO	= 11485,
	IDC_SHADOW_RAD	= 11486,
	IDC_SHADOW_RAD2	= 11487,
	IDS_OVERWRITEFRAMES_Q = 11488,
	IDS_TEXLACK	= 11489,
	IDS_CHOOSEGROUP	= 11490,
	IDS_NEU	= 11491,
	IDS_OHNETITEL	= 11492,
	IDS_SONNE	= 11493,
	IDS_B	= 11494,
	IDS_TYPEFAIL1	= 11495,
	IDS_TYPEFAIL2	= 11496,
	IDS_TYPEFAIL3	= 11497,
	IDS_TYPEFAIL4	= 11498,
	IDS_TYPEFAIL5	= 11499,
	IDS_TYPEFAIL6	= 11500,
	IDS_TYPEFAIL7	= 11501,
	IDS_TYPEFAIL8	= 11502,
	IDS_TYPEFAIL9	= 11503,
	IDS_TYPEFAIL10	= 11504,
	IDS_INITIALISIERE	= 11505,
	IDS_SPEICHEREBILD	= 11506,
	IDS_APPLYINGFILTER	= 11507,
	IDS_TIEFENUNSCHAERFE	= 11508,
	IDS_RAY	= 11509,
	IDS_QBODEN	= 11510,
	IDS_QHIMMEL	= 11511,
	IDS_QKAMERA	= 11512,
	IDS_SEK	= 11513,
	IDS_UMGEBUNG	= 11514,
	IDS_WELTVOREIN	= 11515,
	IDS_MMATERIAL	= 11516,
	IDS_CHOOSEMAT	= 11517,
	IDS_FR	= 11518,
	IDS_FG	= 11519,
	IDS_FB	= 11520,
	IDS_FH	= 11521,
	IDS_FS	= 11522,
	IDS_FV	= 11523,
	IDS_QUMGEBUNG	= 11524,
	IDS_RAYREQ	= 11525,
	IDS_AUSGABE	= 11526,
	IDS_SAUS	= 11527,
	IDS_SSKAL	= 11528,
	IDS_SROT	= 11529,
	IDS_SPATH	= 11530,
	IDS_SKAM	= 11531,
	IDS_SUMGEB	= 11532,
	IDS_SKINEMATIK	= 11533,
	IDS_SMORPH	= 11534,
	IDS_SWIND	= 11535,
	IDS_ANIM_PULSATE	= 11536,
	IDS_ANIM_VIBRATE	= 11537,
	IDS_STEXTUR0	= 11538,
	IDS_SPOS	= 11539,
	IDS_CHOOSESPUR	= 11540,
	IDS_CHOOSESEQ	= 11541,
	IDS_CHOOSEKEY	= 11542,
	IDS_CHOOSEKEYSEQ	= 11543,
	IDS_CHOOSESEQSPUR	= 11544,
	IDS_UEBERSCHNEIDUNG	= 11545,
	IDS_CHOOSESPURSEQKEY	= 11546,
	IDS_PUNKTNUMMER	= 11547,
	IDS_VIERECKNUMMER	= 11548,
	IDS_NOFIT	= 11549,
	IDS_PHONGFORUNDER	= 11550,
	IDS_VERSIONSORRY	= 11551,
	IDS_POLYFAIL	= 11552,
	IDS_OBJECTFAIL	= 11553,
	IDS_SAMPLEFLARES	= 11554,
	IDS_SELEKTMAT	= 11555,
	DELME_IDS_LWAVENAME	= 11556,
	IDS_SCHLIESSEN	= 11557,
	IDS_MAXDOK	= 11558,
	IDS_DXFHEADER2	= 11559,
	IDS_SSCHMELZ	= 11560,
	IDS_FRAMETEXT	= 11561,
	IDS_PAKTION	= 11562,
	IDS_PTEXTUR	= 11563,
	IDS_POBJEKT	= 11564,
	IDS_SCHLAUCHOBJECT	= 11565,
	IDS_QHELIX	= 11566,
	IDS_PEDIT	= 11567,
	IDS_PANSICHT	= 11568,
	IDS_PTOOL	= 11569,
	IDS_SOBJLAYERANZ	= 11570,
	IDS_SOBJLAYER	= 11571,
	IDS_OM_TEX	= 11572,
	IDS_OM_PHONG	= 11573,
	IDS_OM_DARST	= 11574,
	IDS_QELLIPSE	= 11575,
	IDS_QQUADRAT	= 11576,
	IDS_QRECHTECK	= 11577,
	IDS_QGDREIECK	= 11578,
	IDS_PRIMITIVE_PROFILE	= 11579,
	IDS_QTRAPEZ	= 11580,
	IDS_QRAUTE	= 11581,
	IDS_QKREISAUSSCHNITT	= 11582,
	IDS_QZAHNRAD	= 11583,
	IDS_QPARALLELOGRAMM	= 11584,
	IDS_QKREISRING	= 11585,
	IDS_QKREISSCHICHT	= 11586,
	IDS_QKREISABSCHNITT	= 11587,
	IDS_QDRACHEN	= 11588,
	IDS_UMGOBJEKT	= 11589,
	IDS_SAUSSI	= 11590,
	IDS_ANIM_TARGET	= 11591,
	IDS_FEXISTS	= 11592,
	IDS_HL1	= 11593,
	IDS_HL2	= 11594,
	IDS_HL3	= 11595,
	IDS_HL4	= 11596,
	IDS_HL5	= 11597,
	IDS_HL6	= 11598,
	IDS_HL7	= 11599,
	IDS_HL8	= 11600,
	IDS_HL9	= 11601,
	IDS_HL10	= 11602,
	IDS_HL11	= 11603,
	IDS_BEENDEN	= 11604,
	IDS_ADOBEPFAD	= 11605,
	IDS_ADOBEGRUPPE	= 11606,
	IDS_ADOBELAYER	= 11607,
	IDS_ALREADYOPEN	= 11608,
	DELME_IDS_LWAVENULL	= 11609,
	DELME_IDS_LWAVEBONE	= 11610,
	DELME_IDS_LWAVESUBST	= 11611,
	IDS_LINE	= 11612,
	IDS_OMANGROUP	= 11613,
	IDS_PROGBILD	= 11614,
	IDS_PROGZEIT	= 11615,
	IDS_MNAME	= 11616,
	IDS_CALCSMAP	= 11617,
	IDS_TRACERWORKS	= 11618,
	IDS_NOPATH	= 11619,
	IDS_NOPATHTIT	= 11620,
	IDS_PROGVER	= 11621,
	IDS_DEMOVER	= 11622,
	IDS_LAUF0	= 11623,
	IDS_LAUF1	= 11624,
	IDS_LAUF2	= 11625,
	IDS_LAUF3	= 11626,
	IDS_LAUF4	= 11627,
	IDS_LAUF5	= 11628,
	IDS_LAUF6	= 11629,
	IDS_LAUF7	= 11630,
	IDS_LAUF8	= 11631,
	IDS_LAUF9	= 11632,
	IDS_LAUF10	= 11633,
	IDS_SEKUNDEN	= 11634,
	IDS_BILDER	= 11635,
	IDS_CHECKOUTSUB	= 11636,
	IDS_HANDBUCH	= 11637,
	IDS_WO_ZUM_HENKER	= 11638,
	IDS_HIERHERPC	= 11639,
	IDS_HIERHERMAC	= 11640,
	IDS_CHOOSEDRAWER	= 11641,
	IDS_CHOOSEFILE	= 11642,
	IDS_SAVEFILE	= 11643,
	IDS_TAPER	= 11644,
	IDS_TWIST	= 11645,
	IDS_BEND	= 11646,
	IDS_OM_KINEMATIK	= 11647,
	IDS_OM_WURZEL	= 11648,
	IDS_CHUNKSIZE	= 11649,
	IDS_AXISOBJECT	= 11650,
	IDS_LOFTOBJECT	= 11651,
	IDS_FFDOBJECT	= 11652,
	IDS_PARTICLEOBJECT	= 11653,
	IDS_QQUADER	= 11654,
	IDS_DEFLEKTOROBJECT	= 11655,
	IDS_GRAVITATIONOBJECT	= 11656,
	IDS_ROTATIONOBJECT	= 11657,
	IDS_WINDOBJECT	= 11658,
	IDS_OM_SCHUTZ	= 11659,
	IDS_REIBUNGOBJECT	= 11660,
	IDS_TURBULENZOBJECT	= 11661,
	IDS_EXTRUDEOBJECT	= 11662,
	IDS_ROTATEOBJECT	= 11663,
	IDS_SWEEPOBJECT	= 11664,
	IDS_BONEOBJECT	= 11665,
	IDS_OM_BFIX	= 11666,
	IDS_ZISSOIDE	= 11667,
	IDS_STROPHOIDE	= 11668,
	IDS_KARDIKOIDE	= 11669,
	IDS_LEMNISKATE	= 11670,
	IDS_ZYKLOIDE	= 11671,
	IDS_EPIZYKLOIDE	= 11672,
	IDS_HYPOZYKLOIDE	= 11673,
	IDS_ASTROIDE	= 11674,
	IDS_PRIMITIVE_HELIX	= 11675,
	IDS_FORMEL	= 11676,
	IDS_IKOSAEDER	= 11677,
	IDS_DODEKAEDER	= 11678,
	IDS_OKTAEDER	= 11679,
	IDS_READBYWRITE	= 11680,
	IDS_WRITEBYREAD	= 11681,
	IDS_SFORMEL	= 11682,
	IDS_ATTRAKTOROBJECT	= 11683,
	IDS_QPOLY	= 11684,
	IDS_OM_MOTIONBLUR	= 11685,
	IDS_OM_COMPOSITING	= 11686,
	IDS_MDISPLACE	= 11687,
	IDS_MGLOW	= 11688,
	IDS_QHEXAEDER	= 11689,
	IDS_OM_UVW	= 11690,
	IDS_BEZIEROBJECT	= 11691,
	IDS_VORNEOBJECT	= 11692,
	IDS_HINTEROBJECT	= 11693,
	IDS_BBILD	= 11694,
	IDS_BMOVIE	= 11695,
	IDS_BSZENE	= 11696,
	IDS_PICCOPY	= 11697,
	IDS_RAY_SAVE	= 11698,
	IDS_REALLYREVERT	= 11699,
	IDS_NOREVERT	= 11700,
	IDS_SELECTSEQ	= 11701,
	IDS_SELECTSEQ2	= 11702,
	IDS_LENSTEXT1	= 11703,
	IDS_LENSTEXT2	= 11704,
	IDS_LENSTYP0	= 11705,
	IDS_LENSTYP1	= 11706,
	IDS_LENSTYP2	= 11707,
	IDS_LENSTYP3	= 11708,
	IDS_LENSTYP4	= 11709,
	IDS_LENSTYP5	= 11710,
	IDS_LENSTYP6	= 11711,
	IDS_LENSTYP7	= 11712,
	IDS_LENSTYP8	= 11713,
	IDS_LENSTYP9	= 11714,
	IDS_LENSTYP10	= 11715,
	IDS_LENSTYP11	= 11716,
	IDS_LENSTYP12	= 11717,
	IDS_STREAKTEXT2	= 11718,
	IDS_STREAKTEXT3	= 11719,
	IDS_STREAKTEXT4	= 11720,
	IDS_STREAKTEXT5	= 11721,
	IDS_LENSTYP13	= 11722,
	IDS_OM_WWW	= 11723,
	IDS_BMATERIAL	= 11724,
	IDS_OM_ACTIVE	= 11725,
	IDS_NOSHADER2D	= 11726,
	IDS_NOSHADER3D	= 11727,
	IDS_NOHOOK	= 11728,
	IDS_ERASEOBJECT	= 11729,
	IDS_VRML_INLINETEXTURE1	= 11730,
	IDS_VRML_INLINETEXTURE2	= 11731,
	IDS_BLANK1	= 11732,
	IDS_BLANK2	= 11733,
	IDS_FILESTRUCT	= 11734,
	IDS_FILENOTFOUND	= 11735,
	IDS_DOUBLENAME	= 11736,
	IDS_PROG_LOAD	= 11737,
	IDS_PROG_SAVE	= 11738,
	IDS_PROG_RENDERMATS	= 11739,
	IDS_PROG_COUNTING	= 11740,
	IDS_PROG_RENDERDIAS	= 11741,
	IDS_INSTANCEOBJECT	= 11742,
	IDS_ENURBSOBJECT	= 11743,
	IDS_OM_BAKEP	= 11744,
	IDS_SPLA	= 11745,
	IDS_BENDOBJECT	= 11746,
	IDS_BULGEOBJECT	= 11747,
	IDS_MAGOBJECT	= 11748,
	IDS_SHEAROBJECT	= 11749,
	IDS_SDEFORMOBJECT	= 11750,
	IDS_TAPEROBJECT	= 11751,
	IDS_TWISTOBJECT	= 11752,
	IDS_WAVEOBJECT	= 11753,
	IDS_EXPADVANCED	= 11754,
	IDS_PROG_BAKEPARTICLES	= 11755,
	IDS_SFOLDER	= 11756,
	IDS_ANI_TIME	= 11757,
	IDS_ANI_SELECTION	= 11758,
	IDS_ANI_LOOP	= 11759,
	IDS_ANI_MARKER	= 11760,
	IDS_SSOUND	= 11761,
	IDS_ANIMATING	= 11762,
	IDS_LOADINGTEX	= 11763,
	IDS_SHADOWMEM	= 11769,
	IDS_BLOBOBJECT	= 11882,
	IDS_STAGEOBJECT	= 11884,
	IDS_QINSTANCE	= 11903,
	IDS_FAIL1	= 11905,
	IDS_FAIL2	= 11906,
	IDS_FAIL3	= 11907,
	IDS_FAIL4	= 11908,
	IDS_FAIL5	= 11909,
	IDS_FAIL6	= 11910,
	IDS_FAIL7	= 11911,
	IDS_FAIL8	= 11912,
	IDS_FAIL9	= 11913,
	IDS_FAILM	= 11914,
	IDS_KEYNUMBER	= 11915,
	IDS_OBJNAME	= 11916,
	IDS_PARSING	= 11917,
	IDS_DEFRDATA	= 11918,
	IDS_QMICROPHONE	= 11919,
	IDS_QLOUDSPEAKER	= 11920,
	IDS_M_2	= 11921,
	IDS_M_5	= 11922,
	IDS_QNULL	= 11923,
	IDS_TL_19	= 11924,
	IDS_QBUCKYBALL	= 11925,
	IDS_QTUBE	= 11926,
	IDS_HANDEFFECTOR	= 11927,
	IDS_FOOTEFFECTOR	= 11928,
	IDS_FIGURELEFT	= 11929,
	IDS_FIGURERIGHT	= 11930,
	IDS_HEADEFFECTOR	= 11931,
	IDS_PRIMITIVE_PLATONIC	= 11932,
	IDS_PRIMITIVE_LANDSCAPE	= 11933,
	IDS_PRIMITIVE	= 11934,
	IDS_PRIMITIVE_CAPSULE	= 11935,
	IDS_PRIMITIVE_OILTANK	= 11936,
	IDS_PRIMITIVE_SLICE	= 11937,
	IDS_PRIMITIVE_POLYGON	= 11938,
	IDS_SYMMETRYOBJECT	= 11939,
	IDS_POSSJOINLOSS	= 11940,
	IDS_EXPLOSION	= 11941,
	IDS_QBOOLE	= 11942,
	IDS_WRAPOBJECT	= 11943,
	IDS_CURVEOBJECT	= 11944,
	IDS_EXPLOSIONOBJECT	= 11945,
	IDS_FORMULAOBJECT	= 11946,
	IDS_MELTOBJECT	= 11947,
	IDS_SHATTEROBJECT	= 11948,
	IDS_WINDDEFORMOBJECT	= 11949,
	IDS_RECENT	= 11950,
	IDS_RENDERSOUND_1	= 11951,
	IDS_RENDERSOUND_2	= 11952,
	IDS_QHEADPHONE	= 11953,
	IDS_FILEERROR_OPEN1	= 11968,
	IDS_FILEERROR_OPEN2	= 11969,
	IDS_FILEERROR_CLOSE	= 11970,
	IDS_FILEERROR_READ	= 11971,
	IDS_FILEERROR_WRITE	= 11972,
	IDS_FILEERROR_SEEK	= 11973,
	IDS_FILEERROR_INVALID	= 11974,
	IDS_THEFRAMERATE	= 11975,
	IDS_QTMOVIE_SMALL	= 11976,
	IDS_QTMOVIE_BIG	= 11977,
	IDS_QTMOVIE_USER	= 11978,
	IDS_QTMOVIE_OBJECT	= 11979,
	IDS_QTMOVIE_PANORAMA	= 11980,
	IDS_AVIMOVIE_SMALL	= 11981,
	IDS_AVIMOVIE_BIG	= 11982,
	IDS_AVIMOVIE_USER	= 11983,
	IDS_LOADTEXTURE	= 11984,
	IDS_PARAMETER	= 11985,
	IDS_PRIMITIVE_ARC	= 11986,
	IDS_TEXTCONTENT	= 11987,
	IDS_PRIMITIVE_4SIDE	= 11988,
	IDS_POLYSELECTION	= 11989,
	IDS_M_6	= 11990,
	IDS_M_7	= 11991,
	IDS_POINTSELECTION	= 11992,
	IDS_PRIMITIVE_CONTOUR	= 11993,
	IDC_STREAKROT	= 11994,
	IDC_STREAKHOLEWIDTH	= 11995,
	IDC_STREAKHOLEANZ	= 11996,
	R_TT_BRICK	= 11997,
	R_TT_PHONG	= 11998,
	IDM_U_STOP	= 12002,
	R_TT_GRADIENT	= 12005,
	R_TTMANAGER	= 12006,
	R_TT_NOISE	= 12007,
	R_TT_MIX	= 12008,
	R_TT_GRADOP	= 12009,
	R_TT_CURVE	= 12010,
	R_TT_BITMAP	= 12011,
	R_LIGHTSHADOW	= 12012,
	R_LICHTQUELLE2	= 12013,
	R_EXPLODE1	= 12014,
	DELME_R_DOC_PREFS	= 12017,
	R_BAKEPARTICLES	= 12018,
	R_VOREDITORALLGEMEIN1_3	= 12021,
	R_SR_PREF_2D	= 12024,
	R_LIGHTNOISE	= 12027,
	R_LICHTQUELLE4	= 12028,
	R_LICHTQUELLE3	= 12029,
	R_STAGE	= 12030,
	R_INSTANCE	= 12031,
	R_METABALL	= 12032,
	R_EXPRESSION	= 12033,
	R_SNAP	= 12035,
	R_LOUDSPEAKER	= 12052,
	R_MICROPHONE	= 12053,
	R_HEADPHONE	= 12054,
	R_VIEW_WINDOW	= 12055,
	R_ATANEDIT	= 12056,
	R_SPLINE_CIRCLE	= 12057,
	R_SPLINE_ARC	= 12058,
	R_POLYSELECT	= 12059,
	R_ATIMEEDITEX	= 12060,
	R_MAC_FONTSELECT	= 12061,
	R_POINTSELECT = 12062,
	IDS_SAVEPROJECT_COPYERROR = 12063,
	IDC_POS_X  = 12800,
	IDC_POS_Y  = 12801,
	IDC_POS_Z  = 12802,
	IDC_SIZE_X = 12803,
	IDC_SIZE_Y = 12804,
	IDC_SIZE_Z = 12805,
	IDS_COORDINATE_MANAGER_X_STR = 12806,
	IDS_COORDINATE_MANAGER_Y_STR = 12807,
	IDS_COORDINATE_MANAGER_Z_STR = 12808,
	IDS_COORDINATE_MANAGER_U_STR = 12809,
	IDS_COORDINATE_MANAGER_V_STR = 12810,
	IDS_COORDINATE_MANAGER_W_STR = 12811,
	IDS_COORDINATE_MANAGER_H_STR = 12812,
	IDS_COORDINATE_MANAGER_P_STR = 12813,
	IDS_COORDINATE_MANAGER_B_STR = 12814,
	IDS_COORDINATE_MANAGER_ANGLE_STR = 12815,
	R_UVPEDIT	= 12816,
	IDC_U	= 12817,
	IDC_V	= 12818,
	IDC_W	= 12819,
	IDC_UV_MAGNET_GROUP = 12820,
	IDC_SELECT_RADIUS_TEXT = 12821,
	R_UV_VIEWPORT	= 1041024,

	M_PHGRAPHVIEW = 1034006,
	M_LAYERMANAGER = 1050987,

	IDC_GIZMO_HIDE = 12822,

	IDC_GIZMO_SOFTSELECT = 12824,
	IDC_GIZMO_X4 = 12825,
	IDC_GIZMO_X5 = 12826,
	IDC_GIZMO_KEEPFACENEIGHBORS = 12827,

	IDS_OUTDATED_GPU_DRIVER_WARNING_TITLE										= 12828,
	IDS_OUTDATED_GPU_DRIVER_WARNING_AMD											= 12829,
	IDS_OUTDATED_GPU_DRIVER_WARNING_OTHER 									= 12830,
	IDS_OUTDATED_GPU_DRIVER_WARNING_CURRENT_VERSION 				= 12831,
	IDS_OUTDATED_GPU_DRIVER_WARNING_MINIMAL_VERSION 				= 12832,
	IDS_OUTDATED_GPU_DRIVER_WARNING_AMD_URL									= 12833,
	IDS_OUTDATED_GPU_DRIVER_WARNING_AMD_URL_INFO						= 12834,
	IDS_OUTDATED_GPU_DRIVER_WARNING_REMIND_ME_NEXT_STARTUP	= 12835,
	IDS_OUTDATED_GPU_DRIVER_WARNING_REMIND_ME_IN_2_WEEKS		= 12836,
	IDS_OUTDATED_GPU_DRIVER_WARNING_REMIND_NEVER						= 12837,
	IDS_OUTDATED_GPU_DRIVER_WARNING_NVIDIA_URL							= 12838,
	IDS_OUTDATED_GPU_DRIVER_WARNING_NVIDIA_URL_INFO					= 12839,
	IDS_OUTDATED_GPU_DRIVER_WARNING_INTEL_URL								= 12840,
	IDS_OUTDATED_GPU_DRIVER_WARNING_INTEL_URL_INFO					= 12841,

	IDC_UV_SOFTSELECTION_UVISLAND_ONLY = 12842,
	R_CREATEMARKER = 12843,

	IDS_UPDATE = 12844,
	IDS_GERMAN = 12845,
	IDS_SPANISH = 12846,
	IDS_FRENCH = 12847,
	IDS_ITALIAN = 12848,
	IDS_RUSSIAN = 12849,
	IDS_POLISH = 12850,
	IDS_CZECH = 12851,
	IDS_ARABIC = 12852,
	IDS_JAPANESE = 12853,
	IDS_CHINESE = 12854,
	IDS_KOREAN = 12855,

	CMD_SNAP_CAMERA_TO_ORTHO = 12856,
	CMD_SNAP_CAMERA_TO_ORTHO_HELP = 12857
};

// Please do NOT remove any deprecated symbol but mark as unused instead.
enum
{
	R_SPLINE_CONTOUR	= 12065,
	R_FREEHANDTOLERANCE	= 12066,
	R_SELECT_SPLINE	= 12067,
	IDM_CENTRAL	= 12077,
	IDM_PARALLEL	= 12078,
	IDM_LEFT	= 12079,
	IDM_RIGHT	= 12080,
	IDM_FRONT	= 12081,
	IDM_BACK	= 12082,
	IDM_TOP	= 12083,
	IDM_BOTTOM	= 12084,
	IDM_MILITARY	= 12085,
	IDM_FROG	= 12086,
	IDM_BIRD	= 12087,
	IDM_GENTLEMAN	= 12088,
	IDM_ISOMETRIC	= 12089,
	IDM_DIMETRIC	= 12090,
	IDM_A_GOURAUD	= 12091,
	IDM_A_QUICK	= 12092,
	IDM_A_WIRE	= 12093,
	IDM_NEU	= 12094,
	IDM_OEFFNE	= 12095,
	IDM_HINZULADEN	= 12096,
	IDM_CM_CLOSEWINDOW = 12097,
	IDM_SPEICHERN	= 12098,
	IDM_RAYTRACING	= 12099,
	// Depreciated, do not reuse these IDs
	// IDM_ANSICHT	= 12100,
	// IDM_OBJEKTE	= 12101,
	IDM_ACHSEN	= 12102,
	IDM_UEBER	= 12103,
	IDM_BEENDEN	= 12104,
	IDM_UNDO	= 12105,
	IDM_CUT = 12106,
	IDM_COPY	= 12107,
	IDM_PASTE	= 12108,
	IDM_DELETE	= 12109,
	IDM_SELECTALL	= 12112,
	IDM_SELECTNONE	= 12113,
	DELME_IDM_GROUP	= 12114,
	IDM_UNTERTEILEN	= 12126,
	IDM_OBJEKTACHSENUEBERNEHMEN	= 12130,
	IDM_WELTACHSENUEBERNEHMEN	= 12131,
	IDM_TEXTURAUFOBJEKTANPASSEN	= 12132,
	IDM_TEXTURORTHOGONAL	= 12133,
	IDM_HORIZONTALSPIEGELN	= 12134,
	IDM_VERTIKALSPIEGELN	= 12135,
	IDM_EINEBNEN	= 12136,
	IDM_ABTRENNEN	= 12137,
	// Depreciated, do not reuse these IDs
	// IDM_PUNKTE	= 12139,
	IDM_SPLINE_REVERSE	= 12141,
	IDM_SPLINE_REORDER	= 12142,
	IDM_OPTIMIEREN	= 12143,
	IDM_VERBINDEN	= 12144,
	IDM_TRIANGULIEREN	= 12145,
	IDM_AUSRICHTEN	= 12146,
	IDM_NEUZEICHNEN	= 12147,
	IDM_SHOWSCENE	= 12148,
	IDM_ORIGINALGROESSE	= 12149,
	IDM_LUPE	= 12150,
	IDM_SHOWACTIVE	= 12151,
	IDM_X	= 12153,
	IDM_Y	= 12154,
	IDM_Z	= 12155,
	IDM_WELT	= 12156,
	IDM_OBJECT_MANAGER	= 12158,
	IDM_MATERIAL_MANAGER	= 12159,
	IDM_TIMELINE	= 12160,
	IDM_RENDERAKTU	= 12162,
	IDM_RENDERALL	= 12163,
	IDM_DARSTELLUNG	= 12164,
	IDM_RENDERAUSSCHNITT	= 12165,
	IDM_SPEICHERNALL	= 12167,
	IDM_DELUNUSED	= 12168,
	IDM_AKTUZUWEISEN	= 12169,
	IDM_PARAMETER	= 12171,
	IDM_WELTEINSTELLUNGENEX	= 12172,
	IDM_SAUS	= 12175,
	IDM_SPOS	= 12176,
	IDM_SSKAL	= 12177,
	IDM_SROT	= 12178,
	// Depreciated, do not reuse these IDs
	// IDM_TEXTUR	= 12184,
	// IDM_TACHSEN	= 12185,
	IDM_INFO_MANAGER	= 12186,
	// Depreciated, do not reuse these IDs
	// IDM_VIERECKE	= 12187,
	IDM_SPREADSHEET	= 12188,
	IDM_RASTERN	= 12189,
	IDM_SPLINE_HARDINTER	= 12190,
	IDM_SPLINE_SOFTINTER	= 12191,
	IDM_FITBITMAP	= 12192,
	IDM_FITREGION	= 12193,
	// Depreciated, do not reuse these IDs
	// IDM_ANIM	= 12194,
	IDM_RUNDENAN	= 12195,
	IDM_POLYACHSE	= 12196,
	IDM_AKTUTOKAM	= 12201,
	IDM_EDITTOKAM	= 12202,
	IDM_EDITAKTUMAT	= 12203,
	DELME_IDM_INHALT	= 12204,
	IDM_DOPPELTEMATERIALIEN	= 12211,
	IDM_SFOLLOW	= 12215,
	IDM_OWURZEL	= 12216,
	IDM_OKINEMATIK	= 12217,
	IDM_S_C4D5	= 12218,
	IDM_Z_DXF	= 12219,
	IDM_Z_QD3D	= 12220,
	IDM_MNAME	= 12221,
	IDM_OTEXTUR	= 12222,
	IDM_STEXTUR0	= 12223,
	IDM_TAKEANIM	= 12233,
	IDM_GENERATE_UV	= 12235,
	IDM_MAKEFLAECHEN	= 12236,
	IDM_SCHUTZ	= 12246,
	IDM_BFIX	= 12250,
	IDM_RENDERAKTUMAT	= 12252,
	IDM_RENDERALLMAT	= 12253,
	IDM_MAKEPROJECT	= 12255,
	IDM_MOTIONBLUR	= 12258,
	IDM_COMPOSITING	= 12259,
	IDM_GENERATE_UVW	= 12260,
	IDM_CHANGEDNORM	= 12261,
	IDM_FACETOPOLY	= 12262,
	IDM_UDATAEDIT	= 12265,
	IDM_REVERTFILE	= 12270,
	IDM_SPLINE_ROUND	= 12276,
	IDM_SPLINE_CHAMFER	= 12277,
	IDM_Z_VRML1	= 12285,
	IDM_DOPTIONEN	= 12287,
	IDM_SHOWSCENEALL	= 12288,
	IDM_WWW	= 12289,
	IDM_Z_VRML2	= 12290,
	IDM_Z_3DS	= 12291,
	IDM_Z_WAVE	= 12292,
	IDM_RAMA	= 12294,
	IDM_REDO	= 12297,
	// Depreciated, do not reuse these IDs
	// IDM_FLOBJEKTE	= 12298,
	IDM_BRESET	= 12299,
	IDM_AKTIVIERUNG	= 12300,
	IDM_Z_D3D	= 12303,
	IDM_XVOR_3DS	= 12306,
	IDM_XVOR_LWS	= 12307,
	IDM_XVOR_Q3D	= 12308,
	IDM_XVOR_VRML1	= 12309,
	IDM_XVOR_VRML2	= 12310,
	IDM_XVOR_D3D	= 12311,
	IDM_XVOR_DXF	= 12312,
	IDM_XVOR_ILL	= 12313,
	IDM_XVOR_WAVE	= 12314,
	IDM_XVOR_DEM	= 12315,
	IDM_RESETAXIS	= 12317,
	IDM_OUTWINDOW_EX	= 12319,
	IDM_FITTOSIZE	= 12320,
	IDM_12	= 12321,
	IDM_50	= 12322,
	IDM_25	= 12323,
	IDM_100	= 12324,
	IDM_200	= 12325,
	IDM_400	= 12326,
	IDM_800	= 12327,
	IDM_RED	= 12328,
	IDM_SW	= 12332,
	IDM_SORTMATS	= 12333,
	IDM_S_MODE	= 12342,
	IDM_V_MODE	= 12344,
	IDM_A_MODE	= 12345,
	IDM_OFFSET	= 12359,
	IDM_FITST	= 12360,
	IDM_HYPERNURBS	= 12361,
	IDM_NEWTTREE	= 12362,
	IDM_MAGNETOBJECT	= 12367,
	IDM_SDEFORMOBJECT	= 12370,
	IDM_Z_FACT	= 12371,
	IDM_BAKEPARTI	= 12372,
	IDM_DOC_PREFS	= 12373,
	IDM_INVERSION	= 12374,
	IDM_CLOSEALL	= 12390,
	IDM_SAVEALL	= 12391,
	IDM_CLOSEPHYSICALWINDOW = 12392,
	IDM_EXECUTE_LAST	= 12409,
	IDM_RECORD	= 12410,
	IDM_PLAY_BACKWARDS	= 12411,
	IDM_PLAY_FORWARDS	= 12412,
	IDM_FRAME_LAST	= 12413,
	IDM_FRAME_NEXT	= 12414,
	IDM_KEY_LAST	= 12415,
	IDM_KEY_NEXT	= 12416,
	IDM_A_POS	= 12417,
	IDM_A_SIZE	= 12418,
	IDM_A_DIR	= 12419,
	IDM_A_HIERARCHY	= 12420,
	IDM_A_PLA	= 12421,
	IDM_A_PARAMETER	= 12422,
	IDM_A_PREVIEW	= 12423,
	IDM_A_DROPLESS	= 12424,
	IDM_AUTOKEYS	= 12425,
	IDM_SIMPLE	= 12426,
	IDM_CYCLE	= 12427,
	IDM_PINGPONG	= 12428,
	IDM_FPS_1	= 12429,
	IDM_FPS_500	= 12430,
	IDM_FPS_5	= 12431,
	IDM_FPS_10	= 12432,
	IDM_FPS_15	= 12433,
	IDM_FPS_18	= 12434,
	IDM_FPS_24	= 12435,
	IDM_FPS_25	= 12436,
	IDM_FPS_30	= 12437,
	IDM_FPS_60	= 12438,
	IDM_FPS_100	= 12439,
	IDM_FPS_250	= 12440,
	IDM_FPS_DOC	= 12441,
	IDM_FPS_50	= 12443,
	IDM_UPLOAD	= 12444,
	IDM_GOTOFRAME	= 12458,
	IDM_HIDESEL	= 12473,
	IDM_HIDEUNSEL	= 12474,
	IDM_UNHIDE	= 12475,
	IDM_HIDEINVERT	= 12476,
	IDM_UNDO_VIEW	= 12477,
	IDM_REDO_VIEW	= 12478,
	IDM_SEL_INVERT	= 12479,
	IDM_A_BOX	= 12497,
	IDM_A_SKELETON	= 12498,
	IDM_A_USETAGS	= 12499,
	IDM_A_USELWF	= 12500,
	IDM_GOTOMIN	= 12501,
	IDM_GOTOMAX	= 12502,
	IDM_JUMPNEXT	= 12504,
	IDM_JUMPLAST	= 12505,
	IDM_JUMPPGUP	= 12506,
	IDM_JUMPPGDOWN	= 12507,
	IDM_JUMPHOME	= 12508,
	IDM_JUMPEND	= 12509,
	IDM_NEW_RDATA	= 12512,
	IDM_DELETE_RDATA	= 12513,
	IDM_CAMERATARGET	= 12519,
	IDM_CAMERASTEREO	= 450000256,
	IDM_LIGHTTARGET	= 12520,
	IDM_SVIBRATE	= 12527,
	IDM_M_KEYS	= 12528,
	IDM_SPULSATE	= 12529,
	IDM_M_POINTS	= 12530,
	IDM_ANIM_TARGET	= 12531,
	IDM_M_POLYGONS	= 12532,
	IDM_ANIM_ALIGNTOPATH	= 12533,
	IDM_M_UVW	= 12534,
	IDM_ANIM_ALIGNTOSPLINE	= 12535,
	IDM_A_ISOBATH	= 12539,
	IDM_A_NOSHADING = 12540,
	IDM_CM_DROP	= 12541,
	IDM_CM_MAXIMIZE	= 12543,
	IDM_NEWVIEW	= 12544,
	IDM_GENERATESELECTION	= 12552,
	IDM_SEL_CONNECTED	= 12557,
	IDM_SEL_GROW	= 12558,
	IDM_SEL_SHRINK	= 12559,
	IDM_SEL_CONVERT	= 12560,
	IDM_SEL_POLYTOPOINT	= 12561,
	IDM_SPLINE_MOVEDOWN	= 12562,
	IDM_SPLINE_MOVEUP	= 12563,
	IDM_SPLINE_EQUALLENGTH	= 12566,
	IDM_SPLINE_EQUALDIRECTION	= 12567,
	IDM_SPLINE_JOINSEGMENT	= 12568,
	IDM_SPLINE_BREAKSEGMENT	= 12569,
	IDM_XAXIS	= 12570,
	IDM_YAXIS	= 12571,
	IDM_SEL_ADJACENT	= 12576,
	// Depreciated, do not reuse these IDs
	// IDM_2DTRACKS = 12577,
	X_APS_NEXT_SYMED_VALUE	= 12586,
	IDS_OUTWINDOW_FILE	= 12587,
	IDS_OUTWINDOW_EDIT	= 12588,
	IDS_OUTWINDOW_VIEW	= 12589,
	IDS_EDITOR_FILE	= 12590,
	IDS_EDITOR_EXPORT	= 12591,
	IDS_EDITOR_EXPORTPREFS	= 12592,
	IDS_EDITOR_PRESETS	= 12593,
	IDS_EDITOR_EDIT	= 12594,
	IDS_EDITOR_OBJECTS	= 12595,
	IDS_EDITOR_PRIMITIVE	= 12596,
	IDS_EDITOR_SPLINE_PRIMITIVE	= 12597,
	IDS_EDITOR_NURBS	= 12598,
	IDS_EDITOR_MODELING	= 12599,
	IDS_EDITOR_SCENE	= 12600,
	IDS_EDITOR_PARTICLE	= 12601,
	IDS_EDITOR_DEFORMATION	= 12602,
	IDS_EDITOR_SOUND	= 12603,
	IDS_EDITOR_TOOLS	= 12604,
	IDS_EDITOR_ACTION	= 12605,
	IDS_EDITOR_COORDINATES	= 12606,
	IDS_EDITOR_OPTIONS	= 12607,
	IDS_EDITOR_STRUCTURE	= 12608,
	IDS_EDITOR_MODEL_TOOLS	= 12609,
	IDS_EDITOR_SELECTION_TOOLS	= 12610,
	IDS_EDITOR_VISIBILITY	= 12611,
	IDS_EDITOR_SPLINE_OBJECTS	= 12612,
	IDS_EDITOR_PLUGINS	= 12613,
	IDS_EDITOR_RENDER	= 12614,
	IDS_EDITOR_WINDOW	= 12615,
	IDS_EDITOR_ABOUT	= 12616,
	IDS_MATERIAL_MANAGER_FILE	= 12617,
	IDS_MATERIAL_MANAGER_EDIT	= 12618,
	IDS_MATERIAL_MANAGER_FUNCTION	= 12619,
	IDS_OBJECT_MANAGER_FILE	= 12620,
	IDS_OBJECT_MANAGER_EDIT	= 12621,
	IDS_OBJECT_MANAGER_FUNCTION	= 12622,
	IDS_OBJECT_MANAGER_NEW_PROPERTY	= 12623,
	IDS_OBJECT_MANAGER_TEXTURE	= 12624,
	IDS_OBJECT_MANAGER_ADAPT_TO	= 12625,
	IDS_OBJECT_MANAGER_ALIGN_TO	= 12626,
	IDS_BROWSER_FILE	= 12627,
	IDS_BROWSER_EDIT	= 12628,
	IDS_BROWSER_FUNCTION	= 12629,
	IDS_BROWSER_SORT_BY	= 12630,
	IDS_SPREADSHEET_FILE	= 12631,
	IDS_SPREADSHEET_EDIT	= 12632,
	IDS_SPREADSHEET_VIEW	= 12633,
	IDS_SPREADSHEET_MODE	= 12634,
	IDS_VIEWWINDOW_VIEW	= 12635,
	IDS_VIEWWINDOW_FRAME	= 12636,
	IDS_VIEWWINDOW_PROJECTION	= 12637,
	IDS_VIEWWINDOW_DISPLAY	= 12638,
	IDS_TIMELINE_FILE	= 12639,
	IDS_TIMELINE_NEW_TRACK	= 12640,
	IDS_TIMELINE_GEOMETRY	= 12641,
	IDS_TIMELINE_SPECIAL_EFFECTS	= 12642,
	IDS_TIMELINE_EDIT	= 12643,
	IDS_TIMELINE_REGION_SELECT	= 12644,
	IDS_TIMELINE_VIEW	= 12645,
	IDS_TIMELINE_CURVES	= 12646,
	IDS_TIMELINE_SPACE_CURVES	= 12647,
	IDS_TIMELINE_TIME_CURVES	= 12648,
	IDS_TIMELINE_NAVIGATION	= 12649,
	IDS_TIMELINE_RECORD	= 12650,
	IDS_TIMELINE_PLAY_MODE	= 12651,
	IDS_TIMELINE_FRAME_RATE	= 12652,
	IDS_TIMELINE_SEQUENCES	= 12653,
	IDS_TIMELINE_TANGENTS	= 12655,
	IDS_TIMELINE_LAYER	= 12657,
	IDS_TIMELINE_COLOR_SELECTION	= 12658,
	IDS_TIMELINE_SELECT_LAYER	= 12659,
	IDS_TIMELINE_TOGGLE_LAYER	= 12660,
	IDS_TIMELINE_SOLO_LAYER	= 12661,
	IDS_TIMELINE_ALL_LAYERS	= 12662,
	IDS_TIMELINE_WINDOW	= 12663,

	IDM_CLOSESCENE	= 12664,
	R_COMMAND_MANAGER	= 12665,
	M_COFFEEMANAGER_COMMANDMANAGER = 12666,
	M_COFFEEMANAGER_GLOBALSTATUSBAR = 12668,
	R_GLOBALSTATUSBAR		= 12669,

	IDM_LOADLAYOUT			= 12670,
	IDM_FOLDPALETTE,
	IDM_SAVELAYOUT,
	IDM_SAVELAYOUTAS,
	DELME_IDM_RESETLAYOUT,
	IDS_LAYOUT,
	IDM_LOADPALETTE,
	IDM_SAVEPALETTE,
	IDS_TARGET,
	IDM_LOCK,
	IDM_COLORCORRECTION,
	IDM_A_VECTORLENGTH,
	IDM_A_VECTORDIRECTION,
	IDS_VECTOR_VOLUME_DISPLAY,
	IDS_SHOW_INDICES				=	1061158, // equal to ID_INDICES_DISPLAY_TOGGLE
	IDS_SHOW_VERTEX_INDICES	=	1061174, // equal to ID_VERTEX_INDICES_DISPLAY_TOGGLE
	
	IDM_RENDERSETTINGS			= 50000,
	IDM_DOCUMENTS						= 51000,
	IDM_RECENTFILES					= 52000,
	IDM_PLUGINS							= 53000,
	IDM_VIEWWIN_CAMERAS			= 55000,
	IDM_DEFAULT_LAYOUTS			= 56000,
	IDM_LISTSELECTIONS			= 57000,
	IDM_VOLUMESHADER				= 58000,
	IDM_NODEMATERIALS				= 59000,
	IDM_FILTER3D						= 60000,
	IDM_OUTWINDOW_CHANNELS_EX	= 64000,
	IDM_KEYFRAME_SELECTION	= 66000,
	IDM_OBJECTLIBRARY				= 67000,
	IDM_SELECTIONFILTER			= 69000,
	IDM_DISPLAYFILTER				= 70000,
	IDM_REFLECTION_LAYERS		= 71000,
	IDM_NODE_SPACES					= 72000,
	IDM_FILTER3D_CMD				= 74000,
	IDC_CENTER_X						= 12700,
	IDC_CENTER_Y,
	IDC_CENTER_Z ,
	IDC_CRUMPLE_INANDOUT,
	IDC_CRUMPLE_MODE,
	IDC_CRUMPLE_X,
	IDC_CRUMPLE_Y,
	IDC_CRUMPLE_Z,
	IDC_LEVEL_PLANE,
	IDC_QUANTIZE_X,
	IDC_QUANTIZE_XEDIT,
	IDC_QUANTIZE_Y,
	IDC_QUANTIZE_YEDIT,
	IDC_QUANTIZE_Z,
	IDC_QUANTIZE_ZEDIT,
	IDC_XELECT_RADIUS,
	IDC_XELECT_TOLERANCE,
	IDC_XELECT_VISIBLE,
	IDC_SETVALUE_X,
	IDC_SETVALUE_XEDIT,
	IDC_SETVALUE_Y,
	IDC_SETVALUE_YEDIT,
	IDC_SETVALUE_Z,
	IDC_SETVALUE_ZEDIT,
	IDC_SPLINE_PROJECT,
	IDM_SPLINE_AKIMA_EX = 14000,
	IDM_SPLINE_BEZIER_EX  = 14001,
	IDM_SPLINE_BSPLINE_EX  = 14002,
	IDM_SPLINE_CREATEOUTLINE = 14003,
	IDM_SPLINE_CROSSSECTION = 14004,
	IDM_SPLINE_CUBIC_EX = 14005,
	IDM_SPLINE_LINEUP = 14006,
	IDM_SPLINE_PROJECT = 14007,
	R_MODELING_CENTER,
	R_XELECT_PARAM,
	R_MODELING_SETVALUE,
	IDM_STATISTICS,
	DELME_IDM_POLYGONSTATISTICS,
	DELME_R_MODELING_CRUMPLE,
	R_MODELING_LEVEL,
	R_MODELING_QUANTIZE,
	R_MODELING_PROJECT,
	IDS_CREATECURVE,
	DELME_IDM_CONSTRUCTIONPLANE,
	IDM_SNAPDUMMY,
	R_FREEHAND,
	IDC_FREEHAND_TOLERANCE,
	IDM_MODELING_ARRAY,
	IDM_MODELING_ALIGNNORMALS,
	DELME_IDM_MODELING_ADDPOINTS,
	DELME_IDM_MODELING_BEVEL,
	DELME_IDM_MODELING_BRIDGE,
	IDM_MODELING_CENTER,
	DELME_IDM_MODELING_CREATEPOLYGON,
	IDM_MODELING_DISCONNECT,
	DELME_IDM_MODELING_EXTRUDE,
	IDM_MODELING_EXTRUDEREGION,
	DELME_IDM_MODELING_EXTRUDEINNER,
	DELME_IDM_MODELING_CRUMPLE,
	DELME_IDM_MODELING_KNIFE,
	IDM_MODELING_LEVEL,
	DELME_IDM_MODELING_MAGNET,
	DELME_IDM_MODELING_MATRIXEXTRUDE,
	IDM_MODELING_MIRROR,
	IDM_MODELING_OPTIMIZE,
	DELME_IDM_MODELING_QUANTIZE,
	IDM_MODELING_REVERSENORMALS,
	DELME_IDM_MODELING_SETVALUE,
	IDM_MODELING_SMOOTH,
	DELME_IDM_MODELING_SMOOTHSHIFT,
	IDM_MODELING_NORMALTRANSFORM,
	IDM_MODELING_SPLIT,
	IDM_MODELING_SUBDIVIDE,
	IDM_MODELING_TRIANGULATE,
	IDM_MODELING_TRIM,
	IDM_MODELING_UNTRIANGULATE,
	DELME_IDM_MODELING_WELD,
	IDM_SPLINE_TRIM,
	IDM_ENABLE_SNAPPING,
	DELME_IDM_SNAP_SETTINGS,
	IDM_SPLINE_FREEHAND_EX,


	DELME_IDM_VIEW_MOVE,
	DELME_IDM_VIEW_SCALE,
	DELME_IDM_VIEW_ROTATE,


	M_MODELING_POINT,
	M_MODELING_POLYGON,
	M_MODELING_SPLINE,
	IDS_MODELING_POINT_TOOLS,
	IDM_VIEW_ZOOMIN,
	IDM_VIEW_ZOOMOUT,
	XORE_MODELING_SELECTTOLERANCE,
	XORE_MODELING_SELECTVISIBLE,
	XORE_MODELING_SELECTRADIUS,
	R_ACTIVE_TOOL_EX,

	IDC_DISCONNECT_PRESERVEGROUPS,
	R_MODELING_DISCONNECT,

	R_MODELING_CREATEOUTLINE,
	IDC_CREATEOUTLINE_RADIUS,
	IDC_SELECTPOINTS_TAB,
	IDC_SELECTPOINTS_TABPOLY,
	IDC_SELECTPOINTS_TABSPLINE,
	IDC_SETVALUE_GLOBAL,
	DELME_R_MODELING_SMOOTHSHIFT,
	IDC_SMOOTHSHIFT_ANGLE,
	IDC_SMOOTHSHIFT_OFFSET,


	DELME_M_COFFEEMANAGER_DIALOGMANAGER,
	DELME_R_DIALOG_MANAGER,
	IDM_CM_RENAMEWINDOW,

	DELME_R_REGISTER,
	DELME_IDC_SN,
	DELME_IDC_COMPANY,
	DELME_IDC_STREET,
	DELME_IDC_CITY,
	DELME_IDC_COUNTRY,

	IDC_SPLIT_KEEPPOLYGONS,
	R_MODELING_SPLIT,

	M_STRUCTURE_POPUP1 = 13007,
	M_STRUCTURE_POPUP2 = 13008,
	M_MATERIAL_POPUP1 = 13009,
	IDM_M_OEFFNE = 13012,
	IDM_O_OEFFNE = 13013,
	IDM_MNEU  = 13015,
	IDM_SNEU  = 13016,
	IDM_MHINZULADEN = 13017,
	IDM_SHINZULADEN = 13018,
	IDM_MSPEICHERN  = 13020,
	IDM_SSPEICHERN  = 13021,
	IDM_ORED    = 13022,
	IDM_OGREEN  = 13023,
	IDM_OBLUE   = 13024,
	R_ACTIVE = 13026,


	IDS_WRONG_OBJECTYPE = 13027,
	IDC_EXTRUDE_OFFSET = 13028,
	IDC_EXTRUDE_PRESERVEGROUPS = 13029,
	IDC_EXTRUDEINNER_OFFSET = 13031,
	IDC_EXTRUDEINNER_PRESERVEGROUPS = 13033,
	IDC_EXTRUDEINNER_ANGLE = 13034,
	IDC_EXTRUDE_ANGLE = 13035,
	IDC_EXTRUDE_VARIANCE = 13036,
	IDC_EXTRUDEINNER_VARIANCE = 13037,
	IDM_SHOWSELECTED = 13038,
	IDM_POLYACHSE2	= 13039,
	IDC_BEVEL_OFFSET1 = 13040,
	IDC_BEVEL_OFFSET2 = 13041,
	IDC_BEVEL_PRESERVEGROUPS = 13042,
	IDC_BEVEL_ANGLE = 13043,
	IDC_BEVEL_VARIANCE1 = 13044,
	IDC_BEVEL_VARIANCE2 = 13045,
	IDM_MODELING_CLONE,
	IDC_CLONE_AXIS,
	IDC_ARRAY_KEEPFORM,
	IDC_CLONE_SCALEELEMENTS,
	IDC_ARRAY_HOLES,
	IDC_ARRAY_XCNT,
	IDC_ARRAY_YCNT,
	IDC_ARRAY_ZCNT,
	IDC_CLONE_SCALE,
	IDC_ARRAY_OFFSETX,
	IDC_ARRAY_OFFSETY,
	IDC_ARRAY_OFFSETZ,
	IDC_ARRAY_MOVEX,
	IDC_ARRAY_MOVEY,
	IDC_ARRAY_MOVEZ,
	IDC_ARRAY_SCALEX,
	IDC_ARRAY_SCALEY,
	IDC_ARRAY_SCALEZ,
	IDC_ARRAY_ROTATIONX,
	IDC_ARRAY_ROTATIONY,
	IDC_ARRAY_ROTATIONZ,
	IDC_CLONE_ROTATION,
	IDC_CLONE_MOVEX,
	IDC_CLONE_MOVEY,
	IDC_CLONE_MOVEZ,
	IDC_CLONE_SCALEX,
	IDC_CLONE_SCALEY,
	IDC_CLONE_SCALEZ,
	IDC_CLONE_KEEPFORM,
	IDC_CLONE_ROTATIONX,
	IDC_CLONE_ROTATIONY,
	IDC_CLONE_ROTATIONZ,
	IDC_CLONE_OFFSET,
	IDC_CLONE_HOLES,
	IDC_CLONE_CNT,
	R_MODELING_ARRAY,
	R_MODELING_CLONE,
	DELME_R_MODELING_BRIDGE,
	IDC_BRIDGE_TRIANGULATE,
	IDC_BRIDGE_STRIPES,
	IDC_MIRROR_SYSTEM,
	IDC_MIRROR_PLANE,
	IDC_MIRROR_SNAPPOINTS,
	IDC_MIRROR_DUPLICATE,
	IDC_MIRROR_WELD,
	IDC_MIRROR_TOLERANCE,
	IDC_MIRROR_VALUE,
	R_MODELING_MIRROR,
	R_MODELING_OPTIMIZE,
	IDC_OPTIMIZE_POLYGONS,
	IDC_OPTIMIZE_UNUSEDPOINTS,
	IDC_OPTIMIZE_POINTS,
	IDC_OPTIMIZE_TOLERANCE,
	IDC_CREATEOUTLINE_SEPARATE,
	DELME_R_MODELING_CREATEPOLYGON,
	IDC_CREATEPOLYGON_KEEPQUADRANGLE,
	DELME_R_MODELING_SNAP,
	IDC_SNAP_MOUSERASTER,
	IDC_SNAP_MOUSEQUANTIZE,
	R_MODELING_CROSSSECTION,
	IDC_CROSSSECTION_CONSTRAIN,
	IDC_CROSSSECTION_ANGLE,
	DELME_R_MODELING_MATRIXEXTRUDE,
	IDC_MATRIXEXTRUDE_STEPS,
	IDC_MATRIXEXTRUDE_MOVEX,
	IDC_MATRIXEXTRUDE_MOVEY,
	IDC_MATRIXEXTRUDE_MOVEZ,
	IDC_MATRIXEXTRUDE_SCALEX,
	IDC_MATRIXEXTRUDE_SCALEY,
	IDC_MATRIXEXTRUDE_SCALEZ,
	IDC_MATRIXEXTRUDE_ROTATEX,
	IDC_MATRIXEXTRUDE_ROTATEY,
	IDC_MATRIXEXTRUDE_ROTATEZ,
	IDC_MATRIXEXTRUDE_POLYGONCOORDS,
	IDC_MATRIXEXTRUDE_VARIANCE,
	IDC_MATRIXEXTRUDE_MOVEFROM,
	IDC_MATRIXEXTRUDE_MOVETO,
	IDC_MATRIXEXTRUDE_SCALEFROM,
	IDC_MATRIXEXTRUDE_SCALETO,
	IDC_MATRIXEXTRUDE_ROTATEFROM,
	IDC_MATRIXEXTRUDE_ROTATETO,
	R_MODELING_NORMALTRANSFORM,
	IDC_NORMALTRANSFORM_ACTION,
	IDC_NORMALTRANSFORM_VALUE,
	IDC_LI_INNERCONE_TEXT,
	DELME_IDM_MAKERELATIVE,

	IDS_TITLE_BROWSER,
	IDS_TITLE_OMANAGER,
	IDS_TITLE_MMANAGER,
	IDS_TITLE_TIMELINE,
	IDS_TITLE_IMANAGER,
	IDS_TITLE_CONSOLE,
	IDS_TITLE_OUTWINDOW,
	IDS_TITLE_SPREADSHEET,
	IDS_TITLE_EDITOR,
	IDS_TITLE_VIEW,

	IDC_MODELING_REVERSENORMALS,
	IDC_REVERSENORMALS_USERNORMALS,
	IDC_MODELING_ALIGNNORMALS,
	IDC_ALIGNNORMALS_USERNORMALS,

	IDM_MODELING_EXPLODESEGMENTS_SPLINE = 13316,
	DELME_IDM_MODELING_NORMALMOVE,
	DELME_IDM_MODELING_NORMALSCALE,
	DELME_IDM_MODELING_NORMALROTATE,
	IDM_MODELING_UNDOLAST,
	IDM_TOGGLESELECTTOOL,
	// Depreciated, do not reuse these IDs
	// IDM_TOGGLEMODE,
	IDM_SEL_ALL = 13323,
	IDM_SEL_NONE,
	IDC_SPHERE_PERFECT,
	IDC_NORMALMOVE_VALUE,
	IDC_NORMALSCALE_VALUE,
	IDC_NORMALROTATE_VALUE,
	R_MODELING_NORMALMOVE,
	R_MODELING_NORMALSCALE,
	R_MODELING_NORMALROTATE,
	IDS_SHADER1,
	IDS_SHADER2,
	IDS_SHADER3,
	IDS_SHADER4,
	IDS_SHADER5,
	IDS_SHADER6,
	IDS_SHADER7,
	IDS_SHADER8,
	IDS_SHADER9,
	IDS_SHADER10,
	IDS_SHADER11,
	IDS_SHADER12,
	IDS_SHADER13,
	IDS_SHADER14,
	IDS_SHADER15,
	IDS_SHADER16,
	IDS_SHADER17,
	IDS_SHADER18,
	IDS_SHADER19,
	IDS_SHADER20,
	IDS_SHADER21,
	IDS_SHADER22,
	IDS_SHADER23,
	IDS_SHADER24,
	IDS_SHADER25,
	IDS_SHADER26,
	IDS_SHADER27,
	IDS_SHADER28,
	IDS_NEWSHADER,
	IDS_RELOADIMAGE,
	IDS_EDITOR_CAMERAS,
	IDM_GOTOMARKER,
	IDM_A_BACKFACE,
	IDM_A_TEXTURES,
	M_OBJECT_POPUP1,
	M_OBJECT_POPUP2,
	DELME_M_BROWSER_POPUP1,
	IDS_BSOUND,
	IDS_BFCV,
	IDS_BCOFFEE,

	IDS_EDITOR_CREATEMODIFY,
	IDS_EDITOR_MODELTOOLS,
	IDS_EDITOR_EDITSURFACE,
	IDM_CM_NEWPALETTE,

	R_MODELING_SUBDIVIDE,
	IDC_SUBDIVIDE_HYPER,
	IDC_SUBDIVIDE_ANGLE,
	R_MODELING_SPLINESUB,
	IDC_SUBDIVIDE_SPLINESUB,

	DELME_R_MODELING_SELECTFREE,
	DELME_R_MODELING_SELECTPOLY,
	DELME_R_MODELING_SELECTRECT,
	DELME_R_MODELING_SELECTLIVE,
	DELME_IDC_SELECTFREE_TOLERANCE,
	IDC_SELECTFREE_VISIBLE,
	IDC_SELECTPOLY_TOLERANCE,
	IDC_SELECTPOLY_VISIBLE,
	IDC_SELECTRECT_TOLERANCE,
	IDC_SELECTRECT_VISIBLE,
	IDC_SELECTLIVE_VISIBLE,
	IDC_SELECTLIVE_RADIUS,
	IDC_XSELECT,
	IDC_XDESELECT,
	IDC_XSELECT2,
	IDC_XDESELECT2,
	IDC_XSELECT3,
	IDC_XDESELECT3,
	IDC_XSELECT4,
	IDC_XDESELECT4,
	IDC_XSELECT5,
	IDC_XDESELECT5,
	IDC_XSELECT6,
	IDC_XDESELECT6,
	IDC_SELECTPOINTS_TABPOINT,
	IDC_YSELECT,
	IDC_YDESELECT,
	IDC_YSELECT2,
	IDC_YDESELECT2,
	IDC_YSELECT3,
	IDC_YDESELECT3,
	DELME_R_MODELING_KNIFE,
	IDC_KNIFE_ANGLE,
	IDC_KNIFE_RESTRICT,
	DELME_R_MODELING_MAGNET,
	IDC_MAGNET_NEARESTPOINT,
	IDC_MAGNET_RADIUS,
	IDC_MAGNET_PREVIEW,
	IDC_MAGNET_WIDTH,
	IDC_MAGNET_HEIGHT,
	IDC_MAGNET_TYPE,
	IDC_SNAP_ENABLE,
	DELME_IDC_SNAP_POINT,
	DELME_IDC_SNAP_EDGE,
	IDC_SNAP_POLYGON,
	IDC_SNAP_GRID,
	IDC_SNAP_GRIDLINE,
	IDC_SNAP_SPLINE,
	IDC_SNAP_SPLINEGRID,
	IDC_SNAP_AXIS,
	IDC_SNAP_PLANE,
	IDC_SNAP_TANGENT,
	IDC_SNAP_PERPENDICULAR,
	IDC_SNAP_FACECENTER,
	DELME_IDC_SNAP_MIDPOINT,
	IDC_SNAP_SPLINESUB,
	DELME_IDC_SNAP_RADIUS,
	IDC_SNAP_METHOD,


	IDS_QUAL_CTRL,
	IDS_QUAL_SHIFT,
	IDS_QUAL_ALT,
	IDS_QUAL_ALT2,
	IDS_QUAL_ALT3,
	IDS_KEY_MLEFT,
	IDS_KEY_MRIGHT,
	IDS_KEY_UP,
	IDS_KEY_DOWN,
	IDS_KEY_RIGHT,
	IDS_KEY_LEFT,
	IDS_KEY_PGUP,
	IDS_KEY_PGDOWN,
	IDS_KEY_HOME,
	IDS_KEY_END,
	IDS_KEY_INSERT,
	IDS_KEY_DELETE,
	IDS_KEY_BACKSPACE,
	IDS_KEY_ENTER,
	IDS_KEY_TAB,
	IDS_KEY_F1,
	IDS_KEY_F2,
	IDS_KEY_F3,
	IDS_KEY_F4,
	IDS_KEY_F5,
	IDS_KEY_F6,
	IDS_KEY_F7,
	IDS_KEY_F8,
	IDS_KEY_F9,
	IDS_KEY_F10,
	IDS_KEY_F11,
	IDS_KEY_F12,
	IDS_KEY_ESC,
	IDS_KEY_SPACE,

	IDS_OK,
	IDS_CANCEL,
	IDS_HELP,

	IDS_ACTIVETOOL,
	IDS_NOSETTINGS,
	IDS_SEPARATORICON,
	IDS_SEPARATORICONHELPTEXT,

	IDS_CM_ROWSCOLS,

	IDS_CM_TITLE,

	IDS_CM_GROUP_ALL,
	IDS_CM_GROUP_EDITOR,
	IDS_CM_GROUP_ED_FILE,
	IDS_CM_GROUP_ED_EDIT,
	IDS_CM_GROUP_ED_OBJECTS,
	IDS_CM_GROUP_ED_TOOLS,
	IDS_CM_GROUP_ED_SELECTION,
	IDS_CM_GROUP_ED_PLUGINS,
	IDS_CM_GROUP_ED_RENDERING,
	IDS_CM_GROUP_ED_WINDOWS,
	IDS_CM_GROUP_TIMELINE,
	IDS_CM_GROUP_TL_FILE,
	IDS_CM_GROUP_TL_NAVIGATION,
	IDS_CM_GROUP_TL_VIEW,
	IDS_CM_GROUP_TL_SEQUENCES,
	IDS_CM_GROUP_TL_CURVES,
	IDS_CM_GROUP_TL_LAYERS,
	IDS_CM_GROUP_TL_EDIT,
	IDS_CM_GROUP_TL_WINDOW,


	IDS_CM_GROUP_OBJMAN,
	IDS_CM_GROUP_MATMAN,
	IDS_CM_GROUP_BROWSER,
	IDS_CM_GROUP_SPREADSHEET,
	IDS_CM_GROUP_VIEWWINDOW,
	IDS_CM_GROUP_OUTWINDOW,
	IDS_CM_GROUP_OTHERS,
	IDS_CM_DETAILS,
	IDS_CM_COMMAND,
	IDS_CM_DESCR,
	IDS_CM_CURSHORT,
	IDS_CM_NEWSHORT,
	IDS_CM_REMOVE,
	IDS_CM_ASSIGN,
	IDS_CM_PALETTES,
	IDS_CM_EDITPALETTES,
	IDS_CM_ASSIGNEDTO,


	IDS_CM_LOADLAYOUT,
	IDS_CM_SAVELAYOUT,
	IDS_CM_MERGELAYOUT,

	IDM_USE_ANIMATION,
	IDM_USE_EXPRESSIONS,
	IDM_USE_GENERATORS,
	IDM_USE_DEFORMERS,

	IDS_EDITOR_ECAMS,
	IDS_EDITOR_SCAMS,
	IDS_EDITOR_NAVMODE,
	IDS_NOERROR,
	IDS_OBJECT_MANAGER_EXPRESSION,
	IDM_COFFEEEXPRESSION,
	IDM_FIXEXPRESSION,
	IDM_IKEXPRESSION,
	IDM_SUNEXPRESSION,
	IDM_TARGETEXPRESSION,

	IDS_COFFEEEXPRESSION,
	IDS_FIXEXPRESSION,
	IDS_IKEXPRESSION,
	IDS_SUNEXPRESSION,
	IDS_TARGETEXPRESSION,

	R_SUNEXPRESSION,
	IDM_LIGHTSUN,
	IDM_IESLIGHT_EX,

	IDM_TEXT_COPY,
	IDM_TEXT_CUT,
	IDM_TEXT_PASTE,
	IDM_TEXT_DELETE,

	IDS_TAGSUBMENU,
	IDS_EXPRESSIONSUBMENU,

	IDM_OBJECT_MAN_EX,
	IDM_OBJECT_WOMAN_EX,
	IDM_OBJECT_CHILD_EX,


	IDS_SUBMENU_OBJECTLIBRARY,
	IDM_CM_MAKETAB,

	IDM_X2,
	IDM_Y2,
	IDM_Z2,

	DELME_IDS_SERIAL_EXPIRED,
	DELME_IDS_SERIAL_EXPIRE1,
	DELME_IDS_SERIAL_EXPIRE2,
	DELME_IDS_SERIAL_ENTERDATA,
	DELME_IDS_SERIAL_WRONG,

	R_HOTKEY,

	HOTKEY_CAMERA_MOVE,
	HOTKEY_CAMERA_SCALE,
	HOTKEY_CAMERA_ROTATE,

	HOTKEY_OBJECT_MOVE,
	HOTKEY_OBJECT_SCALE,
	HOTKEY_OBJECT_ROTATE,

	HOTKEY_MODEL_SCALE,
	HOTKEY_ZOOM,
	HOTKEY_SELECT_FREE,
	HOTKEY_SELECT_LIVE,
	HOTKEY_SELECT_RECT,

	R_VIEW_PANEL,
	R_EDIT_TEXT,

	IDC_SUBDIVIDE_SUB,
	IDM_ASSIGN_UVW,
	IDS_CONSTRUCTIONPLANE,
	R_CONSTRUCTIONPLANE,
	IDC_CONSTRUCTIONPLANE_TYPE,
	IDC_CONSTRUCTIONPLANE_SPACING,
	IDC_CONSTRUCTIONPLANE_SUB,
	IDC_CONSTRUCTIONPLANE_ROUGHSUB,
	IDS_PLUGINSHADER,
	IDC_SNAP_PLANE_SPACING,
	IDC_SNAP_PLANE_SUB,
	IDC_SNAP_PLANE_ROUGHSUB,
	IDC_SNAP_PLANE_ENABLE,
	IDC_SNAP_PLANE_DYNAMICGRID,
	DELME_IDC_SNAP_LOCAL_MOVEENABLE,
	DELME_IDC_SNAP_LOCAL_MOVE,
	DELME_IDC_SNAP_LOCAL_SCALEENABLE,
	DELME_IDC_SNAP_LOCAL_SCALE,
	DELME_IDC_SNAP_LOCAL_ROTATEENABLE,
	DELME_IDC_SNAP_LOCAL_ROTATE,
	IDC_SNAP_LOCAL_TEXTUREENABLE,
	IDC_SNAP_LOCAL_TEXTURE,

	IDM_MATERIAL_SMALL_EX,
	IDM_MATERIAL_MEDIUM_EX,
	IDM_MATERIAL_LARGE_EX,
	IDC_MATERIAL_RESET,
	IDC_MATERIAL_REFRESH,

	IDM_MODELING_POPUP,
	IDM_MODELING_SNAPENABLE,
	IDC_SNAPGROUP1,
	IDC_SNAPGROUP2,
	IDC_SNAPGROUP3,
	IDC_SNAPGROUP4,
	IDC_SNAPPANEL,

	IDC_LOFTOBJECT_ISOPARM,
	IDC_LOFTOBJECT_SUBX,
	IDC_LOFTOBJECT_SUBY,
	IDC_LOFTOBJECT_CLOSEY,
	IDC_LOFTOBJECT_FLIPNORMALS,
	IDC_LOFTOBJECT_LINEAR,
	IDC_LOFTOBJECT_ORGANIC,
	IDC_LOFTOBJECT_ADAPTIVEY,
	IDC_LOFTOBJECT_FITUV,

	DELME_IDM_BAKE_ANIM,

	IDM_VIEW_SINGLE,
	IDM_VIEW_2V,
	IDM_VIEW_2H,
	IDM_VIEW_2SPLIT_TOP,
	IDM_VIEW_2SPLIT_BOTTOM,
	IDM_VIEW_2SPLIT_LEFT,
	IDM_VIEW_2SPLIT_RIGHT,
	IDM_VIEW_4T,
	IDM_VIEW_3SPLIT_TOP,
	IDM_VIEW_3SPLIT_BOTTOM,
	IDM_VIEW_3SPLIT_LEFT,
	IDM_VIEW_3SPLIT_RIGHT,
	IDM_VIEW_4H,
	IDM_VIEW_4V,

	IDS_VIEWWINDOW_PANELS,
	IDM_VIEW0,
	IDM_VIEW1,
	IDM_VIEW2,
	IDM_VIEW3,
	IDM_VIEW4,
	IDM_VIEWTOGGLE,
	IDS_TIMELINE_OBJECTS,


	M_ICON_PALETTE,
	M_CMIP_TRANSPOSE,
	M_CMIP_NUM1,
	M_CMIP_NUM2,
	M_CMIP_NUM3,
	M_CMIP_NUM4,
	M_CMIP_NUM5,
	M_CMIP_NUM6,
	M_CMIP_NUM7,
	M_CMIP_NUM8,
	M_CMIP_NUM9,
	M_CMIP_ICONS,
	M_CMIP_TEXT,
	M_CMIP_VERTICAL,

	M_CMIP_ICONS_AS_IS,
	M_CMIP_ICONS_BIG,
	M_CMIP_ICONS_SMALL,
	M_CMIP_ICONS_MEDIUM,

	DELME_CMD_TIMELINESCROLL,

	IDM_INVERSEKINEMATICS,

	IDC_VIEW_XRAY,
	IDM_VIEW_XRAY,
	IDC_MATERIAL_OK,
	IDC_POINTSELECT_1,
	IDC_POINTSELECT_2,
	IDC_POINTSELECT_3,
	IDC_POINTSELECT_4,
	IDC_POINTSELECT_5,
	IDC_POINTSELECT_NAME,
	IDC_POLYSELECT_NAME,
	IDC_POLYSELECT_1,
	IDC_POLYSELECT_2,
	IDC_POLYSELECT_3,
	IDC_POLYSELECT_4,
	IDC_POLYSELECT_5,
	IDS_LISTSELECTION,
	IDS_RESTORESELECTION,
	IDS_SEPARATORICON2,
	IDM_PERSONALIZE,
	DELME_IDM_MAXONONLINE,
	IDC_POINTSELECT_6,
	IDC_POLYSELECT_6,


	IDM_UNFOLDICON,
	DELME_IDM_DELETECMD,

	IDC_MIRROR_SELECTIONS,
	R_SYMMETRY,
	IDC_SYMMETRY,
	IDC_SYMMETRY_PLANE,
	IDC_SYMMETRY_WELD,
	IDC_SYMMETRY_TOLERANCE,

	IDC_CAPS_START,
	IDC_CAPS_END,
	IDC_CAPS_FORM,
	IDC_CAPS_STARTSTEPS,
	IDC_CAPS_STARTRADIUS,
	IDC_CAPS_ENDSTEPS,
	IDC_CAPS_ENDRADIUS,
	IDC_CAPS_HULL,
	IDC_CAPS_HOLE,
	IDC_CAPS_CONSTRAIN,
	IDC_CAPS_ENDREGULAR,

	IDC_LATHEPANEL,
	IDC_LATHEGROUP1,
	IDC_LATHEGROUP2,
	IDC_LATHEOBJECT_ISOPARM,
	IDC_LATHEOBJECT_ANGLE,
	IDC_LATHEOBJECT_SUB,
	IDC_LATHEOBJECT_MOVE,
	IDC_LATHEOBJECT_SCALE,
	IDC_LATHEOBJECT_FLIPNORMALS,

	IDC_SWEEPPANEL,
	IDC_SWEEPGROUP1,
	IDC_SWEEPGROUP2,
	IDC_SWEEPOBJECT_ISOPARM,
	IDC_SWEEPOBJECT_SUB,
	IDC_SWEEPOBJECT_SCALE,
	IDC_SWEEPOBJECT_ROTATE,
	IDC_SWEEPOBJECT_GROWTH,
	IDC_SWEEPOBJECT_PARALLEL,
	IDC_SWEEPOBJECT_RAILDIRECTION,
	IDC_SWEEPOBJECT_RAILSCALE,
	IDC_SWEEPOBJECT_CONSTANT,
	IDC_SWEEPOBJECT_BANKING,
	IDC_SWEEPOBJECT_FLIPNORMALS,

	IDC_LOFTPANEL,
	IDC_LOFTGROUP1,
	IDC_LOFTGROUP2,


	IDC_EXTRUDEPANEL,
	IDC_EXTRUDEGROUP1,
	IDC_EXTRUDEGROUP2,
	IDC_EXTRUDEOBJECT_ISOPARM,
	IDC_EXTRUDEOBJECT_MOVEX,
	IDC_EXTRUDEOBJECT_MOVEY,
	IDC_EXTRUDEOBJECT_MOVEZ,
	IDC_EXTRUDEOBJECT_SUB,
	IDC_EXTRUDEOBJECT_FLIPNORMALS,

	IDS_CM_SHORT1_IS_DEPRECATED,
	IDS_CM_SHORT2_IS_DEPRECATED,

	IDM_CM_CUSTOMIZE,

	IDC_EXPLOSION_PSPEED,
	IDC_EXPLOSION_ASPEED,
	IDC_EXPLOSION_ENDSIZE,
	IDC_EXPLOSION_RANDOM,

	R_MENU_MANAGER,
	M_COFFEEMANAGER_MENUMANAGER,


	IDC_TEXGROUP1_TIME,
	IDC_TEXGROUP2_TIME,
	IDC_TEXGROUP3_TIME,
	IDC_TEXGROUP4_TIME,
	IDC_TEXGROUP5_TIME,
	IDC_TEXGROUP7_TIME,
	IDC_TEXGROUP8_TIME,
	IDC_TEXGROUP10_TIME,
	IDC_TEXGROUP12_TIME,

	R_BONE3,
	R_BONE_NAME01,
	R_BONE_NAME02,
	R_BONE_NAME03,
	R_BONE_NAME04,
	R_BONE_NAME05,
	R_BONE_NAME06,
	R_BONE_VAL_01,
	R_BONE_VAL_02,
	R_BONE_VAL_03,
	R_BONE_VAL_04,
	R_BONE_VAL_05,
	R_BONE_VAL_06,

	IDM_RESTRICTION,

	IDM_SETVERTEX_FROM_SELECTION,
	R_SETVERTEX_FROM_SELECTION,
	IDC_SETVERTEX_VALUE,
	IDC_SETVERTEX_BORDER,
	IDC_SETVERTEX_MODE,

	IDC_MATERIALTAB_DIFFUSION,
		IDC_MATCOLOR13_RGB,
		IDC_TEXGROUP13_MIXMODE,
		IDC_TEXGROUP13_MIXTEXTURE,
		IDC_TEXGROUP13_MIXPREVIEW,
		IDC_TEXGROUP13_IMAGE,
		IDC_TEXGROUP13_NAME,
		IDC_TEXGROUP13_BLUROFFSET,
		IDC_TEXGROUP13_BLURSTRENGTH,
		IDC_TEXGROUP13_INTERPOLATION,
		IDC_TEXGROUP13_INFO,
		IDC_TEXGROUP13_PREVIEW,
		IDC_TEXGROUP13_EDIT,
		IDC_TEXGROUP13_POPUP,
	IDC_CHECK_DIFFUSION,
	IDC_MX_DIFFUSION,
	IDC_MATERIAL_AFFECTSPECULAR,
	IDC_MATERIAL_AFFECTREFLECTION,


	IDS_CM_GROUP_HOTKEYS,
	IDS_CM_EMPTY,
	IDS_CM_EMPTYPALETTE,
	IDS_DEFAULTPALETTENAME,
	IDS_VIEWPANELTITLE,

	IDS_CM_COLORTABLE,
	IDS_CM_RGB100,
	IDS_CM_HSV100,
	IDS_CM_RGB255,
	IDS_CM_HSV255,
	IDS_CM_RGB65535,
	IDS_CM_HSV65535,
	IDS_CM_COLORS,
	IDS_CM_RGB,
	IDS_CM_HSV,
	IDS_CM_BRIGHTNESS,
	IDS_CM_R,
	IDS_CM_G,
	IDS_CM_B,
	IDS_CM_H,
	IDS_CM_S,
	IDS_CM_V,

	IDS_MM_SUBMENU,
	IDS_MM_TITLE,
	IDS_MM_COPY,
	IDS_MM_PASTE,
	IDS_MM_CUT,
	IDS_MM_RENAME,

	IDS_MM_MOVEUP,
	IDS_MM_MOVEDOWN,

	IDS_MM_NEWSUB,
	IDS_MM_APPLY,
	IDS_MM_SAVEALL,
	IDS_MM_REVERT,
	IDS_MM_REVERTFACTORY,

	IDS_MM_ASKREVERT,
	IDS_MM_ASKREVERTFACTORY,
	IDC_UNTRIANGULATE_ANGLE,
	IDC_DISPLAY_LOD,
	IDC_DISPLAY_LODVAL,
	R_MODELING_UNTRIANGULATE,

	IDS_VRML2_ERROR,

	IDS_INIT_USER_INTERFACE,
	IDS_INIT_CINEMA4D,
	IDS_INIT_LOAD_LAYOUT,
	IDS_INIT_LAYOUT,
	IDS_INIT_COMMAND_RESOURCE,
	IDS_INIT_SHORTCUTS,
	IDS_INIT_MENU_RESOURCE,
	IDS_INIT_ICON_RESOURCE,
	IDS_ASK_SAVE_MENUS,
	IDS_SYMBOL_NOT_FOUND,
	IDS_DIALOG_RESOURCE_CORRUPTED,
	IDS_ERROR_READING_RESOURCE,
	IDS_COMMAND_STRINGS_MISSING,

	IDC_SWEEPOBJECT_KEEPSEGMENTS,
	IDC_SWEEPOBJECT_BIRAIL,
	IDC_SYMMETRY_ONPLANE,
	IDC_MIRROR_ONPLANE,

	IDC_CAMERA_APERTURE,
	IDC_CAMERA_SHOW,

	IDS_OBJECTDISPLAY,
	IDS_OBJECTSTATE,
	IDS_LOD,

	IDM_NEXT_DOCUMENT,
	IDM_PREV_DOCUMENT,

	IDM_LOD_LOW,
	IDM_LOD_MEDIUM,
	IDM_LOD_HIGH,

	IDM_EDITORDISPLAY_ON,
	IDM_EDITORDISPLAY_OFF,
	IDM_EDITORDISPLAY_NONE,

	IDM_RENDERDISPLAY_ON,
	IDM_RENDERDISPLAY_OFF,
	IDM_RENDERDISPLAY_NONE,


	DELME_IDM_TOGGLE_OBJECT_STATE,
	IDM_OBJECT_STATE_ON,
	IDM_OBJECT_STATE_OFF,
	IDM_OBJECT_STATE_BOTH,
	IDC_RAYEFFECTS_LOD,
	IDC_RAYEFFECTS_JITTERING,
	IDC_RAYOPT_REFLDEPTH,
	IDC_MATERIAL_AFFECTLUMINANCE,
	IDS_MEMLOW,
	IDS_MEMMEDIUM,
	IDS_MEMHIGH,
	IDS_TIMELOW,
	IDS_TIMEMEDIUM,
	IDS_TIMEHIGH,
	IDC_LIGHT_ADDITIVE,
	IDC_LIGHT_AREASAMPLES,
	IDS_FILTER3D_D3D,
	IDS_FILTER3D_3DS,
	IDS_FILTER3D_DXF,
	IDS_FILTER3D_DEM,
	IDS_FILTER3D_AI,
	IDS_FILTER3D_LW,
	IDS_FILTER3D_Q3D,
	IDS_FILTER3D_VRML1,
	IDS_FILTER3D_VRML2,
	IDS_FILTER3D_OBJ,
	R_ARRAY,
	IDC_ARRAY_RADIUS,
	IDC_ARRAY_COPIES,
	IDC_ARRAY_AMPLITUDE,
	IDC_ARRAY_FREQUENCY,


	IDM_M_VERTEX,

	HOTKEY_GENERAL_POPUP,
	M_GLOBAL_POPUP,

	IDS_VERTEXTAGHELP,
	IDS_RESTRICTIONTAGHELP,

	IDS_ARRAY_OBJECT,
	IDC_ARRAY_CIRCLEFREQ,

	IDM_FIX_ICON,

	R_DEFORM_TWIST,
	R_DEFORM_BEND,
	R_DEFORM_BULGE,
	R_DEFORM_SHEAR,
	R_DEFORM_TAPER,

	M_OBJECT_POPUP3,
	IDC_VIEWTEXTURES,

	IDC_VN_SCALEX,
	IDC_VN_SCALEY,
	IDC_VN_SCALEZ,

	IDC_LIGHT_CLIPPINGINFLUENCE,

	IDC_REGULARGRID,
	IDC_REGULARSUB,
	IDC_CAPS_ENDSUB,

	R_METATAG,
	IDC_META_NEGATIVE,
	IDC_META_STRENGTH,
	IDC_META_RADIUS,

	R_MODELING_EXPLODESEGMENTS,
	IDC_EXPLODESEGMENTS_SELECTION,

	R_MODELING_CONNECT,
	IDC_EXPLODESEGMENTS_GENERATESELECTION,

	IDS_CM_GROUP_ED_OPTIONS,

	IDS_DOUBLENAMEPROBLEM,
	IDM_RENDERVIEW,

	IDS_OM_METABALL,
	IDM_OMETATAG,
	IDC_SHOWOBJECTS,


	IDC_SELECTLIVE_PAINT,
	IDC_SELECTLIVE_PAINTMODE,
	IDC_SELECTLIVE_PAINTSTRENGTH,
	IDC_METABALL_EXPONENTIAL,
	IDS_MARKERFAIL,


	IDM_TOGGLE_GENERATOR,


	R_EXTRUDE_H,
	IDM_EXTRUDE_H,


	IDC_SEPARATELETTERS,
	IDC_HIERARCHIC,

	IDC_BL,
	IDC_SET_BL,

	IDC_BR,
	IDC_SET_BR,

	IDS_APPLTITLE,
	IDS_DEMOTEXT_1,
	IDS_DEMOTEXT_2,
	IDS_DEMOTEXT_3,
	IDS_DEMOTEXT_4,

	IDM_O_GROESSER,
	IDM_O_KLEINER,


	M_CONSOLE,
	IDM_CLEARCONSOLE,

	IDC_RAYVR_DEFAULTX,
	IDC_RAYVR_DEFAULTY,
	IDS_CANNOTRENDERQTVR,

	IDC_ILLGROUP,
	IDC_ILLCONNECT,
	DELME_IDC_LWAVESPLIT,

	IDM_RENDER_LOD,
	IDM_COMPILE_PLUGIN,

	DELME_IDC_USEQUICKTIME,
	IDC_LANGUAGE,

	IDS_COMPILEPLUGIN,
	IDC_RENDER_LOD,
	IDS_RESTARTSETTINGS,
	IDM_SPLINE_LINEAR_EX,
	IDS_INIT_PLUGIN	= 13972,

	DELME_IDS_SERIAL_NETWORK,
	IDC_CAPS_PHONG,

	R_PLUGIN,
	IDS_CM_GROUP_PLUGINS,

	IDS_OMANAGER_PLUGINTAGS,
	IDS_OMANAGER_PLUGINTRACKS,
	IDS_MISSINGFILE,
	IDS_MATERIAL_BITMAPS,
	IDS_MATERIAL_SHADER,

	EMPTY,
	IDM_OSTICKTAG,
	IDS_STICKHELP,

	R_STICKTAGDLG,
	IDC_STICKTAG_ACTIVE,
	IDC_STICKTAG_RECORD,
	IDC_STICKTAG_RESET,

	IDS_PLUGINNOTFOUND,

	R_MACPREFS,
	IDC_MAC_SWITCHCTRLCMD,
	IDC_MAC_MENUTITLE,
	IDC_SCHEME,
	IDS_GUILOOK_STANDARD,

	IDS_COPYCHANNEL,
	IDS_PASTECHANNEL,

	IDS_PLUGINOBJECT,

	R_TEXTURESEQUENCE,
	IDC_STEXTURE_MORPH,

	IDS_FILTER3D_XML,

	IDM_KEYFRAMING_CUSTOM = 16000,
	IDM_KEYFRAMING_DEFAULT,
	DELME_IDM_KEYFRAMING_EDIT,

	DELME_IDM_UMEDIUM,
	DELME_IDS_NETTITLE,

	IDS_SELECTMATERIAL,

	IDS_REG_TITLE,
	DELME_IDS_REG_AMBERSN,
	IDS_REG_BODYPAINT,
	IDS_REG_NAME,
	IDS_REG_COMPANY_EX,
	IDS_REG_STREET_EX,
	IDS_REG_CITY_EX,
	IDS_REG_COUNTRY_EX,


	IDS_REG_SERIALNUMBER_EX,
	IDS_REG_WRONG_EX,
	IDS_REG_OK_EX,
	IDS_REG_EXPIRED_EX,
	IDS_REG_PERSONAL_EX,
	IDS_REG_IN_PROGRESS_EX,
	IDS_REG_NETCONFLICT_EX,
	IDS_BPTITLE,
	IDC_TABLETT_HIRES,

	R_RAYRADIOSITY,
	IDC_GI_ENABLEDIFFUSE,
	IDC_GI_ENABLEBLURRY,
	IDC_GI_MAXDIFFUSEDEPTH,
	IDC_GI_MAXBLURRYDEPTH,
	IDC_GI_MONTECARLOSAMPLES,
	IDC_GI_ACCURACY,
	IDC_GI_MINRESOLUTION,
	IDC_GI_MAXRESOLUTION,
	IDC_GI_STRENGTH,
	IDC_CS_ENABLECAUSTICS,
	IDC_CS_ENABLEVOLUMECAUSTICS,
	IDC_CS_STEPSIZE,
	IDC_CS_SAMPLERADIUS,
	IDC_CS_ACCURACY,
	IDC_CS_STRENGTH,
	IDC_GI_RECOMPUTE,
	IDC_GI_SAVESOLUTION,
	IDC_MX_ENHANCED,
	IDC_MATERIALTAB_ENHANCED,


	IDC_MAT_GI_RECEIVE,
	IDC_MAT_GI_GENERATE,
	IDC_MAT_CS_RECEIVE,
	IDC_MAT_CS_GENERATE,
	IDC_MAT_CS_SAMPLERADIUS,
	IDC_MAT_CS_ACCURACY,
	IDC_MAT_GI_GNSTRENGTH,
	IDC_MAT_GI_RCSTRENGTH,
	IDC_MAT_GI_RDISPERSION,
	IDC_MAT_GI_RMINSAMPLES,
	IDC_MAT_GI_RMAXSAMPLES,
	IDC_MAT_GI_RACCURACY,
	IDC_MAT_GI_TDISPERSION,
	IDC_MAT_GI_TMINSAMPLES,
	IDC_MAT_GI_TMAXSAMPLES,
	IDC_MAT_GI_TACCURACY,

	IDC_LI_CS_ENABLE,
	IDC_LI_CS_ENERGY,
	IDC_LI_CS_PHOTONS,
	IDC_LI_VCS_ENABLE,
	IDC_LI_VCS_ENERGY,
	IDC_LI_VCS_PHOTONS,
	IDC_LI_CS_FALLOFFENABLE,
	IDC_LI_CS_FALLOFF,
	IDC_LI_CS_INNER,
	IDC_LI_CS_OUTER,
	R_LIGHTILLUM,
	IDC_GI_PREPASS,

	IDS_EDITPARAMS,
	IDS_EDITIMAGE,
	IDS_EDITTIMING,
	IDS_PICSEARCH,
	IDS_PICNOAPP,
	IDC_AAFILTER,
	IDC_RAYOPT_AAMINLEVEL,
	IDC_RAYOPT_AAMAXLEVEL,
	IDC_RAYOPT_AAOBJECT,
	IDC_RAYOPT_AATHRESHOLD,
	IDC_COMPOSITING_AACTRL,
	IDC_COMPOSITING_AAMIN,
	IDC_COMPOSITING_AAMAX,
	IDC_MAT_CS_RCSTRENGTH,
	IDC_MAT_CS_GNSTRENGTH,
	IDC_LI_VCS_RAYLENGTH,
	IDS_ARTTITLE,

	IDC_MATERIAL_PMALPHA,
	IDC_RAYOPT_DITHERING,

	IDS_OUTWINDOW_CHANNELS,
	IDM_OUTWINDOW_SCANLINE_EX,
	IDS_OUTWINDOW_COMPONENTS,

	IDC_COMPOSITING_RADIOSITY,
	IDC_COMPOSITING_ACCURACY,

	R_RAYANTIALIAS,

	R_RAYMULTICHANNEL,
	IDC_RAYMULTI_ENABLE,
	IDC_RAYMULTI_LISTVIEW1,
	IDC_RAYMULTI_BITDEPTH,
	IDC_RAYMULTI_LIGHTS,
	IDC_RAYMULTI_GROUP,
	IDC_RAYMULTI_SAVEFORMAT,
	IDC_RAYMULTI_SAVEOPTIONS,
	IDC_RAYMULTI_SAVECHANNELS,
	IDC_RAYMULTI_SAVEONEFILE,
	IDC_RAYMULTI_GROUP1,
	IDC_RAYMULTI_GROUP2,
	IDC_RAYMULTI_GROUP3,
	IDC_RAYSAVE_ENABLE,
	IDC_RAYSAVE_BITS,

	IDC_LISTVIEW1,
	IDC_TAB,
	IDC_ANTISTUFE_2,
	IDC_AAFILTER_2,
	IDS_RENDERINGPREPASS,

	R_RAYCAUSTICS,
	IDC_CS_RECOMPUTE,
	IDC_CS_SAVESOLUTION,

	IDC_GI_GROUP1,
	IDC_CS_GROUP1,

	IDC_RAYMULTI_SAVEFILE,
	IDC_RAYMULTI_SAVECHOOSE,
	IDC_RAYMULTI_LIGHTMODE,
	IDC_RAYMULTI_SAVEDEPTH,
	IDC_RAYMULTI_POPUPMENU,


	R_RAYBLENDCHANNELS,
	R_RAYSPECIALCHANNEL,
	IDC_RSC_GROUPID,

	R_MULTIPASSMANAGER,
	M_MULTIPASSMANAGER,
	IDM_MULTIPASSMANAGER,
	IDM_SINGLECHANNEL_EX,

	IDC_LI_SEPARATEPASS,

	IDC_COMPOSITING_ENABLE0,
	IDC_COMPOSITING_ENABLE1,
	IDC_COMPOSITING_ENABLE2,
	IDC_COMPOSITING_ENABLE3,
	IDC_COMPOSITING_ENABLE4,
	IDC_COMPOSITING_ENABLE5,
	IDC_COMPOSITING_NUM0,
	IDC_COMPOSITING_NUM1,
	IDC_COMPOSITING_NUM2,
	IDC_COMPOSITING_NUM3,
	IDC_COMPOSITING_NUM4,
	IDC_COMPOSITING_NUM5,
	R_RLA,
	R_RPF,
	IDC_RLA_Z,
	IDC_RLA_OBJECTBUFFER,
	IDC_RLA_UV,
	IDC_RLA_NORMAL,
	IDC_RLA_ORIGCOLOR,
	IDC_RLA_COVERAGE,
	IDC_RPF_Z,
	IDC_RPF_OBJECTBUFFER,
	IDC_RPF_UV,
	IDC_RPF_NORMAL,
	IDC_RPF_ORIGCOLOR,
	IDC_RPF_COVERAGE,
	IDC_RPF_OBJECTID,
	IDC_RPF_COLOR,
	IDC_RPF_TRANSPARENCY,
	IDC_RPF_SUBPIXEL_WEIGHT,
	IDC_RPF_SUBPIXEL_MASK,
	IDC_POSTEFFECTS_ENABLE,
	IDC_POSTEFFECTS_XGROUP,
	IDC_POSTEFFECTS_POPUPMENU,
	IDC_POSTEFFECTS_GROUP,
	IDC_POSTEFFECTS_LISTVIEW1,
	IDC_POSTEFFECTS_TAB,
	IDC_POSTEFFECTS_SMBSUB,
	IDC_POSTEFFECTS_SMBSTRENGTH,
	IDC_POSTEFFECTS_SMBDITHER,
	IDC_POSTEFFECTS_OMBSTRENGTH,
	IDC_POSTEFFECTS_FILTERSTRENGTH,
	IDC_POSTEFFECTS_EXTERNALPATH,
	IDC_POSTEFFECTS_EXTERNALCHOOSER,
	IDC_POSTEFFECTS_GROUP0,
	IDC_POSTEFFECTS_GROUP1,
	IDC_POSTEFFECTS_GROUP2,
	IDC_POSTEFFECTS_GROUP3,
	IDC_POSTEFFECTS_GROUP4,
	IDC_POSTEFFECTS_GROUP5,
	IDC_POSTEFFECTS_GROUP6,
	IDC_POSTEFFECTS_GAMMA,
	IDC_POSTEFFECTS_CONTRAST,
	IDC_MATERIAL_BRIGHTNESS,
	IDC_COMIC_ILLUMINATION,
	IDC_COMIC_OUTLINE,
	IDC_COMIC_EDGES,
	IDC_COMIC_EDGECOLOR,
	IDC_COMIC_BACKCOLOR,
	IDC_COMIC_COLOR,
	IDM_FLUSHSOLUTIONS,
	IDC_COMPOSITING_THRESHOLD,
	IDC_RAYMULTI_SUFFIX,
	IDC_AAMIPGLOBAL,
	IDC_COMPOSITING_GI,


	IDC_MAT_DIFFUSE_FALLOFF,
	IDC_MAT_SPECULAR_FALLOFF,
	IDC_MAT_SHADINGMODEL,
	IDC_MAT_SHADINGMODEL_VAL,
	IDC_MAT_SHADINGMODEL_INTENS,


	R_OUTWIN_SAVE,
	IDM_STOPTAG,
	IDS_OM_STOPTAG,

	IDS_OUTWINDOW_LAYER,
	IDS_OUTWINDOW_ALPHA,
	IDS_OUTWINDOW_IMAGE,
	IDS_MULTIPASS_ONECHANNEL,
	IDS_MULTIPASS_ADDIMAGELAYER,
	IDS_MULTIPASS_ADDMATERIAL,
	IDS_MULTIPASS_ADDALL,
	IDS_MULTIPASS_REMOVESELECTED,
	IDS_MULTIPASS_REMOVEALL,
	IDS_POSTEFFECT_REMOVESELECTED,
	IDS_POSTEFFECT_REMOVEALL,
	IDS_MULTIPASS_BLEND,
	IDS_MULTIPASS_OBJECT,
	IDS_MULTIPASS_BLENDCH,
	IDS_MULTIPASS_OBJECTBUFFER,
	IDS_RENDERSETTINGS_TITLE_IS_DEPRECATED,


	IDS_RENDERERROR_GLOBALILLU,
	IDS_RENDERERROR_CAUSTICS,

	IDS_MULTIPASS_RGBA,
	IDS_MULTIPASS_DIFFUSE,
	IDS_MULTIPASS_SPECUALR,
	IDS_MULTIPASS_SHADOW,
	IDS_MULTIPASS_ATMOSPHERE,
	IDS_MULTIPASS_ATMOSPHERE_MULTIPLY,
	IDS_MULTIPASS_AMBIENT,
	IDS_MULTIPASS_CAUSTICS,
	IDS_MULTIPASS_RADIOSITY,
	IDS_MULTIPASS_REFLECTION,
	IDS_MULTIPASS_TRANSPARENCY,
	IDS_MULTIPASS_ILLUMINATION,
	IDS_MULTIPASS_MATERIAL_COLOR,
	IDS_MULTIPASS_MATERIAL_LUMINANCE,
	IDS_MULTIPASS_MATERIAL_TRANSPARENCY,
	IDS_MULTIPASS_MATERIAL_REFLECTION,
	IDS_MULTIPASS_MATERIAL_ENVIRONMENT,
	IDS_MULTIPASS_MATERIAL_SPECULAR_COLOR,
	IDS_MULTIPASS_MATERIAL_DIFFUSION,
	IDS_MULTIPASS_MATERIAL_SPECULAR,
	IDS_MULTIPASS_OBJECTBUFFER_NAME,
	IDS_MULTIPASS_BLEND_NAME,
	IDS_MULTIPASS_DEPTH,
	IDS_MULTIPASS_UNKNOWN,
	IDS_MULTIPASS_LIGHT_NAME,
	IDS_MULTIPASS_BLEND_LAYER,
	IDS_MULTIPASS_OBJECT_LAYER,

	IDS_PAINT_ALPHACHANNELNAME,


	IDS_POSTEFFECT_DEPTH_OF_FIELD,
	IDS_POSTEFFECT_LENS_EFFECTS,
	IDS_POSTEFFECT_OBJECT_GLOW,
	IDS_POSTEFFECT_COLOR_CORRECTION,
	IDS_POSTEFFECT_COMIC_RENDERER,
	IDS_POSTEFFECT_SCENE_MOTION_BLUR,
	IDS_POSTEFFECT_OBJECT_MOTION_BLUR,
	IDS_POSTEFFECT_SOFT_FILTER,
	IDS_POSTEFFECT_SHARPEN_FILTER,
	IDS_POSTEFFECT_MEDIAN_FILTER,
	IDS_POSTEFFECT_REMOTE,

	IDM_OUTWIN_SAVEAS,
	IDS_OUTWIN_ZOOM,
	IDS_OUTWIN_SIZE,

	R_POSTEFFECT_SMB,
	R_POSTEFFECT_OMB,
	R_POSTEFFECT_FILTER,
	R_POSTEFFECT_COMIC,
	R_POSTEFFECT_EXTERNAL,
	R_POSTEFFECT_CORRECTION,

	IDC_MAT_SPECULAR_BLOWOUT,

	IDC_POSTEFFECTS_MOVEUP,
	IDC_POSTEFFECTS_MOVEDOWN,

	IDC_MULTIPASS_MOVEUP,
	IDC_MULTIPASS_MOVEDOWN,

	IDC_GI_CAMERASOLUTION_EX,
	IDC_CS_CAMERASOLUTION,

	IDC_COMIC_QUANTIZE,
	IDC_COMIC_QUANTIZELEVEL,
	EX_IDS_FILENAMETOOLONG,

	IDS_NAME_BACKGROUND,
	IDS_NAME_LAYER,
	IDS_NAME_SELECTION,
	IDS_NAME_ALPHA,

	IDC_RAYMULTI_SHADOWCORRECTION,

	IDS_STUDENTVERSION,
	IDC_GI_STOCHASTIC,
	IDC_MAT_GI_SATURATION,

	R_MORPHSEQUENCE_EX,
	IDC_MORPHSEQUENCE_CUBIC,
	IDC_RAYSAVE_PROJECT,
	IDC_RAYSAVE_PROJECTSAVE,
	IDS_AFXFILE1,
	IDS_AFXFILE2,

	IDM_MATERIALSHOWACTIVE,
	IDM_SELECTMATFROMOBJECT,
	IDM_LINKOBJECTTOMATERIAL,

	IDS_MISSINGPLUGINS,
	IDS_MISSINGPLUGINS1,
	IDS_MISSINGPLUGINS2,

	IDS_OVERWRITEOLDVERSION,
	R_PSD,
	IDC_PSD_PS7,

	IDS_ANCHORTAG,
	IDS_PROTECTIONTAG,
	IDS_PHONGTAG,
	IDS_MOTIONBLURTAG,
	IDS_WWWTAG,
	IDS_STOPTAG,
	IDS_COMPOSITINGTAG,
	IDS_DISPLAYTAG,
	IDS_TEXTURETAG,
	IDS_COFFEEEXPRESSIONTAG,
	IDS_FIXEXPRESSIONTAG,
	IDS_IKEXPRESSIONTAG,
	IDS_SUNEXPRESSIONTAG,
	IDS_KINEMATICTAG,
	IDS_METABALLTAG,
	IDS_POINTSELECTIONTAG,
	IDS_POLYSELECTIONTAG,
	IDS_RESTRICTIONTAG,
	IDS_STICKTEXTURETAG,
	IDS_UVWTAG,
	IDS_BAKEPARTICLETAG,
	IDS_VERTEXMAPTAG,
	IDS_TARGETEXPRESSIONTAG,

	M_FCURVE,
	R_FCURVE,
	DELME_IDM_FC_FRAMEALL,
	DELME_IDM_FC_FRAMESELECTED,
	DELME_IDM_FC_SNAP,
	IDM_FCURVE,
	IDS_FCURVE_EDIT,
	IDS_FCURVE_VIEW,
	IDS_FCURVE_CURVES,
	IDS_FCURVE_TANGENTS,
	IDS_FCURVE_FUNCTION,
	IDS_TITLE_FCURVE,
	DELME_IDM_FC_EASEIN,
	DELME_IDM_FC_EASEOUT,
	DELME_IDM_FC_EASYEASE,
	DELME_IDM_FC_HOLD,
	DELME_IDM_FC_AUTO,
	DELME_IDM_FC_RESET,
	M_FCURVE_POPUP1,
	DELME_IDM_STIME,
	DELME_IDM_SPARAMETER,
	DELME_IDM_ARRANGE_MODE,
	// Depreciated, do not reuse these IDs
	// IDM_EDGES,
	R_MODELING_CONVERTSELECTION = 16352,
	IDC_CONVERTSELECTION_LEFT,
	IDC_CONVERTSELECTION_RIGHT,
	IDC_CONVERTSELECTION_TOLERANT,
	IDC_CONVERTSELECTION_LEFT_1,
	IDC_CONVERTSELECTION_LEFT_2,
	IDC_CONVERTSELECTION_LEFT_3,
	IDC_CONVERTSELECTION_LEFT_4,
// see below related enumerator IDC_CONVERTSELECTION_LEFT_5,
// see below related enumerator IDC_CONVERTSELECTION_LEFT_6,
	IDC_CONVERTSELECTION_RIGHT_1,
	IDC_CONVERTSELECTION_RIGHT_2,
	IDC_CONVERTSELECTION_RIGHT_3,
	IDC_CONVERTSELECTION_RIGHT_4,
// see below related enumerator IDC_CONVERTSELECTION_RIGHT_5,
// see below related enumerator IDC_CONVERTSELECTION_RIGHT_6,
	M_MODELING_EDGE,
	IDS_EDGESELECTION,
	IDS_EDGESELECTIONTAG,
	HOTKEY_WEIGHTSDS,
	HOTKEY_TIMEWARP,
	M_VIEWPOPUP,
	IDM_SELECTALLTEXTURETAGS,

	IDC_SDSWEIGHT_MODE,
	IDC_SDSWEIGHT_STRENGTH,
	IDC_SDSWEIGHT_INTERACTIVEMIN,
	IDC_SDSWEIGHT_INTERACTIVEMAX,
	IDC_SDSWEIGHT_SET,

	DELME_IDM_MAXONNEWS,
	IDM_MAXONSUPPORT,
	DELME_IDM_MAXONPLUGINS,
	DELME_IDM_MAXONRESOURCES,

	IDS_MAXONONLINE,
	DELME_IDS_HTMLMAIN,
	DELME_IDS_HTMLNEWS,
	IDS_HTMLSUPPORT,
	IDS_HTMLSUPPORTBP,
	IDS_HTMLPLUGINS,
	IDS_HTMLRESOURCES,
	IDS_SP2P,
	IDM_SELECTCHILDS,
	DELME_IDM_UO,
	DELME_IDM_SHOWANIMATED,
	IDM_SOUNDONOFF,

	R_SELECTDLG,
	IDC_SELECTDLG_C1,
	IDC_SELECTDLG_C2,
	IDC_SELECTDLG_C3,
	IDC_SELECTDLG_C4,
	IDC_SELECTDLG_C5,
	DELME_IDC_SELECTDLG_C6,
	IDC_SELECTDLG_C7,
	IDC_SELECTDLG_C8,
	IDC_SELECTDLG_C9,
	IDC_SELECTDLG_C10,
	IDC_SELECTDLG_C11,
	IDC_SELECTDLG_C12,
	IDC_SELECTDLG_T1,
	IDC_SELECTDLG_T2,
	IDC_SELECTDLG_T3,
	IDC_SELECTDLG_T4,
	IDC_SELECTDLG_T5,
	IDC_SELECTDLG_T6,
	IDC_SELECTDLG_T7,
	IDC_SELECTDLG_T8,
	IDC_SELECTDLG_T9,
	IDC_SELECTDLG_T10,
	IDC_SELECTDLG_T11,
	IDC_SELECTDLG_T12,
	IDC_SELECTDLG_T13,
	IDC_SELECTDLG_T14,
	IDC_SELECTDLG_T15,
	IDC_SELECTDLG_T16_IS_DEPRECATED,
	IDC_SELECTDLG_T17,
	IDC_SELECTDLG_T18,
	IDC_SELECTDLG_T19,
	IDC_RESTRICTTOACTIVE,
	IDC_SELECTDLG_TAB,
	IDC_SELECTDLG_TAB_OBJECTS,
	IDC_SELECTDLG_TAB_TAGS,
	IDS_TIMELINE_KEYFRAME,
	IDS_SELECTIONFILTER,
	IDM_SHOWINTIMELINE,
	IDS_DISPLAYFILTER,
	DELME_IDM_TL_REMOVE_OBJECT,
	DELME_IDM_TL_REMOVE_ALL,

	IDS_SMOMIX,

	DELME_IDM_FC_CLAMP,
	DELME_IDM_TL_VECTOR,
	IDS_DESC_ANIM,
	IDS_DESC_ADDKEYFRAME,
	IDS_DESC_DELETEKEYFRAME,
	IDS_DESC_NEXTKEYFRAME,
	IDS_DESC_PREVKEYFRAME,
	IDS_DESC_ADDTRACK,
	IDS_DESC_DELTRACK,
	IDS_DESC_COPYTRACK,
	IDS_DESC_PASTETRACK,
	IDS_DESC_SHOWTRACK,
	IDS_DESC_SHOWFCURVE,
	IDS_DESC_SETDRIVER,
	IDS_DESC_SETDRIVEN_ABS,
	IDS_DESC_SETDRIVEN_REL,
	IDS_DESC_ADDKEYFRAMESELECTION,
	IDS_DESC_REMOVEKEYFRAMESELECTION,
	IDS_DESC_CLEARKEYFRAMESELECTION,
	IDS_DESC_USERINTERFACE,
	IDS_DESC_SHOWSUBCHANNELS,
	IDS_DESC_COPY,
	IDS_DESC_PASTE,
	IDS_DESC_PASTEIDENTICAL,
	IDS_DESC_SELECTALL,
	IDS_DESC_DESELECTALL,
	IDS_DESC_EDITENTRY,
	IDS_DESC_REMOVEENTRY,
	IDS_DESC_LOADDATA,
	IDS_DESC_SAVEDATA,
	IDS_DESC_NOELEMENTS,
	IDS_DESC_NOELEMENTS2,

	IDS_BASELIST_USERDATA,

	IDS_ROOTSTRING1,
	IDS_ROOTSTRING2,
	IDS_ROOTSTRING3,
	IDS_ROOTSTRING4,
	IDS_ROOTSTRING5,
	IDS_ROOTSTRING6,
	IDS_ROOTSTRING7,
	IDS_ROOTSTRING8,
	IDS_ROOTSTRING9,
	IDS_ROOTSTRING10,
	IDS_ROOTSTRING11,
	IDS_SELECTTOOL,
	IDS_ACTIVEELEMENTS,
	IDS_CATEGORY1,
	IDS_CATEGORY2,
	IDS_CATEGORY3,
	IDS_CATEGORY4,
	IDS_CATEGORY5,
	IDS_CATEGORY6,
	IDS_CATEGORY7,
	IDS_CATEGORY8,
	IDS_CATEGORY9,
	IDS_CATEGORY10,
	IDS_CATEGORY11,
	IDS_CATEGORY12,
	IDS_CREATESELECTIONOBJECT,
	IDS_TIMETRACK,
	IDS_DRIVEROBJECT,
	IDS_SOUNDSTEREO,
	IDS_SOUNDMONO,
	IDS_ANIMATINGPARTICLES,
	IDS_FCURVEADDFOLDER,
	IDS_FCURVEREMOVE,
	IDS_FCURVEFOLDER,
	IDS_FCURVE,
	IDS_EDITSHADER,
	IDS_TEXGROUP_IMAGE,
	IDS_TEXGROUP_SAMPLING,
	IDS_TEXGROUP_SAMPLING_NONE,
	IDS_TEXGROUP_SAMPLING_CIRCLE,
	IDS_TEXGROUP_SAMPLING_SQUARE,
	IDS_TEXGROUP_SAMPLING_ALIAS,
	IDS_TEXGROUP_SAMPLING_MIP,
	IDS_TEXGROUP_SAMPLING_SAT,
	IDS_TEXGROUP_OFFSET,
	IDS_TEXGROUP_SCALE,
	IDS_TEXGROUP_EDIT,
	IDS_EDITSPLINEPARAMETER,

	IDS_DATATYPE_STRING,
	IDS_DATATYPE_MULTISTRING,
	IDS_DATATYPE_STATICTEXT,
	IDS_DATATYPE_INTEGER,
	IDS_DATATYPE_INTEGERSLIDER,
	IDS_DATATYPE_BOOL,
	IDS_DATATYPE_FLOAT,
	IDS_DATATYPE_FLOATSLIDER,
	IDS_DATATYPE_FLOATSLIDERONLY,
	IDS_DATATYPE_VECTOR,
	IDS_DATATYPE_MATRIX,
	IDS_DATATYPE_COLOR,
	IDS_DATATYPE_LINK,
	IDS_DATATYPE_FILENAME,
	IDS_DATATYPE_LENSGLOW,
	IDS_DATATYPE_TEXGROUP,
	IDS_DATATYPE_TEXNAME,
	IDS_DATATYPE_OBJDESC,
	IDS_DATATYPE_DESCID,
	IDS_TRACKUNKNOWN,

	DLG_PREFS_INTERFACE_1,
	IDS_PREFS_INTERFACE,

	DLG_PREFS_INTERFACE_COLOR,
	IDS_PREFS_COLOR,

	IDS_AM_MODE_TIMELINE,
	IDS_AM_MODE_FCURVE,

	IDC_EXTRUDE_BEVEL,
	IDC_EXTRUDE_EDGEANGLE,
	IDC_EXTRUDE_SNAPVALUE,
	IDC_EXTRUDE_SNAP,

	IDM_KEYFRAMING_LINKGENERATION,
	IDM_SHOWFCURVES,
	IDS_RESTRICTEDITORSELECTION,

	R_TANGENTS,
	IDC_TANGENTS_LINK,
	IDC_TANGENTS_INTERPOLATION,
	IDC_TANGENTS_STRENGTH,
	IDC_TANGENTS_CLAMP,

	IDM_CM_GROUPWINDOW,

	DLG_PREFS_INTERFACE_COLORS,
	IDC_IC_MODE,
	IDC_IC_LIST,
	IDC_IC_MODE_RGB,
	IDC_IC_MODE_BMP,
	IDC_IC_MODE_REF,
	IDC_IC_REFLIST,
	IDC_IC_BMPLIST,

	IDS_COLOR_BG														,
	IDS_COLOR_BGEDIT												,
	IDS_COLOR_BGFOCUS												,
	IDS_COLOR_TEXT													,
	IDS_COLOR_TEXTFOCUS											,
	IDS_COLOR_EDGELT												,
	IDS_COLOR_EDGEWH												,
	IDS_COLOR_EDGEDK												,
	IDS_COLOR_EDGEBL												,
	IDS_COLOR_EMBOSS_WH											,
	IDS_COLOR_EMBOSS_DK											,
	IDS_COLOR_DBARFG1_IS_DEPRECATED					,
	IDS_COLOR_DBARBG1_IS_DEPRECATED					,
	IDS_COLOR_DBARFG2_IS_DEPRECATED					,
	IDS_COLOR_DBARBG2_IS_DEPRECATED					,
	IDS_COLOR_BGGADGET											,
	IDS_COLOR_BGSELECTEDTEXT								,
	IDS_COLOR_FGSELECTEDTEXT								,
	IDS_COLOR_TIMELINE_IS_DEPRECATED				,
	IDS_COLOR_BGTRISTATE										,
	IDS_COLOR_BG_DARK1											,
	IDS_COLOR_BG_DARK2											,
	IDS_COLOR_TIMELINE_BG_IS_DEPRECATED										,
	IDS_COLOR_TIMELINE_BG_DARK_IS_DEPRECATED							,
	IDS_COLOR_TIMELINE_TEXT_IS_DEPRECATED									,
	IDS_COLOR_TIMELINE_TEXT_SELECTED_IS_DEPRECATED				,
	IDS_COLOR_TIMELINE_TEXT_SELECTED2_IS_DEPRECATED				,
	IDS_COLOR_TIMELINE_LINES_IS_DEPRECATED								,
	IDS_COLOR_TIMELINE_LINES_SEL_IS_DEPRECATED						,
	IDS_COLOR_TIMELINE_LINES_SEPARATOR1_IS_DEPRECATED			,
	IDS_COLOR_TIMELINE_LINES_SEPARATOR2_IS_DEPRECATED			,
	IDS_COLOR_TIMELINE_TREE_IS_DEPRECATED									,
	IDS_COLOR_TIMELINE_LOOP_IS_DEPRECATED									,
	IDS_COLOR_TIMELINE_SELECTION_IS_DEPRECATED						,
	IDS_COLOR_TIMELINE_TICKS1_IS_DEPRECATED								,
	IDS_COLOR_TIMELINE_TICKS2_IS_DEPRECATED								,
	IDS_COLOR_TIMELINESCROLLER_MINMAX_IS_DEPRECATED				,
	IDS_COLOR_TIMELINESCROLLER_CURRENT_IS_DEPRECATED			,
	IDS_COLOR_BROWSER_LINES_SELECTED_IS_DEPRECATED				,
	IDS_COLOR_FCURVE_BG_IS_DEPRECATED											,
	IDS_COLOR_FCURVE_TEXT_IS_DEPRECATED										,
	IDS_COLOR_FCURVE_LINES_IS_DEPRECATED									,
	IDS_COLOR_FCURVE_MAINGRID_IS_DEPRECATED								,
	IDS_COLOR_FCURVE_SUBGRID_IS_DEPRECATED								,
	IDS_COLOR_FCURVE_LLTGRAY_IS_DEPRECATED								,
	IDS_COLOR_FCURVE_GRAY1_IS_DEPRECATED									,
	IDS_COLOR_FCURVE_GRAY2_IS_DEPRECATED									,
	IDS_COLOR_FCURVE_GRAY3_IS_DEPRECATED									,
	IDS_COLOR_FCURVE_POINTSELECTED_IS_DEPRECATED					,
	IDS_COLOR_MATERIALMANAGER_BG						,
	IDS_COLOR_MATERIALMANAGER_TEXT					,
	IDS_COLOR_MATERIALMANAGER_TEXT_SELECTED	,
	IDS_COLOR_MATERIALMANAGER_SELECTED			,
	IDS_COLOR_OBJECTMANAGER_BG_IS_DEPRECATED,
	IDS_COLOR_OBJECTMANAGER_ACTIVECAMERA_IS_DEPRECATED		,
	IDS_COLOR_OBJECTMANAGER_INACTIVECAMERA_IS_DEPRECATED	,
	IDS_COLOR_OBJECTMANAGER_TEXT_IS_DEPRECATED						,
	IDS_COLOR_OBJECTMANAGER_TEXT_ACTIVE_IS_DEPRECATED			,
	IDS_COLOR_OBJECTMANAGER_TEXT_ACTIVE2_IS_DEPRECATED		,
	IDS_COLOR_OBJECTMANAGER_SELECTEDTAG_IS_DEPRECATED			,
	IDS_COLOR_OBJECTMANAGER_TREE_IS_DEPRECATED						,
	IDS_COLOR_SPREADSHEET_BG								,
	IDS_COLOR_SPREADSHEET_TEXT							,
	IDS_COLOR_SPREADSHEET_EDITBG						,
	IDS_COLOR_SPREADSHEET_EDITTEXT					,
	IDS_COLOR_SPREADSHEET_SELECTED					,
	IDS_COLOR_CONSOLE_BG										,
	IDS_COLOR_CONSOLE_TEXT									,
	IDS_COLOR_PAINTER_SELECTED							,
	IDS_COLOR_PAINTER_TREE									,
	IDS_COLOR_SYNTAX_COFFEE									,
	IDS_COLOR_SYNTAX_INCLUDE								,
	IDS_COLOR_SYNTAX_COMMENT								,
	IDS_COLOR_SYNTAX_COMMENTWRONG						,
	IDS_COLOR_SYNTAX_STRING									,

	IDS_COLOR_TEXT_SELECTED									,
	IDS_COLOR_TEXT_SELECTED_DARK						,
	IDS_COLOR_TEXT_DISABLED									,
	IDS_COLOR_TEXT_EDIT											,
	IDS_COLOR_TEXT_EDIT_DISABLED						,
	IDS_COLOR_TEXT_MENU											,
	IDS_COLOR_TEXT_MENU_DISABLED						,
	IDS_COLOR_TEXT_TAB											,
	IDS_COLOR_TEXT_TAB_DISABLED							,
	IDS_COLOR_TEXT_BUTTON										,
	IDS_COLOR_TEXT_BUTTON_DISABLED					,
	IDS_COLOR_TEXT_COMBO										,
	IDS_COLOR_TEXT_COMBO_DISABLED						,
	IDS_COL_3D,

	IDS_COLOR_MENU_BG												,
	IDS_COLOR_MENU_BG_SELECTED							,
	IDS_COLOR_MENU_TEXT											,
	IDS_COLOR_MENU_TEXT_SELECTED						,
	IDS_COLOR_MENU_TEXT_DISABLED						,
	IDS_COLOR_MENU_BORDER_WH								,
	IDS_COLOR_MENU_BORDER_DK								,

	DELME_IDM_FC_CURVELIST,
	DELME_IDM_LINK_OMANAGER,
	GV_DATA_TYPE_UNDEFINED_STRING						,
	GV_VALUE_TYPE_UNDEFINED_STRING					,
	IDS_DATATYPE_BASETIME,
	IDS_DATATYPE_TEXTURE,

	DELME_IDM_FC_REMOVEALL,
	IDS_PREFS_COMMON,

	DLG_PREFS_COMMON,
	SUBDLG_GENERAL,
	IDC_LINKMANAGER,
	DELME_IDC_SAVELAYOUTATEND,
	IDC_GFXTABLET,
	IDC_USEHIRES,
	DELME_IDC_REALTIMESPINNER,
	DELME_IDC_REALTIMEMANAGER,
	DELME_IDC_REWINDSCENE,
	IDC_CPUCOUNT,
	IDS_CATEGORYALL,
	IDS_CATEGORYNONE,
	IDS_PATTERNINSCHEME,
	IDS_SCHEMEERROR1,
	IDS_SCHEMEERROR2,
	IDS_SCHEMEERROR3,

	IDS_COLOR_TIMELINE_LAYER0_IS_DEPRECATED,
	IDS_COLOR_TIMELINE_LAYER1_IS_DEPRECATED,
	IDS_COLOR_TIMELINE_LAYER2_IS_DEPRECATED,
	IDS_COLOR_TIMELINE_LAYER3_IS_DEPRECATED,
	IDS_COLOR_TIMELINE_LAYER4_IS_DEPRECATED,
	IDS_COLOR_TIMELINE_LAYER5_IS_DEPRECATED,
	IDS_COLOR_TIMELINE_LAYER6_IS_DEPRECATED,
	IDS_COLOR_TIMELINE_LAYER7_IS_DEPRECATED,

	DELME_IDM_TL_AUTOMODE,
	DELME_IDM_FC_AUTOMODE,

	IDS_TIMELINE_FILTER,
	DELME_IDM_TLFILTER_SHOWANIMATED,
	DELME_IDM_TLFILTER_SHOWACTIVE,
	DELME_IDM_TLFILTER_SHOWALL,
	DELME_IDM_TLFILTER_SHOWOBJECTS,
	DELME_IDM_TLFILTER_SHOWMATERIALS,
	DELME_IDM_TLFILTER_SHOWRENDERSETTINGS,
	DELME_IDM_TLFILTER_SHOWBRANCHES,
	DELME_IDM_TLFILTER_SHOWPOSITIONTRACKS,
	DELME_IDM_TLFILTER_SHOWSCALETRACKS,
	DELME_IDM_TLFILTER_SHOWROTATIONTRACKS,
	DELME_IDM_TLFILTER_SHOWOTHERTRACKS,

	IDS_PARAMTRACK,
	IDS_POPUPSELECT,
	IDS_TLNAME_TAG,
	IDS_TLNAME_MATERIAL,
	IDS_TLNAME_SHADER,
	IDS_TLNAME_VIDEOPOST,

	DELME_IDM_LOCK,

	IDC_TANGENTS_NAAM,

	IDS_RESTRICTKEYFRAMERECORDING,

	IDC_GI_LOCKTOSCREEN,
	IDC_MATERIAL_EXCLUSIVE,
	IDM_BREAKPHONG,
	IDM_UNBREAKPHONG,
	IDM_PHONGTOSELECTION,
	IDS_NORMALTAG,
	IDC_PREV_SIZE,
	IDC_SELECTDLG_TNN,

	DELME_IDM_NEWMATGROUP,
	DELME_IDM_DELMATGROUP,

	IDS_CREATENEWTEXTURE,
	IDM_LOADTEXTURES,
	IDM_UNLOADTEXTURES,

	IDS_CM_COLORTABLE_ENHANCED,
	IDS_CM_RGB_COLOR,
	IDS_CM_HSV_COLOR,
	IDS_CM_XHSV360,
	IDS_CM_XHSV100,
	IDS_CM_XHSV255,
	IDS_CM_XHSV65535,

	IDS_CM_SHOWQUICKSTORAGE,
	IDS_CM_MIXINGPANEL,
	IDS_MULTIPASS_POSTEFFECTS,
	IDS_MATMAN_TEXTURE,
	DELME_IDM_MATERIAL_SHOWLIST,
	IDM_MATERIAL_LEFTLIST_NO,
	IDM_MATERIAL_LEFTLIST_SMALL,
	IDM_MATERIAL_LEFTLIST_MEDIUM,
	IDM_MATERIAL_LEFTLIST_LARGE,
	IDS_MATERIAL_CHANNELS,
	IDM_MATERIAL_COLOR,
	IDM_MATERIAL_DIFFUSION,
	IDM_MATERIAL_LUMINANCE,
	IDM_MATERIAL_TRANSPARENCY,
	IDM_MATERIAL_REFLECTION,
	IDM_MATERIAL_ENVIRONMENT,
	IDM_MATERIAL_BUMP,
	IDM_MATERIAL_ALPHA,
	IDM_MATERIAL_SPECULARCOLOR,
	IDM_MATERIAL_DISPLACEMENT,
	DELME_IDM_MATERIAL_SHOWTEXTURES,

	IDS_SHADER_COLOR,
	IDS_SHADER_BITMAP,
	IDS_POPUPCLEAR,
	IDS_POPUPLOADIMAGE,
	IDS_NOBITMAP,
	IDS_POPUPEDIT,

	IDS_STR_MATERIALGROUP,
	IDS_STR_BITMAPINFO,
	IDS_STR_DISABLEMATERIALS,
	IDS_NAME_LAYERSET,
	IDM_MATERIAL_NORMAL,
	IDM_MATERIAL_CUSTOM,

	IDM_SHOWINMOTION,
	IDM_CONNECTANDDELETE,

	IDC_SELECTDLG_C13,

	IDS_SHADER_XMB_SUBSURFACE,
	IDS_SHADER_XMB_REFLECTION,
	IDS_SHADER_XMB_ENVIORMENT,

	M_CMIP_DYNAMIC,
	M_CMIP_DYNAMIC_OFF,
	M_CMIP_DYNAMIC_DOCMODE,
	M_CMIP_DYNAMIC_ACTIVETOOL,
	M_CMIP_DYNAMIC_SELECTEDTYPE,
	M_CMIP_DYNAMIC_SCRIPT,
	M_CMIP_COPYPALETTE,
	M_CMIP_PASTEPALETTE,
	M_CMIP_CLEARPALETTE,

	IDS_DISPLAYFILTER_DEFAULT,
	IDS_DISPLAYFILTER_GEOMETRY_ONLY,

	IDM_OUTWINDOW_COPY_EX = 300001019,
	IDM_OUTWINDOW_PASTE_EX = 300001020,
	IDM_MATERIAL_CUT = 300001021,
	IDM_MATERIAL_COPY = 300001022,
	IDM_MATERIAL_PASTE = 300001023,
	IDM_MATERIAL_DELETE = 300001024,
	IDM_MATERIAL_SELECTALL = 300001025,
	IDM_MATERIAL_SELECTNONE = 300001026,
	IDM_SPREADSHEET_CUT = 300001027,
	IDM_SPREADSHEET_COPY = 300001028,
	IDM_SPREADSHEET_PASTE = 300001029,
	IDM_SPREADSHEET_DELETE = 300001030,
	IDM_SPREADSHEET_SELECTALL = 300001031,
	IDM_SPREADSHEET_SELECTNONE = 300001032,
	IDM_SPREADSHEET_INVERSION = 300001033,
	DLG_PREFS_RENDERER = 300001058,

	IDS_DESC_XPRESSIONS,

	IDM_TEXT_GOTOLINE,
	IDM_TEXT_FIND,
	IDM_TEXT_SELECTALL,

	IDS_REG_DAYSLEFT,

	IDM_RAYTRACING_TR,

	IDS_EDITOR_PHOENIX,
	IDS_SUBMENU_PHOENIX_SELECT,
	IDS_SUBMENU_PHOENIX_CONSTRAINTS,

	IDM_TEXT_SELECTNONE,
	IDS_TRACKENABLE,
	IDS_TRACKDISABLE,
	IDS_SUBMENU_PHOENIX_2D_TRACK_COMMANDS,
	IDS_SUBMENU_PHOENIX_VIEW,
	IDS_SUBMENU_PHOENIX_VIEW_GRID,
	IDS_SUBMENU_PHOENIX_FRAME,

	IDS_DESC_ADDOVERRIDE,
	IDS_DESC_REMOVEOVERRIDE,

	IDS_EDITOR_PIPELINE,

	IDS_SUBMENU_PHOENIX_NUDGE,
	IDS_VERTEXCOLORTAG,

	IDS_POSTEFFECT_DEMO_WATERMARK,
	IDS_ADD_TRACK_MODIFIER_TAG,
	// disabled
	// IDS_POSTEFFECT_BLOOM, // This was added in CL 292812 and broke the IDs from below.

	// Convert Selection dialog (continued)
	IDC_CONVERTSELECTION_LEFT_5 = 300001081,
	IDC_CONVERTSELECTION_LEFT_6,
	IDC_CONVERTSELECTION_RIGHT_5,
	IDC_CONVERTSELECTION_RIGHT_6,

	DELME_IDS_EDITOR_GPU_PREVIEW,
	DELME_IDM_GPU_USEASPREVIEW = 300001086,
	DELME_IDM_GPU_STARTPREVIEW,
	DELME_IDM_GPU_STARTPREVIEWINMARKED,
	DELME_IDM_GPU_USEOFFLINESETTINGS,
	DELME_IDM_GPU_USEPREVIEWSETTINGS,
	DELME_IDM_GPU_CAMERAUPDATES,
	DELME_IDM_GPU_MATERIALUPDATES,
	DELME_IDM_GPU_LIGHTUPDATES,
	DELME_IDM_GPU_GEOMETRYUPDATES,
	DELME_IDM_GPU_SYNCVIEWPORT,
	DELME_IDS_GPU_BASESHADER_PREVIEW,

	IDM_SEND_TO_PV,
	IDS_CPU_BASESHADER_PREVIEW,

	IDS_MULTIPASS_AOV,
	IDS_MULTIPASS_AOVBUFFER_NAME,
	IDS_MULTIPASS_AOVBUFFER_LAYER,
	IDS_MULTIPASS_AOVBUFFER,

	IDS_HOUDINI_ENGINE_EX,

	IDS_CAPSANDBEVEL_PRESET,
  IDS_SUBSTANCE_ENGINE,
	IDS_MULTIPASS_REFLECTANCE_ALBEDO,

	IDS_MULTIPASS_MAGICBULLETLOOKS,

	IDC_MODELING_GROWSELECTIONS,
	IDC_GROWSELECTIONS_USEEDGE,

	IDS_CONSOLE_ADVANCED,

	IDM_TOGGLETOOL,

	IDS_DISPLAYFILTER_PRESET,
	IDS_DISPLAYFILTER_PRESETS,
	IDS_PREFS_UVCOLOR,

	IDS_GOZ_BRIDGE,
	IDM_SEND_TO_MBL,
	IDS_USD_BRIDGE,
	
	IDS_COLOR_HORIZONTAL_SEPARATOR,
	IDS_DISPLAYFILTER_GEOMETRY_ONLY_PLAYBACK,
	IDS_CLICK_TO_EDIT_ALL_ELEMENTS,
	
	IDS_DESC_SAVEDATADEFAULTS,

	IDM_FIX_COLUMN,
	IDM_FIX_ROW,

	IDS_DEFAULTPRESET_DEFAULT,
	IDS_DEFAULTPRESET_CUSTOM,
	IDS_DEFAULTPRESET_SAVE,
	IDS_DEFAULTPRESET_NOATTRIBUTES, // "No Attributes selected"

	IDS_DESC_OPENXPRESSO,
	IDS_DESC_SELECTTAGS,
	IDS_DESC_JUMPTODRIVER,
	IDS_WRONG_CAMERA_TYPE_FOR_BP3D,
	IDM_A_3D_WORKPLANE,
	IDS_EDITOR_EXPORT_CMD,

	IDS_DESC_FIELDDRIVER_SET,
	IDS_DESC_FIELDDRIVER_RESET,
	IDS_COLOR_KEYFRAMEDOT_FIELD_DRIVEN,
	IDS_FIELD_DRIVER_TAG,
	IDS_DESC_FIELDDRIVER_SELECTTAG,
	IDS_COLOR_BG_C4DHOME,

	IDS_LIB4D_DND_NOTSUPPORTED,
	HOTKEY_CAMERA_FREELOOK,
	HOTKEY_CAMERA_FORWARD,
	HOTKEY_CAMERA_BACK,
	HOTKEY_CAMERA_LEFT,
	HOTKEY_CAMERA_RIGHT,
	HOTKEY_CAMERA_UP,
	HOTKEY_CAMERA_DOWN,

	IDM_CREATE_OVERLAY_LAYOUT,
	IDM_CREATE_OVERLAY_LAYOUT_FREE,

	IDS_EDITOR_NAVSPEED,

	IDS_DEFAULTPRESET_SAVE_AS_DEFAULT,

	IDS_POPUPLOADASSET,
	IDS_POPUPSEARCHSIMILAR,

	M_MATERIAL_POPUPAEC,
	M_MATERIAL_POPUPAEC_OBJECT,
	IDM_REPLACE_MATERIAL,
	IDM_SIMILAR_MATERIAL,
	IDS_REPLACE_MATERIAL,
	IDS_REPLACE_MATERIAL_WITH,

	M_MATERIAL_FILTER_POPUPAEC,
	IDM_FILTER_SCENE,
	IDM_FILTER_SELECTION,
	IDM_FILTER_UNUSED,
	IDS_SYNCED_MATERIAL,
	IDS_TAP_TWOFINGER,
	IDS_TAP_THREEFINGER,
	IDS_TAP_FOURFINGER,

	IDS_RSV_MM_FILTER_MATERIALS,
	IDS_RSV_MM_ADD,
	IDS_RSV_MM_DELETE_SELECTED,
	IDS_RSV_MM_READ_ONLY,
	IDS_RSV_MM_CUSTOM_MATERIALS,
	IDS_RSV_MM_SYNCED_MATERIALS,

	X_LASTSYMBOL_X
};

// Please do NOT remove any deprecated symbol but mark as unused instead.
enum
{
	M_EDITOR_BP = 17000,
	M_EDITOR_USER1,
	M_EDITOR_USER2,
	M_EDITOR_USER3,
	M_EDITOR_USER4,
	M_EDITOR_USER5,

	IDM_MAINMENU_C4D,
	IDM_MAINMENU_BP,
	IDM_MAINMENU_USER1,
	IDM_MAINMENU_USER2,
	IDM_MAINMENU_USER3,
	IDM_MAINMENU_USER4,
	IDM_MAINMENU_USER5,

	IDM_MM_MATERIAL_ONLY,
	IDM_MM_MATERIAL_LIST_ONLY,
	IDM_MM_LAYERS_COMPACT,
	IDM_MM_LAYERS_EXPANDED,
	IDM_MM_LAYERS_EXPANDED2,
	IDM_MM_LAYERS_ACTIVE,

	IDS_COLOR_BG_MM_ACTIVE_BITMAP,
	IDS_COLOR_FG_MM_ACTIVE_BITMAP,
	IDS_COLOR_BG_MM_CURRENT_BITMAP,
	IDS_COLOR_FG_MM_CURRENT_BITMAP,
	IDC_REVERSEORBIT,
	DELME_IDC_DESCRIPTIONLIMIT,

	IDS_COLOR_BG_MM_E_ACTIVE_TEXTURE				,
	IDS_COLOR_FG_MM_E_ACTIVE_TEXTURE				,
	IDS_COLOR_BG_MM_E_INACTIVE_TEXTURE			,
	IDS_COLOR_FG_MM_E_INACTIVE_TEXTURE			,
	IDS_COLOR_BG_MM_E_SELECTED_LAYER				,
	IDS_COLOR_FG_MM_E_SELECTED_LAYER				,
	IDS_COLOR_BG_MM_E_ACTIVE_LAYER					,
	IDS_COLOR_FG_MM_E_ACTIVE_LAYER					,
	IDS_COLOR_BG_MM_E_INACTIVE_LAYER				,
	IDS_COLOR_FG_MM_E_INACTIVE_LAYER				,
	UNUSED_IDS_COLOR_FG_MM_C_ACTIVE_LAYER_ACT_TEX	,
	UNUSED_IDS_COLOR_FG_MM_C_ACTIVE_LAYER_INACT_TEX,
	IDS_COLOR_BG_TEXTUREVIEW								,
	// Depreciated, do not reuse these IDs
	// IDM_UVEDIT_POINTS,
	// IDM_UVEDIT_POLYGONS,

	IDM_UVEDIT_MAGNET = 17040,
	IDM_UVEDIT_SCALE,
	IDM_UVEDIT_SHEAR,
	IDM_UVEDIT_TAPER,

	IDS_TLTIMETRACK,
	IDS_GROUPWINDOW,
	IDS_PAPPLY,

	IDS_TVIEW_CANVAS,

	IDS_TVIEW_UVTAGS,
	IDS_TVIEW_TTAGS,
	IDS_TVIEW_OBJECTS,

	IDS_BRUSH_GENERIC,
	IDS_BRUSH_BITMAP,
	IDS_BRUSH_ADDPRESET,
	IDS_BRUSH_STORECOLOR,

	IDS_CSC_CHANNELS,
	IDS_CSC_BLENDING,
	IDS_CSC_COLOR,
	IDS_CSC_WALLPAPER,
	IDS_STARTUPLAYOUT,
	IDS_WORKINGPATH,
	IDS_MMAN_ALL,
	IDS_MMAN_OTHER,
	IDS_PWIZ_WARNING,
	IDS_PWIZ_SCALE,
	IDS_PWIZ_CACHE,
	IDS_PWIZ_CREATE,
	IDS_PWIZ_REMOVE,
	IDS_PWIZ_MAT,
	IDS_PWIZ_AUTO,
	IDS_PWIZ_LOCKED,
	IDS_PWIZ_UVS,
	IDS_PWIZ_UVS2,
	IDS_PWIZ_START,
	IDS_PWIZ_END,
	IDS_PWIZ_OMODE,
	IDS_PWIZ_MMODE,

	IDS_KEY_MMIDDLE,
	IDS_KEY_MX1,
	IDS_KEY_MX2,

	IDS_CAMERAMAP,

	IDS_LAYERSET_EDIT,
	IDS_LAYERSET_CLEAR,

	DLG_PM_RENDEREXTERNAL,
	IDC_PM_IMAGEFN,
	IDC_PM_WIDTH,
	IDC_PM_HEIGHT,
	IDC_PM_SAVEALPHA,
	IDC_PM_STRAIGHT,
	IDC_PM_SELECTEDOBJECTS,
	IDC_PM_STARTPS,
	IDC_PM_PSPATH,
	IDC_PM_ANIM,
	IDC_PM_ANIMGROUP,
	IDC_PM_ANIMFROM,
	IDC_PM_ANIMTO,

	IDS_DATATYPE_SHADER,

	IDS_DEFAULTFILENAME_SURFACES,
	IDS_DEFAULTFILENAME_EFFECTS,
	IDS_DEFAULTFILENAME_VOLUME,

	DELME_IDC_STACKEDMATERIALS,
	DELME_IDM_STACKEDMATERIALS,

	DELME_IDM_CAMERAROTATE,

	IDC_RAYOPT_USELOD,
	IDS_COLOR_OBJECTMANAGER_TEXT_ACTIVE3_IS_DEPRECATED,

	IDM_A_GOURAUD_WIREISO,
	IDM_A_FLATSHADING,
	IDM_A_QUICK_WIREISO,
	IDM_A_HIDDENLINE,
	IDC_SELECTLIVE_RADIUS_PEN_PRESSURE,
	IDC_VERTEXPAINT_RADIUS_PEN_PRESSURE,
	IDC_VERTEXPAINT_STRENGTH_PEN_PRESSURE,

	IDM_M_NGON,
	IDC_EXTRUDE_SUBDIVISION,
	IDC_EXTRUDE_CREATEQUADS,
	IDC_SELECTLIVE_TOL_EDGE,
	IDC_EXTRUDEINNER_SUBDIVISION,
	IDC_EXTRUDEINNER_SUBDIV_CHK,
	IDC_BEVEL_SUBDIVISION,
	IDC_BEVEL_SUBDIV_CHK,
	IDC_SMOOTHSHIFT_VARIANCE,
	IDC_SMOOTHSHIFT_SUBDIVISION,
	IDC_SMOOTHSHIFT_SUBDIV_CHK,
	IDS_DESC_SHOWHELP,

	IDM_CM_SHOWWINDOWTITLE_IS_DEPRECATED,
	IDM_CM_HIDECONTENT,

	IDS_DESC_ADDTOHUD,
	IDC_SUBPIXELLIMIT,
	IDS_PREPDISPLACEMENT,

	IDS_VIEWSETTINGS,

	DELME_R_MODELING_PSR,
	IDC_AXIS_MODE,
	IDC_AXIS_AUTO_FREE,
	IDC_AXIS_BOUNDS_X,
	IDC_AXIS_BOUNDS_Y,
	IDC_AXIS_BOUNDS_Z,

	HOTKEY_MODELINGAXIS1,
	HOTKEY_MODELINGAXIS2,

	IDM_DOPTIONEN_ALL,

	IDS_PROJECTION_PERSPECTIVE,
	IDS_PROJECTION_PARALLEL,
	IDS_PROJECTION_LEFT,
	IDS_PROJECTION_RIGHT,
	IDS_PROJECTION_FRONT,
	IDS_PROJECTION_BACK,
	IDS_PROJECTION_TOP,
	IDS_PROJECTION_BOTTOM,
	IDS_PROJECTION_MILITARY,
	IDS_PROJECTION_FROG,
	IDS_PROJECTION_BIRD,
	IDS_PROJECTION_GENTLEMAN,
	IDS_PROJECTION_ISOMETRIC,
	IDS_PROJECTION_DIMETRIC,

	IDS_DESC_MAKEGLOBAL,
	IDS_DESC_MAKELOCAL,

	IDS_TAGMENU,
	IDC_RAYOPT_SHOWHUD,
	IDC_RAYOPT_CACHESHADOWMAPS,

	IDC_SOFT_SELECTION,
	IDC_SOFT_RUBBER,
	IDC_SOFT_FALLOFF,
	IDC_SOFT_RADIUS,
	IDC_SOFT_STRENGTH,
	IDC_SOFT_CENTER,
	IDC_SOFT_GROUP,
	IDC_SOFT_SURFACE,
	IDC_SOFT_WIDTH,
	IDC_SOFT_SPLINE_ARROW,
	IDC_SOFT_SPLINE,

	HOTKEY_MODELINGAXIS3,
	IDS_HLP_MAGNIFY,
	IDS_HLP_SPLINEFREEHAND,
	IDS_HLP_SPLINECREATEOUTLINE,
	IDS_HLP_SPLINECHAMFER,
	IDS_HLP_SPLINECROSSSECTION,
	IDS_HLP_SPLINEBEZIER,
	IDS_HLP_SPLINEBSPLINE,
	IDS_HLP_SPLINECUBIC,
	IDS_HLP_SPLINEAKIMA,
	IDS_HLP_SPLINELINEAR,
	IDS_HLP_MIRROR,
	IDS_SAVEALL,

	IDS_AM_TOOLMODE,
	IDS_SOFTWARE_MODE,
	IDC_RAYSAVE_PROJECTTYPE,

	IDS_NETSERVERTITLE,
	IDS_NETCLIENTTITLE,
	IDC_RAYSAVE_PROJECTLOCAL,

	IDS_GLWARNING,
	IDC_UNTRIANGULATE_NGON,
	IDM_SHOWONLINEHELP,
	IDC_UNTRIANGULATE_ANGLE_EDIT,

	IDM_SNAPPING_POPUP,
	M_MODELING_SNAP,
	IDS_COLOR_SYNTAX_CONSTANT,
	IDS_COLOR_SYNTAX_FUNCTION,
	IDS_COLOR_SYNTAX_CLASS,
	IDS_COLOR_SYNTAX_MEMBER,

	IDS_SELECT_FONT,
	IDM_FREEFORM_EX,
	IDS_HTMLFREEFORM,

	IDM_A_FLATSHADING_WIREISO,

	IDS_8BPC,
	IDS_16BPC,
	IDS_32BPC,

	IDS_MULTIPASS_MATERIAL_AMBIENTOCCLUSION,

	IDS_RETRY,
	IDS_ABORT,
	IDS_IGNORE,
	IDS_YES_R,
	IDS_NO_R,

	R_RAYAO,
	R_RAYAOFLUSH,

	RAYAMBIENTOCCLUSIONSHADER_MINLENGTH,
	RAYAMBIENTOCCLUSIONSHADER_MAXLENGTH,
	RAYAMBIENTOCCLUSIONSHADER_DISPERSION,
	RAYAMBIENTOCCLUSIONSHADER_MINSAMPLES,
	RAYAMBIENTOCCLUSIONSHADER_MAXSAMPLES,
	RAYAMBIENTOCCLUSIONSHADER_CONTRAST,
	RAYAMBIENTOCCLUSIONSHADER_ENVIRONMENT,
	RAYAMBIENTOCCLUSIONSHADER_ACCURACY,
	RAYAMBIENTOCCLUSIONSHADER_GRADIENT,
	RAYAMBIENTOCCLUSIONSHADER_TRANSPARENCY,
	RAYAMBIENTOCCLUSIONSHADER_SELFTEST,

	IDC_GI_ADAPTIVESAMPLES,
	IDC_GI_PRECISIONSAMPLES,
	IDC_GI_SHOWDIFFUSEILLUMINATION,
	IDC_RAYOPT_GLOBALBRIGHTNESS,
	IDC_RAYOPT_ENABLESPD,
	IDC_RAYAO_APPLYAMBIENTOCCLUSION,

	IDS_COLOR_CTIMELINE_GRID,
	IDS_COLOR_CTIMELINE_POSITION,
	IDS_COLOR_CTIMELINE_ROTATION,
	IDS_COLOR_CTIMELINE_SCALE,
	IDS_COLOR_CTIMELINE_GENERAL,
	IDS_COLOR_CTIMELINE_CURRENTFRAME,
	IDS_COLOR_CTIMELINE_PREVIEW,
	IDS_COLOR_CTIMELINE_FCX,
	IDS_COLOR_CTIMELINE_FCY,
	IDS_COLOR_CTIMELINE_FCZ,
	IDS_COLOR_CTIMELINE_FCGENERAL,
	IDS_COLOR_CTIMELINE_SELECTION,
	IDS_COLOR_CTIMELINE_MARKER,
	IDS_COLOR_CTIMELINE_TIMEAREA,
	IDS_COLOR_CTIMELINE_BG,
	IDS_COLOR_CTIMELINE_LINEMAIN,
	IDS_COLOR_CTIMELINE_LINESUB,
	IDS_COLOR_CTIMELINE_GREY,

	IDS_MULTIPASS_MATERIAL_NORMAL,
	IDS_MULTIPASS_MATERIAL_UV,

	IDC_RAYMULTI_STRAIGHT,
	IDS_PREFS_ONLINEHELP,

	DLG_PREFS_ONLINEHELP,
	DELME_IDC_ONLINEHELP_MODE,
	IDC_ONLINEHELP_PATH,
	DELME_IDC_ONLINEHELP_URL,

	IDS_COLOR_DBARBG3,
	IDS_SCRIPTS,
	IDM_PM_ENABLE,
	IDM_PM_DISABLE,

	IDS_PROJECTIONLAYER,

	IDS_PM_UNASSIGNEDOBJECTS,
	IDS_PM_ANYCHANNEL,
	IDS_PM_LINKCAMERATOVIEW,
	IDS_PM_RENAMECAMERA,
	IDS_PM_UNPROTECTCAMERA,
	IDS_PM_PROTECTCAMERA,
	IDS_PM_DUPLICATECAMERA,
	IDS_PM_PROTECTIONTESTEDITOR,
	IDS_PM_PROTECTIONTESTFILE,
	IDS_PM_COVERAGERENDEREDITOR,
	IDS_PM_COVERAGERENDERFILE,
	IDS_PM_NEWCAMERA,
	IDS_PM_REMOVE,
	IDS_PM_EDITLAYERSET,
	IDS_PM_NOIMAGE,
	IDS_PM_TITLE,
	IDS_PM_NAME,
	IDS_PM_LAYERSET,
	IDS_PM_PMAT,
	DELME_IDS_PM_CHOOSELUM,
	DELME_IDS_PM_CHOOSEALPHA,
	IDS_PM_SELECTOBJECT,
	IDS_PM_ASSIGN,
	IDS_PM_ALLOBJECTS,
	IDS_PM_SELECTIMAGE,
	IDS_PM_CAM,
	IDS_PM_DELETE,
	IDS_PM_TESTRENDER,

	IDS_MESSAGEDIALOG_BUTTON_ABORT,
	IDS_MESSAGEDIALOG_BUTTON_RETRY,
	IDS_MESSAGEDIALOG_BUTTON_YES,
	IDS_MESSAGEDIALOG_BUTTON_NO,
	IDS_RELOADSCHEME,
	IDS_LAYERSETS,
	IDS_LAYERALPHA,
	IDS_LAYERMASKS,
	IDS_ALPHACHANNELS,
	IDS_SHOWLAYERCONTENT,
	IDS_CHOOSELAYERSET,
	IDS_LAYERSET_NAME,
	IDM_FULLSCREEN,
	IDS_LOAD_PLUGIN,
	IDS_CONFIGURE_WEBBROWSER,
	IDS_CONFIGURE_IMAGEEDITTOOL,

	IDM_MAINWINDOW_FLAG,
	DELME_IDM_COLORCORRECTION,

	IDS_TEXTURE_CONTROL,
	IDS_PICTURE_CONTROL,
	IDS_EXPOSURE,
	IDS_RESET,
	IDS_GAMMA,
	IDS_BLACKPOINT,
	IDS_WHITEPOINT,
	IDS_COLOR_CORRECTION,
	IDS_COLOR_CORRECTION_HELP,
	IDC_VIEWGAMMA,
	IDC_RENDERGAMMA,
	IDS_CONVERTBITMAP,
	IDS_CC_ENABLE,

	IDS_COLOR_CONTENTBROWSER_TEXT_IS_DEPRECATED,
	IDS_COLOR_BROWSER_BACKGROUND_SELECTED_LARGE,
	IDS_COLOR_CONTENTBROWSER_BG_TEXT_INACT_IS_DEPRECATED,
	IDS_COLOR_BROWSER_TEXT_SELECTED,
	IDS_COLOR_CONTENTBROWSER_FG_TEXT_INACT_IS_DEPRECATED,

	IDS_NOTAHOLLYWOODBUNDLE,
	IDS_RGBDISPLAY,
	IDS_GRAYDISPLAY,
	IDS_LOADRENDERPRESET,
	IDS_SAVERENDERPRESET,
	OBSOLETE_IDS_LOADMATERIALPRESET,
	OBSOLETE_IDS_SAVEMATERIALPRESET,
	OBSOLETE_IDS_LOADOBJECTPRESET,
	OBSOLETE_IDS_SAVEOBJECTPRESET,
	OBSOLETE_IDS_LOADSHADERPRESET,
	OBSOLETE_IDS_SAVESHADERPRESET,
	OBSOLETE_IDS_LOADTAGPRESET,
	OBSOLETE_IDS_SAVETAGPRESET,
	LOADVIDEOPOSTPRESET,
	SAVEVIDEOPOSTPRESET,

	IDS_COLOR_CONTENTBROWSER_NOTAVAILABLE_IS_DEPRECATED,
	IDS_LAYERSETS_ALPHA,
	IDC_SWEEPOBJECT_STARTGROWTH,
	IDC_RAYSAVE_PROJECTDATA,

	IDS_MULTIPASS_MOTIONVECTOR,
	IDC_RENDERMOTIONLENGTH,

	DELME_IDS_BUGREPORT01,
	DELME_IDS_BUGREPORT02,
	DELME_IDS_BUGREPORT03a,
	DELME_IDS_BUGREPORT03b,
	DELME_IDS_BUGREPORT04,

	IDS_ERRORSENDMAIL,
	IDS_MAILBETAREPORTS,
	IDS_MAILREPORTS,
	DELME_IDS_AUTOCONVERTBP_PRESETS,
	IDC_ALLOWBUGREPORTS,
	IDS_LAYERNAME,

	IDS_NEWTL_M_FILE,
	IDS_NEWTL_M_EDIT,
	IDS_NEWTL_M_SELECTION,
	IDS_NEWTL_M_LAYER,
	IDS_NEWTL_M_MARKER,
	IDS_NEWTL_M_VIEW,
	IDS_NEWTL_M_PREVIEW,
	IDS_NEWTL_M_ICONSIZE,
	IDS_NEWTL_M_FRAMEVIEW,
	IDS_NEWTL_M_FRKEY,
	IDS_NEWTL_M_FRMARKER,
	IDS_NEWTL_M_OBJECTSTRACKS,
	IDS_NEWTL_M_OBJECTS,
	IDS_NEWTL_M_CURVES,
	IDS_NEWTL_M_PLAYBACK,
	IDS_NEWTL_M_GRID,
	IDS_NEWTL_M_KEY,
	IDS_NEWTL_M_FUNCTIONS,
	IDS_NEWTL_M_KEYSTTINGS,
	IDS_NEWTL_M_KEYINTERPOLATION,
	IDS_NEWTL_M_KEYINTERSPLINE,
	IDS_NEWTL_M_LOOP,
	IDS_NEWTL_M_BOOKMARK,

	M_CMIP_SHOWLOGO,

	IDS_COLOR_SB_BG1,
	IDS_COLOR_SB_BG2,
	IDS_COLOR_SB_TREE1,
	IDS_COLOR_SB_TREE2,
	IDS_COLOR_SB_TEXT,
	IDS_COLOR_SB_TEXT_BORDER,
	IDS_COLOR_SB_TEXT_ACTIVE1,
	IDS_COLOR_SB_TEXT_ACTIVE2,
	IDS_COLOR_SB_TEXT_FOLDER_MAIN,
	IDS_COLOR_SB_TEXT_FOLDER_SUB,
	IDS_COLOR_SB_LAYER_BORDER,

	IDS_COLOR_MENU_BG_ICON,
	IDS_COLOR_BG_PALETTE,

	IDS_DELETE_TAG,
	DELME_CMD_TIMELINESCROLL2,

	IDS_UVTAG,

	IDS_COLOR_POWERFRAME,
	IDS_COLOR_POWERFRAMEDRAG,
	IDS_COLOR_POWERFRAMEMARKER,
	IDS_COLOR_POWERKEYUNSELECTED,
	IDS_COLOR_POWERKEYSELECTED,
	IDS_COLOR_POWERBG,
	IDS_COLOR_POWEREDGE,
	IDS_COLOR_POWERLOOP,
	IDS_COLOR_POWERSELECTED,
	IDS_COLOR_POWERSLIDEBG,
	IDS_COLOR_POWERSLIDEHANDLES,
	IDS_COLOR_POWERBGDRAG,
	IDS_COLOR_POWERHANDLEDRAG,
	IDS_COLOR_POWERKEYP,
	IDS_COLOR_POWERKEYS,
	IDS_COLOR_POWERKEYR,
	IDS_MMAN_UNASSIGNED,

	IDC_TANGENTS_MUTE,
	IDC_TANGENTS_LINK_O,
	IDC_TANGENTS_LINK_L,
	IDC_TANGENTS_LOCK_O,
	IDC_TANGENTS_LOCK_L,
	IDC_TANGENTS_AUTO_O,
	IDC_TANGENTS_AUTO_L,
	IDC_TANGENTS_ZERO_O,
	IDC_TANGENTS_ZERO_L,

	IDM_A_HQ_VIEWPORT,
	IDM_A_HQ_VIEWPORT_TRANSP,
	IDM_A_HQ_VIEWPORT_SHADOWS,
	IDM_A_HQ_VIEWPORT_POST_EFFECTS,
	IDM_A_LAYERCOLOR,

	IDS_COLOR_CTIMELINE_GRIDTEXT,
	IDS_COLOR_CTIMELINE_GRIDTEXTSUB,
	IDS_COLOR_CTIMELINE_SELECTION2,
	IDS_COLOR_CTIMELINE_HIGHLIGHT,
	IDS_COLOR_CTIMELINE_REGIONAREA,
	IDS_COLOR_CTIMELINE_BGOUTSIDE,
	IDS_COLOR_CTIMELINE_BGPREVIEW,
	IDS_COLOR_CTIMELINE_MASTERGREY,
	IDS_COLOR_CTIMELINE_TEXTCOLOR,
	IDS_COLOR_CTIMELINE_CURSORINDICATOR,
	IDS_COLOR_SB_TEXTHG1,
	IDS_COLOR_SB_TEXTHG2,
	IDS_COLOR_CTIMELINE_MARKERTEXT_IS_DEPRECATED,
	IDS_COLOR_CTIMELINE_FCHIGHLIGHT,
	IDS_COLOR_CTIMELINE_FCKEY,
	IDS_COLOR_CTIMELINE_FCSELECTION,
	IDS_COLOR_CTIMELINE_SNAPSHOT,
	IDS_COLOR_CTIMELINE_TANGENT,
	IDS_COLOR_CTIMELINE_TANGENT2,
	IDS_COLOR_CTIMELINE_SEQUENCE,
	IDS_COLOR_CTIMELINE_KEYSYMBOLS,


	IDS_COLOR_TEXT_TAB_ACTIVE,
	IDS_COLOR_QUICKTAB_BORDER,
	IDS_COLOR_QUICKTAB_BG_INACTIVE,
	IDS_COLOR_QUICKTAB_BG_ACTIVE,
	IDS_COLOR_QUICKTAB_TEXT_INACTIVE,
	IDS_COLOR_QUICKTAB_TEXT_ACTIVE,
	IDS_COLOR_QUICKBAR_TEXT,
	IDS_COLOR_QUICKBAR_BG,
	IDS_COLOR_QUICKBAR_TEXT2,
	IDS_COLOR_QUICKBAR_BG2,
	IDS_COLOR_ICONS_BG_ACTIVE,
	IDS_COLOR_BORDER_PALETTE,
	IDS_COLOR_PALETTE_TEXT,
	IDS_COLOR_PALETTE_TEXT_SELECTED,
	IDS_COLOR_PALETTE_TEXT_DISABLED,
	IDS_COLOR_PALETTE_SEPARATOR,

	IDS_PIN_HELP1,
	IDS_PIN_HELP2,
	IDS_ERRORLOAD_TEXTURE,

	IDS_MOREMANAGER_IS_DEPRECATED,
	IDS_TEXTNAME_LOADING,

	IDS_RENDER_AS_EDITOR_OFF_IS_DEPRECATED,
	IDS_RENDER_AS_EDITOR_SOFTWARE_IS_DEPRECATED,
	IDS_RENDER_AS_EDITOR_HARDWARE_IS_DEPRECATED,
	IDS_RENDER_AS_EDITOR_HARDWARE_GLSL_IS_DEPRECATED,

	IDS_EDITOR_CA,
	IDS_OLDBONES,
	IDS_MOCCACONVERSION,
	IDS_CENTERAXIS,
	IDS_REG_PASTE,

	IDS_SUBMENU_SKY,
	DELME_IDS_SUBMENU_WALKTHROUGH,
	IDS_SUBMENU_TP,
	DEPRECATED_IDS_SUBMENU_SPACEMOUSE,

	IDS_COLOR_BORDER_ACTIVE_1,
	IDS_COLOR_BORDER_ACTIVE_3,
	IDS_COLOR_BORDER_ACTIVE_4,
	IDC_DEFKEY_INTERPOLATION,
	IDC_DEFKEY_NAAM,
	IDC_DEFKEY_MUTE,
	IDC_DEFKEY_CLAMP,
	IDC_DEFKEY_BREK,
	IDC_DEFKEY_AUT,
	IDC_DEFKEY_LOCK_O,
	IDC_DEFKEY_LOCK_L,
	IDC_DEFKEY_LOCK_V,
	IDC_DEFKEY_LOCK_T,
	IDC_DEFKEY_ZERO_O,
	IDC_DEFKEY_ZERO_L,

	IDS_SB_FILE,
	IDS_SB_EDIT,
	IDS_SB_SHOW,
	IDS_SB_BOOKMARKS,
	OBSOLETE_IDS_SB_LOADOBJECTPRESET,
	OBSOLETE_IDS_SB_LOADTAGPRESET,
	IDS_SB_ICONSIZE,
	IDS_SB_FOLDING,
	IDS_SB_OBJECTS,
	IDS_SB_RESTORESELECTION,
	IDS_SB_OBJECTDISPLAY,
	IDS_SB_TAGS,
	IDS_SB_BOOK,
	IDS_COLOR_MENU_BG_BORDER,

	IDS_MM_NEWLAYER,
	IDS_MM_REMOVE,
	IDS_MM_LAYERS,
	IDS_MM_ADDTOLAYER,

	IDS_PRINT_HELP,
	IDS_CATEGORY13,

	IDS_LAYERDISABLED,
	IDS_PM_CHOOSE,

	IDS_BUGREPORT_TITLE,
	IDS_BUGREPORT_APP,
	IDS_BUGREPORT_NAME,
	IDS_BUGREPORT_EMAIL,
	IDS_BUGREPORT_DESCRIPTION,
	IDS_BUGREPORT_SCENES,
	IDS_BUGREPORT_GENERAL,
	IDS_BUGREPORT_DONTSEND,
	IDS_BUGREPORT_SEND,
	IDS_BUGREPORT_SENDING,
	IDS_BUGREPORT_SUCCESS,
	IDS_BUGREPORT_FAILED,

	IDS_FORCE_QUIT,
	IDM_MATERIAL_ONELINELAYERS,

	IDS_NEWTL_M_SNAPSHOTSWAP,
	IDS_NEWTL_M_SNAPSHOTMAKE,
	IDS_NEWTL_M_SNAPSHOTON,
	IDS_NEWTL_M_AFTER,
	IDS_NEWTL_M_BEFORE,

	IDS_COLOR_CTIMELINE_BREAKDOWN,
	IDS_COLOR_CTIMELINE_HLECURVE,
	IDS_NEWTL_M_HLECURVEMODE,

	IDS_UPDATERTITLE,
	IDS_DESC_RESETTODEFAULT,
	IDS_JPG_SETTINGS,
	IDS_JPG_QUALITY,
	IDS_JPG_QUALITY1,
	IDS_JPG_QUALITY2,
	IDS_JPG_QUALITY3,
	IDS_JPG_QUALITY4,

	IDS_CAMERASETTINGS,
	IDM_A_HQ_VIEWPORT_NOISES,
	IDM_LOCK_LAYOUT,
	IDS_EMAILCHECK,
	IDS_DATATYPE_INTEGER_CYCLE,
	IDS_MENU_LASTTOOLS,

	IDS_ROOTSTRING12,

	IDS_COLOR_CTIMELINE_CLIPTEXT,
	IDS_COLOR_CTIMELINE_CLIP,
	IDS_COLOR_CTIMELINE_CLIPMASTER,

	IDS_NEWTL_M_MOTION,

	UNUSED_DLG_CACHING,
	UNUSED_IDC_CACHE_STOP,

	IDS_ONION_MEM_INFO1,
	IDS_COLOR_BG_GROUP1_IS_DEPRECATED,
	IDS_COLOR_BG_GROUP2_IS_DEPRECATED,
	IDS_COLOR_POWERSOUND,
	IDS_COLOR_BG_GROUPBAR1_IS_DEPRECATED,
	IDS_COLOR_BG_GROUPBAR2_IS_DEPRECATED,

	IDS_ONION_PROGRESS,

	IDS_FILTERTIFFPSD,
	IDS_FILTERTIFFB3D,
	IDC_RAYOPT_GIREFLECTIVE,
	IDC_RAYOPT_GIREFRACTIVE,
	IDS_NEWTL_M_SHOWMENU,
	IDS_NEWTL_M_HIDEMENU,
	IDS_NEWTL_M_LINK,
	IDS_NEWTL_M_BAR,
	IDS_NEWTL_M_ADD,

	IDS_MOTION_SYSTEM,

	IDM_EDIT_SCRIPT,
	IDS_DESC_CREATESCRIPT,

	IDS_AM_RDATAMODE,

	IDS_DESC_INHERIT,
	IDS_DESC_DONTINHERIT,
	IDS_ROOTSTRING13,
	IDS_CALCBLURRYCACHE,

	IDC_RENDERLOGFILE,
	IDC_RENDERCONVERTGI,
	IDS_PREFS_RENDERER,
	IDS_MENU_DOODLE,

	IDS_COLOR_BUBBLE_BG,
	IDS_COLOR_BUBBLE_FG,
	IDS_COLOR_BUBBLE_BORDER,

	IDS_CONSTRAINTS,

	IDS_RM_PASS,
	IDS_RM_ENGINE,
	IDS_RM_ENGINE_AR,
	IDS_RM_ENGINE_SOFT_IS_DEPRECATED,
	IDS_RM_ENGINE_OPENGL,
	IDS_RM_ENGINE_ENHANCED,

	IDS_RM_EDITORRES,
	IDS_RM_CUSTOM,
	IDS_RM_PRESET,
	IDS_RM_PIXEL,
	IDS_RM_CAT_SCREEN,
	IDS_RM_CAT_WEB_IS_DEPRECATED,
	IDS_RM_CAT_FILM,
	IDS_RM_CAT_PRINT,

	IDC_PREFSSTORAGE,
	IDC_PREFSSTORAGE_SHOWFOLDER,

	IDS_LICENSE_NOAVAILABLE_EX,
	IDS_LICENSE_NOSERIAL_EX,
	IDS_REG_LOCALREG_EX,
	IDS_REG_LICSERV_EX,
	IDS_REG_SERVADDR_EX,
	IDS_REG_SERVPORT_EX,
	IDS_REG_ERROR_EX,
	IDS_REG_NOLICAVAILABLE_EX,
	IDS_REG_SERVNOTFOUND_EX,
	IDS_REG_SERVERINFO_EX,
	IDS_REG_VALID_EX,
	IDS_REG_STATE_EX,
	IDS_REG_TRYAGAIN_EX,
	IDS_REG_CLOSE_EX,
	IDS_REG_CONTINUE_EX,
	IDS_REG_EXPIRED2_EX,
	IDS_REG_AGOEXPIRED1_EX,
	IDS_REG_AGOEXPIRED2_EX,
	IDS_REG_REMAINING_EX,
	IDS_REG_NOW_EX,
	IDS_REG_WARNING1_EX,
	IDS_REG_WARNING2_EX,
	IDS_REG_WARNING3_EX,
	IDS_REG_MSG1_EX,

	IDS_USER,
	IDS_DESC_COPY_INTERFACE,
	IDS_BRUSHBITMAP,
	IDS_INLINE,
	IDS_TOOLBRUSH_HELP,
	IDS_ERRORLOADPRESET,
	IDS_ADDPRESET_SAVENAME,
	IDS_ADDPRESET_SAVELIB,
	IDS_ADDPRESET_ADD,
	IDS_ADDPRESET_STORECOLOR,
	IDS_BRUSHFILE_LOADERROR,
	IDS_LIBERROR,
	IDS_LIBERROR_MOUNT,
	IDS_LIBERROR_CREATE,
	IDS_LIB_OVERWRITE,
	IDS_BPPRESETLIBNAME,
	IDS_PRESET_REPLACE,
	IDS_LOADLIB,
	IDS_FILE_DOESNTEXISTS,
	IDS_LIB_ALREADYMOUNTED,
	IDS_LIB_ALREADYTHERE,
	IDS_COPYERROR,
	IDS_BRUSHLOAD_ERROR,
	IDS_PRESET_EXPORT,
	IDS_PRESETFOLDER_RECHOOSE,
	IDS_PAINT_NEWLIBRARY,
	IDS_PAINT_CHANGEFORMAT,
	IDS_AA_NONE,
	IDS_PRESET_OVERWRITE,
	IDS_RM_CAT_PRINT2,
	IDS_RS_CLIP,
	IDS_PRESETS_SAVE,
	IDS_LICENSE_QUIT,
	IDS_LICENSE_LEASE,
	IDS_LICENSE_SIGNOUT,

	// Dialog definitions of idd_leaselicense start here
	IDD_LEASELICENSE,
	IDC_LEASE_DAYS,
	IDC_LEASE_NEW,
	IDC_LEASE_MIN,
	IDC_LEASE_MAX,
	// Dialog definitions of idd_leaselicense end here

	IDS_NONWRITABLE,
	IDS_TOGGLE_TABLET_MODE,
	IDC_RENDERCONSOLEGI,
	IDS_MENU_WINDOW,
	IDS_MENU_WINDOW_CLOSE,
	IDS_MENU_WINDOW_MINIMIZE,
	IDS_MENU_WINDOW_ZOOM,
	IDS_MENU_WINDOW_FRONT_ALL,

	IDS_NO_UPDATER_FOUND,
	IDS_LICENSE_SERVER_REQUEST,
	IDS_LICENSE_SERVER_LEASEERROR,
	IDS_LICENSE_SERVER_ERRORFREE,
	IDS_LICENSE_LEASETIME,
	IDS_REG_NOTHING,
	IDS_LICENSE_SERVER_NOLEASE,
	IDS_LICENSE_SERVER_DEF,
	IDS_SCHEME_LIGHT_IS_DEPRECATED,
	IDS_SCHEME_DARK,
	IDS_UVMESHLAYER,
	IDS_PRESET_ERROR1,
	IDS_SELECTPATTERNFOLDER,
	IDS_LOADPATTERNERROR,
	IDS_SAVEPATTERNERROR,

	IDS_PVPENABLE,

	DLG_DEMO,
	IDC_DEMOGROUP,
	IDC_DEMOTAB1,
	IDC_DEMOACTIVATE,
	IDC_DEMOTAB2,
	IDC_DEMOCODE,
	IDC_DEMOTAB3,
	IDC_DEMOTAB4,
	IDC_DEMOEXPIRATION,
	IDC_DEMOCONTINUE1,
	IDC_DEMOCONTINUE2,
	IDC_DEMOCONTINUE3,
	IDC_DEMOCONTINUE4,

	IDS_DEMOEXPIRATION,
	IDS_DEMOACTIVATIONFAILED,
	IDS_RS_CLIPDEMO,
	IDS_SAVEPROJECT_ERR1,
	IDS_SAVEPROJECT_ERR2,
	IDS_SAVEPROJECT_ERR3,
	IDC_DEMOHTML,
	IDS_REG_LICBLOCKED,
	IDS_REG_LICMEMERR,

	IDS_LICENSEEXPIRED,
	IDS_RUNTIME,

	IDS_COLOR_CTIMELINE_CLIPTEXTHL,
	IDS_COLOR_TRACK_X,
	IDS_COLOR_TRACK_Y,
	IDS_COLOR_TRACK_Z,
	IDS_COLOR_TRACK_S,

	IDS_INSTALLERTITLE,
	IDS_PERMISSIONS_WRONG,
	IDS_PERMISSIONS_ADMIN_MSG,
	IDS_PERMISSIONS_NOT_REPAIRED,
	IDC_CPUCUSTOM,
	IDM_FULLSCREEN_GROUP,
	IDM_FULLSCREEN_STICKY,
	IDS_FROMIRR,

	IDS_COLOR_CTIMELINE_ANIM,
	EX_IDS_COLOR_AM_ANIMDOT_CHANGED,
	EX_IDS_COLOR_AM_BPDOT,

	IDS_COLOR_PV_BUCKET,
	IDS_COLOR_PV_TEXT,
	IDS_COLOR_PV_CACHE,
	IDS_COLOR_PV_NOTALL,
	IDS_COLOR_PV_COMPARE,
	IDS_COLOR_PV_FPS,

	IDS_PV_M_FILE,
	IDS_PV_M_EDIT,
	IDS_PV_M_VIEW,
	IDS_PV_M_ICONSIZE,
	IDS_PV_M_COMPARE,
	IDS_PV_M_RAMPLAYER,
	IDS_PV_M_TOOLS,
	IDS_PV_M_FPS,
	IDS_DATATYPE_TEXTUREMANAGER,
	IDS_PV_M_CACHESIZE,
	IDS_PV_M_ZOOM,
	IDS_PV_M_FILTER,
	IDS_BUILD,

	IDS_OVERWRITEOLDVERSION2,
	IDS_POSTEFFECT_XMB,
	IDS_MULTIPASS_SAMPLER,

	IDS_RM_M_FILE,
	IDS_RM_M_JOBS,
	IDS_RM_M_SHOW,
	IDS_RM_M_LOG,

	IDS_COLOR_RM_QUEUE,
	IDS_COLOR_RM_ERROR,
	IDS_COLOR_RM_STOP,
	IDS_COLOR_RM_PROG,
	IDS_COLOR_RM_FINISHED,

	IDS_COLOR_PV_NAVIAREA,
	IDS_COLOR_PV_HISTOFILTER,
	IDS_COLOR_PV_HISTO,
	IDS_COLOR_PV_HDLOW,
	IDS_COLOR_PV_HDMED,
	IDS_COLOR_PV_HDHIGH,
	IDS_COLOR_PV_FULLBG_IS_DEPRECATED,
	IDS_COLOR_PV_FULLTXT_IS_DEPRECATED,
	IDS_COLOR_PV_FULLELE_IS_DEPRECATED,
	IDS_COLOR_PV_FULLBOR,
	IDS_COLOR_PV_ASAFE,
	IDS_COLOR_PV_TSAFE,
	IDS_LWF_1,
	IDS_LWF_2,
	IDS_LWF_3,
	IDS_LWF_4,
	IDS_LWF_5,
	IDS_LWF_6,
	IDS_LWF_7,
	IDS_LWF_8,

	IDS_DATATYPE_INTEGER_CYCLEBUTTON,
	IDS_CUSTOMGUI_PROGRESS,
	IDS_COLOR_PROGRESSBAR,
	IDS_PREFS_THEMECOLORS,
	IDS_KEY_F13,
	IDS_KEY_F14,
	IDS_KEY_F15,
	IDS_KEY_F16,
	IDS_KEY_F17,
	IDS_KEY_F18,
	IDS_KEY_F19,
	IDS_KEY_F20,
	IDS_KEY_F21,
	IDS_KEY_F22,
	IDS_KEY_F23,
	IDS_KEY_F24,

	IDS_EDITOR_SIMULATION,
	IDS_EDITOR_SIMULATION_CLOTH,
	IDS_EDITOR_SIMULATION_DYNAMICS,
	IDS_EDITOR_CA_MANAGER,
	IDS_EDITOR_CA_COMMANDS,

	IDS_CM_DISABLED,
	IDS_CM_LINK,
	IDS_CM_LOAD,
	IDS_CM_SAVE,
	IDS_CM_LOADFROMMONITOR,
	IDS_CM_SRGB,
	IDS_CM_LINEAR,
	IDS_CM_CURRENT,
	IDS_CM_CHOOSEPROFILE,
	IDS_CM_ERROR1,
	IDS_CM_CHOOSESAVE,
	IDS_CM_ERROR2,
	IDS_CM_DATATYPE,

	IDS_SUBMENU_HAIROBJECTS,
	IDS_SUBMENU_HAIRMODE,
	IDS_SUBMENU_HAIREDIT,
	IDS_SUBMENU_HAIRSELECTION,
	IDS_SUBMENU_HAIRTOOLS,
	IDS_SUBMENU_HAIROPTIONS,

	IDS_COULDNOTLOAD,
	IDS_LOADIES,

	IDS_ADDIES,
	IDS_ADDIESHELP,
	IDS_EDUCATIONVERSION_IS_DEPRECATED,
	IDS_DATATYPE_UNITSCALE,
	IDS_DOCUMENT_UNIT_KM,
	IDS_DOCUMENT_UNIT_M,
	IDS_DOCUMENT_UNIT_CM,
	IDS_DOCUMENT_UNIT_MM,
	IDS_DOCUMENT_UNIT_MICRO,
	IDS_DOCUMENT_UNIT_NM,
	IDS_DOCUMENT_UNIT_MILE,
	IDS_DOCUMENT_UNIT_YARD,
	IDS_DOCUMENT_UNIT_FOOT,
	IDS_DOCUMENT_UNIT_INCH,

	IDS_COLORPROFILE,
	IDS_ASSIGNPROFILE,
	IDS_CONVERTPROFILE,

	IDS_LOAD_KINEMATIC,
	IDS_LOAD_ANCHOR,
	IDS_LOAD_IK,
	IDS_LOAD_FIX,
	IDS_DEPRECATEDDYNAMICS,
	IDS_PICKMODE,

	IDS_DEPRECATED1,

	IDS_SIMULATIONTAGS,
	IDS_DYNAMICSTAGS_IS_DEPRECATED,
	IDS_SCRIPTING_MAIN,

	IDS_CHANGEDEMOTYPE,
	IDS_CHANGEDEMO_TITLE,
	IDS_CHANGEDEMO_WHICH,

	IDS_COLOR_CTIMELINE_SPLINE,
	IDM_VIEW_STEREO,

	IDS_MAC_ABOUT,
	IDS_MAC_PREFERENCES,
	IDS_MAC_HIDE,
	IDS_MAC_HIDE_OTHERS,
	IDS_MAC_SHOW_ALL,
	IDS_MAC_QUIT,
	IDS_OUTPUTRESOLUTION,
	IDS_RESOLUTIONTOOHIGH,

	IDS_TRACK,

	IDS_DESC_LOCK,
	IDS_DESC_UNLOCK,
	IDS_DESC_HIDE,
	IDS_DESC_UNHIDE,
	IDS_CHOOSEPREVIEWIMAGE,
	IDS_STREAM,
	IDS_MERGEDSTREAM,

	IDC_ROT_H,
	IDC_ROT_P,
	IDC_ROT_B,
	IDS_COLOR_QUICKTAB_BG_ACTIVE_ALTERNATE1,

	IDS_XMB_PREPAREMOTION,
	IDS_PREPARESUBSURFACE,
	IDS_XMB_SKYMAPS,
	IDS_XMB_SUBIRRADIANCE,
	IDS_XMB_INTERACTIVE,
	IDS_XMB_BUILDTREE,
	EX_IDS_COLOR_AM_ANIMDOT_MUTED,

	IDM_MODELING_EXPLODESEGMENTS_POLY,
	IDM_CHANGEPOLYGON_ORDER,

	IDS_MENU_SHOW,
	IDS_MENU_CREATE,
	IDS_MENU_CAMERA,
	IDS_MENU_LIGHT,
	IDS_MENU_MATERIAL,
	IDS_MENU_OBJECT,	
	IDS_MENU_SPLINE,
	IDS_MENU_PHYSICALSKY,
	IDS_MENU_XREF,
	IDS_MENU_ARRANGEOBJECTS,
	IDS_MENU_COORDINATES,
	IDS_MENU_MODES,
	IDS_MENU_TWEAK,
	IDS_MENU_EXECUTION,
	IDS_MENU_MESH,
	IDS_MENU_CONVERSION,
	IDS_MENU_COMMANDS,
	IDS_MENU_CREATETOOLS,
	IDS_MENU_TRANSFORMTOOLS,
	IDS_MENU_POLYGONTOOLS,
	IDS_MENU_NGON,
	IDS_MENU_NORMALS,
	IDS_MENU_MOGRAPH,
	IDS_MENU_EFFECTOR,
	IDS_MENU_MENUS,
	IDS_MENU_LAYOUTS,
	IDS_MENU_VIEW,
	IDS_MENU_AXONOMETRIC,
	IDS_MENU_OPTIONS,
	IDS_MENU_CINEMAN,
	IDS_LAYOUTNAME,
	IDS_RESETLAYOUT,
	IDS_TAGMENU_SCRIPTING,
	IDS_NO_STEREO_CAMERA_FOUND,

	IDS_SEPARATOR,
	IDS_MENU_TOOLSANDMODES,
	IDS_MENU_PROJECTS,
	IDS_MENU_SNAPPING,
	IDS_MENU_TAG,

	M_SCRIPT_EDITOR,
	M_CMIP_TABS,
	IDM_CM_MAKETAB_TOP,
	IDM_CM_MAKETAB_LEFT,
	IDM_CM_MAKETAB_RIGHT,
	IDS_CA_BUILDER,
	IDS_SHADER,

	IDS_NFR_MESSAGE,
	IDS_TEMPORARYVERSION_IS_DEPRECATED,

	IDS_STUDENTVERSION2,
	IDS_VERSIONSORRYSTUDENT,


	IDS_CORRUPTION,

	IDS_REGISTERSTUDENT,
	IDS_REGISTERDEMO,
	IDS_INTROVIDEO,

	IDM_SCULPT_LAYERS,
	IDM_SCULPT_TOOLS,
	IDM_SCULPT_LAYER_MIRROR,
	IDM_SCULPT_LAYER_MIRROR_MASK,
	IDM_SCULPT_LAYER_MIRROR_OBJECT,
	IDM_SCULPT_SMARTRESYM,

	IDM_COMMANDER_EDITFIELD,
	IDS_TAGMENU_MOTIONCAM,

	IDS_TITLE_R_PEDIT,
	// see below related enumerator IDS_TITLE_R_UVPEDIT,
	IDS_AM_NOTHINGFOUND,

	IDS_COLOR_XPRESSO_BACKGROUND,
	IDS_COLOR_XPRESSO_GRID,
	IDS_NO_ANTIALIAS,

	IDS_DESC_RESETALL,
	IDS_COLOR_CTIMELINE_BGTEXTCOLOR,
	IDS_COLOR_CTIMELINE_GRIDMAIN,
	IDS_NEWTL_M_FOLDING,

	IDS_DOCUMENT_BROWSERPRESET,
	IDS_BROWSERPRESET_PRESETEXISTS,
	DELME_IDD_NEW_PRESET_DIALOG,
	DELME_IDC_NEW_PRESET_NAME_EDIT,
	DELME_IDC_NEW_PRESET_AUTHOR_EDIT,
	DELME_IDC_NEW_PRESET_INFO_EDIT,

	IDS_TYPEMISMATCH,

	IDS_DESC_FLUSHREF,

	IDM_WORKPLANE_IS_DEPRECATED,

	IDS_COLOR_ICONS_BG_HIGHLIGHT,
	IDS_COLOR_ICONS_BG_ACTIVE_HIGHLIGHT,
	IDS_COLOR_BG_HIGHLIGHT,
	IDS_COLOR_MENU_BG_HIGHLIGHT,
	IDS_COLOR_MENU_TEXT_HIGHLIGHT,
	IDS_COLOR_ICONS_TEXT_HIGHLIGHT,

	IDS_MENU_WORKPLANE,
	IDS_MENU_SCULPTING,
	IDS_MENU_BRUSHES,
	IDS_MENU_MASK,

	M_CMIP_DONTMIRROR,
	IDM_SWITCH_R2L,

	IDS_DESCINFO_INPORT_CONNECTED,
	IDS_DESCINFO_OUTPORT_CONNECTED,
	IDS_DESCINFO_INPORT,
	IDS_DESCINFO_OUTPORT,
	IDS_DESCINFO_OBJECT,
	IDS_DESCINFO_TAG,
	IDS_DESCINFO_NODE,

	IDS_EDITOR_PLUGINS_TOOLS,
	IDS_EDITOR_SCRIPT_TOOLS,
	IDS_EDITOR_SNAPPING,

	IDS_PRESETPOPUP_NOPRESETSFOUND,

	IDS_MULTIPASS_POSITIONPASS,
	IDS_MULTIPASS_NORMALPASS,

	IDS_STUDENTORIGIN,

	IDM_M_STRUCTURE_NORMALS,
	IDS_ASKABSOLUTETEXTURE,
	IDS_NETWORKCOLLISION,

	IDS_REGISTERLITE,
	IDS_LITEACTIVATIONSUCCEEDED,

	IDS_HTMLSUPPORTLITE,

	IDS_NOMACHINESSELECTED,
	IDS_NOMACHINEONLINE,

	IDS_TEAMRENDER,
	IDS_TEAMRENDER_INITIALIZED,
	IDS_TEAMRENDER_ING,
	IDS_TEAMRENDER_INITIALIZING,
	IDS_UNKNOWN_RENDERENGINE,

	IDS_ANDMORE,

	IDS_RENDERTAGS,
	IDS_ANIMATIONTAGS,
	IDS_HAIRTAGS,
	IDS_MOGRAPHTAGS,
	IDS_CAMERATAGS,
	IDS_SCRIPTTAG,
	IDS_PHOENIXTAGS,

	IDS_COLOR_KEYFRAMEDOT_BG_UP,
	IDS_COLOR_KEYFRAMEDOT_BG_HOVER,
	IDS_COLOR_KEYFRAMEDOT_BG_DOWN,

	IDS_COLOR_SB_TEXT_ACTIVE3,
	IDS_COLOR_SB_BG3_IS_DEPRECATED,
	IDS_COLOR_SB_BG4_IS_DEPRECATED,

	IDM_TEXT_UNDO,
	IDM_TEXT_REDO,

	IDS_COLOR_KEYFRAMEDOT_BG_EDGE,

	IDS_BUGREPORT_TITLE_3RD,
	IDS_BUGREPORT_TITLE_GD,
	IDS_BUGREPORT_GRAPHICSDRIVER,
	IDS_BUGREPORT_3RDPARTYPLUGIN,
	IDS_BUGREPORT_HELP,
	IDS_BUGREPORT_MISSING,
	IDS_PERSUADE_TITLE,
	IDS_PERSUADE_TEXT,
	IDS_PERUSADE_DONTSEND,
	IDS_PERSUADE_BACK,

	IDS_BUGHELP_TITLE,
	IDS_BUGHELP_TEXT,
	IDS_BUGHELP_OK,

	IDS_BUGMISSING_TITLE,
	IDS_BUGMISSING_TEXT,
	IDS_BUGMISSING_UPDATE,
	IDS_BUGMISSING_SEND,

	IDS_MATERIAL_REFLECTION_LAYERS,

	IDS_COLOR_TEXTLINEEDIT,
	IDS_COLOR_TEXTLINECOMPILED,
	IDS_COLOR_TEXTLINESAVED,

	IDS_BROWSERPRESET_SAVEERROR,

	IDS_SKETCHCAT,
	IDS_MOGRAPHCAT,

	IDS_NOTRSUPPORT,
	IDS_UNKNOWNRENDERENGINE,

	IDS_COLOR_CTIMELINE_GRIDMEDIUM,
	IDS_NEWTL_M_SHOWTANGENTMENU,

	IDS_OVERRIDEVALUE_BUBBLETEXT,
	IDS_COLOR_SB_CARET,
	IDS_COLOR_SB_CARETBG,

	IDS_COLOR_TEXT_AUTOTAKE,
	IDS_COLOR_TEXT_AUTOTAKE_DARK,
	IDS_MENU_TAKES,
	IDM_SELECTMATSWITHSAMEREFLECTANCE,

	IDS_LICENSE_FOR_RLM_SERVER,
	IDM_M_STRUCTURE_VERTEXCOLOR,

	IDS_TEXTURINGTAGS,

	IDM_M_STRUCTURE_WEIGHTVERTEX,
	IDM_M_STRUCTURE_WEIGHTEDGE,

	IDM_A_HQ_VIEWPORT_TESSELLATION,
	IDM_A_HQ_VIEWPORT_SSAO,
	IDM_A_HQ_VIEWPORT_REFLECTIONS,

	IDS_TITLE_R_UVPEDIT,

	IDS_FILEOUTDATED,

	IDS_NE_M_CREATE,
	IDS_NE_M_ASSET,
	IDS_NE_M_EDIT,
	IDS_NE_M_SELECT_IS_DEPRECATED,
	IDS_NE_M_NODE,
	IDS_NE_M_PINNING_IS_DEPRECATED,
	IDS_NE_M_VIEW,
	IDS_NE_M_WIRESTYLE_IS_DEPRECATED,

	IDS_MULTIPASS_DIRECT_DIFFUSE,
	IDS_MULTIPASS_INDIRECT_DIFFUSE,
	IDS_MULTIPASS_DIRECT_SPECULAR,
	IDS_MULTIPASS_INDIRECT_SPECULAR,
	IDS_MULTIPASS_DIRECT_DIFFUSE_RAW,
	IDS_MULTIPASS_INDIRECT_DIFFUSE_RAW,
	IDS_MULTIPASS_DIRECT_SPECULAR_RAW,
	IDS_MULTIPASS_INDIRECT_SPECULAR_RAW,
	IDS_MULTIPASS_DIFFUSE_MATERIAL,
	IDS_MULTIPASS_SPECULAR_MATERIAL,

	IDS_SB_EXPORTOBJECT,
	IDS_NODEMATERIALS,
	IDS_MENU_VOLUME,
	IDS_MENU_FIELD,

	IDS_CLEARLAYERSET,

	IDS_SUBMENU_CAMERA,
	IDS_SUBMENU_VIEW,
	IDS_SUBMENU_GUIDE,
	IDS_SUBMENU_TOOLS,
	IDS_SUBMENU_RECENT_TOOLS,
	IDS_SUBMENU_BOOLE_COMMANDS,
	IDS_SUBMENU_PLAYBACK,
	IDS_SUBMENU_ADD,
	IDS_SUBMENU_REMOVE,
	IDS_SUBMENU_CLONE,
	IDS_SUBMENU_CUT,
	IDS_SUBMENU_MOVE,
	IDS_SUBMENU_CONVERT,
	IDS_SUBMENU_UV,
	IDS_SUBMENU_TANGENTS,
	IDS_SUBMENU_SEGMENTS,
	IDS_SUBMENU_POINT_ORDER,

	IDS_CAPSANDBEVEL_BOTH,
	IDS_CAPSANDBEVEL_START,
	IDS_CAPSANDBEVEL_END,
	IDS_CAPSANDBEVEL_END_LINKED,

	// UV viewport HUD name
	IDS_PROJECTION_UV,

	IDS_LAYERMANAGER_MENU_LAYERS,
	IDS_LAYERMANAGER_MENU_EDIT,
	IDS_LAYERMANAGER_MENU_VIEW,

	IDS_GENERALTAGS,
	IDS_RIGGINGTAGS,
	IDS_MODELINGTAGS,

	IDS_MENU_VOLUME_COMMANDS,
	IDS_MENU_VOLUME_FILTER_SDF,
	IDS_MENU_VOLUME_FILTER_FOG,
	IDS_MENU_VOLUME_FILTER_VECTOR,

	IDS_SUBMENU_FORCES,
	IDS_COLOR_TITLEBAR_FOCUS_GRASP_ICON,

	IDS_NFR_ORIGIN,
	IDS_NFR_VERSION2,

	IDS_COLOR_CTIMELINE_CLIPCURVE,
	IDS_FREELICENSE_ERROR,

	IDS_COLOR_XPRESSO_BORDER_NORMAL,
	IDS_COLOR_XPRESSO_BORDER_SELECTED,
	IDS_COLOR_XPRESSO_BORDER_DISABLED,
	IDS_COLOR_XPRESSO_BORDER_SELECTED_DISABLED,
	
	IDS_COLOR_POWERADVANCEDFRAMENUMBER,

	IDS_NFR_MESSAGE_TITLE,

	IDS_SPLASHSCREEN_ABOUT_TITLE_IS_DEPRECATED,
	IDS_SPLASHSCREEN_ABOUT_YEAR,
	IDS_SPLASHSCREEN_ABOUT_TRADEMARKS,
	IDS_SPLASHSCREEN_ABOUT2_IS_DEPRECATED,
	IDS_SPLASHSCREEN_ABOUT3_IS_DEPRECATED,
	IDS_SPLASHSCREEN_ABOUT4_IS_DEPRECATED,
	IDS_SPLASHSCREEN_ABOUT5_IS_DEPRECATED,
	IDS_SPLASHSCREEN_ABOUT_THANKS,
	IDC_SUBDIVIDE_SIMPLESUB,
	IDC_SUBDIVIDE_PATTERN,
	IDC_SUBDIVIDE_PATTERN_CATMULL_CLARK,
	IDC_SUBDIVIDE_PATTERN_LOOP,
	IDC_SUBDIVIDE_PATTERN_OPPOSITE,
	IDC_SUBDIVIDE_SIMPLESUB_STRING,
	IDC_SUBDIVIDE_SUB_STRING,
	IDC_SUBDIVIDE_PATTERN_STRING,
	IDC_SUBDIVIDE_ANGLE_STRING,

	IDS_RM_CAT_MOBILE,

	IDM_DOPTIONEN_SAME_TYPE,

	IDM_DISPLAYFILTER_ALL,
	IDM_DISPLAYFILTER_NONE,
	IDM_DISPLAYFILTER_PRESET_LOAD,
	IDM_DISPLAYFILTER_PRESET_SAVE,
	IDM_DISPLAYFILTER_NULL,
	IDM_DISPLAYFILTER_POLYGON,
	IDM_DISPLAYFILTER_SPLINE,
	IDM_DISPLAYFILTER_GENERATOR,
	IDM_DISPLAYFILTER_HYPERNURBS,
	IDM_DISPLAYFILTER_DEFORMER,
	IDM_DISPLAYFILTER_CAMERA,
	IDM_DISPLAYFILTER_LIGHT,
	IDM_DISPLAYFILTER_SCENE,
	IDM_DISPLAYFILTER_PARTICLE,
	IDM_DISPLAYFILTER_OTHER,
	IDM_DISPLAYFILTER_GRID,
	IDM_DISPLAYFILTER_HORIZON,
	IDM_DISPLAYFILTER_WORLDAXIS,
	IDM_DISPLAYFILTER_HUD,
	IDM_DISPLAYFILTER_SDS,
	IDM_DISPLAYFILTER_HIGHLIGHTING,
	IDM_DISPLAYFILTER_MULTIAXIS,
	IDM_DISPLAYFILTER_OBJECTHANDLES,
	IDM_DISPLAYFILTER_SDSCAGE,
	IDM_DISPLAYFILTER_NGONLINES,
	IDM_DISPLAYFILTER_JOINT,
	IDM_DISPLAYFILTER_ONION,
	IDM_DISPLAYFILTER_GUIDELINES,
	IDM_DISPLAYFILTER_OBJECTHIGHLIGHTING,
	IDM_DISPLAYFILTER_BASEGRID,
	IDM_DISPLAYFILTER_HANDLES,
	IDM_DISPLAYFILTER_HAIR,
	IDM_DISPLAYFILTER_FIELD,
	IDM_DISPLAYFILTER_SHOWPATH,
	IDM_DISPLAYFILTER_GEOMETRY_ONLY,
	IDM_DISPLAYFILTER_DEFAULT,

	IDS_OM_M_EDIT,

	IDS_MESSAGEDIALOG_BUTTON_IGNORE,
	
	IDS_COLOR_SB_CARET_TEXT,

	IDS_STUDENTVERSIONB,
	IDS_STUDENTVERSIONB2,
	
	IDS_COLOR_MANAGER_BG_TREEVIEW,
	IDS_COLOR_TEXT_EDIT_HELP,

	IDM_A_HQ_VIEWPORT_MAGICBULLETLOOKS,
	
	IDS_SUBMENU_PREVIEWRANGE,
	IDS_SUBMENU_SHOWTRACKS,

	IDM_SAFE_FRAMES,
	IDM_DISPLAYFILTER_GEOMETRY_ONLY_PLAYBACK,
	IDS_FX_ANTIALIAS,

	IDM_CREATE_POPUP,
	M_CREATE,
	
	IDS_COLOR_BROWSER_PREVIEW_BG,
	IDS_COLOR_BROWSER_BACKGROUND_MOUSEOVER,
	IDS_COLOR_BROWSER_BACKGROUND_SELECTED_SMALL,

	IDS_SCENEREPOSITORYNAME,

	IDS_COLOR_TEXT_SHORTCUT,
	IDS_COLOR_TEXT_SHORTCUT_DISABLED,
	
	IDS_COLOR_STATUSBAR,

	IDS_SB_NEW_MATERIAL,

	IDS_SHORTCUT_PRESET_LIST,
	IDH_SHORTCUT_PRESET_LIST,
	IDS_SHORTCUT_PRESET_LOAD,
	IDH_SHORTCUT_PRESET_LOAD,
	IDS_SHORTCUT_PRESET_LOAD_INFO,
	IDS_SHORTCUT_PRESET_LOADED,
	IDS_SHORTCUT_PRESET_DUPLICATE,
	IDH_SHORTCUT_PRESET_DUPLICATE,
	IDS_SHORTCUT_PRESET_DUPLICATED,
	IDS_SHORTCUT_PRESET_RENAME,
	IDH_SHORTCUT_PRESET_RENAME,
	IDS_SHORTCUT_PRESET_RENAMED,
	IDS_SHORTCUT_PRESET_DELETE,
	IDH_SHORTCUT_PRESET_DELETE,
	IDS_SHORTCUT_PRESET_DELETED,
	IDS_SHORTCUT_PRESET_DEFAULT,
	IDS_SHORTCUT_PRESET_MODIFIED_SUFFIX,
	IDS_SHORTCUT_PRESET_INVALID,
	IDS_SHORTCUT_PRESET_OK,
	IDS_SHORTCUT_PRESET_CANCEL,
	IDS_SHORTCUT_PRESET_RENAME_ERROR,
	IDS_SHORTCUT_PRESET_DELETE_ERROR,
	IDS_SHORTCUT_PRESET_FILE_EXISTS,
	IDS_SHORTCUT_PRESET_USER,
	
	IDM_A_LINES_ON_SHADING,

	IDS_COLOR_HIERARCHY_LINES,

	IDS_MOVE_VIEW,
	IDS_SCALE_VIEW,

	IDM_MAINMENU_MODEL,
	M_EDITOR_MODEL,

	IDM_MAINMENU_SCULPT,
	M_EDITOR_SCULPT,

	IDS_MM_LIST_VIEW,
	IDS_MM_GRID_VIEW,
	IDS_MM_LAYER_VIEW,

	IDS_CM_CMD_NAME,
	IDS_CM_CMD_HELP,
	IDS_CM_DLG_TITLE,
	IDS_CM_OBJECT_REL,
	IDS_CM_OBJECT_ABS,
	IDS_CM_WORLD,
	IDS_CM_SCALE,
	IDS_CM_SIZE,
	IDS_CM_SIZEPLUS,

	IDS_COLOR_POWERSLIDER_HORIZONTAL_SEPARATOR,

	IDS_COLOR_QUICKTAB_BG_INACTIVE_DISABLED,
	IDS_COLOR_QUICKTAB_BG_ACTIVE_DISABLED,
	
	IDS_SUBMENU_SPLINE,

	IDS_COLOR_BROWSER_BACKGROUND_MOUSEOVER_SELECTED,

	IDS_COLOR_KEYFRAMEDOT_DEFAULT,
	IDS_COLOR_KEYFRAMEDOT_ANIMATED,
	IDS_COLOR_KEYFRAMEDOT_ANIMATED_CHANGED,
	IDS_COLOR_KEYFRAMEDOT_BRUSH_EFFECTOR,

	IDS_COPY_TEXT,
	
	M_CMIP_DYNAMIC_RENDERER,

	IDS_COLOR_MENU_TEXT_SEPARATOR,

	IDS_SEPARATOR_OPEN,
	IDS_SEPARATOR_CLOSE,
	IDS_SEPARATOR_SAVE,
	IDS_SEPARATOR_QUIT,
	IDS_SEPARATOR_HISTORY,
	IDS_SEPARATOR_EDIT,
	IDS_SEPARATOR_CONFIGURE,
	IDS_SEPARATOR_PRIMITIVES,
	IDS_SEPARATOR_OPERATORS,
	IDS_SEPARATOR_SURFACE,
	IDS_SEPARATOR_SPLINE_TO_MESH,
	IDS_SEPARATOR_BOOLEAN,
	IDS_SEPARATOR_DUPLICATE,
	IDS_SEPARATOR_MESHING,
	IDS_SEPARATOR_FILE_TO_OBJECT,
	IDS_SEPARATOR_SHAPES,
	IDS_SEPARATOR_TRANSFORM,
	IDS_SEPARATOR_BREAK,
	IDS_SEPARATOR_CHARACTER,
	IDS_SEPARATOR_SPLINE,
	IDS_SEPARATOR_EXTRA,
	IDS_SEPARATOR_GENERATE,
	IDS_SEPARATOR_GROUP,
	IDS_SEPARATOR_VIRTUAL_SET,
	IDS_SEPARATOR_DELTA,
	IDS_SEPARATOR_PHYSICAL,
	IDS_SEPARATOR_SUN_AND_SKY,
	IDS_SEPARATOR_BAKE,
	IDS_SEPARATOR_COMPONENTS,
	IDS_SEPARATOR_OBJECTS,
	IDS_SEPARATOR_ADDITIONAL,
	IDS_SEPARATOR_MODELING,
	IDS_SEPARATOR_MODES,
	IDS_SEPARATOR_GRID,
	IDS_SEPARATOR_GUIDES,
	IDS_SEPARATOR_ALIGN,
	IDS_SEPARATOR_VIEWPORT_SOLO,
	IDS_SEPARATOR_TOOLS,
	IDS_SEPARATOR_COMPONENT_TOOLS,
	IDS_SEPARATOR_COMMANDS,
	IDS_SEPARATOR_VISIBILITY,
	IDS_SEPARATOR_SETS,
	IDS_SEPARATOR_TRANSFORM_TOOLS,
	IDS_SEPARATOR_PLACEMENT_TOOLS,
	IDS_SEPARATOR_ARRANGEMENT,
	IDS_SEPARATOR_VIEWPORT,
	IDS_SEPARATOR_CONVERT,
	IDS_SEPARATOR_CONNECT,
	IDS_SEPARATOR_MAIN_TOOLS,
	IDS_SEPARATOR_MODIFY,
	IDS_SEPARATOR_MODE,
	IDS_SEPARATOR_SEPARATE,
	IDS_SEPARATOR_TRIANGULATION,
	IDS_SEPARATOR_NORMAL_TRANSFORM_TOOLS,
	IDS_SEPARATOR_PHONG_SHADING,
	IDS_SEPARATOR_SCULPT,
	IDS_SEPARATOR_MASK,
	IDS_SEPARATOR_LINK,
	IDS_SEPARATOR_UV_EDIT,
	IDS_SEPARATOR_PINS,
	IDS_SEPARATOR_UNWRAP,
	IDS_SEPARATOR_INTERACTIVE_MAPPING,
	IDS_SEPARATOR_GENERATORS,
	IDS_SEPARATOR_FILTERS,
	IDS_SEPARATOR_FILTER,
	IDS_SEPARATOR_LOADER,
	IDS_SEPARATOR_DEFORMERS,
	IDS_SEPARATOR_CLONING_TOOLS,
	IDS_SEPARATOR_SKELETON,
	IDS_SEPARATOR_SKINNING,
	IDS_SEPARATOR_MUSCLES,
	IDS_SEPARATOR_CLUSTERS,
	IDS_SEPARATOR_MORPHS,
	IDS_SEPARATOR_REPEAT,
	IDS_SEPARATOR_PLAY,
	IDS_SEPARATOR_SOUND,
	IDS_SEPARATOR_GOTO,
	IDS_SEPARATOR_SET_KEYS,
	IDS_SEPARATOR_FPS,
	IDS_SEPARATOR_PLAYBLAST,
	IDS_SEPARATOR_NLA,
	IDS_SEPARATOR_DYNAMICS,
	IDS_SEPARATOR_PARTICLES,
	IDS_SEPARATOR_FORCES,
	IDS_SEPARATOR_HAIR,
	IDS_SEPARATOR_ROOTS,
	IDS_SEPARATOR_PROPORTIONAL_EDITING,
	IDS_SEPARATOR_LOCKING,
	IDS_SEPARATOR_GROOM_TOOLS,
	IDS_SEPARATOR_CREATE_TOOLS,
	IDS_SEPARATOR_SYMMETRY,
	IDS_SEPARATOR_MANAGERS,
	IDS_SEPARATOR_FRAME,
	IDS_SEPARATOR_TRACK,
	IDS_SEPARATOR_SET_KEY,
	IDS_SEPARATOR_TRIM,
	IDS_SEPARATOR_ONLINE_RENDERING,
	IDS_SEPARATOR_OFFLINE_RENDERING,
	IDS_SEPARATOR_RENDER_QUEUE,
	IDS_SEPARATOR_TEAM_RENDER,
	IDS_SEPARATOR_MENUS,
	IDS_SEPARATOR_LAYOUTS,
	IDS_SEPARATOR_PALETTES,
	IDS_SEPARATOR_FULL_SCREEN,
	IDS_SEPARATOR_ASSETS,
	IDS_SEPARATOR_MATERIALS,
	IDS_SEPARATOR_ANIMATION,
	IDS_SEPARATOR_RENDERING,
	IDS_SEPARATOR_UV_EDIT_AND_PAINT,
	IDS_SEPARATOR_LICENSE,
	IDS_SEPARATOR_ADD,
	IDS_SEPARATOR_CLONE,
	IDS_SEPARATOR_REMOVE,
	IDS_SEPARATOR_CUT,
	IDS_SEPARATOR_MOVE,
	IDS_SEPARATOR_NGONS,
	IDS_SEPARATOR_NORMALS,
	IDS_SEPARATOR_LAYERS,
	IDS_SEPARATOR_FOLD,
	IDS_SEPARATOR_SELECT,
	IDS_SEPARATOR_CACHE,
	IDS_SEPARATOR_ZOOM,
	IDS_SEPARATOR_DISPLAY,
	IDS_SEPARATOR_INFO,
	IDS_SEPARATOR_UVW,
	IDS_SEPARATOR_SEGMENTS,
	IDS_SEPARATOR_TANGENTS,
	IDS_SEPARATOR_TAKES,
	IDS_SEPARATOR_PRESETS,
	IDS_SEPARATOR_MIRROR,
	IDS_SEPARATOR_TILE,
	IDS_SEPARATOR_SNAP,
	IDS_SEPARATOR_VELOCITY,
	IDS_SEPARATOR_INTERPOLATION,
	IDS_SEPARATOR_REDUCED_MODIFICATION,
	IDS_SEPARATOR_SNAPSHOT,
	IDS_SEPARATOR_CAMERA,
	IDS_SEPARATOR_PROJECTION,
	IDS_SEPARATOR_SHADING,
	IDS_SEPARATOR_WIRE,
	IDS_SEPARATOR_OPTIONS,
	IDS_SEPARATOR_EFFECTS,
	IDS_SEPARATOR_EDITOR,

	IDS_VIEW_TRANSFORM_DEFAULT,
	IDS_USE_AUTOMATIC_COLORSPACE,

	IDS_LOAD_FILE,
	IDS_LOAD_ASSET,

	IDS_TASK_MANAGER_TITLE,
	IDS_TASK_MANAGER_SHOW_DETAILS,
	IDS_TASK_MANAGER_CANCEL_TASK,
	IDS_TASK_MANAGER_CLEAN_HISTORY_ENTRY,
	IDS_TASK_MANAGER_CLEAN_ALL_HISTORY,
	IDS_TASK_MANAGER_PIN_POPUP,
	IDS_TASK_MANAGER_ACTIVE_TAB,
	IDS_TASK_MANAGER_HISTORY_TAB,
	IDS_TASK_MANAGER_RESULT_ERROR,
	IDS_TASK_MANAGER_RESULT_WARNING,
	IDS_TASK_MANAGER_RESULT_CANCELLED,
	IDS_TASK_MANAGER_RESULT_SUCCESS,
	IDS_TASK_MANAGER_REMAINING_DURATION,
	IDS_TASK_MANAGER_ESTIMATED_DURATION,
	IDS_TASK_MANAGER_STATUSBAR_ACTIVE_COUNT,
	IDS_TASK_MANAGER_STATUSBAR_1_ERROR,
	IDS_TASK_MANAGER_STATUSBAR_X_ERRORS,
	IDS_TASK_MANAGER_STATUSBAR_1_WARNING,
	IDS_TASK_MANAGER_STATUSBAR_X_WARNINGS,
	IDS_TASK_MANAGER_STATUSBAR_CLICK_TO_OPEN,
	IDS_TASK_MANAGER_BUBBLEHELP_OPEN,

	IDS_TASK_RENDER_IN_PV,
	IDS_TASK_RENDER_FRAME,
	IDS_TASK_MANAGER_COMMANDNAME,

	IDS_SAVE_FILE,
	IDS_CHOOSE_FOLDER,

	IDS_TASK_NURBS_CAPS_GENERATION,
	IDS_TASK_VIEWPORT_RENDERING,
	IDS_TASK_REVERTING_DOC,
	IDS_TASK_LOADING_DOC,
	IDS_TASK_SENDING_CRASHLOG,
	IDS_TASK_SENDING_CRASHLOG_CANCEL,
	
	IDS_COLOR_TEXT_SEPARATOR,
	IDS_INVALID_OCIO_CONFIG,

	IDS_REDSHIFT,

	IDS_XPBDSIMULATIONTAGS,

	IDS_COLOR_WARNING,
	IDS_COLOR_ERROR,

	IDS_CANCEL_ALL_TASKS_QUESTION,

	IDS_COLOR_NETSTATE_DISABLED,
	IDS_COLOR_NETSTATE_IDLE,
	IDS_COLOR_NETSTATE_BUSY,
	IDS_COLOR_NETSTATE_BUSY2,
	IDS_COLOR_NETSTATE_CRITICAL,

	IDS_NORMAL_TRANSFORM,
	IDS_OCIO_SCENE_NEEDS_CONVERSION,
	IDS_OCIO_SCENE_IS_CONVERTED,
	IDS_OCIO_DOCUMENT_RENDERSPACE,

	IDM_SHOW_CAMERA_ATTRIBUTES,
	
	IDS_DEFAULT_MATERIAL_AUTO,

	IDS_UICONVERSION_UIDATA_TYPE_SUFFIX,
	IDS_UICONVERSION_UIDATA_VALUE_SUFFIX,
	
	IDS_ADD_TAG,

	IDS_EXPORT_CMD_TOOLTIP,

	IDS_EDITIMAGEINFINDER,
	IDS_LOCATEIMAGEINFINDER,

	IDS_COLOR_BG_GROUP_ROUNDED,

	IDS_COLOR_BG_BUTTON,
	IDS_COLOR_BG_BUTTON_HIGHLIGHTED,
	IDS_COLOR_BG_BUTTON_DISABLED,
	IDS_COLOR_TEXT_BUTTON_EMPHASIZED,
	IDS_COLOR_BG_BUTTON_EMPHASIZED,
	IDS_COLOR_BG_BUTTON_EMPHASIZED_HIGHLIGHTED,
	IDS_COLOR_TEXT_BUTTON_DIMMED,
	IDS_COLOR_BG_BUTTON_DIMMED,

	IDS_MISSINGS_BUTTON_PAI,

	IDS_MISSING_FONTS_TITLE,
	IDS_MISSING_FONTS_INFO_SINGLE,
	IDS_MISSING_FONTS_INFO_MULTI,

	IDS_MISSING_NODEASSETS_TITLE,
	IDS_MISSING_NODEASSETS_INFO_SINGLE,
	IDS_MISSING_NODEASSETS_INFO_MULTI,

	IDS_SAVEDENIED_NODEASSET_TITLE,
	// legacy particles
	IDS_LEGACY_PARTICLES_SUBMENU,
	IDS_SEPARATOR_TP_PARTICLES,
	IDS_SEPARATOR_PARTICLES_OLD,
	// new particle ids
	IDS_FP_EMITTER_SUBMENU,
	IDS_FP_GROUP_SUBMENU,
	IDS_FP_CONDITION_SUBMENU,
	IDS_FP_MODIFIER_SUBMENU,
	IDS_FP_SEPARATOR_PROXIMITY,
	IDS_FP_SEPARATOR_DATA_MANIPULATION,
	IDS_FP_SEPARATOR_EXTERNAL,

	IDS_LIGHT_TYPE_DOME,

	IDS_EDITOR_SIMULATION_CONNECTOR,

	IDS_ASSET_BROWSER_PRESET,
	
	IDS_UNDOREDO_HISTORY,
	IDS_UNDOREDO_HISTORY_CREATE,
	IDS_UNDOREDO_HISTORY_DELETE,
	IDS_UNDOREDO_HISTORY_MODIFY,
	IDS_UNDOREDO_HISTORY_SELECT,
	IDS_UNDOREDO_HISTORY_DESELECT,
	IDS_UNDOREDO_HISTORY_REORDER,

	IDS_DOCUMENT_CURRENT_RENDER_COLOR_SPACE,
	IDS_DOCUMENT_LEGACY_SPACE_NAME,
	IDS_DOCUMENT_OCIO_INFOSTRING0,
	IDS_DOCUMENT_OCIO_INFOSTRING1,
	IDS_DOCUMENT_OCIO_INFOSTRING0_BASIC,
	IDS_DOCUMENT_OCIO_INFOSTRING0_OCIO,
	IDS_DOCUMENT_OCIO_INFOSTRING1_BASIC,
	IDS_DOCUMENT_OCIO_INFOSTRING1_OCIO,
	IDS_DOCUMENT_OCIO_INFOSTRING2_BASIC,
	IDS_DOCUMENT_OCIO_INFOSTRING2_OCIO,
	IDS_DOCUMENT_OCIO_INFOSTRING_SPACE,

	IDS_SEPARATOR_PROFILER_MODE,
	IDS_SEPARATOR_PROFILER_UNIT,

	IDS_LOCATE_COMMAND_HIDDEN_DRAG_TO_REVEAL,
	IDS_LOCATE_COMMAND_HIDDEN_DRAG_TO_REVEAL_DIRECTION_LEFT,
	IDS_LOCATE_COMMAND_HIDDEN_DRAG_TO_REVEAL_DIRECTION_TOP,
	IDS_LOCATE_COMMAND_HIDDEN_DRAG_TO_REVEAL_DIRECTION_RIGHT,
	IDS_LOCATE_COMMAND_HIDDEN_DRAG_TO_REVEAL_DIRECTION_BOTTOM,
	IDS_LOCATE_COMMAND_HIDDEN_DRAG_TO_REVEAL_CLICK_AND_HOLD,
	IDS_LOCATE_COMMAND_CLICK_AND_HOLD,
	IDS_LOCATE_COMMAND_MENU_CLICK,
	IDS_LOCATE_COMMAND_MENU_CLICK_SUBMENU,

	IDS_FIND_SIMILAR_TEXTURE,

	IDS_FP_SEPARATOR_LIQUID,
	IDS_TOGGLE_SCENE_PANEL,
	IDS_TOGGLE_SCENE_PANEL_HELP,

	IDS_COLOR_PALETTE_ICON_ACTIVE,

	IDS_COLOR_BROWSER_BACKGROUND,

  IDS_PROTECTION_R_X,
  IDS_PROTECTION_R_Y,
  IDS_PROTECTION_R_Z,

	IDS_SPLASHSCREEN_AEC_ABOUT_TITLE_IS_DEPRECATED,
	IDS_SPLASHSCREEN_AEC_ABOUT_TRADEMARKS,

	IDS_COLOR_BROWSER_TEXT_MOUSEOVER,
	IDS_COLOR_BROWSER_TEXT_MOUSEOVER_SELECTED,

	IDS_COLOR_BG_COMBO,
	IDS_COLOR_BG_COMBO_FOCUS,
	IDS_COLOR_BG_COMBO_DISABLED,

	IDS_RSV_OBJECTS_TAB,
	IDS_RSV_ENVIRONMENT_TAB,
	IDS_RSV_MATERIALS_TAB,

	IDM_M_STRUCTURE_UVPOINTS,
	IDM_M_STRUCTURE_UVPOLYGONS,

	X_DEFDUMMY2_X
};

// Layer Reflection Group
// Please do NOT remove any deprecated symbol but mark as unused instead.
enum
{
	REFLECTION_STRINGS = 200000,

	IDS_REFLECTION_LAYER_GLOBAL_LAYER,
	IDS_REFLECTION_LAYER_GLOBAL_LAYERS,
	IDS_REFLECTION_LAYER_GLOBAL_SHADER,
	IDS_REFLECTION_LAYER_GLOBAL_TRANSPARENT,
	IDS_REFLECTION_LAYER_GLOBAL_SPECULAR,
	IDS_REFLECTION_LAYER_GLOBAL_REFLECTION,
	IDS_REFLECTION_LAYER_GLOBAL_ADD,
	IDS_REFLECTION_LAYER_GLOBAL_REMOVE,
	IDS_REFLECTION_LAYER_GLOBAL_COPY,
	IDS_REFLECTION_LAYER_GLOBAL_PASTE,
	IDS_REFLECTION_LAYER_GLOBAL_STRENGTH_REFLECTION,
	IDS_REFLECTION_LAYER_GLOBAL_STRENGTH_SPECULAR,
	IDS_REFLECTION_LAYER_GLOBAL_SEPARATE_PASS,

	IDS_REFLECTION_LAYER_MENU_REMOVE,
	IDS_REFLECTION_LAYER_MENU_COPY,
	IDS_REFLECTION_LAYER_MENU_PASTE,
	IDS_REFLECTION_LAYER_MENU_DUPLICATE,

	IDS_REFLECTION_LAYER_MULTIPASS_PREMULTIPLY,
	IDS_REFLECTION_LAYER_MULTIPASS_MULTIPLY,
	IDS_REFLECTION_LAYER_MULTIPASS_REFLECTION,
	IDS_REFLECTION_LAYER_MULTIPASS_SPECULAR,

	IDS_REFLECTION_LAYER_MAIN_DISTRIBUTION,
	IDS_REFLECTION_LAYER_MAIN_ADDITIVE,
	IDS_REFLECTION_LAYER_MAIN_COLORED_REFLECTION,
	IDS_REFLECTION_LAYER_MAIN_COLORED_SPECULAR,
	IDS_REFLECTION_LAYER_MAIN_VALUE_ROUGHNESS,
	IDS_REFLECTION_LAYER_MAIN_VALUE_WIDTH,
	IDS_REFLECTION_LAYER_MAIN_VALUE_FALLOFF,
	IDS_REFLECTION_LAYER_MAIN_VALUE_INNER,
	IDS_REFLECTION_LAYER_MAIN_VALUE_ORENNAYAR,
	IDS_REFLECTION_LAYER_MAIN_VALUE_REFLECTION,
	IDS_REFLECTION_LAYER_MAIN_VALUE_SPECULAR,

	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_MODE,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_SPACE,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_BUMP,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_NORM,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_MIPMAP,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_REVERSEX,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_REVERSEY,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_REVERSEZ,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_SWAP,
	IDS_REFLECTION_LAYER_MAIN_VALUE_BUMP_CUSTOM,

	IDS_REFLECTION_LAYER_COLOR_GROUP,
	IDS_REFLECTION_LAYER_COLOR_COLOR,
	IDS_REFLECTION_LAYER_COLOR_BRIGHTNESS,
	IDS_REFLECTION_LAYER_COLOR_TEXTURE,
	IDS_REFLECTION_LAYER_COLOR_MIX_MODE,
	IDS_REFLECTION_LAYER_COLOR_MIX_STRENGTH,

	IDS_REFLECTION_LAYER_TRANS_GROUP,
	IDS_REFLECTION_LAYER_TRANS_COLOR,
	IDS_REFLECTION_LAYER_TRANS_BRIGHTNESS,
	IDS_REFLECTION_LAYER_TRANS_TEXTURE,
	IDS_REFLECTION_LAYER_TRANS_MIX_MODE,
	IDS_REFLECTION_LAYER_TRANS_MIX_STRENGTH,

	IDS_REFLECTION_LAYER_ANISO_GROUP,
	IDS_REFLECTION_LAYER_ANISO_PROJECTION,
	IDS_REFLECTION_LAYER_ANISO_PROJECTION_SCALE,
	IDS_REFLECTION_LAYER_ANISO_PROJECTION_ANGLE,
	IDS_REFLECTION_LAYER_ANISO_PROJECTION_OFFSET_U,
	IDS_REFLECTION_LAYER_ANISO_PROJECTION_OFFSET_V,
	IDS_REFLECTION_LAYER_ANISO_PROJECTION_COUNT,
	IDS_REFLECTION_LAYER_ANISO_PATTERN,
	IDS_REFLECTION_LAYER_ANISO_MIRROR,
	IDS_REFLECTION_LAYER_ANISO_SCRATCHES,
	IDS_REFLECTION_LAYER_ANISO_VALUE_CUSTOM,
	IDS_REFLECTION_LAYER_ANISO_VALUE_ANISOTROPY,
	IDS_REFLECTION_LAYER_ANISO_VALUE_ORIENTATION,

	IDS_REFLECTION_LAYER_PRIMARY_VALUE_AMPLITUDE,
	IDS_REFLECTION_LAYER_PRIMARY_VALUE_SCALE,
	IDS_REFLECTION_LAYER_PRIMARY_VALUE_LENGTH,
	IDS_REFLECTION_LAYER_PRIMARY_VALUE_ATTENUATION,

	IDS_REFLECTION_LAYER_SECONDARY_VALUE_AMPLITUDE,
	IDS_REFLECTION_LAYER_SECONDARY_VALUE_SCALE,
	IDS_REFLECTION_LAYER_SECONDARY_VALUE_LENGTH,
	IDS_REFLECTION_LAYER_SECONDARY_VALUE_ATTENUATION,

	IDS_REFLECTION_LAYER_FRESNEL_GROUP,
	IDS_REFLECTION_LAYER_FRESNEL_MODE,
	IDS_REFLECTION_LAYER_FRESNEL_PRESET,
	IDS_REFLECTION_LAYER_FRESNEL_METAL,
	IDS_REFLECTION_LAYER_FRESNEL_INVERTED,
	IDS_REFLECTION_LAYER_FRESNEL_OPAQUE,
	IDS_REFLECTION_LAYER_FRESNEL_VALUE_STRENGTH,
	IDS_REFLECTION_LAYER_FRESNEL_VALUE_IOR,
	IDS_REFLECTION_LAYER_FRESNEL_VALUE_ETA,
	IDS_REFLECTION_LAYER_FRESNEL_VALUE_ABSORP,

	IDS_REFLECTION_LAYER_SAMPLING_GROUP,
	IDS_REFLECTION_LAYER_SAMPLING_DIM,
	IDS_REFLECTION_LAYER_SAMPLING_DIM_DISTANCE,
	IDS_REFLECTION_LAYER_SAMPLING_DIM_FALLOFF,
	IDS_REFLECTION_LAYER_SAMPLING_DIM_COLOR,
	IDS_REFLECTION_LAYER_SAMPLING_CLAMP,
	IDS_REFLECTION_LAYER_SAMPLING_CUTOFF,
	IDS_REFLECTION_LAYER_SAMPLING_EXIT_COLOR,
	IDS_REFLECTION_LAYER_SAMPLING_SEPARATE_PASS,
	IDS_REFLECTION_LAYER_SAMPLING_SAMPLE_COUNT,

	IDS_REFLECTION_LAYER_CLOTH_GROUP,
	IDS_REFLECTION_LAYER_CLOTH_PRESET,
	IDS_REFLECTION_LAYER_CLOTH_PATTERN,
	IDS_REFLECTION_LAYER_CLOTH_QUALITY,
	IDS_REFLECTION_LAYER_CLOTH_SMOOTHING,
	IDS_REFLECTION_LAYER_CLOTH_SCATTERING_UNIFORM,
	IDS_REFLECTION_LAYER_CLOTH_SCATTERING_FORWARD,

	IDS_REFLECTION_LAYER_CLOTH_VALUE_ORIENTATION,
	IDS_REFLECTION_LAYER_CLOTH_VALUE_SCALE_U,
	IDS_REFLECTION_LAYER_CLOTH_VALUE_SCALE_V,
	IDS_REFLECTION_LAYER_CLOTH_VALUE_HIGHLIGHTS,

	IDS_REFLECTION_LAYER_CLOTH_NOISE_INTENSITY,
	IDS_REFLECTION_LAYER_CLOTH_NOISE_SCALE,
	IDS_REFLECTION_LAYER_CLOTH_NOISE_SHAPE_WARP,
	IDS_REFLECTION_LAYER_CLOTH_NOISE_SHAPE_WEFT,
	IDS_REFLECTION_LAYER_CLOTH_NOISE_SHAPE_SCALE,

	IDS_REFLECTION_LAYER_CLOTH_COLOR_DIFFUSE_WARP,
	IDS_REFLECTION_LAYER_CLOTH_COLOR_DIFFUSE_WEFT,
	IDS_REFLECTION_LAYER_CLOTH_COLOR_SPECULAR_WARP,
	IDS_REFLECTION_LAYER_CLOTH_COLOR_SPECULAR_WEFT,

	IDS_REFLECTION_LAYER_DEBUG_GROUP,
	IDS_REFLECTION_LAYER_DEBUG_DUDV,
	IDS_REFLECTION_LAYER_DEBUG_SCRATCHES,
	IDS_REFLECTION_LAYER_DEBUG_WARMNESS,
	IDS_REFLECTION_LAYER_DEBUG_CLOTH,

	IDS_REFLECTION_LAYER_GLOBAL_LINEAR_TEXTURES,

	IDS_DATATYPE_ACOLOR,
	IDS_DATATYPE_VECTOR4D,

	IDS_REFLECTION_DISTRIBUTION_BECKMANN = 201000,
	IDS_REFLECTION_DISTRIBUTION_GGX,
	IDS_REFLECTION_DISTRIBUTION_PHONG,
	IDS_REFLECTION_DISTRIBUTION_WARD,
	IDS_REFLECTION_DISTRIBUTION_ANISOTROPIC,
	IDS_REFLECTION_DISTRIBUTION_REFLECTION,
	IDS_REFLECTION_DISTRIBUTION_SPECULAR_BLINN,
	IDS_REFLECTION_DISTRIBUTION_SPECULAR_PHONG,
	IDS_REFLECTION_DISTRIBUTION_LAMBERTIAN,
	IDS_REFLECTION_DISTRIBUTION_ORENNAYAR,
	IDS_REFLECTION_DISTRIBUTION_IRAWAN,

	IDS_REFLECTION_ADDITIVE_AVERAGE = 201100,
	IDS_REFLECTION_ADDITIVE_MIN,
	IDS_REFLECTION_ADDITIVE_MAX,
	IDS_REFLECTION_ADDITIVE_ADD,
	IDS_REFLECTION_ADDITIVE_METAL,

	IDS_REFLECTION_MIXING_NORMAL = 201200,
	IDS_REFLECTION_MIXING_ADD,
	IDS_REFLECTION_MIXING_SUBTRACT,
	IDS_REFLECTION_MIXING_MULTIPLY,

	IDS_REFLECTION_BUMP_MODE_DEFAULT = 201300,
	IDS_REFLECTION_BUMP_MODE_BUMP,
	IDS_REFLECTION_BUMP_MODE_NORMAL,

	IDS_REFLECTION_BUMP_SPACE_TANGENT = 201400,
	IDS_REFLECTION_BUMP_SPACE_LOCAL,
	IDS_REFLECTION_BUMP_SPACE_WORLD,

	IDS_REFLECTION_PROJECTION_NONE = 201500,
	IDS_REFLECTION_PROJECTION_PLANAR,
	IDS_REFLECTION_PROJECTION_RADIAL,

	IDS_REFLECTION_MIRROR_NONE = 201600,
	IDS_REFLECTION_MIRROR_U,
	IDS_REFLECTION_MIRROR_V,
	IDS_REFLECTION_MIRROR_UV,

	IDS_REFLECTION_PATTERN_NONE = 201700,
	IDS_REFLECTION_PATTERN_CIRCULAR,
	IDS_REFLECTION_PATTERN_BOX,
	IDS_REFLECTION_PATTERN_DIAGONAL,
	IDS_REFLECTION_PATTERN_LATTICE,
	IDS_REFLECTION_PATTERN_CUSTOM,

	IDS_REFLECTION_SCRATCHES_NONE = 201800,
	IDS_REFLECTION_SCRATCHES_PRIMARY,
	IDS_REFLECTION_SCRATCHES_SECONDARY,
	IDS_REFLECTION_SCRATCHES_BOTH,

	IDS_REFLECTION_CLOTH_PRESET_CUSTOM = 201900,
	IDS_REFLECTION_CLOTH_PRESET_A,
	IDS_REFLECTION_CLOTH_PRESET_B,
	IDS_REFLECTION_CLOTH_PRESET_C,
	IDS_REFLECTION_CLOTH_PRESET_D,
	IDS_REFLECTION_CLOTH_PRESET_E,
	IDS_REFLECTION_CLOTH_PRESET_F,

	IDS_REFLECTION_CLOTH_PATTERN_COTTON_DENIM = 202000,
	IDS_REFLECTION_CLOTH_PATTERN_COTTON_TWILL,
	IDS_REFLECTION_CLOTH_PATTERN_POLYESTER_LINING,
	IDS_REFLECTION_CLOTH_PATTERN_SILK_CHARMEUSE,
	IDS_REFLECTION_CLOTH_PATTERN_SILK_SHANTUNG,
	IDS_REFLECTION_CLOTH_PATTERN_WOOL_GABARDINE,

	IDS_REFLECTION_CLOTH_QUALITY_LOW = 202100,
	IDS_REFLECTION_CLOTH_QUALITY_MEDIUM,
	IDS_REFLECTION_CLOTH_QUALITY_HIGH,

	IDS_REFLECTION_FRESNEL_NONE = 202200,
	IDS_REFLECTION_FRESNEL_DIELECTRIC,
	IDS_REFLECTION_FRESNEL_CONDUCTOR,

	IDS_REFLECTION_FRESNEL_DIELECTRIC_CUSTOM = 202300,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_ASPHALT,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_BEER,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_DIAMOND,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_EMERALD,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_ETHANOL,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_GLASS,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_JADE,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_MILK,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_OIL_VEGETABLE,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_PEARL,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_PET,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_PLEXIGLASS,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_RUBY,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_SAPPHIRE,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_WATER,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_WATER_ICE,
	IDS_REFLECTION_FRESNEL_DIELECTRIC_WHISKEY,

	IDS_REFLECTION_FRESNEL_METAL_CUSTOM = 202400,
	IDS_REFLECTION_FRESNEL_METAL_ALUMINUM,
	IDS_REFLECTION_FRESNEL_METAL_BERYLLIUM,
	IDS_REFLECTION_FRESNEL_METAL_CHROMIUM,
	IDS_REFLECTION_FRESNEL_METAL_COPPER,
	IDS_REFLECTION_FRESNEL_METAL_COPPER_OXIDE,
	IDS_REFLECTION_FRESNEL_METAL_GOLD,
	IDS_REFLECTION_FRESNEL_METAL_IRIDIUM,
	IDS_REFLECTION_FRESNEL_METAL_IRON,
	IDS_REFLECTION_FRESNEL_METAL_LITHIUM,
	IDS_REFLECTION_FRESNEL_METAL_MAGNESIUM_OXIDE,
	IDS_REFLECTION_FRESNEL_METAL_MERCURY,
	IDS_REFLECTION_FRESNEL_METAL_NICKEL,
	IDS_REFLECTION_FRESNEL_METAL_NIOBIUM,
	IDS_REFLECTION_FRESNEL_METAL_POTASSIUM,
	IDS_REFLECTION_FRESNEL_METAL_RHODIUM,
	IDS_REFLECTION_FRESNEL_METAL_SELENIUM,
	IDS_REFLECTION_FRESNEL_METAL_SILICON_CARBIDE,
	IDS_REFLECTION_FRESNEL_METAL_SILVER,
	IDS_REFLECTION_FRESNEL_METAL_SODIUM,
	IDS_REFLECTION_FRESNEL_METAL_TANTALUM,
	IDS_REFLECTION_FRESNEL_METAL_TELLURIUM,
	IDS_REFLECTION_FRESNEL_METAL_TIN_TELLURIDE,
	IDS_REFLECTION_FRESNEL_METAL_TITANIUM_NITRIDE,
	IDS_REFLECTION_FRESNEL_METAL_TUNGSTEN,
	IDS_REFLECTION_FRESNEL_METAL_VANADIUM,

	IDS_LOCATEIMAGE,
	IDS_ROOTSTRING14,
	IDS_ROOTSTRING15,

	IDS_BUGREPORT_COUNTDOWN,
	IDS_BUGREPORT_TITLE_HE,

	IDS_REFLECTION_LAYER_GLOBAL_DESCENTRY,

	UNUSED_IDS_DESC_GO_TO_RESOURCE,
	UNUSED_IDS_DESC_COPY_RESOURCE_PATH,

	IDS_LAYERSET_NO_MULTI_IMAGE,
	IDS_LAYERSET_IMAGE_NAME,
	IDS_LAYERSET_LAYER_NAME,

	IDS_NEWFEATURE_OFF,

	IDS_C4D_SERIAL_WARNING1A = 202500,
	IDS_C4D_SERIAL_WARNING1B,
	IDS_C4D_SERIAL_WARNING2A,
	IDS_C4D_SERIAL_WARNING2B,
	IDS_C4D_SERIAL_WARNING3,
	IDS_CLR_SERIAL_WARNING1A,
	IDS_CLR_SERIAL_WARNING1B,
	IDS_CLR_SERIAL_WARNING2,
	IDS_CLR_SERIAL_WARNING3,
	IDS_TR_SERIAL_WARNING1,
	IDS_TR_SERIAL_WARNING2,

	IDS_SHORTCUT_KEYS,
	IDS_COLOR_TEXT_HIGHLIGHT_1_UNUSED,
	IDS_COLOR_TEXT_HIGHLIGHT_1_UNUSED_HIGHLIGHT,
	IDS_COLOR_TEXT_HIGHLIGHT_1_USED,
	IDS_COLOR_TEXT_HIGHLIGHT_1_USED_HIGHLIGHT,
	IDS_COLOR_TEXT_HIGHLIGHT_1_DISABLED,
	IDS_NEWFEATURE_LOAD_TUTORIAL,
	IDS_NEWFEATURE_LOAD_TUTORIAL2,
	IDS_NEWFEATURE_RESET_WARNING,

	IDM_MNEU_PBR,
	IDS_REFLECTION_LAYER_GLOBAL_DIFFUSE,
	IDM_LIGHTPBR,
	// IDS_DEFAULT_RENDER_SETTINGS_PREVIEW,
	// IDS_DEFAULT_RENDER_SETTINGS_FINAL,

	IDS_MEDIASESSION_OPTIONS,
	IDS_MEDIASESSION_NOOPTIONS,
	IDS_MEDIASESSION_SYSTEMOPTIONS,
	IDS_MEDIASESSION_BROWSERPRESET,
	IDS_MEDIASESSION_PRESETS,
	IDS_MEDIASESSION_PRESETS_SAVEBUTTON,
	IDS_MEDIASESSION_PRESETS_DELETEBUTTON,
	IDS_MEDIASESSION_PRESETEXISTS,
	IDS_MEDIASESSION_PRESET_DELETE_WARNING,
	IDS_MEDIASESSION_PRESET_CUSTOM,
	IDS_MEDIASESSION_PRESET_UNSUPPORTED,

	IDS_RESOLUTIONMISMATCH,

	IDM_MAXONTUTORIALS,
	IDM_LIGHTSPOT,
	IDM_LIGHTAREA,
	IDM_LIGHTINFINITE,
	IDM_SAVEINCREMENTAL,
	IDM_SAVEASTEMPLATE,
	IDM_MNEU_NIMBUS,
	IDS_HTMLTUTORIALS,
	IDS_PAINT_SAVETOOMANYALPHAS,
	IDS_EDITOR_MVP,

	IDS_COLOR_NODES_PORTCONNECTOR_BG,
	IDS_COLOR_NODES_PORTCONNECTOR_TEXT,

	IDS_COLOR_PATHLIST_INVALID_PATH,
	IDS_WARNING_PHYSICAL_DYNAMIC_MB,

	IDM_SAVE_AS_DEFAULT_SCENE,
	IDS_COFFEEWARNING_TITLE,
	IDS_COFFEEWARNING_INFO,
	IDS_COFFEEWARNING_MOREINFO,
	IDS_COFFEEWARNING_GETPLUGIN_BUTTON,
	IDS_COFFEEWARNING_GETPLUGIN_HTML,
	IDS_COFFEEWARNING_CLOSE_BUTTON,
	IDS_COFFEEWARNING_ELEMENT_MOGRAPH_EFFECTOR,
	IDS_COFFEEWARNING_ELEMENT_EXPRESSIONTAG,
	IDS_COFFEEWARNING_ELEMENT_INTERACTIONTAG,
	IDS_COFFEEWARNING_ELEMENT_XPRESSONODES,
	IDS_COFFEEWARNING_CONSOLE_SEPARATOR,
	IDS_COFFEEWARNING_CONSOLE_ELEMENTSINPROJECT,
	IDS_COFFEEWARNING_CONSOLE_PROJECTPATH,
	IDS_COLOR_SB_TEMPSELECTION,
	IDS_DESC_RESETENTRY,
	IDM_MNEU_UBERNODEMATERIAL,
	IDS_TONEMAPPING,
	IDS_MATNAME_NODE,
	IDS_MATNAME_PBR,
	IDS_MATNAME_UBER,
	IDS_NIMBUS_MATERIAL_BAKED,

	IDC_REGISTER_REGULAR,
	IDC_BINARY_TYPE,
	IDC_BINARY_SWITCH,
	IDC_REGISTER_DEMO,
	IDC_REGISTER_EDUCATION,
	IDC_REGISTER_OUTER,

	IDS_TYPETOSEARCH,
	IDS_TYPETOSEARCHFILTER,
	IDS_LIGHT_COLOR,
	IDS_DISPLAY_COLOR,
	IDS_STANDARD_MATERIAL,
	IDS_PBR_MATERIAL,
	IDS_UBER_MATERIAL,
	IDS_NODE_MATERIAL,

	IDS_PRESETPOPUP_CLOSE,

	IDM_MNEU_DEFAULT,
	IDS_MATERIAL_MANAGER_NEW_MATERIALS,
	IDS_COLOR_SLIDER_BAR_NORMAL,
	IDS_COLOR_SLIDER_BAR_FOCUS,
	IDS_COLOR_SLIDER_BAR_DISABLED,
	IDS_COLOR_MATERIALMANAGER_SELECTED_MAT,
	IDS_PREFS_THEMECOLORS_RESET_SELECTED,
	IDS_PREFS_THEMECOLORS_RESET_ALL,
	IDS_PREFS_THEMECOLORS_UNDO_RESET_SELECTED,
	IDS_PREFS_THEMECOLORS_UNDO_RESET_ALL,

	IDS_TEXTNAME_ICON_ERROR,
	IDS_TEXTNAME_INFO,
	IDS_TEXTNAME_EMPTY,

	IDS_NODE_SPACES_INTERFACE,
	IDS_MENU_NODE_SPACES,
	IDS_NODE_SPACES_CURRENT,
	IDS_NODE_SPACES_UNKNOWN,
	IDM_NODE_SPACES_RESET,
	IDS_CACHE_PROXY_TAG,
	IDS_COLOR_CLOCK_HOUR_HAND,
	IDS_COLOR_LIST_HEADER_SORT_ARROW,
	IDS_COLOR_QUICKTAB_COLUMN_SEPARATOR,

	IDC_REGISTER_ACCOUNT,
	IDC_REGISTER_OFFLINE,

	IDS_LICENSE_EXPIRATION_WARNING_ONLINE_NO_INTERNET_TITLE,
	IDS_LICENSE_EXPIRATION_WARNING_ONLINE_NO_INTERNET_POPUP,
	IDS_LICENSE_EXPIRATION_WARNING_OFFLINE_TITLE,
	IDS_LICENSE_EXPIRATION_WARNING_OFFLINE_POPUP,
	IDS_LICENSE_EXPIRATION_WARNING_TEMPORAL_TITLE,
	IDS_LICENSE_EXPIRATION_WARNING_TEMPORAL_POPUP,
	IDS_LICENSE_EXPIRATION_WARNING_TRIAL_TITLE,
	IDS_LICENSE_EXPIRATION_WARNING_TRIAL_POPUP,
	IDS_LICENSE_EXPIRATION_WARNING_EDUCATIONAL_TITLE,
	IDS_LICENSE_EXPIRATION_WARNING_EDUCATIONAL_POPUP,
	IDS_LICENSE_EXPIRATION_WARNING_DAYS_LEFT,
	IDS_LICENSE_EXPIRATION_WARNING_ONE_DAY_LEFT,
	IDS_LICENSE_EXPIRATION_WARNING_HOURS_LEFT,

	IDM_MNEU_GRASS,
	IDM_MNEU_HAIR,
	IDM_MNEU_PYROCLUSTER,
	IDM_MNEU_PYROCLUSTER_VOLUMETRACER,
	IDM_MNEU_SHADOWCATCHER,
	IDM_MNEU_SKETCH,

	IDS_COLOR_MATERIAL_PREVIEW_BORDER_RENDERING,
	IDS_COLOR_BORDER_PALETTE_EDITMODE,
	IDS_COLOR_BG_TAB_BAR,

	IDS_DENOISER,
	IDS_DENOISER_RAW,
	IDS_DENOISER_MSG,

	IDS_TRIAL_VERSION,
	IDS_NFR_VERSION,

	IDS_LICENSE_MAXON_ACCOUNT,
	IDS_LICENSE_OFFLINE,
	IDS_LICENSE_OFFLINE_SELECT,
	IDS_LICENSE_OFFLINE_INSTALL_ERROR,
	IDS_LICENSE_SERIAL_NUMBER,
	IDS_LICENSE_SERVER,
	IDS_LICENSE_RLM,
	IDS_LICENSE_UNKNOWN,
	IDS_LICENSE_STATE_SUCCESS_EX,
	IDS_LICENSE_STATE_EXPIRED_EX,
	IDS_LICENSE_STATE_FAILED_EX,
	IDS_LICENSE_INVALID_TRY,
	IDS_LICENSE_INVALID_SHUTDOWN,
	IDS_LICENSE_FREE_QUESTION,
	IDS_LICENSE_MANAGER_QUIT,

	IDS_LICENSE_EXPIRATION_WARNING_NFR_TITLE,
	IDS_LICENSE_EXPIRATION_WARNING_NFR_POPUP,

	IDS_ZYNC,

	IDS_HTMLDOCS,

	IDS_COLOR_DOTTED_LINE_IS_DEPRECATED,
	IDS_COLOR_DOTTED_LINE_DISABLED_IS_DEPRECATED,

	IDM_GOTOMAX_PREVIEWRANGE,
	IDM_GOTOMIN_PREVIEWRANGE,
		
	IDS_LICENSE_SWITCH_RESTART,

	IDC_LICENSEMANAGER_VERSION_NUMBER,

	IDM_SET_MIN_PREVIEWRANGE,
	IDM_SET_MAX_PREVIEWRANGE,
	IDM_DELETE_KEYFRAME,
	IDM_SET_KEY_ANIMATED,
	IDM_SET_KEY_HIERARCHY,
	IDM_SHOWFCURVES_POS,
	IDM_SHOWFCURVES_ROT,
	IDM_SHOWFCURVES_SCALE,
	IDM_SET_PREVIEWRANGE_TO_MARKERS,
	IDM_SET_PREVIEWRANGE_PREVIOUS_MARKER,
	IDM_SET_PREVIEWRANGE_NEXT_MARKER,
	IDM_CREATE_MARKER_COMMAND,
	ID_MARKER_TAB,
	ID_MARKER_TIME,
	ID_MARKER_TIME_LENGTH,
	ID_MARKER_COLOR,
	ID_MARKER_NAME,
	ID_MARKER_LAYER,
	ID_MARKER_TAB_MULTI,
	ID_MARKER_TAB_SINGLE,
	ID_MARKER_MULTI_BPM,
	ID_MARKER_MULTI_COUNT,
	ID_MARKER_MULTI_USE_LENGTH,
	ID_MARKER_VAL_COUNTBPM,
	ID_MARKER_PREVIEWRANGE,
	ID_MARKER_TIME_MULTI_COLFIRST,
	
	IDS_COLOR_TITLE_TEXT,
	IDS_COLOR_TITLE_BACKGROUND,

	IDS_COLOR_SB_VISIBILITY_DOT_NONE,
	IDS_COLOR_SB_VISIBILITY_DOT_ENABLED,
	IDS_COLOR_SB_VISIBILITY_DOT_DISABLED,

	IDM_VIEW_SHADOW_HINTING,
	IDS_NEWTL_M_FILTER,
	IDS_NEWTL_M_PRESETMENU,
	IDS_TL_M_USER_MODE,
	
	IDS_ASSET_CATEGORY_OTHER,
	IDS_TL_M_CREATEMARKERSELECTION,
	IDS_TL_HELP_CREATEMARKERSELECTION,

	IDS_PAINTCOLORPRESET,
	IDS_PAINTBRUSHPRESET,
	IDS_PAINTGRADIENTPRESET,
	IDS_EXCHANGE_PRESET,
	
	IDC_REGISTER_MAXONAPP,
	IDS_LICENSE_MAXON_APP,

	IDS_COLOR_FIELDS_LINKED_OBJECT_ERROR,
	IDS_COLOR_FIELDS_NON_CRITICAL_ERROR,

	IDM_VIEW_COLORSPACE,

	IDS_PENDING_JOB,
	IDS_BASEDRAW_DATA_USE_MONITOR_COLOR_SPACE_UNUSED,
	IDS_BASEDRAW_DATA_COLOR_CONVERSION_ERROR,
	IDS_DOCUMENT_CONVERT_RENDER_SPACE,
	
	IDS_IMPORT,
	IDS_EXPORT,
	
	IDS_IMEXPORT_VERIFY_SCRIPT,

	IDS_FRAMETEXTI,
	IDS_OVERWRITEFRAMES_OVERWRITE,
	IDS_OVERWRITEFRAMES_RENDERWITHOUTSAVE,
	IDS_OVERWRITEFRAMES_RENDER_MISSING,
	IDS_OVERWRITEFRAMES_REMEMBER_CHOICE,
	IDS_OVERWRITEFRAMES_NOTHINGTORENDER,

	IDS_COLOR_OVERLAY,

	IDS_COLOR_SLIDER_BG_NORMAL,
	IDS_COLOR_SLIDER_BG_FOCUS,
	IDS_COLOR_SLIDER_BG_DISABLED,

	IDS_COLOR_SLIDER_OVERFLOW_NORMAL,
	IDS_COLOR_SLIDER_OVERFLOW_FOCUS,
	IDS_COLOR_SLIDER_OVERFLOW_DISABLED,

	IDS_COLOR_SCENES_AND_LAYOUTS_TABS_BAR_BACKGROUND,
	IDS_COLOR_SCENES_AND_LAYOUTS_TABS_LAYOUT_ACTIVE_INDICATOR,
	IDS_COLOR_SCENES_AND_LAYOUTS_TABS_LAYOUT_ACTIVE_TEXT_COLOR,
	IDS_COLOR_SCENES_AND_LAYOUTS_TABS_LAYOUT_INACTIVE_TEXT_COLOR,

	IDS_CAMERA_TOGGLE_NAV_CURSOR_LOCK,

	X_DUMMY_END_X
};

// gui_coredefs (begin)
enum
{
	// IMPORTANT: maximum event number is 2000 (see GeEventsDoIt)
	// priority groups start at each multiple of 50

	MESSAGE_PAINTER_NEWAKTUBITMAP		= 650,
	MESSAGE_PAINTER_BITMAPCHANGED		= 651,

	MESSAGE_PAINTER_NEWAKTUBRUSH		= 700,
	MESSAGE_PAINTER_BRUSHCHANGED		= 701,

	MESSAGE_PAINTER_NEWAKTUCOLOR		= 750,
	MESSAGE_PAINTER_COLORCHANGED		= 751,

	MESSAGE_PAINTER_NEWAKTUPOLY			= 800,
	MESSAGE_PAINTER_POLYCHANGED			= 801,

	MESSAGE_PAINTER_TOOLCHANGED			= 850,
	MESSAGE_PAINTER_UNDOCHANGED			= 900,

	MESSAGE_PAINTER_INPUTDEVCHANGED	= 950,
	
	MESSAGE_PAINTER_POST_UPDATESTATUSBAR = 1000
};

enum
{
	VIEW_SINGLE         = 0,
	VIEW_2V             = 1,
	VIEW_2H             = 2,
	VIEW_2SPLIT_TOP     = 3,
	VIEW_2SPLIT_BOTTOM  = 4,
	VIEW_2SPLIT_LEFT    = 5,
	VIEW_2SPLIT_RIGHT   = 6,
	VIEW_4T             = 7,
	VIEW_3SPLIT_TOP     = 8,
	VIEW_3SPLIT_BOTTOM  = 9,
	VIEW_3SPLIT_LEFT    = 10,
	VIEW_3SPLIT_RIGHT   = 11,
	VIEW_4H             = 12,
	VIEW_4V             = 13,

	VIEW_DUMMY
};

enum
{
	COREMSG_PAINTER											= 'CMpa',	// container request to painter core
	COREMSG_AMBER												= 'amb6',
	COREMSG_CINEMA											= 'CMci',	// container request to C4D core

	COREMSG_SETDATA											= 'setd', // modeling tools

	// data container
	CM_DISABLED													= 'disb',
	CM_TYPE_BUTTON											= 'bttn',
	CM_TYPE_STRING											= 'strg',
		CM_STRING													= 'strg',
	CM_TYPE_INT													= 'vint',
	CM_TYPE_FLOAT												= 'vflt',
		CM_VALUE_VAL											= 'valu',	// necessary
		CM_VALUE_MIN											= 'mini',	// unnecessary
		CM_VALUE_MAX											= 'maxi',	// unnecessary
		CM_VALUE_MIN2											= 'min2', // for second range of slider with ints
		CM_VALUE_MAX2											= 'max2', // for second range of slider with ints
		CM_VALUE_STEP											= 'step',	// unnecessary
		CM_VALUE_FORMAT										= 'frmt',	// unnecessary
		CM_VALUE_FPS											= 'ffps',	// for FORMAT_FRAMES, FORMAT_SECONDS, FORMAT_SMPTE
		CM_VALUE_QUADSCALE								= 'quad',	// quadscale of the slider
		CM_VALUE_TRISTATE									= 'tris',	// 0 == off, 1 == enabled/even values 2 == enabled/different values
	CM_TYPE_DATA												= 'vdat',

	COREMSG_SYSTEM											= 'CMsy',	// container request to C4D OS
		COREMSG_SYSTEM_GETINPUTDEVICEDATA = 'Sgdd', // input device data
			CSD_INPUTDEV_NAME								= 'idna', // input device data
			CSD_INPUTDEV_ID									= 'idid', // input device data
			CSD_INPUTDEV_SUPPORT						= 'idsp',	// ...

		// request bitmap data
		COREMSG_PAINTER_GETBITMAPDATA 		= 'Pgbd', // get data of requested layer
		COREMSG_PAINTER_SETBITMAPDATA		  = 'Psbd', // set data of requested layer
			PGD_BITMAP_MARKER								= 'bmid',	// set/get bitmap marker; set only: 0 == active
			PGD_BITMAP_NAME									= 'name', // set/get layer name (string)
			PGD_BITMAP_TYPE									= 'type',	// get type of bitmap (enum)
				PGD_BITMAPTYPE_GROUP					= 'grou',	// paint layer group
				PGD_BITMAPTYPE_PIXELLAYER			= 'pixe',	// paint layer
			PGD_LAYER_STRENGTH							= 'stre', // set/get coverage (real)
			PGD_LAYER_BLENDING							= 'blnd', // set/get blending (enum)
				PGD_BLEND_NORMAL							= 'nrml',
				PGD_BLEND_DISSOLVE							= 'disv',
				PGD_BLEND_DIFFERENCE					= 'diff',
				PGD_BLEND_LIGHTEN							= 'ligt',
				PGD_BLEND_DARKEN							= 'dark',
				PGD_BLEND_MULTIPLY						= 'mult',
				PGD_BLEND_SCREEN							= 'scrn',
				PGD_BLEND_ADD									= 'add_',
				PGD_BLEND_EXCLUSION						= 'excl',
				PGD_BLEND_ERASE								= 'eras',
				PGD_BLEND_REPLACEVOXEL				= 'repl',
			PGD_LAYER_MODE									= 'mode', // set/get mode (enum)
				PGD_MODE_RGB									= 'rgb_',
				PGD_MODE_RGBA									= 'rgba',
				PGD_MODE_GREY8								= 'gry8',
				PGD_MODE_GREY8A								= 'gr8a',
				PGD_MODE_CMYK									= 'cmyk',
				PGD_MODE_CMYKA								= 'cmka',
			PGD_LAYER_SHOW									= 'show', // set/get layer visibility
			PGD_LAYER_XOFFSET								= 'xoff', // set/get x offset
			PGD_LAYER_YOFFSET								= 'yoff', // set/get y offset
			PGD_BITMAP_WIDTH								= 'widt', // get width
			PGD_BITMAP_HEIGHT								= 'heig', // get height
			PGD_MEMORY_USAGE								= 'memo',	// get memory usage

		// request data of current tool
		COREMSG_PAINTER_GETTOOL						= 'Pgtd', // get tool mode data (container)
		COREMSG_PAINTER_SETTOOL						= 'Pstd', // set tool mode data (container)
			PGD_TOOL_MODE										= 'bmmd',	// set/get tool mode
				PGD_TOOLMODE_DRAWBRUSH				= 'tdrw',	// draw with brush
				PGD_TOOLMODE_DODGE						= 'dodg',	// dodge tool
				PGD_TOOLMODE_BURN							= 'burn',	// burn tool
				PGD_TOOLMODE_SPONGE						= 'spng',	// sponge tool
				PGD_TOOLMODE_BLUR							= 'blur', // blur tool
				PGD_TOOLMODE_SHARPEN					= 'shar', // sharpen tool
				PGD_TOOLMODE_HSV							= 'thsv', // coloration tool
				PGD_TOOLMODE_SMEAR						= 'smea',	// smear tool
				PGD_TOOLMODE_FILLBITMAP				= 'fill', // fill bitmap
				PGD_TOOLMODE_MAGICWAND				= 'magc', // fill bitmap
				PGD_TOOLMODE_PICKUP						= 'pick', // pick color
				PGD_TOOLMODE_MOVESPLINE				= 'spmv',	// move spline
				PGD_TOOLMODE_EDITSPLINE				= 'sped', // edit spline
				PGD_TOOLMODE_MOVELAYER				= 'lymv',	// move layer
				PGD_TOOLMODE_DRAWLINE					= 'line',	// draw line
				PGD_TOOLMODE_DRAWCIRCLE				= 'crcl',	// draw circle
				PGD_TOOLMODE_DRAWRECTANGLE		= 'rect', // draw rectangle
				PGD_TOOLMODE_DRAWTEXT					= 'text', // text tool
				PGD_TOOLMODE_TRANSFORMBITMAP	= 'trns', // distort bitmap
				PGD_TOOLMODE_UVEDIT						= 'uved', // uvedit mode
				PGD_TOOLMODE_UVGIZMO					= 'uvgz', // uvgizmo active
				PGD_TOOLMODE_SELECTIONTOOLS		= 'sele',	// draw circle
				PGD_TOOLMODE_SELECTCOLORRANGE	= 'selc',	// select colorrange
				PGD_TOOLMODE_MAGNIFY					= 'magn', // magnify
				PGD_TOOLMODE_CLONE            = 'clon', // clone tool
				PGD_TOOLMODE_GRADIENT					= 'grad',	// gradient tool

		// for all tools
		PGD_TOOLACTIVE										= 'Pact', // tool is active

		COREMSG_PAINTER_GETBRUSHDATA			= 'Pgbr',	// get brush data
		COREMSG_PAINTER_SETBRUSHDATA			= 'Psbr',	// set brush data
			PGD_BRUSH_MARKER								= 'mark',	// brush marker
			PGD_BRUSH_NAME									= 'name',	// brush name
			PGD_BRUSH_PRESSURE							= 'pres', // brush pressure (real)
			PGD_BRUSH_PRESSURE_MODIFY				= 'mprs',	// pressure control
				PGD_MODIFY_NONE								= 'none', // no control
				PGD_MODIFY_PENPRESSURE				= 'pprs', // pen pressure
				PGD_MODIFY_PENTILT						= 'ptlt', // pen tilt
				PGD_MODIFY_PENDIRECTION				= 'pdir', // pen direction
				PGD_MODIFY_DRAWDIRECTION			= 'ddir', // draw direction
				PGD_MODIFY_DRAWRANDOM					= 'drnd', // randomness
				PGD_MODIFY_DRAWWHEEL					= 'dwhl', // mousewheel
				PGD_MODIFY_DRAWDISTANCE				= 'ddst', // distance
			PGD_BRUSH_SIZE									= 'size', // brush size (real 1..500)
			PGD_BRUSH_SIZE_MODIFY						= 'msiz', // brush size control
			PGD_BRUSH_HARD									= 'hard', // brush hardness (real 0..1)
			PGD_BRUSH_HARD_MODIFY						= 'mhar', // brush hardness control
			PGD_BRUSH_DISTANCE							= 'dist', // brush distance (real 1..oo)
			PGD_BRUSH_DISTANCE_MODIFY				= 'mdis', // brush distance control
			PGD_BRUSH_DISTANCE_ONOFF				= 'mdon', // distance on/off

		COREMSG_PAINTER_GETFILLDATA				= 'Pgfl',	// get fill data
		COREMSG_PAINTER_SETFILLDATA				= 'Psfl',	// set fill data
			PGD_FILL_TOLERANCE							= 'tole', // color tolerance (real 0..1)
			PGD_FILL_AA											= 'anti', // antialiasing (bool)
			PGD_FILL_MERGELAYER							= 'merg',	// merge layer (bool)

			PGD_CLONE_RELATIVE							= 'rela',	// (bool) clone relative
			PGD_CLONE_SCALE									= 'cscl',	// (real) clone scale
			PGD_CLONE_ROT										= 'crot',	// (real) clone rotation
			PGD_BLUR_RADIUS									= 'brad',	// (real) blur radius
			PGD_SHARPEN_STRENGTH						= 'stre',	// (real) sharpen strength

		COREMSG_PAINTER_GETMAGICDATA			= 'Pgma',	// get fill data
		COREMSG_PAINTER_SETMAGICDATA			= 'Psma',	// set fill data
			PGD_MAGIC_MODE									= 'mamo', // mode
				PGD_MAGIC_NEWSELECT						= 'senw', // create new selection
				PGD_MAGIC_NEWINVERSESELECT		= 'seiv', // create invert selection
				PGD_MAGIC_ADDSELECT						= 'sead', // add to selection
				PGD_MAGIC_SUBSELECT						= 'sesb', // subtract from selection

		COREMSG_PAINTER_GETLINEDATA				= 'Pgli',	// get line data
		COREMSG_PAINTER_SETLINEDATA				= 'Psli',	// set line data
			PGD_LINE_WIDTH									= 'liwd', // line thickness (real)
			PGD_LINE_BEGIN									= 'libg',	// start form
			PGD_LINE_END										= 'lied',	// end form
				PGD_CAPS_NONE									= 'none',
				PGD_CAPS_OUT_CIRCLE						= 'ocrc',
				PGD_CAPS_IN_CIRCLE						= 'icrc',
				PGD_CAPS_OUT_SPICE						= 'ospc',
				PGD_CAPS_IN_SPICE							= 'ispc',
				PGD_CAPS_OUT_BEVEL						= 'obvl',
				PGD_CAPS_IN_BEVEL							= 'ibvl',
				PGD_CAPS_ARROW								= 'arrw',
			PGD_POLY_DRAWMODE								= 'pldr',	// draw mode (filled/outline)
				PGD_DRAWMODE_FILLED						= 'dmfl', // filled
				PGD_DRAWMODE_OUTLINED					= 'dmol', // outline
				PGD_DRAWMODE_PATH							= 'dmpt', // path

		COREMSG_PAINTER_GETGRADIENTDATA		= 'Pgri',	// get line data
		COREMSG_PAINTER_SETGRADIENTDATA		= 'Psri',	// set line data
			PGD_GRADIENT_COL								= 'grco', // gradient color
			PGD_GRADIENT_TYPE								= 'grty', // gradient type
				PGD_GRADIENT_TYPE_LINEAR			= 'line',
				PGD_GRADIENT_TYPE_RADIAL			= 'radi',
				PGD_GRADIENT_TYPE_CIRCLE			= 'grty',
				PGD_GRADIENT_TYPE_REFLECTIVE	= 'refl',
				PGD_GRADIENT_TYPE_ROUTE				= 'rout',
			PGD_GRADIENT_DITHER							= 'grdt', // gradient type
			PGD_GRADIENT_ALPHA							= 'gral', // gradient type
			PGD_GRADIENT_INVERT							= 'grin',
			PGD_GRADIENT_BLENDMODE					= 'grbm',
			PGD_GRADIENT_BLENDSTRENGTH			= 'grbs',
			PGD_GRADIENT_NOISEVARIATION			= 'grnv',
			PGD_GRADIENT_NOISESCALE					= 'grns',
			PGD_GRADIENT_PREVIEW						= 'grpr', // gradient type
			PGD_GRADIENT_ADDPRESET					= 'grAd', // gradient type

		COREMSG_PAINTER_GETPOLYFILLDATA		= 'Pgpf',	// get polyfill data
		COREMSG_PAINTER_SETPOLYFILLDATA		= 'Pspf',	// set polyfill data
			PGD_POLYFILL_BORDER							= 'pfbd', // soft edge
			PGD_POLYFILL_ANTIALIAS					= 'anti', // antialiasing
			PGD_POLYFILL_BRUSHEDITOR				= 'bred',
			PGD_POLYFILL_BRUSHEDITORTAB			= 'bftb',

		COREMSG_PAINTER_GETCIRCLEDATA			= 'Pgcr',	// get circle data
		COREMSG_PAINTER_SETCIRCLEDATA			= 'Pscr',	// set circle data
			PGD_CIRCLE_CIRCLEMODE						= 'crmd',
				PGD_CIRCLEMODE_DIAMETER				= 'cdia',
				PGD_CIRCLEMODE_RADIUS					= 'crad',
			PGD_CIRCLE_ASPECTRATIO					= 'casp',	// aspect ratio circle

		COREMSG_PAINTER_GETPICKUPDATA			= 'Pgpd',	// get circle data
		COREMSG_PAINTER_SETPICKUPDATA			= 'Pspd',	// set circle data
			PGD_PICKUP_MODE									= 'mode', // mode
				PICKUP_MODE_SOLIDCOLOR				= 'soli', // mode
				PICKUP_MODE_TEXTURECLONE			= 'clon', // mode
				PICKUP_MODE_TEXTUREBRUSH			= 'brus', // mode
			PGD_PICKUP_SOLID_RANGE					= 'Srad', // sample radius
			PGD_PICKUP_SOLID_ENABLESAMPLING	= 'Sran', // enable sampling

		COREMSG_PAINTER_GETSPECIALBRUSH		= 'Pgpd',	// get special brush
		COREMSG_PAINTER_SETSPECIALBRUSH		= 'Pspd',	// set special brush
			PGD_SPECIALBRUSH_MODE								= 'Pdod',
				PGD_SPECIALBRUSH_MODE_SHADOW				= 1,
				PGD_SPECIALBRUSH_MODE_MID						= 2,
				PGD_SPECIALBRUSH_MODE_HIGH					= 3,
				PGD_SPECIALBRUSH_MODE_SAT						= 4,
				PGD_SPECIALBRUSH_MODE_DESAT					= 5,
			PGD_SPECIALBRUSH_STRENGTH						= 'Pstr',

	COREMSG_DUMMY
};

// Fields Strings
enum
{
	IDS_FIELDMASK												= 440000342,

	FIELDSTRINGS_DUMMY
};

#define	MESSAGE_PREV_USERAREA (-24523562)
#define	MESSAGE_PREV_REDRAW		(-24523561)
#define MESSAGE_UPDATECOMMANDS ('updc')
// gui_coredefs (end)

enum
{
	IDM_MAXONDOCS = 1019760
};

enum 
{
    IDS_HELPDIALOG_TITLE = 2000000,
		IDS_HELP_EXTERNAL_REDIRECT_ANCHOR = 2001000
};


// String for the Tangent UI
enum
{
    IDS_TANGENT_UI_IN  = 3000000,
    IDS_TANGENT_UI_OUT,
    IDS_TANGENT_UI_MIN,
    IDS_TANGENT_UI_MAX
};


#endif // C4D_SYMBOLS_H__
