CONTAINER VPrsrenderer
{
	NAME VPrsrenderer;
	INCLUDE VPbase;

	GROUP REDSHIFT_RENDERER_TAB_BASIC
	{
		DEFAULT 1;
		LONG REDSHIFT_RENDERER_SETTING_MODE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}

		SEPARATOR { LINE; }
		LONG REDSHIFT_RENDERER_BASIC_RENDERING_ENGINE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_RENDERING_ENGINE_PRODUCTION;
				REDSHIFT_RENDERER_RENDERING_ENGINE_RT;
			}
			ANIM OFF;
		}

		STRING REDSHIFT_RENDERER_BASIC_RT_UNSUPPORTED { ANIM OFF; WORDWRAP; READONLY; SCALE_V; }

		SEPARATOR { LINE; }
		LONG REDSHIFT_RENDERER_BASIC_QUALITY_PRESET
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_LOW;
				REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_MEDIUM;
				REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_HIGH;
				REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_VERY_HIGH;
				REDSHIFT_RENDERER_BASIC_QUALITY_PRESET_CUSTOM;
			}
			ANIM OFF;
			PARENTCOLLAPSE;
		}
		REAL REDSHIFT_RENDERER_BASIC_UNIFIED_ADAPTIVE_ERROR_THRESHOLD { MIN 0.0; STEP 0.001; ANIM OFF; CUSTOMGUI RSSLIDER; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_QUALITY_PRESET; }
		LONG REDSHIFT_RENDERER_BASIC_PROGRESSIVE_RENDERING_NUM_PASSES { MIN 1; MAXSLIDER 1024; STEP 1; CUSTOMGUI LONGSLIDER; ANIM OFF; }

		BOOL REDSHIFT_RENDERER_BASIC_DENOISE  { ANIM OFF; PARENTCOLLAPSE; } // REDSHIFT_RENDERER_DENOISE_ENGINE
		LONG REDSHIFT_RENDERER_BASIC_DENOISE_ENGINE // REDSHIFT_RENDERER_DENOISE_ENGINE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_DENOISE_ENGINE_OIDN;
				REDSHIFT_RENDERER_DENOISE_ENGINE_OPTIX;
				REDSHIFT_RENDERER_DENOISE_ENGINE_ALTUS_SINGLEPASS;
				REDSHIFT_RENDERER_DENOISE_ENGINE_ALTUS_DUALPASS;
			}
			ANIM OFF;
			PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_DENOISE;
		}
		BOOL REDSHIFT_RENDERER_BASIC_DENOISE_ENGINE_RT { ANIM OFF; }

		SEPARATOR { LINE; }
		BOOL REDSHIFT_RENDERER_BASIC_MOTION_BLUR { ANIM OFF; PARENTCOLLAPSE; }	// REDSHIFT_RENDERER_MOTION_BLUR_ENABLED
		LONG REDSHIFT_RENDERER_BASIC_MOTION_BLUR_TRANSFORMATIOM_STEPS { MIN 2; MAX 31; MAXSLIDER 10; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MOTION_BLUR; } // REDSHIFT_RENDERER_MOTION_BLUR_NUM_TRANSFORMATION_STEPS
		BOOL REDSHIFT_RENDERER_BASIC_MOTION_BLUR_DEFORMATION_ENABLED		{ ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MOTION_BLUR; }

		SEPARATOR { LINE; }
		GROUP
		{
			SCALE_V; COLUMNS 5;
			BOOL REDSHIFT_RENDERER_BASIC_GI_ENABLED						{ ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			BOOL REDSHIFT_RENDERER_BASIC_CAUSTICS_ENABLED				{ ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			STATICTEXT { JOINENDSCALE; }
		}
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED		{ MIN 0; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE; }
		LONG REDSHIFT_RENDERER_BASIC_COMBINED_GI_BOUNCES			{ MIN 1; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED; }
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_REFLECTION		{ MIN 0; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED; }
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_REFRACTION		{ MIN 0; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED; }
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_VOLUME			{ MIN 0; MAX 31; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED; }
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_TRANSPARENCY	{ MIN 0; MAX 255; CUSTOMGUI LONGSLIDER; ANIM OFF; }

		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED_RT		{ MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE; }
		LONG REDSHIFT_RENDERER_BASIC_COMBINED_GI_BOUNCES_RT				{ MIN 1; MAX 4; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED_RT; }
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_REFLECTION_RT		{ MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED_RT; }
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_REFRACTION_RT		{ MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_COMBINED_RT; }
		LONG REDSHIFT_RENDERER_BASIC_MAX_TRACE_DEPTH_TRANSPARENCY_RT	{ MIN 0; MAX 8; CUSTOMGUI LONGSLIDER; ANIM OFF; }

		SEPARATOR { LINE; }
		BOOL REDSHIFT_RENDERER_BASIC_HARDWARE_RAYTRACING { ANIM OFF; }

		SEPARATOR { LINE; }
		GROUP
		{
			SCALE_V; COLUMNS 1;
			STRING REDSHIFT_RENDERER_BASIC_MODIFIED { ANIM OFF; CUSTOMGUI MULTISTRING; WORDWRAP; READONLY; SCALE_V; }
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_SAMPLING
	{
		DEFAULT 1;
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_SAMPLING
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		GROUP //REDSHIFT_RENDERER_GROUP_PROGRESSIVE_RENDERING
		{
			DEFAULT 1; // Start open
			LONG REDSHIFT_RENDERER_RENDERING_ENGINE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_RENDERING_ENGINE_PRODUCTION;
					REDSHIFT_RENDERER_RENDERING_ENGINE_RT;
				}
				ANIM OFF;
			}
			STRING REDSHIFT_RENDERER_RT_UNSUPPORTED { ANIM OFF; WORDWRAP; READONLY; SCALE_V; }
			SEPARATOR { LINE; }

			LONG REDSHIFT_RENDERER_RENDER_MODE_IPR
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_RENDER_MODE_PROGRESSIVE;
					REDSHIFT_RENDERER_RENDER_MODE_BUCKET;
				}
				ANIM OFF;
			}

			LONG REDSHIFT_RENDERER_RENDER_MODE_FINAL
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_RENDER_MODE_PROGRESSIVE;
					REDSHIFT_RENDERER_RENDER_MODE_BUCKET;
				}
				ANIM OFF;
			}

			LONG REDSHIFT_RENDERER_PROGRESSIVE_RENDERING_NUM_PASSES { MIN 1; MAXSLIDER 1024; STEP 1; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			BOOL REDSHIFT_RENDERER_LIGHT_IMPORTANCE_SAMPLING_RT { ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_GROUP_SAMPLING
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_ENABLE_AUTOMATIC_SAMPLING { ANIM OFF; }							// As of 3.0.13
			REAL REDSHIFT_RENDERER_UNIFIED_ADAPTIVE_ERROR_THRESHOLD { MIN 0.0; STEP 0.001; ANIM OFF; CUSTOMGUI RSSLIDER;  }
			LONG REDSHIFT_RENDERER_UNIFIED_MIN_SAMPLES	{ MIN 1; MAX 8192; CUSTOMGUI LONGSLIDER; MAXSLIDER 1024; ANIM OFF; }
			LONG REDSHIFT_RENDERER_UNIFIED_MAX_SAMPLES	{ MIN 1; MAX 8192; CUSTOMGUI LONGSLIDER; MAXSLIDER 1024; ANIM OFF; }
			BOOL REDSHIFT_RENDERER_UNIFIED_DEBUG_DRAW_SAMPLES { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_UNIFIED_RANDOMIZE_PATTERN { ANIM OFF; }

			LONG REDSHIFT_RENDERER_UNIFIED_FILTER_TYPE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_BOX;
					REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_TRIANGLE;
					REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_GAUSS;
					REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_MITCHELL;
					REDSHIFT_RENDERER_FILTERING_FILTER_TYPE_LANCZOS;
				}
				ANIM OFF;
			}
			REAL REDSHIFT_RENDERER_UNIFIED_FILTER_SIZE { MIN 0.0; MAXSLIDER 6; STEP 0.001; ANIM OFF; }
			REAL REDSHIFT_RENDERER_UNIFIED_MAX_OVERBRIGHT { MIN 1.0; STEP 0.001; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_GLOSSY_RAY_MAX_OVERBRIGHT { MIN 1.0; STEP 0.001; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_GROUP_SAMPLING_OVERRIDE
		{
			DEFAULT 1;
			// Reflection
			BOOL REDSHIFT_RENDERER_REFLECT_SAMPLES_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_REFLECT_SAMPLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE;
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_REFLECT_SAMPLES_ENABLED;
			}
			LONG REDSHIFT_RENDERER_REFLECT_SAMPLES_COUNT { MIN 0; MAX 65535; STEP 1; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_REFLECT_SAMPLES_ENABLED; }
			REAL REDSHIFT_RENDERER_REFLECT_SAMPLES_SCALE { MIN 0.0; STEP 0.001; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_REFLECT_SAMPLES_ENABLED; }

			// Refraction
			BOOL REDSHIFT_RENDERER_REFRACT_SAMPLES_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_REFRACT_SAMPLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE;
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_REFRACT_SAMPLES_ENABLED;
			}
			LONG REDSHIFT_RENDERER_REFRACT_SAMPLES_COUNT { MIN 0; MAX 65535; STEP 1; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_REFRACT_SAMPLES_ENABLED; }
			REAL REDSHIFT_RENDERER_REFRACT_SAMPLES_SCALE { MIN 0.0; STEP 0.001; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_REFRACT_SAMPLES_ENABLED; }

			// AO
			BOOL REDSHIFT_RENDERER_AO_SAMPLES_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_AO_SAMPLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE;
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_AO_SAMPLES_ENABLED;
			}
			LONG REDSHIFT_RENDERER_AO_SAMPLES_COUNT { MIN 0; MAX 65535; STEP 1; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_AO_SAMPLES_ENABLED; }
			REAL REDSHIFT_RENDERER_AO_SAMPLES_SCALE { MIN 0.0; STEP 0.001; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_AO_SAMPLES_ENABLED; }

			// Lights
			BOOL REDSHIFT_RENDERER_LIGHT_SAMPLES_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_LIGHT_SAMPLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE;
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_LIGHT_SAMPLES_ENABLED;
			}
			LONG REDSHIFT_RENDERER_LIGHT_SAMPLES_COUNT { MIN 0; MAX 65535; STEP 1; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_LIGHT_SAMPLES_ENABLED; }
			REAL REDSHIFT_RENDERER_LIGHT_SAMPLES_SCALE { MIN 0.0; STEP 0.001; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_LIGHT_SAMPLES_ENABLED; }

			// Volume
			BOOL REDSHIFT_RENDERER_VOLUME_SAMPLES_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_VOLUME_SAMPLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE;
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_VOLUME_SAMPLES_ENABLED;
			}
			LONG REDSHIFT_RENDERER_VOLUME_SAMPLES_COUNT { MIN 0; MAX 65535; STEP 1; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_VOLUME_SAMPLES_ENABLED; }
			REAL REDSHIFT_RENDERER_VOLUME_SAMPLES_SCALE { MIN 0.0; STEP 0.001; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_VOLUME_SAMPLES_ENABLED; }

			// Single Scattering
			BOOL REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE;
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_ENABLED;
			}
			LONG REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_COUNT { MIN 0; MAX 65535; STEP 1; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_ENABLED; }
			REAL REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_SCALE { MIN 0.0; STEP 0.001; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_SINGLE_SCATTERING_SAMPLES_ENABLED; }

			// Multiple Scattering
			BOOL REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_REPLACE;
					REDSHIFT_RENDERER_SAMPLING_OVERRIDE_MODE_SCALE;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_ENABLED;
			}
			LONG REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_COUNT { MIN 0; MAX 65535; STEP 1; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_ENABLED; }
			REAL REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_SCALE { MIN 0.0; STEP 0.001; MAXSLIDER 10.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_MULTIPLE_SCATTERING_SAMPLES_ENABLED; }
		}

		GROUP REDSHIFT_RENDERER_GROUP_DENOISE
		{
			DEFAULT 0;
			BOOL REDSHIFT_RENDERER_DENOISE_ENABLED  { ANIM OFF;}
			LONG REDSHIFT_RENDERER_DENOISE_ENGINE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_DENOISE_ENGINE_OIDN;
					REDSHIFT_RENDERER_DENOISE_ENGINE_OPTIX;
					REDSHIFT_RENDERER_DENOISE_ENGINE_ALTUS_SINGLEPASS;
					REDSHIFT_RENDERER_DENOISE_ENGINE_ALTUS_DUALPASS;
				}
				ANIM OFF;
			}
			BOOL REDSHIFT_RENDERER_DENOISE_AOVS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_DENOISE_AUTO_CREATE_AOVS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_DENOISE_BUFFERS_SHOW { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_DENOISE_BUFFERS_SAVE { ANIM OFF; }

			GROUP REDSHIFT_RENDERER_GROUP_DENOISE_ALTUS
			{
				DEFAULT 1;
				REAL REDSHIFT_RENDERER_DENOISE_ALTUS_KC1 { MIN 0.0; MAX 5.0; STEP 0.001; MAXSLIDER 1.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
				REAL REDSHIFT_RENDERER_DENOISE_ALTUS_KC2 { MIN 0.0; MAX 5.0; STEP 0.001; MAXSLIDER 1.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
				REAL REDSHIFT_RENDERER_DENOISE_ALTUS_KC4 { MIN 0.0; MAX 5.0; STEP 0.001; MAXSLIDER 1.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
				REAL REDSHIFT_RENDERER_DENOISE_ALTUS_KF { MIN 0.0; MAX 5.0; STEP 0.001; MAXSLIDER 1.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
			}
			GROUP REDSHIFT_RENDERER_GROUP_DENOISE_OIDN
			{
				DEFAULT 1;
				LONG REDSHIFT_RENDERER_DENOISE_OIDN_QUALITY
				{
					CUSTOMGUI QUICKTABRADIO;
					CYCLE
					{
						REDSHIFT_RENDERER_DENOISE_OIDN_QUALITY_FAST;
						REDSHIFT_RENDERER_DENOISE_OIDN_QUALITY_BALANCED;
						REDSHIFT_RENDERER_DENOISE_OIDN_QUALITY_HIGH;
					}
					ANIM OFF;
				}
			}
			GROUP REDSHIFT_RENDERER_GROUP_DENOISE_OVERHEAD
			{
				DEFAULT 1;
				REAL REDSHIFT_RENDERER_DENOISE_OVERHEAD_BUCKET { MIN 0.0; MAX 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; ANIM OFF; }
				REAL REDSHIFT_RENDERER_DENOISE_OVERHEAD_PROGRESSIVE { MIN 0.0; MAX 100.0; STEP 0.01; CUSTOMGUI REALSLIDER; ANIM OFF; }
			}
		}

		GROUP REDSHIFT_RENDERER_GROUP_DENOISE_RT
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_DENOISE_ENGINE_RT { ANIM OFF; }							// As of 3.5.05
			REAL REDSHIFT_RENDERER_DENOISE_AGGRESSIVENESS_RT { MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_GROUP_UPSAMPLING_RT
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_UPSAMPLING_RT { ANIM OFF; }
			LONG REDSHIFT_RENDERER_UPSAMPLING_ENGINE_RT
			{
				CYCLE
				{
					REDSHIFT_RENDERER_UPSAMPLING_ENGINE_RT_DLSS;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_UPSAMPLING_MODE_RT
			{
				CYCLE
				{
					REDSHIFT_RENDERER_UPSAMPLING_MODE_RT_QUALITY;
					REDSHIFT_RENDERER_UPSAMPLING_MODE_RT_BALANCED;
					REDSHIFT_RENDERER_UPSAMPLING_MODE_RT_PERFORMANCE;
					REDSHIFT_RENDERER_UPSAMPLING_MODE_RT_ULTRAPERFORMANCE;
				}
				ANIM OFF;
			}
		}


		GROUP REDSHIFT_RENDERER_OPT_GROUP_TEXTURE_SAMPLING
		{
			DEFAULT 0;
			LONG REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_FELINE;
					REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_BILINEAR;
					REDSHIFT_RENDERER_TEXTURE_SAMPLING_TECHNIQUE_POINT;
				}
				ANIM OFF;
			}
			REAL REDSHIFT_RENDERER_BUMP_MAP_BIAS { MIN -8.0; MAX 8.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }	// As of 2.6.10
			BOOL REDSHIFT_RENDERER_COPY_TO_TEXTURE_CACHE { ANIM OFF; }
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_MOTION_BLUR
	{
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_MOTION_BLUR
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		BOOL REDSHIFT_RENDERER_MOTION_BLUR_ENABLED					{ ANIM OFF; }
		LONG REDSHIFT_RENDERER_MOTION_BLUR_NUM_TRANSFORMATION_STEPS	{ MIN 2; MAX 31; MAXSLIDER 10; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		BOOL REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_ENABLED		{ ANIM OFF; }
		LONG REDSHIFT_RENDERER_MOTION_BLUR_NUM_DEFORMATION_STEPS
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_OFF;
				REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_2;
				REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_3;
				REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_5;
				REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_9;
				REDSHIFT_RENDERER_MOTION_BLUR_DEFORMATION_STEPS_17;
			}
			ANIM OFF;
		}

		GROUP REDSHIFT_RENDERER_GROUP_MOTIONBLUR_SHUTTER
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE_STILL;
					REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE_MOVIE;
					REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TYPE_CUSTOM;
				}
				ANIM OFF;
			}

			// Still Shutter
			REAL REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_TIME_RATIO { MIN 0.02; MAX 8000.0; STEP 0.1; ANIM OFF; }

			// Movie Shutter
			REAL REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_ANGLE { STEP 1.0; UNIT DEGREE; MIN 1.0; MAX 1080.0; ANIM OFF; }
			REAL REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_OFFSET_ANGLE { STEP 1.0; UNIT DEGREE; ANIM OFF; }

			// Custom Shutter
			REAL REDSHIFT_RENDERER_MOTION_BLUR_FRAME_DURATION						{ MIN 0.001; MAXSLIDER 2.0; STEP 0.01; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_OFFSET_FRAMES				{ STEP 0.01; ANIM OFF; }
			REAL REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_START						{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF;  }
			REAL REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_END							{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_EFFICIENCY_FOR_TRAPEZOIDAL	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; CUSTOMGUI REALSLIDER; MINSLIDER 0.0; MAXSLIDER 100; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION_STARTONFRAME;
					REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION_CENTERONFRAME;
					REDSHIFT_RENDERER_MOTION_BLUR_SHUTTER_POSITION_ENDONFRAME;
				}
				ANIM OFF;
			}
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_GLOBALS
	{
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_GLOBALS
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		BOOL REDSHIFT_RENDERER_ENABLE_HARDWARE_RAYTRACING { ANIM OFF; }					// As of 3.0.00

		GROUP REDSHIFT_RENDERER_OPT_GROUP_MAX_TRACE_DEPTH
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_COMBINED		{ MIN 0; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_REFLECTION	{ MIN 0; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_REFRACTION	{ MIN 0; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_VOLUME		{ MIN 0; MAX 31; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_TRANSPARENCY	{ MIN 0; MAX 255; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_OPT_GROUP_MAX_TRACE_DEPTH_RT
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_COMBINED_RT		{ MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_REFLECTION_RT	{ MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_REFRACTION_RT	{ MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_TRACE_DEPTH_TRANSPARENCY_RT	{ MIN 0; MAX 8; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_OPT_GROUP_DISPLACEMENT_OVERRIDES
		{
			DEFAULT 1;

			BOOL REDSHIFT_RENDERER_DISPLACEMENT_GLOBAL_DISPLACEMENT { ANIM OFF; }

			LONG REDSHIFT_RENDERER_DISPLACEMENT_TYPE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_DISPLACEMENT_TYPE_VERTEX;
					REDSHIFT_RENDERER_DISPLACEMENT_TYPE_TESSELLATION_FREE;
				}
			}

			LONG REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION
			{
				CYCLE
				{
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_64;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_128;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_256;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_512;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_1024;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_2048;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_4096;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_8192;
					REDSHIFT_RENDERER_DISPLACEMENT_BAKINGRESOLUTION_16384;
				}
			}

			BOOL REDSHIFT_RENDERER_DISPLACEMENT_AUTOBUMPENABLED { }

			LONG REDSHIFT_RENDERER_DISPLACEMENT_NORMAL_INTERPOLATION
			{
				CYCLE
				{
					REDSHIFT_RENDERER_DISPLACEMENT_NORMAL_INTERPOLATION_VERTEX;
					REDSHIFT_RENDERER_DISPLACEMENT_NORMAL_INTERPOLATION_SMOOTH;
				}
			}
		}

		GROUP REDSHIFT_RENDERER_OPT_GROUP_HAIR
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_MPW_HAIR_ENABLED { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_MPW_HAIR_AUTO_THRESHOLD { ANIM OFF; }
			REAL REDSHIFT_RENDERER_MPW_HAIR_THRESHOLD	{ MIN 0.0; MAX 2.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MPW_HAIR_TRACE_DEPTH	{ MIN 0; MAX 16; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE_NONE;
					REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE_4;
					REDSHIFT_RENDERER_HAIR_TESSELLATION_MODE_8;
				}
				ANIM OFF;
			}
		}

		GROUP REDSHIFT_RENDERER_GROUP_COLOR_MANAGEMENT
		{
			DEFAULT 1;
			STATICTEXT REDSHIFT_RENDERER_COLOR_MANAGEMENT_NATIVE_MODE { ANIM OFF; SCALE_H; HIDDEN; }
			FILENAME REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_CONFIG  { ANIM OFF; }
			STRING REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_RENDERING_COLORSPACE { ANIM OFF; CUSTOMGUI RSCOLORSPACE; TYPE 0; }
			STRING REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_DISPLAY { ANIM OFF; CUSTOMGUI RSCOLORSPACE; TYPE 2; }
			STRING REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_VIEW { ANIM OFF; CUSTOMGUI RSCOLORSPACE; TYPE 3; }
			BOOL REDSHIFT_RENDERER_COLOR_MANAGEMENT_COMPENSATE_VIEW_TRANSFORM { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_COLOR_MANAGEMENT_OCIO_USE_FILE_RULES { ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_GLOBALS_GROUP_OPTIONS
		{
			DEFAULT 1;
			COLUMNS 2;
			BOOL REDSHIFT_RENDERER_INTEGRATION_OPTIONS_DEFAULT_LIGHT { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_RENDER_IN_CAMERA_SPACE { ANIM OFF; }

			BOOL REDSHIFT_RENDERER_DO_8BIT_QUANTIZATION_AND_DITHERING { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_FREEZE_TESSELLATION { ANIM OFF; }

			REAL REDSHIFT_RENDERER_CONTOUR_SCALE { MIN 1.0; MAX 32.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			STATICTEXT { JOINENDSCALE; }
			LINK REDSHIFT_RENDERER_GLOBAL_CONTOUR
			{
				ACCEPT { Mrsgraph; Mmaterial; }
				ANIM OFF;
			}
			STATICTEXT { JOINENDSCALE; }
			LINK REDSHIFT_RENDERER_ENVIRONMENT
			{
				ACCEPT { Orssky; Mrsgraph; Mmaterial; }
				ANIM OFF;
			}
			STATICTEXT { JOINENDSCALE; }
		}

		GROUP REDSHIFT_RENDERER_OPT_GROUP_GLOBAL_OVERRIDES
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_REFLECTIONS_ENABLE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_REFRACTIONS_ENABLE { ANIM OFF; PARENTCOLLAPSE; }
			BOOL REDSHIFT_RENDERER_DOME_LIGHTS_AFFECTED_BY_REFRACTION_ENABLE { ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_REFRACTIONS_ENABLE; }	// As of 2.6.10
			BOOL REDSHIFT_RENDERER_AREA_LIGHTS_AFFECTED_BY_REFRACTION_ENABLE { ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_REFRACTIONS_ENABLE; }	// As of 2.6.10
			BOOL REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_ENABLE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_EMISSION_ENABLE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_TESSELLATION_ENABLE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_DISPLACEMENT_ENABLE { ANIM OFF; }
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_GI
	{
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_GI
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		BOOL REDSHIFT_RENDERER_GI_ENABLED { ANIM OFF; }
		LONG REDSHIFT_RENDERER_PRIMARY_GI_ENGINE
		{
			CYCLE
			{
				REDSHIFT_RENDERER_GIENGINE_IRRADIANCE_CACHE;
				REDSHIFT_RENDERER_GIENGINE_BRUTE_FORCE;
			}
			ANIM OFF;
		}
		LONG REDSHIFT_RENDERER_COMBINED_GI_BOUNCES		{ MIN 1; MAX 63; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		LONG REDSHIFT_RENDERER_COMBINED_GI_BOUNCES_RT	{ MIN 1; MAX 4; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		LONG REDSHIFT_RENDERER_SECONDARY_GI_ENGINE
		{
			CYCLE
			{
				//REDSHIFT_RENDERER_GIENGINE_NONE;
				REDSHIFT_RENDERER_GIENGINE_IRRADIANCE_POINT_CLOUD;
				REDSHIFT_RENDERER_GIENGINE_BRUTE_FORCE;
			}
			ANIM OFF;
		}
		LONG REDSHIFT_RENDERER_NUM_GI_BOUNCES	{ HIDDEN; MIN 0; MAX 62; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		LONG REDSHIFT_RENDERER_BRUTE_FORCE_GI_NUM_RAYS	{ MIN 1; MAX 65535; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		BOOL REDSHIFT_RENDERER_CONSERVE_GI_REFLECTION_ENERGY { ANIM OFF; }

		GROUP REDSHIFT_RENDERER_GI_GROUP_IRRADIANCE_CACHING
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD_DONT_SAVE;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD_PREPASSONLY;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_LOAD;
				}
				ANIM OFF;
			}
			FILENAME REDSHIFT_RENDERER_IRRADIANCE_CACHE_FILENAME { SAVE; ANIM OFF; }
			BOOL REDSHIFT_RENDERER_IRRADIANCE_CACHE_FLYTHROUGH_MODE { ANIM OFF; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_BLEND_FRAMES { MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			BOOL REDSHIFT_RENDERER_SHOW_IRRADIANCE_CACHE_CALCULATION { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_IRRADIANCE_CACHE_USE_SEPARATE_POINTS_FOR_SECONDARY_RAYS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_IRRADIANCE_CACHE_DEBUG_DRAW_POINTS { ANIM OFF; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_CUSTOM;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_LOW;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_MEDIUM;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET_HIGH;
				}
				ANIM OFF;
				PARENTCOLLAPSE;
			}

			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_MIN_RATE	{ MIN -8; MAX 0; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_MAX_RATE	{ MIN -8; MAX 2; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET; }
			REAL REDSHIFT_RENDERER_IRRADIANCE_CACHE_COLOR_THRESHOLD { MIN 0.001; MAX 2.0; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_DISTANCE_THRESHOLD
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_VERY_LOW;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_LOW;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_MEDIUM;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_HIGH;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET;
			}
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_NORMAL_THRESHOLD
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_LOW;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_MEDIUM;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_THRESHOLD_HIGH;
				}
				ANIM OFF;
				PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET;
			}
			REAL REDSHIFT_RENDERER_IRRADIANCE_CACHE_MIN_DETAIL { MIN 0.0; MAX 8.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET; }
			REAL REDSHIFT_RENDERER_IRRADIANCE_CACHE_RADIUS_FACTOR { MIN 1.0; MAX 4.0; STEP 0.001;  CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_NUM_SMOOTHING_PASSES	{ MIN 0; MAX 16; CUSTOMGUI LONGSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_IRRADIANCE_CACHE_PRESET; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_CACHE_NUM_RAYS	{ MIN 1; MAX 16384; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_IRRADIANCE_CACHE_ADAPTIVE_AMOUNT { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER;  ANIM OFF; }
			REAL REDSHIFT_RENDERER_IRRADIANCE_CACHE_ADAPTIVE_ERROR_THRESHOLD { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_GI_GROUP_IRRADIANCE_POINT_CLOUD
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_MODE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD_DONT_SAVE;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD_PREPASSONLY;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_REBUILD;
					REDSHIFT_RENDERER_IRRADIANCE_CACHE_MODE_LOAD;
				}
				ANIM OFF;
			}
			FILENAME REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_FILENAME { SAVE; ANIM OFF; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_BLEND_FRAMES { MIN 0; MAX 5; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_4;
					REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_8;
					REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_16;
					REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_32;
					REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_SCREEN_RADIUS_64;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_NUM_SAMPLES_PER_PIXEL	{ MIN 1; MAX 32768; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			SEPARATOR { LINE; }
			REAL REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_FILTER_SIZE { MIN 2.0; MAX 8.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_IRRADIANCE_POINT_CLOUD_RETRACE_THRESHOLD { MIN 0.0; MAX 16.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			BOOL REDSHIFT_RENDERER_SHOW_IRRADIANCE_POINT_CLOUD_CALCULATION { ANIM OFF; }
		}

		// Deprecated
		GROUP REDSHIFT_RENDERER_GROUP_PHOTON_GI
		{
			DEFAULT 0;
			HIDDEN;
			BOOL REDSHIFT_RENDERER_PHOTON_GI_ENABLE { ANIM OFF; }
			LONG REDSHIFT_RENDERER_PHOTON_GI_MAX_NUM_TO_GATHER	{ MIN 1; MAXSLIDER 100000; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_PHOTON_GI_SEARCH_RADIUS { MIN 0; MAX 100; MAXSLIDER 50; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_CAUSTICS
	{
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_CAUSTICS
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		BOOL REDSHIFT_RENDERER_CAUSTICS_ENABLED { ANIM OFF; }
		LONG REDSHIFT_RENDERER_CAUSTICS_ENGINE
		{
			CYCLE
			{
				REDSHIFT_RENDERER_CAUSTICS_ENGINE_BRUTE_FORCE;
				REDSHIFT_RENDERER_CAUSTICS_ENGINE_PHOTON_MAPPING;
			}
			ANIM OFF;
		}

		BOOL REDSHIFT_RENDERER_CAUSTICS_OVERRIDES_ENABLED { ANIM OFF; }

		GROUP REDSHIFT_RENDERER_GROUP_CAUSTICS_GLOBAL_OVERRIDES
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_CAUSTICS_GLOBAL_OVERRIDE_REFLECTION	{ ANIM OFF; }
			BOOL REDSHIFT_RENDERER_CAUSTICS_GLOBAL_OVERRIDE_REFRACTION	{ ANIM OFF; }
			BOOL REDSHIFT_RENDERER_CAUSTICS_GLOBAL_OVERRIDE_LIGHT_CASTS_CAUSTICS	{ ANIM OFF; }
			BOOL REDSHIFT_RENDERER_CAUSTICS_GLOBAL_OVERRIDE_DISABLE_INTENSITY_CLAMP	{ ANIM OFF; }
		}

		//BOOL REDSHIFT_RENDERER_PHOTON_CAUSTICS_ENABLE_DEPRECATED { ANIM OFF; }
		GROUP REDSHIFT_RENDERER_GROUP_CAUSTICS_PHOTON
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_PHOTON_MODE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_PHOTON_MODE_REBUILD;
					REDSHIFT_RENDERER_PHOTON_MODE_LOAD;
					REDSHIFT_RENDERER_PHOTON_MODE_REBUILD_PREPASSONLY;
					REDSHIFT_RENDERER_PHOTON_MODE_REBUILD_DONT_SAVE;
				}
				ANIM OFF;
			}
			FILENAME REDSHIFT_RENDERER_PHOTON_FILENAME { SAVE; ANIM OFF; }
			SEPARATOR { LINE; }
			LONG REDSHIFT_RENDERER_PHOTON_CAUSTICS_NUM_PHOTONS { MIN 1; MINSLIDER 10000; MAXSLIDER 1000000; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_PHOTON_CAUSTICS_MAX_NUM_TO_GATHER	{ MIN 1; MAXSLIDER 4000; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_PHOTON_CAUSTICS_SEARCH_RADIUS { MIN 0; MAX 10000; MAXSLIDER 50; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }

			SEPARATOR REDSHIFT_RENDERER_GROUP_CAUSTICS_TRACEDEPTH { }
			LONG REDSHIFT_RENDERER_PHOTON_MAX_TRACE_DEPTH_REFLECTION	{ MIN 0; MAX 10; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_PHOTON_MAX_TRACE_DEPTH_REFRACTION	{ MIN 0; MAX 10; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_PHOTON_MAX_TRACE_DEPTH_COMBINED	{ MIN 0; MAX 10; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_GROUP_CAUSTICS_BRUTE_FORCE
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_CAUSTICS_BRUTE_FORCE_GI_NUM_RAYS	{ MIN 1; MAX 65535; CUSTOMGUI LONGSLIDER; ANIM OFF; } // virtual parameter
			BOOL REDSHIFT_RENDERER_CAUSTICS_INDIRECT_BRUTE_FORCE_SAMPLING_ENABLED { ANIM OFF; }
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_AOV
	{
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_AOV
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		LONG REDSHIFT_RENDERER_AOV_GLOBAL_MODE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_AOV_GLOBAL_MODE_ENABLE;
				REDSHIFT_RENDERER_AOV_GLOBAL_MODE_BATCH_ONLY;
				REDSHIFT_RENDERER_AOV_GLOBAL_MODE_DISABLE;
			}
			ANIM OFF;
		}

		SEPARATOR { LINE; }

		FILENAME REDSHIFT_RENDERER_AOV_PATH	{ ANIM OFF; SAVE; }
		BOOL REDSHIFT_RENDERER_AOV_MULTIPART { ANIM OFF; }
		BOOL REDSHIFT_RENDERER_AOV_AUTOCROP { ANIM OFF; }

		LONG REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_FLOAT16;
				REDSHIFT_RENDERER_AOV_FILE_BIT_DEPTH_FLOAT32;
			}
			ANIM OFF;
		}

		LONG REDSHIFT_RENDERER_AOV_FILE_COMPRESSION
		{
			CYCLE
			{
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_NONE;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_DEFAULT;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_RLE;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_ZIP;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_ZIPS;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_PIZ;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_PXR24;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_B44;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_DWAA;
				REDSHIFT_RENDERER_AOV_FILE_COMPRESSION_EXR_DWAB;
			}
			ANIM OFF;
		}

		REAL REDSHIFT_RENDERER_AOV_FILE_EXR_DWA_COMPRESSION		{ MIN 0.0; MAX 400.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
		LONG REDSHIFT_RENDERER_AOV_FILE_STORAGE
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_AOV_FILE_STORAGE_SCANLINE;
				REDSHIFT_RENDERER_AOV_FILE_STORAGE_TILED;
			}
			ANIM OFF;
		}
		BOOL REDSHIFT_RENDERER_AOV_MULTIPASS_COMPATIBILITY { ANIM OFF; }

		SEPARATOR { LINE; }

		GROUP
		{
			BUTTON REDSHIFT_RENDERER_AOV_MANAGER_SHOW { ANIM OFF; SCALE_H; }
		}

		GROUP REDSHIFT_RENDERER_AOV_GROUP_ACTIVE_AOVS
		{
			HIDDEN;
			DEFAULT 1;
			GROUP
			{
				COLUMNS 2;
				LONG REDSHIFT_RENDERER_AOV_QUICK_ADD { ANIM OFF; SCALE_H; }
			}
			LONG REDSHIFT_RENDERER_AOV_COUNT { ANIM OFF; MIN 0; HIDDEN; }

			SEPARATOR { LINE; }
			//RSAOV REDSHIFT_RENDERER_AOV_LAYER_1 { ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_AOV_GROUP_PROCESSING
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_AOV_ENABLE_DEEP_OUTPUT { ANIM OFF; PARENTCOLLAPSE; }
			LONG REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE
			{
				PARENTCOLLAPSE REDSHIFT_RENDERER_AOV_ENABLE_DEEP_OUTPUT;
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE_Z;
					REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE_OBJECT_ID;
					REDSHIFT_RENDERER_AOV_DEEP_MERGE_MODE_MESH_ID;
				}
				ANIM OFF;
			}
			REAL REDSHIFT_RENDERER_AOV_DEEP_MERGE_Z_THRESHOLD { MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_AOV_ENABLE_DEEP_OUTPUT; }
			REAL REDSHIFT_RENDERER_AOV_DEEP_MERGE_ALPHA_THRESHOLD { MIN 0.001; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_AOV_ENABLE_DEEP_OUTPUT; }
			BOOL REDSHIFT_RENDERER_AOV_MAX_OVERBRIGHT_ENABLE { ANIM OFF; PARENTCOLLAPSE; }
			REAL REDSHIFT_RENDERER_AOV_MAX_OVERBRIGHT { MIN 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_AOV_MAX_OVERBRIGHT_ENABLE; }
			BOOL REDSHIFT_RENDERER_AOV_DISABLE_IMPORTANCE_OPTIMIZATIONS { ANIM OFF; HIDDEN; }
			BOOL REDSHIFT_RENDERER_AOV_ENABLE_IMPORTANCE_OPTIMIZATIONS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_AOV_FIX_RAW_HALO_ARTIFACTS { ANIM OFF; }
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_OPT
	{
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_OPT
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		GROUP REDSHIFT_RENDERER_SSS_GROUP_GENERAL
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE_NONE;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE_RAY_TRACED;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_OVERRIDE_MODE_POINT_BASED;
				}
				ANIM OFF;
			}

			LONG REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_REBUILD;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_LOAD;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_REBUILD_PREPASSONLY;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_MODE_REBUILD_DONT_SAVE;
				}
				ANIM OFF;
			}
			FILENAME REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_FILENAME { SAVE; ANIM OFF; }
			LONG REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_64;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_16;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_4;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_1_1;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_4_1;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_RATE_16_1;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY_LOW;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY_MEDIUM;
					REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_INTERPOLATION_QUALITY_HIGH;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_SUBSURFACE_SCATTERING_NUM_GI_RAYS { MIN 1; MAX 4096; CUSTOMGUI LONGSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_OPT_GROUP_CUTOFF_THRESHOLDS
		{
			DEFAULT 0;
			REAL REDSHIFT_RENDERER_DIFFUSE_SAMPLING_CUT_OFF_THRESHOLD	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_REFLECTION_SAMPLING_CUT_OFF_THRESHOLD	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_REFRACTION_SAMPLING_CUT_OFF_THRESHOLD	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_DIRECT_LIGHTING_SHADOW_CUT_OFF_THRESHOLD	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_DIRECT_LIGHTING_CUT_OFF_THRESHOLD	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_OPT_GROUP_RUSSIAN_ROULETTE
		{
			DEFAULT 0;
			REAL REDSHIFT_RENDERER_RUSSIAN_ROULETTE_IMPORTANCE_THRESHOLD	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_RUSSIAN_ROULETTE_FALLOFF	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_OPT_GROUP_RUSSIAN_ROULETTE_RT
		{
			DEFAULT 1;
			REAL REDSHIFT_RENDERER_RUSSIAN_ROULETTE_IMPORTANCE_THRESHOLD_RT	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_RUSSIAN_ROULETTE_FALLOFF_THRESHOLD_RT	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_RAYTRACING_ACCELERATION_STRUCTURE
		{
			DEFAULT 0;
			BOOL REDSHIFT_RENDERER_DO_COMPLETE_RTH_CONSTRUCTION { ANIM OFF; }
			LONG REDSHIFT_RENDERER_RTH_MAX_NUM_LEAF_PRIMITIVES { MIN 2; MAX 32; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC
			{
				CYCLE
				{
					REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC_NONE;
					REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC_IPR_ONLY;
					REDSHIFT_RENDERER_PROGRESSIVE_FAST_PREPROC_ALL;
				}
				ANIM OFF;
			}
		}
	}

	GROUP REDSHIFT_RENDERER_TAB_SYSTEM
	{
		LONG REDSHIFT_RENDERER_SETTING_MODE_TAB_SYSTEM
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_RENDERER_SETTING_MODE_BASIC;
				REDSHIFT_RENDERER_SETTING_MODE_ADVANCED;
			}
			ANIM OFF;
		}
		SEPARATOR { LINE; }

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_PREVIEW_RENDERING
		{
			DEFAULT 1;
			BOOL REDSHIFT_RENDERER_PREVIEW_RENDERING_RT { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_PREVIEW_OVERLAY_RT { ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_LOG
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_LOG_LEVEL
			{
				CYCLE
				{
					REDSHIFT_RENDERER_LOG_LEVEL_ERRORS_AND_WARNINGS;
					REDSHIFT_RENDERER_LOG_LEVEL_DETAILED;
					REDSHIFT_RENDERER_LOG_LEVEL_DEBUG;
				}
				ANIM OFF;
			}

			BOOL REDSHIFT_RENDERER_LOG_DIAGNOSTICS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_LOG_IPR { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_LOG_SCENE_VALIDATION { ANIM OFF; }
			SEPARATOR { LINE; }
			BOOL REDSHIFT_RENDERER_ABORT_ON_LICENSE_FAIL { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ABORT_ON_MISSING_RESOURCE { ANIM OFF; }
			SEPARATOR { LINE; }
			LONG REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL
			{
				CYCLE
				{
					REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_ALWAYS;
					REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_ERRORS_AND_WARNINGS;
					REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_ERRORS;
					REDSHIFT_RENDERER_FEEDBACK_DISPLAY_LEVEL_NEVER;
				}
				ANIM OFF;
			}
			BUTTON REDSHIFT_RENDERER_SYSTEM_FEEDBACK_DISPLAY_SHOW { ANIM OFF; SCALE_H; }
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_BUCKET_RENDERING
		{
			DEFAULT 1;
			LONG REDSHIFT_RENDERER_BLOCK_SIZE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_BLOCK_SIZE_64;
					REDSHIFT_RENDERER_BLOCK_SIZE_128;
					REDSHIFT_RENDERER_BLOCK_SIZE_256;
					REDSHIFT_RENDERER_BLOCK_SIZE_512;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER_SPIRAL;
					REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER_SCANLINE_X;
					REDSHIFT_RENDERER_BLOCK_RENDERING_ORDER_HILBERT;
				}
				ANIM OFF;
			}
		}

		GROUP REDSHIFT_RENDERER_INTEGRATION_GROUP_SHADER_BAKING
		{
			DEFAULT 0;
			GROUP
			{
				LONG		REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_WIDTH { ANIM OFF; MIN 1; }
				LONG		REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_HEIGHT { ANIM OFF; MIN 1; }
				LONG		REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH
				{
					CUSTOMGUI QUICKTABRADIO;
					ANIM OFF;
					CYCLE
					{
						REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_8;
						REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_16;
						REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_32;
					}
				}
				SEPARATOR { LINE; }
				LONG		REDSHIFT_RENDERER_SHADER_BAKING_SKY_WIDTH { ANIM OFF; MIN 1; }
				LONG		REDSHIFT_RENDERER_SHADER_BAKING_SKY_HEIGHT { ANIM OFF; MIN 1; }
				LONG		REDSHIFT_RENDERER_SHADER_BAKING_SKY_DEPTH
				{
					CUSTOMGUI QUICKTABRADIO;
					ANIM OFF;
					CYCLE
					{
						REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_8;
						REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_16;
						REDSHIFT_RENDERER_SHADER_BAKING_TEXTURE_DEPTH_32;
					}
				}
			}
			SEPARATOR { LINE; }
			BOOL REDSHIFT_RENDERER_SHADER_BAKING_FREEZE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_SHADER_BAKING_MULTITHREADING { ANIM OFF; HIDDEN; }
		}

		GROUP REDSHIFT_RENDERER_INTEGRATION_GROUP_UNITS
		{
			DEFAULT 0;
			LONG REDSHIFT_RENDERER_INTEGRATION_UNIT_MODE
			{
				ANIM OFF;
				CYCLE
				{
					REDSHIFT_RENDERER_INTEGRATION_UNIT_MODE_DISABLED;
					REDSHIFT_RENDERER_INTEGRATION_UNIT_MODE_CUSTOM;
					REDSHIFT_RENDERER_INTEGRATION_UNIT_MODE_CORE;
				}
			}

			GROUP
			{
				COLUMNS 2;
				UNITSCALE REDSHIFT_RENDERER_INTEGRATION_EXPORT_SCALE { ANIM OFF; }
				STATICTEXT REDSHIFT_RENDERER_INTEGRATION_EXPORT_EFFECTIVE_SCALE { ANIM OFF; SCALE_H; }
			}

			SEPARATOR { LINE; }
			REAL REDSHIFT_RENDERER_PHOTOMETRIC_UNITS_TO_METER_SCALE				{ MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_PHOTOMETRIC_CANDELA_METERS_SQUARED_FACTOR	{ MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
			REAL REDSHIFT_RENDERER_IMAGE_UNITS_SCALE							{ MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_LEGACY_COMPATIBILITY_OPTIONS
		{
			DEFAULT 0;
			LINK REDSHIFT_RENDERER_EFFECT_CAMERA
			{
				ANIM OFF;
				ACCEPT { Trscamera;	}
			}
			BOOL REDSHIFT_RENDERER_MATERIAL_OVERRIDE_ENABLED { ANIM OFF; PARENTCOLLAPSE; }
			COLOR REDSHIFT_RENDERER_MATERIAL_OVERRIDE_COLOR { ANIM OFF; PARENTCOLLAPSE REDSHIFT_RENDERER_MATERIAL_OVERRIDE_ENABLED; }
			BOOL REDSHIFT_RENDERER_MATERIAL_MAX_COMBINE_TRACE_DEPTH_ENABLE { ANIM OFF; }	// As of R2.5.02
			BOOL REDSHIFT_RENDERER_UNIFIED_DISABLE_DIVISION { ANIM OFF; HIDDEN; }
			BOOL REDSHIFT_RENDERER_UNIFIED_ENABLE_DIVISION { ANIM OFF; } // Virtual
			BOOL REDSHIFT_RENDERER_INTEGRATION_INSTANCE_OPTIMIZATIONS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_VOLUME_GRID_EMISSION { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_CUT_OFFS_RULES { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_NON_INVSQ_LIGHT_DECAY { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_BUMP_SAMPLING_TECHNIQUE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_NO_GI_FROM_VOLUME_SCATTERING { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_COLOR_MANAGEMENT_HAIR { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_COLOR_MANAGEMENT_XPARTICLES { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_NON_SCALING_OF_POINT_CLOUDS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_COLOR_MANAGEMENT_MATERIAL_OVERRIDE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_CAMERA_TRANSFORMATION_BLUR { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_REFRACTION_AFFECTS_ALPHA_CHANNEL { ANIM OFF; }
			LONG REDSHIFT_RENDERER_ENABLE_LEGACY_STANDARD_MATERIAL_CONVERSION
			{
				ANIM OFF;
				CYCLE
				{
					REDSHIFT_RENDERER_LEGACY_STANDARD_CONVERSION_NONE;
					REDSHIFT_RENDERER_LEGACY_STANDARD_CONVERSION_ARCHITECTURAL;
					REDSHIFT_RENDERER_LEGACY_STANDARD_CONVERSION_RSMATERIAL;
				}
			}
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_STANDARD_SKY_CONVERSION { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_STANDARD_AO_EMULATION { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_BLACKBODY_AND_DISPERSION_TECHNIQUE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_SSS_GI { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_VOLUME_PHASE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_AUTOMATIC_VELOCITY_SOURCES { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_DISPERSION_NESTED_DIELECTRICS_TECHNIQUE { ANIM OFF; }	// Disabled for now
			BOOL REDSHIFT_RENDERER_LEGACY_C4D_HAIR_EVALUATION { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_LEGACY_HAIR_STRAND_ATTRIBUTE_SAMPLING { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_LEGACY_TIME { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_AUTOMATIC_DISPLACEMENT { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_GI_CONSERVE_REFLECTION_ENERGY_FOR_PHOTON_CAUSTICS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_AREA_LIGHT_VISIBILITY { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_CAMERA_NEAR_FAR_UNITS { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_LEGACY_IES_INTENSITY_UNITS { ANIM OFF; }
			LONG REDSHIFT_RENDERER_MATERIAL_PROCESSING_MODE
			{
				ANIM OFF;
				CYCLE
				{
					REDSHIFT_RENDERER_MATERIAL_PROCESSING_MODE_SINGLE;
					REDSHIFT_RENDERER_MATERIAL_PROCESSING_MODE_STACKED;
				}
			}
			LONG REDSHIFT_RENDERER_TEXTURE_PROJECTION_MODE
			{
				ANIM OFF;
				CYCLE
				{
					REDSHIFT_RENDERER_TEXTURE_PROJECTION_MODE_BAKED;
					REDSHIFT_RENDERER_TEXTURE_PROJECTION_MODE_PROCEDURAL;
				}
			}
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_EXPERIMENTAL_OPTIONS
		{
			DEFAULT 0;
			BOOL REDSHIFT_RENDERER_DISABLE_BUMP_SMOOTHING_ON_LIGHTING_SILHOUETTES { ANIM OFF; HIDDEN; }
			BOOL REDSHIFT_RENDERER_DISABLE_SHADOW_RAY_BIASING { ANIM OFF; HIDDEN; }
			BOOL REDSHIFT_RENDERER_ENABLE_BUMP_SMOOTHING_ON_LIGHTING_SILHOUETTES { ANIM OFF; }		// Virtual
			BOOL REDSHIFT_RENDERER_ENABLE_SHADOW_RAY_BIASING { ANIM OFF; }							// Virtual
			BOOL REDSHIFT_RENDERER_ENABLE_SECONDARY_RAY_CLAMPING_ON_FIRST_BOUNCE { ANIM OFF; }		// As of 2.5.02
			BOOL REDSHIFT_RENDERER_DISABLE_SAMPLING_OPTIMIZATIONS { ANIM OFF; HIDDEN; }				// As of 3.0.00
			BOOL REDSHIFT_RENDERER_ENABLE_SAMPLING_OPTIMIZATIONS { ANIM OFF; }						// Virtual
			LONG REDSHIFT_RENDERER_SHADING_NORMAL_ADAPTATION_TECHNIQUE								// As of 3.5.11
			{
				ANIM OFF;
				CYCLE
				{
					REDSHIFT_RENDERER_SHADING_NORMAL_ADAPTATION_TECHNIQUE_NONE;
					REDSHIFT_RENDERER_SHADING_NORMAL_ADAPTATION_TECHNIQUE_KELLER;
					REDSHIFT_RENDERER_SHADING_NORMAL_ADAPTATION_TECHNIQUE_SKEWED_REFLECTION;
				}
			}
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_DEBUG_CAPTURE
		{
			DEFAULT 0;
			BOOL REDSHIFT_RENDERER_ENABLE_DEBUG_CAPTURE { ANIM OFF; }
			BOOL REDSHIFT_RENDERER_ENABLE_DEBUG_CAPTURE_SHADER_INTEGRITY_CHECK { ANIM OFF; }
		}

		GROUP REDSHIFT_RENDERER_MEMORY_GROUP_GENERAL
		{
			DEFAULT 0;
			BOOL REDSHIFT_RENDERER_AUTOMATIC_MEMORY_MANAGEMENT { ANIM OFF; }
			LONG REDSHIFT_RENDERER_PERCENTAGE_OF_GPU_MEMORY_TO_USE { MIN 10; MAX 100; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_GPU_MEMORY_INACTIVITY_TIMEOUT { MIN 1; CUSTOMGUI LONGSLIDER; MAXSLIDER 1000; ANIM OFF; }
			LONG REDSHIFT_RENDERER_NVLINK_FOR_VOLUME_GRIDS
			{
				CYCLE
				{
					REDSHIFT_RENDERER_NVLINK_MODE_AUTOMATIC;
					REDSHIFT_RENDERER_NVLINK_MODE_FORCE_ENABLE;
					REDSHIFT_RENDERER_NVLINK_MODE_FORCE_DISABLE;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_NVLINK_FOR_GEOMETRY
			{
				CYCLE
				{
					REDSHIFT_RENDERER_NVLINK_MODE_AUTOMATIC;
					REDSHIFT_RENDERER_NVLINK_MODE_FORCE_ENABLE;
					REDSHIFT_RENDERER_NVLINK_MODE_FORCE_DISABLE;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE_AUTOMATIC;
					REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE_ENABLED;
					REDSHIFT_RENDERER_MAPPED_TEXTURE_CACHE_MODE_DISABLED;
				}
				ANIM OFF;
			}
			LONG REDSHIFT_RENDERER_MAX_NUM_GPU_MB_FOR_IRRADIANCE_POINT_CLOUD_HIERARCHY { MIN 16; MAX 4096; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_NUM_GPU_MB_FOR_FOR_ICP_HIERARCHY { MIN 16; MAX 4096; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_PERCENTAGE_OF_FREE_MEMORY_USED_FOR_TEXTURE_CACHE { MIN 10; MAX 90; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_NUM_GPU_MB_FOR_TEXTURE_CACHE { MIN 64; MAX 4096; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_MAX_NUM_CPU_MB_FOR_TEXTURE_CACHE { MIN 1024; MAX 16384; CUSTOMGUI LONGSLIDER; ANIM OFF; }
			LONG REDSHIFT_RENDERER_NUM_GPU_MB_TO_RESERVE_FOR_RAYS { MIN 0; MAX 4096; CUSTOMGUI LONGSLIDER; ANIM OFF; }

			LONG REDSHIFT_RENDERER_TEXTURE_COMPRESSION_LEVEL_RT
			{
				CYCLE
				{
					REDSHIFT_RENDERER_TEXTURE_COMPRESSION_LEVEL_RT_NONE;
					REDSHIFT_RENDERER_TEXTURE_COMPRESSION_LEVEL_RT_LOW;
					REDSHIFT_RENDERER_TEXTURE_COMPRESSION_LEVEL_RT_MEDIUM;
					REDSHIFT_RENDERER_TEXTURE_COMPRESSION_LEVEL_RT_HIGH;
					REDSHIFT_RENDERER_TEXTURE_COMPRESSION_LEVEL_RT_VERY_HIGH;
				}
				ANIM OFF;
			}

			BUTTON REDSHIFT_RENDERER_MEMORY_GENERAL_RESET_TO_DEFAULTS { ANIM OFF; SCALE_H; }
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_SHADOW_LINKING
		{
			DEFAULT 0;
			HIDDEN;
			LONG REDSHIFT_RENDERER_SHADOW_LINKING_MODE
			{
				CYCLE
				{
					REDSHIFT_RENDERER_SHADOW_LINKING_MODE_USELIGHTLINKS;
					REDSHIFT_RENDERER_SHADOW_LINKING_MODE_USESHADOWLINKS;
					REDSHIFT_RENDERER_SHADOW_LINKING_MODE_ALL;
				}
				ANIM OFF;
			}
		}

		GROUP REDSHIFT_RENDERER_SYSTEM_GROUP_DEBUG_GLOBAL_PREFERENCES
		{
			DEFAULT 0;
			HIDDEN;
			BUTTON REDSHIFT_RENDERER_SYSTEM_GLOBAL_PREFS_SHOW { ANIM OFF; SCALE_H; }
		}
	}
}
