CONTAINER Orssky
{
	NAME Orssky;
	INCLUDE Obase;

	GROUP REDSHIFT_SKY_GROUP
	{
		DEFAULT 1;
		GROUP REDSHIFT_SKY_PHYSICALSKY_GROUP_GENERAL
		{
			DEFAULT 1;
			BUTTON REDSHIFT_SKY_PHYSICALSKY_UPGRADE { ANIM OFF; SCALE_H; }
			REAL REDSHIFT_SKY_PHYSICALSKY_MULTIPLIER
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 2;
				STEP 0.001;
			}
			BOOL REDSHIFT_SKY_PHYSICALSKY_USENONPHYSICALINTENSITY {}

			LONG REDSHIFT_SKY_PHYSICALSKY_MODEL
			{
				CYCLE
				{
					REDSHIFT_SKY_PHYSICALSKY_MODEL_HOSEKWILKIE;
					REDSHIFT_SKY_PHYSICALSKY_MODEL_PREETHAM_ET_AL;
					REDSHIFT_SKY_PHYSICALSKY_MODEL_PRG_CLEAR_SKY;
				}
			}
		}

		GROUP REDSHIFT_SKY_PHYSICALSKY_GROUP_ATMOSPHERE
		{
			DEFAULT 1;
			BUTTON REDSHIFT_SKY_PHYSICALSKY_CLOUD_CREATE { ANIM OFF; SCALE_H; }
			REAL REDSHIFT_SKY_PHYSICALSKY_HAZE
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 10;
				STEP 0.001;
			}
			REAL REDSHIFT_SKY_PHYSICALSKY_OZONE
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				MIN 0;
				MAX 1;
				STEP 0.001;
			}
			REAL REDSHIFT_SKY_PHYSICALSKY_HORIZON_HEIGHT
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER -10;
				MAXSLIDER 10;
			}
			REAL REDSHIFT_SKY_PHYSICALSKY_HORIZON_BLUR
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 5;
				STEP 0.001;
			}
			COLOR REDSHIFT_SKY_PHYSICALSKY_GROUND_COLOR {}
			COLOR REDSHIFT_SKY_PHYSICALSKY_NIGHT_COLOR {}
		}

		GROUP REDSHIFT_SKY_PHYSICALSKY_GROUP_COLOR_ADJUSTMENT
		{
			DEFAULT 1;
			REAL REDSHIFT_SKY_PHYSICALSKY_REDBLUESHIFT
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER -10;
				MAXSLIDER 10;
				STEP 0.001;
				// Default 0
			}
			REAL REDSHIFT_SKY_PHYSICALSKY_SATURATION
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				STEP 0.001;
			}
			BOOL REDSHIFT_SKY_PHYSICALSKY_SATURATION_AFFECTS_COLOR_ADJUSTMENTS {}
		}
	}

	GROUP REDSHIFT_SKY_PHYSICALSKY_GROUP_SUN
	{
		DEFAULT 1;
		GROUP
		{
			COLUMNS 2;
			BUTTON REDSHIFT_SKY_PHYSICALSKY_SUN_CREATE { ANIM OFF; SCALE_H; }
			BUTTON REDSHIFT_SKY_PHYSICALSKY_SUN_REMOVE { ANIM OFF; SCALE_H; }
		}
		LINK REDSHIFT_SKY_PHYSICALSKY_SUN
		{
			ACCEPT { Orslight; }
		}
		LONG REDSHIFT_SKY_PHYSICALSKY_SUN_POSITION_MODE
		{
			CYCLE
			{
				REDSHIFT_SKY_PHYSICALSKY_SUN_POSITION_MODE_SUN_DIRECTION;
				REDSHIFT_SKY_PHYSICALSKY_SUN_POSITION_MODE_WIDGET;
			}
		}
		VECTOR REDSHIFT_SKY_PHYSICALSKY_SUN_DIRECTION {}
		REAL REDSHIFT_SKY_PHYSICALSKY_SUN_DISK_INTENSITY
		{
			CUSTOMGUI REALSLIDER;
			MINSLIDER 0;
			MAXSLIDER 10;
			STEP 0.001;
		}
		REAL REDSHIFT_SKY_PHYSICALSKY_SUN_DISK_SCALE
		{
			CUSTOMGUI REALSLIDER;
			MINSLIDER 0;
			MAXSLIDER 100;
			STEP 0.01;
		}
		REAL REDSHIFT_SKY_PHYSICALSKY_SUN_GLOW_INTENSITY
		{
			CUSTOMGUI REALSLIDER;
			MINSLIDER 0;
			MAXSLIDER 100;
			STEP 0.1;
		}
		COLOR REDSHIFT_SKY_PHYSICALSKY_SUN_TINT {}
	}

	GROUP REDSHIFT_SKY_PHYSICALSKY_GROUP_OVERRIDES
	{
		DEFAULT 0;
		BOOL REDSHIFT_SKY_PHYSICALSKY_FORCEALPHATOZERO	{}
		GROUP REDSHIFT_SKY_PHYSICALSKY_GROUP_RAY_TYPE_ENABLE
		{
			DEFAULT 1;
			BOOL REDSHIFT_SKY_PHYSICALSKY_BACKGROUND_ENABLE	{}
			BOOL REDSHIFT_SKY_PHYSICALSKY_REFLECTION_ENABLE	{}
			REAL REDSHIFT_SKY_PHYSICALSKY_REFLECTION_INTENSITY
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				STEP 0.001;
			}
			BOOL REDSHIFT_SKY_PHYSICALSKY_REFRACTION_ENABLE	{}
			REAL REDSHIFT_SKY_PHYSICALSKY_REFRACTION_INTENSITY
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				STEP 0.001;
			}
			BOOL REDSHIFT_SKY_PHYSICALSKY_GI_ENABLE	{}
			REAL REDSHIFT_SKY_PHYSICALSKY_GI_INTENSITY
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				STEP 0.001;
			}
		}
	}

	GROUP REDSHIFT_SKY_LIGHT_GROUP_DETAILS
	{
		GROUP REDSHIFT_SKY_LIGHT_GROUP_SHADOW
		{
			DEFAULT 1;
			BOOL REDSHIFT_SKY_LIGHT_SHADOW	{}
			REAL REDSHIFT_SKY_LIGHT_SHADOWTRANSPARENCY
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				MIN 0;
				MAX 1;
				STEP 0.001;
			}
		}

		GROUP REDSHIFT_SKY_LIGHT_GROUP_LIGHT_GROUP
		{
			DEFAULT 1;
			STRING REDSHIFT_SKY_LIGHT_LIGHT_GROUP  { CUSTOMGUI RSLIGHTGROUPREF; }
		}

		GROUP REDSHIFT_SKY_LIGHT_GROUP_RAY_CONTRIBUTION
		{
			DEFAULT 1;
			LONG REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION_CANCEL;
					REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION_AUTO;
					REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION_ALWAYS;
				}
			}
			LONG REDSHIFT_SKY_LIGHT_INDIRECT_MAX_TRACE_DEPTH { MIN 0; MAX 255; CUSTOMGUI LONGSLIDER; }

			SEPARATOR { LINE; }
			LONG REDSHIFT_SKY_LIGHT_DOME_SAMPLES { MIN 0; MAX 512; CUSTOMGUI LONGSLIDER; }
			LONG REDSHIFT_SKY_LIGHT_VOLUME_NUM_SAMPLES { MIN 0; MAX 512; CUSTOMGUI LONGSLIDER; }

			SEPARATOR { LINE; }
			REAL REDSHIFT_SKY_LIGHT_CAMERA_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_DIFFUSE_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_REFLECTION_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_TRANSMISSION_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_SINGLE_SCATTERING_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_MULTIPLE_SCATTERING_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_VOLUME_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_INDIRECT_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			SEPARATOR { LINE; }
			REAL REDSHIFT_SKY_LIGHT_TOON_DIFFUSE_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_SKY_LIGHT_TOON_REFLECTION_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
		}

		GROUP REDSHIFT_SKY_LIGHT_GROUP_DOME_ENVIRONMENT
		{
			DEFAULT 1;
			BOOL REDSHIFT_SKY_LIGHT_DOME_ALPHAREPLACEENABLE {}
			REAL REDSHIFT_SKY_LIGHT_DOME_ALPHAREPLACEVALUE
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				STEP 0.001;
			}
		}

		GROUP REDSHIFT_SKY_LIGHT_GROUP_PHOTON_CAUSTICS
		{
			DEFAULT 1;
			LONG REDSHIFT_SKY_LIGHT_CAUSTICS_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_SKY_LIGHT_CAUSTICS_MODE_OFF;
					REDSHIFT_SKY_LIGHT_CAUSTICS_MODE_AUTO;
					REDSHIFT_SKY_LIGHT_CAUSTICS_MODE_ON;
				}
			}

			BOOL REDSHIFT_SKY_LIGHT_CAUSTICS_OVERRIDE_REFRACTION_SHADOWS { }

			REAL REDSHIFT_SKY_LIGHT_PHOTON_CAUSTICS_INTENSITY_MULTIPLIER
			{
				CUSTOMGUI REALSLIDER;
				MIN 0;
				MAXSLIDER 10;
				STEP 0.001;
			}

			REAL REDSHIFT_SKY_LIGHT_PHOTON_CAUSTICS_PHOTON_MULTIPLIER
			{
				CUSTOMGUI REALSLIDER;
				MIN 0;
				MAXSLIDER 10;
				STEP 0.001;
			}
		}
	}

	GROUP REDSHIFT_SKY_LIGHT_GROUP_PROJECT
	{
		SCALE_V;
		BOOL REDSHIFT_SKY_LIGHT_LEGACY_MODE { HIDDEN; }

		LONG REDSHIFT_SKY_LIGHT_EXCLUSION_MODE
		{
			CYCLE
			{
				REDSHIFT_SKY_LIGHT_EXCLUSION_MODE_INCLUDE;
				REDSHIFT_SKY_LIGHT_EXCLUSION_MODE_EXCLUDE;
			}
		}

		IN_EXCLUDE  REDSHIFT_SKY_LIGHT_EXCLUSION_LIST
		{
			SCALE_V; NUM_FLAGS 3;
			INIT_STATE 7;
			IMAGE_01_ON 1009314;	IMAGE_01_OFF 1009318;	// Illumination
			IMAGE_02_ON 1009315;	IMAGE_02_OFF 1009319;	// Shadows
			IMAGE_03_ON 1009316;	IMAGE_03_OFF 1009320;	// Hierarchy
			ACCEPT { Obase; };
		}
	}
}
