#ifndef ORSSKY_H__
#define ORSSKY_H__

enum
{
	REDSHIFT_PHYSICALSKY_ON = 10000,
	REDSHIFT_SKY_PHYSICALSKY_MULTIPLIER,
	REDSHIFT_SKY_PHYSICALSKY_USENONPHYSICALINTENSITY,
	REDSHIFT_SKY_PHYSICALSKY_HAZE,
	REDSHIFT_SKY_PHYSICALSKY_OZONE,
	REDSHIFT_SKY_PHYSICALSKY_HORIZON_HEIGHT,
	REDSHIFT_SKY_PHYSICALSKY_HORIZON_BLUR,
	REDSHIFT_SKY_PHYSICALSKY_GROUND_COLOR,
	REDSHIFT_SKY_PHYSICALSKY_NIGHT_COLOR,
	REDSHIFT_SKY_PHYSICALSKY_REDBLUESHIFT,
	REDSHIFT_SKY_PHYSICALSKY_SATURATION,
	REDSHIFT_SKY_PHYSICALSKY_SUN_DIRECTION,
	REDSHIFT_SKY_PHYSICALSKY_SUN,
	REDSHIFT_SKY_PHYSICALSKY_SUN_DISK_INTENSITY,
	REDSHIFT_SKY_PHYSICALSKY_SUN_DISK_SCALE,
	REDSHIFT_SKY_PHYSICALSKY_SUN_GLOW_INTENSITY,
	REDSHIFT_SKY_PHYSICALSKY_FORCEALPHATOZERO,
	REDSHIFT_SKY_PHYSICALSKY_BACKGROUND_ENABLE,
	REDSHIFT_SKY_PHYSICALSKY_REFLECTION_ENABLE,
	REDSHIFT_SKY_PHYSICALSKY_REFLECTION_INTENSITY,
	REDSHIFT_SKY_PHYSICALSKY_REFRACTION_ENABLE,
	REDSHIFT_SKY_PHYSICALSKY_REFRACTION_INTENSITY,
	REDSHIFT_SKY_PHYSICALSKY_GI_ENABLE,
	REDSHIFT_SKY_PHYSICALSKY_GI_INTENSITY,
	REDSHIFT_SKY_PHYSICALSKY_MODEL,
	REDSHIFT_SKY_PHYSICALSKY_SUN_TINT,
	REDSHIFT_SKY_PHYSICALSKY_SATURATION_AFFECTS_COLOR_ADJUSTMENTS,

	// Enums
	REDSHIFT_SKY_PHYSICALSKY_MODEL_HOSEKWILKIE = 0,
	REDSHIFT_SKY_PHYSICALSKY_MODEL_PREETHAM_ET_AL,
	REDSHIFT_SKY_PHYSICALSKY_MODEL_PRG_CLEAR_SKY,

	// Groups
	REDSHIFT_SKY_GROUP = 20000,
	REDSHIFT_SKY_PHYSICALSKY_GROUP_GENERAL,
	REDSHIFT_SKY_PHYSICALSKY_GROUP_ATMOSPHERE,
	REDSHIFT_SKY_PHYSICALSKY_GROUP_COLOR_ADJUSTMENT,
	REDSHIFT_SKY_PHYSICALSKY_GROUP_SUN,
	REDSHIFT_SKY_PHYSICALSKY_GROUP_OVERRIDES,
	REDSHIFT_SKY_PHYSICALSKY_GROUP_RAY_TYPE_ENABLE,

	// UI Controls
	REDSHIFT_SKY_PHYSICALSKY_SUN_CREATE = 30000,
	REDSHIFT_SKY_PHYSICALSKY_SUN_REMOVE,

	// Location settings
	REDSHIFT_SKY_PHYSICALSKY_WORLD_PROPERTIES = 40000,
	REDSHIFT_SKY_PHYSICALSKY_DATETIME,
	REDSHIFT_SKY_PHYSICALSKY_DATETIME_TIMEZONE,
	REDSHIFT_SKY_PHYSICALSKY_GEOLOCATION_LATITUDE,
	REDSHIFT_SKY_PHYSICALSKY_GEOLOCATION_LONGITUDE,
	REDSHIFT_SKY_PHYSICALSKY_OVERRIDE_SUNPOSITION,

	REDSHIFT_SKY_PHYSICALSKY_CLOUD_CREATE,
	REDSHIFT_SKY_PHYSICALSKY_UPGRADE,
	REDSHIFT_SKY_PHYSICALSKY_SUN_POSITION_MODE,

	// DOME Light specific 
	REDSHIFT_SKY_LIGHT_GROUP_DETAILS,

	// Shadow
	REDSHIFT_SKY_LIGHT_GROUP_SHADOW,
	REDSHIFT_SKY_LIGHT_SHADOW,
	REDSHIFT_SKY_LIGHT_SHADOWTRANSPARENCY,

	// Light Groups
	REDSHIFT_SKY_LIGHT_GROUP_LIGHT_GROUP,
	REDSHIFT_SKY_LIGHT_LIGHT_GROUP,

	// Contributions
	REDSHIFT_SKY_LIGHT_GROUP_RAY_CONTRIBUTION,
	REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION,
	REDSHIFT_SKY_LIGHT_INDIRECT_MAX_TRACE_DEPTH,
	REDSHIFT_SKY_LIGHT_CAMERA_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_DIFFUSE_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_REFLECTION_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_TRANSMISSION_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_SINGLE_SCATTERING_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_MULTIPLE_SCATTERING_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_VOLUME_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_INDIRECT_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_TOON_DIFFUSE_RAY_CONTRIBUTION_SCALE,
	REDSHIFT_SKY_LIGHT_TOON_REFLECTION_RAY_CONTRIBUTION_SCALE,

	// Environment
	REDSHIFT_SKY_LIGHT_GROUP_DOME_ENVIRONMENT,
	REDSHIFT_SKY_LIGHT_DOME_ALPHAREPLACEENABLE,
	REDSHIFT_SKY_LIGHT_DOME_ALPHAREPLACEVALUE,

	// Caustics
	REDSHIFT_SKY_LIGHT_GROUP_PHOTON_CAUSTICS,
	REDSHIFT_SKY_LIGHT_CAUSTICS_MODE,
	REDSHIFT_SKY_LIGHT_CAUSTICS_OVERRIDE_REFRACTION_SHADOWS,
	REDSHIFT_SKY_LIGHT_PHOTON_CAUSTICS_INTENSITY_MULTIPLIER,
	REDSHIFT_SKY_LIGHT_PHOTON_CAUSTICS_PHOTON_MULTIPLIER,

	// Trace Sets
	REDSHIFT_SKY_LIGHT_GROUP_PROJECT,
	REDSHIFT_SKY_LIGHT_EXCLUSION_LIST,
	REDSHIFT_SKY_LIGHT_EXCLUSION_MODE,
	REDSHIFT_SKY_LIGHT_LEGACY_MODE,

	// Samples
	REDSHIFT_SKY_LIGHT_DOME_SAMPLES,
	REDSHIFT_SKY_LIGHT_VOLUME_NUM_SAMPLES,

	REDSHIFT_SKY_LIGHT_EXCLUSION_MODE_INCLUDE = 0,
	REDSHIFT_SKY_LIGHT_EXCLUSION_MODE_EXCLUDE,

	REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION_CANCEL = 0,
	REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION_AUTO,
	REDSHIFT_SKY_LIGHT_AFFECTED_BY_REFRACTION_ALWAYS,

	REDSHIFT_SKY_LIGHT_CAUSTICS_MODE_OFF = 0,
	REDSHIFT_SKY_LIGHT_CAUSTICS_MODE_AUTO,
	REDSHIFT_SKY_LIGHT_CAUSTICS_MODE_ON,

	REDSHIFT_SKY_PHYSICALSKY_SUN_POSITION_MODE_SUN_DIRECTION = 0,
	REDSHIFT_SKY_PHYSICALSKY_SUN_POSITION_MODE_WIDGET,
};

#endif // ORSSKY_H__
