CONTAINER Orslight
{
	NAME Orslight;
	INCLUDE Obase;

	GROUP ID_OBJECTPROPERTIES
	{
	}

	GROUP REDSHIFT_LIGHT_GROUP_GENERAL
	{
		DEFAULT 1;

		GROUP
		{
			COLUMNS 4;
			LONG REDSHIFT_LIGHT_TYPE
			{
				CYCLE
				{
					REDSHIFT_LIGHT_TYPE_PHYSICAL_POINT;
					REDSHIFT_LIGHT_TYPE_PHYSICAL_SPOT;
					REDSHIFT_LIGHT_TYPE_PHYSICAL_INFINITE;
					-1;
					REDSHIFT_LIGHT_TYPE_PHYSICAL_AREA;
					REDSHIFT_LIGHT_TYPE_DOME;
					REDSHIFT_LIGHT_TYPE_IES;
					-1;
					REDSHIFT_LIGHT_TYPE_PORTAL;
					REDSHIFT_LIGHT_TYPE_PHYSICALSUN;
				}
			}

			BUTTON REDSHIFT_LIGHT_BUTTON_GRAPH_EDIT { }
			BUTTON REDSHIFT_LIGHT_BUTTON_GRAPH_ADD_REMOVE {	}
			POPUP REDSHIFT_LIGHT_POPUP_TOOLS { }
		}

		BOOL REDSHIFT_LIGHT_OBJECT_COLOR { }

		GROUP REDSHIFT_LIGHT_GROUP_PREVIEW
		{
			DEFAULT 0;
			BOOL REDSHIFT_LIGHT_SHOW_ILLUMINATION { }
			BOOL REDSHIFT_LIGHT_PREVIEW { }
			REAL REDSHIFT_LIGHT_PREVIEW_INTENSITY_SCALE
			{
				CUSTOMGUI REALSLIDER;
				MIN 0;
				MINSLIDER 0;
				MAXSLIDER 10;
				STEP 0.001;
			}
		}


		LINK REDSHIFT_LIGHT_PARENT
		{
			HIDDEN;
		}

		GROUP REDSHIFT_LIGHT_GROUP_SHADER
		{
			DEFAULT 1;
		}

		//----------------------------------------------------------------------
		// Physical
		//----------------------------------------------------------------------
		GROUP REDSHIFT_LIGHT_GROUP_PHYSICAL
		{
			HIDDEN;
			DEFAULT 1;
			GROUP REDSHIFT_LIGHT_GROUP_PHYSICAL_INTENSITY
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_PHYSICAL_INTENSITY
				{
					CUSTOMGUI REALSLIDER;
					MIN 0;
					MINSLIDER 0;
					MAXSLIDER 100;
					STEP 0.001;
				}
				REAL REDSHIFT_LIGHT_PHYSICAL_EXPOSURE
				{
					MIN -32;
					MAX 32;
					STEP 0.001;
					CUSTOMGUI REALSLIDER;
					MINSLIDER -10;
					MAXSLIDER 10;
				}
				LONG REDSHIFT_LIGHT_PHYSICAL_UNITSTYPE
				{
					PARENTCOLLAPSE;
					CYCLE
					{
						REDSHIFT_LIGHT_UNITSTYPE_IMAGE; // 0
						REDSHIFT_LIGHT_UNITSTYPE_LUMINOUS_POWER_LM; // 1
						REDSHIFT_LIGHT_UNITSTYPE_LUMINANCE_CD_PER_MSQUARED; // 2
						REDSHIFT_LIGHT_UNITSTYPE_RADIANT_POWER_W; // 3
						REDSHIFT_LIGHT_UNITSTYPE_RADIANCE_W_PER_SR_PER_MSQUARED; // 4
						REDSHIFT_LIGHT_UNITSTYPE_LUMINOUS_INTENSITY; // 5
						REDSHIFT_LIGHT_UNITSTYPE_LUMINOUS_EXITANCE; // 6
					}
				}
				REAL REDSHIFT_LIGHT_PHYSICAL_LUMENSPERWATT
				{
					PARENTCOLLAPSE REDSHIFT_LIGHT_PHYSICAL_UNITSTYPE;
					MINSLIDER 0;
					MAXSLIDER 100;
					STEP 0.01;
				}
				LONG REDSHIFT_LIGHT_PHYSICAL_DECAYTYPE
				{
					PARENTCOLLAPSE;
					CUSTOMGUI QUICKTABRADIO;
					CYCLE
					{
						REDSHIFT_LIGHT_DECAYTYPE_NONE; // 1
						REDSHIFT_LIGHT_DECAYTYPE_LINEAR; // 2
						REDSHIFT_LIGHT_DECAYTYPE_INVERSE_SQUARE; // 0
					}
				}
				REAL REDSHIFT_LIGHT_PHYSICAL_FALLOFFSTART
				{
					MIN 0;
					UNIT METER;
					PARENTCOLLAPSE REDSHIFT_LIGHT_PHYSICAL_DECAYTYPE;
				}
				REAL REDSHIFT_LIGHT_PHYSICAL_FALLOFFSTOP
				{
					MIN 0;
					UNIT METER;
					PARENTCOLLAPSE REDSHIFT_LIGHT_PHYSICAL_DECAYTYPE;
				}
			}

			GROUP REDSHIFT_LIGHT_GROUP_PHYSICAL_COLOR
			{
				DEFAULT 1;
				LONG REDSHIFT_LIGHT_PHYSICAL_COLORMODE
				{
					CYCLE
					{
						REDSHIFT_LIGHT_COLORMODE_COLOR; // 0
						REDSHIFT_LIGHT_COLORMODE_TEMPERATURE; // 1
						REDSHIFT_LIGHT_COLORMODE_TEMPERATURE_AND_COLOR; // 2
					}
				}
				COLOR REDSHIFT_LIGHT_PHYSICAL_COLOR	{ }
				RSFILE REDSHIFT_LIGHT_PHYSICAL_TEXTURE { LAYERS 1; }
				REAL REDSHIFT_LIGHT_PHYSICAL_TEMPERATURE
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 1667;
					MAXSLIDER 25000;
				}
			}

			GROUP REDSHIFT_LIGHT_GROUP_PHYSICAL_AREA
			{
				DEFAULT 1;
				LONG REDSHIFT_LIGHT_PHYSICAL_AREA_GEOMETRY
				{
					CYCLE
					{
						REDSHIFT_LIGHT_AREA_GEOMETRY_RECTANGLE;
						REDSHIFT_LIGHT_AREA_GEOMETRY_DISC;
						REDSHIFT_LIGHT_AREA_GEOMETRY_SPHERE;
						REDSHIFT_LIGHT_AREA_GEOMETRY_CYLINDER;
						REDSHIFT_LIGHT_AREA_GEOMETRY_MESH;
					}
				}
				LINK REDSHIFT_LIGHT_PHYSICAL_AREA_MESH
				{
					ACCEPT { Obase; }
				}

				REAL REDSHIFT_LIGHT_PHYSICAL_AREA_SIZEX { UNIT METER; MIN 0.0; }
				REAL REDSHIFT_LIGHT_PHYSICAL_AREA_SIZEY { UNIT METER; MIN 0.0; }
				REAL REDSHIFT_LIGHT_PHYSICAL_AREA_SIZEZ { UNIT METER; MIN 0.0; }
				REAL REDSHIFT_LIGHT_PHYSICAL_AREA_SPREAD { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
				SEPARATOR { LINE; }
				BOOL REDSHIFT_LIGHT_PHYSICAL_AREA_BIDIRECTIONAL { }
				BOOL REDSHIFT_LIGHT_PHYSICAL_AREA_NORMALIZE { }
				BOOL REDSHIFT_LIGHT_PHYSICAL_AREA_VISIBLE_IN_RENDER { }
				REAL REDSHIFT_LIGHT_PHYSICAL_AREA_OPACITY
				{
					STEP 0.001;
					CUSTOMGUI REALSLIDER;
					MINSLIDER 0;
					MAXSLIDER 1;
				}
				RSFILE REDSHIFT_LIGHT_PHYSICAL_AREA_OPACITY_TEXTURE { LAYERS 1; }
				BOOL REDSHIFT_LIGHT_PHYSICAL_AREA_USE_ALPHA { }
			}
			GROUP REDSHIFT_LIGHT_GROUP_PHYSICAL_SPOT
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_PHYSICAL_SPOT_CONE_ANGLE { UNIT DEGREE; MIN 0.1; MAX 179.9; CUSTOMGUI REALSLIDER; }
				REAL REDSHIFT_LIGHT_PHYSICAL_SPOT_CONE_FALLOFF_ANGLE { UNIT DEGREE; MIN 0; MAX 180; CUSTOMGUI REALSLIDER; }
				REAL REDSHIFT_LIGHT_PHYSICAL_SPOT_CONE_FALLOFF_CURVE { MIN 0; MAXSLIDER 10; STEP 0.01; CUSTOMGUI REALSLIDER; }
			}
		}

		//----------------------------------------------------------------------
		// DOME
		//----------------------------------------------------------------------
		GROUP REDSHIFT_LIGHT_GROUP_DOME
		{
			HIDDEN;
			DEFAULT 1;
			GROUP REDSHIFT_LIGHT_GROUP_DOME_GENERAL
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_DOME_MULTIPLIER
				{
					CUSTOMGUI REALSLIDER;
					MIN 0;
					MINSLIDER 0;
					MAXSLIDER 5;
					STEP 0.001;
				}

				REAL REDSHIFT_LIGHT_DOME_EXPOSURE0
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER -8;
					MAXSLIDER 8;
					STEP 0.001;
					// Default 1
				}

				COLOR REDSHIFT_LIGHT_DOME_COLOR { }
				RSFILE REDSHIFT_LIGHT_DOME_TEX0	{ OPEN; }
				LONG REDSHIFT_LIGHT_DOME_ENVTYPE
				{
					CYCLE
					{
						REDSHIFT_LIGHT_DOME_ENVTYPE_SPHERICAL; // 0
						REDSHIFT_LIGHT_DOME_ENVTYPE_HEMISPHERICAL; // 1
						REDSHIFT_LIGHT_DOME_ENVTYPE_MIRROR_BALL; // 2
						REDSHIFT_LIGHT_DOME_ENVTYPE_ANGULAR; // 3
					}
				}
				BOOL REDSHIFT_LIGHT_DOME_FLIP_HORIZONTAL { }
				REAL REDSHIFT_LIGHT_DOME_ROTATE_ON_HORIZON
				{
					CUSTOMGUI REALSLIDER;
					UNIT DEGREE;
					MINSLIDER -180;
					MAXSLIDER 180;
					STEP 1;
				}

				SEPARATOR { LINE; }
				REAL REDSHIFT_LIGHT_DOME_HUE0
				{
					MIN 0;
					MAX	360;
					CUSTOMGUI REALSLIDER;
					STEP 0.001;
				}

				REAL REDSHIFT_LIGHT_DOME_SATURATION0
				{
					MIN 0;
					MAXSLIDER 100;
					CUSTOMGUI REALSLIDER;
					STEP 0.001;
				}

				REAL REDSHIFT_LIGHT_DOME_TEX0_GAMMA
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 0;
					MAXSLIDER 2.2;
					STEP 0.01;
				}
			}
			GROUP REDSHIFT_LIGHT_GROUP_DOME_ENVIRONMENT
			{
				DEFAULT 1;
				//BOOL REDSHIFT_LIGHT_DOME_BACKGROUND_ENABLE_LEGACY {}
				BOOL REDSHIFT_LIGHT_DOME_ALPHAREPLACEENABLE {}
				REAL REDSHIFT_LIGHT_DOME_ALPHAREPLACEVALUE
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 0;
					MAXSLIDER 1;
					STEP 0.001;
				}
			}
			GROUP REDSHIFT_LIGHT_GROUP_DOME_BACK_PLATE
			{
				DEFAULT 1;
				BOOL REDSHIFT_LIGHT_DOME_BACKPLATEENABLED {}
				RSFILE REDSHIFT_LIGHT_DOME_TEX1 { }
				REAL REDSHIFT_LIGHT_DOME_EXPOSURE1
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER -8;
					MAXSLIDER 8;
					STEP 0.001;
				}

				REAL REDSHIFT_LIGHT_DOME_HUE1
				{
					MIN 0;
					MAX	360;
					CUSTOMGUI REALSLIDER;
					STEP 0.001;
				}

				REAL REDSHIFT_LIGHT_DOME_SATURATION1
				{
					MIN 0;
					MAXSLIDER 100;
					CUSTOMGUI REALSLIDER;
					STEP 0.001;
				}

				REAL REDSHIFT_LIGHT_DOME_TEX1_GAMMA
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 0;
					MAXSLIDER 2.2;
					STEP 0.01;
				}
				SEPARATOR { LINE; }
				LONG REDSHIFT_LIGHT_DOME_BACKPLATEASPECT
				{
					CYCLE
					{
						REDSHIFT_LIGHT_DOME_BACKPLATEASPECT_TEXTURE; // 0
						REDSHIFT_LIGHT_DOME_BACKPLATEASPECT_RENDER; // 1
					}
				}
				BOOL REDSHIFT_LIGHT_DOME_APPLYEXPOSURECOMPENSATION {}
				SEPARATOR { LINE; }
				BUTTON REDSHIFT_LIGHT_DOME_BACKGROUND_CONVERT { }
			}
		}


		//----------------------------------------------------------------------
		// IES
		//----------------------------------------------------------------------
		GROUP REDSHIFT_LIGHT_GROUP_IES
		{
			HIDDEN;
			DEFAULT 1;

			GROUP REDSHIFT_LIGHT_GROUP_IES_INTENSITY
			{
				DEFAULT 1;
				
				RSFILE REDSHIFT_LIGHT_IES_PROFILE { COLORSPACE 0; }

				LONG REDSHIFT_LIGHT_IES_INTENSITYMODE
				{
					CYCLE
					{
						REDSHIFT_LIGHT_IES_INTENSITYMODE_FROM_FILE; // 0
						REDSHIFT_LIGHT_IES_INTENSITYMODE_OVERRIDE; // 1
					}
				}
				
				REAL REDSHIFT_LIGHT_IES_OVERRIDE_VALUE
				{
					CUSTOMGUI REALSLIDER;
					MIN 0;
					MINSLIDER 0;
					MAXSLIDER 10000;
					STEP 0.001;
				}

				LONG REDSHIFT_LIGHT_IES_OVERRIDE_UNIT
				{
					DEFAULT 1;
					CYCLE
					{
						REDSHIFT_LIGHT_UNITSTYPE_LUMINOUS_POWER_LM; // 1
						REDSHIFT_LIGHT_UNITSTYPE_LUMINOUS_INTENSITY; // 5
					}
				}
				
				REAL REDSHIFT_LIGHT_IES_MULTIPLIER
				{
					CUSTOMGUI REALSLIDER;
					MIN 0;
					MINSLIDER 0;
					MAXSLIDER 2;
					STEP 0.001;
				}

				REAL REDSHIFT_LIGHT_IES_EXPOSURE
				{
					MIN -32;
					MAX 32;
					STEP 0.001;
					CUSTOMGUI REALSLIDER;
					MINSLIDER -10;
					MAXSLIDER 10;
				}
			}

			GROUP REDSHIFT_LIGHT_GROUP_IES_COLOR
			{
				DEFAULT 1;
				LONG REDSHIFT_LIGHT_IES_COLORMODE
				{
					CYCLE
					{
						REDSHIFT_LIGHT_COLORMODE_COLOR; // 0
						REDSHIFT_LIGHT_COLORMODE_TEMPERATURE; // 1
					}
				}
				COLOR REDSHIFT_LIGHT_IES_COLOR {}
				REAL REDSHIFT_LIGHT_IES_TEMPERATURE
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 1667;
					MAXSLIDER 25000;
				}
			}

		}


		//----------------------------------------------------------------------
		// Portal
		//----------------------------------------------------------------------
		GROUP REDSHIFT_LIGHT_GROUP_PORTAL
		{
			HIDDEN;
			DEFAULT 1;

			GROUP REDSHIFT_LIGHT_GROUP_PORTAL_INTENSITY
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_PORTAL_MULTIPLIER
				{
					CUSTOMGUI REALSLIDER;
					MIN 0;
					MINSLIDER 0;
					MAXSLIDER 2;
					STEP 0.001;
				}
				REAL REDSHIFT_LIGHT_PORTAL_EXPOSURE
				{
					MIN -32;
					MAX 32;
					STEP 0.001;
					CUSTOMGUI REALSLIDER;
					MINSLIDER -10;
					MAXSLIDER 10;
				}
			}
			GROUP REDSHIFT_LIGHT_GROUP_PORTAL_COLOR
			{
				DEFAULT 1;
				COLOR REDSHIFT_LIGHT_PORTAL_TINT_COLOR {}
				COLOR REDSHIFT_LIGHT_PORTAL_TRANSPARENCY {}
				LINK REDSHIFT_LIGHT_PORTAL_ENVIRONMENT_SHADER
				{
					ACCEPT
					{
						Mrsgraph;
						Mmaterial;	// Nodes material with Redshift nodespace
						Obase;		// Ideally we just want Orssky, but it causes a cyclical reference
					}
				}
			}

			GROUP REDSHIFT_LIGHT_GROUP_PORTAL_SHAPE
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_PORTAL_SIZEX { UNIT METER; MIN 0.0; }
				REAL REDSHIFT_LIGHT_PORTAL_SIZEY { UNIT METER; MIN 0.0; }
				REAL REDSHIFT_LIGHT_PORTAL_SPREAD { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
			}
		}


		//----------------------------------------------------------------------
		// Sun
		//----------------------------------------------------------------------
		GROUP REDSHIFT_LIGHT_GROUP_PHYSICALSUN
		{
			HIDDEN;
			DEFAULT 1;

			GROUP REDSHIFT_LIGHT_GROUP_PHYSICALSUN_INTENSITY
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_PHYSICALSUN_MULTIPLIER
				{
					CUSTOMGUI REALSLIDER;
					MIN 0;
					MINSLIDER 0;
					MAXSLIDER 2;
					STEP 0.001;
				}

				BOOL REDSHIFT_LIGHT_PHYSICALSUN_USENONPHYSICALINTENSITY {}
				REAL REDSHIFT_LIGHT_PHYSICALSUN_SUN_DISK_SCALE
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 0;
					MAXSLIDER 100;
					STEP 0.01;
				}
				LONG REDSHIFT_LIGHT_PHYSICALSUN_MODEL
				{
					CYCLE
					{
						REDSHIFT_LIGHT_PHYSICALSUN_MODEL_PRG_CLEAR_SKY;
						REDSHIFT_LIGHT_PHYSICALSUN_MODEL_LEGACY;
					}
				}
			}
			GROUP REDSHIFT_LIGHT_GROUP_PHYSICALSUN_COLOR
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_PHYSICALSUN_REDBLUESHIFT
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER -10;
					MAXSLIDER 10;
					STEP 0.01;
				}
				REAL REDSHIFT_LIGHT_PHYSICALSUN_SATURATION
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 0;
					MAXSLIDER 1;
					STEP 0.001;
				}
				COLOR REDSHIFT_LIGHT_PHYSICALSUN_TINT {}
			}
			GROUP REDSHIFT_LIGHT_GROUP_PHYSICALSUN_ATMOSPHERE
			{
				DEFAULT 1;
				REAL REDSHIFT_LIGHT_PHYSICALSUN_HAZE
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 2;
					MAXSLIDER 10;
					STEP 0.01;
				}
				REAL REDSHIFT_LIGHT_PHYSICALSUN_OZONE
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER 0;
					MAXSLIDER 1;
					MIN 0;
					MAX 1;
					STEP 0.001;
				}
				REAL REDSHIFT_LIGHT_PHYSICALSUN_HORIZON_HEIGHT
				{
					CUSTOMGUI REALSLIDER;
					MINSLIDER -100;
					MAXSLIDER 100;
					STEP 0.01;
				}
			}
		}
	}

	GROUP REDSHIFT_LIGHT_GROUP_DETAILS
	{
		GROUP REDSHIFT_LIGHT_GROUP_SHADOW
		{
			DEFAULT 1;
			BOOL REDSHIFT_LIGHT_SHADOW	{}
			REAL REDSHIFT_LIGHT_SHADOWTRANSPARENCY
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 1;
				MIN 0;
				MAX 1;
				STEP 0.001;
			}
			REAL REDSHIFT_LIGHT_SAMPLINGOVERRIDES_SHADOWSAMPLESSCALE
			{
				CUSTOMGUI REALSLIDER;
				MINSLIDER 0;
				MAXSLIDER 2;
				STEP 0.001;
			}
			LONG REDSHIFT_LIGHT_SAMPLINGOVERRIDES_NUMSHADOWSAMPLES
			{
				CUSTOMGUI LONGSLIDER;
				MINSLIDER 1;
				MAXSLIDER 256;
				MIN 0;
				MAX 4096;
			}
			BOOL REDSHIFT_LIGHT_SOFTNESS_AFFECTS_GOBO { }
		}

		GROUP REDSHIFT_LIGHT_GROUP_LIGHT_GROUP
		{
			DEFAULT 1;
			STRING REDSHIFT_LIGHT_LIGHT_GROUP  { CUSTOMGUI RSLIGHTGROUPREF; }
		}

		GROUP REDSHIFT_LIGHT_GROUP_RAY_CONTRIBUTION
		{
			DEFAULT 1;
			BOOL REDSHIFT_LIGHT_MATTE_SHADOW_ILLUMINATOR { }
			LONG REDSHIFT_LIGHT_AFFECTED_BY_REFRACTION
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_LIGHT_AFFECTED_BY_REFRACTION_CANCEL;
					REDSHIFT_LIGHT_AFFECTED_BY_REFRACTION_AUTO;
					REDSHIFT_LIGHT_AFFECTED_BY_REFRACTION_ALWAYS;
				}
			}
			LONG REDSHIFT_LIGHT_INDIRECT_MAX_TRACE_DEPTH { MIN 0; MAX 255; CUSTOMGUI LONGSLIDER; }

			SEPARATOR { LINE; }
			LONG REDSHIFT_LIGHT_PHYSICAL_AREA_SAMPLES { MIN 0; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; }
			LONG REDSHIFT_LIGHT_DOME_SAMPLES { MIN 0; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; }
			LONG REDSHIFT_LIGHT_PORTAL_SAMPLES { MIN 0; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; }
			LONG REDSHIFT_LIGHT_VOLUME_NUM_SAMPLES { MIN 0; MAXSLIDER 512; CUSTOMGUI LONGSLIDER; }

			SEPARATOR { LINE; }
			//BOOL REDSHIFT_LIGHT_AFFECTS_DIFFUSE_DEPRECATED { }
			//BOOL REDSHIFT_LIGHT_AFFECTS_SPECULAR_DEPRECATED { }
			REAL REDSHIFT_LIGHT_CAMERA_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_DIFFUSE_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			//REAL REDSHIFT_LIGHT_GLOSSY_RAY_CONTRIBUTION_SCALE_DEPRECATED { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_REFLECTION_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_TRANSMISSION_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_SINGLE_SCATTERING_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_MULTIPLE_SCATTERING_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_VOLUME_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_INDIRECT_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			SEPARATOR { LINE; }
			REAL REDSHIFT_LIGHT_TOON_DIFFUSE_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_TOON_REFLECTION_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_LIGHT_TOON_RIM_RAY_CONTRIBUTION_SCALE { MIN 0; MAX 100; MAXSLIDER 1; STEP 0.001; CUSTOMGUI REALSLIDER; }
		}

		GROUP REDSHIFT_LIGHT_GROUP_PHOTON_CAUSTICS
		{
			DEFAULT 1;
			//BOOL REDSHIFT_LIGHT_CAUSTICS_ENABLED_DEPRECATED { }

			LONG REDSHIFT_LIGHT_CAUSTICS_MODE
			{
				CUSTOMGUI QUICKTABRADIO;
				CYCLE
				{
					REDSHIFT_LIGHT_CAUSTICS_MODE_OFF;
					REDSHIFT_LIGHT_CAUSTICS_MODE_AUTO;
					REDSHIFT_LIGHT_CAUSTICS_MODE_ON;
				}
			}

			BOOL REDSHIFT_LIGHT_CAUSTICS_OVERRIDE_REFRACTION_SHADOWS { }

			REAL REDSHIFT_LIGHT_PHOTON_CAUSTICS_INTENSITY_MULTIPLIER
			{
				CUSTOMGUI REALSLIDER;
				MIN 0;
				MAXSLIDER 10;
				STEP 0.001;
			}

			REAL REDSHIFT_LIGHT_PHOTON_CAUSTICS_PHOTON_MULTIPLIER
			{
				CUSTOMGUI REALSLIDER;
				MIN 0;
				MAXSLIDER 10;
				STEP 0.001;
			}
		}

		GROUP REDSHIFT_LIGHT_GROUP_LEGACY
		{
			DEFAULT 0;
			BOOL REDSHIFT_LIGHT_LEGACY_NON_AREA_LIGHT_INTENSITY { }
			BOOL REDSHIFT_LIGHT_LEGACY_SOFT_SHADOW_TECHNIQUE { }
			BOOL REDSHIFT_LIGHT_PHYSICALSUN_SATURATION_AFFECTS_COLOR_ADJUSTMENTS {}
			BOOL REDSHIFT_LIGHT_LEGACY_SPREAD_INTENSITY { }
			BOOL REDSHIFT_LIGHT_LEGACY_UV_COMPUTATION { }
			//BOOL REDSHIFT_LIGHT_LEGACY_MESH_LIGHT_FEATURES_DEPRECATED { }
		}

		// REMIX: Remove this
		GROUP REDSHIFT_LIGHT_GROUP_PHOTON_GI
		{
			HIDDEN;
			DEFAULT 0;
			BOOL REDSHIFT_LIGHT_GI_ENABLED { }
			REAL REDSHIFT_LIGHT_PHOTON_GI_INTENSITY_MULTIPLIER
			{
				CUSTOMGUI REALSLIDER;
				MIN 0;
				MAXSLIDER 10;
				STEP 0.001;
			}
			LONG REDSHIFT_LIGHT_PHOTON_GI_NUM_PHOTONS
			{
				MIN 0;
			}
		}
	}

	GROUP REDSHIFT_LIGHT_GROUP_PROJECT
	{
		SCALE_V;

		LONG REDSHIFT_LIGHT_EXCLUSION_MODE
		{
			CYCLE
			{
				REDSHIFT_LIGHT_EXCLUSION_MODE_INCLUDE;
				REDSHIFT_LIGHT_EXCLUSION_MODE_EXCLUDE;
			}
		}

		IN_EXCLUDE  REDSHIFT_LIGHT_EXCLUSION_LIST
		{
			SCALE_V; NUM_FLAGS 3;
			INIT_STATE 7;
			IMAGE_01_ON 1009314;	IMAGE_01_OFF 1009318;	// Illumination
			IMAGE_02_ON 1009315;	IMAGE_02_OFF 1009319;	// Shadows
			IMAGE_03_ON 1009316;	IMAGE_03_OFF 1009320;	// Hierarchy
			ACCEPT { Obase; };
		}
	}

}
