CONTAINER Drsposteffects
{
	NAME Drsposteffects;

	GROUP REDSHIFT_POSTEFFECTS_GROUP_DOF
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_DOF_OVERRIDE { }
			BOOL REDSHIFT_POSTEFFECTS_DOF_ENABLED { }
		}

		GROUP REDSHIFT_POSTEFFECTS_GROUP_DOF_FOCUS_SETTINGS
		{
			DEFAULT 1;
			LONG REDSHIFT_POSTEFFECTS_DOF_DERIVE_CAMERA
			{
				CYCLE
				{
					REDSHIFT_POSTEFFECTS_DOF_DERIVE_CAMERA_NONE;
					REDSHIFT_POSTEFFECTS_DOF_DERIVE_CAMERA_FOCUS_DISTANCE;
					REDSHIFT_POSTEFFECTS_DOF_DERIVE_CAMERA_FOCUS_DISTANCE_RADIUS;
				}
			}
			REAL REDSHIFT_POSTEFFECTS_DOF_FOCUS_DISTANCE { MIN 0.0; STEP 0.1; UNIT METER; CUSTOMGUI REALSLIDER; MAXSLIDER 10000.0; }
			REAL REDSHIFT_POSTEFFECTS_DOF_RADIUS { MIN 0.0; STEP 0.01; CUSTOMGUI REALSLIDER; MAXSLIDER 100.0; }
			REAL REDSHIFT_POSTEFFECTS_DOF_POWER { MIN 0.0; STEP 0.01; CUSTOMGUI REALSLIDER; MAXSLIDER 100.0; }
			REAL REDSHIFT_POSTEFFECTS_DOF_ASPECT { MIN 0.0; STEP 0.01; CUSTOMGUI REALSLIDER; MAXSLIDER 4.0; }
		}

		GROUP REDSHIFT_POSTEFFECTS_GROUP_DOF_SHUTTER_BLADES
		{
			DEFAULT 1;
			LONG REDSHIFT_POSTEFFECTS_DOF_BLADE_COUNT { MIN 0; MAX 64; CUSTOMGUI LONGSLIDER; }
			REAL REDSHIFT_POSTEFFECTS_DOF_BLADE_ANGLE { MIN 0.0; MAX 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		}

		GROUP REDSHIFT_POSTEFFECTS_GROUP_DOF_IMAGE
		{
			DEFAULT 1;
			BOOL REDSHIFT_POSTEFFECTS_DOF_BOKE_IMAGE_ENABLED { }
			LONG REDSHIFT_POSTEFFECTS_DOF_BOKE_NORMALIZATION_MODE
			{
				CYCLE
				{
					REDSHIFT_POSTEFFECTS_DOF_BOKE_NORMALIZATION_MODE_NONE;
					REDSHIFT_POSTEFFECTS_DOF_BOKE_NORMALIZATION_MODE_UNIT_INTENSITY;
					REDSHIFT_POSTEFFECTS_DOF_BOKE_NORMALIZATION_MODE_WHITE_COLOR_SUM;
				}
			}
			RSFILE REDSHIFT_POSTEFFECTS_DOF_BOKE_IMAGE { COLORSPACE 0; OPEN; }
		}
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_DISTORTION
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_DISTORTION_OVERRIDE { }
			BOOL REDSHIFT_POSTEFFECTS_DISTORTION_ENABLED { }
		}

		RSFILE REDSHIFT_POSTEFFECTS_DISTORTION_IMAGE { COLORSPACE 0; OPEN; }
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_LUT
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_LUT_OVERRIDE { }
			BOOL REDSHIFT_POSTEFFECTS_LUT_ENABLED { }
		}

		FILENAME REDSHIFT_POSTEFFECTS_LUT_FILE { }
		BOOL REDSHIFT_POSTEFFECTS_LUT_LOG_INPUT { }
		BOOL REDSHIFT_POSTEFFECTS_LUT_APPLY_BEFORE_COLOR_MANAGEMENT { }
		REAL REDSHIFT_POSTEFFECTS_LUT_STRENGTH { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_COLORCONTROL
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_COLORCONTROL_OVERRIDE { }
			BOOL REDSHIFT_POSTEFFECTS_COLORCONTROL_ENABLED { }
		}

		REAL REDSHIFT_POSTEFFECTS_COLORCONTROL_EXPOSURE { MIN -16.0; MAX 16.0; STEP 0.001; MINSLIDER -4.0; MAXSLIDER 4.0; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_COLORCONTROL_CONTRAST { MIN -1.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }

		GROUP REDSHIFT_POSTEFFECTS_GROUP_COLORCONTROL_CURVES
		{
			DEFAULT 1;
			RSPFXCURVE REDSHIFT_POSTEFFECTS_COLORCONTROL_CURVE_RGB { COLOR 0.9 0.9 0.9; }
			RSPFXCURVE REDSHIFT_POSTEFFECTS_COLORCONTROL_CURVE_RED { COLOR 0.9 0.0 0.0; }
			RSPFXCURVE REDSHIFT_POSTEFFECTS_COLORCONTROL_CURVE_GREEN { COLOR 0.0 0.9 0.0; }
			RSPFXCURVE REDSHIFT_POSTEFFECTS_COLORCONTROL_CURVE_BLUE { COLOR 0.0 0.0 0.9; }
		}
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_EXPOSURE
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_EXPOSURE_OVERRIDE { }
			BOOL REDSHIFT_POSTEFFECTS_EXPOSURE_ENABLED { }
		}

		GROUP REDSHIFT_POSTEFFECTS_GROUP_EXPOSURE_FILM_SETTINGS
		{
			DEFAULT 1;
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_FILM_SPEED { MIN 10.0; STEP 0.1; CUSTOMGUI REALSLIDER; MAXSLIDER 3200.0; }
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_SHUTTER_RATIO { MIN 0.002; STEP 0.1; CUSTOMGUI REALSLIDER; MAXSLIDER 8000.0; }
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_FSTOP { MIN 1.0; MAX 22.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			COLOR REDSHIFT_POSTEFFECTS_EXPOSURE_WHITEPOINT { }
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_VIGNETTING { MIN 0.0; STEP 0.01; CUSTOMGUI REALSLIDER; MAXSLIDER 25.0; }
		}

		GROUP REDSHIFT_POSTEFFECTS_GROUP_EXPOSURE_TONE_MAPPING
		{
			DEFAULT 1;
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_REINHARD_FACTOR { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
			BOOL REDSHIFT_POSTEFFECTS_EXPOSURE_REINHARD_ALLOW_DESATURATION { }
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_BLACK_CRUSH_THRESHOLD { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_BLACK_CRUSH_AMOUNT { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER;  }
			REAL REDSHIFT_POSTEFFECTS_EXPOSURE_BLACK_CRUSH_SATURATION { MIN 0.0; STEP 0.001; CUSTOMGUI REALSLIDER; MAXSLIDER 2.0; }
		}
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_BLOOM
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_BLOOM_OVERRIDE	{ }
			BOOL REDSHIFT_POSTEFFECTS_BLOOM_ENABLED		{ }
		}

		REAL REDSHIFT_POSTEFFECTS_BLOOM_THRESHOLD	{ MIN 0.0; MAX 50.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_BLOOM_SOFTNESS	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }

		GROUP REDSHIFT_POSTEFFECTS_GROUP_BLOOM_TINT
		{
			COLOR REDSHIFT_POSTEFFECTS_BLOOM_TINT_1 { }
			COLOR REDSHIFT_POSTEFFECTS_BLOOM_TINT_2 { }
			COLOR REDSHIFT_POSTEFFECTS_BLOOM_TINT_3 { }
			COLOR REDSHIFT_POSTEFFECTS_BLOOM_TINT_4 { }
			COLOR REDSHIFT_POSTEFFECTS_BLOOM_TINT_5 { }
		}
		REAL REDSHIFT_POSTEFFECTS_BLOOM_INTENSITY	{ MIN 0.0; MAX 4.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_FLARE
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_FLARE_OVERRIDE	{ }
			BOOL REDSHIFT_POSTEFFECTS_FLARE_ENABLED		{ }
		}

		REAL REDSHIFT_POSTEFFECTS_FLARE_THRESHOLD	{ MIN 0.0; MAX 50.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_FLARE_SOFTNESS	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_FLARE_CHROMATIC	{ MIN 0.0; MAX 10.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_FLARE_SIZE		{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_FLARE_HALO		{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		GROUP REDSHIFT_POSTEFFECTS_GROUP_FLARE_TINT
		{
			COLOR REDSHIFT_POSTEFFECTS_FLARE_TINT_1 { }
			COLOR REDSHIFT_POSTEFFECTS_FLARE_TINT_2 { }
			COLOR REDSHIFT_POSTEFFECTS_FLARE_TINT_3 { }
			COLOR REDSHIFT_POSTEFFECTS_FLARE_TINT_4 { }
			COLOR REDSHIFT_POSTEFFECTS_FLARE_TINT_5 { }
			COLOR REDSHIFT_POSTEFFECTS_FLARE_TINT_6 { }
		}
		REAL REDSHIFT_POSTEFFECTS_FLARE_INTENSITY { MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_STREAK
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_STREAK_OVERRIDE { }
			BOOL REDSHIFT_POSTEFFECTS_STREAK_ENABLED { }
		}

		REAL REDSHIFT_POSTEFFECTS_STREAK_THRESHOLD	{ MIN 0.0; MAX 50.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_STREAK_TAIL		{ MIN 0.25; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_STREAK_SOFTNESS	{ MIN 0.0; MAX 1.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
		LONG REDSHIFT_POSTEFFECTS_STREAK_NUMBER		{ MIN 1; MAX 8; CUSTOMGUI LONGSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_STREAK_ANGLE		{ UNIT DEGREE; MIN 0; MAX 359; STEP 1; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_STREAK_INTENSITY	{ MIN 0.0; MAX 4.0; STEP 0.001; CUSTOMGUI REALSLIDER; }
	}

	GROUP REDSHIFT_POSTEFFECTS_GROUP_BACKGROUND
	{
		GROUP
		{
			COLUMNS 2;
			BOOL REDSHIFT_POSTEFFECTS_BACKGROUND_OVERRIDE					{ }
			BOOL REDSHIFT_POSTEFFECTS_BACKGROUND_ENABLED					{ }
		}

		LONG REDSHIFT_POSTEFFECTS_BACKGROUND_TYPE
		{
			CYCLE
			{
				REDSHIFT_POSTEFFECTS_BACKGROUND_TYPE_RENDER;
				REDSHIFT_POSTEFFECTS_BACKGROUND_TYPE_COMPOSITE_PRE;
				REDSHIFT_POSTEFFECTS_BACKGROUND_TYPE_COMPOSITE_POST;
			}
		}
		BOOL REDSHIFT_POSTEFFECTS_BACKGROUND_AFFECTED_BY_BENT_RAYS			{ }
		COLORA REDSHIFT_POSTEFFECTS_BACKGROUND_COLOR						{ }
		RSFILE REDSHIFT_POSTEFFECTS_BACKGROUND_IMAGE					 	{ }
		BOOL REDSHIFT_POSTEFFECTS_BACKGROUND_IMAGE_ALPHA					{ }
		LONG REDSHIFT_POSTEFFECTS_BACKGROUND_FRAME
		{
			CUSTOMGUI QUICKTABRADIO;
			CYCLE
			{
				REDSHIFT_POSTEFFECTS_BACKGROUND_FRAME_STRETCH;
				REDSHIFT_POSTEFFECTS_BACKGROUND_FRAME_CROP;
				REDSHIFT_POSTEFFECTS_BACKGROUND_FRAME_FIT;
			}
		}
		REAL REDSHIFT_POSTEFFECTS_BACKGROUND_OFFSET_X	{ MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		REAL REDSHIFT_POSTEFFECTS_BACKGROUND_OFFSET_Y	{ MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }

		SEPARATOR										{ LINE; }
		REAL REDSHIFT_POSTEFFECTS_BACKGROUND_GAMMA		{ MIN 0; MAXSLIDER 2.2; STEP 0.1; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_BACKGROUND_EXPOSURE	{ MINSLIDER -10; MAXSLIDER 10; STEP 0.1; CUSTOMGUI REALSLIDER; }
		REAL REDSHIFT_POSTEFFECTS_BACKGROUND_HUE 		{ MIN 0; MAXSLIDER 360; CUSTOMGUI REALSLIDER; UNIT DEGREE; }
		REAL REDSHIFT_POSTEFFECTS_BACKGROUND_SATURATION { MIN -100; MAX 100; CUSTOMGUI REALSLIDER; UNIT PERCENT; }
		BOOL REDSHIFT_POSTEFFECTS_BACKGROUND_EXPOSURE_COMPENSATION	{ }
	}

}
