#ifndef DRSAOV_H__
#define DRSAOV_H__

enum
{
	REDSHIFT_AOV_ENABLED = 1000,
	REDSHIFT_AOV_NAME,
	REDSHIFT_AOV_MULTIPASS_BIT_DEPTH,
	REDSHIFT_AOV_TYPE,
	REDSHIFT_AOV_FILTER_TYPE,
	REDSHIFT_AOV_SCALE,
	REDSHIFT_AOV_APPLY_COLOR_PROCESSING,
	REDSHIFT_AOV_NORMALIZE,
	REDSHIFT_AOV_OUTPUT_RAW_VECTORS,
	REDSHIFT_AOV_NO_CLAMP,
	REDSHIFT_AOV_MAX_MOTION_PIXELS,
	REDSHIFT_AOV_IMAGE_OUTPUT_MIN,
	REDSHIFT_AOV_IMAGE_OUTPUT_MAX,
	REDSHIFT_AOV_MOTION_VECTOR_FILTERING,
	REDSHIFT_AOV_PUZZLE_MATTE_MODE,
	REDSHIFT_AOV_PUZZLE_MATTE_RED_ID,
	REDSHIFT_AOV_PUZZLE_MATTE_GREEN_ID,
	REDSHIFT_AOV_PUZZLE_MATTE_BLUE_ID,
	REDSHIFT_AOV_PUZZLE_MATTE_REFLECTION_REFRACTION,
	REDSHIFT_AOV_DEPTH_MODE,
	REDSHIFT_AOV_DEPTH_USE_CAMERA_NEAR_FAR,
	REDSHIFT_AOV_DEPTH_MIN,
	REDSHIFT_AOV_DEPTH_MAX,
	REDSHIFT_AOV_GRAPH,
	REDSHIFT_AOV_LIGHTGROUP_GLOBALAOV,
	REDSHIFT_AOV_LIGHTGROUP_ALL,
	REDSHIFT_AOV_LIGHTGROUP_NAMES,
	REDSHIFT_AOV_DENOISE_ENABLED,
	REDSHIFT_AOV_CRYPTOMATTE_TYPE,
	REDSHIFT_AOV_CRYPTOMATTE_DEPTH,
	REDSHIFT_AOV_CRYPTOMATTE_USER_ATTRIBUTE,
	REDSHIFT_AOV_SECONDARY_RAY_VISIBILITY,
	REDSHIFT_AOV_ENVIRONMENT_RAYS_TO_BLACK,
	REDSHIFT_AOV_EFFECTIVE_NAME,				// Read-Only
	REDSHIFT_AOV_AO_NUM_SAMPLES,
	REDSHIFT_AOV_AO_BRIGHT,
	REDSHIFT_AOV_AO_DARK,
	REDSHIFT_AOV_AO_SPREAD,
	REDSHIFT_AOV_AO_FALLOFF,
	REDSHIFT_AOV_AO_MAX_DISTANCE,

	REDSHIFT_AOV_MULTIPASS_ENABLED = 5000,
	REDSHIFT_AOV_FILE_ENABLED,

	REDSHIFT_AOV_FILE_PATH = 6000,
	REDSHIFT_AOV_FILE_DATA_TYPE,
	REDSHIFT_AOV_FILE_FORMAT,
	REDSHIFT_AOV_FILE_BIT_DEPTH,
	REDSHIFT_AOV_FILE_COMPRESSION,
	REDSHIFT_AOV_FILE_STORAGE,
	REDSHIFT_AOV_FILE_JPEG_QUALITY,
	REDSHIFT_AOV_FILE_EXR_DWA_COMPRESSION,
	REDSHIFT_AOV_FILE_EFFECTIVE_PATH,			// Read-Only

	// Enums
	REDSHIFT_AOV_TYPE_WORLD_POSITION = 0,
	REDSHIFT_AOV_TYPE_DEPTH,
	REDSHIFT_AOV_TYPE_PUZZLE_MATTE,
	REDSHIFT_AOV_TYPE_MOTION_VECTORS,
	REDSHIFT_AOV_TYPE_OBJECT_ID,
	REDSHIFT_AOV_TYPE_DIFFUSE_LIGHTING,
	REDSHIFT_AOV_TYPE_DIFFUSE_LIGHTING_RAW,
	REDSHIFT_AOV_TYPE_DIFFUSE_FILTER,
	REDSHIFT_AOV_TYPE_SPECULAR_LIGHTING,
	REDSHIFT_AOV_TYPE_SUB_SURFACE_SCATTER,
	REDSHIFT_AOV_TYPE_SUB_SURFACE_SCATTER_RAW,
	REDSHIFT_AOV_TYPE_REFLECTIONS,
	REDSHIFT_AOV_TYPE_REFLECTIONS_RAW,
	REDSHIFT_AOV_TYPE_REFLECTIONS_FILTER,
	REDSHIFT_AOV_TYPE_REFRACTIONS,
	REDSHIFT_AOV_TYPE_REFRACTIONS_RAW,
	REDSHIFT_AOV_TYPE_REFRACTIONS_FILTER,
	REDSHIFT_AOV_TYPE_EMISSION,
	REDSHIFT_AOV_TYPE_GLOBAL_ILLUMINATION,
	REDSHIFT_AOV_TYPE_GLOBAL_ILLUMINATION_RAW,
	REDSHIFT_AOV_TYPE_CAUSTICS,
	REDSHIFT_AOV_TYPE_CAUSTICS_RAW,
	REDSHIFT_AOV_TYPE_AMBIENT_OCCLUSION_LEGACY,
	REDSHIFT_AOV_TYPE_SHADOWS,
	REDSHIFT_AOV_TYPE_NORMALS,
	REDSHIFT_AOV_TYPE_BUMP_NORMALS,
	REDSHIFT_AOV_TYPE_MATTE,
	REDSHIFT_AOV_TYPE_VOLUME_LIGHTING,
	REDSHIFT_AOV_TYPE_VOLUME_FOG_TINT,
	REDSHIFT_AOV_TYPE_VOLUME_FOG_EMISSION,
	REDSHIFT_AOV_TYPE_TRANSLUCENCY_LIGHTING_RAW,
	REDSHIFT_AOV_TYPE_TRANSLUCENCY_FILTER,
	REDSHIFT_AOV_TYPE_TRANSLUCENCY_GI_RAW,
	REDSHIFT_AOV_TYPE_TOTAL_DIFFUSE_LIGHTING_RAW,
	REDSHIFT_AOV_TYPE_TOTAL_TRANSLUCENCY_LIGHTING_RAW,
	REDSHIFT_AOV_TYPE_OBJECT_SPACE_POSITIONS,
	REDSHIFT_AOV_TYPE_OBJECT_SPACE_BUMP_NORMALS,
	REDSHIFT_AOV_TYPE_BACKGROUND,
	REDSHIFT_AOV_TYPE_MAIN,
	REDSHIFT_AOV_TYPE_CUSTOM,
	REDSHIFT_AOV_TYPE_IDS_AND_COVERAGE,
	REDSHIFT_AOV_TYPE_BEAUTY,
	REDSHIFT_AOV_TYPE_CRYPTOMATTE,
	REDSHIFT_AOV_TYPE_VOLUME_DEPTH,
	REDSHIFT_AOV_TYPE_AMBIENT_OCCLUSION,
	REDSHIFT_AOV_TYPE_MAX,
	REDSHIFT_AOV_TYPE_NONE = 65535,

	REDSHIFT_AOV_FILTER_TYPE_FULL = 0,
	REDSHIFT_AOV_FILTER_TYPE_MIN_DEPTH,
	REDSHIFT_AOV_FILTER_TYPE_MAX_DEPTH,
	REDSHIFT_AOV_FILTER_TYPE_CENTER_SAMPLE,
	REDSHIFT_AOV_FILTER_TYPE_MAX,

	REDSHIFT_AOV_PUZZLE_MATTE_MODE_MATERIAL_ID = 0,
	REDSHIFT_AOV_PUZZLE_MATTE_MODE_OBJECT_ID,

	REDSHIFT_AOV_DEPTH_MODE_Z = 0,
	REDSHIFT_AOV_DEPTH_MODE_Z_NORMALIZED,
	REDSHIFT_AOV_DEPTH_MODE_Z_NORMALIZED_INVERTED,
	REDSHIFT_AOV_DEPTH_MODE_MAX,

	REDSHIFT_AOV_MULTIPASS_BIT_DEPTH_8 = 0,
	REDSHIFT_AOV_MULTIPASS_BIT_DEPTH_16,
	REDSHIFT_AOV_MULTIPASS_BIT_DEPTH_32,

	REDSHIFT_AOV_FILE_BIT_DEPTH_INT8 = 0,
	REDSHIFT_AOV_FILE_BIT_DEPTH_INT16,
	REDSHIFT_AOV_FILE_BIT_DEPTH_INT32,
	REDSHIFT_AOV_FILE_BIT_DEPTH_FLOAT16,
	REDSHIFT_AOV_FILE_BIT_DEPTH_FLOAT32,
	REDSHIFT_AOV_FILE_BIT_DEPTH_MAX,

	REDSHIFT_AOV_FILE_DATATYPE_RGB = 0,
	REDSHIFT_AOV_FILE_DATATYPE_RGBA,
	REDSHIFT_AOV_FILE_DATATYPE_POINT,
	REDSHIFT_AOV_FILE_DATATYPE_SCALAR,
	REDSHIFT_AOV_FILE_DATATYPE_MAX,

	REDSHIFT_AOV_FILE_FORMAT_OPENEXR = 0,
	REDSHIFT_AOV_FILE_FORMAT_TIFF,
	REDSHIFT_AOV_FILE_FORMAT_PNG,
	REDSHIFT_AOV_FILE_FORMAT_TGA,
	REDSHIFT_AOV_FILE_FORMAT_JPEG,
	REDSHIFT_AOV_FILE_FORMAT_MAX,

	// Keep in sync with vprsrenderer
	REDSHIFT_AOV_FILE_COMPRESSION_NONE = 0,
	REDSHIFT_AOV_FILE_COMPRESSION_DEFAULT,
	REDSHIFT_AOV_FILE_COMPRESSION_TIFF_LZW = 100,
	REDSHIFT_AOV_FILE_COMPRESSION_TIFF_CCITTRLE,
	REDSHIFT_AOV_FILE_COMPRESSION_TIFF_ZIP,
	REDSHIFT_AOV_FILE_COMPRESSION_TIFF_PACKBITS,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_RLE = 200,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_ZIP,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_ZIPS,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_PIZ,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_PXR24,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_B44,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_DWAA,
	REDSHIFT_AOV_FILE_COMPRESSION_EXR_DWAB,

	REDSHIFT_AOV_FILE_STORAGE_SCANLINE = 0,
	REDSHIFT_AOV_FILE_STORAGE_TILED,

	REDSHIFT_AOV_LIGHTGROUP_GLOBALAOV_NONE = 0,
	REDSHIFT_AOV_LIGHTGROUP_GLOBALAOV_ALL,
	REDSHIFT_AOV_LIGHTGROUP_GLOBALAOV_REMAINDER,

	// Order Matches RSBlockSinkCryptomatteType
	REDSHIFT_AOV_CRYPTOMATTE_TYPE_MESH_ID = 0,
	REDSHIFT_AOV_CRYPTOMATTE_TYPE_MATERIAL_ID,
	REDSHIFT_AOV_CRYPTOMATTE_TYPE_OBJECT_ID,
	REDSHIFT_AOV_CRYPTOMATTE_TYPE_USER_ATTRIBUTE,
	REDSHIFT_AOV_CRYPTOMATTE_TYPE_MAX,

	REDSHIFT_AOV_SECONDARY_RAY_VISIBILITY_DISABLED = 0,
	REDSHIFT_AOV_SECONDARY_RAY_VISIBILITY_ENABLED_REFRACTION_AND_TRANSPARENCY,
	REDSHIFT_AOV_SECONDARY_RAY_VISIBILITY_ENABLED_REFLECTION,
	REDSHIFT_AOV_SECONDARY_RAY_VISIBILITY_ENABLED_ALL,
	REDSHIFT_AOV_SECONDARY_RAY_VISIBILITY_MAX,
};

#endif // DRSAOV_H__
